##############################################################################
# ThanCad 0.9.2 "Tartu": n-dimensional CAD with raster support for engineers
#
# Copyright (C) 2001-2026 Thanasis Stamos, January 20, 2026
# Athens, Greece, Europe
# URL: http://thancad.sourceforge.net
# e-mail: cyberthanasis@gmx.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (www.gnu.org/licenses/gpl.html).
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##############################################################################
"""\
ThanCad 0.9.2 "Tartu": n-dimensional CAD with raster support for engineers
This module defines ThanCad fonts made by straight lines. The lines
have thickness and the characters resemble the arial font.
"""

from math import cos, sin, pi
from .thanfont import ThanFontLine



class ThanFontPolygon(ThanFontLine):
    "Font class made by filled polygons."


    def __init__(self, name, dilines):
        "Initialisation."

        ThanFontLine.__init__(self, name, dilines)


    def thanTkPaint(self, dc, xz, yz, h, a, theta):
        "Draws text using ThanCad's polygon fonts."

        assert h >= 1, "Text height must be > 1 pixel"

        hf = 100.0
        by = h / hf
        bx = by*cos(theta)
        by = by*sin(theta)
        hx2 = hf * bx
        hy2 = hf * by
        tfont = self.thanDilines
        col = self.thanColor
        fill = self.thanFill

#-------Transform the coordinates

        for c in a:                               # Loop of all the characters in text
            k = ord(c)
            if type(tfont[k]) is int: k = tfont[k]
            if k < 0 or k > 255:
                print "Character with code:" + str(k)
                return

            for pl in tfont[k]:                   # Loop of all polylines of a char
                plr = [	(xz+xx*bx-yy*by, yz-(xx*by+yy*bx)) for (xx, yy) in pl ]
                dc.create_polygon(plr, outline=col, fill=fill)

            xz += hx2     # Advance character position
            yz -= hy2


def makeArialPolygons():
    "Makes the polygons that define each character in thanFontPrime1."

    dilines = \
{
193 : [
         [ 67.0 , 30.0 , 25.0 , 30.0 , 29.0 , 41.0 , 63.0 , 41.0 ] ,
         [ 47.0 , 85.0 , 67.0 , 30.0 , 78.0 , 0.0 , 92.0 , 0.0 , 54.0 , 100.0 , 38.0 , 100.0 , 0.0 , 0.0 , 14.0 , 0.0 , 25.0 , 30.0 , 45.0 , 85.0 ]
      ],
194 : [
         [ 23.0 , 58.0 , 50.0 , 58.0 , 57.0 , 59.0 , 60.0 , 60.0 , 62.0 , 61.0 , 63.0 , 62.0 , 65.0 , 64.0 , 66.0 , 65.0 , 67.0 , 67.0 , 68.0 , 72.0 , 68.0 , 73.0 , 68.0 , 74.0 , 68.0 , 75.0 , 67.0 , 79.0 , 66.0 , 81.0 , 64.0 , 84.0 , 61.0 , 86.0 , 58.0 , 87.0 , 53.0 , 88.0 , 23.0 , 88.0 , 23.0 , 100.0 , 51.0 , 100.0 , 58.0 , 99.0 , 63.0 , 98.0 , 66.0 , 97.0 , 69.0 , 95.0 , 71.0 , 94.0 , 73.0 , 92.0 , 75.0 , 90.0 , 78.0 , 86.0 , 79.0 , 84.0 , 80.0 , 81.0 , 81.0 , 76.0 , 81.0 , 73.0 , 80.0 , 69.0 , 79.0 , 66.0 , 78.0 , 63.0 , 76.0 , 60.0 , 74.0 , 58.0 , 72.0 , 56.0 , 68.0 , 53.0 , 70.0 , 52.0 , 74.0 , 50.0 , 77.0 , 48.0 , 79.0 , 46.0 , 81.0 , 44.0 , 83.0 , 41.0 , 84.0 , 38.0 , 85.0 , 35.0 , 86.0 , 31.0 , 86.0 , 29.0 , 86.0 , 26.0 , 85.0 , 23.0 , 84.0 , 20.0 , 83.0 , 17.0 , 81.0 , 13.0 , 79.0 , 10.0 , 77.0 , 8.0 , 75.0 , 6.0 , 73.0 , 5.0 , 69.0 , 3.0 , 66.0 , 2.0 , 63.0 , 1.0 , 57.0 , 0.0 , 55.0 , 0.0 , 23.0 , 0.0 , 23.0 , 12.0 , 54.0 , 12.0 , 57.0 , 12.0 , 60.0 , 13.0 , 63.0 , 14.0 , 67.0 , 16.0 , 69.0 , 19.0 , 71.0 , 22.0 , 72.0 , 24.0 , 72.0 , 27.0 , 72.0 , 30.0 , 71.0 , 35.0 , 70.0 , 37.0 , 68.0 , 40.0 , 66.0 , 42.0 , 63.0 , 44.0 , 59.0 , 45.0 , 53.0 , 46.0 , 23.0 , 46.0 ] ,
         [ 23.0 , 0.0 , 10.0 , 0.0 , 10.0 , 100.0 , 23.0 , 100.0 ]
      ],
195 : [
         [ 74.0 , 100.0 , 11.0 , 100.0 , 11.0 , -0.0 , 24.0 , 0.0 , 24.0 , 87.0 , 74.0 , 87.0 ]
      ],
196 : [
         [ 78.0 , 0.0 , 14.0 , 0.0 , 18.0 , 11.0 , 74.0 , 11.0 ] ,
         [ 47.0 , 85.0 , 74.0 , 11.0 , 78.0 , 0.0 , 92.0 , 0.0 , 54.0 , 100.0 , 38.0 , 100.0 , 0.0 , 0.0 , 14.0 , 0.0 , 18.0 , 11.0 , 45.0 , 85.0 ]
      ],
197 : [
         [ 24.0 , 44.0 , 24.0 , 13.0 , 74.0 , 13.0 , 74.0 , 0.0 , 11.0 , 0.0 , 11.0 , 100.0 , 74.0 , 100.0 , 74.0 , 87.0 , 24.0 , 87.0 , 24.0 , 56.0 , 74.0 , 56.0 , 74.0 , 44.0 ]
      ],
198 : [
         [ 3.0 , 12.0 , 65.0 , 88.0 , 3.0 , 88.0 , 3.0 , 100.0 , 80.0 , 100.0 , 80.0 , 88.0 , 18.0 , 12.0 , 80.0 , 12.0 , 80.0 , -0.0 , 3.0 , 0.0 ]
      ],
199 : [
         [ 89.0 , 100.0 , 76.0 , 100.0 , 76.0 , -0.0 , 89.0 , 0.0 , 89.0 , 100.0 ] ,
         [ 24.0 , 100.0 , 11.0 , 100.0 , 11.0 , -0.0 , 24.0 , 0.0 , 24.0 , 100.0 ] ,
         [ 24.0 , 43.5 , 76.0 , 43.5 , 76.0 , 56.5 , 24.0 , 56.5 ]
      ],
200 : [
         [ 52.0 , 100.0 , 60.0 , 100.0 , 66.0 , 99.0 , 69.0 , 98.0 , 74.0 , 96.0 , 78.0 , 94.0 , 81.0 , 92.0 , 85.0 , 89.0 , 89.0 , 85.0 , 92.0 , 81.0 , 94.0 , 77.0 , 96.0 , 73.0 , 98.0 , 67.0 , 99.0 , 63.0 , 100.0 , 54.0 , 100.0 , 42.0 , 99.0 , 36.0 , 97.0 , 30.0 , 95.0 , 25.0 , 93.0 , 21.0 , 88.0 , 14.0 , 85.0 , 11.0 , 81.0 , 8.0 , 78.0 , 6.0 , 74.0 , 4.0 , 72.0 , 3.0 , 69.0 , 2.0 , 65.0 , 1.0 , 59.0 , 0.0 , 54.0 , 0.0 , 52.0 , 0.0 , 52.0 , 10.0 , 54.0 , 10.0 , 60.0 , 11.0 , 64.0 , 12.0 , 69.0 , 14.0 , 72.0 , 16.0 , 75.0 , 18.0 , 78.0 , 21.0 , 80.0 , 23.0 , 84.0 , 30.0 , 85.0 , 33.0 , 86.0 , 36.0 , 87.0 , 45.0 , 87.0 , 55.0 , 86.0 , 62.0 , 85.0 , 67.0 , 83.0 , 72.0 , 80.0 , 77.0 , 76.0 , 81.0 , 72.0 , 84.0 , 68.0 , 86.0 , 66.0 , 87.0 , 62.0 , 88.0 , 59.0 , 89.0 , 55.0 , 89.0 , 52.0 , 89.0 ] ,
         [ 52.0 , 100.0 , 44.0 , 100.0 , 38.0 , 99.0 , 35.0 , 98.0 , 30.0 , 96.0 , 26.0 , 94.0 , 23.0 , 92.0 , 19.0 , 89.0 , 15.0 , 85.0 , 12.0 , 81.0 , 10.0 , 77.0 , 8.0 , 73.0 , 6.0 , 67.0 , 5.0 , 63.0 , 4.0 , 54.0 , 4.0 , 42.0 , 5.0 , 36.0 , 7.0 , 30.0 , 9.0 , 25.0 , 11.0 , 21.0 , 16.0 , 14.0 , 19.0 , 11.0 , 23.0 , 8.0 , 26.0 , 6.0 , 30.0 , 4.0 , 32.0 , 3.0 , 35.0 , 2.0 , 39.0 , 1.0 , 45.0 , 0.0 , 50.0 , 0.0 , 52.0 , 0.0 , 52.0 , 10.0 , 50.0 , 10.0 , 44.0 , 11.0 , 40.0 , 12.0 , 35.0 , 14.0 , 32.0 , 16.0 , 29.0 , 18.0 , 26.0 , 21.0 , 24.0 , 23.0 , 20.0 , 30.0 , 19.0 , 33.0 , 18.0 , 36.0 , 17.0 , 45.0 , 17.0 , 55.0 , 18.0 , 62.0 , 19.0 , 67.0 , 21.0 , 72.0 , 24.0 , 77.0 , 28.0 , 81.0 , 32.0 , 84.0 , 36.0 , 86.0 , 38.0 , 87.0 , 42.0 , 88.0 , 45.0 , 89.0 , 49.0 , 89.0 , 52.0 , 89.0 ] ,
         [ 32.0 , 44.0 , 71.0 , 44.0 , 71.0 , 56.0 , 32.0 , 56.0 ]
      ],
201 : [
         [ 24.0 , 100.0 , 11.0 , 100.0 , 11.0 , -0.0 , 24.0 , 0.0 , 24.0 , 100.0 ]
      ],
202 : [
         [ 40.695 , 49.695 , 76.914 , 0.0 , 93.0 , 0.0 , 50.0 , 59.0 , 91.0 , 100.0 , 73.0 , 100.0 , 24.0 , 51.0 , 24.0 , 100.0 , 11.0 , 100.0 , 11.0 , -0.0 , 24.0 , 0.0 , 24.0 , 33.0 ]
      ],
203 : [
         [ 47.0 , 85.0 , 67.0 , 30.0 , 78.0 , 0.0 , 92.0 , 0.0 , 54.0 , 100.0 , 38.0 , 100.0 , 0.0 , 0.0 , 14.0 , 0.0 , 25.0 , 30.0 , 45.0 , 85.0 ]
      ],
204 : [
         [ 17.0 , 100.0 , 17.0 , 100.0 ] ,
         [ 53.0 , 15.0 , 24.0 , 100.0 , 4.0 , 100.0 , 4.0 , 0.0 , 17.0 , 0.0 , 17.0 , 85.0 , 46.0 , 0.0 , 58.0 , 0.0 , 87.0 , 85.0 , 87.0 , 0.0 , 100.0 , 0.0 , 100.0 , 100.0 , 80.0 , 100.0 ]
      ],
205 : [
         [ 77.0 , 21.0 , 24.0 , 100.0 , 11.0 , 100.0 , 11.0 , -0.0 , 24.0 , 0.0 , 24.0 , 78.0 , 76.0 , 0.0 , 90.0 , 0.0 , 90.0 , 100.0 , 77.0 , 100.0 ]
      ],
206 : [
         [ 16.0 , 44.0 , 16.0 , 56.0 , 75.0 , 56.0 , 75.0 , 44.0 ] ,
         [ 8.0 , 100.0 , 8.0 , 88.0 , 83.0 , 88.0 , 83.0 , 100.0 ] ,
         [ 8.0 , 12.0 , 8.0 , 0.0 , 83.0 , 0.0 , 83.0 , 12.0 ]
      ],
207 : [
         [ 53.0 , 0.0 , 48.0 , 0.0 , 42.0 , 1.0 , 38.0 , 2.0 , 35.0 , 3.0 , 33.0 , 4.0 , 29.0 , 6.0 , 26.0 , 8.0 , 22.0 , 11.0 , 19.0 , 14.0 , 14.0 , 21.0 , 12.0 , 25.0 , 10.0 , 30.0 , 8.0 , 36.0 , 7.0 , 42.0 , 7.0 , 54.0 , 8.0 , 63.0 , 9.0 , 67.0 , 11.0 , 73.0 , 13.0 , 77.0 , 15.0 , 81.0 , 18.0 , 85.0 , 22.0 , 89.0 , 26.0 , 92.0 , 29.0 , 94.0 , 33.0 , 96.0 , 38.0 , 98.0 , 41.0 , 99.0 , 47.0 , 100.0 , 58.0 , 100.0 , 64.0 , 99.0 , 68.0 , 98.0 , 73.0 , 96.0 , 77.0 , 94.0 , 82.0 , 91.0 , 84.0 , 89.0 , 86.0 , 87.0 , 88.0 , 85.0 , 91.0 , 81.0 , 93.0 , 78.0 , 95.0 , 74.0 , 96.0 , 71.0 , 97.0 , 68.0 , 98.0 , 65.0 , 99.0 , 59.0 , 99.0 , 42.0 , 97.0 , 32.0 , 95.0 , 26.0 , 93.0 , 22.0 , 91.0 , 19.0 , 89.0 , 16.0 , 84.0 , 11.0 , 82.0 , 9.0 , 79.0 , 7.0 , 75.0 , 5.0 , 71.0 , 3.0 , 68.0 , 2.0 , 64.0 , 1.0 , 58.0 , 0.0 ] ,
         [ 57.0 , 89.0 , 58.0 , 89.0 , 61.0 , 88.0 , 65.0 , 87.0 , 67.0 , 86.0 , 71.0 , 84.0 , 75.0 , 81.0 , 79.0 , 77.0 , 82.0 , 72.0 , 84.0 , 67.0 , 85.0 , 62.0 , 86.0 , 55.0 , 86.0 , 45.0 , 85.0 , 36.0 , 84.0 , 33.0 , 83.0 , 30.0 , 79.0 , 23.0 , 77.0 , 21.0 , 74.0 , 18.0 , 71.0 , 16.0 , 68.0 , 14.0 , 63.0 , 12.0 , 59.0 , 11.0 , 53.0 , 10.0 , 47.0 , 11.0 , 43.0 , 12.0 , 38.0 , 14.0 , 35.0 , 16.0 , 32.0 , 18.0 , 29.0 , 21.0 , 27.0 , 23.0 , 23.0 , 30.0 , 22.0 , 33.0 , 21.0 , 36.0 , 20.0 , 45.0 , 20.0 , 55.0 , 21.0 , 62.0 , 22.0 , 67.0 , 24.0 , 72.0 , 27.0 , 77.0 , 31.0 , 81.0 , 35.0 , 84.0 , 39.0 , 86.0 , 41.0 , 87.0 , 45.0 , 88.0 , 48.0 , 89.0 , 52.0 , 89.0 ]
      ],
208 : [
         [ 89.0 , 100.0 , 11.0 , 100.0 , 11.0 , -0.0 , 24.0 , 0.0 , 24.0 , 87.0 , 76.0 , 87.0 , 76.0 , 0.0 , 89.0 , 0.0 ] ,
         [ 11.0 , 100.0 , 11.0 , 87.0 ]
      ],
209 : [
         [ 24.0 , 40.0 , 60.6 , 40.0 , 67.537 , 41.734 , 72.046 , 43.988 , 80.351 , 50.632 , 82.628 , 55.186 , 85.406 , 60.743 , 86.996 , 68.691 , 87.008 , 72.269 , 85.587 , 79.347 , 83.707 , 84.989 , 80.106 , 89.99 , 78.591 , 91.794 , 76.315 , 94.07 , 71.576 , 97.278 , 66.008 , 100.0 , 24.0 , 100.0 , 24.0 , 87.0 , 63.0 , 87.0 , 65.046 , 86.0 , 68.0 , 84.0 , 69.0 , 83.0 , 69.84 , 82.0 , 72.0 , 79.0 , 73.0 , 76.0 , 74.003 , 71.0 , 74.0 , 70.0 , 73.0 , 65.0 , 71.0 , 61.0 , 70.0 , 59.0 , 65.0 , 55.0 , 63.0 , 54.0 , 59.0 , 53.0 , 24.0 , 53.0 ] ,
         [ 24.0 , 100.0 , 11.0 , 100.0 , 11.0 , -0.0 , 24.0 , 0.0 , 24.0 , 100.0 ]
      ],
210 : [
         [ 8.0 , 88.0 , 42.073 , 52.086 , 8.0 , 12.0 , 8.0 , 0.0 , 83.0 , 0.0 , 83.0 , 12.0 , 25.0 , 12.0 , 58.552 , 51.473 , 24.0 , 88.0 , 83.0 , 88.0 , 83.0 , 100.0 , 8.0 , 100.0 ]
      ],
211 : [
         [ 49.0 , 100.0 , 36.0 , 100.0 ] ,
         [ 49.0 , 87.0 , 82.0 , 87.0 , 82.0 , 100.0 , 3.0 , 100.0 , 3.0 , 87.0 , 36.0 , 87.0 , 36.0 , 0.0 , 49.0 , 0.0 ]
      ],
212 : [
         [ 54.0 , 42.0 , 94.0 , 100.0 , 79.0 , 100.0 , 47.0 , 52.0 , 15.0 , 100.0 , 0.0 , 100.0 , 40.0 , 42.0 , 40.0 , 0.0 , 54.0 , 0.0 ]
      ],
213 : [
         [ 44.0 , 90.0 , 41.924 , 90.0 , 33.857 , 88.655 , 29.013 , 87.041 , 26.186 , 85.628 , 24.186 , 84.628 , 20.299 , 82.684 , 16.808 , 79.192 , 13.808 , 76.192 , 11.316 , 73.701 , 9.734 , 70.538 , 6.934 , 66.338 , 5.262 , 59.649 , 3.98 , 51.954 , 4.061 , 47.639 , 5.302 , 41.193 , 6.934 , 34.662 , 9.734 , 30.462 , 11.316 , 27.299 , 13.808 , 24.808 , 14.808 , 23.808 , 16.808 , 21.808 , 20.299 , 18.316 , 24.186 , 16.372 , 29.013 , 13.959 , 33.657 , 12.411 , 40.713 , 11.0 , 44.0 , 11.0 , 44.0 , 24.0 , 42.0 , 24.0 , 37.0 , 25.0 , 34.0 , 26.0 , 30.0 , 28.0 , 28.0 , 29.0 , 26.0 , 31.0 , 24.0 , 33.0 , 23.0 , 34.0 , 22.0 , 35.0 , 21.0 , 37.0 , 19.0 , 40.0 , 18.0 , 44.0 , 17.038 , 49.0 , 17.0 , 51.0 , 18.0 , 57.0 , 19.0 , 61.0 , 21.0 , 64.0 , 22.0 , 66.0 , 23.0 , 67.0 , 26.0 , 70.0 , 28.0 , 72.0 , 30.0 , 73.0 , 32.0 , 74.0 , 34.0 , 75.0 , 37.0 , 76.0 , 43.0 , 77.0 , 44.0 , 77.0 ] ,
         [ 58.0 , 0.0 , 58.0 , 100.0 , 44.0 , 100.0 , 44.0 , -0.0 ] ,
         [ 58.0 , 77.0 , 59.0 , 77.0 , 65.0 , 76.0 , 68.0 , 75.0 , 70.0 , 74.0 , 72.0 , 73.0 , 74.0 , 72.0 , 76.0 , 70.0 , 79.0 , 67.0 , 80.0 , 66.0 , 81.0 , 64.0 , 83.0 , 61.0 , 84.0 , 57.0 , 85.0 , 51.0 , 84.962 , 49.0 , 84.0 , 44.0 , 83.0 , 40.0 , 81.0 , 37.0 , 80.0 , 35.0 , 79.0 , 34.0 , 78.0 , 33.0 , 76.0 , 31.0 , 74.0 , 29.0 , 72.0 , 28.0 , 68.0 , 26.0 , 65.0 , 25.0 , 60.0 , 24.0 , 58.0 , 24.0 , 58.0 , 11.0 , 61.287 , 11.0 , 68.343 , 12.411 , 72.987 , 13.959 , 77.814 , 16.372 , 81.701 , 18.316 , 85.192 , 21.808 , 87.192 , 23.808 , 88.192 , 24.808 , 90.684 , 27.299 , 92.266 , 30.462 , 95.066 , 34.662 , 96.698 , 41.193 , 97.939 , 47.639 , 98.02 , 51.954 , 96.738 , 59.649 , 95.066 , 66.338 , 92.266 , 70.538 , 90.684 , 73.701 , 88.192 , 76.192 , 85.192 , 79.192 , 81.701 , 82.684 , 77.814 , 84.628 , 75.814 , 85.628 , 72.987 , 87.041 , 68.143 , 88.655 , 60.076 , 90.0 , 58.0 , 90.0 ]
      ],
214 : [
         [ 6.0 , 100.0 , 21.0 , 100.0 , 47.63 , 63.014 , 75.0 , 100.0 , 90.0 , 100.0 , 55.262 , 52.414 , 93.0 , 0.0 , 78.0 , 0.0 , 47.721 , 42.083 , 17.0 , 0.0 , 1.0 , 0.0 , 40.04 , 52.757 , 6.048 , 100.0 ]
      ],
215 : [
         [ 57.0 , 29.0 , 60.0 , 29.0 , 62.27 , 29.0 , 69.339 , 30.394 , 74.048 , 31.974 , 76.737 , 33.333 , 79.501 , 34.655 , 84.329 , 37.944 , 86.192 , 39.808 , 87.192 , 40.808 , 89.192 , 42.808 , 91.103 , 44.718 , 94.092 , 49.202 , 95.759 , 52.17 , 97.131 , 55.266 , 98.672 , 59.858 , 100.0 , 68.0 , 100.0 , 100.0 , 87.0 , 100.0 , 87.0 , 70.0 , 87.0 , 69.0 , 86.014 , 63.0 , 85.0 , 59.978 , 84.123 , 58.0 , 83.0 , 56.0 , 81.0 , 53.0 , 80.0 , 52.0 , 78.0 , 50.0 , 77.0 , 49.0 , 76.0 , 48.0 , 73.0 , 45.956 , 71.0 , 45.0 , 69.022 , 44.0 , 66.0 , 42.986 , 61.0 , 42.0 , 60.0 , 42.0 , 57.0 , 42.0 , 57.0 , 100.0 , 44.0 , 100.0 , 44.0 , 42.0 , 41.0 , 42.0 , 40.0 , 42.0 , 35.0 , 42.986 , 31.978 , 44.0 , 30.0 , 45.0 , 28.0 , 45.956 , 25.0 , 48.0 , 24.0 , 49.0 , 23.0 , 50.0 , 21.0 , 52.0 , 20.0 , 53.0 , 18.0 , 56.0 , 16.877 , 58.0 , 16.0 , 59.978 , 14.986 , 63.0 , 14.0 , 69.0 , 14.0 , 70.0 , 14.0 , 100.0 , 1.0 , 100.0 , 1.0 , 68.0 , 2.328 , 59.858 , 3.869 , 55.266 , 5.241 , 52.17 , 6.908 , 49.202 , 9.897 , 44.718 , 11.808 , 42.808 , 13.808 , 40.808 , 14.808 , 39.808 , 16.671 , 37.944 , 21.499 , 34.655 , 24.263 , 33.333 , 26.952 , 31.974 , 31.661 , 30.394 , 38.73 , 29.0 , 41.0 , 29.0 , 44.0 , 29.0 , 44.0 , 0.0 , 57.0 , 0.0 ]
      ],
216 : [
         [ 23.425 , 35.0 , 23.371 , 35.081 , 22.73 , 36.332 , 21.756 , 38.321 , 21.27 , 39.293 , 20.45 , 42.323 , 19.707 , 44.753 , 19.0 , 48.993 , 19.0 , 52.0 , 19.0 , 53.335 , 19.842 , 60.912 , 20.478 , 63.528 , 22.252 , 68.425 , 23.498 , 71.114 , 24.8 , 73.066 , 27.6 , 76.8 , 30.088 , 80.118 , 31.75 , 81.779 , 34.987 , 84.054 , 37.264 , 85.715 , 38.94 , 86.554 , 41.848 , 87.141 , 49.637 , 87.998 , 50.993 , 87.993 , 53.421 , 87.999 , 62.216 , 87.128 , 65.06 , 86.554 , 66.736 , 85.715 , 69.013 , 84.054 , 72.25 , 81.779 , 73.912 , 80.118 , 76.4 , 76.8 , 79.2 , 73.066 , 80.502 , 71.114 , 81.748 , 68.425 , 83.522 , 63.528 , 84.158 , 60.912 , 85.0 , 53.335 , 85.0 , 52.0 , 85.0 , 48.993 , 84.293 , 44.753 , 83.55 , 42.323 , 82.73 , 39.293 , 82.244 , 38.321 , 81.27 , 36.332 , 80.629 , 35.081 , 80.575 , 35.0 , 79.0 , 30.0 , 77.0 , 27.0 , 75.0 , 24.0 , 72.0 , 20.0 , 70.0 , 18.0 , 68.0 , 16.0 , 65.0 , 14.0 , 62.0 , 12.0 , 58.0 , 11.0 , 58.0 , 0.0 , 97.0 , 0.0 , 97.0 , 12.0 , 76.0 , 12.0 , 77.0 , 13.0 , 79.797 , 15.0 , 80.911 , 16.0 , 81.961 , 17.0 , 83.0 , 18.049 , 84.0 , 19.119 , 85.0 , 20.0 , 87.0 , 22.754 , 87.904 , 24.0 , 89.0 , 26.0 , 90.997 , 29.0 , 92.0 , 30.957 , 93.0 , 33.0 , 94.0 , 35.0 , 95.083 , 39.0 , 96.0 , 42.0 , 97.0 , 48.0 , 97.0 , 52.0 , 97.0 , 54.0 , 96.0 , 63.0 , 95.028 , 67.0 , 92.853 , 73.0 , 91.0 , 77.0 , 89.0 , 80.0 , 86.0 , 84.0 , 83.0 , 88.0 , 80.0 , 91.0 , 76.0 , 93.811 , 73.0 , 96.0 , 69.0 , 98.0 , 64.0 , 99.01 , 54.0 , 100.0 , 51.0 , 99.993 , 49.0 , 100.0 , 40.0 , 99.01 , 35.0 , 98.0 , 31.0 , 96.0 , 28.0 , 93.811 , 24.0 , 91.0 , 21.0 , 88.0 , 18.0 , 84.0 , 15.0 , 80.0 , 13.0 , 77.0 , 11.147 , 73.0 , 8.972 , 67.0 , 8.0 , 63.0 , 7.0 , 54.0 , 7.0 , 52.0 , 7.0 , 48.0 , 8.0 , 42.0 , 8.917 , 39.0 , 10.0 , 35.0 , 11.0 , 33.0 , 12.0 , 30.957 , 13.003 , 29.0 , 15.0 , 26.0 , 16.096 , 24.0 , 17.0 , 22.754 , 19.0 , 20.0 , 20.0 , 19.119 , 21.0 , 18.049 , 22.039 , 17.0 , 23.089 , 16.0 , 24.203 , 15.0 , 27.0 , 13.0 , 28.0 , 12.0 , 7.0 , 12.0 , 7.0 , 0.0 , 45.0 , 0.0 , 45.0 , 11.0 , 42.0 , 12.0 , 39.0 , 14.0 , 36.0 , 16.0 , 34.0 , 18.0 , 32.0 , 20.0 , 29.0 , 24.0 , 27.0 , 27.0 , 25.0 , 30.0 ]
      ]
}
    return dilines


thanFontArial = ThanFontPolygon("thanarial", makeArialPolygons())
if __name__ == "__main__":
    print(__doc__)
    for k in thanFontArial.thanDilines:
        print(k, ':', thanFontArial.thanDilines[k])
