##############################################################################
# ThanCad 0.9.2 "Tartu": n-dimensional CAD with raster support for engineers
#
# Copyright (C) 2001-2026 Thanasis Stamos, January 20, 2026
# Athens, Greece, Europe
# URL: http://thancad.sourceforge.net
# e-mail: cyberthanasis@gmx.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (www.gnu.org/licenses/gpl.html).
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##############################################################################
"""\
ThanCad 0.9.2 "Tartu": n-dimensional CAD with raster support for engineers

This module returns the coordinates of the perimeter of Greece in EGSA87.
"""
#Monday August 5, 2013
#The approximate coordinates of the perimeter of Greece were taken
#from:
#/home/a12/h/libs/source_fortran2003/geom2003/developer/greece/egm08a.thcx
#The file was unziped and the ThanLines belonging to layer greece
#were copied here.
#Thu Apr 26 23:04:31 EEST 2018
#The approximate coordinates of Mykonos were taken from:
#/home/a12/h/libs/source_fortran2003/geom2003/developer/greece/mykonos/mykonos02.thcx
#The file was unziped and the ThanLines belonging to Mykonos
#were copied here.


from math import radians

def thanIterGreece(geodp):
    "Loop over all lines of the perimeter of Greece."
    greece= """\
        <NODES>
                2.344095155337721e+01   3.795650135436782e+01   0.000000000000000e+00
                2.347787054848116e+01   3.798931823890467e+01   0.000000000000000e+00
                2.350658532245089e+01   3.798931823890467e+01   0.000000000000000e+00
                2.352709587528642e+01   3.794419502266651e+01   0.000000000000000e+00
                2.348607476961537e+01   3.791137813812967e+01   0.000000000000000e+00
                2.344915577451142e+01   3.790727602756257e+01   0.000000000000000e+00
                2.342454311110880e+01   3.793188869096520e+01   0.000000000000000e+00
                2.344095155337721e+01   3.795650135436782e+01   0.000000000000000e+00
        <NODES>
                2.458950405488002e+01   4.075968501994669e+01   0.000000000000000e+00
                2.466129098980435e+01   4.079045084919998e+01   0.000000000000000e+00
                2.472795028651981e+01   4.079045084919998e+01   0.000000000000000e+00
                2.476897139219085e+01   4.069815336144012e+01   0.000000000000000e+00
                2.475871611577309e+01   4.063662170293355e+01   0.000000000000000e+00
                2.472282264831092e+01   4.059047295905361e+01   0.000000000000000e+00
                2.466641862801323e+01   4.058021768263585e+01   0.000000000000000e+00
                2.460488696950666e+01   4.058021768263585e+01   0.000000000000000e+00
                2.454848294920897e+01   4.062636642651579e+01   0.000000000000000e+00
                2.450746184353792e+01   4.066738753218684e+01   0.000000000000000e+00
                2.456386586383561e+01   4.070840863785789e+01   0.000000000000000e+00
                2.458950405488002e+01   4.075968501994669e+01   0.000000000000000e+00
        <NODES>
                2.500554780005310e+01   3.767377620262564e+01   0.000000000000000e+00
                2.506297734799257e+01   3.768198042375985e+01   0.000000000000000e+00
                2.525987865521360e+01   3.759583610185065e+01   0.000000000000000e+00
                2.523526599181098e+01   3.755071288561249e+01   0.000000000000000e+00
                2.519834699670703e+01   3.753430444334408e+01   0.000000000000000e+00
                2.513681533820046e+01   3.755891710674670e+01   0.000000000000000e+00
                2.504656890572415e+01   3.759993821241775e+01   0.000000000000000e+00
                2.500144568948600e+01   3.766146987092432e+01   0.000000000000000e+00
                2.500554780005310e+01   3.767377620262564e+01   0.000000000000000e+00
        <NODES>
                2.608440287920169e+01   3.763685720752169e+01   0.000000000000000e+00
                2.615824086940957e+01   3.764506142865591e+01   0.000000000000000e+00
                2.619926197508062e+01   3.766146987092432e+01   0.000000000000000e+00
                2.625669152302009e+01   3.766146987092432e+01   0.000000000000000e+00
                2.632642740266087e+01   3.764095931808880e+01   0.000000000000000e+00
                2.624848730188588e+01   3.761634665468617e+01   0.000000000000000e+00
                2.616234297997668e+01   3.757942765958223e+01   0.000000000000000e+00
                2.610491343203721e+01   3.755071288561249e+01   0.000000000000000e+00
                2.605568810523195e+01   3.754661077504539e+01   0.000000000000000e+00
                2.597364589388985e+01   3.755481499617960e+01   0.000000000000000e+00
                2.604748388409774e+01   3.761224454411906e+01   0.000000000000000e+00
                2.608440287920169e+01   3.763685720752169e+01   0.000000000000000e+00
        <NODES>
                2.690719652529427e+01   3.705753023313454e+01   0.000000000000000e+00
                2.695847290738309e+01   3.707804078597007e+01   0.000000000000000e+00
                2.697898346021861e+01   3.704214731850790e+01   0.000000000000000e+00
                2.699949401305414e+01   3.698061566000133e+01   0.000000000000000e+00
                2.696872818380085e+01   3.697036038358357e+01   0.000000000000000e+00
                2.693796235454756e+01   3.700112621283685e+01   0.000000000000000e+00
                2.691232416350316e+01   3.704214731850790e+01   0.000000000000000e+00
                2.690719652529427e+01   3.705753023313454e+01   0.000000000000000e+00
        <NODES>
                2.068433325228273e+01   3.790317391699546e+01   0.000000000000000e+00
                2.075817124249062e+01   3.785394859019020e+01   0.000000000000000e+00
                2.084841767496693e+01   3.781292748451915e+01   0.000000000000000e+00
                2.096737888141297e+01   3.773088527317706e+01   0.000000000000000e+00
                2.089354089120508e+01   3.772678316260995e+01   0.000000000000000e+00
                2.086892822780245e+01   3.766114939353627e+01   0.000000000000000e+00
                2.084021345383272e+01   3.762012828786523e+01   0.000000000000000e+00
                2.077457968475904e+01   3.767345572523759e+01   0.000000000000000e+00
                2.068023114171563e+01   3.776370215771389e+01   0.000000000000000e+00
                2.064741425717879e+01   3.785805070075730e+01   0.000000000000000e+00
                2.064741425717879e+01   3.788676547472704e+01   0.000000000000000e+00
                2.068433325228273e+01   3.790317391699546e+01   0.000000000000000e+00
        <NODES>
                2.070484380511826e+01   3.881794457345985e+01   0.000000000000000e+00
                2.073766068965510e+01   3.872359603041644e+01   0.000000000000000e+00
                2.073355857908799e+01   3.864565592964144e+01   0.000000000000000e+00
                2.072535435795378e+01   3.862104326623881e+01   0.000000000000000e+00
                2.067202692058142e+01   3.860053271340329e+01   0.000000000000000e+00
                2.061459737264195e+01   3.856771582886645e+01   0.000000000000000e+00
                2.056537204583669e+01   3.854310316546382e+01   0.000000000000000e+00
                2.056126993526959e+01   3.860873693453750e+01   0.000000000000000e+00
                2.056126993526959e+01   3.868667703531249e+01   0.000000000000000e+00
                2.062280159377616e+01   3.879743402062432e+01   0.000000000000000e+00
                2.066382269944721e+01   3.882614879459405e+01   0.000000000000000e+00
                2.070484380511826e+01   3.881794457345985e+01   0.000000000000000e+00
        <NODES>
                2.654826185067260e+01   3.738569907850294e+01   0.000000000000000e+00
                2.661492114738805e+01   3.736518852566741e+01   0.000000000000000e+00
                2.658928295634365e+01   3.730365686716084e+01   0.000000000000000e+00
                2.656364476529924e+01   3.725238048507202e+01   0.000000000000000e+00
                2.654826185067260e+01   3.730365686716084e+01   0.000000000000000e+00
                2.653287893604596e+01   3.736518852566741e+01   0.000000000000000e+00
                2.654826185067260e+01   3.738569907850294e+01   0.000000000000000e+00
        <NODES>
                2.827991304178475e+01   4.146783133699181e+01   0.000000000000000e+00
                2.815472656207574e+01   4.154294322481722e+01   0.000000000000000e+00
                2.795442819454133e+01   4.183087212814794e+01   0.000000000000000e+00
                2.801702143439583e+01   4.190598401597335e+01   0.000000000000000e+00
                2.792939089859952e+01   4.201865184771146e+01   0.000000000000000e+00
        <NODES>
                2.360139535293310e+01   3.918909584611418e+01   0.000000000000000e+00
                2.366702912200678e+01   3.917268740384576e+01   0.000000000000000e+00
                2.372609951417309e+01   3.913330714240155e+01   0.000000000000000e+00
                2.375235302180256e+01   3.912018038858682e+01   0.000000000000000e+00
                2.372938120262678e+01   3.909064519250366e+01   0.000000000000000e+00
                2.368343756427520e+01   3.907423675023524e+01   0.000000000000000e+00
                2.365718405664573e+01   3.909720856941102e+01   0.000000000000000e+00
                2.360467704138679e+01   3.914643389621629e+01   0.000000000000000e+00
                2.358170522221100e+01   3.918253246920681e+01   0.000000000000000e+00
                2.360139535293310e+01   3.918909584611418e+01   0.000000000000000e+00
        <NODES>
                2.621977252791615e+01   3.918745500188734e+01   0.000000000000000e+00
                2.611721976373853e+01   3.910541279054524e+01   0.000000000000000e+00
                2.602287122069511e+01   3.909310645884393e+01   0.000000000000000e+00
                2.594082900935301e+01   3.912182123281366e+01   0.000000000000000e+00
                2.587519524027934e+01   3.915053600678340e+01   0.000000000000000e+00
                2.587519524027934e+01   3.922847610755839e+01   0.000000000000000e+00
                2.588750157198065e+01   3.925308877096101e+01   0.000000000000000e+00
                2.603107544182932e+01   3.928590565549786e+01   0.000000000000000e+00
                2.614183242714115e+01   3.930641620833338e+01   0.000000000000000e+00
                2.624848730188588e+01   3.938025419854127e+01   0.000000000000000e+00
                2.632232529209377e+01   3.939256053024258e+01   0.000000000000000e+00
                2.636334639776482e+01   3.933102887173601e+01   0.000000000000000e+00
                2.642487805627139e+01   3.925719088152812e+01   0.000000000000000e+00
                2.651102237818059e+01   3.918335289132023e+01   0.000000000000000e+00
                2.662177936349243e+01   3.902337057920315e+01   0.000000000000000e+00
                2.660947303179111e+01   3.899465580523341e+01   0.000000000000000e+00
                2.653153293101612e+01   3.906849379544130e+01   0.000000000000000e+00
                2.648640971477796e+01   3.909720856941103e+01   0.000000000000000e+00
                2.646589916194244e+01   3.908900434827682e+01   0.000000000000000e+00
                2.651922659931480e+01   3.902337057920315e+01   0.000000000000000e+00
                2.651922659931480e+01   3.900286002636762e+01   0.000000000000000e+00
                2.647410338307665e+01   3.897824736296499e+01   0.000000000000000e+00
                2.641257172457007e+01   3.895773681012947e+01   0.000000000000000e+00
                2.635924428719771e+01   3.898645158409920e+01   0.000000000000000e+00
                2.626489574415430e+01   3.899055369466630e+01   0.000000000000000e+00
                2.619926197508062e+01   3.901106424750183e+01   0.000000000000000e+00
                2.615413875884247e+01   3.902747268977025e+01   0.000000000000000e+00
                2.613773031657405e+01   3.907669801657551e+01   0.000000000000000e+00
                2.621977252791615e+01   3.912592334338076e+01   0.000000000000000e+00
                2.626899785472141e+01   3.915874022791760e+01   0.000000000000000e+00
                2.623207885961746e+01   3.919565922302155e+01   0.000000000000000e+00
                2.621977252791615e+01   3.918745500188734e+01   0.000000000000000e+00
        <NODES>
                2.341762079952681e+01   3.915956065003102e+01   0.000000000000000e+00
                2.343402924179522e+01   3.921206766528996e+01   0.000000000000000e+00
                2.346684612633206e+01   3.920550428838259e+01   0.000000000000000e+00
                2.348653625705417e+01   3.918581415766050e+01   0.000000000000000e+00
                2.347012781478575e+01   3.915299727312365e+01   0.000000000000000e+00
                2.344059261870259e+01   3.912674376549418e+01   0.000000000000000e+00
                2.341433911107312e+01   3.911033532322576e+01   0.000000000000000e+00
                2.340449404571207e+01   3.914643389621629e+01   0.000000000000000e+00
                2.341762079952681e+01   3.915956065003102e+01   0.000000000000000e+00
        <NODES>
                2.287896240568385e+01   3.628694235355614e+01   0.000000000000000e+00
                2.291588140078779e+01   3.637718878603245e+01   0.000000000000000e+00
                2.299792361212989e+01   3.631565712752587e+01   0.000000000000000e+00
                2.304304682836804e+01   3.625412546901930e+01   0.000000000000000e+00
                2.303484260723383e+01   3.621720647391535e+01   0.000000000000000e+00
                2.300202572269699e+01   3.619669592107984e+01   0.000000000000000e+00
                2.294459617475752e+01   3.617618536824431e+01   0.000000000000000e+00
                2.289947295851937e+01   3.624181913731799e+01   0.000000000000000e+00
                2.287896240568385e+01   3.628694235355614e+01   0.000000000000000e+00
        <NODES>
                2.279409999332686e+01   3.883446838758796e+01   0.000000000000000e+00
                2.291880415456685e+01   3.890010215666164e+01   0.000000000000000e+00
                2.302381818508474e+01   3.893291904119848e+01   0.000000000000000e+00
                2.310586039642683e+01   3.898870774491110e+01   0.000000000000000e+00
                2.321087442694472e+01   3.902808800635531e+01   0.000000000000000e+00
                2.326666313065735e+01   3.903465138326268e+01   0.000000000000000e+00
                2.333557858818471e+01   3.899527112181848e+01   0.000000000000000e+00
                2.340777573416575e+01   3.890338384511532e+01   0.000000000000000e+00
                2.350294469932259e+01   3.880493319150481e+01   0.000000000000000e+00
                2.360795872984047e+01   3.876227124160692e+01   0.000000000000000e+00
                2.369328262963625e+01   3.873601773397745e+01   0.000000000000000e+00
                2.382126847932993e+01   3.868351071871850e+01   0.000000000000000e+00
                2.394597264056991e+01   3.865725721108903e+01   0.000000000000000e+00
                2.407724017871727e+01   3.867038396490377e+01   0.000000000000000e+00
                2.410677537480042e+01   3.866053889954271e+01   0.000000000000000e+00
                2.417240914387410e+01   3.853911642675641e+01   0.000000000000000e+00
                2.420194433995726e+01   3.848989109995115e+01   0.000000000000000e+00
                2.418225420923515e+01   3.840456720015537e+01   0.000000000000000e+00
                2.423147953604041e+01   3.827001797355433e+01   0.000000000000000e+00
                2.430039499356777e+01   3.818797576221223e+01   0.000000000000000e+00
                2.439884564717829e+01   3.814203212386066e+01   0.000000000000000e+00
                2.451698643151091e+01   3.812890537004593e+01   0.000000000000000e+00
                2.454980331604775e+01   3.807311666633330e+01   0.000000000000000e+00
                2.455964838140880e+01   3.801732796262067e+01   0.000000000000000e+00
                2.453011318532565e+01   3.798122938963015e+01   0.000000000000000e+00
                2.447760617006671e+01   3.796482094736173e+01   0.000000000000000e+00
                2.442181746635408e+01   3.796153925890805e+01   0.000000000000000e+00
                2.434633863191935e+01   3.801076458571330e+01   0.000000000000000e+00
                2.425773304366988e+01   3.809280679705540e+01   0.000000000000000e+00
                2.421507109377199e+01   3.810265186241645e+01   0.000000000000000e+00
                2.417569083232779e+01   3.817156731994382e+01   0.000000000000000e+00
                2.410349368634674e+01   3.822079264674908e+01   0.000000000000000e+00
                2.404442329418043e+01   3.831596161190591e+01   0.000000000000000e+00
                2.400504303273622e+01   3.836846862716485e+01   0.000000000000000e+00
                2.396894445974570e+01   3.838159538097958e+01   0.000000000000000e+00
                2.379173328324677e+01   3.838159538097958e+01   0.000000000000000e+00
                2.374250795644151e+01   3.838159538097958e+01   0.000000000000000e+00
                2.367031081046047e+01   3.841441226551643e+01   0.000000000000000e+00
                2.361780379520152e+01   3.843410239623853e+01   0.000000000000000e+00
                2.358498691066469e+01   3.853255304984904e+01   0.000000000000000e+00
                2.350950807622996e+01   3.857521499974693e+01   0.000000000000000e+00
                2.341105742261944e+01   3.869663747253324e+01   0.000000000000000e+00
                2.336839547272155e+01   3.873273604552377e+01   0.000000000000000e+00
                2.331588845746261e+01   3.874914448779218e+01   0.000000000000000e+00
                2.316821247704683e+01   3.884103176449533e+01   0.000000000000000e+00
                2.306648013498263e+01   3.882790501068060e+01   0.000000000000000e+00
                2.301725480817737e+01   3.885415851831007e+01   0.000000000000000e+00
                2.296802948137211e+01   3.885744020676375e+01   0.000000000000000e+00
                2.296802948137211e+01   3.883446838758796e+01   0.000000000000000e+00
                2.291552246611317e+01   3.883118669913428e+01   0.000000000000000e+00
                2.283019856631739e+01   3.882790501068060e+01   0.000000000000000e+00
                2.279409999332686e+01   3.883446838758796e+01   0.000000000000000e+00
        <NODES>
                2.464078043696883e+01   3.702163676567238e+01   0.000000000000000e+00
                2.469205681905764e+01   3.702163676567238e+01   0.000000000000000e+00
                2.475871611577309e+01   3.696010510716580e+01   0.000000000000000e+00
                2.471256737189317e+01   3.694984983074804e+01   0.000000000000000e+00
                2.464078043696883e+01   3.694984983074804e+01   0.000000000000000e+00
                2.461514224592442e+01   3.699599857462797e+01   0.000000000000000e+00
                2.464078043696883e+01   3.702163676567238e+01   0.000000000000000e+00
        <NODES>
                2.507662968472372e+01   3.998028401219677e+01   0.000000000000000e+00
                2.522020355457239e+01   3.997515637398789e+01   0.000000000000000e+00
                2.525096938382568e+01   3.998028401219677e+01   0.000000000000000e+00
                2.531250104233225e+01   3.993926290652572e+01   0.000000000000000e+00
                2.540479853009211e+01   4.000592220324117e+01   0.000000000000000e+00
                2.545094727397204e+01   4.001617747965894e+01   0.000000000000000e+00
                2.543556435934540e+01   3.996490109757012e+01   0.000000000000000e+00
                2.534839450979442e+01   3.987773124801915e+01   0.000000000000000e+00
                2.536890506262994e+01   3.978030612205040e+01   0.000000000000000e+00
                2.534326687158554e+01   3.976492320742376e+01   0.000000000000000e+00
                2.529199048949673e+01   3.982645486593034e+01   0.000000000000000e+00
                2.524071410740791e+01   3.986747597160138e+01   0.000000000000000e+00
                2.522533119278127e+01   3.989311416264579e+01   0.000000000000000e+00
                2.519456536352799e+01   3.984183778055698e+01   0.000000000000000e+00
                2.511252315218589e+01   3.984183778055698e+01   0.000000000000000e+00
                2.504073621726155e+01   3.984696541876586e+01   0.000000000000000e+00
                2.503048094084379e+01   3.985209305697474e+01   0.000000000000000e+00
                2.506637440830596e+01   3.993926290652572e+01   0.000000000000000e+00
                2.507662968472372e+01   3.998028401219677e+01   0.000000000000000e+00
        <NODES>
                2.813383867352732e+01   3.663262054679742e+01   0.000000000000000e+00
                2.803840689050075e+01   3.656588291910073e+01   0.000000000000000e+00
                2.803184351359339e+01   3.659213642673020e+01   0.000000000000000e+00
                2.803184351359339e+01   3.669386876879440e+01   0.000000000000000e+00
                2.808106884039864e+01   3.669715045724809e+01   0.000000000000000e+00
                2.808106884039864e+01   3.674309409559966e+01   0.000000000000000e+00
                2.803512520204707e+01   3.674309409559966e+01   0.000000000000000e+00
                2.794980130225129e+01   3.674637578405334e+01   0.000000000000000e+00
                2.788416753317761e+01   3.673324903023860e+01   0.000000000000000e+00
                2.779556194492815e+01   3.672996734178492e+01   0.000000000000000e+00
                2.768726622595657e+01   3.673981240714598e+01   0.000000000000000e+00
                2.769711129131763e+01   3.670371383415545e+01   0.000000000000000e+00
                2.762819583379027e+01   3.664792513044282e+01   0.000000000000000e+00
                2.755271699935554e+01   3.666105188425756e+01   0.000000000000000e+00
                2.746739309955975e+01   3.664464344198914e+01   0.000000000000000e+00
                2.739191426512502e+01   3.664136175353546e+01   0.000000000000000e+00
                2.737878751131029e+01   3.665777019580388e+01   0.000000000000000e+00
                2.745426634574502e+01   3.673324903023860e+01   0.000000000000000e+00
                2.755271699935554e+01   3.677919266859018e+01   0.000000000000000e+00
                2.763147752224395e+01   3.679560111085860e+01   0.000000000000000e+00
                2.772992817585446e+01   3.678575604549755e+01   0.000000000000000e+00
                2.781853376410393e+01   3.678575604549755e+01   0.000000000000000e+00
                2.788416753317761e+01   3.678903773395123e+01   0.000000000000000e+00
                2.795964636761234e+01   3.679888279931228e+01   0.000000000000000e+00
                2.803184351359339e+01   3.683169968384912e+01   0.000000000000000e+00
                2.802528013668602e+01   3.688092501065438e+01   0.000000000000000e+00
                2.803840689050075e+01   3.691702358364491e+01   0.000000000000000e+00
                2.812373079029653e+01   3.691702358364491e+01   0.000000000000000e+00
                2.815654767483337e+01   3.692686864900595e+01   0.000000000000000e+00
                2.821889975545337e+01   3.697281228735753e+01   0.000000000000000e+00
                2.827140677071231e+01   3.702203761416279e+01   0.000000000000000e+00
                2.811060403648180e+01   3.701875592570911e+01   0.000000000000000e+00
                2.785463233709445e+01   3.700562917189437e+01   0.000000000000000e+00
                2.775289999503025e+01   3.701219254880174e+01   0.000000000000000e+00
                2.770039297977131e+01   3.697937566426490e+01   0.000000000000000e+00
                2.760850570306816e+01   3.697937566426490e+01   0.000000000000000e+00
                2.751661842636501e+01   3.697937566426490e+01   0.000000000000000e+00
                2.742801283811555e+01   3.699578410653332e+01   0.000000000000000e+00
                2.729018192306082e+01   3.698593904117227e+01   0.000000000000000e+00
                2.739519595357871e+01   3.704172774488489e+01   0.000000000000000e+00
                2.746411141110607e+01   3.709423476014383e+01   0.000000000000000e+00
                2.746872749787181e+01   3.710733750538304e+01   0.000000000000000e+00
                2.740719583936524e+01   3.711246514359192e+01   0.000000000000000e+00
                2.737130237190307e+01   3.714323097284521e+01   0.000000000000000e+00
                2.739694056294748e+01   3.720476263135178e+01   0.000000000000000e+00
                2.748411041249846e+01   3.731244303373828e+01   0.000000000000000e+00
                2.745334458324517e+01   3.731757067194717e+01   0.000000000000000e+00
                2.739181292473859e+01   3.730218775732052e+01   0.000000000000000e+00
                2.740206820115636e+01   3.737910233045373e+01   0.000000000000000e+00
                2.733540890444090e+01   3.737910233045373e+01   0.000000000000000e+00
                2.724823905488993e+01   3.735859177761820e+01   0.000000000000000e+00
                2.719183503459223e+01   3.749703800925799e+01   0.000000000000000e+00
                2.719696267280111e+01   3.753293147672017e+01   0.000000000000000e+00
                2.717645211996559e+01   3.758933549701786e+01   0.000000000000000e+00
                2.705338880295244e+01   3.766625007015107e+01   0.000000000000000e+00
                2.709524962891200e+01   3.767049925261073e+01   0.000000000000000e+00
                2.713030337608566e+01   3.769188826119547e+01   0.000000000000000e+00
                2.718670739638335e+01   3.770214353761324e+01   0.000000000000000e+00
                2.723285614026328e+01   3.778418574895534e+01   0.000000000000000e+00
                2.723798377847216e+01   3.788161087492408e+01   0.000000000000000e+00
                2.720721794921888e+01   3.797903600089282e+01   0.000000000000000e+00
                2.708928227041461e+01   3.803031238298163e+01   0.000000000000000e+00
                2.692519784773042e+01   3.806107821223492e+01   0.000000000000000e+00
                2.684828327459720e+01   3.810722695611484e+01   0.000000000000000e+00
                2.678675161609063e+01   3.817901389103918e+01   0.000000000000000e+00
                2.672009231937517e+01   3.817901389103918e+01   0.000000000000000e+00
                2.664830538445084e+01   3.814312042357702e+01   0.000000000000000e+00
                2.657651844952650e+01   3.812773750895037e+01   0.000000000000000e+00
                2.651498679101993e+01   3.815850333820366e+01   0.000000000000000e+00
                2.640217875042454e+01   3.823541791133687e+01   0.000000000000000e+00
                2.632013653908245e+01   3.823541791133687e+01   0.000000000000000e+00
                2.626886015699364e+01   3.826105610238127e+01   0.000000000000000e+00
                2.627398779520252e+01   3.831233248447009e+01   0.000000000000000e+00
                2.631500890087356e+01   3.832258776088785e+01   0.000000000000000e+00
                2.639705111221566e+01   3.831233248447009e+01   0.000000000000000e+00
                2.641243402684231e+01   3.835335359014114e+01   0.000000000000000e+00
                2.646371040893112e+01   3.837899178118555e+01   0.000000000000000e+00
                2.647909332355776e+01   3.840975761043883e+01   0.000000000000000e+00
                2.639192347400678e+01   3.843026816327436e+01   0.000000000000000e+00
                2.639192347400678e+01   3.856358675670526e+01   0.000000000000000e+00
                2.641756166505119e+01   3.867639479730065e+01   0.000000000000000e+00
                2.654062498206433e+01   3.866101188267400e+01   0.000000000000000e+00
                2.658164608773538e+01   3.856358675670526e+01   0.000000000000000e+00
                2.662779483161531e+01   3.844052343969211e+01   0.000000000000000e+00
                2.666368829907748e+01   3.838924705760331e+01   0.000000000000000e+00
                2.673034759579294e+01   3.838924705760331e+01   0.000000000000000e+00
                2.682777272176168e+01   3.837899178118555e+01   0.000000000000000e+00
                2.693032548593930e+01   3.838411941939442e+01   0.000000000000000e+00
                2.701749533549028e+01   3.838411941939442e+01   0.000000000000000e+00
                2.709953754683237e+01   3.839437469581219e+01   0.000000000000000e+00
                2.712517573787678e+01   3.842514052506547e+01   0.000000000000000e+00
                2.700724005907252e+01   3.846103399252764e+01   0.000000000000000e+00
                2.694570840056594e+01   3.849692745998981e+01   0.000000000000000e+00
                2.686879382743273e+01   3.857896967133190e+01   0.000000000000000e+00
                2.676111342504622e+01   3.868665007371841e+01   0.000000000000000e+00
                2.681751744534391e+01   3.875843700864274e+01   0.000000000000000e+00
                2.693545312414818e+01   3.873279881759834e+01   0.000000000000000e+00
                2.693032548593930e+01   3.878407519968715e+01   0.000000000000000e+00
                2.697647422981923e+01   3.881484102894044e+01   0.000000000000000e+00
                2.703800588832580e+01   3.885586213461148e+01   0.000000000000000e+00
                2.705851644116132e+01   3.888150032565589e+01   0.000000000000000e+00
                2.693032548593930e+01   3.891226615490918e+01   0.000000000000000e+00
                2.681751744534391e+01   3.893790434595358e+01   0.000000000000000e+00
                2.680726216892615e+01   3.896867017520687e+01   0.000000000000000e+00
                2.683290035997056e+01   3.903020183371344e+01   0.000000000000000e+00
                2.684828327459720e+01   3.910198876863778e+01   0.000000000000000e+00
                2.675085814862846e+01   3.921992444744204e+01   0.000000000000000e+00
                2.667394357549524e+01   3.930196665878414e+01   0.000000000000000e+00
                2.675085814862846e+01   3.935837067908183e+01   0.000000000000000e+00
                2.678675161609063e+01   3.941990233758840e+01   0.000000000000000e+00
                2.688930438026825e+01   3.945066816684169e+01   0.000000000000000e+00
                2.696109131519258e+01   3.955322093101931e+01   0.000000000000000e+00
                2.690981493310377e+01   3.956860384564596e+01   0.000000000000000e+00
                2.681238980713503e+01   3.958911439848148e+01   0.000000000000000e+00
                2.669958176653965e+01   3.955322093101931e+01   0.000000000000000e+00
                2.643807221788671e+01   3.950707218713939e+01   0.000000000000000e+00
                2.622783905132259e+01   3.946605108146834e+01   0.000000000000000e+00
                2.608939281968280e+01   3.947117871967722e+01   0.000000000000000e+00
                2.609452045789168e+01   3.955322093101931e+01   0.000000000000000e+00
                2.615605211639825e+01   3.963526314236141e+01   0.000000000000000e+00
                2.616117975460713e+01   3.984036867071666e+01   0.000000000000000e+00
                2.619194558386042e+01   3.998394254056532e+01   0.000000000000000e+00
                2.628937070982916e+01   4.001470836981861e+01   0.000000000000000e+00
                2.633039181550021e+01   4.004547419907190e+01   0.000000000000000e+00
                2.643294457967783e+01   4.016853751608505e+01   0.000000000000000e+00
                2.652011442922881e+01   4.023519681280050e+01   0.000000000000000e+00
                2.666368829907748e+01   4.032236666235148e+01   0.000000000000000e+00
                2.673034759579294e+01   4.039415359727582e+01   0.000000000000000e+00
                2.680726216892615e+01   4.041979178832022e+01   0.000000000000000e+00
                2.694058076235706e+01   4.038902595906693e+01   0.000000000000000e+00
                2.699185714444587e+01   4.040953651190246e+01   0.000000000000000e+00
                2.709440990862349e+01   4.043517470294686e+01   0.000000000000000e+00
                2.724311141668105e+01   4.046594053220015e+01   0.000000000000000e+00
                2.734053654264979e+01   4.038902595906693e+01   0.000000000000000e+00
                2.747385513608069e+01   4.031211138593372e+01   0.000000000000000e+00
                2.759179081488496e+01   4.031211138593372e+01   0.000000000000000e+00
                2.771998177010699e+01   4.031211138593372e+01   0.000000000000000e+00
                2.782253453428461e+01   4.034800485339589e+01   0.000000000000000e+00
                2.783791744891125e+01   4.038389832085805e+01   0.000000000000000e+00
                2.779176870503132e+01   4.040440887369358e+01   0.000000000000000e+00
                2.770459885548035e+01   4.051208927608008e+01   0.000000000000000e+00
                2.772510940831587e+01   4.053259982891561e+01   0.000000000000000e+00
                2.789432146920894e+01   4.052747219070672e+01   0.000000000000000e+00
                2.798149131875992e+01   4.050183399966232e+01   0.000000000000000e+00
                2.795585312771552e+01   4.047106817040903e+01   0.000000000000000e+00
                2.795072548950664e+01   4.041466415011134e+01   0.000000000000000e+00
                2.797636368055104e+01   4.036851540623141e+01   0.000000000000000e+00
                2.809942699756419e+01   4.040440887369358e+01   0.000000000000000e+00
                2.822249031457734e+01   4.041466415011134e+01   0.000000000000000e+00
                2.830453252591943e+01   4.040440887369358e+01   0.000000000000000e+00
        <NODES>
                2.284204341057990e+01   3.794419502266651e+01   0.000000000000000e+00
                2.293228984305621e+01   3.793599080153230e+01   0.000000000000000e+00
                2.295690250645884e+01   3.793188869096520e+01   0.000000000000000e+00
                2.298971939099568e+01   3.787445914302572e+01   0.000000000000000e+00
                2.304304682836804e+01   3.784574436905599e+01   0.000000000000000e+00
                2.312919115027724e+01   3.782113170565336e+01   0.000000000000000e+00
                2.314970170311277e+01   3.779651904225074e+01   0.000000000000000e+00
                2.312508903971014e+01   3.774729371544547e+01   0.000000000000000e+00
                2.312508903971014e+01   3.770217049920732e+01   0.000000000000000e+00
                2.317841647708250e+01   3.764884306183496e+01   0.000000000000000e+00
                2.326456079899171e+01   3.758320929276128e+01   0.000000000000000e+00
                2.334250089976670e+01   3.754218818709023e+01   0.000000000000000e+00
                2.340403255827327e+01   3.751347341312049e+01   0.000000000000000e+00
                2.349017688018247e+01   3.745604386518103e+01   0.000000000000000e+00
                2.349017688018247e+01   3.741502275950998e+01   0.000000000000000e+00
                2.343684944281011e+01   3.739861431724156e+01   0.000000000000000e+00
                2.335480723146801e+01   3.739861431724156e+01   0.000000000000000e+00
                2.329327557296144e+01   3.738220587497314e+01   0.000000000000000e+00
                2.319482491935092e+01   3.734528687986920e+01   0.000000000000000e+00
                2.314559959254566e+01   3.731246999533236e+01   0.000000000000000e+00
                2.308817004460619e+01   3.733298054816788e+01   0.000000000000000e+00
                2.307586371290488e+01   3.739451220667446e+01   0.000000000000000e+00
                2.306355738120357e+01   3.742322698064419e+01   0.000000000000000e+00
                2.308406793403909e+01   3.745194175461393e+01   0.000000000000000e+00
                2.306355738120357e+01   3.745194175461393e+01   0.000000000000000e+00
                2.300612783326410e+01   3.744373753347971e+01   0.000000000000000e+00
                2.295690250645884e+01   3.747245230744945e+01   0.000000000000000e+00
                2.292408562192200e+01   3.751757552368760e+01   0.000000000000000e+00
                2.289947295851937e+01   3.754629029765734e+01   0.000000000000000e+00
                2.282973707887859e+01   3.754218818709023e+01   0.000000000000000e+00
                2.278461386264043e+01   3.756269873992576e+01   0.000000000000000e+00
                2.275179697810360e+01   3.760371984559681e+01   0.000000000000000e+00
                2.274769486753649e+01   3.759551562446259e+01   0.000000000000000e+00
                2.272718431470096e+01   3.752577974482181e+01   0.000000000000000e+00
                2.273949064640228e+01   3.743963542291261e+01   0.000000000000000e+00
                2.294049406419042e+01   3.708275180357449e+01   0.000000000000000e+00
                2.296100461702594e+01   3.708275180357449e+01   0.000000000000000e+00
                2.301843416496541e+01   3.694328004429292e+01   0.000000000000000e+00
                2.305945527063646e+01   3.679970617444425e+01   0.000000000000000e+00
                2.301843416496541e+01   3.672997029480346e+01   0.000000000000000e+00
                2.307586371290488e+01   3.663151964119295e+01   0.000000000000000e+00
                2.313739537141145e+01   3.650435421361270e+01   0.000000000000000e+00
                2.313739537141145e+01   3.645102677624033e+01   0.000000000000000e+00
                2.310457848687462e+01   3.644692466567323e+01   0.000000000000000e+00
                2.301843416496541e+01   3.651666054531401e+01   0.000000000000000e+00
                2.295280039589174e+01   3.655768165098506e+01   0.000000000000000e+00
                2.283794130001280e+01   3.665203019402848e+01   0.000000000000000e+00
                2.276410330980491e+01   3.672176607366926e+01   0.000000000000000e+00
                2.274769486753649e+01   3.679150195331004e+01   0.000000000000000e+00
                2.260822310825492e+01   3.680791039557846e+01   0.000000000000000e+00
                2.253028300747993e+01   3.674227662650478e+01   0.000000000000000e+00
                2.248515979124178e+01   3.651255843474691e+01   0.000000000000000e+00
                2.246054712783915e+01   3.643461833397191e+01   0.000000000000000e+00
                2.239081124819836e+01   3.643051622340481e+01   0.000000000000000e+00
                2.234568803196021e+01   3.646743521850875e+01   0.000000000000000e+00
                2.237030069536284e+01   3.654537531928375e+01   0.000000000000000e+00
                2.233748381082600e+01   3.666023441516268e+01   0.000000000000000e+00
                2.230466692628916e+01   3.677509351104162e+01   0.000000000000000e+00
                2.227185004175232e+01   3.682021672727977e+01   0.000000000000000e+00
                2.215699094587339e+01   3.688585049635346e+01   0.000000000000000e+00
                2.209956139793392e+01   3.692276949145739e+01   0.000000000000000e+00
                2.207905084509839e+01   3.702942436620212e+01   0.000000000000000e+00
                2.201751918659182e+01   3.701711803450081e+01   0.000000000000000e+00
                2.193547697524972e+01   3.698430114996397e+01   0.000000000000000e+00
                2.190676220127999e+01   3.690225893862187e+01   0.000000000000000e+00
                2.192317064354841e+01   3.682431883784688e+01   0.000000000000000e+00
                2.191496642241420e+01   3.678329773217583e+01   0.000000000000000e+00
                2.186574109560894e+01   3.674227662650478e+01   0.000000000000000e+00
                2.180420943710237e+01   3.679150195331004e+01   0.000000000000000e+00
                2.173857566802869e+01   3.682431883784688e+01   0.000000000000000e+00
                2.166883978838791e+01   3.685713572238372e+01   0.000000000000000e+00
                2.168935034122343e+01   3.693917793372582e+01   0.000000000000000e+00
                2.161141024044844e+01   3.701711803450081e+01   0.000000000000000e+00
                2.154987858194187e+01   3.710326235641001e+01   0.000000000000000e+00
                2.160320601931423e+01   3.723042778399026e+01   0.000000000000000e+00
                2.169345245179053e+01   3.738220587497314e+01   0.000000000000000e+00
                2.163602290385107e+01   3.747245230744945e+01   0.000000000000000e+00
                2.160320601931423e+01   3.751757552368760e+01   0.000000000000000e+00
                2.150475536570371e+01   3.757500507162707e+01   0.000000000000000e+00
                2.142681526492872e+01   3.761602617729812e+01   0.000000000000000e+00
                2.130785405848268e+01   3.764063884070075e+01   0.000000000000000e+00
                2.126683295281163e+01   3.777190637884810e+01   0.000000000000000e+00
                2.122170973657347e+01   3.780472326338494e+01   0.000000000000000e+00
                2.115607596749980e+01   3.782113170565336e+01   0.000000000000000e+00
                2.110274853012743e+01   3.784984647962310e+01   0.000000000000000e+00
                2.113966752523138e+01   3.789907180642835e+01   0.000000000000000e+00
                2.118068863090242e+01   3.793599080153230e+01   0.000000000000000e+00
                2.125452662111031e+01   3.797701190720335e+01   0.000000000000000e+00
                2.127913928451294e+01   3.800572668117308e+01   0.000000000000000e+00
                2.132836461131820e+01   3.813699421932044e+01   0.000000000000000e+00
                2.140630471209319e+01   3.819032165669280e+01   0.000000000000000e+00
                2.144732581776424e+01   3.820673009896122e+01   0.000000000000000e+00
                2.152526591853923e+01   3.817391321442438e+01   0.000000000000000e+00
                2.161141024044844e+01   3.816981110385728e+01   0.000000000000000e+00
                2.167704400952212e+01   3.819852587782701e+01   0.000000000000000e+00
                2.170575878349185e+01   3.826005753633358e+01   0.000000000000000e+00
                2.174677988916290e+01   3.830107864200463e+01   0.000000000000000e+00
                2.182471998993789e+01   3.832569130540726e+01   0.000000000000000e+00
                2.202982551829314e+01   3.828467019973621e+01   0.000000000000000e+00
                2.209135717679971e+01   3.828056808916911e+01   0.000000000000000e+00
                2.212007195076944e+01   3.825595542576648e+01   0.000000000000000e+00
                2.217339938814181e+01   3.819032165669280e+01   0.000000000000000e+00
                2.232517747912469e+01   3.816570899329017e+01   0.000000000000000e+00
                2.260822310825492e+01   3.807956467138097e+01   0.000000000000000e+00
                2.273949064640228e+01   3.801803301287440e+01   0.000000000000000e+00
                2.281743074717727e+01   3.794829713323362e+01   0.000000000000000e+00
                2.284204341057990e+01   3.794419502266651e+01   0.000000000000000e+00
        <NODES>
                2.898138076949174e+01   3.672789227792584e+01   0.000000000000000e+00
                2.885831745247859e+01   3.672789227792584e+01   0.000000000000000e+00
                2.879678579397202e+01   3.665097770479262e+01   0.000000000000000e+00
                2.874550941188321e+01   3.664072242837486e+01   0.000000000000000e+00
                2.865321192412335e+01   3.670738172509031e+01   0.000000000000000e+00
                2.848912750143915e+01   3.679455157464129e+01   0.000000000000000e+00
                2.842246820472370e+01   3.682018976568570e+01   0.000000000000000e+00
                2.834555363159048e+01   3.682018976568570e+01   0.000000000000000e+00
                2.822761795278621e+01   3.675865810717912e+01   0.000000000000000e+00
                2.814044810323524e+01   3.663559479016598e+01   0.000000000000000e+00
                2.813383867352732e+01   3.663262054679742e+01   0.000000000000000e+00
        <NODES>
                2.387049380613518e+01   3.924160286137312e+01   0.000000000000000e+00
                2.393284588675518e+01   3.925472961518786e+01   0.000000000000000e+00
                2.394925432902360e+01   3.925472961518786e+01   0.000000000000000e+00
                2.394597264056991e+01   3.922191273065101e+01   0.000000000000000e+00
                2.392300082139413e+01   3.918581415766050e+01   0.000000000000000e+00
                2.388690224840360e+01   3.916940571539207e+01   0.000000000000000e+00
                2.388033887149624e+01   3.913658883085523e+01   0.000000000000000e+00
                2.385080367541308e+01   3.913002545394787e+01   0.000000000000000e+00
                2.383439523314466e+01   3.913330714240155e+01   0.000000000000000e+00
                2.383111354469098e+01   3.915956065003102e+01   0.000000000000000e+00
                2.385080367541308e+01   3.917925078075312e+01   0.000000000000000e+00
                2.385408536386676e+01   3.921863104219733e+01   0.000000000000000e+00
                2.387049380613518e+01   3.924160286137312e+01   0.000000000000000e+00
        <NODES>
                2.430748395339156e+01   3.668321264388622e+01   0.000000000000000e+00
                2.440490907936030e+01   3.671910611134840e+01   0.000000000000000e+00
                2.448695129070240e+01   3.674987194060168e+01   0.000000000000000e+00
                2.453822767279121e+01   3.673961666418391e+01   0.000000000000000e+00
                2.451771711995568e+01   3.667808500567735e+01   0.000000000000000e+00
                2.447156837607575e+01   3.665757445284181e+01   0.000000000000000e+00
                2.441516435577806e+01   3.665757445284181e+01   0.000000000000000e+00
                2.434337742085373e+01   3.663706390000630e+01   0.000000000000000e+00
                2.431261159160044e+01   3.665244681463294e+01   0.000000000000000e+00
                2.430748395339156e+01   3.668321264388622e+01   0.000000000000000e+00
        <NODES>
                2.437382277271895e+01   3.744405801086776e+01   0.000000000000000e+00
                2.440253754668868e+01   3.746867067427040e+01   0.000000000000000e+00
                2.443125232065842e+01   3.744405801086776e+01   0.000000000000000e+00
                2.444766076292684e+01   3.738252635236120e+01   0.000000000000000e+00
                2.443535443122552e+01   3.735381157839146e+01   0.000000000000000e+00
                2.439433332555448e+01   3.733740313612304e+01   0.000000000000000e+00
                2.437792488328606e+01   3.740303690519672e+01   0.000000000000000e+00
                2.437382277271895e+01   3.744405801086776e+01   0.000000000000000e+00
        <NODES>
                2.509201259935037e+01   3.702676440388126e+01   0.000000000000000e+00
                2.513816134323030e+01   3.711906189164112e+01   0.000000000000000e+00
                2.518943772531911e+01   3.712931716805888e+01   0.000000000000000e+00
                2.526122466024344e+01   3.712931716805888e+01   0.000000000000000e+00
                2.527660757487009e+01   3.709855133880559e+01   0.000000000000000e+00
                2.526122466024344e+01   3.704214731850790e+01   0.000000000000000e+00
                2.520482063994575e+01   3.701650912746349e+01   0.000000000000000e+00
                2.512790606681254e+01   3.699599857462797e+01   0.000000000000000e+00
                2.509201259935037e+01   3.702676440388126e+01   0.000000000000000e+00
        <NODES>
                1.937105324264498e+01   4.184992103979634e+01   0.000000000000000e+00
                1.948359339565218e+01   4.184992103979634e+01   0.000000000000000e+00
                1.959613354865938e+01   4.177489427112487e+01   0.000000000000000e+00
                1.958362908721413e+01   4.166235411811768e+01   0.000000000000000e+00
                1.945948479398575e+01   4.155981753426668e+01   0.000000000000000e+00
                1.950430078380550e+01   4.148299012314710e+01   0.000000000000000e+00
                1.940186423564607e+01   4.138055357498766e+01   0.000000000000000e+00
                1.947228936250568e+01   4.124610560552839e+01   0.000000000000000e+00
                1.945948479398575e+01   4.111805992032910e+01   0.000000000000000e+00
                1.945948479398575e+01   4.102202565642962e+01   0.000000000000000e+00
                1.945308250972579e+01   4.095800281382997e+01   0.000000000000000e+00
                1.950430078380550e+01   4.091958910827018e+01   0.000000000000000e+00
                1.947228936250568e+01   4.089397997123032e+01   0.000000000000000e+00
                1.935704824582631e+01   4.082355484437070e+01   0.000000000000000e+00
                1.934424367730638e+01   4.074672743325112e+01   0.000000000000000e+00
                1.936345053008628e+01   4.066990002213155e+01   0.000000000000000e+00
                1.930582997174659e+01   4.062508403231179e+01   0.000000000000000e+00
                1.940186423564607e+01   4.054825662119221e+01   0.000000000000000e+00
                1.938905966712614e+01   4.048423377859256e+01   0.000000000000000e+00
                1.946588707824571e+01   4.039460179895305e+01   0.000000000000000e+00
                1.945308250972579e+01   4.031777438783347e+01   0.000000000000000e+00
                1.931863454026652e+01   4.038819951469309e+01   0.000000000000000e+00
                1.940826651990603e+01   4.028576296653365e+01   0.000000000000000e+00
                1.948509393102561e+01   4.018332641837421e+01   0.000000000000000e+00
                1.963234646900480e+01   4.012570586003453e+01   0.000000000000000e+00
                1.974758758568417e+01   4.007448758595481e+01   0.000000000000000e+00
                1.983721956532368e+01   3.998485560631529e+01   0.000000000000000e+00
                1.992685154496319e+01   3.990802819519572e+01   0.000000000000000e+00
                2.000367895608277e+01   3.984400535259607e+01   0.000000000000000e+00
                1.997806981904291e+01   3.970955738313680e+01   0.000000000000000e+00
                2.017013834684186e+01   3.959431626645743e+01   0.000000000000000e+00
                2.016373606258189e+01   3.950468428681793e+01   0.000000000000000e+00
                2.019574748388172e+01   3.945986829699817e+01   0.000000000000000e+00
                2.020214976814168e+01   3.942145459143838e+01   0.000000000000000e+00
                2.032379316908102e+01   3.927420205345918e+01   0.000000000000000e+00
                2.047104570706021e+01   3.925499520067929e+01   0.000000000000000e+00
                2.075914849875863e+01   3.895408784046094e+01   0.000000000000000e+00
                2.081036677283835e+01   3.896049012472091e+01   0.000000000000000e+00
                2.082317134135829e+01   3.906932895714031e+01   0.000000000000000e+00
                2.091280332099780e+01   3.897329469324083e+01   0.000000000000000e+00
                2.102164215341720e+01   3.901170839880062e+01   0.000000000000000e+00
                2.110487184879674e+01   3.898609926176076e+01   0.000000000000000e+00
                2.116249240713643e+01   3.893488098768104e+01   0.000000000000000e+00
                2.116889469139639e+01   3.884524900804153e+01   0.000000000000000e+00
                2.110487184879674e+01   3.887085814508139e+01   0.000000000000000e+00
                2.099603301637734e+01   3.890286956638122e+01   0.000000000000000e+00
                2.093841245803765e+01   3.890286956638122e+01   0.000000000000000e+00
                2.081036677283835e+01   3.890927185064118e+01   0.000000000000000e+00
                2.079115992005846e+01   3.886445586082143e+01   0.000000000000000e+00
                2.074634393023871e+01   3.882604215526164e+01   0.000000000000000e+00
                2.077835535153853e+01   3.876201931266199e+01   0.000000000000000e+00
                2.087438961543801e+01   3.876201931266199e+01   0.000000000000000e+00
                2.090640103673783e+01   3.869159418580237e+01   0.000000000000000e+00
                2.091920560525776e+01   3.865318048024258e+01   0.000000000000000e+00
                2.097682616359744e+01   3.862757134320272e+01   0.000000000000000e+00
                2.101523986915723e+01   3.856354850060308e+01   0.000000000000000e+00
                2.114328555435653e+01   3.840349139410395e+01   0.000000000000000e+00
                2.113048098583660e+01   3.832666398298437e+01   0.000000000000000e+00
                2.123931981825601e+01   3.830105484594451e+01   0.000000000000000e+00
                2.134175636641545e+01   3.837147997280412e+01   0.000000000000000e+00
                2.148260662013467e+01   3.827544570890466e+01   0.000000000000000e+00
                2.171308885349341e+01   3.832666398298437e+01   0.000000000000000e+00
                2.189875509703240e+01   3.835867540428420e+01   0.000000000000000e+00
                2.198198479241194e+01   3.837147997280412e+01   0.000000000000000e+00
                2.207801905631142e+01   3.835227312002423e+01   0.000000000000000e+00
                2.212923733039113e+01   3.833946855150430e+01   0.000000000000000e+00
                2.220606474151072e+01   3.834587083576427e+01   0.000000000000000e+00
                2.224447844707051e+01   3.832666398298437e+01   0.000000000000000e+00
                2.234691499522994e+01   3.835867540428420e+01   0.000000000000000e+00
                2.237252413226980e+01   3.840989367836391e+01   0.000000000000000e+00
                2.242374240634952e+01   3.840989367836391e+01   0.000000000000000e+00
                2.248136296468921e+01   3.836507768854416e+01   0.000000000000000e+00
                2.250056981746910e+01   3.833306626724433e+01   0.000000000000000e+00
                2.252617895450896e+01   3.827544570890466e+01   0.000000000000000e+00
                2.261581093414847e+01   3.833306626724433e+01   0.000000000000000e+00
                2.266062692396823e+01   3.835867540428420e+01   0.000000000000000e+00
                2.275666118786770e+01   3.825623885612476e+01   0.000000000000000e+00
                2.280787946194742e+01   3.821782515056497e+01   0.000000000000000e+00
                2.306397083234602e+01   3.819221601352511e+01   0.000000000000000e+00
                2.317921194902539e+01   3.816660687648525e+01   0.000000000000000e+00
                2.319201651754532e+01   3.810898631814556e+01   0.000000000000000e+00
                2.298074113696647e+01   3.803856119128595e+01   0.000000000000000e+00
                2.297163452783510e+01   3.796539076493566e+01   0.000000000000000e+00
                2.306126650747461e+01   3.790777020659598e+01   0.000000000000000e+00
                2.317010533989401e+01   3.795898848067570e+01   0.000000000000000e+00
                2.327254188805345e+01   3.797819533345560e+01   0.000000000000000e+00
                2.339418528899279e+01   3.795898848067570e+01   0.000000000000000e+00
                2.343259899455258e+01   3.797819533345560e+01   0.000000000000000e+00
                2.346461041585240e+01   3.801020675475542e+01   0.000000000000000e+00
                2.357985153253177e+01   3.802941360753531e+01   0.000000000000000e+00
                2.360546066957163e+01   3.792697705937587e+01   0.000000000000000e+00
                2.371429950199104e+01   3.786295421677622e+01   0.000000000000000e+00
                2.377192006033072e+01   3.779252908991661e+01   0.000000000000000e+00
                2.381673605015047e+01   3.777332223713672e+01   0.000000000000000e+00
                2.388075889275012e+01   3.777332223713672e+01   0.000000000000000e+00
                2.393197716682985e+01   3.770929939453707e+01   0.000000000000000e+00
                2.398319544090957e+01   3.767088568897728e+01   0.000000000000000e+00
                2.402801143072932e+01   3.767088568897728e+01   0.000000000000000e+00
                2.406642513628911e+01   3.772210396305699e+01   0.000000000000000e+00
                2.405362056776918e+01   3.776691995287675e+01   0.000000000000000e+00
                2.402160914646935e+01   3.780533365843654e+01   0.000000000000000e+00
                2.402160914646935e+01   3.784374736399633e+01   0.000000000000000e+00
                2.400240229368946e+01   3.786935650103619e+01   0.000000000000000e+00
                2.400240229368946e+01   3.791417249085595e+01   0.000000000000000e+00
                2.398319544090957e+01   3.793978162789580e+01   0.000000000000000e+00
                2.398319544090957e+01   3.802941360753531e+01   0.000000000000000e+00
                2.398319544090957e+01   3.812544787143479e+01   0.000000000000000e+00
                2.402160914646935e+01   3.814465472421468e+01   0.000000000000000e+00
                2.406002285202914e+01   3.815745929273461e+01   0.000000000000000e+00
                2.399600000942949e+01   3.823428670385420e+01   0.000000000000000e+00
                2.388716117701009e+01   3.829830954645384e+01   0.000000000000000e+00
                2.380393148163055e+01   3.831111411497377e+01   0.000000000000000e+00
                2.367588579643125e+01   3.832391868349370e+01   0.000000000000000e+00
                2.358625381679174e+01   3.837513695757342e+01   0.000000000000000e+00
                2.355424239549191e+01   3.845196436869300e+01   0.000000000000000e+00
                2.350302412141219e+01   3.849678035851276e+01   0.000000000000000e+00
                2.336857615195293e+01   3.849678035851276e+01   0.000000000000000e+00
                2.329174874083335e+01   3.852879177981258e+01   0.000000000000000e+00
                2.331735787787321e+01   3.860561919093216e+01   0.000000000000000e+00
                2.320851904545381e+01   3.865043518075191e+01   0.000000000000000e+00
                2.304205965469472e+01   3.868244660205174e+01   0.000000000000000e+00
                2.295242767505521e+01   3.874646944465139e+01   0.000000000000000e+00
                2.283718655837584e+01   3.875287172891135e+01   0.000000000000000e+00
                2.271554315743650e+01   3.880409000299107e+01   0.000000000000000e+00
                2.267712945187672e+01   3.882969914003093e+01   0.000000000000000e+00
                2.260670432501710e+01   3.884250370855086e+01   0.000000000000000e+00
                2.252347462963755e+01   3.886171056133076e+01   0.000000000000000e+00
                2.256829061945731e+01   3.889372198263058e+01   0.000000000000000e+00
                2.264511803057689e+01   3.890652655115051e+01   0.000000000000000e+00
                2.275395686299629e+01   3.886811284559072e+01   0.000000000000000e+00
                2.290120940097549e+01   3.894494025671030e+01   0.000000000000000e+00
                2.297163452783510e+01   3.896414710949020e+01   0.000000000000000e+00
                2.298443909635503e+01   3.903457223634981e+01   0.000000000000000e+00
                2.292681853801535e+01   3.909859507894946e+01   0.000000000000000e+00
                2.291401396949542e+01   3.914341106876922e+01   0.000000000000000e+00
                2.283078427411587e+01   3.917542249006904e+01   0.000000000000000e+00
                2.281157742133598e+01   3.923304304840872e+01   0.000000000000000e+00
                2.280517513707601e+01   3.925865218544858e+01   0.000000000000000e+00
                2.287560026393563e+01   3.927785903822848e+01   0.000000000000000e+00
                2.290761168523545e+01   3.933547959656816e+01   0.000000000000000e+00
                2.295882995931517e+01   3.934188188082813e+01   0.000000000000000e+00
                2.306766879173458e+01   3.929706589100837e+01   0.000000000000000e+00
                2.315730077137409e+01   3.923304304840872e+01   0.000000000000000e+00
                2.316370305563405e+01   3.916261792154911e+01   0.000000000000000e+00
                2.306766879173458e+01   3.908579051042953e+01   0.000000000000000e+00
                2.320211676119384e+01   3.911139964746939e+01   0.000000000000000e+00
                2.329174874083335e+01   3.916261792154911e+01   0.000000000000000e+00
                2.333656473065311e+01   3.919462934284893e+01   0.000000000000000e+00
                2.319571447693388e+01   3.938029558638792e+01   0.000000000000000e+00
                2.311248478155433e+01   3.944431842898756e+01   0.000000000000000e+00
                2.309968021303440e+01   3.948273213454735e+01   0.000000000000000e+00
                2.300364594913493e+01   3.952754812436712e+01   0.000000000000000e+00
                2.292681853801535e+01   3.957236411418687e+01   0.000000000000000e+00
                2.288200254819559e+01   3.964919152530645e+01   0.000000000000000e+00
                2.286279569541570e+01   3.968760523086623e+01   0.000000000000000e+00
                2.281797970559595e+01   3.972601893642602e+01   0.000000000000000e+00
                2.279877285281605e+01   3.979644406328564e+01   0.000000000000000e+00
                2.261310660927706e+01   3.996290345404473e+01   0.000000000000000e+00
                2.252987691389752e+01   4.011015599202392e+01   0.000000000000000e+00
                2.261310660927706e+01   4.034704050964262e+01   0.000000000000000e+00
                2.259389975649717e+01   4.041106335224227e+01   0.000000000000000e+00
                2.261310660927706e+01   4.048148847910189e+01   0.000000000000000e+00
                2.269633630465661e+01   4.052630446892164e+01   0.000000000000000e+00
                2.279877285281605e+01   4.057752274300137e+01   0.000000000000000e+00
                2.289480711671552e+01   4.061593644856115e+01   0.000000000000000e+00
                2.297163452783510e+01   4.054551132170154e+01   0.000000000000000e+00
                2.283078427411587e+01   4.047508619484192e+01   0.000000000000000e+00
                2.290120940097549e+01   4.037905193094245e+01   0.000000000000000e+00
                2.299724366487496e+01   4.031502908834280e+01   0.000000000000000e+00
                2.312528935007426e+01   4.027021309852304e+01   0.000000000000000e+00
                2.320851904545381e+01   4.023820167722322e+01   0.000000000000000e+00
                2.331735787787321e+01   4.015497198184368e+01   0.000000000000000e+00
                2.334936929917303e+01   4.000771944386448e+01   0.000000000000000e+00
                2.340058757325275e+01   3.996930573830469e+01   0.000000000000000e+00
                2.352863325845205e+01   3.993089203274491e+01   0.000000000000000e+00
                2.362466752235153e+01   3.990528289570504e+01   0.000000000000000e+00
                2.370149493347111e+01   3.989888061144508e+01   0.000000000000000e+00
                2.373990863903089e+01   3.989888061144508e+01   0.000000000000000e+00
                2.368228808069121e+01   3.996930573830469e+01   0.000000000000000e+00
                2.360546066957163e+01   4.000131715960452e+01   0.000000000000000e+00
                2.350302412141219e+01   4.003973086516431e+01   0.000000000000000e+00
                2.344540356307251e+01   4.003332858090435e+01   0.000000000000000e+00
                2.341339214177268e+01   4.012936284480381e+01   0.000000000000000e+00
                2.333656473065311e+01   4.018698340314350e+01   0.000000000000000e+00
                2.338138072047286e+01   4.025100624574315e+01   0.000000000000000e+00
                2.348381726863230e+01   4.025100624574315e+01   0.000000000000000e+00
                2.356704696401184e+01   4.021259254018336e+01   0.000000000000000e+00
                2.365667894365135e+01   4.019338568740346e+01   0.000000000000000e+00
                2.370149493347111e+01   4.017417883462358e+01   0.000000000000000e+00
                2.380393148163055e+01   4.006534000220417e+01   0.000000000000000e+00
                2.384874747145030e+01   3.998851259108459e+01   0.000000000000000e+00
                2.391277031404995e+01   3.996930573830469e+01   0.000000000000000e+00
                2.397039087238964e+01   3.996930573830469e+01   0.000000000000000e+00
                2.398319544090957e+01   4.000771944386448e+01   0.000000000000000e+00
                2.397679315664960e+01   4.005253543368424e+01   0.000000000000000e+00
                2.397679315664960e+01   4.010375370776396e+01   0.000000000000000e+00
                2.395758630386970e+01   4.013576512906378e+01   0.000000000000000e+00
                2.380393148163055e+01   4.019338568740346e+01   0.000000000000000e+00
                2.375271320755083e+01   4.025100624574315e+01   0.000000000000000e+00
                2.371429950199104e+01   4.029582223556291e+01   0.000000000000000e+00
                2.370149493347111e+01   4.030862680408283e+01   0.000000000000000e+00
                2.384874747145030e+01   4.034704050964262e+01   0.000000000000000e+00
                2.393197716682985e+01   4.035984507816256e+01   0.000000000000000e+00
                2.404081599924925e+01   4.031502908834280e+01   0.000000000000000e+00
                2.418806853722844e+01   4.021259254018336e+01   0.000000000000000e+00
                2.429690736964785e+01   4.012296056054385e+01   0.000000000000000e+00
                2.434172335946760e+01   4.014856969758371e+01   0.000000000000000e+00
                2.438013706502739e+01   4.019978797166343e+01   0.000000000000000e+00
                2.424568909556813e+01   4.030862680408283e+01   0.000000000000000e+00
                2.408563198906900e+01   4.037905193094245e+01   0.000000000000000e+00
                2.401520686220939e+01   4.039825878372235e+01   0.000000000000000e+00
                2.393197716682985e+01   4.039825878372235e+01   0.000000000000000e+00
                2.383594290293037e+01   4.044307477354210e+01   0.000000000000000e+00
                2.389996574553002e+01   4.050709761614175e+01   0.000000000000000e+00
                2.385514975571026e+01   4.057752274300137e+01   0.000000000000000e+00
                2.377832234459068e+01   4.059032731152129e+01   0.000000000000000e+00
                2.370789721773107e+01   4.065435015412094e+01   0.000000000000000e+00
                2.377832234459068e+01   4.076318898654035e+01   0.000000000000000e+00
                2.391917259830991e+01   4.073117756524052e+01   0.000000000000000e+00
                2.404721828350921e+01   4.069276385968073e+01   0.000000000000000e+00
                2.414965483166865e+01   4.071197071246063e+01   0.000000000000000e+00
                2.419447082148841e+01   4.078239583932024e+01   0.000000000000000e+00
                2.432251650668771e+01   4.086562553469979e+01   0.000000000000000e+00
                2.448897589744680e+01   4.093605066155940e+01   0.000000000000000e+00
                2.452738960300658e+01   4.093605066155940e+01   0.000000000000000e+00
                2.461061929838613e+01   4.087843010321971e+01   0.000000000000000e+00
                2.468744670950571e+01   4.084641868191989e+01   0.000000000000000e+00
                2.476427412062529e+01   4.085282096617986e+01   0.000000000000000e+00
                2.486671066878473e+01   4.089763695599961e+01   0.000000000000000e+00
                2.502676777528385e+01   4.096165979859926e+01   0.000000000000000e+00
                2.507934276593231e+01   4.098310669451760e+01   0.000000000000000e+00
                2.517779341954283e+01   4.097490247338339e+01   0.000000000000000e+00
                2.525573352031782e+01   4.092157503601103e+01   0.000000000000000e+00
                2.539110316903228e+01   4.089286026204130e+01   0.000000000000000e+00
                2.549775804377701e+01   4.086004337750446e+01   0.000000000000000e+00
                2.561671925022305e+01   4.084363493523604e+01   0.000000000000000e+00
                2.572747623553488e+01   4.084363493523604e+01   0.000000000000000e+00
                2.582182477857829e+01   4.084363493523604e+01   0.000000000000000e+00
                2.590386698992039e+01   4.080671594013209e+01   0.000000000000000e+00
                2.603513452806775e+01   4.079851171899789e+01   0.000000000000000e+00
                2.604333874920196e+01   4.072057161822289e+01   0.000000000000000e+00
                2.605154297033616e+01   4.067544840198474e+01   0.000000000000000e+00
                2.604744085976906e+01   4.062212096461238e+01   0.000000000000000e+00
                2.613358518167826e+01   4.071646950765579e+01   0.000000000000000e+00
                2.632228226776509e+01   4.094208558884655e+01   0.000000000000000e+00
                2.635509915230193e+01   4.108155734812812e+01   0.000000000000000e+00
                2.639201814740587e+01   4.118411011230575e+01   0.000000000000000e+00
                2.641663081080850e+01   4.122102910740968e+01   0.000000000000000e+00
                2.662173633916374e+01   4.131947976102020e+01   0.000000000000000e+00
                2.660943000746243e+01   4.144254307803335e+01   0.000000000000000e+00
                2.659712367576111e+01   4.148356418370440e+01   0.000000000000000e+00
                2.660532789689533e+01   4.157791272674781e+01   0.000000000000000e+00
                2.639201814740587e+01   4.169277182262675e+01   0.000000000000000e+00
                2.634279282060061e+01   4.168046549092544e+01   0.000000000000000e+00
                2.621972950358747e+01   4.170918026489517e+01   0.000000000000000e+00
                2.612948307111116e+01   4.170507815432806e+01   0.000000000000000e+00
                2.616640206621510e+01   4.147946207313729e+01   0.000000000000000e+00
                2.615819784508089e+01   4.140562408292941e+01   0.000000000000000e+00
                2.598590920126249e+01   4.132358187158731e+01   0.000000000000000e+00
                2.598590920126249e+01   4.129076498705047e+01   0.000000000000000e+00
                2.583823322084671e+01   4.130307131875178e+01   0.000000000000000e+00
                2.580131422574277e+01   4.127025443421495e+01   0.000000000000000e+00
                2.561671925022305e+01   4.127845865534916e+01   0.000000000000000e+00
                2.554288126001516e+01   4.124153966024521e+01   0.000000000000000e+00
                2.544853271697175e+01   4.123333543911100e+01   0.000000000000000e+00
                2.536238839506255e+01   4.121282488627548e+01   0.000000000000000e+00
                2.524752929918361e+01   4.126205021308073e+01   0.000000000000000e+00
                2.520650819351256e+01   4.126205021308073e+01   0.000000000000000e+00
                2.505473010252968e+01   4.133999031385573e+01   0.000000000000000e+00
                2.493166678551653e+01   4.133999031385573e+01   0.000000000000000e+00
                2.487013512700996e+01   4.131947976102020e+01   0.000000000000000e+00
                2.480860346850339e+01   4.132358187158731e+01   0.000000000000000e+00
                2.456657894504420e+01   4.151227895767413e+01   0.000000000000000e+00
                2.445992407029947e+01   4.151227895767413e+01   0.000000000000000e+00
                2.443941351746395e+01   4.148356418370440e+01   0.000000000000000e+00
                2.427532909477975e+01   4.148766629427151e+01   0.000000000000000e+00
                2.421789954684029e+01   4.151638106824124e+01   0.000000000000000e+00
                2.410714256152845e+01   4.149587051540571e+01   0.000000000000000e+00
                2.399228346564952e+01   4.147946207313729e+01   0.000000000000000e+00
                2.394305813884426e+01   4.144254307803335e+01   0.000000000000000e+00
                2.375025894219033e+01   4.139741986179520e+01   0.000000000000000e+00
                2.363950195687850e+01   4.134819453498994e+01   0.000000000000000e+00
                2.345900909192588e+01   4.136050086669125e+01   0.000000000000000e+00
                2.340978376512063e+01   4.138511353009388e+01   0.000000000000000e+00
                2.295855160273909e+01   4.133999031385573e+01   0.000000000000000e+00
                2.280267140118910e+01   4.120051855457417e+01   0.000000000000000e+00
                2.273703763211542e+01   4.112668056436628e+01   0.000000000000000e+00
                2.267550597360885e+01   4.112668056436628e+01   0.000000000000000e+00
                2.256064687772992e+01   4.108976156926234e+01   0.000000000000000e+00
                2.243758356071677e+01   4.110617001153076e+01   0.000000000000000e+00
                2.235964345994178e+01   4.110617001153076e+01   0.000000000000000e+00
                2.224068225349573e+01   4.113078267493339e+01   0.000000000000000e+00
                2.220786536895890e+01   4.114719111720181e+01   0.000000000000000e+00
                2.214223159988522e+01   4.111437423266496e+01   0.000000000000000e+00
                2.168279521636947e+01   4.090516659374262e+01   0.000000000000000e+00
                2.158434456275895e+01   4.088875815147420e+01   0.000000000000000e+00
                2.140385169780634e+01   4.090106448317552e+01   0.000000000000000e+00
                2.097723219882743e+01   4.077800116616237e+01   0.000000000000000e+00
                2.103876385733400e+01   4.059750830120975e+01   0.000000000000000e+00
                2.101825330449848e+01   4.056879352724002e+01   0.000000000000000e+00
                2.089929209805244e+01   4.049905764759924e+01   0.000000000000000e+00
                2.085416888181429e+01   4.049085342646502e+01   0.000000000000000e+00
                2.072290134366693e+01   4.028164578754268e+01   0.000000000000000e+00
                2.068188023799588e+01   4.022831835017031e+01   0.000000000000000e+00
                2.044395782510380e+01   4.006833603805322e+01   0.000000000000000e+00
                2.035371139262749e+01   3.998629382671113e+01   0.000000000000000e+00
                2.032089450809065e+01   3.977298407722167e+01   0.000000000000000e+00
                2.028397551298671e+01   3.970324819758089e+01   0.000000000000000e+00
                2.018552485937619e+01   3.968273764474537e+01   0.000000000000000e+00
                2.005912857752728e+01   3.965415106173085e+01   0.000000000000000e+00
        <NODES>
                2.436151644101763e+01   3.767787831319274e+01   0.000000000000000e+00
                2.438612910442027e+01   3.763275509695459e+01   0.000000000000000e+00
                2.433690377761501e+01   3.757122343844802e+01   0.000000000000000e+00
                2.428767845080975e+01   3.753840655391118e+01   0.000000000000000e+00
                2.426716789797423e+01   3.755891710674670e+01   0.000000000000000e+00
                2.430408689307817e+01   3.766146987092432e+01   0.000000000000000e+00
                2.436151644101763e+01   3.767787831319274e+01   0.000000000000000e+00
        <NODES>
                2.062801600099852e+01   4.194069713599350e+01   0.000000000000000e+00
                2.059596826219302e+01   4.180449424607010e+01   0.000000000000000e+00
                2.053988471928338e+01   4.163624361734119e+01   0.000000000000000e+00
                2.049181311107512e+01   4.150805266211916e+01   0.000000000000000e+00
                2.056392052338751e+01   4.118757527406409e+01   0.000000000000000e+00
                2.068409954390816e+01   4.102733658003656e+01   0.000000000000000e+00
                2.093246951965084e+01   4.091516949421729e+01   0.000000000000000e+00
                2.098855306256048e+01   4.086709788600903e+01   0.000000000000000e+00
                2.101258886666461e+01   4.081101434309939e+01   0.000000000000000e+00
        <NODES>
                2.573809501366939e+01   3.636017143672672e+01   0.000000000000000e+00
                2.577398848113155e+01   3.640632018060664e+01   0.000000000000000e+00
                2.582526486322037e+01   3.638068198956224e+01   0.000000000000000e+00
                2.584577541605589e+01   3.637555435135336e+01   0.000000000000000e+00
                2.578424375754932e+01   3.634991616030895e+01   0.000000000000000e+00
                2.573809501366939e+01   3.636017143672672e+01   0.000000000000000e+00
        <NODES>
                2.692770707812980e+01   3.676525485522832e+01   0.000000000000000e+00
                2.711742969185840e+01   3.686780761940594e+01   0.000000000000000e+00
                2.720459954140938e+01   3.689857344865923e+01   0.000000000000000e+00
                2.726613119991595e+01   3.690882872507699e+01   0.000000000000000e+00
                2.729689702916924e+01   3.688831817224147e+01   0.000000000000000e+00
                2.725587592349819e+01   3.683704179015265e+01   0.000000000000000e+00
                2.718408898857385e+01   3.678063776985496e+01   0.000000000000000e+00
                2.707128094797847e+01   3.673961666418391e+01   0.000000000000000e+00
                2.696360054559197e+01   3.669859555851286e+01   0.000000000000000e+00
                2.695334526917421e+01   3.672936138776615e+01   0.000000000000000e+00
                2.692770707812980e+01   3.676525485522832e+01   0.000000000000000e+00
        <NODES>
                1.971623515844598e+01   3.978604266729660e+01   0.000000000000000e+00
                1.983929847545913e+01   3.978604266729660e+01   0.000000000000000e+00
                1.988852380226439e+01   3.977373633559528e+01   0.000000000000000e+00
                1.992134068680123e+01   3.976143000389397e+01   0.000000000000000e+00
                1.987621747056307e+01   3.972040889822292e+01   0.000000000000000e+00
                1.984750269659334e+01   3.968348990311897e+01   0.000000000000000e+00
                1.984340058602623e+01   3.965477512914924e+01   0.000000000000000e+00
                1.988031958113018e+01   3.960554980234399e+01   0.000000000000000e+00
                1.991723857623412e+01   3.958914136007557e+01   0.000000000000000e+00
                1.992134068680123e+01   3.951940548043478e+01   0.000000000000000e+00
                1.996646390303938e+01   3.946607804306242e+01   0.000000000000000e+00
                2.002389345097885e+01   3.944146537965979e+01   0.000000000000000e+00
                2.010183355175384e+01   3.940454638455584e+01   0.000000000000000e+00
                2.008132299891832e+01   3.939224005285453e+01   0.000000000000000e+00
                2.004030189324727e+01   3.938813794228742e+01   0.000000000000000e+00
                1.998697445587490e+01   3.939634216342164e+01   0.000000000000000e+00
                1.992544279736833e+01   3.942095482682426e+01   0.000000000000000e+00
                1.985570691772755e+01   3.945377171136110e+01   0.000000000000000e+00
                1.981878792262360e+01   3.955632447553872e+01   0.000000000000000e+00
                1.975725626411703e+01   3.962606035517950e+01   0.000000000000000e+00
                1.970392882674467e+01   3.967118357141766e+01   0.000000000000000e+00
                1.967931616334204e+01   3.970810256652160e+01   0.000000000000000e+00
                1.965470349993941e+01   3.976553211446107e+01   0.000000000000000e+00
                1.965060138937231e+01   3.978194055672950e+01   0.000000000000000e+00
                1.968341827390914e+01   3.979014477786370e+01   0.000000000000000e+00
                1.971623515844598e+01   3.978604266729660e+01   0.000000000000000e+00
        <NODES>
                2.450057798924249e+01   3.894625090054157e+01   0.000000000000000e+00
                2.458262020058459e+01   3.891671570445841e+01   0.000000000000000e+00
                2.463512721584353e+01   3.883467349311631e+01   0.000000000000000e+00
                2.462856383893616e+01   3.879529323167210e+01   0.000000000000000e+00
                2.462856383893616e+01   3.876575803558895e+01   0.000000000000000e+00
                2.458590188903827e+01   3.876247634713527e+01   0.000000000000000e+00
                2.454652162759407e+01   3.877560310095001e+01   0.000000000000000e+00
                2.453011318532565e+01   3.883795518157000e+01   0.000000000000000e+00
                2.448416954697407e+01   3.885764531229210e+01   0.000000000000000e+00
                2.445463435089092e+01   3.888718050837526e+01   0.000000000000000e+00
                2.443822590862250e+01   3.892656076981947e+01   0.000000000000000e+00
                2.450057798924249e+01   3.894625090054157e+01   0.000000000000000e+00
        <NODES>
                2.487017815133864e+01   3.748918122710592e+01   0.000000000000000e+00
                2.490709714644258e+01   3.751789600107566e+01   0.000000000000000e+00
                2.495632247324784e+01   3.750558966937434e+01   0.000000000000000e+00
                2.497273091551626e+01   3.743585378973356e+01   0.000000000000000e+00
                2.495632247324784e+01   3.739893479462961e+01   0.000000000000000e+00
                2.487838237247285e+01   3.737022002065988e+01   0.000000000000000e+00
                2.486607604077154e+01   3.746046645313618e+01   0.000000000000000e+00
                2.487017815133864e+01   3.748918122710592e+01   0.000000000000000e+00
        <NODES>
                2.549709601785197e+01   4.048792019487600e+01   0.000000000000000e+00
                2.557913822919407e+01   4.050843074771152e+01   0.000000000000000e+00
                2.565092516411841e+01   4.048279255666711e+01   0.000000000000000e+00
                2.570220154620721e+01   4.044177145099606e+01   0.000000000000000e+00
                2.567656335516281e+01   4.043151617457831e+01   0.000000000000000e+00
                2.559452114382071e+01   4.043151617457831e+01   0.000000000000000e+00
                2.552786184710526e+01   4.044177145099606e+01   0.000000000000000e+00
                2.550735129426973e+01   4.045715436562271e+01   0.000000000000000e+00
                2.549709601785197e+01   4.048792019487600e+01   0.000000000000000e+00
        <NODES>
                2.635180249728976e+01   4.168271791009772e+01   0.000000000000000e+00
                2.640217875042454e+01   4.180425410471811e+01   0.000000000000000e+00
                2.656113553489986e+01   4.186065812501580e+01   0.000000000000000e+00
                2.670470940474853e+01   4.192731742173126e+01   0.000000000000000e+00
                2.696621895340147e+01   4.197346616561119e+01   0.000000000000000e+00
        <NODES>
                2.600646277842669e+01   3.859675108022424e+01   0.000000000000000e+00
                2.613362820600694e+01   3.852701520058346e+01   0.000000000000000e+00
                2.613362820600694e+01   3.837523710960058e+01   0.000000000000000e+00
                2.614593453770826e+01   3.832601178279531e+01   0.000000000000000e+00
                2.611721976373853e+01   3.825627590315453e+01   0.000000000000000e+00
                2.606799443693327e+01   3.821115268691638e+01   0.000000000000000e+00
                2.601466699956090e+01   3.818243791294665e+01   0.000000000000000e+00
                2.596954378332275e+01   3.816602947067823e+01   0.000000000000000e+00
                2.590391001424907e+01   3.821935690805059e+01   0.000000000000000e+00
                2.589570579311486e+01   3.824807168202032e+01   0.000000000000000e+00
                2.592442056708460e+01   3.830550122995979e+01   0.000000000000000e+00
                2.599825855729248e+01   3.835062444619794e+01   0.000000000000000e+00
                2.597774800445696e+01   3.840805399413741e+01   0.000000000000000e+00
                2.593262478821881e+01   3.845727932094267e+01   0.000000000000000e+00
                2.588750157198065e+01   3.850240253718083e+01   0.000000000000000e+00
                2.584648046630960e+01   3.853932153228477e+01   0.000000000000000e+00
                2.586699101914513e+01   3.855572997455319e+01   0.000000000000000e+00
                2.591211423538328e+01   3.856393419568739e+01   0.000000000000000e+00
                2.594493111992012e+01   3.858444474852292e+01   0.000000000000000e+00
                2.600646277842669e+01   3.859675108022424e+01   0.000000000000000e+00
        <NODES>
                2.354397862408916e+01   3.547555770247831e+01   0.000000000000000e+00
                2.358089761919311e+01   3.559041679835725e+01   0.000000000000000e+00
                2.357679550862600e+01   3.564784634629672e+01   0.000000000000000e+00
                2.362191872486416e+01   3.561913157232699e+01   0.000000000000000e+00
                2.363832716713257e+01   3.555349780325331e+01   0.000000000000000e+00
                2.365883771996810e+01   3.553298725041778e+01   0.000000000000000e+00
                2.369165460450494e+01   3.559041679835725e+01   0.000000000000000e+00
                2.370396093620625e+01   3.566015267799803e+01   0.000000000000000e+00
                2.372447148904178e+01   3.568476534140066e+01   0.000000000000000e+00
                2.378190103698125e+01   3.561913157232699e+01   0.000000000000000e+00
                2.382292214265229e+01   3.554939569268620e+01   0.000000000000000e+00
                2.384753480605492e+01   3.553298725041778e+01   0.000000000000000e+00
                2.393367912796413e+01   3.552888513985068e+01   0.000000000000000e+00
                2.401161922873912e+01   3.552478302928358e+01   0.000000000000000e+00
                2.414288676688647e+01   3.547555770247831e+01   0.000000000000000e+00
                2.429056274730225e+01   3.544274081794148e+01   0.000000000000000e+00
                2.445874928055355e+01   3.538941338056911e+01   0.000000000000000e+00
                2.456130204473117e+01   3.538120915943490e+01   0.000000000000000e+00
                2.464744636664037e+01   3.540582182283753e+01   0.000000000000000e+00
                2.465565058777458e+01   3.543863870737437e+01   0.000000000000000e+00
                2.496741099087455e+01   3.543043448624016e+01   0.000000000000000e+00
                2.506175953391797e+01   3.537710704886780e+01   0.000000000000000e+00
                2.522174184603506e+01   3.535659649603227e+01   0.000000000000000e+00
                2.545146003779293e+01   3.535659649603227e+01   0.000000000000000e+00
                2.559503390764160e+01   3.536890282773359e+01   0.000000000000000e+00
                2.576322044089290e+01   3.533198383262965e+01   0.000000000000000e+00
                2.571809722465475e+01   3.526224795298886e+01   0.000000000000000e+00
                2.570989300352054e+01   3.522122684731782e+01   0.000000000000000e+00
                2.575091410919159e+01   3.515559307824414e+01   0.000000000000000e+00
                2.585756898393631e+01   3.512687830427440e+01   0.000000000000000e+00
                2.598063230094946e+01   3.514738885710992e+01   0.000000000000000e+00
                2.611189983909682e+01   3.518020574164677e+01   0.000000000000000e+00
                2.618163571873760e+01   3.524173740015334e+01   0.000000000000000e+00
                2.619804416100602e+01   3.531967750092833e+01   0.000000000000000e+00
                2.631290325688496e+01   3.533608594319675e+01   0.000000000000000e+00
                2.629649481461654e+01   3.524173740015334e+01   0.000000000000000e+00
                2.627598426178101e+01   3.511046986200598e+01   0.000000000000000e+00
                2.618573782930471e+01   3.505304031406651e+01   0.000000000000000e+00
                2.610779772852971e+01   3.502022342952967e+01   0.000000000000000e+00
                2.597242807981525e+01   3.501201920839546e+01   0.000000000000000e+00
                2.578373099372843e+01   3.502432554009678e+01   0.000000000000000e+00
                2.557452335480608e+01   3.499971287669415e+01   0.000000000000000e+00
                2.539813260042057e+01   3.500791709782836e+01   0.000000000000000e+00
                2.523815028830348e+01   3.497510021329152e+01   0.000000000000000e+00
                2.501663631767981e+01   3.495048754988889e+01   0.000000000000000e+00
                2.480742867875746e+01   3.494228332875468e+01   0.000000000000000e+00
                2.474179490968379e+01   3.495458966045599e+01   0.000000000000000e+00
                2.466795691947590e+01   3.508995930917045e+01   0.000000000000000e+00
                2.453258727076144e+01   3.514328674654282e+01   0.000000000000000e+00
                2.442593239601671e+01   3.518840996278097e+01   0.000000000000000e+00
                2.414698887745358e+01   3.517200152051255e+01   0.000000000000000e+00
                2.398290445476938e+01   3.522532895788492e+01   0.000000000000000e+00
                2.387624958002466e+01   3.522532895788492e+01   0.000000000000000e+00
                2.377779892641414e+01   3.524583951072044e+01   0.000000000000000e+00
                2.366704194110231e+01   3.522122684731782e+01   0.000000000000000e+00
                2.359320395089442e+01   3.523353317901913e+01   0.000000000000000e+00
                2.352346807125364e+01   3.529506483752570e+01   0.000000000000000e+00
                2.351936596068653e+01   3.537710704886780e+01   0.000000000000000e+00
                2.351936596068653e+01   3.542223026510595e+01   0.000000000000000e+00
                2.354397862408916e+01   3.547555770247831e+01   0.000000000000000e+00
        <NODES>
                2.542530908292764e+01   3.645246892448657e+01   0.000000000000000e+00
                2.547658546501645e+01   3.641144781881552e+01   0.000000000000000e+00
                2.545094727397204e+01   3.637555435135336e+01   0.000000000000000e+00
                2.539967089188323e+01   3.634991616030895e+01   0.000000000000000e+00
                2.537916033904771e+01   3.637555435135336e+01   0.000000000000000e+00
                2.540479853009212e+01   3.643708600985993e+01   0.000000000000000e+00
                2.542530908292764e+01   3.645246892448657e+01   0.000000000000000e+00
        <NODES>
                2.707640858618735e+01   3.560640862002119e+01   0.000000000000000e+00
                2.715845079752945e+01   3.575511012807875e+01   0.000000000000000e+00
                2.719434426499162e+01   3.580125887195868e+01   0.000000000000000e+00
                2.718921662678274e+01   3.563717444927448e+01   0.000000000000000e+00
                2.722511009424490e+01   3.552436640867910e+01   0.000000000000000e+00
                2.716870607394721e+01   3.544745183554588e+01   0.000000000000000e+00
                2.713794024469393e+01   3.538079253883043e+01   0.000000000000000e+00
                2.709179150081400e+01   3.549360057942581e+01   0.000000000000000e+00
                2.707128094797847e+01   3.556538751435015e+01   0.000000000000000e+00
                2.707640858618735e+01   3.560640862002119e+01   0.000000000000000e+00
        <NODES>
                2.693032548593930e+01   3.765599479373331e+01   0.000000000000000e+00
                2.700336235220885e+01   3.769412740947726e+01   0.000000000000000e+00
                2.706637077051958e+01   3.772038091710673e+01   0.000000000000000e+00
                2.705849471823074e+01   3.777288793236567e+01   0.000000000000000e+00
                2.702775061190804e+01   3.777905811074645e+01   0.000000000000000e+00
                2.693032548593930e+01   3.778418574895534e+01   0.000000000000000e+00
                2.679187925429951e+01   3.782520685462639e+01   0.000000000000000e+00
                2.667907121370412e+01   3.781495157820862e+01   0.000000000000000e+00
                2.659190136415314e+01   3.772778172865765e+01   0.000000000000000e+00
                2.673034759579294e+01   3.771239881403100e+01   0.000000000000000e+00
                2.684828327459720e+01   3.767137770835996e+01   0.000000000000000e+00
                2.693032548593930e+01   3.765599479373331e+01   0.000000000000000e+00
        <NODES>
                2.577398848113155e+01   3.679602068448160e+01   0.000000000000000e+00
                2.584064777784701e+01   3.683704179015265e+01   0.000000000000000e+00
                2.590730707456246e+01   3.688831817224147e+01   0.000000000000000e+00
                2.601498747694896e+01   3.689344581045034e+01   0.000000000000000e+00
                2.605600858262001e+01   3.689344581045034e+01   0.000000000000000e+00
                2.595858345665127e+01   3.684729706657042e+01   0.000000000000000e+00
                2.591243471277134e+01   3.680114832269049e+01   0.000000000000000e+00
                2.580475431038484e+01   3.677038249343720e+01   0.000000000000000e+00
                2.577398848113155e+01   3.679602068448160e+01   0.000000000000000e+00
        <NODES>
                2.342864522167590e+01   3.774319160487837e+01   0.000000000000000e+00
                2.346966632734695e+01   3.776780426828100e+01   0.000000000000000e+00
                2.349838110131668e+01   3.774729371544547e+01   0.000000000000000e+00
                2.350248321188379e+01   3.772268105204284e+01   0.000000000000000e+00
                2.346556421677984e+01   3.768986416750601e+01   0.000000000000000e+00
                2.344915577451142e+01   3.767755783580469e+01   0.000000000000000e+00
                2.342864522167590e+01   3.772678316260995e+01   0.000000000000000e+00
        <NODES>
                2.476762538716102e+01   3.797733238459140e+01   0.000000000000000e+00
                2.493581192041232e+01   3.787067750984667e+01   0.000000000000000e+00
                2.494811825211363e+01   3.776402263510195e+01   0.000000000000000e+00
                2.493991403097942e+01   3.771069519772959e+01   0.000000000000000e+00
                2.484556548793601e+01   3.780094163020589e+01   0.000000000000000e+00
                2.481685071396628e+01   3.784196273587694e+01   0.000000000000000e+00
                2.474711483432549e+01   3.786657539927957e+01   0.000000000000000e+00
                2.470609372865445e+01   3.789939228381641e+01   0.000000000000000e+00
                2.470609372865445e+01   3.797323027402430e+01   0.000000000000000e+00
                2.473891061319129e+01   3.798143449515850e+01   0.000000000000000e+00
                2.476762538716102e+01   3.797733238459140e+01   0.000000000000000e+00
        <NODES>
                2.629700757843743e+01   3.658578751791748e+01   0.000000000000000e+00
                2.634828396052623e+01   3.660117043254412e+01   0.000000000000000e+00
                2.642519853365945e+01   3.658578751791748e+01   0.000000000000000e+00
                2.637392215157064e+01   3.653451113582867e+01   0.000000000000000e+00
                2.632264576948183e+01   3.649861766836651e+01   0.000000000000000e+00
                2.629700757843743e+01   3.654989405045531e+01   0.000000000000000e+00
                2.629700757843743e+01   3.658578751791748e+01   0.000000000000000e+00
        <NODES>
                2.535422719825702e+01   3.708717439152964e+01   0.000000000000000e+00
                2.545677996243464e+01   3.715280816060332e+01   0.000000000000000e+00
                2.550600528923990e+01   3.719382926627437e+01   0.000000000000000e+00
                2.557984327944779e+01   3.712819549720069e+01   0.000000000000000e+00
                2.561266016398462e+01   3.708717439152964e+01   0.000000000000000e+00
                2.555933272661226e+01   3.701333640132175e+01   0.000000000000000e+00
                2.555112850547805e+01   3.697231529565071e+01   0.000000000000000e+00
                2.549369895753858e+01   3.694770263224808e+01   0.000000000000000e+00
                2.544447363073332e+01   3.693949841111387e+01   0.000000000000000e+00
                2.540345252506227e+01   3.700923429075465e+01   0.000000000000000e+00
                2.537473775109254e+01   3.705025539642570e+01   0.000000000000000e+00
                2.535422719825702e+01   3.708717439152964e+01   0.000000000000000e+00
        <NODES>
                2.524584174561680e+01   3.677038249343720e+01   0.000000000000000e+00
                2.528686285128785e+01   3.679089304627273e+01   0.000000000000000e+00
                2.538941561546547e+01   3.669346792030399e+01   0.000000000000000e+00
                2.536890506262995e+01   3.667295736746846e+01   0.000000000000000e+00
                2.532788395695890e+01   3.667295736746846e+01   0.000000000000000e+00
                2.526122466024344e+01   3.674474430239280e+01   0.000000000000000e+00
                2.524584174561680e+01   3.677038249343720e+01   0.000000000000000e+00
        <NODES>
                2.052845305073275e+01   3.837081452164541e+01   0.000000000000000e+00
                2.054896360356828e+01   3.846516306468883e+01   0.000000000000000e+00
                2.063100581491037e+01   3.846106095412172e+01   0.000000000000000e+00
                2.068433325228273e+01   3.846926517525593e+01   0.000000000000000e+00
                2.073355857908799e+01   3.834620185824279e+01   0.000000000000000e+00
                2.077868179532615e+01   3.830518075257174e+01   0.000000000000000e+00
                2.068023114171563e+01   3.832569130540726e+01   0.000000000000000e+00
                2.063510792547748e+01   3.839132507448094e+01   0.000000000000000e+00
                2.062280159377616e+01   3.842003984845067e+01   0.000000000000000e+00
                2.059408681980643e+01   3.842824406958488e+01   0.000000000000000e+00
                2.058998470923932e+01   3.838312085334673e+01   0.000000000000000e+00
                2.061049526207485e+01   3.833799763710858e+01   0.000000000000000e+00
                2.063921003604458e+01   3.827236386803490e+01   0.000000000000000e+00
                2.070074169455116e+01   3.823544487293096e+01   0.000000000000000e+00
                2.073355857908799e+01   3.821903643066253e+01   0.000000000000000e+00
                2.076637546362483e+01   3.814519844045465e+01   0.000000000000000e+00
                2.078278390589325e+01   3.806725833967965e+01   0.000000000000000e+00
                2.070484380511826e+01   3.808776889251518e+01   0.000000000000000e+00
                2.064741425717879e+01   3.810827944535070e+01   0.000000000000000e+00
                2.053665727186696e+01   3.810007522421650e+01   0.000000000000000e+00
                2.048743194506170e+01   3.814519844045465e+01   0.000000000000000e+00
                2.046692139222618e+01   3.820673009896122e+01   0.000000000000000e+00
                2.043820661825644e+01   3.824775120463227e+01   0.000000000000000e+00
                2.042179817598802e+01   3.825185331519938e+01   0.000000000000000e+00
                2.041359395485381e+01   3.817391321442438e+01   0.000000000000000e+00
                2.038487918088408e+01   3.818211743555860e+01   0.000000000000000e+00
                2.036026651748145e+01   3.822724065179675e+01   0.000000000000000e+00
                2.038487918088408e+01   3.829697653143753e+01   0.000000000000000e+00
                2.039308340201829e+01   3.833389552654147e+01   0.000000000000000e+00
                2.046692139222618e+01   3.835030396880989e+01   0.000000000000000e+00
                2.052845305073275e+01   3.837081452164541e+01   0.000000000000000e+00
        <NODES>
                2.772249100050637e+01   3.612942771732706e+01   0.000000000000000e+00
                2.780453321184847e+01   3.625761867254909e+01   0.000000000000000e+00
                2.795836235811490e+01   3.637555435135336e+01   0.000000000000000e+00
                2.820448899214119e+01   3.644734128627769e+01   0.000000000000000e+00
                2.819423371572343e+01   3.631402269284678e+01   0.000000000000000e+00
                2.811219150438134e+01   3.614993827016259e+01   0.000000000000000e+00
                2.801476637841260e+01   3.604225786777609e+01   0.000000000000000e+00
                2.789170306139945e+01   3.598072620926951e+01   0.000000000000000e+00
                2.775838446796854e+01   3.590893927434518e+01   0.000000000000000e+00
                2.772249100050637e+01   3.604225786777609e+01   0.000000000000000e+00
                2.772249100050637e+01   3.612942771732706e+01   0.000000000000000e+00
        <NODES>
                2.301557254200878e+01   4.198075680950039e+01   0.000000000000000e+00
                2.288738158678676e+01   4.198876874420176e+01   0.000000000000000e+00
                2.292744126029364e+01   4.186858972368112e+01   0.000000000000000e+00
                2.297551286850190e+01   4.160419587853568e+01   0.000000000000000e+00
                2.295948899909915e+01   4.145998105391090e+01   0.000000000000000e+00
                2.292744126029364e+01   4.140389751100127e+01   0.000000000000000e+00
                2.294703471161601e+01   4.132968572706140e+01   0.000000000000000e+00
        <NODES>
                2.568169099337169e+01   4.015462371129873e+01   0.000000000000000e+00
                2.581500958680260e+01   4.019564481696978e+01   0.000000000000000e+00
                2.588679652172693e+01   4.020077245517865e+01   0.000000000000000e+00
                2.597909400948679e+01   4.017000662592537e+01   0.000000000000000e+00
                2.599447692411344e+01   4.012898552025432e+01   0.000000000000000e+00
                2.594832818023351e+01   4.011873024383656e+01   0.000000000000000e+00
                2.586115833068253e+01   4.011360260562768e+01   0.000000000000000e+00
                2.580988194859372e+01   4.009821969100103e+01   0.000000000000000e+00
                2.570732918441610e+01   4.012898552025432e+01   0.000000000000000e+00
                2.568169099337169e+01   4.015462371129873e+01   0.000000000000000e+00
        <NODES>
                2.604744085976906e+01   4.062212096461238e+01   0.000000000000000e+00
                2.626841803076773e+01   4.057866823675947e+01   0.000000000000000e+00
                2.645269252889940e+01   4.059469210616222e+01   0.000000000000000e+00
                2.662895509232969e+01   4.061872791026635e+01   0.000000000000000e+00
                2.669305056994070e+01   4.063475177966910e+01   0.000000000000000e+00
                2.677316991695447e+01   4.061071597556497e+01   0.000000000000000e+00
                2.683726539456548e+01   4.058668017146084e+01   0.000000000000000e+00
                2.658088348412143e+01   4.049053695504432e+01   0.000000000000000e+00
                2.637257318188563e+01   4.037836986922505e+01   0.000000000000000e+00
                2.632450157367737e+01   4.033831019571817e+01   0.000000000000000e+00
                2.627642996546911e+01   4.031427439161403e+01   0.000000000000000e+00
                2.627642996546911e+01   4.024216697930164e+01   0.000000000000000e+00
                2.626040609606636e+01   4.017807150169063e+01   0.000000000000000e+00
                2.623637029196223e+01   4.012198795878099e+01   0.000000000000000e+00
                2.624438222666360e+01   4.007391635057273e+01   0.000000000000000e+00
                2.632450157367737e+01   4.008994021997549e+01   0.000000000000000e+00
                2.636456124718426e+01   4.017005956698925e+01   0.000000000000000e+00
                2.638058511658701e+01   4.022614310989889e+01   0.000000000000000e+00
                2.643666865949665e+01   4.023415504460027e+01   0.000000000000000e+00
                2.672509830874621e+01   4.044246534683606e+01   0.000000000000000e+00
                2.690937280687787e+01   4.052258469384983e+01   0.000000000000000e+00
                2.705358763150265e+01   4.054662049795396e+01   0.000000000000000e+00
                2.720581439082881e+01   4.063475177966910e+01   0.000000000000000e+00
                2.736605308485634e+01   4.071487112668287e+01   0.000000000000000e+00
                2.745418436657149e+01   4.085908595130765e+01   0.000000000000000e+00
                2.755833951768939e+01   4.096324110242555e+01   0.000000000000000e+00
                2.765448273410590e+01   4.099528884123106e+01   0.000000000000000e+00
                2.778267368932793e+01   4.098727690652968e+01   0.000000000000000e+00
                2.789484077514721e+01   4.095522916772417e+01   0.000000000000000e+00
                2.813519881618851e+01   4.105137238414069e+01   0.000000000000000e+00
                2.823935396730641e+01   4.108342012294620e+01   0.000000000000000e+00
                2.834350911842430e+01   4.105137238414069e+01   0.000000000000000e+00
        <NODES>
                2.443567490861358e+01   3.712931716805888e+01   0.000000000000000e+00
                2.447669601428463e+01   3.720110410298322e+01   0.000000000000000e+00
                2.452284475816457e+01   3.721648701760986e+01   0.000000000000000e+00
                2.453822767279121e+01   3.718572118835657e+01   0.000000000000000e+00
                2.450746184353792e+01   3.714982772089441e+01   0.000000000000000e+00
                2.447156837607575e+01   3.710367897701448e+01   0.000000000000000e+00
                2.443567490861358e+01   3.712931716805888e+01   0.000000000000000e+00
        <NODES>
                2.530758308596383e+01   3.740739167363044e+01   0.000000000000000e+00
                2.530716062756674e+01   3.740948183251123e+01   0.000000000000000e+00
                2.530945698646551e+01   3.741101796397427e+01   0.000000000000000e+00
                2.531285707129681e+01   3.741183466033484e+01   0.000000000000000e+00
                2.531154310003376e+01   3.741308219661849e+01   0.000000000000000e+00
                2.531317306821223e+01   3.741428749605208e+01   0.000000000000000e+00
                2.531376949311557e+01   3.741866148714383e+01   0.000000000000000e+00
                2.530841320935266e+01   3.742284752731867e+01   0.000000000000000e+00
                2.530613520306998e+01   3.742253690590552e+01   0.000000000000000e+00
                2.530346830149088e+01   3.742329683891586e+01   0.000000000000000e+00
                2.530506703277015e+01   3.742576762506706e+01   0.000000000000000e+00
                2.530236495034551e+01   3.742686746100851e+01   0.000000000000000e+00
                2.530183969052683e+01   3.742935205184774e+01   0.000000000000000e+00
                2.530000981003470e+01   3.743113224105934e+01   0.000000000000000e+00
                2.530675692772056e+01   3.743994206019573e+01   0.000000000000000e+00
                2.531249560554846e+01   3.743786609868919e+01   0.000000000000000e+00
                2.531954451436320e+01   3.743187262163371e+01   0.000000000000000e+00
                2.531959316566323e+01   3.742712062452573e+01   0.000000000000000e+00
                2.532468790124398e+01   3.742716606921141e+01   0.000000000000000e+00
                2.532458236108433e+01   3.743492296653204e+01   0.000000000000000e+00
                2.532331608462362e+01   3.743723915326778e+01   0.000000000000000e+00
                2.532835515730575e+01   3.744011052388359e+01   0.000000000000000e+00
                2.532447407792208e+01   3.744460642103329e+01   0.000000000000000e+00
                2.532546954314774e+01   3.744740047138272e+01   0.000000000000000e+00
                2.532902510912831e+01   3.744748694544953e+01   0.000000000000000e+00
                2.532958152839053e+01   3.744923182306660e+01   0.000000000000000e+00
                2.532784366984934e+01   3.745139377411646e+01   0.000000000000000e+00
                2.532690405663886e+01   3.745582419611038e+01   0.000000000000000e+00
                2.532893056558807e+01   3.746229667901100e+01   0.000000000000000e+00
                2.532243169453864e+01   3.746633777406552e+01   0.000000000000000e+00
                2.531563668861886e+01   3.746898180440751e+01   0.000000000000000e+00
                2.530883572663143e+01   3.747144879534358e+01   0.000000000000000e+00
                2.531320322106896e+01   3.747450338725713e+01   0.000000000000000e+00
                2.531243816434124e+01   3.747823566701578e+01   0.000000000000000e+00
                2.530956664209482e+01   3.747901942554977e+01   0.000000000000000e+00
                2.530889472417012e+01   3.748162769311010e+01   0.000000000000000e+00
                2.531358592468262e+01   3.749203686973697e+01   0.000000000000000e+00
                2.532335225844896e+01   3.749213987018139e+01   0.000000000000000e+00
                2.533240447107157e+01   3.749739408558279e+01   0.000000000000000e+00
                2.533946648629786e+01   3.749706892201930e+01   0.000000000000000e+00
                2.534198734924679e+01   3.749986707295108e+01   0.000000000000000e+00
                2.535877664008062e+01   3.749712114109025e+01   0.000000000000000e+00
                2.536057719835586e+01   3.749290300525774e+01   0.000000000000000e+00
                2.536017723764565e+01   3.748284728836333e+01   0.000000000000000e+00
                2.536291352697625e+01   3.747850699144446e+01   0.000000000000000e+00
                2.535990725444375e+01   3.747559321587564e+01   0.000000000000000e+00
                2.536578963015101e+01   3.747241990924172e+01   0.000000000000000e+00
                2.536826514186831e+01   3.746834127653268e+01   0.000000000000000e+00
                2.537365855078698e+01   3.746450557263099e+01   0.000000000000000e+00
                2.537333900935045e+01   3.746204136560356e+01   0.000000000000000e+00
                2.537663551496517e+01   3.746125527918767e+01   0.000000000000000e+00
                2.537890396802339e+01   3.746242797413279e+01   0.000000000000000e+00
                2.538012039197499e+01   3.746503830592695e+01   0.000000000000000e+00
                2.538061398360138e+01   3.746626051056884e+01   0.000000000000000e+00
                2.538268135125643e+01   3.746796019492761e+01   0.000000000000000e+00
                2.538426006225798e+01   3.746860488782639e+01   0.000000000000000e+00
                2.538146745331682e+01   3.748721632552856e+01   0.000000000000000e+00
                2.538061549448197e+01   3.748812946562638e+01   0.000000000000000e+00
                2.537827278253289e+01   3.749068070560775e+01   0.000000000000000e+00
                2.538691680427242e+01   3.749554717252990e+01   0.000000000000000e+00
                2.539126565547613e+01   3.749357522527588e+01   0.000000000000000e+00
                2.539425629220509e+01   3.749571395113247e+01   0.000000000000000e+00
                2.540246823660168e+01   3.749534206434619e+01   0.000000000000000e+00
                2.540697292015723e+01   3.749118625423908e+01   0.000000000000000e+00
                2.540553203232384e+01   3.748360548387552e+01   0.000000000000000e+00
                2.540946989102039e+01   3.748226188061372e+01   0.000000000000000e+00
                2.541109204342241e+01   3.748364531430567e+01   0.000000000000000e+00
                2.541137956826814e+01   3.748043184516359e+01   0.000000000000000e+00
                2.541835223941533e+01   3.748305049247614e+01   0.000000000000000e+00
                2.541985051883828e+01   3.748076374183541e+01   0.000000000000000e+00
                2.542353395044055e+01   3.748401217060006e+01   0.000000000000000e+00
                2.542424041117378e+01   3.748060735076825e+01   0.000000000000000e+00
                2.542902749062274e+01   3.748212353419312e+01   0.000000000000000e+00
                2.543046084279575e+01   3.747926254962841e+01   0.000000000000000e+00
                2.542876880715210e+01   3.747083811657030e+01   0.000000000000000e+00
                2.546043633591291e+01   3.747423436688406e+01   0.000000000000000e+00
                2.546137157040508e+01   3.745958087205896e+01   0.000000000000000e+00
                2.545762197941386e+01   3.745016094274132e+01   0.000000000000000e+00
                2.545971731783405e+01   3.744693562585746e+01   0.000000000000000e+00
                2.545806799838511e+01   3.744468856731154e+01   0.000000000000000e+00
                2.542219657790855e+01   3.744175226406372e+01   0.000000000000000e+00
                2.541985355992853e+01   3.743917405734378e+01   0.000000000000000e+00
                2.542217959437195e+01   3.743594201293060e+01   0.000000000000000e+00
                2.542389504017494e+01   3.743448842017145e+01   0.000000000000000e+00
                2.542609523412127e+01   3.743407903795492e+01   0.000000000000000e+00
                2.542334800695849e+01   3.743203807435074e+01   0.000000000000000e+00
                2.542011271642084e+01   3.743494567626422e+01   0.000000000000000e+00
                2.541850095269372e+01   3.743322539890969e+01   0.000000000000000e+00
                2.542018594498339e+01   3.743071270908584e+01   0.000000000000000e+00
                2.542018289738019e+01   3.743049702500934e+01   0.000000000000000e+00
                2.541933403428003e+01   3.742972800659012e+01   0.000000000000000e+00
                2.541816283392252e+01   3.742980738045254e+01   0.000000000000000e+00
                2.541663771903963e+01   3.743072751440865e+01   0.000000000000000e+00
                2.541526036784136e+01   3.742994069165908e+01   0.000000000000000e+00
                2.541411494104818e+01   3.743012715361207e+01   0.000000000000000e+00
                2.541378359960356e+01   3.743036735125231e+01   0.000000000000000e+00
                2.541333639478231e+01   3.743138668597847e+01   0.000000000000000e+00
                2.541194647043321e+01   3.743143820825895e+01   0.000000000000000e+00
                2.540865241728438e+01   3.743423434226143e+01   0.000000000000000e+00
                2.540557547370699e+01   3.743324946101328e+01   0.000000000000000e+00
                2.540360332695599e+01   3.743192134679158e+01   0.000000000000000e+00
                2.540448958949293e+01   3.743023617560884e+01   0.000000000000000e+00
                2.540413484573362e+01   3.742980228339577e+01   0.000000000000000e+00
                2.540450311386609e+01   3.742899785414534e+01   0.000000000000000e+00
                2.540501158665348e+01   3.742833272552671e+01   0.000000000000000e+00
                2.540407914729134e+01   3.742674262502343e+01   0.000000000000000e+00
                2.540384475693444e+01   3.742649205857783e+01   0.000000000000000e+00
                2.540394060386039e+01   3.742598039620547e+01   0.000000000000000e+00
                2.540358754166873e+01   3.742561442914140e+01   0.000000000000000e+00
                2.540121357718596e+01   3.742314431254321e+01   0.000000000000000e+00
                2.540135522417991e+01   3.741501177810332e+01   0.000000000000000e+00
                2.539974020688999e+01   3.741347042183731e+01   0.000000000000000e+00
                2.539374630652749e+01   3.741892966862280e+01   0.000000000000000e+00
                2.539256394128199e+01   3.742228424378796e+01   0.000000000000000e+00
                2.538747530153802e+01   3.742240660592317e+01   0.000000000000000e+00
                2.538252483875415e+01   3.742060569139605e+01   0.000000000000000e+00
                2.538132503227860e+01   3.741834937347901e+01   0.000000000000000e+00
                2.537822842441913e+01   3.741844321845372e+01   0.000000000000000e+00
                2.537926199797287e+01   3.741664803152057e+01   0.000000000000000e+00
                2.537849763187492e+01   3.741420121527883e+01   0.000000000000000e+00
                2.537598990742520e+01   3.741249592240435e+01   0.000000000000000e+00
                2.537274326211434e+01   3.741434745763687e+01   0.000000000000000e+00
                2.537012681437677e+01   3.741546183370129e+01   0.000000000000000e+00
                2.536783500422978e+01   3.741342488641961e+01   0.000000000000000e+00
                2.537018313528799e+01   3.741125326254146e+01   0.000000000000000e+00
                2.536941726050837e+01   3.740880342994517e+01   0.000000000000000e+00
                2.536447367170650e+01   3.740684031788732e+01   0.000000000000000e+00
                2.536312789931899e+01   3.740651367297623e+01   0.000000000000000e+00
                2.535842584800801e+01   3.741068103018506e+01   0.000000000000000e+00
                2.535344694943931e+01   3.740849575147773e+01   0.000000000000000e+00
                2.535311388176321e+01   3.740569048570849e+01   0.000000000000000e+00
                2.535076918341279e+01   3.740803563118637e+01   0.000000000000000e+00
                2.534850643694184e+01   3.740686155865371e+01   0.000000000000000e+00
                2.534971658558000e+01   3.740384180889278e+01   0.000000000000000e+00
                2.534695660487621e+01   3.740690054720573e+01   0.000000000000000e+00
                2.534817513143015e+01   3.740968417760050e+01   0.000000000000000e+00
                2.534813257137715e+01   3.741307129255458e+01   0.000000000000000e+00
                2.533822932866009e+01   3.741609068720719e+01   0.000000000000000e+00
                2.533684647840163e+01   3.741437637561420e+01   0.000000000000000e+00
                2.533310473739189e+01   3.741547767820557e+01   0.000000000000000e+00
                2.533394423183394e+01   3.741203716584334e+01   0.000000000000000e+00
                2.533629231909755e+01   3.741191720155992e+01   0.000000000000000e+00
                2.533728962673793e+01   3.740907783102909e+01   0.000000000000000e+00
                2.533183150137154e+01   3.741063812258140e+01   0.000000000000000e+00
                2.532607262880160e+01   3.741709936105823e+01   0.000000000000000e+00
                2.532628945999191e+01   3.742203232989906e+01   0.000000000000000e+00
                2.532227462420614e+01   3.742212186631877e+01   0.000000000000000e+00
                2.532080264481236e+01   3.741846295548508e+01   0.000000000000000e+00
                2.531805444938668e+01   3.741589776088074e+01   0.000000000000000e+00
                2.531859196705455e+01   3.741288762870180e+01   0.000000000000000e+00
                2.531850407160577e+01   3.741060281903534e+01   0.000000000000000e+00
                2.531674538123652e+01   3.741099847636094e+01   0.000000000000000e+00
                2.531439533092460e+01   3.740753885653698e+01   0.000000000000000e+00
                2.531744228994404e+01   3.740605597678816e+01   0.000000000000000e+00
                2.531497890745029e+01   3.740541374242933e+01   0.000000000000000e+00
                2.531343518381928e+01   3.740562797279254e+01   0.000000000000000e+00
                2.531246080881121e+01   3.740830792522994e+01   0.000000000000000e+00
                2.530973895566106e+01   3.740627443762559e+01   0.000000000000000e+00
                2.530916462136154e+01   3.740397808199921e+01   0.000000000000000e+00
                2.530712322517445e+01   3.740210936481998e+01   0.000000000000000e+00
                2.530518137835868e+01   3.740304600940950e+01   0.000000000000000e+00
                2.530758308596383e+01   3.740739167363044e+01   0.000000000000000e+00\
"""
    cs = []
    for dline in greece.split("\n"):
        dline = dline.strip()
        if dline == "<NODES>":
            if len(cs) > 1: yield cs
            cs = []
        else:
            a = list(map(float, dline.split()))  #works for python2,3
            a[0], a[1] = geodp.geodetGRS802en(radians(a[0]), radians(a[1]))
            cs.append(a)
    if len(cs) > 1: yield cs


def thanPoints(geodp):
    "Loop over all predefined points."
    #greece= """\
    #    ΜΑΝΤΖΟΥ13_2OS_OROFOS    4.148278026409000e-01    6.628592078647713e-01        173.000
    #    DAMASIPPOY13_4OS_OROFOS    4.147054553060465e-01    6.628628716911514e-01        108.610
    #    NTUA 37.97727573700102  23.781804330869225 191.236"""
    greece= """\
        NTUA  23.781804330869225 37.97727573700102 191.236"""
    for dline in greece.split("\n"):
        dline = dline.strip()
        dl = dline.split()
        nam = dl[0]
        a = list(map(float, dl[1:]))
        a[0], a[1] = geodp.geodetGRS802en(radians(a[0]), radians(a[1]))
        yield (nam, a)
