#from typing import TextIO, Tuple
#def writeGor(fw: TextIO, imethod: int, dpi: float, scale: float, dmax: float, fn: str) -> None:
def writeGor(fw, imethod, dpi, scale, dmax, fn):
    """Creates the .gor file for the orthoimage program.

    imethod = 1 -> διγραμμική παρεμβολή, 2 -> δικυβική παρεμβολή."""
    #form: str = """\
    form = """\
# ΕΠΕΞΗΓΗΣΕΙΣ
# 1. Η παρεμβολή μπορεί να είναι ΔΙΓΡΑΜΜΙΚΗ ή ΔΙΚΥΒΙΚΗ.
#    Η ΔΙΚΥΒΙΚΗ δίνει καλύτερα αποτελέσματα αλλά αργεί πολύ περισσότερο.

# 1. Η ανάλυση ανηγμένων εικόνων πρέπει να δίνεται 2 ή 3 φορές μεγαλύτερη
#    από την επιθυμητή. Στην συνέχεια η μείωση της ανάλυσης γίνεται με
#    το GIMP ή python με bicubic interpolation, διότι έτσι επιτυγχάνεται
#    καλύτερη ποιότητα.

# 2. Η μέγιστη πλευρά τριγώνου πρέπει να είναι η μέγιστη απόσταση των
#    σημείων που χρησιμοποιούνται στην ορθοαναγωγή (από το πρόγραμμα
#    τριγωνοποίησης). Για παράδειγμα:
#    α. σε ορθοφωτοχάρτη που βασίζεται σε αποτύπωση σημείων (κλ 1:500)
#       η απόσταση είναι 50m.
#    β. σε ορθοφωτοχάρτη που βασίζεται σε υψομετρικές καμπύλες της ΓΥΣ,
#       είναι η απόσταση των ισοϋψών καθώς και η απόσταση των σημείων κάθε
#       ισοϋψούς (τυπικά για χάρτη ΓΥΣ κλ 1:5000 η απόσταση είναι 250m ή
#       5cm στο χάρτη)
#    γ. για την αναγωγή χάρτου ΓΥΣ 1:5000 με κανάβους είναι η μέγιστη
#       απόσταση των κανάβων δηλαδή 500m * τετρ.ρίζα 2 = 708 m

# 3. Αν δεν οριστούν πινακίδες το πρόγραμμα φτειάχνει μία που να χωράει
#    όλες τις δεδομένες εικόνες

# 4. Στην περίπτωση χρωματισμού εικόνων (βλέπε παρακάτω), αν στην εγχρωμη εικόνα
#    υπάρχει σκια (είναι σκοτεινή ή τουλάχιστον λιγότερη φωτεινή από την
#    υπόλοιπη εικόνα) το αποτέλεσμα μερικές φορές είναι άσχημο. Το πρόγραμμα
#    έχει τη δυνατότητα να αγνοήσει τη σκιά και να μην χρωματίσει αυτό το μέρος
#    της εικόνας. Ως σκιά ορίζεται ένα χρώμα στην έγχρωμη εικόνα του οποίου
#    οι συνιστώσες κόκκινου, πράσινου και μπλέ είναι εντός 2 ορίων (min, max).
#    Ένα χρώμα θεωρείται σκιά αν και οι τρεις συνιστώσες του είναι εντός
#    των ορίων που θέτει ο χρήστης. Στο παρόν αρχείο, ως ΕΜΒΕΛΕΙΑ τοποθετούμε
#    2 ακεραίους από 0 έως 255 που είναι τα όρια (αν min<=χρώμα<=max τότε
#    το χρώμα θεωρείται σκιά).
#    Αν δεν θέλουμε να αγνοηθεί η σκιά, γράφουμε ΟΧΙ στην ερώτηση
#    ΑΓΝΟΗΣΗ ΣΚΙΑΣ ΣΕ ΧΡΩΜΑΤΙΣΜΟ:
#    Η εμβέλεια των χρωμάτων πρέπει να καθοριστεί ακόμα και αν δεν αγνοείται
#    η σκιά (βάζουμε 0 0 σε κάθε εμβέλεια).

# 5. Παρόμοιο αποτέλεσμα έχει ο χρωματισμός όταν η ένταση (φωτεινότητα) ενός
#    έγχρωμου pixel είναι πολύ χαμηλή, οπότε στην ουσία είναι μαύρο. Αν αυτό
#    το pixel χρωματίσει pixel της γκρίζας εικόνας που τυχαίνει να είναι
#    φωτεινό, τότε το γκρίζο pixel θα μετασχηματιστεί σε κόκκινο ή πράσινο ή
#    μπλε που θα φαίνεται ως έγχρωμος θόρυβος (έγχρωμα pixels τυχαία
#    τοποθετημένα) στην ανηγμένη εικόνα.
#    Το πρόγραμμα έχει δυνατότητα να αγνοήσει έγχρωμα pixel κάτω από μία
#    ελάχιστη φωτεινότητα. Μία λογική τιμή ελάχιστης φωτεινότητας είναι 5.
#    Αν δεν θέλουμε να αγνοηθεί τα σκούρα έγχρωμα γράφουμε ΟΧΙ στην ερώτηση
#    ΑΓΝΟΗΣΗ ΣΚΟΥΡΩΝ PIXEL ΧΡΩΜΑTΙΣΜΟΥ:
#    Η ελάχιστη φωτεινότητα πρέπει να καθοριστεί ακόμα και αν δεν αγνοούνται
#    τα σκούρα pixel (βάζουμε 0).

# 6. Τρίγωνα μεγάλης κλίσης είναι συνήθως όψεις κτιρίων που φαίνονται στην
#    εικόνα λόγω πλάγιας λήψης. Τα τρίγωνα αυτά κανονικά έπρεπε να έχουν
#    άπειρη κλίση, αλλά λόγω μικροσφαλμάτων η κλίση είναι απλώς μεγάλη.
#    Στην ορθοαναγωγή τα τρίγωνα αυτά δίνουν μερικές φορές άσχημο αποτέλεσμα.
#    Το πρόγραμμα έχει τη δυνατότητα να τα αγνοήσει, αν η κλίσης τους ξεπερνά
#    μία μέγιστη κλίση. Η κλίση δίνεται επί %% ύψος/πλάτος και μία λογική τιμή
#    είναι 1000%%.
#    Αν δεν θέλουμε να αγνοηθούν τα τρίγωνα μεγάλης κλίσης γράφουμε ΟΧΙ στην
#    ερώτηση
#    ΑΓΝΟΗΣΗ ΤΡΙΓΩΝΩΝ ΜΕΓΑΛΗΣ ΚΛΙΣΗΣ :
#    Η μέγιστη κλίση πρέπει να δοθεί καθοριστεί ακόμα και αν δεν αγνοούνται
#    τα τρίγωνα μεγάλης κλίσης (βάζουμε 0).
#    Ας σημειωθεί ότι η αγνόηση τριγώνων μεγάλης κλίσης γίνεται μόνο σε
#    ορθοαναγωγή και όχι σε χρωματισμό εικόνων (είτε είναι χρωματισμός
#    ανηγμένης εικόνας είτε χρωματισμός ανεπεξέργαστης εικόνας, είτε
#    χρωματισμός εικόνας με αλλαγή γεωμετρίας.

# 7. Στο τέλος του παρόντος αρχείου δίνονται τα στοιχεία της κάθε
#    δεδομένης εικόνας:
#    filename: το αρχείο που περιέχει την εικόνα (χωρίς την κατάληξη .bmp). Το
#              αρχείο δεν πρέπει να είναι pathname (δηλαδή όχι κάτι σαν
#              c:/image/map.bmp).
#    Περ-Πάνω: Πλατος ζώνης σε pixel στην πάνω πλευρά της εικόνας.
#              Αυτή η ζώνη δεν θα ληφθεί υπόψη στην ορθοαναγωγή
#    Περ-Αριστ, Περ-Κάτω, Περ-Δεξιά: ανάλογα
#    Χρωματισμός: κενό (τίποτα), ή η λέξη COLORISER, ή η λέξη RECEIVER
#                 ή η λέξη PASSIVE_RECEIVER
#        Αν έχει τη λέξη COLORISER τότε αυτή η εικόνα χρησιμοποιείται για
#        χρωματίσει την ορθοφωτογραφία. Αν κάποιο μέρος της ορθοφωτογραφίας
#        είναι κενό, δηλαδή δεν έχει ληφθεί από άλλη εικόνα, τότε το μέρος
#        αυτό ΔΕΝ χρωματίζεται (παραμένει κενό).
#        Αν έχει τη λέξη RECEIVER ή PASSIVE_RECEIVER τότε αυτή η εικόνα
#        που κανονικά πρέπει
#        να είναι gray-scale χρωματίζεται ως έχει χωρίς να γίνεται
#        ορθοφωτογραφία. Πρέπει να υπάρχουν υποχρεωτικά και εικόνες με
#        COLORISER. Όλες οι άλλες εικόνες αγνοούνται. Επιπλέον οι εικόνες
#        με RECEIVER (ή PASSIVE_RECEIVER) και COLORISER πρέπει απαραίτητα
#        να έχουν το ίδιο
#        τριγωνισμό (αρχείο .trp) με εξαίρεση τις εικονοσυντεταγμένες.
#        Όταν μία εικόνα είναι RECEIVER παίρνει την απόχρωση της εικόνας
#        COLORISER αλλά διατηρεί τη σκουρότητά της. Αντίθετα, αν είναι
#        PASSIVE_RECEIVER παίρνει και την απόχρωση και τη σκουρότητα
#        από την εικόνα COLORISER.
#        Παράδειγμα RECEIVER είναι ο χρωματισμός εικόνας SAR. Παράδειγμα
#        PASSIVE_RECEIVER είναι εικόνα SAR που χάνει τελείως την πληροφορία που
#        έχει και στην ουσία μετατρέπεται σε οπτική (αλλά με τη γεωμετρία της
#        SAR).
#        Μπορούν να χρωματιστούν παραπάνω από μία εικόνα σε κάθε τρέξιμο
#        του προγράμματος.

#    Για κάθε εικόνα με πρόθεμα αρχείου, για παράδειγμα, 'egn', πρέπει να
#    υπάρχουν τα αρχεία:
#        egn.bmp: το αρχείο της εικόνας
#        egn.trp: Τριγωνισμός με σημεία δοσμένα σε συντεταγμένες ΕΓΣΑ87
#                 (ή άλλη προβολή όπου z=υψόμετρο) και σε συντεταγμένες
#                 pixel της εικόνας.
#
#
ΠΑΡΕΜΒΟΛΗ: %s
ΑΝΑΛΥΣΗ ΑΝΗΓΜΕΝΩΝ ΕΙΚΟΝΩΝ (dpi) : %.1f
ΚΛΙΜΑΚΑ ΑΝΗΓΜΕΝΩΝ ΕΙΚΟΝΩΝ       : %.1f
ΜΕΓΙΣΤΗ ΠΛΕΥΡΑ ΤΡΙΓΩΝΟΥ (m)     : %.1f
ΟΡΙΖΟΝΤΑΙ ΠΙΝΑΚΙΔΕΣ;            : ΟΧΙ

ΑΓΝΟΗΣΗ ΣΚΙΑΣ ΣΕ ΧΡΩΜΑΤΙΣΜΟ;    : ΟΧΙ
    ΕΜΒΕΛΕΙΑ ΚΟΚΚΙΝΟΥ ΣΚΙΑΣ     : 90 130
    ΕΜΒΕΛΕΙΑ ΠΡΑΣΙΝΟΥ ΣΚΙΑΣ     : 66 95
    ΕΜΒΕΛΕΙΑ ΜΠΛΕ ΣΚΙΑΣ         : 89 110

ΑΓΝΟΗΣΗ ΣΚΟΥΡΩΝ PIXEL ΧΡΩΜΑTΙΣΜΟΥ: ΟΧΙ
    ΕΛΑΧΙΣΤΗ ΦΩΤΕΙΝΟΤΗΤΑ         : 5

ΑΓΝΟΗΣΗ ΤΡΙΓΩΝΩΝ ΜΕΓΑΛΗΣ ΚΛΙΣΗΣ : ΟΧΙ
    ΜΕΓΙΣΤΗ ΚΛΙΣΗ ΤΡΙΓΩΝΩΝ %%    : 1000.0

#
#ΣΤΟΙΧΕΙΑ ΔΕΔΟΜΕΝΩΝ ΕΙΚΟΝΩΝ
#Filename  Περ-Αριστ  Περ-Κάτω Περ-Δεξιά  Περ-Πάνω  Χρωματισμός
%-10s         0         0         0         0
"""
    #meth: Tuple[str, str] = ("ΔΙΓΡΑΜΜΙΚΗ", "ΔΙΚΥΒΙΚΗ")
    meth = ("ΔΙΓΡΑΜΜΙΚΗ", "ΔΙΚΥΒΙΚΗ")
    fw.write(form % (meth[imethod-1], dpi, scale, dmax, fn))
