﻿-----  Create a polygon_g table and add a geometry column to it----
CREATE TABLE exercise1.polygon_g (
	IDpolygon_g INTEGER CONSTRAINT PK_polygon_g PRIMARY KEY, 
	propertyID INTEGER, 
	buildingID INTEGER
);
ALTER TABLE exercise1.polygon_g
	ADD CONSTRAINT FK_polygon_g_property FOREIGN KEY (propertyID) 
	REFERENCES exercise1.property(IDproperty) ON DELETE CASCADE;

INSERT INTO exercise1.polygon_g SELECT * FROM exercise1.polygon;
/*
INSERT INTO exercise1.polygon_g VALUES (1, 1, NULL);
INSERT INTO exercise1.polygon_g VALUES (2, 2, NULL);
INSERT INTO exercise1.polygon_g VALUES (3, 3, NULL);
INSERT INTO exercise1.polygon_g VALUES (4, 4, NULL);
INSERT INTO exercise1.polygon_g VALUES (5, 5, NULL);
INSERT INTO exercise1.polygon_g VALUES (6, 6, NULL);
INSERT INTO exercise1.polygon_g VALUES (7, 7, NULL);
INSERT INTO exercise1.polygon_g VALUES (8, 8, NULL);
INSERT INTO exercise1.polygon_g VALUES (9, 9, NULL);
INSERT INTO exercise1.polygon_g VALUES (10, 10, NULL);
INSERT INTO exercise1.polygon_g VALUES (11, 11, NULL);
INSERT INTO exercise1.polygon_g VALUES (12, 12, NULL);
INSERT INTO exercise1.polygon_g VALUES (13, 13, NULL);
INSERT INTO exercise1.polygon_g VALUES (14, 14, NULL);
INSERT INTO exercise1.polygon_g VALUES (15, 15, NULL);
INSERT INTO exercise1.polygon_g VALUES (16, NULL, 1);
INSERT INTO exercise1.polygon_g VALUES (1001, NULL, NULL);
INSERT INTO exercise1.polygon_g VALUES (1002, NULL, NULL);
*/
SELECT AddGeometryColumn('exercise1','polygon_g', 'geometry', 0, 'POLYGON', 2);

----  UPDATE the geometry of all polygons ----
-------------------------------------------------------------------------------
-- (a) By issuing UPDATE queries for each polygon
/*UPDATE exercise1.polygon_g SET geometry = ST_GeomFromText('POLYGON((10 20, 30 20, 30 30, 30 40, 10 40, 10 20))')
    WHERE IDpolygon_g ='1';
UPDATE polygon_g SET geometry = ST_GeomFromText('POLYGON((30 20, 60 20, 60 30, 30 30, 30 20))')
    WHERE IDpolygon_g ='2';
--  etc. ..............................
*/
---------------------------------------------------------------------------------
-- (b) Automatically, by building and running the following code (function create_polygon_geom() 
--  and the ones called by it). In order for this code to run, it is necessary to have inserted the entries 
--  for each polygon in the 'polygonedge' table in an order keeping the continuity  of the circumference
--  (clockwise or counter-clockwise)

DROP FUNCTION IF EXISTS exercise1.create_polygon_string(exercise1.polygonedge.polygonid%TYPE);
CREATE FUNCTION exercise1.create_polygon_string(exercise1.polygonedge.polygonid%TYPE) RETURNS varchar AS $$
DECLARE idpol ALIAS FOR $1;
               e exercise1.polygonedge.edgeid%TYPE;
              p0id exercise1.point.idpoint%TYPE;
              p1id exercise1.point.idpoint%TYPE;
              p2id exercise1.point.idpoint%TYPE;
              p3id exercise1.point.idpoint%TYPE;
              z exercise1.point.x%TYPE;
             flag BOOLEAN :=FALSE;
             str varchar := 'POLYGON((';
BEGIN
-- determine initial point: the one not common in 1st and 2nd edge
FOR e IN SELECT edgeid FROM exercise1.polygonedge
    WHERE idpol=polygonid LIMIT 2
LOOP
   IF flag=FALSE THEN
    p0id = (SELECT pointid1 FROM exercise1.edge WHERE idedge = e);
    p1id = (SELECT pointid2 FROM exercise1.edge WHERE idedge = e);
    flag=TRUE;
    ELSE 
      p2id = (SELECT pointid1 FROM exercise1.edge WHERE idedge = e);
      p3id = (SELECT pointid2 FROM exercise1.edge WHERE idedge = e);
      IF p0id=p2id OR p0id=p3id THEN
        p0id=p1id;
      END  IF ;
   END IF;
END LOOP;
 
  z= (SELECT x FROM exercise1.point WHERE idpoint=p0id);
        str=CONCAT(str, CONCAT(z, ' '));
        z= (SELECT y FROM exercise1.point WHERE idpoint=p0id);
        str=CONCAT(str, z);
        
  FOR e IN SELECT edgeid FROM exercise1.polygonedge
    WHERE idpol=polygonid
    LOOP
        -- can do some processing here
        p1id = (SELECT pointid1 FROM exercise1.edge WHERE idedge = e);
        p2id = (SELECT pointid2 FROM exercise1.edge WHERE idedge = e);
        IF (p1id = p0id) THEN p0id = p2id;
                        ELSE p0id = p1id;
        END IF;

        z= (SELECT x FROM exercise1.point WHERE idpoint=p0id);
        str=CONCAT(str,' , ');
        str=CONCAT(str, CONCAT(z, ' '));
        z= (SELECT y FROM exercise1.point WHERE idpoint=p0id);
        str=CONCAT(str, z);
     END LOOP;
    str=CONCAT(str, '))');
    RETURN str;
END;
$$ LANGUAGE plpgsql;


DROP FUNCTION IF EXISTS exercise1.create_polygon_geom();
CREATE FUNCTION exercise1.create_polygon_geom() RETURNS void AS $$
DECLARE  idp exercise1.polygon_g.idpolygon_g%TYPE;
DECLARE str_pol varchar;
BEGIN
FOR idp IN SELECT idpolygon_g FROM exercise1.polygon_g 
LOOP
    str_pol = exercise1.create_polygon_string(idp);
    UPDATE exercise1.polygon_g SET geometry = ST_GeomFromText(str_pol)
    WHERE idpolygon_g =idp ;
END LOOP;

END;
$$ LANGUAGE plpgsql;

SELECT exercise1.create_polygon_geom();

--  Verify that the following query gives, indeed:  POLYGON((30 20, 60 20, 60 30, 30 30, 30 20))
SELECT ST_AsText(geometry) FROM exercise1.polygon_g WHERE IDpolygon_g='2';

-- .............................
--===============================================================
