﻿--------   ΔΗΜΙΟΥΡΓΙΑ ΠΙΝΑΚΩΝ ΜΕ ΓΕΩΜΕΤΡΙΕΣ ------------------------
-- create another point table (point_g), then add a geometry column  ---
CREATE TABLE exercise1.point_g (
	IDpoint_g INTEGER CONSTRAINT PK_point_g PRIMARY KEY
);
-- add a geometry column 
SELECT AddGeometryColumn('exercise1', 'point_g', 'point_geom', 0, 'POINT', 2);

-- add a geometry check constraint
ALTER TABLE exercise1.point_g 
ADD CONSTRAINT point_valid_check CHECK (ST_isvalid(point_geom));

-- create a generic index struccture
CREATE INDEX point_idx ON exercise1.point_g USING GIST (point_geom);

--  create entries and insert point_geom values for all points of the table 'point'
-----------------------------------------------------------------------------------------------


CREATE oR REPLACE FUNCTION exercise1.create_point_g() RETURNS void AS $$
DECLARE  
     idp exercise1.point.IDpoint%TYPE;
     px exercise1.point.x%TYPE;
     py exercise1.point.y%TYPE;
BEGIN
FOR idp,px,py IN SELECT * FROM exercise1.point 
LOOP
   INSERT INTO exercise1.point_g (IDpoint_g, point_geom) VALUES (idp, 
         (SELECT ST_GeomFromText (
         CONCAT ('POINT(' , px, ' ' , py,  ')' ) ))
	 );	 
END LOOP;
END;
$$ LANGUAGE plpgsql;

SELECT exercise1.create_point_g();
-- =========================================================================
