﻿
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

CREATE TABLE exercise1.point (
	IDpoint INTEGER CONSTRAINT PK_point PRIMARY KEY, 
	x NUMERIC(10,3), 
	y NUMERIC(10,3)
);

CREATE TABLE exercise1.edge (
	IDedge INTEGER CONSTRAINT PK_edge PRIMARY KEY, 
	pointID1 INTEGER NOT NULL, 
	pointID2 INTEGER NOT NULL
);

CREATE TABLE exercise1.polygon (
	IDpolygon INTEGER CONSTRAINT PK_polygon PRIMARY KEY, 
	propertyID INTEGER, 
	buildingID INTEGER
);


CREATE TABLE exercise1.polygonedge (
        IDpolygonedge INTEGER CONSTRAINT PK_polygonedge PRIMARY KEY,
	polygonID INTEGER, 
	edgeID INTEGER 	
);



CREATE TABLE exercise1.municipality (
	IDmunicipality INTEGER CONSTRAINT PK_municipality PRIMARY KEY, 
	polygonID INTEGER
);

CREATE TABLE exercise1.property (
	IDproperty INTEGER CONSTRAINT PK_property PRIMARY KEY,
  	burden NUMERIC(8,2),  
	municipalityID INTEGER 
);

CREATE TABLE exercise1.building (
	IDbuilding INTEGER CONSTRAINT PK_building PRIMARY KEY, 
	propertyID INTEGER, 
	floors INTEGER, 
	streetname VARCHAR(250), 
	no VARCHAR(20)
);



-- !!!!   add foreign key constraints

ALTER TABLE exercise1.edge
  ADD CONSTRAINT FK_edge_point1 FOREIGN KEY (pointID1) REFERENCES exercise1.point (IDpoint) ON DELETE CASCADE;

ALTER TABLE exercise1.edge
  ADD CONSTRAINT FK_edge_point2 FOREIGN KEY (pointID2) REFERENCES exercise1.point (IDpoint) ON DELETE CASCADE;

ALTER TABLE exercise1.polygonedge
	ADD CONSTRAINT FK_polygonedge_polygon FOREIGN KEY (polygonID) REFERENCES exercise1.polygon (IDpolygon) ON DELETE CASCADE; 
ALTER TABLE exercise1.polygonedge
	ADD CONSTRAINT FK_polygonedge_edge FOREIGN KEY (edgeID) REFERENCES exercise1.edge (IDedge) ON DELETE CASCADE;


ALTER TABLE exercise1.municipality
	ADD CONSTRAINT FK_municipality_polygon FOREIGN KEY (polygonID) REFERENCES exercise1.polygon (IDpolygon) ON DELETE CASCADE;

ALTER TABLE exercise1.property
	ADD CONSTRAINT FK_property_municipality FOREIGN KEY (municipalityID) REFERENCES exercise1.municipality (IDmunicipality) ON DELETE CASCADE;

ALTER TABLE exercise1.polygon
	ADD CONSTRAINT FK_polygon_property FOREIGN KEY (propertyID) REFERENCES exercise1.property(IDproperty) ON DELETE CASCADE;

ALTER TABLE exercise1.building
	ADD CONSTRAINT FK_building_property FOREIGN KEY (propertyID) REFERENCES exercise1.property (IDproperty) ON DELETE CASCADE;

ALTER TABLE exercise1.polygon ADD CONSTRAINT FK_polygon_building FOREIGN KEY (buildingID) REFERENCES exercise1.building (IDbuilding) ON DELETE CASCADE;
  
  
CREATE TABLE exercise1.street (
	IDstreet INTEGER CONSTRAINT PK_street PRIMARY KEY, 
	streetname VARCHAR(250), 
	usage VARCHAR(50)
);
ALTER TABLE exercise1.street ADD CONSTRAINT FK_street_parcel FOREIGN KEY (IDstreet) REFERENCES exercise1.property (IDproperty) ON DELETE CASCADE;


INSERT INTO exercise1.point VALUES (1, 10, 20);
INSERT INTO exercise1.point VALUES (2, 30, 20);
INSERT INTO exercise1.point VALUES (3, 60, 20);
INSERT INTO exercise1.point VALUES (4, 70, 20);
INSERT INTO exercise1.point VALUES (5, 100, 20);
INSERT INTO exercise1.point VALUES (6, 30, 30);
INSERT INTO exercise1.point VALUES (7, 60, 30);
INSERT INTO exercise1.point VALUES (8, 10, 40);
INSERT INTO exercise1.point VALUES (9, 30, 40);
INSERT INTO exercise1.point VALUES (10, 10, 50);
INSERT INTO exercise1.point VALUES (11, 30, 50);
INSERT INTO exercise1.point VALUES (12, 40, 50);
INSERT INTO exercise1.point VALUES (13, 60, 50);
-- TO BE COMPLETED
-- ..........................................
-- ..........................................
INSERT INTO exercise1.point VALUES (19, 60, 70);
INSERT INTO exercise1.point VALUES (20, 70, 70);
INSERT INTO exercise1.point VALUES (21,90,70);
INSERT INTO exercise1.point VALUES (22, 100,70);
INSERT INTO exercise1.point VALUES (23, 10,80);
INSERT INTO exercise1.point VALUES (24, 30,80);
INSERT INTO exercise1.point VALUES (25, 60,80);
INSERT INTO exercise1.point VALUES (26, 70,80);
INSERT INTO exercise1.point VALUES (27,100,80);
INSERT INTO exercise1.point VALUES (28, 10,90);
INSERT INTO exercise1.point VALUES (29, 100,90);

INSERT INTO exercise1.point VALUES (101,80,30);
INSERT INTO exercise1.point VALUES (102, 90,30);
INSERT INTO exercise1.point VALUES (103,90,40);
INSERT INTO exercise1.point VALUES (104,80,40);

INSERT INTO exercise1.edge VALUES (1 , 1,2);
INSERT INTO exercise1.edge VALUES (2 , 2,6);
INSERT INTO exercise1.edge VALUES (3, 6, 9);
INSERT INTO exercise1.edge VALUES (4 ,8, 9);
INSERT INTO exercise1.edge VALUES (5 , 1, 8);
INSERT INTO exercise1.edge VALUES (6, 2, 3);
INSERT INTO exercise1.edge VALUES (7, 3, 7);
INSERT INTO exercise1.edge VALUES (8 , 6, 7);
INSERT INTO exercise1.edge VALUES (9, 7, 13);
INSERT INTO exercise1.edge VALUES (10 ,12 ,13);
--  TO BE COMPLETED
-- ..........................................
-- ..........................................
INSERT INTO exercise1.edge VALUES (18, 4, 5);
INSERT INTO exercise1.edge VALUES (19, 5,16);
INSERT INTO exercise1.edge VALUES (20,15,16);
INSERT INTO exercise1.edge VALUES (21,14,15);
INSERT INTO exercise1.edge VALUES (22,11,17);
INSERT INTO exercise1.edge VALUES (23,17,24);
INSERT INTO exercise1.edge VALUES (24,23,24);
INSERT INTO exercise1.edge VALUES (25,10,23);
INSERT INTO exercise1.edge VALUES (26,12,18);
INSERT INTO exercise1.edge VALUES (27,17,18);
INSERT INTO exercise1.edge VALUES (28,13,19);
INSERT INTO exercise1.edge VALUES (29,18,19);
INSERT INTO exercise1.edge VALUES (30,19,25);
INSERT INTO exercise1.edge VALUES (31,24,25);
INSERT INTO exercise1.edge VALUES (32,14,20);
INSERT INTO exercise1.edge VALUES (33,20,26);
INSERT INTO exercise1.edge VALUES (34,25,26);
INSERT INTO exercise1.edge VALUES (35,15,21);
INSERT INTO exercise1.edge VALUES (36,20,21);
INSERT INTO exercise1.edge VALUES (37,16,22);
INSERT INTO exercise1.edge VALUES (38,21,22);
INSERT INTO exercise1.edge VALUES (39,22,27);
INSERT INTO exercise1.edge VALUES (40,26,27);
INSERT INTO exercise1.edge VALUES (41,27,29);
INSERT INTO exercise1.edge VALUES (42,28,29);
INSERT INTO exercise1.edge VALUES (43,23,28);

INSERT INTO exercise1.edge VALUES ( 101,101,102);
INSERT INTO exercise1.edge VALUES ( 102,102,103);
INSERT INTO exercise1.edge VALUES ( 103,103,104);
INSERT INTO exercise1.edge VALUES ( 104,101,104);

INSERT INTO exercise1.polygon VALUES (1001, NULL, NULL);
INSERT INTO exercise1.polygon VALUES (1002, NULL, NULL);


INSERT INTO exercise1.polygonedge VALUES (1,1001, 1);
INSERT INTO exercise1.polygonedge VALUES (2,1001, 6);
INSERT INTO exercise1.polygonedge VALUES (3,1001, 7);
INSERT INTO exercise1.polygonedge VALUES (4,1001, 9);
INSERT INTO exercise1.polygonedge VALUES (5,1001, 28);
--  TO BE COMPLETED
-- ..........................................
-- ..........................................
INSERT INTO exercise1.polygonedge VALUES (8,1001, 40);
INSERT INTO exercise1.polygonedge VALUES (9,1001, 41);
INSERT INTO exercise1.polygonedge VALUES (10,1001, 42);
INSERT INTO exercise1.polygonedge VALUES (11,1001, 43);
INSERT INTO exercise1.polygonedge VALUES (12,1001, 25);
INSERT INTO exercise1.polygonedge VALUES (13,1001, 14);
INSERT INTO exercise1.polygonedge VALUES (14,1001, 5);
INSERT INTO exercise1.polygonedge VALUES (15,1002, 15);
INSERT INTO exercise1.polygonedge VALUES (16, 1002, 18);
INSERT INTO exercise1.polygonedge VALUES (17,1002,19);
INSERT INTO exercise1.polygonedge VALUES (18,1002, 37);
INSERT INTO exercise1.polygonedge VALUES (19,1002, 39);
INSERT INTO exercise1.polygonedge VALUES (20,1002, 40);
INSERT INTO exercise1.polygonedge VALUES (21,1002, 34);
INSERT INTO exercise1.polygonedge VALUES (22,1002, 30);
INSERT INTO exercise1.polygonedge VALUES (23,1002, 28);
INSERT INTO exercise1.polygonedge VALUES (24,1002, 9);
INSERT INTO exercise1.polygonedge VALUES (25,1002, 7);

INSERT INTO exercise1.municipality  VALUES (1, 1001);
INSERT INTO exercise1.municipality VALUES (2, 1002);

INSERT INTO exercise1.property VALUES (101, 1000.0, 1);
INSERT INTO exercise1.property VALUES (102, 2000.0, 1);
INSERT INTO exercise1.property VALUES (103, 1500.0, 1);
INSERT INTO exercise1.property VALUES (104,  500.0, 1);
INSERT INTO exercise1.property VALUES (105,  0.0, 2);
INSERT INTO exercise1.property VALUES (106,  8000.0, 1);
INSERT INTO exercise1.property VALUES (107,  1500.0, 1);
INSERT INTO exercise1.property VALUES (108,  400.0, 1);
INSERT INTO exercise1.property VALUES (109,  2500.0, 1);
INSERT INTO exercise1.property VALUES (110,  500.0, 1);
--  TO BE COMPLETED
-- ..........................................
-- ..........................................
INSERT INTO exercise1.property VALUES (114,  2000.0, 1);
INSERT INTO exercise1.property VALUES (115,  0.0, 1);


INSERT INTO exercise1.building VALUES (1, 106, 3, 'Street1', '57');

INSERT INTO exercise1.polygon VALUES (1, 101, NULL);
INSERT INTO exercise1.polygon VALUES (2, 102, NULL);
INSERT INTO exercise1.polygon VALUES (3, 103, NULL);
INSERT INTO exercise1.polygon VALUES (4, 104, NULL);
--  TO BE COMPLETED
-- ..........................................
-- ..........................................
INSERT INTO exercise1.polygon VALUES (8, 108, NULL);
INSERT INTO exercise1.polygon VALUES (9, 109, NULL);
INSERT INTO exercise1.polygon VALUES (10, 110, NULL);
INSERT INTO exercise1.polygon VALUES (11, 111, NULL);
INSERT INTO exercise1.polygon VALUES (12, 112, NULL);
INSERT INTO exercise1.polygon VALUES (13, 113, NULL);
INSERT INTO exercise1.polygon VALUES (14, 114, NULL);
INSERT INTO exercise1.polygon VALUES (15, 115, NULL);
INSERT INTO exercise1.polygon VALUES (16, NULL, 1);


INSERT INTO exercise1.polygonedge VALUES (26,1, 1);
INSERT INTO exercise1.polygonedge VALUES (27,1, 2);
INSERT INTO exercise1.polygonedge VALUES (28,1, 3);
INSERT INTO exercise1.polygonedge VALUES (29,1, 4);
INSERT INTO exercise1.polygonedge VALUES (30,1, 5);
--  TO BE COMPLETED
-- ..........................................
-- ..........................................
INSERT INTO exercise1.polygonedge VALUES (35,3, 8);
INSERT INTO exercise1.polygonedge VALUES (36,3,9);
INSERT INTO exercise1.polygonedge VALUES (37,3,10);
INSERT INTO exercise1.polygonedge VALUES (38,3,11);
INSERT INTO exercise1.polygonedge VALUES (39,3,12);
INSERT INTO exercise1.polygonedge VALUES (40,3,3);
INSERT INTO exercise1.polygonedge VALUES (41,4,4);
INSERT INTO exercise1.polygonedge VALUES (42,4,12);
INSERT INTO exercise1.polygonedge VALUES (43,4,13);
INSERT INTO exercise1.polygonedge VALUES (44,4,14);
INSERT INTO exercise1.polygonedge VALUES (45,5,15);
INSERT INTO exercise1.polygonedge VALUES (46,5,16);
INSERT INTO exercise1.polygonedge VALUES (47,5,17);
INSERT INTO exercise1.polygonedge VALUES (48,5,9);
INSERT INTO exercise1.polygonedge VALUES (49,5,7);
INSERT INTO exercise1.polygonedge VALUES (50,6, 18);
INSERT INTO exercise1.polygonedge VALUES (51,6, 19);
INSERT INTO exercise1.polygonedge VALUES (52,6, 20);
INSERT INTO exercise1.polygonedge VALUES (53,6, 21);
INSERT INTO exercise1.polygonedge VALUES (54,6, 16);
INSERT INTO exercise1.polygonedge VALUES (55,7, 13);
INSERT INTO exercise1.polygonedge VALUES (56,7, 22);
INSERT INTO exercise1.polygonedge VALUES (57,7,23);
INSERT INTO exercise1.polygonedge VALUES (58,7, 24);
INSERT INTO exercise1.polygonedge VALUES (59,7, 25);
INSERT INTO exercise1.polygonedge VALUES (60,8, 11);
INSERT INTO exercise1.polygonedge VALUES (61,8, 26);
INSERT INTO exercise1.polygonedge VALUES (62,8, 27);
INSERT INTO exercise1.polygonedge VALUES (63,8, 22);
INSERT INTO exercise1.polygonedge VALUES (64,9, 10);
INSERT INTO exercise1.polygonedge VALUES (65,9, 28);
INSERT INTO exercise1.polygonedge VALUES (66,9, 29);
INSERT INTO exercise1.polygonedge VALUES (67,9, 26);
INSERT INTO exercise1.polygonedge VALUES (68,10, 27);
INSERT INTO exercise1.polygonedge VALUES (69,10, 29);
INSERT INTO exercise1.polygonedge VALUES (70,10, 30);
INSERT INTO exercise1.polygonedge VALUES (71,10, 31);
INSERT INTO exercise1.polygonedge VALUES (72,10, 23);
INSERT INTO exercise1.polygonedge VALUES (73,11, 17);
INSERT INTO exercise1.polygonedge VALUES (74,11, 32);
INSERT INTO exercise1.polygonedge VALUES (75,11, 33);
INSERT INTO exercise1.polygonedge VALUES (76,11, 34);
INSERT INTO exercise1.polygonedge VALUES (77,11, 30);
INSERT INTO exercise1.polygonedge VALUES (78,11, 28);
INSERT INTO exercise1.polygonedge VALUES (79,12, 21);
INSERT INTO exercise1.polygonedge VALUES (80,12, 35);
INSERT INTO exercise1.polygonedge VALUES (81,12, 36);
INSERT INTO exercise1.polygonedge VALUES (82,12, 32);
INSERT INTO exercise1.polygonedge VALUES (83,13, 20);
INSERT INTO exercise1.polygonedge VALUES (84,13, 37);
INSERT INTO exercise1.polygonedge VALUES (85,13, 38);
INSERT INTO exercise1.polygonedge VALUES (86,13, 35);
INSERT INTO exercise1.polygonedge VALUES (87,14, 36);
INSERT INTO exercise1.polygonedge VALUES (88,14, 38);
INSERT INTO exercise1.polygonedge VALUES (89,14, 39);
INSERT INTO exercise1.polygonedge VALUES (90,14, 40);
INSERT INTO exercise1.polygonedge VALUES (91,14, 33);
INSERT INTO exercise1.polygonedge VALUES (92,15, 24);
INSERT INTO exercise1.polygonedge VALUES (93,15, 31);
INSERT INTO exercise1.polygonedge VALUES (94,15, 34);
INSERT INTO exercise1.polygonedge VALUES (95,15, 40);
INSERT INTO exercise1.polygonedge VALUES (96,15, 41);
INSERT INTO exercise1.polygonedge VALUES (97,15, 42);
INSERT INTO exercise1.polygonedge VALUES (98,15, 43);
INSERT INTO exercise1.polygonedge VALUES (99,16, 101);
INSERT INTO exercise1.polygonedge VALUES (100,16, 102);
INSERT INTO exercise1.polygonedge VALUES (101,16,103);
INSERT INTO exercise1.polygonedge VALUES (102,16,104);


INSERT INTO exercise1.street VALUES (105, 'Street1','Pezodromos');
INSERT INTO exercise1.street VALUES (111, 'Street2','low speed');
INSERT INTO exercise1.street VALUES (115, 'Road1','high speed');


CREATE TABLE exercise1.propertyperson (
	propertyID INTEGER,
	personID INTEGER 	
);

ALTER TABLE exercise1.propertyperson
	ADD CONSTRAINT PK_propertyperson PRIMARY KEY  (propertyID, personID);
ALTER TABLE exercise1.propertyperson
	ADD CONSTRAINT FK_propertyperson_person FOREIGN KEY (personID) REFERENCES exercise1.person (IDperson) ON DELETE CASCADE;
ALTER TABLE exercise1.propertyperson
	ADD CONSTRAINT FK_propertyperson_property FOREIGN KEY (propertyID) REFERENCES exercise1.property (IDproperty) ON DELETE CASCADE;

COMMIT;

------------------------------------------------------------------------------------------------------------------
---------   Assign properties with the specified  IDproperty to students of acad. year 2024
---------   enrolled in the course SPATIAL DATABASES. The assignement must be done in alphabetical order 
---------   and a round-robin manner,  allowing joint ownership, ofcourse
CREATE OR REPLACE FUNCTION exercise1.asign_properties(yr INTEGER) RETURNS void AS $$
	DECLARE cnt INTEGER := 0; 
	DECLARE  propid INT[]; 
	DECLARE persid INTEGER;
	BEGIN  
	--  TO BE COMPLETED
	-- ..........................................
	-- ..........................................
	END;
$$ LANGUAGE plpgsql;

SELECT exercise1.asign_properties(2021);
-------------------------------------------------------------------------------------------------------------------
----------------------------------------------  QUERIES -------------------------------------------------------

--  ΙΙΙ.1  Length of each line, sorted in ascenting order --------
SELECT e.IDedge, ROUND(SQRT( POWER((p1.x - p2.x),2) + POWER ((p1.y - p2.y),2)) ,2) AS length 
FROM exercise1.edge e, exercise1.point p1, exercise1.point p2
WHERE
e.pointID1 = p1.IDpoint AND
e.pointID2 = p2.IDpoint 
ORDER BY length, e.IDedge;

--   ΙΙΙ.2  Distance of points from origin -----------------------
SELECT IDpoint, ROUND(SQRT(POWER(x,2)+POWER(y,2)) ,2) AS dist_from_orig
FROM exercise1.point  ORDER BY IDpoint;

--  ΙΙΙ.3   Circumference of each property -----------------
SELECT C1.propertyid, C1.circumference FROM
	(SELECT propertyedge.propertyid, ROUND(SUM(A1.length),2) AS circumference
	FROM 
	(SELECT propertyid, edgeid  
		FROM exercise1.polygon JOIN exercise1.polygonedge
		ON exercise1.polygon.idpolygon=exercise1.polygonedge.polygonid
		WHERE exercise1.polygon.propertyid > 0) propertyedge
	JOIN 
	(SELECT e.IDedge, SQRT( POWER((p1.x - p2.x), 2) + POWER ((p1.y - p2.y), 2)) AS length 
		FROM exercise1.edge e, exercise1.point p1, exercise1.point p2
		WHERE
		e.pointID1 = p1.IDpoint AND
		e.pointID2 = p2.IDpoint ) A1
		ON propertyedge.edgeid = A1.idedge
	GROUP BY propertyedge.propertyid) C1
ORDER BY C1.circumference, C1.propertyid;


--ΙΙΙ.3    alternative 2 (minor changes) ------------- 
-----------Circumference of each property -----------------
SELECT C1.propertyid, C1.circumference FROM
(SELECT propertyedge.propertyid, ROUND(SUM(A1.length),2) AS circumference
FROM 
   (SELECT propertyid, edgeid  
    FROM exercise1.polygon, exercise1.polygonedge
    WHERE exercise1.polygon.idpolygon=exercise1.polygonedge.polygonid
    AND exercise1.polygon.propertyid > 0) propertyedge,

   (SELECT e.IDedge, SQRT( POWER((p1.x - p2.x), 2) + POWER ((p1.y - p2.y), 2)) AS length 
    FROM exercise1.edge e, exercise1.point p1, exercise1.point p2
    WHERE
        e.pointID1 = p1.IDpoint AND
        e.pointID2 = p2.IDpoint ) A1
WHERE propertyedge.edgeid = A1.idedge
GROUP BY propertyedge.propertyid) C1
ORDER BY C1.circumference, C1.propertyid;



-------------------Circumference, as a function------------------------------------------
------------------- much cleaner code  ----------------------------------------------------------
DROP FUNCTION IF EXISTS exercise1.circumference(integer);
CREATE FUNCTION exercise1.circumference(polygID  integer) RETURNS  NUMERIC AS $$
	DECLARE circ NUMERIC :=0;
	       p1ID exercise1.point.IDpoint%TYPE;
	       p2ID exercise1.point.IDpoint%TYPE;
	       p1x exercise1.point.x%TYPE;
	       p1y exercise1.point.y%TYPE;
	       p2x exercise1.point.x%TYPE;
	       p2y exercise1.point.y%TYPE;
	BEGIN  
		FOR p1ID, p2ID IN  (SELECT exercise1.edge.pointID1, exercise1.edge.pointID2  
					FROM exercise1.edge, exercise1.polygonedge
					WHERE exercise1.edge.IDedge=exercise1.polygonedge.edgeID
					AND exercise1.polygonedge.polygonid=polygID)
		LOOP
			p1x = (SELECT x FROM exercise1.point WHERE point.IDpoint=p1ID);
			p1y = (SELECT y FROM exercise1.point WHERE point.IDpoint=p1ID);
			p2x = (SELECT x FROM exercise1.point WHERE point.IDpoint=p2ID);
			p2y = (SELECT y FROM exercise1.point WHERE point.IDpoint=p2ID);
			circ = circ + SQRT( POWER((p1x - p2x), 2) + POWER ((p1y - p2y), 2));
		END LOOP;
		RETURN ROUND(circ,2);
	END;
$$ LANGUAGE plpgsql;

--------------    Creation of a VIEW for circumferences  -------------------------------
DROP VIEW IF EXISTS exercise1.circumferences;
CREATE VIEW  exercise1.circumferences AS
	SELECT IDpolygon AS ΠΟΛΥΓΩΝΟ,
 	       exercise1.circumference(IDpolygon) AS ΠΕΡΙΜΕΤΡΟΣ
	FROM exercise1.polygon pol
	WHERE pol.propertyID>0
	ORDER BY ΠΕΡΙΜΕΤΡΟΣ, ΠΟΛΥΓΩΝΟ;
	
	SELECT * FROM exercise1.circumferences;
---------------------------------------------------------------------------------------------------------------------;
---------------------------------------------------------------------------------------------------------------------

