##############################################################################
# ThanCad 0.8.0 "Students2023": n-dimensional CAD with raster support for engineers
# 
# Copyright (C) 2001-2023 Thanasis Stamos, September 29, 2023
# Athens, Greece, Europe
# URL: http://thancad.sourceforge.net
# e-mail: cyberthanasis@gmx.net
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (www.gnu.org/licenses/gpl.html).
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##############################################################################
"""\
ThanCad 0.8.0 "Students2023": n-dimensional CAD with raster support for engineers

This module defines various information for the translation from English to Greek.
"""

from p_ggen import Translation
#from thanopt import thancadconf


#English to Greek translation table
en2gr = \
{ "__TRANSLATION__"     : ("en", "utf_8", "gr", "utf_8"),
"Error in data"                                   : u"Λάθος στα δεδομένα",
"Cancel"                                          : u"Ακύρωση",
"Execute"                                         : u"Εκτέλεση",
"Delete"                                          : u"Διαγραφή",
"&New"                                            : u"&Νέο",
"&Open"                                           : u"Ανοιγμα",
"Open &without images"                            : u"Ανοιγμα χωρίς εικόνες",
"Opens an existing drawing with the images unloaded": u"Ανοίγει ένα υφιστάμενο σχέδιο με απόκρυψη των εικόνων",
"Open spreadsheet"                                : u"Άνοιγμα λογιστικού φύλλου",
"with &points"                                    : u"με σημεία",
"Opens spreadsheets (ods,xls,xlsx) which contain points coordinates.":
                                                    u"Ανοίγει λογιστικά φύλλα (ods,xls,xlsx), τα οποία περιέχουν συντεταγμένες σημείων",
"with &lines"                                     : u"με γραμμές",
"Opens spreadsheets (ods,xls,xlsx) which contain coordinates of lines.":
                                                    u"Ανοίγει λογιστικά φύλλα (ods,xls,xlsx), τα οποία περιέχουν συντεταγμένες γραμμών",
"Ins&ert"                                         : u"Εισαγωγή",
"Inserts other drawings into current drawing"     : u"Εισάγει άλλα σχέδια μέσα στο τρέχον σχέδιο",
"Choose files to insert"                          : u"Επιλέξτε αρχεία προς εισαγωγή",
"&Save"                                           : u"Αποθήκευση",
"Save"                                            : u"Αποθήκευση",
"S&ave as"                                        : u"Αποθήκευση ως",

"with &surface"                                   : "με επιφάνεια",
"Opens spreadsheets (ods,xls,xlsx) which contain coordinates of surface.":
    "Ανοίγει λογιστικά φύλλα (ods,xls,xlsx) που περιέχουν συντεταγμένες επιφάνειας",
"Export to spreadsheet"                           : "Εξαγωγή σε λογιστικό φύλλο",
"Export &points"                                  : "Εξαγωγή σημείων",
"Exports ThanCad points to spreadsheets (ods,xls,xlsx).": "1",
"Export &lines"                                   : "Εξαγωγή γραμμών",
"Exports ThanCad lines to spreadsheets (ods,xls,xlsx).": "Εξαγωγή γραμμών του ThanCad σε λογιστικά φύλλα (ods,xls,xlsx).",
"Export &images"                                  : "Εξαγωγή εικόνων",
"Exports ThanCad images to an autocad script (scr) file.": "Εξαγωγή εικόνων του ThanCad σε αρχείο script (scr) του Autocad.",
"Converts a complex pixel valued TerraSAR image to GeoTiff and inserts it to the current drawing.":
    "Μετατρέπει μία εικόνα TerraSAR που έχει μιγαδικές τιμές στα pixels σε GeoTiff και την εισάγει στο τρέχον σχέδιο.",
"Existing drawing has been opened."               : "Το υφιστάμενο σχέδιο έχει ανοίξει.",
"Select points to export:"                        : "Επιλογή σημείων προς εξαγωγή:",
"Export points to spreadsheet"                    : "Εξαγωγή σημείων σε λογιστικό φύλλο",
"Select lines to export:"                         : "Επιλογή γραμμών για εξαγωγή",
"Export lines to spreadsheet"                     : "Εξαγωγή γραμμών σε λογιστικό φύλλο",
"Warning: Only the first spreadsheet {} rows were exported."  : "Προειδοποίηση: Έγινε εξαγωγή μόνο των πρώτων {} γραμμών του λογιστικού φύλλου.",
"Select images to export to an autocad script file:": "Επιλογή εικονων για εξαγωγή σε αρχείο script του autocad:",
"Export images to autocad script"                 : "Εξαγωγή εικόνων σε script του autocad",

"&Close"                                          : u"Κλείσιμο",
"Export &dxf"                                     : u"Εξαγωγή dxf",
"&Export syk"                                     : u"Εξαγωγή syk",
"&Export brk"                                     : u"Εξαγωγή brk",
"Export to &Image"                                : u"Εκτύπωση σε εικόνα",
"&Export syn"                                     : u"Εξαγωγή syn",
"Exports points to a syn file"                    : u"Εξάγει σημεία σε αρχείο μορφής .syn",
"Plot to PDF"                                     : u"Εκτύπωση σε pdf",
"&Plot"                                           : u"Εκτύπωση",

"Save and E&xit"                                  : u"Αποθήκευση και Έξοδος",
"&Instructions"                                   : u"Οδηγίες",

"Plots the drawing to a printer"                  : u"Εκτυπώνει το σχέδιο σε εκτυπωτή",
"Plot Drawing to Printer"                         : u"Εκτύπωση Σχεδίου σε Εκτυπωτή",
"Save and Exit"                                   : u"Αποθήκευση και έξοδος",
"Save and Print"                                  : u"Αποθήκευση και εκτύπωση",
"Printer selection"                               : u"Επιλογή Εκτυπωτή",
"Plot definition"                                 : u"Ορισμός εκτύπωσης",
"Pick Window"                                     : u"Επιλογή παραθύρου",
"Plot File"                                       : u"Αρχείο Εκτύπωσης",
"Display"                                         : u"Οθόνη",
"Window"                                          : u"Παράθυρο",

"Choose files to open"                            : u"Επιλέξτε αρχεία για άνοιγμα",
"file has been successfully imported (into another window).": u"Το αρχείο εισήχθη επιτυχώς (σε άλλο παράθυρο).",
"import failed."                                  : u"η εισαγωγή απέτυχε.",
"file has been successfully exported."            : u"Το αρχείο εξήχθη επιτυχώς.",
"export failed."                                  : u"η εξαγωγή απέτυχε.",

"First dimension point: "                         : u"Πρώτο σημείο διάστασης: ",
"Last  dimension point: "                         : u"Τελευταίο σημείο διάστασης: ",
"Dimension text"                                  : u"Κείμενο διάστασης",
"Perpendicular location: "                        : u"Κάθετη θέση: ",
"Reference points: %s -:- %s"                     : u"Σημεία αναφοράς: %s -:- %s",

"No raster image found at point. Try again.\n"    : u"Δεν βρέθηκε εικόνα στο σημείο. Προσπαθείστε πάλι.\n",

"Select a line to transform to curve: "           : u"Επιλογή γραμμής που θα μετατραπεί σε καμπύλη: ",
"Delete empty layer %s (enter=no): "              : u"Διαγραφή άδειας διαφάνειας %s (enter=no): ",
"Delete empty layer %s (enter=yes): "             : u"Διαγραφή άδειας διαφάνειας %s (enter=yes): ",
"No unused layers (current layer can not be purged).": u"Δεν υπάρχουν αχρησιμοποίητες διαφάνειες (η τρέχουσα διαφάνεια δεν μπορεί να διαγραφεί).",
"No layers were purged."                          : u"Δεν έγινε διαγραφή καμμίας διαφάνειας.",

"&File"                                           : u"Αρχείο",
"Makes an empty drawing"                          : u"Δημιουργεί ένα κενό σχέδιο",
"Opens an existing drawing"                       : u"Ανοίγει ένα υφιστάμενο σχέδιο",
"Saves drawing into a file"                       : u"Αποθηκεύει το σχέδιο σε αρχείο",
"Closes current drawing"                          : u"Κλείνει το τρέχον αρχείο",
"Exports a dxf file"                              : u"Εξάγει ένα αρχείο dxf",
"Exports a syk file"                              : u"Εξάγει ένα αρχείο syk",
"Exports a brk file"                              : u"Εξάγει ένα αρχείο brk",
"Plots the drawing into a raster image"           : u"Εκτυπώνει το σχέδιο σε αρχείο εικόνας",
"Plots the drawing to a PDF file"                 : u"Εκτυπώνει το σχέδιο σε αρχείο pdf",
"&Purge"                                          : u"Εκκαθάριση",
"Removes unused items, such as layers, from drawing": u"Αφαιρεί αχρησιμοποίητα στοιχεία, όπως διαφάνειες, από το σχέδιο",
"E&xit"                                           : u"Έξοδος",
"&Edit"                                           : u"Επεξεργασία",
"&Undo"                                           : u"Αναίρεση εντολής",
"&Redo"                                           : u"Επανυποβολή αναιρεμένης εντολής",
"Cu&t"                                            : u"Αποκοπή",
"&Copy"                                           : u"Αντιγραφή",
"C&opy with Base Point"                           : u"Αντιγραφή με σημείο αναφοράς",
"&Paste"                                          : u"Επικόλληση",
"P&aste to Original Coordinates"                  : u"Επικόλληση στις αρχικές συντεταγμένες",
"&Select"                                         : u"Επιλογή",
"Changes layer of selected elements"              : u"Αλλάζει τη διαφάνεια επιλεγμενων στοιχείων",
"Deletes selected elements"                       : u"Διαγράφει επιλεγμένα στοιχεία",
"Rotates selected elements"                       : u"Περιστρέφει επιλεγμένα στοιχεία",
"Scales selected elements"                        : u"Μεγενθύνει επιλεγμένα στοιχεία",
"Moves selected elements"                         : u"Μετακινεί επιλεγμένα αντικείμενα",
"Copies selected elements"                        : u"Αντιγράφει επιλεγμένα αντικείμενα",
"Copies object parallel to itself"                : u"Αντιγράφει στοιχείο παράλληλα με τον ευατό του",
"Breaks an element into 2 pieces"                 : u"Κόβει ένα στοιχείο σε δύο τμήματα",
"Explode 1 or more elements to smaller objects"   : u"Χωρίζει σύνθετο στοιχείο σε μικρότερα στοιχεία",
"Cuts elements with other elements being the cutting edges": u"Κόβει στοιχεία με ψαλίδι άλλα στοιχεία",
"Layer:"                                          : u"Διαφάνεια:",
"World xyz"                                       : u"Γενικές xyz",
"Image xy (mm)"                                   : u"Εικονοσυντεταγμένες xy (mm)",
"Pixel xy"                                        : u"xy σε εικονοστοιχεία",
"New drawing has been created."                   : u"Το νέο αρχείο έχει δημιουγηθεί.",
"Zoom &Window"                                    : u"Εστίαση σε παράθυρο",
"Zoom &All"                                       : u"Εστίαση σε όλο το σχέδιο",
"Zoom R&elative"                                  : u"Εστίαση σχετική",
"&Zoom real time"                                 : u"Εστίαση καθοδηγούμενη",
"P&an Relative"                                   : u"Μετατόπιση σχετική",
"&Pan real time"                                  : u"Μετατόπιση καθοδηγούμενη",
"Pan real time"                                   : u"Μετατόπιση καθοδηγούμενη",
"&Redraw"                                         : u"Επανασχεδίαση",
"Re&gen"                                          : u"Αναδημιουργία",

"Image file"                                      : u"Αρχείο εικόνας",
"Insert Raster &Image"                            : u"Εισαγωγή Eικόνας",
"&Clip image"                                     : u"Απόκρυψη περιθωρίων εικόνας",
"Import &log Image"                               : u"Εισαγωγή εικόνας μορφής .log",
"Import &tfw/j2w Image"                           : u"Εισαγωγή εικόνας μορφής .tfw/.j2w",
"Import &GeoTIFF"                                 : u"Εισαγωγή εικόνας μορφής GeoTIFF",
"Inserts TIFF images whose georeference is inside the TIFF":
                                                    u"Εισάγει εικόνες TIFF η γεωαναφορά των οποίων είναι μέσα στο TIFF",
"Inserts TIFF images whose georeference is defined in .tfw/.j2w files":
                                                    u"Εισάγει εικόνες TIFF η γεωαναφορά των οποίων καθορίζεται σε αρχεία .tfw/.j2w",
"Inserts BMP images whose georeference is defined in .log files": u"Εισάγει εικόνες BMP η γεωαναφορά των οποίων καθορίζεται σε αρχεία .log",
"Import &Cadastre"                                : u"Εισαγωγή εικόνας κτηματολογίου",
"Inserts Greek cadastre map image to its correct position using standardised file naming conventions":
    u"Εισάγει εικόνα εληνικού κτηματολογίου στη σωστή της θέση χρησιμοποιώντας προτυποποιημένη σύμβαση ονοματισμού αρχείων",
"Image &Render"                                   : u"Ποιότητα εικόνας",
"Select rendering mode of images (Quick/Best) <Quick>: ": u"Επιλογή ποιότητας εμφάνισης εικόνων [Q=γρήγορη/B=καλύτερη] <Q>: ",
"Current image rendering mode: Quick\n"           : u"Τρέχουσα ποιότητα εμφάνισης εικόνων: Γρήγορη\n",
"Current image rendering mode: Best\n"            : u"Τρέχουσα ποιότητα εμφάνισης εικόνων: Καλύτερη\n",
"Locate image file"                               : u"Προσδιορισμός αρχείου εικόνας",
"Locate image directory"                          : u"Προσδιορισμός φακέλλου εικόνων",
"Select an image: "                               : u"Επιλογή εικόνας: ",
"Select directory for missing image files"        : u"Επιλογή φακέλλου που περιέχει αρχεία εικόνων που λείπουν",
"Image &frame"                                    : u"Πλαίσιο εικόνων",
"Displays or not frames around images"            : u"Προβάλλει ή όχι πλαίσια γύρω απο τις εικόνες",
"Imageframe is "                                  : u"Η προβολή πλαισίων γύρω από εικόνες είναι ",
"Enter image frame setting [ON/OFF] <%s>: "       : u"Ρύθμιση πλαισίων γύρω από εικόνες [ON/OFF] <%s>: ",
"Imageframe is now "                              : u"Η προβολή πλαισίων γύρω από εικόνες είναι τώρα ",
"On or Off is required. Try again.\n"             : u"Χρειάζεται On ή Off. Προσπαθείστε πάλι.\n",
"Unload images"                                   : u"Απόκρυψη εικόνων",
"Load images"                                     : u"Προβολή εικόνων",
"Hides the content of images and conserves memory": u"Αποκρύπτει το περιεχόμενο εικόνων και εξοικονομεί μνήμη",
"Reshows the content of the image allocating memory": u"Επαναπροβάλλει το περιεχόμενο εικόνων με δέσμευση μνήμης",
"Choose image file"                               : u"Επιλογή αρχείου εικόνας",

"Joins 2 or more adjacent lines"                  : u"Ενώνει 2 ή περισσότερες διαδοχικές γραμμές",
"This command will join lines even if they have different z or higher dimensions":
    u"Η εντολή αυτή θα συνενώσει γραμμές ακόμα και αν έχουν διαφορετικές z ή ανώτερες διαστάσεις",
"Save translation report"                         : u"Αποθήκευση της απογραφής της μετάφρασης",
"Translation report was completed"                : u"Η απογραφή μετάφρασης ολοκληρώθηκε",
"&Translation report"                             : u"Απογραφή μετάφρασης",
"&View"                                           : u"Προβολή",
"&Image"                                          : u"Εικόνα",
"F&ormat"                                         : u"Μορφή",
"&Window"                                         : u"Παράθυρο",
"&Layer"                                          : u"Διαφάνεια",
"&Text Style"                                     : u"Ύφος κειμένου",
"&Tools"                                          : u"Εργαλεία",
"&Distance"                                       : u"Απόσταση",
"&Area"                                           : u"Εμβαδό",
"A&ngle"                                          : u"Γωνία",
"&Id Point"                                       : u"Συντεταγμένες σημείου",
"&List"                                           : u"Κατάλογος",
"Drafting &Settings"                              : u"Ρυθμίσεις σχεδίασης",
"&Find text"                                      : u"Αναζήτηση κειμένου",
"&Find centroid"                                  : u"Υπολογισμός κεντροειδούς",
"&Find convex hull"                               : u"Υπολογισμός κυρτού κελύφους",
"&Simplify line"                                  : u"Απλοποίηση γραμμής",
"&Draw"                                           : u"Σχεδίαση",
"&Line"                                           : u"Γραμμή",
"Line"                                            : u"Γραμμή",
"&Rectangle"                                      : u"Ορθογώνιο",
"&Circle"                                         : u"Κύκλος",
"Circle"                                          : u"Κύκλος",
"&Arc"                                            : u"Τόξο κύκλου",
"&Point"                                          : u"Σημείο",
"&Named Point"                                    : u"Ονοματισμένο σημείο",
"R&oad"                                           : u"Οδός",
"&Text"                                           : u"Κείμενο",
"&Dimension aligned"                              : u"Στοιχισμένη διάσταση",
"&Engineering"                                    : u"Μηχανική",
"&Grid"                                           : u"Κάναβος",

"Draw &Greece"                                    : u"Σχεδίαση Ελλάδας",
"Draws the perimeter of Greece in EGSA87 coordinates": u"Σχεδιάζει την περίμετρο της Ελλάδας σε συντεταγμένες ΕΓΣΑ87",

"Geo&detic Projection"                            : u"Γεωδαιτική Προβολή",
"Displays and changes the geodetic projection of the drawing":
                                                    u"Δείχνει και μεταβάλλει τη γεωδαιτική προβολή του σχεδίου",
"Current geodetic projection is "                 : u"Η τρέχουσα γεωδαιτική προβολή είναι ",
"Select geodetic projection: Utm/transverse Mercator/Egsa87/Htrs07/Identity (enter=E): ":
                                                    u"Επιλογή γεωδαιτικής προβολής: "\
                                                    u"U=Utm/M=εγκάρσια μερκατορική/E=ΕΓΣΑ87/H=HTRS07/I=ταυτότητα (enter=E): ",
"Select ellipsoid: g=GRS80/w=WGS84/r=Greek87/n=NAD83 (enter=g): ":
                                                    u"Επιλογή ελειψοειδούς: g=GRS80/w=WGS84/r=Ελληνικό(ΕΓΣΑ87)/n=NAD83 (enter=g): ",
"UTM zone (1-60) (enter=34): "                    : u"Ζώνη παγκόσμιας μερκατορικής προβολής (1-60) (enter=34): ",
"North/South (enter=N): "                         : u"N=βόρειο ημισφαίριο/S=νότιο ημισφαίριο (enter=βόρειο): ",

"Load DE&Ms"                                      : u"Εισαγωγή ΨΜΕπ",
"Loads DEMs (USGS format) stored in .tif files"   : u"Εισαγωγή Ψηφιακών Μοντέλων Επιφανείας (μορφή USGS) που είναι αποθηκευμένα σε αρχεία .tif",
"Manage DE&Ms"                                    : u"Διαχείριση ΨΜΕπ",
"Manages DEMs (USGS format) stored in .tif files" : u"Διαχείριση Ψηφιακών Μοντέλων Επιφανείας (μορφή USGS) που είναι αποθηκευμένα σε αρχεία .tif",
"Locate DEM directory"                            : u"Εντοπισμός φακέλλου με ΨΜΕπ",
"Locates the directory for missing files of DEMs" : u"Εντοπισμός του φακέλλου που περιέχει ανεντόπιστα αρχεία ΨΜΕπ",

"&Trace"                                          : u"Ιχνηλάτηση",
"Nothing to cancel."                              : u"Δεν υπάρχει τίποτα να ακυρωθεί.",
"First line point (c=continue existing line): "   : u"Πρώτο σημείο της γραμμής (c=συνέχιση υφιστάμενης γραμμής): ",

"Center (3p=3 points/2p=2 points): "             : u"Κέντρο: (3p=3 σημεία/2p=2 σημεία): ",
"Radius (D=Diameter): "                           : u"Ακτίνα: (D=Διάμετρος): ",
"Diameter: "                                      : u"Διάμετρος: ",
"First point on circle: "                         : u"Πρώτο σημείο κύκλου: ",
"Second point on circle: "                        : u"Δεύτερο σημείο κύκλου: ",
"Third point on circle: "                         : u"Τρίτο σημείο κύκλου: ",
"Invalid circle: points are collinear."           : u"Μη έγκυρος κύκλος: τα σημεία είναι συγγραμμικά.",

"Command: "                                       : u"Εντολή: ",
"Cancelled."                                      : u"Ακυρώθηκε.",
"Save drawing to a file"                          : u"Αποθήκευση σχεδίου σε αρχείο",
"Drawing has been saved."                         : u"Το σχέδιο έχει αποθηκευθεί.",
"&Interchange"                                    : u"Κυκλοφοριακός κόμβος",
"Creates an interchange between 2 highways"       : u"Υπολογίζει και σχεδιάζει κυκλοφορικαό κόμβο μεταξύ 2 εθνικών οδών",

"Select an element (w=window/c=crossing/l=layers/f=layer of/p=previous): ":
                                                    u"Επιλογή ενός στοιχείου (w=παράθυρο/c=παράθυρο τομής/"\
                                                    u"l=διαφάνειες/f=διαφάνεια του/p=προηγούμενα): ",
"Select an element (w=window/c=crossing/l=layers/f=layer of/p=previous/%s): ":
                                                    u"Επιλογή ενός στοιχείου (w=παράθυρο/c=παράθυρο τομής/"\
                                                    u"l=διαφάνειες/f=διαφάνεια του/p=προηγούμενα/%s): ",

"First window corner: "                           : u"Πρώτη κορυφή παραθύρου: ",
"Other window corner: "                           : u"Αντιδιαγώνια κορυφή παραθύρου: ",
"elements added"                                  : u"στοιχεία προστέθηκαν",
"duplicate"                                       : u"διπλά",

"Select layer(s)"                                 : u"Επιλογή διαφανειών",
"Select a (breakable) element to break.."         : u"Επιλογή ενός στοιχείου που μπορεί να σπάσει..",
"Select lines to find their centroid:\n"          : u"Επιλογή γραμμών για να βρεθεί το κεντροειδές τους:\n",
"At least"                                        : u"Τουλάχιστον",
"Exactly"                                         : u"Ακριβώς",
"%s %d line(s) are required (%d found). Try again.\n": u"%s %d γραμμές(ή) χρειάζονται (%d βρέθηκαν). Προσπαθείστε πάλι.\n",

"Select lines to find their convex hull:\n"       : u"Επιλογή γραμμών για να βρεθεί το κυρτό κέλυφός τους:\n",
"Specify point: "                                 : u"Καθορείστε σημείο: ",
"Specify a point (m=multiple): "                  : u"Καθορείστε ένα σημείο (m=πολλαπλά σημεία): ",
"Specify a point (<enter>): "                     : u"Καθορείστε ένα σημείο (<enter>): ",
"Specify a point (Multiple/toggle X/toggle Y/toggle Z): ":
    u"Καθορείστε ένα σημείο (m=πολλαπλά σημεία/x=Αντιστροφή X/y=Αντιστροφή Y/z=Αντιστροφή Z): ",
"Specify a point (toggle X/toggle Y/toggle Z): "  :
    u"Καθορείστε ένα σημείο (x=Αντιστροφή X/y=Αντιστροφή Y/z=Αντιστροφή Z): ",
"Coordinate usability (for DTM, etc)"             : u"Αξιοποίηση συντεταγμένων (για DTM, κλπ)",
"Point name: "                                    : u"Όνομα σημείου: ",
"Start point of trace: "                          : u"Αρχικό σημείο ιχνηλάτησης: ",
"Select a line with 3 point to fit highway interchange\n": u"Επιλέξτε μία γραμμή με 3 σημεία για να τοποθετηθεί κυκλοφοριακός κόμβος\n",
"First point: "                                   : u"Πρώτο σημείο: ",
"Next point: "                                    : u"Επόμενο σημείο: ",
"(closed)"                                        : u"(κλειστή)",
"(open)"                                          : u"(ανοικτή)",
"Press enter to continue.."                       : u"(Πατείστε enter για συνέχεια..",

"Edit ThanCad Text styles"                        : u"Επεξεργασία ύφους κειμένου του ThanCad",
"Image file open failed"                          : u"Αποτυχία ανοίγματος αρχείου εικόνας",
"Choose image .log files"                         : u"Επιλογή αρχείων εικόνων .log",
"Choose image .tfw files"                         : u"Επιλογή αρχείων εικόνων .tfw",
"Plot to pdf file"                                : u"Εκτύπωση σε αρχείο pdf",
"Engineering scale 1:x (enter=500): "             : u"Κλίμακα 1:x (enter=500): ",
"First grid corner (Quadrilateral): "             : u"Πρώτο σημείο της περιοχής κανάβου (q=τετράπλευρο):",
"Other grid corner: "                             : u"Αντιδιαγώνιο σημείο περιοχής κανάβου: ",
"Keep grid boundary (Yes/No/<Yes>): "             : u"Διατήρηση περιγράμματος περιοχής κανάβου (Ναι/Οχι/<Ναι>): ",
"Select new current layer"                        : u"Επιλογή νέας τρέχουσας διαφάνειας",
"Drawing modified, OK to close?"                  : u"Το σχέδιο έχει αλλαγές, σίγουρα να κλείσει;",
"Data modified, OK to cancel?"                    : u"Τα δεδομένα έχουν αλλάξει, σίγουρα να ακυρωθούν;",
"(This might be an old, no longer supported, drawing file)": u"(Μπορεί να είναι ένα παλαιό αρχείο ThanCad το οποίο δεν υποστηρίζεται πια)",
"Open failed"                                     : u"Αποτυχία ανοίγματος",
"Existing drawing has been opened (into another window).": u"Το σχέδιο έχει ανοίξει (σε άλλο παράθυρο).",
"Save failed"                                     : u"Αποτυχία αποθήκευσης",
"Sudup, brother!"                                 : u"Σουντούπ, Ώ αδελφέ μου!",
"To curve"                                        : u"Σε καμπύλη",
"To spline"                                       : u"Σε κυβική καμπύλη",
"&Decurve"                                        : u"Αφαίρεση καμπυλότητας",
"Spl&ine"                                         : u"Κυβική καμπύλη",
"Mirrors selected elements with respect to 2d axis": u"Δημιουργεί τα κατοπτρικά αντίθετα ως προς άξονα 2Δ από τα επιλεγμένα στοιχεία",
"Mirrors selected elements with respect to a point": u"Δημιουργεί τα κατοπτρικά ως προς σημείο από τα επιλεγμένα στοιχεία",
"Reverses the orientation of lines, circles, arcs": "Αντιστρέφει τη φορά γραμμών, κύκλων, τόξων",
"Select lines, circles, arcs to reverse orientation:": "Επιλογή γραμμών, κύκλων, τόξων προς αντιστροφή φοράς:",
"Element"                                         : u"Στοιχείο",
"Layer"                                           : u"Διαφάνεια",
"Length"                                          : u"Μήκος",
"Area"                                            : u"Εμβαδό",
"Vertices"                                        : u"Κομβοι",
"Unrecognized command\n"                          : u"Άγνωστη εντολή\n",
"Select new layer for the elements"               : u"Επιλογή νέας διαφάνειας για τα στοιχεία",
"Origin of rotation (Insertion point): "          : u"Κέντρο περιστροφής (I=σημείο εισαγωγής): ",
"Rotation angle"                                  : u"Γωνία περιστροφής",
"Rotation angle (azimuth)"                        : u"Γωνία περιστροφής (γωνία διεύθυνσης)",
"&Modify"                                         : u"Μεταβολή",
"Change &layer"                                   : u"Αλλαγή διαφάνειας",
"&Erase"                                          : u"Διαγραφή",
"&Rotate"                                         : u"Περιστροφή",
"Sc&ale"                                          : u"Μεγέθυνση/σμίκρυνση",
"&Move"                                           : u"Μεταφορά",
"M&irror"                                         : u"Κατοπτρικά αντίθετα",
"Point Mirror"                                    : u"Κατοπτρικά ως προς σημείο",
"&Offset"                                         : u"Παράλληλη αντιγραφή",
"&Break"                                          : u"Κοπή",
"&Trim"                                           : u"Αποκοπή",
"&Fillet"                                         : u"Στρογγύλευση τόξου",
"&Join"                                           : u"Συνένωση",
"Join &2D"                                        : u"Συνένωση 2D",
"Join &gap"                                       : u"Συνένωση κενού",
"&Straighten"                                     : u"Εξομάλυνση",
"Straightens the line between 2 user selected points (not necessarily nodes) of the line.":
                                                    u"Εξομάλυνση γραμμής μεταξύ 2 σημείων (όχι απαραίτητα κόμβων) που επιλέγει ο χρήστης",
"&Move node"                                      : u"Μεταφορά κόμβου",
"Moves an arbitrary node of a line the segments which lead to it.":
                                                    u"Μεταφέρει κόμβο μίας γραμμής και τα ευθύγραμμα τμήματα που συντρέχουν σε αυτόν",
"E&xplode"                                        : u"Διάσπαση",
"Re&verse"                                        : u"Αντιστροφή φοράς",
"Hatch Open"                                      : u"Διαγράμμιση ανοικτή",
"Creates hatch between disjoint lines"            : u"Σχεδίαση διαγράμμισης μεταξύ ανεξάρτητων γραμμών",
"Mirror point: "                                  : u"Σημείο κατοπτρισμού: ",
"Select 2 lines to create draw between:\n"        : u"Επιλογή 2 γραμμών για σχεδίαση διαγράμμισης μεταξύ τους",
"Next line point: "                               : u"Επόμενο σημείο γραμμής: ",
"Next line point (undo/<enter>): "                : u"Επόμενο σημείο γραμμής: (u=αναίρεση προηγούμενου/<enter>): ",
"Next line point (undo/close/<enter>): "          : u"Επόμενο σημείο γραμμής: (u=αναίρεση προηγούμενου/c=κλείσιμο/<enter>): ",
"Distance of hatch lines/Number of hatch lines (enter=Number): ": u"Απόσταση μεταξύ γραμμών διαγράμμισης/N=Πλήθος γραμμών διαγράμμισης (enter=N): ",
"Number of hatch lines (enter=%d): "              : u"Πλήθος γραμμών διαγράμμισης (enter=%d): ",
"Save command window text"                        : u"Αποθήκευση κειμένου που βρίσκεται στο παράθυρο εντολών",
"Save command window text was completed."         : u"Η αποθήκευση κειμένου ολοκληρώθηκε.",
"Origin of scale (Insertion point): "             : u"Κέντρο μεγέθυνσης/σμίκρυνσης [I=σημείο εισαγωγής]: ",
"Scale factor: "                                  : u"Συντελεστής μεγέθυνσης/σμίκρυνσης: ",
"Origin or Delta coordinates: "                   : u"Σημείο προέλευσης ή Δέλτα συντεταγμένες: ",
"Destination or <enter>: "                        : u"Σημείο προορισμού ή <enter>: ",
"Zoom &Selection"                                 : u"Εστίαση σε επιλογή",
"Create &DTM"                                     : u"Δημιουργία ΨΜΕδ",
"Creates a DTM from 3D lines"                     : u"Δημιουργία Ψηφιακού Μοντέλου Εδάφους από τρισδιάστατες γραμμές",
"Computes and shows the z coordinate at an arbitrary point": u"Υπολογίζει και τυπώνει τη συντεταγμένη z σε αυθαίρετο σημείο",
"DTM/DEM &Z"                                      : u"ΨΜΕδ/ΨΜΕπ Z",
"Add Z to &Points"                                : u"Πρόσθεση Z σε σημεία",
"Supplies z coordinates to existing points"       : u"Προμηθεύει συντεταγμένες Z σε υφιστάμενα σημεία",
"Add Z to &Lines"                                 : u"Πρόσθεση Z σε γραμμές",
"Supplies z coordinates to existing polylines"    : u"Προμηθεύει συντεταγμένες Z σε υφιστάμενες γραμμές",
"Triangulation"                                   : u"Τριγωνοποίηση",
"Creates and manages triangulation from (2D) points and lines.": u"Δημιουργεί και επεξεργάζεται μία τριγωνοποίηση από (διδιάστατα) σημεία και γραμμές",
"Engineering Pro&file"                            : u"Σχέδιο Μηκοτομής",
"&Quick Profile"                                  : u"Γρήγορη μηκοτομή",
"Creates an engineering drawing with the profile of a (3D) line":
                                                    u"Δημιουργεί λεπτομερές σχέδιο μηκοτομής μιας τρισδιάστατης γραμμής",
"Creates quickly the profile of a (3D) line"      : u"Δημιουργεί γρήγορα τη μηκοτομή μιας τρισδιάστατης γραμμής",
"Specify corner of window, enter a scale factor (nX or nXP), or\n": u"Καθορίστε κορυφή παραθύρου, δώστε ένα συντελεστή μεγέθυνσης (nX ή nXP), ή\n",
"(All/Center/Dynamic/Extents/Previous/Scale/Window/seLection) <real time>:":
    u"(A=όλα/C=κέντρο/D=δυναμική/E=όρια/P=προηγούμενη/S=συντελεστής μεγέθυνσης/W=παράθυρο/L=επιλογή) <πραγμ.χρόνος>:",
"Invalid point, factor or option. Try again.\n"   : u"Μη έγκυρο σημείο, συντελεστής ή επιλογή. Προσπαθείστε πάλι.\n",
"Select elements to zoom to\n"                    : u"Επιλέξτε αντικείμενα για προβολή\n",
"Invalid or empty previous selection."            : u"Η προηγούμενη επιλογή ήταν άκυρη ή άδεια.",
"<varies>"                                        : u"ποικίλει",
"Regenerating drawing.."                          : u"Αναδημιουργία σχεδίου..",
"end of regeneration.\n"                          : u"τέλος αναδημιουργίας.\n",
"Nothing left to undo!"                           : u"Δεν υπάρχει προηγούμενη εντολή για αναίρεση!",
"&Run script"                                     : u"Εκτέλεση δέσμης εντολών",
"Text size"                                       : u"Μέγεθος κειμένου",
"Text location"                                   : u"Τοποθεσία κειμένου",
"below previous text"                             : u"κάτω από προηγούμενο κείμενο",
"Text:\n"                                         : u"Κείμενο:\n",
"Size: %s    Angle: %s\n"                         : u"Μέγεθος: %s    Γωνία: %s\n",

"Open script file (with ThanCad's commands)"      : u"Ανοιγμα αρχείου δέσμης (με εντολές του ThanCad)",
"&Polygon"                                        : u"Πολύγωνο",
"E&dit Text"                                      : u"Διόρθωση Κειμένου",
"Edit named &Point"                               : u"Διόρθωση ονοματισμένου Σημείου",
"Convert to named Poi&nt"                         : u"Μετατροπή σε ονοματισμένο σημείο",
"Lets the user edit any text interactively"       : u"Δίνει τη δυνατότητα στο χρήστη να διορθώνει κείμενο διαδραστικά",
"Lets the user edit any named point interactively": u"Δίνει τη δυνατότητα στο χρήστη να διορθώνει ονοματισμένα σημεία διαδραστικά",
"First polygon corner: "                          : u"Πρώτη κορυφή του πολυγώνου: ",
"Second polygon corner: "                         : u"Δεύτερη κορυφή του πολυγώνου: ",
"Next polygon corner (Undo): "                    : u"Επόμενη κορυφή του πολυγώνου (U=αναίρεση): ",
"Select text to edit: "                           : u"Επιλογή κειμένου προς διόρθωση: ",
"Edit text"                                       : u"Διόρθωση κειμένου",
"Invalid Point. Try again.\n"                     : u"Μη έγκυρο σημείο. Προσπαθείστε πάλι.\n",
"Invalid point or option. Try again.\n"           : u"Μη έγκυρο σημείο ή επιλογή. Προσπαθείστε πάλι.\n",
"&Research"                                       : u"Έρευνα",
"D&eveloper"                                      : u"Προγραμματιστής",
"Show &font"                                      : u"Προβολή γραμματοσειράς",
"Show &dimensions"                                : u"Προβολή διαστάσεων",
"&Save CMD text"                                  : u"Αποθήκευση κειμένου εντολών",
"&Help"                                           : u"Βοήθεια",
"&Introduction"                                   : u"Εισαγωγή",
"&GPL"                                            : u"Άδεια GPL",
"&About"                                          : u"Περί",
"Change Layer.."                                  : u"Αλλαγή διαφάνειας..",

"Instructions about this dialog"                  : u"Οδηγίες για αυτό το διάλογο",
"Information about this program"                  : u"Πληροφορίες για αυτό το πρόγραμμα",

"&Scan Image"                                     : u"Σάρωση Εικόνας",
"Acquires image from scanner"                     : u"Εισάγει εικόνα από σαρωτή",
"Scan image and insert to ThanCad"                : u"Σάρωση εικόνας και εισαγωγή στο ThanCad",
"Insert Image\nto drawing"                        : u"Εισαγωγή Εικόνας\nστο σχέδιο",
"Scan"                                            : u"Σάρωση",
"Rotate left 90deg"                               : u"Περιστροφή αριστερά 90deg",
"Rotate 180deg"                                   : u"Περιστροφή 180deg",
"Rotate right 90deg"                              : u"Περιστροφή δεξιά 90deg",
"Redraw Image"                                    : u"Επανασχεδίαση Εικόνας",
"Save Image\nto file"                             : u"Αποθήκευση Εικόνας\nσε αρχείο",
"Filename to save image"                          : u"Όνομα αρχείου για αποθήκευση εικόνας",
"Image filename: %s"                              : u"Αρχείο εικόνας: %s",
"Bounding box: %s"                                : u"Περιγεγραμμένο ορθογώνιο: %s",
"Angle (not used): %s\n"                          : u"Γωνία (δεν χρησιμοποιείται): %s\n",

"Lower-left image point (rectification/pixel/mm/cadastre/<enter>): ":
                                                    u"Σημείο κάτω-αριστερά της εικόνας (r=αναγωγή/p=εικονοσημεία/m=mm/c=κτηματολόγιο/<enter>): ",
"Image width in user data units: "                : u"Πλάτος εικόνας σε μονάδες σχεδίου: ",
"Regenerating image.."                            : u"Αναδημιουργία εικόνας..",
"Scanned Image has not been saved, OK to discard?": u"Η σαρωμένη Εικόνα δεν έχει αποθηκευτεί, Εντάξει να χαθεί;",
"Warning"                                         : u"Προειδοποίηση",
"No image has been scanned!"                      : u"Δεν έχει σαρωθεί καμμία εικόνα!",
"Please save scanned Image"                       : u"Παρακαλώ να αποθηκεύεσετε τη σαρωμένη Εικόνα",
"Spans: %s    to: %s\n"                           : u"Καλύπτει: %s    έως: %s\n",
"Vertices %d (X Y Z Radius):\n"                   : u"Κορυφές %d (X Y Z Ακτίνα):\n",



"Extend"                                          : u"Επέκταση",
"Extends lines and arcs until they cross other elements being the boundary edges":
                                                    u"Επεκτέινει γραμμές και τόξα κύκλου μέχρι να τμήσουν"\
                                                    u"άλλα στοιχεία που είναι τα όρια",
"Select elements to be used as boundary edges, or press enter to select all elements on display:":
                                                    u"Επιλογή στοιχείων (που δρουν ως όρια), ή πατείστε "\
                                                    u"enter για επιλογή όλων των στοιχείων στην οθόνη",
"Extension method"                                : u"Μέθοδος επέκτασης",
"The extended element replaces the original element": u"Το επεκταμένο στοιχείο αντικαθιστά το αρχικό στοιχείο",
"The extended element replaces the original element but retains the original end node (lines only)":
                                                     u"Το επεκταμένο στοιχείο αντικαθιστά το αρχικό "\
                                                     u"στοιχείο αλλά διατηρεί το αρχικό άκρο (μόνο σε γραμμές)",
"The extended element contains only the net extension and the original element is retained":
                                                    u"Το επεκταμένο στοιχείο περιέχει μόνο την καθαρή "\
                                                    u"επέκταση και το αρχικό στοιχείο διατηρείται",
"Select extension method (1/2/3) <1>: "           : u"Επιλογή μεθόδου επέκτασης (1/2/3) <1>: ",
"Select an element to extend"                     : u"Επιλογή στοιχείου προς επέκταση",
"Element extension does not intersect boundary edges": u"Η επέκταση του στοιχείου δεν τέμνει κανένα όριο",

"F&ractal demo"                                   : u"Επίδειξη κλασματικού",
"&Units"                                          : u"Μονάδες",
"Unit management"                                 : u"Διαχείριση μονάδων",
"LENGTH UNITS:"                                   : u"ΜΟΝΑΔΕΣ ΜΗΚΟΥΣ:",
"meters (m)"                                      : u"μέτρα (m)",
"feet (ft)"                                       : u"πόδια (ft)",
"Length unit"                                     : u"Μονάδα μήκους",
"Decimal digits"                                  : u"Δεκαδικά ψηφία",
"ANGLE UNITS:"                                    : u"ΜΟΝΑΔΕΣ ΓΩΝΙΑΣ:",
"degrees (deg)"                                   : u"μοίρες (deg)",
"radians (rad)"                                   : u"ακτίνια (rad)",
"gradians (grad)"                                 : u"βαθμοί (grad)",
"Angle unit"                                      : u"Μονάδα γωνίας",
"ANGLE ORIENTATION:"                              : u"ΠΡΟΣΑΝΑΤΟΛΙΣΜΟΣ ΓΩΝΙΩΝ:",
"at 3 o'clock"                                    : u"ώρα 3",
"at 12 o' clock"                                  : u"ώρα 12",
"at 9 o' clock"                                   : u"ώρα 9",
"at 6 o' clock"                                   : u"ώρα 6",
"Angle is zero at"                                : u"Η γωνία είναι μηδέν\nόταν η ώρα είναι",
"anti-clockwise"                                  : u"ανθωρολογιακά",
"clockwise"                                       : u"ωρολογιακά",
"Positive angle\ndirection"                       : u"Θετική φορά γωνίας",
"&Elevation"                                      : u"Υψόμετρο",
"Elevation (higher dimensions)"                   : u"Υψόμετρο (υψηλότερες διαστ)",
"&Highlight zero elevation"                       : u"Επισήμανση μηδενικού υψομέτρου",
"Joins 2 lines filling the gap between them."     : u"Ενώνει 2 γραμμές καλύπτοντας το ενδιάμεσο κενό",
"C&hange elevation"                               : u"Αλλαγή υψομέτρου",
"Change elevation (higher dim)"                   : u"Αλλαγή υψομέτρου (υψηλότερες διαστ)",
"This drawing has only %d dimensions. The elevation":
                                                    u"Αυτό το σχέδιο έχει μόνο %d διαστάσεις. Το υψόμετρο",
"of dimension z can also be set with the CHELEV command.":
                                                    u"της διάστασης z μπορεί επίσης να δοθεί με την εντολή CHELEV.",
"This drawing has only %d dimensions. The elevation and thickness":
                                                    u"Αυτό το σχέδιο έχει μόνο %d διαστάσεις. Το υψόμετρο και το πάχος",
"of dimension z can also be set with the ELEV command.":
                                                    u"της διάστασης z μπορεί επίσης να δοθεί με την εντολή ELEV.",
"Current elevations of z and higher dimensions:"  : u"Τρέχοντα υψόμετρα της διάστασης z και υψηλοτέρων:",
"Enter new elevations separated by coma (enter="  : u"Δώστε νέα υψόμετρα διαχωρισμένα με κόμα (enter=",

"Changes the z coordinate of selected elements"   : u"Αλλάζει το συντεταγμένη z των επιλεγμένων στοιχείων",
"Change co&ntour line elevation"                  : u"Αλλαγή υψομέτρου ισοϋψών",
"Changes the z coordinate of many lines progressively": u"Αλλάζει τη συντεταγμένη z πολλών γραμμών προοδευτικά",
"Current elevation:"                              : u"Υφιστάμενο υψόμετρο",
"New elevation (enter="                           : u"Νέο υψόμετρο (enter=",
"Select first contour line to elevate.."          : u"Επιλογή πρώτης ισοϋψούς προς αλλαγή υψομέτρου..",
"No element selected. Try again."                 : u"Μηδενική επιλογή. Προσπαθείστε πάλι.",
"Select last contour line to elevate.."           : u"Επιλογή τελευταίας ισοϋψούς προς αλλλαγή υψομέτρου..",
"Elevation of first contour line (enter="         : u"Υψόμετρο πρώτης ισοϋψούς (enter=",
"A real number is required. Try again.\n"         : u"Χρειάζεται να δώσετε ενα πραγματικό αριθμό. Προσπαθείστε πάλι.\n",
"Elevation of last contour line (enter="          : u"Υψόμετρο τελευταίας ισοϋψούς (enter=",
"No lines were met between first and last line."  : u"Δεν βρέθηκαν γραμμές μεταξύ της πρώτης και τελευταίας γραμμής.",
"Error: An interim contour line is met more than once:": u"Λάθος: Μία ενδιάμεση ισοϋψής συναντάται περισσότερες από μία φορά:",
"The elevation must increase/decrease monotonically between first and last line.":
                                                    u"Το υψόμετρο πρέπει να αυξάνεται/μειώνεται μονότονα μεταξύ πρώτης και τελευταίας γραμμής.",
"Warning: delta z is not a integer: %s\n"         : u"Προειδοποίηση: η διαφορά z δεν είναι ακέραια: %s\n",
"Continue (yes/no) (enter=yes): "                 : u"Συνέχεια (ναι/όχι) (enter=ναι): ",
"\n<Object snap is off>\n"                        : u"\n<Τα μαγνητικά σημεία είναι απενεργοποιημένα>\n",
"\n<Object snap is on>\n"                         : u"\n<Τα μαγνητικά σημεία είναι ενεργοποιημένα>\n",
"\n<Ortho off>\n"                                 : u"\n<Ο περιορισμός οριζοντίων/κατακορύφων γραμμών είναι απενεργοποιημένος>\n",
"\n<Ortho on>\n"                                  : u"\n<Ο περιορισμός οριζοντίων/κατακορύφων γραμμών είναι ενεργοποιημένος>\n",
"\n<View %s coordinates>\n"                       : u"\n<Προβολή συντεταγμένων %s>\n",
"\nWARNING: Clipboard is unaffected."             : u"\nΠΡΟΕΙΔΟΠΟΙΗΣΗ: To πρόχειρο (clipboard) δεν έχει μεταβληθεί.",
"%d curves were succesfully decurved."            : u"Η καμπυλότητα αφaιρέθηκε επιτυχώς από %d καμπύλες.",
"%d generated line segments in DTM."              : u"Δημιουργήθηκαν %d γραμμές στο ΨΜΕ.",
"%d points with invalid z were put into layer %s.": u"%d σημεία με λάθος z τοποθετήθηκαν στη διαφάνεια %s.",
"%d profiles were created."                       : u"Δημιουργήθηκαν %d μηκοτομές.",
"%d triangles were generated."                    : u"Δημιουργήθηκαν %d τρίγωνα.",
"%d unknown elements were not imported"           : u"Δεν έγινε εισαγωγή %d άγνωστων στοιχείων.",
"%d/%d lines were transformed to 3d."             : u"%d/%d γραμμές μετατράπηκαν σε τρισδιάστατες.",
"%d/%d points were transformed to 3d."            : u"%d/%d σημεία μετατράπηκαν σε τρισδιάστατες.",
"%s\nPlease create new drawing for the rectification": "%s\nΠαρακαλώ να φτειάξετε νέο αρχείο σχεδίου για την ορθοαναγωγή",
"(Warning: This command, if completed, can not be undone)": u"(Προειδοποίηση: Αυτή η εντολή, όταν ολοκληρωθεί, δεν θα μπορεί να ακυρωθεί)",
"<Brighten images>"                               : u"<Αύξηση φωτεινότητας εικόνων>",
"<Coords off>"                                    : u"<Προβολή συντεταγμένων απενεργοποιημένη>",
"<Coords on>"                                     : u"<Προβολή συντεταγμένων ενεργοποιημένη>",
"<Darken images>"                                 : u"<Μείωση φωτεινότητας εικόνων>",
"A positive real number is required. Try again.\n": u"Αναμένεται ένας θετικός πραγματικός αριθμός. Προσπαθείστε πάλι.\n",
"About"                                           : u"Περί",
"An integer number is required. Try again.\n"     : u"Αναμένεται ένας ακέραιος αριθμός. Προσπαθείστε πάλι.\n",
"Backwards"                                       : u"Προς τα πίσω",
"Base point: "                                    : u"Σημείο αναφοράς: ",
"Bitmap"                                          : u"Άσπρο/μαύρο",
"CHANGES DETECTED"                                : u"ΑΝΙΧΝΕΥΘΗΚΑΝ ΑΛΛΑΓΕΣ",
"Camera"                                          : u"Φωτομηχανή",

"&Background colour"                              : u"Χρώμα παρασκηνίου",
"Changes the canvas background colour"            : u"Αλλαγή του χρώματος παρασκηνίου του καμβά",
"&Encoding"                                       : u"Κωδικοποίηση",
"Changes the encoding for reading/writing text files": u"Αλλάζει την κωδικοποίηση για την ανάγνωση/εγγραφή αρχείων κειμένου",
"Choose encoding for text files"                  : u"Επιλογή κωδικοποίησης για αρχεία κειμένου",
"Current encoding is: "                           : u"Η τρέχουσα κωδικοποίηση είναι: ",
"Encoding set to: "                               : u"Η κωδικοποίηση έγινε: ",
"Inserts a new image to the current drawing"      : u"Εισαγωγή νέας εικόνας στο τρέχον σχέδιο",
"Import tiled Image"                              : u"Εισαγωγή τεμαχισμένης εικόνας",
"Inserts a Digital Globe image split into multiple tiles": u"Εισαγωγή εικόνας της Digital Globe που είναι χωρισμένη σε πολλαπλά τεμάχια",
"Import/convert TerraSAR Image"                   : u"Εισαγωγή/μετατροπή εικόνας TerraSAR",
"Convert a complex pixel valued TerraSAR image to 8bit GeoTiff and inserts it to the current drawing":
    u"Μετατροπή εικόνας TerraSAR μιγαδικών pixels σε GeoTiff 8bits και εισαγωγή της στο τρέχον σχέδιο",
"TerraSAR image file open failed"                 : u"Αποτυχία ανοίγματος εικόνας TerraSAR",
"Locates the image file of an image"              : u"Προσδιορισμός της θέσης του αρχείου μίας εικόνας",
"Locates the directory for missing image files"   : u"Προσδιορισμος της θέσης φακέλλου που περιέχει αρχεία από εικόνες που λείπουν",
"Embed images"                                    : u"Ενσωμάτωση εικόνων",
"Saves the images into ThanCad's native file (.thcx)": u"Αποθήκευση εικόνων σε εγγενές αρχείο του ThanCad (.thcx)",
"Clips an image to a smaller rectangle"           : u"Κάνει (μικρότερο) ορθογωνικό απόσπασμα μίας εικόνας",
"Manages the mode of rendering images"            : u"Διαχείριση του τρόπου απόδοσης των εικόνων",
"&Interpolate line"                               : u"Παρεμβολή σημείων σε γραμμή",
"&Ellipse"                                        : u"Έλλειψη",
"Traces a curve in a bitmap raster image"         : u"Ιχνηλατηση καμπύλης σε εικόνα bitmap",
"Tr&iangulation"                                  : u"Τριγωνισμός",
"Lets the user convert points to named points interactively": u"Διαδραστική μετατροπή σημείων σε ονοματισμένα σημεία",
"Changes the z and higher coordinates of selected elements": u"Αλλαγή του z και υψηλότερων διαστάσεων σεε πιλεγμένα στοιχεία",
"Shows font for debugging"                        : u"Προβολή γραμματοσειράς για εκσφαλμάτωση",
"Shows window dimensions for debugging"           : u"Προβολή διαστάσεων παραθύρου για εκσφαλμάτωση",
"Saves the text of the command window"            : u"Αποθήκευση κειμένου του παραθύρου εντολών",
"Saves translation status to a file"              : u"Αποθήκευση της απογραφής μετάφρασης σε αρχείο",
"Show &handles"                                   : u"Προβολή κωδικών",
"Shows element handles for debugging"             : u"Προβολή των κωδικών των στοιχείων για εκσφαλμάτωση",
"Demonstrates a fractal made of colored lines"    : u"Επίδειξη κλασματικού από έγχρωμες γραμμές",
"Run &tests"                                      : u"Εκτέλεση ελέγχων",
"Runs unit tests of ThanCad"                      : u"Εκτέλεση μοναδιαίων ελεχων του ThanCad",
"ThanDrawing"                                     : "1",
"La Universitat de Valencia"                      : u"Πανεπιστήμιο Βαλέντσιας",
"Purge [Layers/Objects/Do-undo history] <L>: "    : u"Εκκαθάριση [L=διαφάνειες/O=αντικείμενα/D=ιστορία αναίρεσης/επαναφοράς] <L>: ",
"Choose image tiles"                              : u"Επιλογή τεμαχίων εικόνας",
}

T = Translation(en2gr)
#T.thanLangSet("en", thancadconf.thanTranslateTo)
del en2gr


if __name__ == "__main__":
    print(__doc__)
