from __future__ import print_function
import sys, base64, tkinter

__icons = None
__tk = "An improbable value for Tk :)"
self = sys.modules[__name__]

def get(name, **kw):
    """Return a PhotoImage object named name.

    The image is created calling the local function function name().
    The created image is cached  __icons, so that a hard
    reference to the image always exists in order to keep it alive.
    If the same image is asked again, a reference to the created image
    is returned and thus we save memory.
    If tkinter library is initialised, then destroyed and then reinitialised,
    the images are invalidated and produce error if you try to display
    them. Thus get() checks for Tk reinitialisation and deletes the
    cached images.
    """
    global __icons, __tk
    try: dero = tkinter._default_root
    except: import Tkinter; dero = Tkinter._default_root   #Ease the trasition to python3
    if __tk != dero:
        if __icons is not None: print("Module", __name__, ": Reinitialise images")
        __icons = {}
        __tk = dero

    try: return __icons[name]
    except: pass
    fun = getattr(self, name)
    try: ph = tkinter.PhotoImage(data=fun())
    except: ph = tkinter.BitmapImage(data=base64.decodebytes(fun()), **kw)
    __icons[name] = ph
    return ph

def cancel(): return b'\
    R0lGODlhEAAQAPECAAAAAK+0n////wAAACH5BAEBAAIALAAAAAAQABAAAAKRlChRokSJEiVKFAhR\
    okSJEgVClAhQokSJEgFKlCgQokSJAiFKlCgRoESJACVKlChRIESBECVKlChRIkCAEiVKlChRokCI\
    EiVKlChRIkCAEiVKlChRIESBECVKlCgRoESJACVKlCgQokSJAiFKlAhQokSJEgFKFAhRokSJEgVC\
    lChRokSJEiVKlChRokSJEiVKBQA7'

def clear(): return b'\
    R0lGODlhEAAQAKIAANnZ2QAAAP//AICAAMDAwP///////////yH5BAEAAAAALAAAAAAQABAAAANm\
    CLrciqHLCwgQAIEAoaEYABCAEAABCAEQgAAYuryAAAEQCBCqqgAFQAAgAIYqAGAEgmqgqAYABoJq\
    oKhGIOhCoKjGBIJuoKjGDAaCaiCpxgwGgm4gqcYEgi4EkmoEgu5i6CLocjsmADs='

def help(): return b'\
    R0lGODlhEAAQAJEAANnZ2QAAAP//AP///yH5BAEAAAAALAAAAAAQABAAAAJIhI+pEEEJ4WOEiJAS\
    gg9B8i0IfohEBMkh+BBxIaQQPlqIBMFHCJEg+AghEgQfIUSC4KNFRBB8TN0ISggfLUSC4KNFRBB8\
    TIUCADs='

def move(): return b'\
    R0lGODlhEAAQAPECAAAAAK+0n////wAAACH5BAEBAAIALAAAAAAQABAAAAKRlChRokSJEiVKlChR\
    okCIEiVKlChRIkCAEiVKlChRIECAECVKlChRokCIEiVKlChQokCIEiFKlAhQokCIEgFKFAgQIECA\
    AAFCFAgQIECAAAFClAhQokCIEgFKlChQokCIEiFKlChRokCIEiVKlChRIECAECVKlChRIkCAEiVK\
    lChRokCIEiVKlChRokSJEiVKBQA7'

def new(): return b'\
    R0lGODlhEAAQAJEAANnZ2QAAAP///////yH5BAEAAAAALAAAAAAQABAAAAJJhI+JFD8I/gXJjiD4\
    FiQ7JAg+BMmOiCD4QfItCH6QfAuCHyTfguAHybcg+EHyLQh+kHwLgh8k34LgB8m3IPhB8i0IPsVH\
    go+JBQA7'

def open(): return b'\
    R0lGODlhEAAQAJEAANnZ2QAAAP//AICAACH5BAEAAAAALAAAAAAQABAAAAJNhI+pGEEhfLS4AArh\
    I0ZcUEL4EBEWJDM+wQ+Sb0Hwg+RbEPwg+RYEP0REKP4BhAgpnG8BEEIK51sAQJCyiZgZWgAAETTf\
    gmBTfCT4mFoAOw=='

def regen(): return b'\
    R0lGODlhEAAQAPEDAACAAP8AAK+0n////yH5BAEBAAMALAAAAAAQABAAAAKR3Lhx48aNGzdu3Lhx\
    48aNAzdu3Lhx48aNAzFuHAgQIECAAAFuHAgQIECAAAFu3Lhx48aNAzFu3Lhx48aNAzdu3Lhx48aN\
    Gzdu3Lhx48aNGzdu3Lgx48aNGzdu3Lgw48aNGzdu3JgwYcKECRNm3JgwYcKECRNm3Lgw48aNGzdu\
    3Lgx48aNGzdu3Lhx48aNGzduBQA7'

def run(): return b'\
    R0lGODlhEAAQAPIFAAAAAFhYWAAAgP8AAK+0n////wAAAAAAACH5BAEBAAUALAAAAAAQABAAAAOW\
    WFVVhVVVVVhVVYVVUlU4VVWCVSUiKFI1hVUlVVhVJYU1U1VYUlWFVVUACFAlglJVVVhQVYVQJVVY\
    VQWFUAUFWFVVgzNQFRhVMIVVVTUIVRGFBTNTWFUFhVAFBVhVVYVSBVVYBVWFVSUiWAUAgFVVVVgl\
    VYU1UyVYVVWFUlU1WCUiglJVUlhVU4UlVVVYVVWFVVVVWFWVADs='

def save(): return b'\
    R0lGODlhEAAQAJEAANnZ2QAAAICAgMDAwCH5BAEAAAAALAAAAAAQABAAAAJZhI9pFB8RIITC+RYQ\
    ABSF5ltEAFAUmm8hAUBRaL6FBABFofkWEgAUheZbSABQJIpvIgFAoXy0AAiSGP8kAIIkxgcICSBE\
    QvEBQgIIkVB8gJAAAhgfj+BjWgEAOw=='

def saveas(): return b'\
    R0lGODlhEAAQAKIAANnZ2QAAAICAgMDAwP//AICAAP///////yH5BAEAAAAALAAAAAAQABAAAANt\
    CLrciqHLDAghgaOrARgAIYGjqxEYACGBo6shGAAhgaOrIRgAIYGjqyEYACGBMxGqGBIAgSIRRBiq\
    EoAQIhJIqiGCARAiGEFEqgoBhEhgEAWWagBgiEQQBpZqBCCESAQGlmpIICiGLi+CLrdiAgA7'

def zoomall(): return b'\
    R0lGODlhEAAQAPEDAAAAAP//AK+0n////yH5BAEBAAMALAAAAAAQABAAAAKR3Lhx48aNGzdu3Lhx\
    YcKEGTdu3LgxYcKECTdu3LgwYcKECTNu3JgQIMKAABNuXJgQYMKEABNmXJgQIcKAARNmXJgwYUCE\
    CRNmXJgwYUCECRNmXJgQIcKAARNmXJgQYMKEABNm3JgQIMKAABNu3LgwYcKECTNu3LgxYcKECTdu\
    3LhxYcKEGTdu3Lhx48aNGzduBQA7'

def zoomin(): return b'\
    R0lGODlhEAAQAPEDAAAAAP//AK+0n////yH5BAEBAAMALAAAAAAQABAAAAKR3Lhx48aNGzdu3Lhx\
    YcKEGTdu3LgxYcKECTdu3LgwYUCECTNu3JgwYUCECRNuXJgwYUCECRNmXJgwYUCECRNmXBgQIECA\
    ABFmXBgQIECAABFmXJgwYUCECRNmXJgwYUCECRNm3JgwYUCECRNu3LgwYUCECTNu3LgxYcKECTdu\
    3LhxYcKEGTdu3Lhx48aNGzduBQA7'

def zoomout(): return b'\
    R0lGODlhEAAQAPEDAAAAAP//AK+0n////yH5BAEBAAMALAAAAAAQABAAAAKR3Lhx48aNGzdu3Lhx\
    YcKEGTdu3LgxYcKECTdu3LgwYcKECTNu3JgwYcKECRNuXJgwYcKECRNmXJgwYcKECRNmXBgQIECA\
    ABFmXBgQIECAABFmXJgwYcKECRNmXJgwYcKECRNm3JgwYcKECRNu3LgwYcKECTNu3LgxYcKECTdu\
    3LhxYcKEGTdu3Lhx48aNGzduBQA7'

def floppy(): return b'\
    R0lGODlhMAAwAMZFAAAAAAAAEREAABEAEQARAAARERERERERIiIRIiIRMzMRMxEiIhEiMyIiIiIi\
    MyIiRDMiMzMiRDMiVUQiVSIzMyIzRDMzRDMzVTMzZkQzVUQzZkQzd1UzZjNEVTNEZkREVUREZkRE\
    d1VEZlVEd0RVZlVVVVVVZlVVd2ZmZoh3iIh3u4iId4iIiIiIqpmIu4iZqpmZqpmZu6qZu4iqqpmq\
    u6qqqqqqu6qqzLuqzLuq3aq7u7u7zLu73cy73bvMzLvM3czMzMzM3d3M3czd3d3d3f//////////\
    ////////////////////////////////////////////////////////////////////////////\
    ////////////////////////////////////////////////////////////////////////////\
    /////////////////////////////////////////////////////////////////////////yH+\
    EUNyZWF0ZWQgd2l0aCBHSU1QACH5BAEKAH8ALAAAAAAwADAAAAf+gH+Cg4SFhoeIiYQojI2Oj5CR\
    kpCGk5aXmCiFjACdnSUjJikrLCyjpaempKqoq6clnp0OMIOcAAQBBDAkI0W+v8DBwsIjJAAOD8hD\
    tSidAgADL6HD1NW/JiMACQ7cQswAuQMFu73W5sGhx8kPy4K2A9DSJuf0viYixw4QDkTfAQX/yNWj\
    V0ydsm/QCESbNtAcNgARHET05q6ZOHECG1pLJ7FChHZ/OCk0sHCexmr3IErk9+3iOF4nqxWs8MAj\
    SE4kScqLSe1hxAgRKIa0WOCAgYw80ZkA4LGChJvNcpZMKiwl0AgW+lUEYMDAgZflqP6aGcEpVK4D\
    vO4Uey0bVqz+QjkZPXAAKdt0Ti08/ebVAIK1bItYtYBV61AAdOnaFTtTQoULZ/36BczWp14LcZsl\
    XrCYKt4LoCMjOPA3VI7AOVJKuGxY7oIDnHmROE01h2wAoEN/I01aXqjf2IIDHy68eLbVEi5k1rYg\
    QfMav3lhk14suvXp1nHnhvxtAYLvzWOJH0+e/AQLoCdcaN3MuXMHDBIw4EYfGTIKycrqd8rf8fbt\
    GZx1gHsNJFCgA9two8BKPzEI1GXIQXiBehko9417CM5H3zrIPODhfmU5FuF/F2BwgQYnnlXgitsk\
    qA+DDHr0IFYRnlchhRdUyN4x8WlYHwwvwDADkEISOWSQRxb+iSQMAFSIogYqGtgifTCwaKWUV65Y\
    g3BNnpjBcvLVt84LCfzQgw9BmImmmmn2EEQPO+Bgww1FVLfUiR5A+c2BLu5T5ZnAlADEmT0MOmic\
    NsgQg2Ch4KNBBhp8sCM3HK4zQwJoFlHCpgCc2eabPsh5Aw2LnnBbBxqgehaC9C0Y0Z9AaMqpD4XW\
    iqiiLrzA6EOPaqDBcpV2FAGZZsoKy6dwikrqCy3UKR0Aeea5Kjf7NPinD8YCYGiyicaQawvNBueo\
    ryDsWClNHl2a6aawEBrqnMu28EKpt0ULwqoN/vQArNnSequ3zLbgAg27ZqMBCAcDK+wD+hHLQ7bc\
    jhoDs/N10oCDs+nkCcIGIIV0TL4PVomDDtn++63ANuCww66OgsBBuYYwVROIl+pwAyyeKDuxvDHQ\
    cEOmpha0MQghdDzIxwx7ZEGVMiRKQ9NQAwzuwCr3METBABy8AQhCFRIBEUQMAXY/JSSVAw9nqyA2\
    2Iq07fbbhQQCADs='


def line2(): return b'\
    R0lGODlhIAAgAIQcAP8Av/8Kwv8Rw/8Zxf8axv8myf8oyf9Az/9F0P9I0f9V1P9Y1fxm1/xq2Pxr\
    2P+H4f+P4/+X5f+f5/+k6P+o6f+u6/Ly8v/r+vf39//y/P/z/P/1/f///////////////yH+FUNy\
    ZWF0ZWQgd2l0aCBUaGUgR0lNUAAsAAAAACAAIAAABcggJ45kaY6apKqVaGFwLM801hRJnhAUh53A\
    0+JBSkR8weRoyLmIjEhlclgROKE/aXBxCLQ4WG1QAUBAzoZjVlyqBBSL+KKRibJH7u8ou77nTXx3\
    In+AIn1ahIV2iF5BgWKJJ49SkZKGjHqOl0qVQJNAnZ6boI1in22lpqOomVqng6lsr6FSp7S1HBsO\
    cgsKsYI/EQUPxAcACoIlwQmwBwvJJMtNAhUPz9CXEcxNHNbY2dsi3t8/EwM6CQUMNew1FiIUEfLy\
    dd8iIQA7'

def ntua3(): return b'\
    R0lGODlhbgBtAOfpAAABAAACAAkBAAEEAAIFAQoDAQQHAgUIBAcJBQgLBwoMCA0MAA4NAgwOCg8O\
    AxAPBREQBhASDxMSCBYTAhMVEhgVBRkWBxcWDhwXAh0WCRoXCRcYFh0ZBRsZDCEZBx4aBxobGSMb\
    CiAcCiMdBR8dEigeCSMfDyUgCiEgGichBCkjCCIjISgkDy4jCS0lAyslCy4nBTImBiwnEionHC8o\
    BzApCS8pDzUoCi4qGjMrDDArFyosKTMsEzksBzYtBy0uLDwuCzoxDDgxEjcxFz4wDTQxJkAxBzAy\
    L0EzCT00Dz41CkM0C0Q1DDQ2M0Y3DkE4E0g4CEM5D0E5GUk5EEo6Cko6Eks7C008DUk+DEk+FE8+\
    D1A/CFA/Dz5APUpAG1JAClJBElVDDUJEQVdFD1JGFVZFFllGB1NHHFpHCUZIRVxIC1tIElZKGV5K\
    DUlLSF9MD19MFmFNEFpOI1xPF2JOEWNPEl1QH2VQCmRQG1BST2dSDWNUFmhTF2lUD1NVUmFVKWtV\
    EWVXH21XE25YCmVYJm1YHHBZDWlbI1lbWHFbF3NcEHVeEndfFHhgC15gXXNgI3phDXtiDnliH2Fj\
    YHtjGHxkEH5lEoBnFGZoZYBoHoRqDYRqGIZsEH9tJ4htEohuHIlvFItwFo5yDY9zD4tyKJB0EZVz\
    EZB0G5J2E5R3FXV3dJN3HpV4FpZ5F5t4GJl7Dnp8eZt9EaB8Epp9HJp+JZ5/FKWAGH+BfqCCGKeC\
    DqGDI6SFD6SFHIOFgquFE6eIFK2HFqeIH6qKF7CJGbOLD7GLG7COELWNErKQE7ePFbGQH7mRGLuS\
    GrWTI72UDryTG7eVGr+VEcCWE7+WH8KYFbyZIL6aFZeZlsOZGMWbGsOeG8edHMmeD5yem8ieHsug\
    E8SgKMahIMyhFJ+hns2iFs+jGNCkGcqlJNGlG9KmHdSnDsynJqaopdWoINapIamrqLGzr7S2s7m7\
    uL2/vM7QzNLU0dbY1Nnb2N/h3ufp5uvu6vHz8Pb49fn7+Pv9+v7//CH+EUNyZWF0ZWQgd2l0aCBH\
    SU1QACwAAAAAbgBtAAAI/gD/CRxIsKDBgwgTKlzIsKHDhxAjDuxHsR67ixgzyqPYT6LHjyAT9uNn\
    r1eeHwEMBFiJoKXLlTCP5MEkj1/HkDhzJuRXD9ORlAYWqFDDilWrWuqSKq1VtNUaFQsQpDyCqR4/\
    nVhD9pOHCUTKJYZeGVOaFJs0smjJYntlaIlUEG663cxKd+G9Wz8RjPFELK0oUe2W6EnK7Aq2pK/a\
    JK0lLZ1SbLHWLAhw5Fa9upgJ9qs3CcSCJXyVehNlCak6QwgyNdiUlFiAFofb0FA3DIGBHKEccyvr\
    ackCA5Pizc2ss16eAA/QnCUb6YGDG6GSlosTYEG01gEQbCmnYczpCYqy/ljgtksFOrLS1EzOI494\
    TnuwEDhQs1xdNEiC1MXpcZhsuRIPMIPdKRWcYYCAUvTAjGPqiJKDY+JUE0056mCTiAMITHKZexLx\
    0w0ICKDRnzq7UGFADUj9osAdTiyhFDMOLFCBMOq4RkwtBkyATTkTrLQEhV9coU4rI6Q0wjBlGYIh\
    Jvpw+BA9TQRgA5JKAbIABwa0o9QSAXDgxJYZSAPDCNj4EkBfXyhyGgKyXMLIeVf4Io4EPfiSSw4V\
    iKNUNFAEsAI9TjLUCwIQcHKeOsw4UY4oyaizgGnqSLKAlklxg0Ec6kiziDS+EEGhUnEgIIo3SUGD\
    gDiKjMAgOiGwoo4i/p6os+gICNxyVaAG2YMIAlAIqJQtBnyj1BgiKJWLAWoAooKnmwibFlmttOCA\
    Boaoc8oC5XABhFLlLJCKJwsIWdYaCBxhD64E0bMCAoZ8StYCsSjFjQClJJWOEgaoAIgtz/abqSdI\
    xeFiKgK4ok47lhjwygcLPJCUN4dBMsEG46D7zzgITCCKUqxE0h8ULip1RcjqeHOMvyiT9c00SfUQ\
    wAhAGGBIDxIA4oB9JwBCGK3X3OoeP9cgkMN1Si0CQQpoklwjps8e802aI4zAx1gpq9ybGsnsYYAm\
    mjzwiwZ66FkWEgGo4jNm/KgSwBPuKkXMFQu0scQHbfeLTcZSTfAB/gIf1Fe1fwZAoo4m1emMVjlj\
    BIDI2Vnxg0gAVzAYTQ7tKgWMESnVnVY0XLpgySW1KPLIIRiMWDU2h6ETSVK+KJBKv4grzrhOtwTg\
    xW5JSfNAABMAslw5gJygOVrMBNADMW2Ewkw0sdhy5t9JlfLAFbn0l85ysaYV+yR1dYPAGrhv+QAj\
    NHzQhtjlUGr3BAsQo4c0gLQBBRR7+5oyI+mUo4UEvJvOzQRh2M0YKhAEJJUDDQhYHFa8BwXNAQMB\
    wiiHJ4IQvqQo4hc0Qgs2AmCEJVyBVhxglyQMVzUNqAAp3rhDADRBmOjgYgRcYIYGFBAAIHzjFeUw\
    QwCuoRN7bOAE/n7jhtic8IV+eUIHoQhDWjhhgFLUIhOUgAM2gLCJ10GvFj1aghqIAYkiMmMEG8vU\
    A1IxDJUEoAQvqNAXENCekODjCBhQhlK+EYYFLEANzBiGAqhEFmJQwQtcsECmRsSNTdiAX7U4ATeW\
    AAkS/u0bSFBBABSgjkZ1rRxgaEYrHKCH4iEgCUlgYYVOAIJzgcQRBoiOUgwxgmOIIgVGKIcFVocW\
    W0gCSzlIBRRc9RgDxAAaEAgAKwwhiuxBLxqbQBwCyqIJBAxBAlq6QQByEANRLCII/GpNuWbnkGsY\
    QBEMqpEB+lIhCfiCFcAgixqQAgQSrKQOCCCavZhhAFEYQAJz/vjCYKCnFCogYBptYEQqlkC4AEgg\
    KUEAwgK6xoYApIAsnggA9yTiQyiEs0bPSwoGBEcWTjyPOzDpQVraQQxB8CALIyhDB4bwAi1owYop\
    S4cFuMAIA6TCBb5IwkoYISvqWKIV1PGOUtKhBgPEIyL8OAICyOm2AMgiKQkTUGSwoQcOmCcpV+Bd\
    AGiZlkjUIAuKqENWYWLMlMVBABUQJhLGQIw7EAEKDRKACXhwhRQs4BXHIEYYXocNFmxgHxC5RgAU\
    k5RIAKIvVroCIxTAU3XAAAiG4B2kshoHA/jtMXDggRdqMQxizGAMp3jFMJYQuJRFQwMwSUkqpuCW\
    RBg0FSsp/kEuAGEILgQgDlqSBQJg8ZB9bMAG7qjUBzjQAVao7gpXsIRSJtADNATgFbIqbAAYgQD1\
    pYUGOrBEGG1xgtQ+wHTPmpxUVpICT8iBJcyoxcs2QQMHvCIAHxBbO2oQAEA1JD5MbUMRPYEAGoSv\
    HKX4HyDQYIR0nAIBFDITFLTQr3Tw1wBRaMwwYpDalcThov1Chye2cAME7KK7AdDANziAgyuoxAIe\
    TaPbEOCG4SBEHwGgglJMoQFfccMSzlKHCqMgAUug4RJ6MMAdDkWEAFQAF8+iJw8ikBJWFKnCKZGn\
    v9agh3IwQwVXgIAaAgCIUKyEC8lw7kpigJY2BOCoC8Gv/lKgQIVDPaYxrJhMACwRhk18Bi1AMHJZ\
    ofqb6ngislBeCUdR9othoCPLcQigCJoBiQCAgRu+eMFK6qnBByBiITD+klI8YYEvIFleQFjCMNpR\
    gQmELhIBsF/uOJCSsnpDCUFowB240Q5mQGIMuB5DKqiwkgWQ6m+bcFhSvhWNEbQDXCn5ACeepYgz\
    KyQ+kCIMFBZwhxwDw6bKQAALPVGBK7hZZJOuViqQII1AGEAPdQCCEyzBbksYIgiGgO1KwOsvZnCA\
    o1aukTCekApZ+AIboRCHKAzzmAwlRB8UgEG/atGDF+AOGAo3RAMVgQAg8JEspYBJKi0RgC/0YAms\
    gLIB/kagBlxwAxIc0BH0sMGKTEjj5TCPuTS4oYYUjEALFhcZBTZkkHEEYNBJ+YYnBFQOXtLGAbGw\
    BCSiAYE4QIKwaElHkVfyAWI4gAjEwAYGKhwCRRyjkWuoRY79lQ4rwiHQFZbAYX7RKF9kUx04usVB\
    +tGFCaTFuXcgiywYIY1YzFoauOhBKFLZr4zDJA7Y4AY6wpDaCkAiGaEY70qgUItvM4cRU8CAJcqB\
    jUJkgQqgDz0VrpCFK1TLX+14wQ9c/A8YQ10pbeAApKLxgQAoohxLQIovAIEBT1h+qDkYQhhsAwMY\
    tAAmE5BENHYxAgc4YCVTcIICROyvOnwhHUaogzpw/iH5ChsgBZ8CRg+CkB+yNBvNBAlaM/4mjgwk\
    QdIpQAo3GoWy96ohFZJ3wBhqkQpDMCOyX6AFK6EBuDANnlAKw6MWvkIMfxEKDviAp+Ar2PAEyDAN\
    NDB2xwAcBpEHdgc9RcIuVLAAtsAMuYcy6UAdd+BHATAG0jAdUkEFyQAFZrQSpqYOEvBpaXFZFWJG\
    Iyd55PQLCqcON1BB6gAFOzAc+hABRZQU6GAJPIUNkcBUhWUE6VQjtZBnPPBrDRYJGqAJrsAI0XAj\
    AZAFEJAIspIKqXAjFhAASxAJBuBIZHEFObBsjxEAWnAHGqAOLhAGZkZO4mAIZAAEcKgOi+BsA8EO\
    /gFgRejQJxBwDEVGBGLTL2ZmYVWjDGdhCT3SBpHQA05YC4zQP57ACjSwCcxVhc+CCwFgTBvUBpCQ\
    hzBwB5ElhaxAf2iBirw1EPGxFAhACRjwGZaAAECXFrJgRhxwMlXzDVtXHdexZW3ACi0RDVyQTOoQ\
    Cr4QCb+HKF/gBLS4QVdwBxMADCXwBVvGVNwXbWQBA3lAEH5AZtHzAhiCAKkQDZawALmAMoW4EihA\
    b2mBDjRwgwFQLa/gAkLCDL8QCdxQAUsgILXHVWRxB6pUh2jnhwEIfs/yBQ1wE/2gAEv4ImNAAwvg\
    AMMACMrlL+UwiTH2N4awBlOQirlTaNKAWkig/gkGYATqEAQBQAPXmBbiwAiL0JM+uQiM0B/Xxj8Y\
    IC5k4WU3AQ/ThR6GAAjMgA0T8jfRQAMsoYNosQtxIAgh5wtYlR258GSxoAEIAHAq8Xb2IgLpgAvi\
    cAJKAQlqwDXrdAXRQATGWA7RcJfRQG+wBQ8CgYgw9UVKkAMWoCb8xHGU+Cwa5hsOxSVcqQ62YAZL\
    4A3cEA3SgA5mEF/6MYRRhywOIAsLoBQ9MAGQEAc0cAWi8k1kwQwZlBbQYAC3CAsCsAtMeAWQQCG/\
    kAOi9DflwGvZIWVM+AUrUQGGEA09QkLfUAu+wA138AGaEAdwlSmGoAZS1g6b2AM9IFTqEJqj/kkD\
    WRAAosBlSqEIKRADp5cWFuAHAuEHy5QUx/AA7sIIecdP0TBeI+A30WAEBjAGbSAKa2ACLrAEv6AU\
    n+BQBcUIRlCNGiBnuakUw2CO2kma3fmdhjNa5VAOKqCFZMEF6PkPfiBjw3ZQSgGf/JQUjbYSqgQ/\
    NBQADmBGRmB5zPABKYBqqUQFttB9C6oOY6ABKVCe2SmaEOqd4KkOwCAk3jAF/cIFCOAPHMpgQQcB\
    HMUMNCCF6sAN9ZgUgKBEZIEOikALomAU0oBFK2EBHeQJiocWi5BoH+A8sPE2FcYB7pIOCAAHovAB\
    I/Kg3AmkhoMOjOAACmCOSmFbSroCTJoU/sogARJQBhWwZ7TRAupQB9gQBzmgTiegADR0ARUgm8Tg\
    BLWQgElhZ5qQCuiwBLugJWlVYQ8Jp3EQCSJQDaDpo3cqoUP1Dd+AYW0ZAP7gD3Z4OK/gCdFAq6/A\
    qBwQCk5HFrngCYzgBQRYDpCAAKbYL8DwBcNgAS4CCUbQEhQHZUojCxNQAQxppxEapIjipP4CW7ea\
    q5niNmGgj5bgAGSzBCMQjOrgAFDgdKUQCpBAq0ohDmrwfDdwCXHwRTfJSTAhAawWAC/wbeiADhfl\
    rXj6MFdACRIQDP1CrrjKpO8GDNwgARYwAqSQFtzwF6IACFdwcUlxHQJIPaLgm0ohDMEE/hM0SQwu\
    MAXMkArUsRJBwHg8EADuEg1/EaCtup3fajiAEAFXAKPEVDcUa67MoAYIkAIpEA2KIAFjoI9VIw2l\
    sAsrwZBKsa4VtgChMAYtAAzY8A2otRJEMAYG4AUF4C6lcAUWQARkwbCwqg6pAAGeAEuAoAVEmLSD\
    qg66YAT9QYKDyE/tIBXrqRTtgAciFwAs0A64gA0ak1phkDi8EIziwAVoIbfg2gkvoHLPknG3agCD\
    Gol/kw74ihZI6kjlcI8aBxYOlQr1ZAAmGQCXkDhE6AkqgACf8JCaS0LhYAPQ1S/fqaR+wKTcAAH8\
    hA5q8JBkZzrlUAephQBacAxiMljJ/mAL5JGMWVskRCgMrdAKYaAGP/ujcysdKCOAxGu8DsB5qDMa\
    KpspQFCMI6oO6QC9kyYEzZAOnjmTOYYNzwcTXjBN1zh2PQq0DQtVQECEZIG+HJqHU3pGk2aoN6oO\
    vKcGnNpgg7cSEvAXcSBNBtBYSmEmyAecE3xjEuCzLeOqQVsWE4AAwfssWtAFAoEIByIrGJB7tSCb\
    /RIHEEADmrgg0FOiKmoLXKLBEwxoK2EIQKABKjt8s2A6vWtBY8AJHMAMjXFdG/oOiZgUToCdKPMN\
    etAGIaABVEsW7eANQaaim8QSPdCsSlGwK7EKCCC++1gBMJXCBjy3blsBFmAB8Hg4/gjgCAKhxWEU\
    CvEpLxg6v0rxCjQADK6AATegBAGAAU7pL3B8A0DgAKqmFKGgAFI6Bj2wCZYABIygAbVgt88CDEgb\
    AOwgEPnQcf7CCCpwwX+DDUawAN8wGRDQCgqMFtqrAQagqPSrABKgw4/BDOXwDdLwDQJCDGJzDEYA\
    DeNqAPkwEGLwnFOqJ8wQL9JwAiicFsQgzGkBLt6gEi9MkqXKEon8InATB3rCDTbQAi/wAi1Qzy5A\
    zy/AQjt5c+/bBgYwF3lwuEBWIw5wHUT0uYZwA0rjL8BwV9VBus5aYVqbFsnwBSeDDpAABl7gBaL3\
    R2VgP3+oAKyBFlAgBulnAPSH/gtuyg0asAZIutA4agFxoKnQYwsNzYbW9SxIfEYETBbpsAbDKRop\
    6n3j5DYpQAXnXEkGIMgDQQ+DVRYdpwULUAJxEArgJQ3ulTs5iRZagARFZgATjRbEkAJkZY9XAAga\
    kE3oEAtYgFxXMHqklwqf4iC3N86sXBBiEITowAVLEAe50A7YcAkQrTuxEg0coAZlLC/SIE3V4ado\
    8QuQoBJSihZZwEJL0ApbGwBH0yMSoAIpAFO1sM5J8QUR0CQEER8KjA058AI6qAYc4I3i6Mb9wg2p\
    JQG9nBSDpwYqdMdpkQocoAc1YMy78AXGsAm40ETJoAeT7bEtkI4FEQ+2hxbA/gBDCQgMi2AMW+2x\
    C4DEg5sUzrMEx+AAPPos2PCUZCEMtTACBrCioSBp5WcfvhDfUhhRPFQQ/EABNnCUCAAGOdzTSZbY\
    U3qaKzEC/oINNaAIORAAJPBUdiMC4GWYUEZCdwDJOZDAShEGFGDaBeFNTNUn4yXbaXEMC/U27x11\
    bTAGgGYA36xBRcI/j/Is6UDWUCcOccAGpQd6bHYFXhAGhMkHfWFdxLAAE2UQTm2U4iAN1iADQFDe\
    tVAaSZbgSzBw2sDQ1QQTVdovzIALa7ASHrAJlhcNAVAEyDIWsWCdZn7m1hkEr9NJaXF+CbErpqMJ\
    CuAJbUCpQjDB3tACN9AG/jSZMuVABKVwAedlzP7CugGgB5bXbpYgT8SgBmjw6JCuBo2pYw8gAQaj\
    FC+QBgpRD9EtHd0VA8njDTlNogFwA0hQAWMQ1hinBCMAW2GEMrx5eKZFDPoDZWFQC2NwB8uzCzui\
    i/WNEP2QBt9lL9xQpigDCEaQ7Mle4uR9AV4gCBBA6P2yDjqlca+eDg/gHK8QDaaJAHcA5qmVA/xF\
    gySrDi3wA4ClENAtzJfQBrSoyD6dCIlQAaJgjCmzeKlVw/SLAN9wDugQWVOAAwvADBCQBMzADAtA\
    WyshA53OyTvEEME+7GhxfMwO71AlCZQGPdiXWnBgL4erBF+wCdUxDAHw/mkvQMYnQAOo+Hrm/lcN\
    QQ+ymxbD4AkAzk/SMAYjgAEjygoG0CeekAHnkQ4GcAVfIA0yGQoSMLkwwCDewAEpEAroAAwNT4iG\
    2BCOgADx8iwMeNv8BA4IwD8rnjKaYARLHAeElQt/0YJLMAbpoAcvcFHEUFmaEAQLUB/YsAAt1lsb\
    UAKmQwybQAQqMd6KfLwrIe0pQ1Xc9wca8HtjbSZMQxbRICNT78/29RCCRZiIogAq8AiyMAL8gg62\
    MOrQ4wMrgQfzOwxxAAgTUAeGLw49MgHBhRaBoaL10Qq14hGT4MJp4Q0VsDwpUAOirT3iMPzicB4u\
    YwA6nw7ELw607BQs/vACmpOxS/ksvrAAGIA7WA0C6Y5UR8ABUvoLW4UAPwI9RbwSn5CdAUAIaieT\
    MOH5KZMIdvAa1iUORPAAmM9sZKwO6OACBlD5EhEPAGEACjp1BdUBCWBgTTlxtTQBK2dQYsFyASwG\
    eIANm4MAr1zkunPRYqKJJbGFORGAlkRmpby9hBnzZUR16NAY6PZP506ePX3qvBYADcGCJybIUodt\
    xAgzL3oQK0nxogFP5bSIhCLug0hDUU0aMMDMoCaRZad6KugpwK2fbd3y8xOga0FfYtUpUrNpmLc4\
    kbymM6RmUSpiUMoiOBaHq9eSYwKwsEvWbNkl4tS9QuCHn1vOPuEi/ihV8sUvQ0BKySKijlm0dBI9\
    5ejRQ4KHAAgmVJgwIUS0SBMMWITEeCIwi0gKSj7RRvly5YAsl9KwQl9n6jz55UEgamIQpJauWFqi\
    rpZAbAaxLYozxYIGLrzatSsJLFcumsINSkgIVbKZgtyiRZNGIlEQWMGe6g7UyZ4VspOIkxhiYcaX\
    HNBSJxUXHIDKPg03JCaUOkJRRzI0CoLEognsimWCFeZBsEUFGTSoDgswoCEUdJjxJJ02ECjvDhd+\
    BDJIIYck0oU2JPrmAQFq+CZEi0ZUp0QVoilowAJbxNIeNxBQpL5v6uPmAykk8EsdwyZDM02RjDAo\
    TIsM0O/Jgiyh/qJJdaw0EEss+UEkACq88SpME8ozU01D0WSzoFIuCs5JofqjSA0EurhHT0v5USWA\
    GKg0yBchQknGAKQKOvNQUy1KVB1uDAEkgDuOk9MgZmgIAJF8LMWVn3dWkKCqgsSBJAUNnGitICpO\
    RTaJdnYpAYhLvkjhSCcneIWiUkZAoJvNcOX2niYCgMIu1doQRiJpkkE3XXXXZbfdZKhkJbAlKCwo\
    lRiqTcqQAJqgh1t/deKnFwQeMIRQr+DbMOENy+EEAgQw2fbff+n5doRUooKEAww25rhjjz8GeWMN\
    NuaAAy04LWiYFgJYIR6JXwY4ngVfaAVhg3aBRAhkkX3gCpTV32nFCQLj2Qdmo//ZpxcQEGjBkGIN\
    EkcaT0bYGU0HrijFYHVcWQIBBHop+mixkz4iAAkMqaWkcrDZxRJGgLjh0BqA+M6SXwA1iBhDZDDg\
    iFvqETvwnfrpxg2LluAkw6jS0YiZSx6H/BJLWIuKGE6W+K2JbvoRvHOe5MGkbAOUMOQVxRWWCJxX\
    DEHiNxAwkYdzz2cf3J5eDE9ogRY4YYUVvL3yphVWLldAAYvcwMSeiGln3jrQ89jgt9q8pr56r980\
    AHl5lm+++5/66ccedsa/xQ/zz79lfHbsAd9799+nPSAAOw=='

def mormor(): return b'\
    R0lGODlhgABqAOf/AB4VFRYXGxoXFhwXESEWEh4WGyQaESsZEQ8iJSkdGzIdHRoiNCoeNCUiHjcd\
    HyMjKCohKBIqIy4jGDYhGC8jIToiFD8iEB0pQ34VFR4tTBsuVDIsKTkqMz4rLEAsHkUrH4kYEzEv\
    NBk5LEUvGjsxJiY0TkwuHFUsGjoyLxs9KkkvP04vMyw3SjA5M1gvKlQyGl0yFzU9K004LU85I0I7\
    Nz87QUw4OVQ3LUU8MVM7IIcvFG0/ImRAQF1FNFpFPmZEJ2NBTmhCN1dGR05JRVNJOVFKP4I9PzpT\
    QjhPcj5PZ3xFPUxRXYVCTIRHJ4BLIH5MJ0laQHdSHXZPQJlKDH5NQWhWMn5POHRPVnJTNXlRNmxU\
    QWBXTFteGGZVU15YU2NYR3FhIpBTUo1VSnNkEoRbQX5eQIxZS49aQ4hdOo5cNYxdRYtfNoleTmtl\
    YYBhUH5hWXFlWIdjN31kTIpeZWZob3tmRWxpVnVnUpBdaYVhZJ1gM4xjSHNqTZ9jFIhlR5FpFH5o\
    Z5NoNKZdbJ9rA5ZuAIxyAJ5mSqpqCJxpSJtqUn5yXIdxT5JuTZhrWnZzb5htUqBsRZJvVJpuSoxx\
    WYdyZ3N2fXJ5ZoB2ZoV2W4t1YYd5Y6x1IrBzQrB0O4x9Z6R4WqB6W6l5U4eBbJx7ao1/b5h9apCA\
    ZKd7a5GCbJqBX52CUpqBZ46GX4+EeYqFf4OGjKx/YoqHebZ6gKmCYqSCcp+EcpaHcJiIbJWId6CF\
    gZCLd7KFZ5WQfLiJYZ2PeJuPfrKLaqqMeaOOe6ORdZ2ShrCRYayRbp+VbpmVkZeVmqmVgqWXgKKY\
    hbKdh6qfjq6giKKhpbSej6ehnbuhfb6fjLajh8aic7GomLeokKqprc+oYLuwnsGwksOuoMGwmbKz\
    tLuzmrC0vsmzjsi3mdO+rN3AhdDBotjDnNDFrszFw8fP5M/P2eDTs9nU0ebUq97Vu93Ww+zlyfLl\
    u+Lm7fDmxOzm1Onp4fjxx/n00fr32/r45fv68fb7/vv9+f/8/////yH+EUNyZWF0ZWQgd2l0aCBH\
    SU1QACH5BAEKAP8ALAAAAACAAGoAAAj+ANkJHMjuHTqB1hb10JRJk0OGDyN6mkjRFCpUmWxp3Gjr\
    IiZTq26JfPYuXz58KFPiM8lyZT59MGHicxevn7+b/fbpq0euGjqY7/b1Gzp03zZnSMHFi0euHlGb\
    N6PaHHqTXz+CAt8ZZHeu2KQeiiA2hBhRE8WJFy9murURVceLmkyJZEvS5L27ePPelYeX7z15587V\
    hOpPJ89q5vLFC/pU57ZoSesxrRe1Mk7LUc1h1YoOXddJWu44zDS2rNmJpSimLcXWVuuLpTKBXEW7\
    7kx3uOXp3i2Pnu+l8WLqozcYp+GeiesxJuoYqTOlk6Hy8zedqr+p1jW/G8jZs7FMoUn+O8SEafQk\
    s6fPwvYk0jXbtJjYzrVNTx6+eylZ6hcOMx/Np4Xt1NNP+gR1XVH6XOMMM88t1ZR1hElFmE2aFaRV\
    QeiYc44xmMgh2kPlPSTeWRNZBNtGr8EVkka32KYXXinBeNd9gAk24T6KDQiUUMwlqAyD0P3UT3XX\
    WQbhdRVyZ9A756QyiRxwmFYWiaWUkhYqnqB4y0UWabKKax3Zlhtvfv3Vm2+KwaScU5XpFA861byz\
    44E56bPNNXgGqQ+ERGFWWZIWasVkKp5AmQl5IEpE4pUXuSefKaZ4stYtKz4Tz0m99aaSfizx519N\
    VQX4Jjfs7NiYnXheg847b+pz2VP+fGbH3aoCuVOOkx6OF+KUi6Zl0VyuoQIpJnzI5ZYty5R0n17L\
    vojfs+7YSFVOkplD6pw93oknOkuhI5SfOMF6E1bsRFuONtqsAhocnmiyK4iZkOgJo6i0FqwpmNSh\
    hbGuLcMOpmPyFrCm+ADHjlPY7SMZOdwQyBiP/aC6LavevgprdQDWes656FpjjTEgaxHvRJhMRFZ6\
    6l1p75aoYIJFDnLJhey/t+EmjjjTnDONMYGd4849JsU0U3HXKbzYqqZCLLGqrILzLbhFWlYOx9pY\
    M83NOKeSykLtthvRWCOnnNbKF02CRRUgyXXLMOzcd84xddTRwwwz1FHFD1XkXYb+Me6UGS2oxkm2\
    lJwF7lMYgtoyHc84+0x32YF0Qu5P1dZgPc454hijtUKytYvvlJH2mhZHb5mCxQ9qi8S2OanM4MEE\
    EsTuwewffGBCDj/8UAYjoBTjMztE5xQPPRbqsxjE1Ca+qkFPQz7htDddjfXN1qSySMlfmezuyQ/J\
    y2hrIl20ChZYpH2LKXxoQYIHsbcf+wQe1P7B7LOPYMILP6QiDj03vmMOOuP4V0GQpzDlCQp5NrGK\
    hF41jOlNQ2upWMUwPMGHL5isNKbxHpfqJR+Wma58kPpKBSRggBK6L3YVqMAEJiA/E5igfvd7wizi\
    Ybib7OMd7mCHZhTjrcbUI3H+glrOq6SCmX4sghHGWIQfgDGNJopjHKi4gxY8YQruZVBsF+mgfMaH\
    hVSYQg4zmEAJx9i+FKawdi5E4wtekMYPvGAHkjhHDffBlcC4g4c8KtoPUxXEPFqHiBizSRmwoAVb\
    NFF65hjHLbTALhAh6opo+R74OuKJ05liEVgYwQHGyElOSmACB1hhBehnOza68I2QOMee9kEP3ORw\
    J/DwYwH5qBV4SGcq4YocVLZAiV/4whfLeMY4hjmOVFShDnGIAxoCEYg0PCEQi1CUakbnqLlAinyL\
    WEQONtlJAxBgAAPw5hgP8D74za4CFrifC3cACXrsg5W6cQc99JGPehBwj3f+EpQtw+W4Pz7FKslI\
    xjcG+o1rgGOY4ugEDP7wBx2AAAQOhSgjpDnNY9nCF3PZ0gcXUYYPHOAACegmOMHZSfeZU4UVMEHt\
    flAMfcBTHvJUE6xmmU94vGOfEaqMAi3jCoGGg6DbQGggdlCIPmDgqBh4KAjYQFFGsWgYGQUJ3gYp\
    RgIQwADhHOM3R3pVAyQgpN8kQALeJ4EKfAB+PzDHcOI5z3y4c1oF3EZNbwqVP9IJO1AJaDj2OlBs\
    iANzaYhCIaaA1KOCAANM7R4WG5XR85nuBy87gFVDWsKsdnIAXTWABL5K2fbBb4UeWARK2Go8dhiO\
    OT+U6zX0ORTHETGXUoH+BjSysddwdIMbiRQHFsZAiD4ctrA68ENYHCI6lUXVFFrIARY+4E3MjnGk\
    mM3sN8kYOxNSgAJjPesEcmAN3sxzeLJMbT5rSZh+hqpPRZJtbX9qDnM88Qd/KEQhdFBYDEwhDsNF\
    2bwYlTqNoGIVc8NCVa3qzbBCl4xYxawEUEDC2F33qytkISTK0bfeGM+dh0ueamvpFNdK7nGxhcZP\
    +TrMRFaBoVGIQhMMO4U+LCK/FZUksM43N00WmJOYPTCCsWoACpCAhF7d7AAaANod9OIcZ7owAeEh\
    1/HCw5Z4pU4u+2kTaCQjG9/46Te8oaFxLGIMYADDGMbQhylM4RCDeDH+cSPpVFuYoppulkMPKmDV\
    ASggwh8lsFWnq1kglzABDaCsV4dc1gq8IA3dXQpMQMUcJm/4yTh9bbgA5A8rY5mgXMbcMcDMhTEf\
    4tOfxu+a9+tUYTVWWHXY5lUlMIMgvOAGFfhogfdswupaNwHYFetXP8nCHaRhGvWwh7CHTewmy7Ue\
    T+5w1Iw0FQX2w9ID/ak3MDeOaYSZC50eBKgPIeo10+tYHAyfLVZRBhNIlgAfCMIOrCAFFziAm10F\
    dK2BLIEHU0CsQx5r7EzwAz1Y4x31CDikIW3sayAbHvZArz/Rm94rR3vLxJxGHKqA7TFoexDa7nYk\
    SW3R1K0CUpicgFX+D2ACK1hBDWxgQxAcUEJuSiDQnFXArjfQgFwnYLLv88AbOWENbxhbtT/fxsET\
    ntNJ4zIq0M5yQb0xzGlEgeKdRjMhCjEIVcCY4xZ1c0ZR/QORA0ACPzi5GvaQcimw/KNfxS5nx5oA\
    BWxA7ZMFAK5jd4AXwCANvahG0K8R9IPvqTJ1lVDgrQyNLP/0GkwfhzgCUQUwRH0QhIi81S/h7Stx\
    JHUaTbVkB+CBLFiBDHtQw9jZYHYFkPPBBACA3Md6XbjvueYK2PcTnNCLaey970+G2KtcC6AqI0PE\
    fJXGQRWftzFkG+ORxy/lT9Nm/4okJPgqwwvOPYMskAH0ZE+5yjv+oIDW31z1Vm09BMC5Z3BugIQH\
    8MAO9MAJYGAj6EGPR+5hdXTYHggZyQD+T4U/TG403vi8BXnJd3XN1xFRxVHmZlXVRwaiJ3rZxwY8\
    IHNj1QDfBH4DwFngd1XflAATMFYVAAN6oAd553Pw12SQpnvYETmT5g/OkH+G9w3SEFTD1GkAiHyS\
    t3zMR01tMRcfhwnSJ1kS0APW54APyAZmEIEJAABWZYHQBV0JAE4JQE6adXfsNw3eQIIlCGkBt4Vc\
    2IVcKBTXEFAEBYPbwA0zyGljcAhTRwiDEAeUdwmXQApYxxH1AlVbsghx8AOSZQBZ0IdssAd78AhF\
    +AZAQAEZuFX+TQgAAjAAFACFK0ROL+AE7NcL74eFQdcZAGcP+0Bsw8Yj7/SJYIh/IwaD2EBMYuZ4\
    fyCAbOiGilWAdYhRl1QGP2ABoXQD8zMDWEAGbNAI2scGbyAFNpCEqad6SjgAAiAAwyh3Q0YAoTQB\
    KfUEIcgJzfAM2IANfBd03aAg25AO3NiN3tgO7eCN6QCO14B/0RYOMUhMnYaK28ZtDgGHFUU6r7gl\
    PvgEMOACEyADMvABHZBuDJhyQcADN9ABHYBdSriETZh6AnBzCbCQEhA/FgADTcB+s/ALxEAMzHCR\
    xIAUF5kLrdAK0tAN4jiS3QiO5CiGtZWOitcJasiG7eiGcEj+eWwmj8NQk8PQMn6ABUHQAzcwNz4g\
    AyrQAVKwi78YBD4gBEIgAzYgBB2QjKoXXQBwgQSgAHJHAM5oAjDgBBPJCcJgkV6pkRfZlenQDSEp\
    juFokmhpkuUoUAQlDYineJuAZoXAhpAXanDYio3CEZ5Qk78kLIsgB1ogBUEwmDdwA0cZBL74BoPJ\
    Az7QBR2AAjQgBF0QjEoYld90jDfnVQzpjG/kBGnACRVJDLhwkaNJDL/wCx8pDdJAW+vQmq05D7AJ\
    m2nZDvawlueokuPwB58WeXNJCJ/GCHBICaOWFqRwLJ7wS8PgC37JCGUwCVLwnM9plFJABVfwBj0Q\
    BC5wAzz+wANAYAM+4AM8yQNBMJCVeZDwdlUp9EZpAAmhIAyl+QsMcg3dsA3k0A7zIGXTwQ9WUVf8\
    MA9pCQ9rSVv7dw3ExJJqKF+FAGowqQnwyGYWdZy/ZAtxkU1YMAlsoAZUkKHPKXpUEJ2DGQTQ+Zwd\
    +qERSIxVWUIHOQHpBANPAAmQsAq/0GTkQA7oAA/BRnTiclf6KZvhCKD4J6DoeA1mOA4sOXXy5Zu/\
    eZcyiQrFOTq4YAsQ6gtQ6gkU+gMMqAZmYHJZkAiJUHYhanIN6KWCKQMKIFbM+FWzdgARCQO+hgal\
    oAszOnA3SnRURmn6OST+MA/r0A4BSlsw6AxDWgyd8Af+YwZmYMBMk3CXDBpjxvlLv+RLpSCLO3Cl\
    ZwCmXPoIj6B9ZnAGZ8AGifAIjSB6pCeYtigDHRCFCiBzBGZoMNCqT2AFmXAJ6ECbtDlsd1UkUXZX\
    QwKbziANVzZibjmkw/AFbdAGd3AHcAAHioAJikB5VXQJVBQ6/IILpOCojloKWNCHanAGYiAGVnAG\
    XJoIomcGVHAGZnCujZCujfAIohedNyADPrACpvdVe2gAhrYDJ3ACO8AGkfAG18CJuEp/ksNwGHMN\
    vjpb2ZCwBjVM1bAKxxpBmnAHi1CTmCBBUCUX1WCH1VANvoALl/CojhoJT5Ct23oGVHByiZCuXHoG\
    SrD+qel6CqfQCFyqBmSQBaQqA9v5bsx4bgfwgfhqAkFADafwBqSAo73HJx7WWsvWD72af1iWsM6Q\
    eBl7C6lgk6ZQtdWwNsOQsTW5sVC1sR17CbZwmr+0ClmwA2hbsidrBWQnBkqgBFSQcugaszIrrjVL\
    qj7AAyvgAPTKTSqqryfwAW7QDbmQC4DwDfSXo733OIFnsE6bsNkQtYrHtVprhzZZuTY5tRsLn6RA\
    CqLQuZcgB324AzBgchlqcmRABW9rBrvIi2agro1gBqJ3twH5nDzgADJ3bhxYAfl6Aj1ACyK5DsmA\
    DO1AFHdKaVFRHVS2bHjitN8Atd5ghhwLVVAlpab+wJdrc1GqswzLgAm+8AykAAeX8JEfGbrkswP4\
    YwVKIAVKYLotq65yKwas2wiAuAdkoJPj+Zw9sEKmN3KhZAEA/APBwI32ILzfMA+tlbj7KXj/FJuO\
    e2WQywzgIA7egA2/lCWooJzsccEaoZwd7AuaAEyogAskjAu6oAue4IM/sEYvwIBU4AJGEMNGwARM\
    EMNwO51jB4h+4Ac1O57wEwRndQAUcGMfhU438AinUJ82sQ65kA6wqZ/7mbitBcWwqQ7qsFfz0LwQ\
    nLDIEL3YwA2ooAtx4Qm6IAof4RaagAqigMKRYguiEMK+4AkkrAu8wAu6gApmQ7onYAFZsAdWcAL+\
    LhAEGZqhpHcF4kkFNOsHOjxIPbACUdlyj0hgRWwBpfAIsEALCDMP6Khe6uCardkOrxmbVWzFpGzF\
    64AnPwq5yAAOV1gNmiAKYVEey8qgl6AIsFzLzKoIisAHt/DGJ8wLp3nHi4AGWZA7+FOzL/ycbuAG\
    7KsERhC3DEgGO7zDNTuQx4iMHyVZYFXELYwIoRAK9WkP4ZgLybAOVxwO+rdX5uzJrVnKpYzKW5wN\
    yFCG0asIX/AFu3zPd4AJd3DP/OzPfNDPdyChl2DCdfwLvJDCfrAGaPADKpSt6ivDNBwGsqt99QuI\
    NcuTHXDNzGgAaLeqFrADTeAE7BkK4dsFbRD+Dd1gaVhGkrMJjrDpyaiMDJArz9sAQONwB16wBbtc\
    BF6Az1+wBV/wz1twrF8ABwP9yrqAC6dZx+2CCX6AvpJlAp5nBaobBmKQroJIv/WryNeHBe9apgKg\
    hC0nc0rYsyfgBFqZBp8QCmwgBDRACeSQbFy4FMqhT1s4cPAQjtx4J6nMxWVohnfQBV6gCHdQBG0w\
    1MSq2FtQ1P0MB1/gxmtcx5SNC+NRBhYwcj1gct/aqemqBpg6zZHAwz1cmJIFfiZ0blZpAfo6e2iw\
    CrVQC8TgkdFguIBw25RACbcNCG3QBb79276NlMIt3HKFDL+nyoE9DnDgBV6ArEOQ2JjwBTv+bc9b\
    gNT9nNhYMtnAXMe40DIIOHIV4HnmyqWfnQijXb/X14fa6QBLqHoerUIEpqI/wKZoUAbDsAxIwQy4\
    kNuXkNuUEJwxGeBx2LlyKAqe0LmeIArwjLA2Hb3csNxdgNSIzdPSTeFe0AZIfdRfkN2/XNndnS9Y\
    0LPohAXjCrvpqsheXbNWQJiqSowebQCP6IwW4AeMwJx+8GYb8bkEruMJbuAUIQoGLgpq7OPS6gnO\
    UI7HDdjRWw06jeGH3QYW3tzSndjX/QVALgq4QNkI/QtPmi91YHcwcMytq66CeH3XZwV96K4TYNbg\
    l80p5AEptTugEAmZcKwB3c/3nOd5TgT+fN7nOPDnf04ERVAEQwDoNEADM83gyIB43PAMTf4FT07h\
    vd3PW0DllW7lB07HlF3ZLRM3T9AEO/ADWZBy6gqIasDZWioFuoidZbpZZeq/6LRGor4DftAM3pAL\
    NEACKLDrh37ou/7ru/52EAABBQABDdAAKDAEXlADzF4DQhACC67KjO4Ly03lE34HW3DhlA7ZVX7l\
    mq7lCA2l2YSHcTBIZaB9p96H6k4GYHqhQRBrCtABvp2ZoeQBJpCv+DMJ1WCG5uANQgDsNACZwB7s\
    xF7sxt4AIRACG7ABKBACuw4BD7DgCLvo4MANvwAHiA3p1z7lx1rpRb3YTKrd4P4LS53+wtkUNyhf\
    BoOk7lkwuzRbv+8+AXBACaRACV3wnVpACaSRCaWwtdzw8+1lDl0AmQHv67++8A+A8MNOAQ3wAAn/\
    AMY+7BD/ABG/lggLDW7ZDByL8YnNB4gt5dqO7VSu4ROxxpp+mghdx0udFlSK8nFTBmQA92Z+fSgH\
    iDtJCiRMCu5J4DxfChK07w4+DubQDEVf+LuOXQEgACFQAyEAAde1AQkfAky/AcPu9FSPJ9KAf7OF\
    9c7gC9WwDE+u8W0A9sYa6fYM2QcuCq3w7dvt4Uz94V5eB1gg91fagGPXCJRQC8qgDMKw+8oQTNWo\
    9Ru7sUM6TJTQ60aPAg0gAAXQABv+wOwc4PgM7/CS7/jXBfHOj/kBJVuc7/mg/9xF/fX9POii//EY\
    7u3fnvabTsJoL6W2kAlyQD5zX/t7sArB0AzY8AzNMAzKgA37/vMAwU3gQIHjDI6DQwMHDYYoUDQQ\
    ECJEgxA1QnDAWEOjRQ4QGjgM8YDitWvSkCWDlhKaM2bPcNkZ0mbLnSJeutz5QmPIF5petij6IlPU\
    UF28jPL6dfQoLqW/fuHCxQcLljJkyKjBasVNMGHPsD1r1qwat2pjuR0kWPBgK4YNH1bU2GADBAFX\
    5ty9kjcvgwUlSixA0KIFSWnJkKmERsybN2Z3Yv7c4sXLHcdeeNb8+QUOnEtEiyr+NQqVFy5fTJ1C\
    1aWoShUsVshYgR0pWDNlX8OWrYYtbDNs3g6OI2jQWzSGOBxuELDhuADmdefguQv9LoQLGTRcQCBC\
    BElnJxG36t2KZpeZW7pMhmm5Z+bNmkiJKpoU9GilTHnp0oWLlBYtWLL8J2MVYZSJxhmxbmvGm1Ea\
    aeSRSFZphhvf0hJOCIcuBKA5AQbgsC48pJPuCupKyAA77bhLBiWVWhkHG/GKaOMmX565RJHKLvMJ\
    qM0U8Ww+H5nCTz9S7ujPCjQCHFAZZQwMCyxvqHnkE1h26WUXWEBZZRgJvRnInHEooYGECwsoIIAC\
    mBtAgATsuiuPu+a4goELWCj+wcTtSErmle8MesaOmh4iwpNnlrlkCBqIoKmNyYLirEcf78MlyEih\
    IoUUSorMQkAll4xmN96aiRKWXkbdBRhgZnlklGq8wUYgL72xcDkBAAgggA3VvAKQLTaDg5I84rwg\
    2AUiOBFPPVc8S7zIGhiABCK+EOUZYWS6hRtztrlEMzgUsRG/H0dDLT9KK71Ei0nI8IMrJYUpkDav\
    oJRy1F5MpXcWUCKRsNWDcrlwg48keqC5NdsYwouCvfhVzuouiAAKS0i6BpljU2LRxTuI8IKCATYg\
    4lmefFnmlmHYoQedL4rouONLPpsPqnDHJTeTVdyoRRibhWEmGiXDwiaST6T+pJJKeke1N5JV9R3H\
    my5Q2ICCBhS55BI4EmCOgjy6GCLrIbZI2K8Lhm0hBojzRMwVLq+BwzhmB8AhZSLsIAUHCUSp5pIN\
    7sahbThYNsrbl/NrpRVSBKeklFJWqdlmZZhRZsCwgmEElE9CmbdUek+1l5FIeHvmrHGiYZqCBGIg\
    PQbmALD61yuUuOKNPICQs06wxb7GmVcmhgY8b8Qjgoa1myUBh+BxaKB4iDbeYHgi4CuqefyCfD6/\
    wQUvpZbqbRHGlwGXaXyZsCKJ/JNZZtnF8npnCQUURibhjctxyFna39JRYC4ACPJoxZVY8nfldQYy\
    kF3DHMGd26kIGmbDhjD+4JATCZDAacYznoY45K/h+WBln4leBkUhOMGRwharGEUpsKc4xjmuGaPw\
    Q+RAAYtZXO5y4wuFJPywCmxgAxxn6YYN7nYJV7iiDQUAQAEoAIgeFrEVc4AdAL8WAUvEgiTMcMUr\
    UpQiV3xlGTgZAgVSZhx/FU9DGype8L4ANW9lMIO4EEWlSCEMEK5CQIrbFPfCwoYUfgIU43Ph+dTH\
    iDIIo4bgeF8XNtACXcQiFo6YFQA6QMQiuuKISSzRAkTQRJJIzBVTTIYrnuENXGzBX8m7GwmGVwTh\
    dbF4D+AYZRRhC/vwghnMYMkyluELcVWqFZeYhBtHOMLtCSMsoyADIxj+8TPyme+FmWMEGSJRQxuO\
    IxccaIEoDAmIMykyD410JBIXEKyvTdKJESvgFF3hDGzY6AtC8ALxmAXBBuYtbw7ZiSeGgQlU2NA3\
    5jAHOvCJT688Y5OLqYbNuCKMEfqiccoIixuCOcw75lGP6vODG7xSQ250A5qGjMUPg7hIbD5SYd2k\
    5DWYcTspUjEatriDJ3zhC1towgs0MCWHiieBBooSB1/AxB00kU99LkZCN1QLWZ7BDnaYg6A24+Uy\
    mPEL7gWDCnsQJiga6lDMSZURfijDMJjZmy7QAKMaBYANABGLRuZiDiroi7C86YxrEIOkb22FIjQx\
    jGUY446zWIUm4LD+hSEwrXgyZVbynLUMdpDjj+TgqT7NAdDOEdUctihFpbCnvZv90gpQVSELqTo+\
    q17Vj8zkBiC8mr82CKABFBCrIfXnCrOiNQMlQkAKmgjLKL71dlHTxTJAIQlEICIUv/0tXkVxCYM9\
    5AHHRcEQ7ICNFo0DHc99x3PN8QzFmqMa0xDHNIBRCiEl9Re+bAYb0BXVFbZws52dITO9IowhYLQL\
    AWhAWBlZREqcdQEauE5sm2jbSrzVh46IhBp6awhIFBgSvx3VG5awhCSUAAkPpsM1wLGMtHBDHNed\
    hjGMIS/gFngSmZAsZbPHvVpcNoWRkCoeHTo+ZKYXG7UDixcM2Qr+LzCnAGLFpq9UUB3YyjYW/CVp\
    JbywBCmcwchnSESSH9FbBM8LEEl48IMrAQ5W+eK6puoFcEPBiVAY2MuQiESlRKg4OAJzDyeWnIrz\
    yNk9unhQXnHGIWPx3iCK1RGNBMRZeWwiS/TwdpUAdJC7UOQzKMHQhqYCG7DS2wPLixaAoAMdSGGq\
    Dn/Z0l+WxCRIYbgRNs6XwaCjH1KoQjWvGb00xEYsnzEOYhhSCBsKax5k/QZKUCLPaF2Yfg9Z20C/\
    ohJ08IESxKAEHhTbB8UOAhXOIGDeIljLXkYEJKLdW2pDQhIFRoQktK1tRhhOhLZYqTK+e8JIRELU\
    4EsxLKh6Kqn+QpSGIn1l55jRilgIIQAZEkIe3rDvfdcX1yWKgI/b4Ag6LKHgS7BICIRg6C403NaA\
    AEQXhBCERVO7y4zGNrUTkW3eIiLJktj4IyTxCJI7qBSZGLMwljGgX0Sj3Ff1Q7nT3cLyAcNyLLZq\
    euH9yhfT+9Vn8gEgHNGGNlwiFrfm5rBkewkWhKANLJgTnfxCBx4IgTyxIAYziEEMV0ScCmpIgyGo\
    PfYkK7nsZ09EydVe8g9z+mbcY9zLz43iuxrzfPaCqFZZ8sqWYCNqNQBAEIVAiaEPvOt6FlbALWEJ\
    vxg8CY9/PB1ksqtLOMPylr9G162QhrD3Nsm9HTnJ0Z4IBpX+vkGnaFAjIkHyVXgb3CBTajNKUW5z\
    C5PueLQ75vB+1WE8Y+/xHgczLkG/wAsBELW+RODyzIFgAVwEUIBClJfw6wUvYTN2wD4cGkmKTEwC\
    7IY4gyEMgZU9KFn0pU87yRmU9gZ9ohGfKHkkvL1GlS/DGQgdBe1HfXvzrpmzwvQD++O7eJOQIoiv\
    BKAAHpCOOZC1X6GO6lA6KLADJHi8BaMDRxg6yTAUf2mOGUCDRAC/I8MKrJACKrisPVi7tUu/kmuQ\
    klsFyIIs2LM8hFqFcvMDqJK5u9qsK2kzARzAZcAGc4ADChAACiAAHniT6IAT6ngthhGBFBCBB0uC\
    6kO4kGj+gFqxFQGwlRuwAjNQAzYwAy9UAyuQgiC4gQ7oAB+QAn5jQylggzd0gziMuTncAzd4QcjK\
    Hr67v2YIBhucu/Lqv2PavavyhQF8JSAkBxu4tyBik+iAjjixDg0YFu1IgSirQBbAxAU4rgXAwlrp\
    ABcIglAMRRe4ARvAiAVAxSHoAohjxVpzxVo7vld0xW9DBZB5JWH4hVfqQ3M7M81JN3W7nF1gs3sx\
    t0I0xJYwByGopgKwiw9RQkjEr0lMgUq0xAqsPq0xFBrYgi0QAgiAgE3UxON6AIlAgUvAhZu5mXDj\
    HiWRpU1pHFvIhMnCGct7pVx0uXLrRf7rv1IRRliwIz/+zMVjfAZzoKbAc44kxIv/iUZigcKBUxQv\
    cATJMBidYBqmSZ4vKAU4sIEecAMp8AEhyBrJaANckKVl8KcmOclmAItnqAaV3A1lgMfXg6XLu7+c\
    qYVJiAR0ycHxmRJ66cefkTs/OEZm4IWBLMjAYxNZexPYwS9J1I4jOAJSwIWXaous0QmYQgExUQ4c\
    yARh8Jmf+S1g6D1/mihmWgxWOcu0XAxmkr14nEdn8CeaVJJSkIMyQMHbg4WetDlhtBf4A0ChNESk\
    MEogQko4EYIlEIK7YMpoFIEjGIIauAReYIuGKJi2oIGsFJ4OmAAtAIUk+5lP0LZGm5dVUcvSNE1v\
    aIb+eMQe++sn37M8nVGGWnCDPUDBXzSmvJQqkruqSdC6V1KKVcsFwgSAK8ADIFgwG3CTxZTECGgB\
    i4APXnipImCIrEGBhmAI6SQBNmiEEfy4bUMwYNiS0xTPZrCF8nxLxnmlxVkXrzyzKLGjvKw5zPmZ\
    khM13nQKokQKXugNb+CAwBtOOJE4NlHOScyaSWkFrfECkPSCS5BKXEAFUlDDMxg2MzgDjvst7wwF\
    0hTP06yG8rSFV6LJ14yGrSMGYZgEUXPPuzKv8vHH+WSEPSiDTHCK/OQFYuAFbuCqaiJOhNSmpgyA\
    J5zGLSiCIthGneirrPkCX/iFuCGBG2ADE0yEzxT+uVCYHC0Dhg0tTYHwhmqwnrcM0Wjgu62jBDLA\
    LGKCz368Ejt6hBctg1L4BRI1ilZ4BnDYpOAEgAHY0TeBjh3zUe14wi4Y0iKAg+S6TJ0oAlJgqahh\
    AyUwAjVohFM4hUTYA+CqUkn4LWrAUrWUEG44qhB1zd/bulIgU5KzIymZEhZtUfi7wTLABRJtNV1g\
    BjptlWhQAABYk+f4kFxFK/y6gB/1U1LQRiLdAssc0ju4hDtQBDi4ARdwAe0MQzV4hLyUhErVtlkI\
    z8WgBlk4hbS8Vm4Yhg8NUblMT2IQVdp0TxY61bxM0zUVNVYlBlwIHFi1olbhzwK4VSW8Cz7NLyj+\
    fEJdgIMhINJWwBqDyRofaBsiCB4ZkAEwtAI1+JlTSFUtCwVMTctsxYMNJSgQfc3LM0RiIAUy3YNp\
    NdXyQdXO2gMykAN4DZysw4Z46xxyWAHUwVVHxAMhuABezQ4g1YXhY4jIKJi+Ugh3Eh4iWFisKDtI\
    jdgYkgRQUEuLjYbSzA3UtJmZDNEBbJxyRcGfUVd+nAV/bDOUDZxWyDpnKMqv8IpE3IB849E5iAwN\
    pAE/FQH4kE4aKILhy5qFeCehxYEiU4MzsIJEgNRgSNVKnYaz7AZBEAQ82Fa1ZEuVo1qOXSphcJkx\
    NVetPVUrycufYYRHwKpMCBxXWqrWBMJxeAP+OLiDWmPDfaMM7LODLWgBSoQPnt2aYaVOd7KprKS4\
    YbsBKWiEUaAFwf1MS/2t8ERcWZAFil1Ls20GnNHYvbMZpyDRciXVkZ2Srv2ZPYJRTci63qwh33sz\
    bmiGqFGj8SWFqIkaqKkRbjFHXNCaL7gEErjKoBWT4CEBGbACMQgCHOgBNjiF36WFFrVSCWkGQTBe\
    PJCFtDRbfxoxq1USp4BeYqBc9zRVdc1cOwLAMvjQNyWnr4BLZjDJs0CjoRDhER4KTdAEET5hBs0P\
    qbkDUhhWirRdUcJdKlCCG5AB3h2FYAgG663S4DKGbBUEasgFWeiGszRb7wE3WULP9ITe7yL+hkwg\
    AzSQ4K1FV6kCn0iAUahght5INcj1p3HwBTjIPtZlXTHmFTHGPkUghfwQguukhOrEgTZum+AhgiIg\
    gRmgAiPggSbVTt/938yVWCo1hFMIhlx42rV8Bg9eBlxQKQ8eQFwUhncNHIXKWsuFz/H5R3MrA1bd\
    4ASmx1eqhnHoBgwk5VI2ZVPmDKlMCCTdgoUoAhRoG+ExDtwNAyPwAA8IAu2EVIjNy0DWsk9QFW8A\
    Byt6Jf0oBSXlOwd+VxKVg1H9zJHlS8nRHD9AWbIkS8gdjVUjB8I7ZQy8QFMGNNMVBaiYzrql2yEN\
    WuMIng3AgRs4w/p1Qwbh5WJiUV8OhVkyMIZqSOSlgldSqEUHBugHdgM0QAORtVwW89ppLoNJsOZP\
    5TtemBGDaIVSroRuruhSDggAOw=='


def than(): return b'\
    R0lGODlhTgBkAOf9ABQODQwRFBgPBxIQFBASDgsUDyURECYSChoVFCITEhcWGRoXCRYXFRIYGRwW\
    EBEZEyAWCxkYETEYDjgWDycbEiYbGDUXFhofHCQdEy0bDhUhGywbFh4fGDAaFkcUEiYcJg8kHCQe\
    GisdECYfEEEYDxYjJCIhFh8hJBwiLSkhGCAhMzceEhgkND8cFDseE0EdDjUhEkUeCjEjFjUiFz8g\
    DzMkEz0iEDQjISMmOjAmFzklEEAkDDclHhwqPCwpFz0kFzomFi4pHjwnDSsqKykqNDYpISIuLFYh\
    FhYyKyQtNUQnFUYnEFAkFCouITIsJkQoG0wmGTcrKE4nDRwyOU4nE0ArFiswKC8vKEMsEjMvJB81\
    JUEsHFkmETQwHUwrD1YoET0vH0wtFkouGzI1KEYxGxs+NlsuHUYzLGMtFVcwIWAwFFwyDVoxHVYz\
    F2cvEFwyE1YzHFsyGFI0ITM9J2AxGlI1HE02IS07UmMyEE83HFI1KE03J0k5IUc5KEE6MCBFMj89\
    KG8yFXAzG201FWk3FGE6IGQ6Gms4HHQ2GVQ/KElBRls+LzxFSF0/KkhFMHI8FFFCO1FEKyhNSz1F\
    YlVDMnI9G01HLEpHO25AG0lHQ1JGM2xBIWpCKkBLWmBHJlxIMTRTQF9JLHpDG1pLLVBNN3lEI1pM\
    MnZHJGpKMGJNMGZMMGJNNWtLN2dPLV9RN2FSMjNcV2JQRHFPMGZTP21SNmhTO2lUNlpXT3NSOGJY\
    RGhYOHZUOmdZPlZbXnhVNnRZPXNaN3BbPXRbM3BbQ29cSm9fP3NhO2djT3ZgQWRjWnhgPXBiR29i\
    TUxsWUZsa39pUGx4W1F9e39zWomAY45/Z4uEYIyEbYiJb2qSc5CIan2Oc2GUj46MhXSag5WSc52R\
    bZ2TdqSUfJuYeJigmoirjHquqo6qqZW4pam4tJe/uqC+vK7GxqTMrrrKt6vQvKfSzLPdu7/txcjs\
    yNHt58jx7Mv5zNX61dv55NT799n78eb46t/9+en+/P/7/fL//fv9+iH+EUNyZWF0ZWQgd2l0aCBH\
    SU1QACwAAAAATgBkAAAI/gBTBUOmTBnBggeB/UKG7Ncvg8iWMbuliAiLiyySoNh4EYdHHD1Cigw5\
    ZUq0d/T2qVzJsuU+fPPo0Zs3T9+9e6psDWTIUxkwZcF2MoQ4bGKmJD0uJllKREVHHCqIEOmBdGTJ\
    k/j28eP3El9Wly3n5btn814qWrQc9iwIDJhQnsOK3jqalAUKplFVqPhAZAiRpUkw9pjCyJm6ryq9\
    en2pcuvKfPjy0bx5r1UrYDwPMvy10+FChnIzGcGIQqppFSeGqFad5O+JElaMFN72TqtjxYxts8Qn\
    k16+35aDuS2I0GFQZDsRDiOWTHRgu6b7njhxofoQI9ONXNCgwQiS2eVq/iv2+jsfy99g9+W01bag\
    MYhB4xfLHBr7xunTh4SgXr1/de4AlmBEGZLAEs026aBEHnpaqVQeg1ulYotODxGXGUQWFsOLUbHh\
    5x8DIDIwnQIKXPDAAxqAAOAF3iEBizMHKojYVlwxhphWqkgYzC8/PcRQfJkhU4yGueRyyRD+9Rdi\
    AQw00IACAyjQAAMnPqCiBtshgQSBziBID3ktjbfYVp5M2BlPxhFkzHtBDVNLLrH44cQQHNQZIgMI\
    EFDAnk42MMCfDex5InfbdaelJNGkI9NiXYmplT/+5DihWmohF4wya0L0i5uayBnCBSBGwAABAAxQ\
    agAB7FkAAQFE6eSJ/kw2UGgJAk4hiTPlLArWVpD6848nlrlVKXKYCbWjQ7VQEkQICiAwAAEMoPrn\
    tKiuSsC10EIboqwP9EdrEreWgw8/vv5j7rno9gOsZZ4hR1BbQbZliylgLDAqtqxOOwCqAeBrbYgk\
    StmfrK+VMIWB9JDbTz/oNvyPKsG6ddy7Pxn0UzDJ1osvvvsCwGq/em58bQABywrqBRxcQGsJLpaz\
    D6QOLyxzKKkEG1SFPrVnabIiOHAtAEBjyy/I2Fqr56qjltzAif6VoMGWzrxD7j8yn8sww6pA3FaP\
    n8UXzJC1fJIDBBFEILKqInscMrYAk9hnn9OtLMk2j5rLsN3nZk3L/mVbu2XpTsXoEkkOJph97apG\
    j9zqn2oTsG+/bQesdMEDwiJ1uQtTLXM/oaiClixbs+WWQpbSmwICABCtNr9/oiq0tNQ6qQAACCAQ\
    wJNOFurd3OP6unnmD+udVlAVt8VZQ7+sAsbpj/8M9KkBAN08ttIrAPCSTToJYnVaWj61w1RnjYrn\
    aXF27PE/0rvsyCJv/DjR1+IpeYh6nnh7iVmWEU3vdme+sPiykEX5jiWcoWCsD4Qz3L5I9bznYat1\
    ItveBUTFAOsJikkSBEHLXtY/zfUja5ZpBS10Epeg+GRNbkkEGCgANNgNoHaoE4AMBeCAPIXqTmWL\
    AAdE1SwGiCp+/iDq1tPK4D3MbS5HELuMmUrYt2DQ4hM1gIDHGIcAB0CAAhDIIgQcwMUa5rCLDtBh\
    CLh4gdqV7QFl0xYDtqPBMmyDf1SzW9bIhxZg0MKJwvlJQ1bRBwgIoFSmcsAGVkBIF0ggAxvYAAUw\
    wMgQVKACCUjAIylAyRSkgAIhCMEOywYiVllJRSAg4uXwZi7hoeWON0MfMmphhxwsgFSBnIELqACF\
    WipBCTqAwQx2ucsMzGADIpCBMHcpgxxQcgM32MAjw3itQXFnS3QjV6/0oY9UmBKVXrsZLRIxArOZ\
    SgAyEAMc4kCHL3whDlJYwg5uqYQnPOEHT1CCDW4Jz3f+gJf4/hRBBZzVrye9xkXn2AdlKBMKmp3S\
    OF5rS1DAMAKfmQoCW6jDG9RA0Yqa85xxgINGw8AGNmy0lrV8pw2EsAQlAAEIPKjAtAImIC00Ax72\
    iKk94mGPgqbiLPGZ0IQkFoxV5GAEAriWAGoQhjZM9BB4IAQh3ICGQzjVEIYohFSlGoc4dDQNaTAD\
    E6AQBi94NQxK+KXtbgeiBmhAC38ghz3qwdZ4yKOgphQOLYBxmfiYYmweAwAFthCGOKxBqYR4hGAH\
    UYlBPKIShNiEYjfBicZyYqqFoENV20DZNoSBDEDAQPYegLuzYiMe8agHaOHhCWvqzTN31EkwdPIJ\
    EfwRAAKY/oEY2qAGPAj2to8QhShuK4pSnAITmDiFcIWr2EMQAqpVhSplqyCDGkYJSlICASjYEVN5\
    xAMeNLMmWjijk0kFxRaR8CPQBAAEMcThDYHl7W5vW4r2Dve9xN0EVKNaiPkWIgxAoAACSASoBoBA\
    C9iwhzzkAQ93eMKgaMFjHo1ji9a+dgNbgAMd3mBb3OaWve11L3yBiwn5RhWqU60DEHq2X7cFoATS\
    ZQeB3WFgmnnOFnPlkbDm+sQZvDYDT5BwbQlRiR5beLe6DXJvfXuKUgB3E06dalTbUIcadPOHUnLS\
    f8kx4AKbVm9BmatqU+tgoMnWqOgFLI8rcWHBBjnDaC5F/o+BawgPLxm/T4bWvpb2324ImMBzzEn5\
    hmG+oAQuvH8calffsIakWtjCPa6EkYMrXEwkerHzfXN+fQalOT/tDwFuq2VuCmPPGC+PtuCDDGFL\
    VDiAGQ+oVuogVs3qwlZCsRyO9ZHdHNUwMDcE+9WXlEFBDrbiGYQiTEtbhCEMhdZiD6N2gGz7OtHa\
    oqGprDasYBXNYcWuudpuLgQcxAAEZZZ4X1EGwR/YMVp25JkWqvAMZ4BhjGIHYw9SBAAEysvs2uLB\
    DW6IdrQrge3FKna+TwUxHJ4wg3027lopGneB3ZEOTzgcy8KJz9ZqoQcDJAAACaB3VSmKb3zrOxBO\
    XbNi/k9R3E0A16mHsG8bxPCDDdROXwSw0h+6weJ0qMMTWbOmauODzWHs4QDjBYIS+kqH2g4i34II\
    RCAQoW9FEzm+kI40fetQhRnod6W3Y1mi0mHzh2fNTG1S9zAo4UcCDBULXpXCUVd9iKYK4hCFJWyi\
    0byJ+haC1iDWNreBjvUGsMwZXLd5KxzeCk7nsYm16MMfCRABGWxhCUvwghSkYHR9sx3lPU55ISwb\
    hs7XgbJ5Z7IcnsDCfLXO74C3uToGT3idTkgXujBGUI79WnD+wAY2WAENdtBXNXg8qYRoO8oPoYY4\
    qNMGMACCDqpQBTF8HrJwGP0GGhelATRgCs4whzrW/rGOwSexFTqtxTC6GxQyiFcAg1yBBNYvAd1T\
    4QvPRoMail7RN6STBivIQAZgsILb2+AHzlcHGtUIcqAHW1ABQeM4bmME2bd965Bzgwd+rlcL3VUL\
    fLAAgbYBM7B+FsB+7scEXHAEXMAFX1BO92dI+jcD/Xd7P9CCARh9e9AHWYBrC0QAJHICDKh926cK\
    hHdTNWMLqlALI4QxrtBH47UBGSABLrCE66d/NkADUMAEIkiCVLAE+Kd/IpCFIgADXAgEPwAEVUAG\
    dkAGYNAHYJAFReAAeYUAjhQCVtALOvgOEJNnEKNz4Zd4tUcB+icBHXhIECAC++cCTMAE5sQEVEAD\
    /i6wAlyof4mUASJQA2CoAzoABpRohluwBzOwRaSCABVAATzgBMkwDuqwfamQXXNUMxKiUxijCRiQ\
    JwKAATJQA+qXSFsEASMAiCuwA1Swi4jIhTBQAyKwAQeARbdYA1tQAxkgA0VwBnogB3KQBj8gAmbD\
    AA5AATPwA2eQDOjAfXI4eNa0CjmXCq/wCrAHe6bgAwsQAQ6AAWCwBT+QfxsgAKizjiMAATDwhD8A\
    A/q3f8CISAcATJBYBUDwi2TgfG2QUVXQUGEEATOgB09wBtzAferwDqVoijkSgamgC67HByPASOy4\
    BfqITJGUAJSUhTXQfGJgA44IA+u3Aku4hE8g/gZi0Hm8Z2pvYFVwoJI1hAAJYAFPoAeQwA3oMIrv\
    EIE9eFPrIoG2wDMV4ADgVAMsKQEd0AHtp4jrpwN1wAltsAM6AJWERANQaEud1wZeRVmTFX2Z5QCP\
    1AEW0AJAKZSjmA6lOAoGhUSlyGkTUgvKswF+tAE/sIQT8JJ/+Y4rsASFQHJegH9AoHtgGU+3VFSU\
    5QVVJVlMxm0d6Yku+QSLEAvjMJRcV5EulmehsAqu4Aq8UAuo+QlWh35/2QITMAEt4AI08H80IAFw\
    wAntFQcxQAO3FJbxBAWmVgjndZN0QJkaZVLX+AS1RAWNwJlDOYq2UIp5Zk0FNQqleZqoOQtg/nBF\
    g/QCMfCdu9mYLUACcXAI7WUI6BQGAhgGu7iLt9lR50R8wqltzygGP6mcHbWZnTmK5nCXPvifozCO\
    Agp7vEAJwShLUTiI4LmLJBADdGCepXAIdMAGVhUHB0kFFNpRFGoITkVRknVVBagHaQAHhcAJjZAL\
    6NAO/HlTARqgN7UKnxAKn3BT4xh7usALZJB8P6AEVDCIhriL3ykFhpBhKAdVb3CkUlBOkhUHhqBU\
    bVd8GpoGBbgIcuBYi8AM7dAO7qAO6OCD2ZUKqwCjBUUzNaoLq7UKAqkES9CjPjp5broGaOZUeMBv\
    iVanr+ZUaFCckkWfzigHJcoJrBAL3KCl/izmDndJMwW1Ciw6CtZ5nbAXF59ABjsQeeZEgiM4gl+A\
    B6XQW5VAfBQFd7mlWxlWCRw6f0u6eXWQB3VQB3+KCrMwDoTKYjf1pS86mqNgCriKmrywq7wwC3wA\
    eV/ABWjgBkqHBpg6p2oWfBJKUUnVY6OKCUpFUTcpVau6qo3gWCeqDefADvDQraswpuI4jmH6CeT6\
    CWFaC6a5q6zEnvBHrIHAVJj6oGo2fBWFBqvmrMN3pJSlbamaB3bQCADbCJQwBt3AraAlD65gCjSD\
    qwH6CnRJrqbwCaaQrrwwDLOQCOwqrPF3qUUHd5knoV9QUag2CCiXp1WlbUxWrXmQCImw/gcxOAZa\
    ULDwQFP24AqKWp0NW4qJILG4OrG7arF7IAZKwARmQAcbywWDWLR6qlVJS38U1VTFaaGVBQcCSLVy\
    kAiUQAlgcAnNwGvdGlr1MI63GqY3lXMyyrPXuauzELQ8GgfwZ6wheAQkQAIv0J4v8AI0QAVm8Gxf\
    MHlSS1kapVF10Hl9agefkLW5AA3QIA9rxVb1MJevYLP/ebblugo+u6uJUAVYMKlScFFHcAQeQALt\
    5wKuOQE08ARZZQZaVYVe5QWdFwZ5oJ6D26dyYAeU8AmacAzQoA2N67gsSpo0+gpgCqPk2gjmWgu8\
    GglkoAO4N5tQyARzi4JT2X7whFVp/tCeXeW62ftVhCsGeiAGe0AJmuAK0nAN2gBTjhu2rzCaYeoK\
    42gK41pQ5EqavPoJVSCJNvCSpFu6TeiIxrgFMdmbs7kD67QE2YsFYSCTMkkGLrsIlMAM02C+VNa7\
    0fmipWkKs8qoo1C5q1ALs/DBW6CCTMiBFtCBgZmI/edOW1AF8kSYuqemSyAGS4AFNEwGNiyGfHC7\
    1EAN1iDBFDyrDiu5Psio8+sKugonfTADU0lI+8iWEtACdUsFMQB57zSQvph886Smk4oFzHfDDIy1\
    zGANYnwN3qANaiVgekmuDku2YJoKOSuOBMoLuUAJKriChMSHSvgCJPC5g0gCLRCb/oqof8m3fGJA\
    wEJAw4iMBWPIB64wDdaQDdngDd4gwQNWC6xArjYVpt/qsIxKo+Uox7mwBQPphXd8AOynhExoSIbk\
    gTCwfASMBYesuV1sw3wQCcswDdMQyZJcxs1wDvegCwlrCqPwovC7Chp8rujKq3KcxP2nv+t3AAdg\
    AAeQAdAMza/ZAlBwS7infId8yFiwBF4shqYgDdNADbosydcACr3MC8Hsg+OKqxJrs2nLq7mgCTLQ\
    yri3hH88AR7Qz685t4MIBWx6iDYABCOluYkchmKYCLecy7oMDuBwDaQwB82glwpLM+MKo2GaXfS7\
    q8wwC8QQC0VQx0t4t3rcz5+b/tJHYE6d+wVMoASzqQSTOqmv23l2wAefQM6Q/NARPdGgwM5iGgrB\
    DL/mqqg3Rc9FcguxAAk30AEuKZs0cNL97AEp/aNpp06SCMOQ97piQAa1rNM7HckQfQ1zUNZuoslu\
    /AoTG7HmSqO6CsrH0BxOkEz794Q0ULolPAGEZAOT2rpewJU6INOQpwRYUJA3HQnFUA3V4NDZANEQ\
    LQ1+MAZjcNafkCOjCc/kmiNgqsxyHNe3MAQnUAFI+NRMCM0dsH8rMHReQJZhANiBvU6vmwd8wAe8\
    IA3U4Mg97A2OLQ6kINlXcNZsHAqdTLznqsxFkgzJQBEo8AGirYQtgIirTEip/t1VFuq6uPR/7qSm\
    nYcFicAMts3D13ANkSwO5O0NgODbZ52wwmudAXq27csLNwrXydALndADeyHaLgl537kDLwAFacAG\
    URsHrgvL7QRPM6medlAL3+3Qug0O5C0O1wAITWAFv33W7uy+Dsu+9BvHuYDc9H0HUBHaM2ADa+qm\
    FFqcwplRQisGQiAELKwEZIAFtavguMzguv3g4uAK5z0Gv72rNmvUDEuXiUqx8k3fnXAHdhECFAAD\
    kCd5XWVqgVsHMnm/ksh8SiAGtbsK5JzL4m0Nuy0O4GANjjAGWXAFV7AMuiC8QAimnQxXmszZucAM\
    yX3kd5AUQ1ABKvgDNLCm/jLsfM4oBlWwBcdo5VcuBnawCs8gDWK86NbgDQ8O0dZw3hR+5mmuC5v2\
    n+7cwcadC3FN35MA4kSQCVkQTFjMTrfEfF7Ygi3oTjJpuM9w24wtyTgO5seQBVZw61YQF+wsvJju\
    xpar6cbd6Z3w6SigCLFACSOWhTNQ6pIIBDXw7Ml3UrRsy7gc1tkA5jiu25dwBbfeBJO9DEDdwYqq\
    yRq9CvBdjjcq7J2QBENwCbNwbDBQkluoiFz47FCZfJpLBlVgy99tzpDs4GDu4GN93k2QBWQ+DKv1\
    ChXspaPpg0sZ7MldEUPgBLGAmo0QwopEAYBokrFYA1WuBGH4wLZt7Y6O/uOOfQxdUOZO4ARXgBwa\
    6YO8frb++QqbnguZ4ASZVAQVjwusoAc/0AGJpEhaqPFQuXxPsAWUkAtg/e/gIOsmDw65UOZm7gRZ\
    EBcLT+7lGqMTwtnLjPNKDgbvvgussAh6MAOOSAHApIUdf1Jb0AezMPKQ/A2Ovcsmbw1+cAVDcAUG\
    nwXLMH5LSe7jGqM0YwvA7gqksDyO1Il9UAvAsAu7cGwDKQOUpPGPaO8nBQau8Or+fs50L8kQHQ6Q\
    vfJ63wVdgOawp8lZE/iajJpp7gr2nAKZNEmUwGd2xAqNsAfJrvEUIAPB9Ow5IAKaUNu57NgOvsvG\
    D/C1fgVUnwWkb/UC/jqrqZD1nAZ7kdAHRfBISh4CGDACs/8LvvD9qNDzP5ABk5+FwpSFmqAJjjAN\
    1fANct/0ji7rJV/evT0G3h4EQVD1sCegvN6iX6rWAMEHjI8UGEKEqODAxAhNyIA9/NWo0aI9MzJQ\
    oACBAo8ikGJBKuID0LFs4MCJQ2lSpcpw1vxcaRIzS5YrxXTpevUqVatUPUOlChXq0yeBOYKYQIqw\
    AoeFrp79otVoCxAwe6zKMBjCiR+uRaJEceLExLFr3sSdRHl2JTiXTmZegRtkGS+cOnv2XPUpVKQ+\
    XYymCMFBMIeDDjCMYDZsVZ8iQRxnkdFHMpiZlZvQhDvEyiVrZr99/lsLDrS0t5dlLruZ026qVab4\
    guni4yhS2iYIY8CQI1ckSn2+OombAgwYyX0AHZ8DaEwQJ5kUZbpENjRLZpizxGwSxGZdnUEj8ekS\
    20eOFBRSFKSNAemILppMfaJ05gzYK1m6EJfsyJElS4DmzBnDEUogueQSR0iRpprPFiwJnEtoCgu4\
    K0IYhq66RgklEdh84JAgDArCDSkQRxjBB0dMWYUSq/rwowuuitNEk/34O06TXHKhJBZKZHRkjmO8\
    +UacBakBJAsr4AorBBOKsakVoV7LYbzxyCtohIVIJBE3CkYAxJVVUqQkzN6K25E/S/QDRJNYmJll\
    llhi1MQPEx5o/oKUY6CZBhxqcjDyCsdMcGwYXUb5TiAwZMjhr/MWVc8EECtACLccNKmFlby+zGuP\
    3jQhhT/9JIvlmWGGIWaWoTQBwzYOHngABBAueckKWQH1MwheTOkrvCkX5TWF2lKoIFgKKsBthEln\
    qWUVVlShpZZEEpGRlE4dAcSRXJiRZplhakHWFFR9PSiCCAaTNSYfYgqiCVPASDTK8VIIgteDAqsN\
    A2FHOA+DBXy4sZZRk4WWU2lJqRZbaRIjhhhtedHEKNsOwoApDrCj+Aon+pChsXhTkC3RReed19F8\
    G0WKgyz8yIWYfz+B1hRTpD3QYGmeeYYZmp8hpo+NlQoBXkApBc4iwoAAADs='


def circle2(): return b'\
    I2RlZmluZSBjaXJjbGUyX3dpZHRoIDMyCiNkZWZpbmUgY2lyY2xlMl9oZWlnaHQgMzIKc3RhdGlj\
    IHVuc2lnbmVkIGNoYXIgY2lyY2xlMl9iaXRzW10gPSB7CiAgIDB4MDAsIDB4NDAsIDB4MDEsIDB4\
    MDAsIDB4MDAsIDB4ZmMsIDB4M2YsIDB4MDAsIDB4MDAsIDB4N2YsIDB4ZmYsIDB4MDAsCiAgIDB4\
    ODAsIDB4MDcsIDB4ZTAsIDB4MDEsIDB4ZTAsIDB4MDEsIDB4ODAsIDB4MDcsIDB4ZTAsIDB4MDAs\
    IDB4MDAsIDB4MDYsCiAgIDB4MzAsIDB4MDAsIDB4MDAsIDB4MGUsIDB4MzgsIDB4MDAsIDB4MDAs\
    IDB4MWMsIDB4MWMsIDB4MDAsIDB4MDAsIDB4MzgsCiAgIDB4MGMsIDB4MDAsIDB4MDAsIDB4MzAs\
    IDB4MGUsIDB4MDAsIDB4MDAsIDB4NzAsIDB4MDYsIDB4MDAsIDB4MDAsIDB4NjAsCiAgIDB4MDYs\
    IDB4MDAsIDB4MDAsIDB4NjAsIDB4MDYsIDB4MDAsIDB4MDAsIDB4NjAsIDB4MDcsIDB4MDAsIDB4\
    MDAsIDB4ZTAsCiAgIDB4MDYsIDB4MDAsIDB4MDAsIDB4YzAsIDB4MDMsIDB4MDAsIDB4MDAsIDB4\
    NjAsIDB4MDYsIDB4MDAsIDB4MDAsIDB4NjAsCiAgIDB4MDcsIDB4MDAsIDB4MDAsIDB4NjAsIDB4\
    MDYsIDB4MDAsIDB4MDAsIDB4NjAsIDB4MDYsIDB4MDAsIDB4MDAsIDB4NjAsCiAgIDB4MGUsIDB4\
    MDAsIDB4MDAsIDB4NzAsIDB4MGMsIDB4MDAsIDB4MDAsIDB4MzAsIDB4MWMsIDB4MDAsIDB4MDAs\
    IDB4MzgsCiAgIDB4MzgsIDB4MDAsIDB4MDAsIDB4MWMsIDB4NzAsIDB4MDAsIDB4MDAsIDB4MGMs\
    IDB4NjAsIDB4MDAsIDB4MDAsIDB4MDcsCiAgIDB4ZTAsIDB4MDEsIDB4ODAsIDB4MDcsIDB4ODAs\
    IDB4MDcsIDB4ZTAsIDB4MDEsIDB4MDAsIDB4ZmYsIDB4ZmUsIDB4MDAsCiAgIDB4MDAsIDB4ZmMs\
    IDB4M2YsIDB4MDAsIDB4MDAsIDB4ODAsIDB4MDIsIDB4MDAgfTsK'

def line1(): return b'\
    I2RlZmluZSBsaW5lMV93aWR0aCAzMgojZGVmaW5lIGxpbmUxX2hlaWdodCAzMgpzdGF0aWMgdW5z\
    aWduZWQgY2hhciBsaW5lMV9iaXRzW10gPSB7CiAgIDB4MDAsIDB4MDAsIDB4MDAsIDB4N2UsIDB4\
    MDAsIDB4MDAsIDB4MDAsIDB4ZmYsIDB4MDAsIDB4MDAsIDB4MDAsIDB4YzMsCiAgIDB4MDAsIDB4\
    MDAsIDB4MDAsIDB4Y2IsIDB4MDAsIDB4MDAsIDB4MDAsIDB4Y2YsIDB4MDAsIDB4MDAsIDB4MDAs\
    IDB4Y2YsCiAgIDB4MDAsIDB4MDAsIDB4MDAsIDB4ZmYsIDB4MDAsIDB4MDAsIDB4ODAsIDB4N2Ys\
    IDB4MDAsIDB4MDAsIDB4YzAsIDB4MDEsCiAgIDB4MDAsIDB4MDAsIDB4ZTAsIDB4MDAsIDB4MDAs\
    IDB4MDAsIDB4NzAsIDB4MDAsIDB4MDAsIDB4MDAsIDB4MzgsIDB4MDAsCiAgIDB4MDAsIDB4MDAs\
    IDB4MWMsIDB4MDAsIDB4MDAsIDB4MDAsIDB4MGUsIDB4MDAsIDB4MDAsIDB4MDAsIDB4MDcsIDB4\
    MDAsCiAgIDB4MDAsIDB4ODAsIDB4MDMsIDB4MDAsIDB4MDAsIDB4YzAsIDB4MDEsIDB4MDAsIDB4\
    MDAsIDB4ZTAsIDB4MDAsIDB4MDAsCiAgIDB4MDAsIDB4NzAsIDB4MDAsIDB4MDAsIDB4MDAsIDB4\
    MzgsIDB4MDAsIDB4MDAsIDB4MDAsIDB4MWMsIDB4MDAsIDB4MDAsCiAgIDB4MDAsIDB4MGUsIDB4\
    MDAsIDB4MDAsIDB4MDAsIDB4MDcsIDB4MDAsIDB4MDAsIDB4ODAsIDB4MDMsIDB4MDAsIDB4MDAs\
    CiAgIDB4ZmUsIDB4MDEsIDB4MDAsIDB4MDAsIDB4ZmYsIDB4MDAsIDB4MDAsIDB4MDAsIDB4ZjMs\
    IDB4MDAsIDB4MDAsIDB4MDAsCiAgIDB4ZjMsIDB4MDAsIDB4MDAsIDB4MDAsIDB4ZDMsIDB4MDAs\
    IDB4MDAsIDB4MDAsIDB4YzMsIDB4MDAsIDB4MDAsIDB4MDAsCiAgIDB4ZmYsIDB4MDAsIDB4MDAs\
    IDB4MDAsIDB4N2UsIDB4MDAsIDB4MDAsIDB4MDAgfTsK'

if __name__ == "__main__":
    root = tkinter.Tk()
    ph = get("line1")
    b = tkinter.Button(root, image=ph)
    b.grid()
    root.mainloop()
    root = tkinter.Tk()
    ph = get("circle2")
    b = tkinter.Button(root, image=ph)
    b.grid()
    root.mainloop()
