try:
    from PIL import Image
    from PIL.Image import (open, new,
        ROTATE_90, ROTATE_180, ROTATE_270,
        NEAREST, ANTIALIAS, BICUBIC)
    try:
        from PIL.Image import DecompressionBombError
    except ImportError:
        class DecompressionBombError(Exception): pass    #Support for older versions of PILLOW 
    from PIL.ImageTk import PhotoImage
    from PIL.ImageEnhance import Brightness
    from PIL.ImageDraw import Draw
    from PIL.ImageFont import load_path
    from PIL.ImageFilter import SMOOTH
except ImportError:
    from . import Imagefake as Image
    from .Imagefake import (open, new,
        ROTATE_90, ROTATE_180, ROTATE_270,
        NEAREST, ANTIALIAS, BICUBIC,
        DecompressionBombError)
    from .ImageTkfake import PhotoImage
    from .ImageEnhancefake import Brightness
    from .ImageDrawfake import Draw
    from .ImageFilterfake import SMOOTH       #Note: ImageFilterfake is the real ImageFilter (it is not fake)

try:
    import sane
except ImportError:
    from . import sanefake as sane
try:
    import _sane
except ImportError:
    from . import _sanefake as _sane

from .getscandpi import getScanDpi, getScanDpiFake
from .Imagefake import ThanImageMissing


def imageSetmaxpixels(n=None):   #Thanasis2018_04_05
    "Change the default max pixel size (int(1024 * 1024 * 1024 // 4 // 3))."
    if n is None: 
        Image.MAX_IMAGE_PIXELS = int(1024 * 1024 * 1024 // 4 // 3)  #default
    else:
        n = int(n)
        if n >= 1024: Image.MAX_IMAGE_PIXELS = n
