# -*- coding: iso-8859-7 -*-

##############################################################################
# ThanCad 0.9.1 "Students2024": n-dimensional CAD with raster support for engineers
#
# Copyright (C) 2001-2025 Thanasis Stamos, May 20, 2025
# Athens, Greece, Europe
# URL: http://thancad.sourceforge.net
# e-mail: cyberthanasis@gmx.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (www.gnu.org/licenses/gpl.html).
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##############################################################################
"""\
ThanCad 0.9.1 "Students2024": n-dimensional CAD with raster support for engineers

This module defines ThanCad fonts made by straight lines.
"""

from .thanfont import ThanFontLine, thanFonts

def makeTimes1Lines():
    "Makes the lines that define each character in thanFontPrime1."

    dilines = \
{
  0: 63,

  1: 63,

  2: 63,

  3: 63,

  4: 63,

  5: 63,

  6: 63,

  7: 63,

  8: 63,

  9: 63,

 10: 63,

 11: 63,

 12: 63,

 13: 63,

 14: 63,

 15: 63,

 16: 63,

 17: 63,

 18: 63,

 19: 63,

 20: 63,

 21: 63,

 22: 63,

 23: 63,

 24: 63,

 25: 63,

 26: 63,

 27: 63,

 28: 63,

 29: 63,

 30: 63,

 31: 63,

 32: 63,

 33: [ [24.523873638312871, 13.918774049227977, 23.23854371481303, 13.827615898623662, 22.035256126855732, 13.554141446817084, 20.914010874440979, 13.089234878741991, 19.86569214250849, 12.442012009461905, 18.899415746118532, 11.612472838975918, 18.881184115997989, 11.594241208855237, 18.033413315391702, 10.609733182343916, 17.377074631051361, 9.5522986353525994, 16.903052247916659, 8.4401691979983298, 16.620461981047921, 7.2459974251014501, 16.529303830445091, 5.9880149467817319, 16.529303830445091, 5.9424358714813934, 16.629577796108201, 4.6662217630409941, 16.912168062976939, 3.4720499901441144, 17.386190446111641, 2.3599205527889353, 18.051644945512258, 1.32071763591739, 18.899415746118532, 0.36355705458663579, 18.93587900635967, 0.33620960940697842, 19.893039587689341, -0.51156119119968935, 20.93224250456154, -1.1678998755387511, 22.053487756976288, -1.64192225867464, 23.247659529873321, -1.9153967104830372, 24.523873638312871, -2.0156706761463283, 24.624147603975981, -2.0156706761463283, 25.891245897355251, -1.9062808954240609, 27.085417670252269, -1.6145748134940732, 28.197547107606741, -1.1405524303590937, 29.245865839539221, -0.47509793095923669, 30.221258050989469, 0.36355705458663579, 31.050797221475172, 1.3298334509772758, 31.698020090755222, 2.3690363678497306, 32.15381084376935, 3.4993974353246813, 32.436401110638123, 4.7026850232823563, 32.527559261240953, 5.9880149467817319, 32.436401110638123, 7.2368816100397453, 32.16292665882964, 8.4401691979983298, 31.698020090755222, 9.5614144504115757, 31.050797221475172, 10.627964812466416, 30.221258050989469, 11.612472838975918, 30.175678975688051, 11.648936099217281, 29.19117094917755, 12.469359454643381, 28.133736402184748, 13.098350693801876, 27.00337533470972, 13.554141446817084, 25.800087746752439, 13.827615898623662, 24.523873638312871, 13.918774049227977],
       [24.669726679277399, 99.999415663474792, 24.277746631685229, 99.990299848414907, 23.065343228667668, 99.835330992389572, 21.916750531072068, 99.479814205040384, 20.841084353958738, 98.93286530142268, 19.838344697327638, 98.194484281540099, 18.899415746118532, 97.264671145390821, 18.698867814792319, 97.027659953822877, 18.015181685271131, 96.079615187553827, 17.45000115153362, 95.040412270682282, 17.012442028640059, 93.910051203208241, 16.702504316590449, 92.697647800188861, 16.51107220032452, 91.384970431508918, 16.456377309962821, 89.981134912223752, 16.456377309962821, 89.57092323451343, 16.501956385264229, 88.549951947760746, 16.58399872080679, 87.319316914621595, 16.711620131650729, 85.897249765219385, 16.884820617796091, 84.28375049954866, 23.22942789975275, 25.887839223378251, 25.964172417837521, 25.887839223378251, 32.45463274075869, 84.28375049954866, 32.564022521482087, 85.49615390256713, 32.66429648714518, 86.899989421849568, 32.718991377506882, 88.103277009807243, 32.737223007627449, 89.115132481498222, 32.700759747386307, 90.446041480299755, 32.573138336542343, 91.858992814642988, 32.336127144975023, 93.17167018332384, 32.007957802804839, 94.356726141160834, 31.579514494971569, 95.441508133333627, 31.059913036535448, 96.407784529725177, 30.430921797375959, 97.264671145390821, 30.15744734556748, 97.565493042379785, 29.200286764237831, 98.44061128816702, 28.17931547748617, 99.124297417687558, 27.076301855191989, 99.607435615883333, 25.909477527475811, 99.89914169781332, 24.669726679277399, 99.999415663474792],
     ],

 34: [ [16.666041056349311, 100.00027996740755, 15.863849331044459, 99.963816707166188, 14.5967510376652, 99.75415296077972, 13.4481583400696, 99.334825468006784, 12.43630286837822, 98.72406585896897, 11.55206880753081, 97.912758318601846, 11.10539386957697, 97.356693599925165, 10.567560781020321, 96.445112093898388, 10.148233288247321, 95.369445916782752, 9.8474113912579924, 94.138810883645419, 9.6650950900523451, 92.744091179423776, 9.6104001996906447, 91.203518434233956, 9.6104001996906447, 90.902696537244083, 9.6468634599317795, 90.109620627001277, 9.7106741653537352, 89.19803912097268, 9.8200639460771413, 88.14972038904034, 9.9568011719813683, 86.982896061324027, 10.13000165812676, 85.688450322762947, 10.33966540451325, 84.266383173359827, 10.59490822620117, 82.716694613111031, 10.877498493069909, 81.039384642020195, 11.18743620511952, 79.234453260082773, 15.15281575634242, 57.894330203962454, 18.252192876838478, 57.894330203962454, 22.144645907579129, 79.170642554661754, 22.25403568830254, 79.75405471852082, 22.59132084553298, 81.622796805877442, 22.89214274252231, 83.363917482392026, 23.15650137927048, 84.959185117941161, 23.384396755777541, 86.417715527585642, 23.575828872043498, 87.730392896267404, 23.73991354312858, 88.906333039043602, 23.85841913891224, 89.945535955915147, 23.94957728951508, 90.838885831823973, 24.004272179876779, 91.595498481827235, 24.02250380999735, 92.215373905924935, 23.940461474454789, 93.546282904728287, 23.694334467827161, 94.804265383047095, 23.275006975054168, 95.952858080641818, 22.68247899613581, 96.982945182454387, 21.934982161192639, 97.912758318601846, 21.31510673709343, 98.459707222219549, 20.30325126540205, 99.134277536680202, 19.191121828047581, 99.617415734874157, 17.978718425030021, 99.909121816805055, 16.666041056349311, 100.00027996740755],
       [43.26598940225378, 100.00027996740755, 42.281481375743247, 99.954700892107212, 41.014383082363977, 99.726805515599153, 39.874906199828672, 99.307478022827127, 38.844819098016728, 98.70583422884738, 37.933237591988501, 97.912758318601846, 37.477446838974373, 97.384041045105732, 36.912266305236841, 96.46334372401634, 36.47470718234328, 95.396793361964228, 36.164769470293663, 94.175274143887691, 35.973337354027741, 92.798786069784001, 35.909526648605777, 91.276444954716681, 35.927758278726323, 90.237242037846045, 35.973337354027741, 88.95191211434485, 36.055379689570287, 87.67569800590536, 37.641531510059451, 78.951862993216309, 41.53398454080007, 57.894330203962454, 44.997994263707447, 57.894330203962454, 49.100111040834598, 79.024789513697215, 49.209500821557981, 79.608201677556281, 49.455627828185612, 80.957342306475766, 49.665291574572109, 82.288251305279118, 49.856723690838038, 83.610044489018946, 50.020808361923137, 84.904490227579117, 50.157545587827371, 86.180704336017698, 50.266935368550769, 87.438686814339235, 50.358093519153577, 88.678437662537362, 50.42190422457557, 89.899956880614809, 50.458367484816698, 91.103244468571575, 50.467483299876989, 92.288300426408568, 50.403672594455003, 93.537167089666582, 50.166661402887662, 94.813381198106072, 49.765565540235229, 95.961973895702613, 49.191269191437407, 97.001176812574158, 48.452888171554548, 97.912758318601846, 47.887707637817009, 98.423243961979097, 46.875852166125668, 99.11604590656043, 45.763722728771199, 99.608299919815181, 44.560435140813887, 99.900006001744259, 43.26598940225378, 100.00027996740755],
     ],

 35: [ [15.006962715377909, 30.793876333675144, 8.306838646070247, -2.0139420682826312, 14.286813325615579, -2.0139420682826312, 21.14190625094804, 30.793876333675144, 45.572290612505242, 30.793876333675144, 15.006962715377909, 30.793876333675144],
       [21.14190625094804, 61.432130751283694, 16.1646712280338, 36.700924492736704, 22.217572428061398, 36.700924492736704, 27.267733971457911, 61.432130751283694, 51.84397137397962, 61.432130751283694, 21.14190625094804, 61.432130751283694],
       [35.052640032939202, 100.00114427134031, 29.063549538333572, 100.00114427134031, 22.50927850999042, 67.20244168444242, 28.489253189535791, 67.20244168444242, 35.052640032939202, 100.00114427134031],
       [65.754705155970797, 100.00114427134031, 59.765614661365163, 100.00114427134031, 52.782900325188727, 67.20244168444242, 28.489253189535791, 67.20244168444242, 22.50927850999042, 67.20244168444242, 2.6823807538759179, 67.20244168444242, 2.6823807538759179, 61.432130751283694, 21.14190625094804, 61.432130751283694, 51.84397137397962, 61.432130751283694, 46.647956789618597, 36.700924492736704, 22.217572428061398, 36.700924492736704, 16.1646712280338, 36.700924492736704, 2.6823807538759179, 36.700924492736704, 2.6823807538759179, 30.793876333675144, 15.006962715377909, 30.793876333675144, 45.572290612505242, 30.793876333675144, 39.008903769101828, -2.0139420682826312, 44.852141222742937, -2.0139420682826312, 51.552265292050599, 30.793876333675144, 71.160383486718345, 30.793876333675144, 71.160383486718345, 36.700924492736704, 52.782900325188727, 36.700924492736704, 57.823946053524992, 61.432130751283694, 71.160383486718345, 61.432130751283694, 71.160383486718345, 67.20244168444242, 58.908728045698609, 67.20244168444242, 65.754705155970797, 100.00114427134031],
     ],

 36: [ [10.97777245873303, 24.085500753252745, 7.8054688177546998, 24.085500753252745, 7.8054688177546998, 3.6843066483397706, 8.5803130978787294, 3.3652531212301255, 9.8929904665594108, 2.8547674778546934, 11.18743620511952, 2.3716292796589187, 12.45453449849879, 1.9158385266446203, 13.69428534669723, 1.496511033871684, 14.915804564775071, 1.1045309862811337, 16.119092152732382, 0.73989838386842166, 17.295032295508829, 0.40261322663718602, 18.452740808164691, 0.092675514588336227, 19.592217690700011, -0.18079893722006091, 20.704347128054479, -0.42692594384789118, 21.816476565408951, -0.66393713541583566, 23.01976415336625, -0.89183251192207535, 24.24128337144413, -1.101496258309453, 25.481034219642542, -1.29292837457524, 26.739016697961549, -1.4661288607194365, 28.015230806401089, -1.6119819016839756, 29.30967654496121, -1.7487191275886289, 30.631469728702172, -1.8581089083118059, 31.96237872750342, -1.9401512438553254, 33.32063517148552, -2.0130777643362308, 33.32063517148552, -11.238282605341738, 37.933237591988501, -11.238282605341738, 37.933237591988501, -2.0130777643362308, 38.598692091389132, -1.9492670589152112, 40.020759240793183, -1.7851823878290816, 41.406363129956127, -1.5846344565034087, 42.75550375887795, -1.3567390799962595, 44.068181127558631, -1.0741488131279766, 45.353511051058462, -0.76421110107821733, 46.602377714317178, -0.41781012878709589, 47.814781117334739, -0.025830081195636012, 48.999837075171477, 0.39349741157820972, 50.139313957706797, 0.8584039796533034, 51.251443395061273, 1.3597738079679402, 52.327109572174599, 1.8976068965239392, 53.366312489046841, 2.4719032453222098, 33.32063517148552, 2.6724511766487922, 33.265940281123818, 2.6815669917077685, 31.770946611237491, 2.8456516627938981, 30.321532016652579, 3.0553154091812758, 28.926812312429352, 3.3105582308680823, 27.586787498567819, 3.60226431279807, 26.30145757506796, 3.948665285088282, 25.070822541929829, 4.3315295176198561, 23.894882399153371, 4.7508570103927923, 22.773637146738618, 5.2248793935268623, 21.707086784685568, 5.7353650369041134, 20.68611549793394, 6.2914297555807934, 19.728954916604259, 6.8930735495587214, 18.826489225636291, 7.5311806037789211, 17.969602609969741, 8.2148667333003687, 17.176526699725141, 8.9441319381230642, 16.912168062976939, 9.2084905748715755, 16.146439597913229, 10.038029745355743, 15.426290208150901, 10.922263806204683, 14.76083570875028, 11.861192757412937, 14.150076099711351, 12.845700783924258, 13.594011381034109, 13.894019515855689, 13.083525737658279, 14.978801508030301, 12.62773498464415, 16.127394205625933, 12.21752330693144, 17.321565978522813, 11.87112233464072, 18.570432641781736, 11.57030043765138, 19.873994195400883, 11.31505761596347, 21.223134824323097, 11.123625499697541, 22.626970343607354, 10.97777245873303, 24.085500753252745],
       [58.872264785457467, 41.715487079837658, 37.933237591988501, 41.679023819597205, 38.917745618498998, 40.995337690077577, 40.376276028144218, 39.965250588264098, 41.752764102246893, 38.980742561752777, 43.047209840807, 38.014466165364865, 44.268729058884837, 37.093768844274564, 45.408205941420157, 36.200418968366648, 46.46564048841293, 35.334416537641118, 47.450148514923448, 34.513993182215927, 48.352614205891427, 33.711801456909598, 49.18215337637713, 32.955188806907245, 49.929650211320308, 32.22592360208364, 50.595104710720932, 31.533121657503216, 51.18763268963928, 30.867667158102449, 51.698118333015117, 30.238675918943045, 52.126561640848387, 29.637032124963298, 52.54588913362138, 28.989809255684122, 53.174880372780898, 27.850332373150195, 53.712713461337557, 26.683508045432973, 54.159388399291402, 25.507567902657684, 54.49667355652187, 24.313396129758985, 54.742800563149501, 23.100992726742334, 54.888653604114012, 21.870357693604092, 54.943348494475721, 20.630606845405055, 54.943348494475721, 20.439174729139268, 54.879537789053728, 19.162960620699778, 54.73368474808921, 17.914093957439945, 54.49667355652187, 16.674343109242727, 54.168504214351678, 15.471055521285052, 53.749176721578692, 14.285999563448968, 53.238691078202862, 13.119175235731745, 52.637047284224217, 11.979698353196909, 52.409151907717153, 11.596834120665335, 51.707234148075401, 10.530283758613223, 50.950621498071939, 9.5184282869213348, 50.13019814264652, 8.5612677055923996, 49.245964081799123, 7.6679178296835744, 48.297919315529718, 6.8383786591975877, 47.28606384383837, 6.0635343790736442, 46.219513481785327, 5.3433849893126535, 45.453785016721582, 4.9240574965388078, 44.46927699021105, 4.4591509284637141, 43.375379182977149, 4.0398234356907778, 42.172091595019879, 3.6478433881002275, 40.868530041399453, 3.2923266007474012, 39.455578707055679, 2.9641572585769609, 37.933237591988501, 2.6724511766487922, 33.32063517148552, 2.6724511766487922, 53.366312489046841, 2.4719032453222098, 54.378167960738182, 3.0826628543609331, 55.353560172188423, 3.7298857236401091, 56.29248912339753, 4.4226876682232614, 57.194954814365502, 5.1519528730459569, 58.070073060152623, 5.9085655230492193, 58.908728045698609, 6.7107572483528202, 59.528603469797822, 7.3579801176329056, 60.41283753064522, 8.3424881441451362, 61.233260886070667, 9.3543436158361146, 61.998989351134377, 10.384430717646865, 62.700907110776143, 11.432749449579205, 63.3481299800562, 12.499299811633136, 63.922426328854023, 13.584081803806839, 64.442027787290101, 14.687095426101223, 64.906934355364513, 15.817456493576174, 65.298914402956669, 16.95693337611101, 65.636199560187123, 18.123757703827323, 65.909674011995591, 19.308813661663407, 66.128453573442371, 20.502985434561197, 66.274306614406896, 21.733620467700348, 66.365464765009719, 22.973371315897566, 66.401928025250854, 24.231353794218194, 66.374580580070003, 25.443757197233936, 66.292538244527464, 26.783782011097173, 66.146685203562939, 28.08734356471723, 65.937021457176442, 29.36355767315581, 65.663547005367974, 30.594192706294052, 65.335377663197804, 31.797480294251727, 64.943397615605633, 32.964304621967131, 64.48760686259152, 34.094665689442991, 63.968005404155399, 35.18856349667567, 63.384593240297328, 36.255113858728691, 62.746486186077561, 37.276085145481375, 62.044568426435802, 38.269708987051672, 61.278839961372057, 39.226869568380607, 61.096523660166412, 39.436533314767075, 60.613385461971433, 39.974366403324893, 60.07555237341478, 40.530431122001573, 59.501256024616957, 41.11384328585882, 58.872264785457467, 41.715487079837658],
       [37.933237591988501, 94.523403724055242, 33.32063517148552, 94.450477203574337, 33.32063517148552, 60.931625226914548, 13.41169507982846, 60.320865617875825, 14.058917949108521, 59.582484597992334, 14.751719893689989, 58.844103578109753, 15.49010091357289, 58.096606743166376, 16.274061008757169, 57.330878278102318, 17.09448436418262, 56.56514981303917, 17.969602609969741, 55.781189717855341, 18.881184115997989, 54.988113807609807, 19.838344697327638, 54.195037897365182, 20.841084353958738, 53.383730357000786, 21.889403085891221, 52.563307001573776, 22.983300893125119, 51.742883646148584, 24.122777775660438, 50.904228660602712, 25.298717918436889, 50.056457859997863, 26.529352951575021, 49.19957124433131, 27.796451244954309, 48.333568813603961, 29.10912861363499, 47.458450567816726, 30.46738505761709, 46.574216506969606, 31.871220576900608, 45.68086663106169, 33.32063517148552, 44.778400940092979, 33.32063517148552, 2.6724511766487922, 37.933237591988501, 2.6724511766487922, 37.933237591988501, 41.679023819597205, 58.872264785457467, 41.715487079837658, 58.197694470996559, 42.353594134058767, 57.468429266173963, 43.009932818397829, 56.702700801110232, 43.6845031328603, 55.882277445684792, 44.386420892502429, 55.016275014957962, 45.115686097324215, 54.104693508929699, 45.872298747328387, 53.147532927600061, 46.656258842512216, 52.135677455908677, 47.458450567816726, 51.078242908915911, 48.278873923241008, 49.98434510168201, 49.135760538907562, 48.826636589026123, 50.010878784694796, 47.632464816129101, 50.913344475664417, 46.392713967930689, 51.83404179675199, 45.098268229370568, 52.782086563021949, 43.758243415509043, 53.757478774471565, 42.372639526346077, 54.760218431102658, 40.941456561881722, 55.781189717855341, 39.455578707055679, 56.829508449787681, 37.933237591988501, 57.896058811839794, 37.933237591988501, 94.523403724055242],
       [57.094680848702382, 94.751299100562392, 37.933237591988501, 94.523403724055242, 38.334333454640927, 94.477824648753995, 39.801979679346402, 94.295508347548093, 41.205815198629921, 94.058497155981058, 42.564071642612021, 93.766791074051071, 43.858517381172128, 93.43862173188063, 45.098268229370568, 93.055757499349966, 46.283324187207278, 92.618198376457258, 47.413685254682321, 92.144175993322278, 48.489351431795647, 91.615458719825256, 49.501206903487031, 91.041162371027895, 50.458367484816698, 90.412171131867581, 51.36083317578467, 89.737600817407838, 52.208603976390947, 89.017451427645028, 52.992564071575231, 88.251722962580061, 53.266038523383713, 87.950901065592006, 53.922377207724047, 87.157825155347382, 54.54225263182326, 86.300938539679919, 55.116548980621083, 85.389357033652232, 55.654382069177728, 84.423080637261592, 56.155751897493282, 83.392993535449932, 56.620658465567679, 82.299095728216344, 57.039985958340679, 81.150503030620712, 57.422850190872559, 79.947215442663946, 57.76925116316329, 78.680117149284342, 58.070073060152623, 77.349208150482809, 58.334431696900822, 75.963604261321052, 58.562327073407857, 74.523305481796342, 58.753759189673822, 73.019195996849703, 58.908728045698609, 71.451275806480226, 61.716399084265618, 71.451275806480226, 61.716399084265618, 93.010178424048718, 60.759238502935972, 93.374811026459611, 58.8540331553369, 94.09496041622242, 57.094680848702382, 94.751299100562392],
       [37.933237591988501, 105.99109906989088, 33.32063517148552, 105.99109906989088, 33.32063517148552, 99.354785706004805, 32.481980185939527, 99.254511740342423, 31.041681406414881, 99.044847993955045, 29.646961702191678, 98.798720987328124, 28.297821073269859, 98.516130720458932, 26.994259519649429, 98.197077193349287, 25.718045411209889, 97.841560405999189, 24.496526193132041, 97.440464543346934, 23.3114702352953, 97.002905420453317, 22.1628775376997, 96.528883037318337, 21.059863915405518, 96.018397393941996, 20.002429368412749, 95.462332675264406, 18.981458081661088, 94.87892051140625, 18.00606587021085, 94.249929272246845, 17.067136919001769, 93.584474772846988, 16.17378704309408, 92.873441198144064, 15.3169004274275, 92.135060178262393, 14.50559288706236, 91.351100083076744, 13.70340116175751, 90.512445097530872, 12.84651454609096, 89.52793707102137, 12.05343863584636, 88.516081599330391, 11.32417343102375, 87.476878682457027, 10.667834746683409, 86.419444135463891, 10.08442258282534, 85.343777958350984, 9.5648211243892263, 84.231648520995805, 9.1181461864353821, 83.11040326858074, 8.7352819539035238, 81.952694755927041, 8.4253442418539066, 80.785870428208909, 8.188333050286559, 79.582582840253053, 8.0151325641411972, 78.361063622174697, 7.914858598478105, 77.12131277397657, 7.8783953382369702, 75.854214480596966, 7.8783953382369702, 75.626319104089816, 7.914858598478105, 74.24071521492715, 8.0151325641411972, 72.900690401065731, 8.1792172352262753, 71.588013032384879, 8.4071126117333392, 70.320914739005275, 8.6897028786021053, 69.090279705867033, 9.0361038508928573, 67.896107932971063, 9.4463155286055667, 66.747515235373612, 9.9203379117402601, 65.635385798021161, 10.449055185236629, 64.550603805846549, 11.041583164155011, 63.511400888974094, 11.69792184849535, 62.517777047403797, 11.734385108736459, 62.463082157041754, 12.244870752112289, 61.752048582339739, 12.81005128584982, 61.041015007636815, 13.41169507982846, 60.320865617875825, 33.32063517148552, 60.931625226914548, 32.463748555818967, 61.496805760651114, 31.1966502624397, 62.381039821499144, 29.993362674482398, 63.256158067287288, 28.863001607007359, 64.122160498012818, 27.796451244954309, 64.979047113680281, 26.80282740338351, 65.826817914286039, 25.882130082294971, 66.665472899831911, 25.02524346662841, 67.495012070317898, 24.232167556383839, 68.315435425743999, 23.5211339816818, 69.126742966108395, 22.873911112401739, 69.938050506472791, 22.29049894854364, 70.731126416719235, 22.071719387096859, 71.05017994382797, 21.378917442515391, 72.16230938118315, 20.777273648536749, 73.301786263717986, 20.275903820221199, 74.450378961312708, 19.856576327448209, 75.626319104089816, 19.537522800338341, 76.820490876986696, 19.300511608770989, 78.042010095064143, 19.16377438286673, 79.28176094326318, 19.11819530756534, 80.539743421581989, 19.11819530756534, 80.813217873390386, 19.200237643107869, 82.144126872192828, 19.37343812925323, 83.420340980632318, 19.656028396122, 84.641860198708855, 20.048008443714139, 85.808684526425168, 20.540262456969401, 86.920813963779437, 21.14190625094804, 87.969132695712688, 21.843824010589799, 88.97187235234378, 22.655131550954959, 89.910801303552944, 22.965069263004551, 90.229854830662589, 23.776376803369718, 90.950004220425399, 24.669726679277399, 91.60634290476537, 25.6542347057879, 92.207986698743298, 26.720785067840978, 92.736703972239411, 27.86937776543656, 93.210726355374391, 29.10912861363499, 93.611822218027555, 30.421805982315671, 93.958223190316858, 31.82564150159919, 94.24081345718696, 33.32063517148552, 94.450477203574337, 37.933237591988501, 94.523403724055242, 57.094680848702382, 94.751299100562392, 55.48118158303236, 95.352942894541229, 54.022651173387182, 95.890775983097228, 52.700857989646209, 96.373914181293003, 51.534033661930032, 96.793241674066849, 50.503946560118102, 97.148758461416037, 49.628828314330967, 97.44958035840591, 48.899563109508392, 97.686591549973855, 48.316150945650293, 97.868907851178847, 47.878591822756732, 97.987413446961909, 46.97612613178876, 98.197077193349287, 45.873112509494568, 98.424972569856436, 44.697172366718121, 98.634636316241995, 43.466537333579993, 98.816952617447896, 42.172091595019879, 98.981037288534026, 40.822950966098063, 99.126890329498565, 39.40999963175426, 99.254511740342423, 37.933237591988501, 99.354785706004805, 37.933237591988501, 105.99109906989088],
     ],

 37: [ [86.301752301847628, 44.906886654869595, 85.344591720517954, 44.186737265106785, 84.433010214489727, 43.402777169922956, 83.557891968702606, 42.555006369316288, 82.737468613277144, 41.634309048227806, 81.962624333153144, 40.649801021718304, 81.224243313270264, 39.601482289785963, 80.540557183749073, 38.489352852430784, 79.902450129529299, 37.30429689459379, 79.300806335550647, 36.055430231334867, 79.20053236988754, 35.836650669889423, 78.717394171692561, 34.697173787352767, 78.279835048799001, 33.548581089757135, 77.887855001206844, 32.363525131920142, 77.541454028916121, 31.169353359023262, 77.249747946987071, 29.956949956005701, 76.994505125299156, 28.717199107807573, 76.78484137891266, 27.459216629488765, 76.629872522887865, 26.173886705989389, 76.511366927104191, 24.879440967429218, 76.438440406621922, 23.557647783686662, 76.420208776501369, 22.217622969826152, 76.420208776501369, 22.071769928860704, 76.447556221682206, 20.704397669819627, 76.520482742164475, 19.355257040898323, 76.648104153008433, 18.042579672215652, 76.812188824093511, 16.748133933656391, 77.030968385540291, 15.490151455336672, 77.286211207228206, 14.25951642220025, 77.596148919277809, 13.056228834242575, 77.95166570662883, 11.880288691464557, 78.352761569281256, 10.731695993869835, 78.808552322295384, 9.6104507414547697, 79.300806335550647, 8.5165529342220907, 79.72013382832364, 7.6414346884339466, 80.358240882543413, 6.4746103607194527, 81.041927012064605, 5.3533651083043878, 81.762076401826945, 4.2959305613112519, 82.536920681950946, 3.3023067197400451, 83.357344037376365, 2.3633777685308814, 84.223346468103216, 1.4882595227427373, 85.125812159071174, 0.66783616731754591, 86.082972740400848, -0.088776482685716473, 97.103993148282441, 0.011497482976665196, 96.064790231410228, 0.093539818521094276, 94.980008239236611, 0.39436171551005827, 93.940805322364398, 0.89573154382469511, 92.96541311091417, 1.6158809335884143, 92.053831604885914, 2.5456940697367827, 91.196944989219347, 3.6851709522716192, 90.914354722350595, 4.1500775203458034, 90.495027229577587, 4.9340376155314516, 90.103047181985445, 5.7818084161372099, 89.747530394634424, 6.7116215522855782, 89.428476867524537, 7.7143612089166709, 89.127654970535218, 8.7809115709696925, 88.872412148847289, 9.9295042685662338, 88.635400957279955, 11.151023486642771, 88.434853025953728, 12.436353410143056, 88.261652539808367, 13.803725669184132, 88.124915313904125, 15.234908633649866, 88.015525533180735, 16.748133933656391, 87.942599012698494, 18.325169939085754, 87.897019937397076, 19.984248280056818, 87.878788307276508, 21.707137326449811, 87.878788307276508, 22.536676496936707, 87.906135752457345, 24.286912988511176, 87.960830642819076, 25.955107144543035, 88.042872978361586, 27.550374780091261, 88.152262759084977, 29.072715895157671, 88.279884169928934, 30.513014674683291, 88.443968841014026, 31.889502748786981, 88.635400957279955, 33.174832672286357, 88.854180518726736, 34.396351890363803, 89.091191710294069, 35.53582877289864, 89.364666162102566, 36.611494950013366, 89.656372244031601, 37.596002976521959, 89.984541586201786, 38.51670029761226, 90.340058373552779, 39.355355283158133, 90.713806791024368, 40.121083748221281, 91.124018468737091, 40.813885692802614, 91.178713359098793, 40.895928028345224, 92.035599974765347, 42.062752356060628, 92.947181480793589, 43.010797122330587, 93.913457877183546, 43.758293957273963, 94.925313348874909, 44.287011230770077, 95.991863710927959, 44.596948942818926, 97.103993148282441, 44.706338723543013, 86.301752301847628, 44.906886654869595],
       [97.031066627800186, 48.525865233801596, 96.611739135027179, 48.525865233801596, 95.408451547069888, 48.443822898259896, 94.205163959112596, 48.279738227173766, 93.010992186215574, 48.033611220545936, 91.816820413318567, 47.687210248254814, 90.631764455481843, 47.258766940421992, 89.446708497645105, 46.739165481985765, 88.261652539808367, 46.128405872947951, 87.085712397031926, 45.426488113305822, 86.301752301847628, 44.906886654869595, 97.103993148282441, 44.706338723543013, 98.179659325395775, 44.615180572939607, 99.273557132629691, 44.323474491012348, 100.30364423444161, 43.812988847635097, 101.2790364458918, 43.092839457873197, 102.18150213685981, 42.163026321723009, 103.01104130734549, 41.032665254248968, 103.1842417934909, 40.750074987379776, 103.6126851013241, 39.984346522316628, 104.0046651489163, 39.154807351830641, 104.36929775132759, 38.252341660862839, 104.706582908558, 37.286065264473109, 105.01652062060769, 36.246862347599745, 105.2899950724161, 35.134732910247294, 105.53612207904381, 33.958792767470186, 105.7549016404905, 32.709926104210354, 105.9463337567565, 31.397248735530411, 106.11041842784159, 30.011644846367744, 106.23803983868549, 28.562230251783149, 106.3383138043486, 27.039889136715828, 106.4112403248309, 25.45373731622567, 106.4568194001323, 23.794658975254606, 106.4750510302528, 22.071769928860704, 106.4659352151926, 20.813787450541895, 106.4294719549515, 19.154709109570831, 106.3565454344692, 17.568557289080672, 106.24715565374581, 16.055331989075057, 106.11953424290191, 14.605917394489552, 105.9463337567565, 13.22942932038768, 105.7549016404905, 11.925867766766714, 105.5178904489232, 10.686116918568587, 105.2626476272353, 9.5192925908522739, 104.96182573024601, 8.41627896855789, 104.63365638807581, 7.3861918667462305, 104.2781396007248, 6.4290312854172953, 103.8861595531326, 5.5447972245692654, 103.46683206035959, 4.724373869144074, 103.01104130734549, 3.9768770342006974, 102.9836938621647, 3.9221821438377447, 102.0994598013172, 2.728010370940865, 101.1787624802287, 1.7526181594921582, 100.221601898899, 0.98688969442810048, 99.218862242267988, 0.43994079081130621, 98.179659325395775, 0.12088726370166114, 97.103993148282441, 0.011497482976665196, 86.082972740400848, -0.088776482685716473, 87.085712397031926, -0.78157842726704985, 87.732935266311983, -1.2009059200399861, 88.890643778967871, -1.8572446043790478, 90.048352291623758, -2.4406567682381137, 91.224292434400198, -2.9237949664338885, 92.409348392236936, -3.3248908290852341, 93.603520165133929, -3.6348285411349934, 94.806807753091235, -3.8536081025822568, 96.028326971169108, -3.9812295134252054, 97.249846189246966, -4.0268085887282723, 97.568899716356853, -4.0268085887282723, 98.808650564555279, -3.9721136983662291, 100.0301697826331, -3.8353764724615758, 101.2152257404698, -3.6165969110152218, 102.382050068186, -3.3340066441460294, 103.5215269507213, -2.9602582266752506, 104.6427722031361, -2.5226991037816333, 105.72755419530969, -2.0030976453435869, 106.7941045573628, -1.4014538513647494, 107.833307474235, -0.72688353690500662, 108.8451629459263, 0.029729113099165261, 109.8387867874971, 0.85926828358333296, 110.7959473688268, 1.7617339745529534, 111.73487632003589, 2.746242001061546, 112.2088987031706, 3.2840750896202735, 112.8925848326918, 4.1409617052859176, 113.5306918869115, 5.0434273962537191, 114.13233568089019, 5.9823563474628827, 114.6792845845072, 6.9668643739732943, 115.189770227883, 7.9969514757849538, 115.6546767959574, 9.0726176528987708, 116.07400428873041, 10.193862905313836, 116.447752706202, 11.351571417970263, 116.7759220483721, 12.554859005927028, 117.0676281303012, 13.803725669184132, 117.3137551369288, 15.098171407746122, 117.50518725319471, 16.438196221605722, 117.6601561092195, 17.814684295709412, 117.7695458899429, 19.236751445113441, 117.8424724104252, 20.704397669819627, 117.8607040405458, 22.217622969826152, 117.8424724104252, 23.548531968627685, 117.7695458899429, 24.870325152368423, 117.6601561092195, 26.164770890928594, 117.49607143813439, 27.450100814427969, 117.29552350680819, 28.708083292746778, 117.04939650018061, 29.947834140944906, 116.7485746031913, 31.169353359023262, 116.4112894459608, 32.363525131920142, 116.028425213429, 33.53946527469725, 115.5999819055957, 34.697173787352767, 115.125959522461, 35.836650669889423, 114.6245896941455, 36.884969401820854, 113.9864826399257, 38.060909544597052, 113.3119123254648, 39.182154797012117, 112.58264712064221, 40.230473528945367, 111.81691865557841, 41.224097370514755, 110.996495300153, 42.163026321723009, 110.13049286942621, 43.029028752451268, 109.21891136339789, 43.840336292816573, 108.2708665971285, 44.596948942818926, 107.2681269404974, 45.280635072342193, 106.5479775507351, 45.718194195234901, 105.3629215928984, 46.383648694634758, 104.16874982000139, 46.948829228373143, 102.9836938621647, 47.431967426568008, 101.78952208926761, 47.823947474160377, 100.6044661314309, 48.133885186209227, 99.410294358533918, 48.3526647476574, 98.225238400697194, 48.480286158500348, 97.031066627800186, 48.525865233801596],
       [37.577720804637472, 96.201577999078836, 26.03709893831979, 95.964566807512711, 27.00337533470972, 95.891640287029986, 28.097273141943621, 95.599934205100908, 29.127360243755561, 95.098564376785362, 30.084520825085239, 94.378414987022552, 30.97787070099292, 93.439486035814298, 31.80740987147863, 92.290893338216847, 32.080884323287108, 91.835102585202549, 32.500211816060101, 91.042026674958834, 32.892191863652251, 90.194255874353075, 33.256824466063541, 89.273558553264593, 33.584993808233719, 88.289050526753272, 33.885815705223052, 87.240731794820931, 34.16840597209179, 86.119486542406776, 34.414532978719421, 84.934430584570691, 34.624196725105918, 83.676448106251883, 34.815628841371847, 82.354654922510235, 34.97059769739667, 80.96905103334575, 35.107334923300897, 79.519636438762063, 35.207608888964018, 77.997295323694743, 35.280535409446259, 76.411143503206404, 35.326114484747677, 74.761180977295226, 35.335230299807961, 73.038291930901323, 35.335230299807961, 72.883323074876898, 35.316998669687401, 71.206013103784244, 35.271419594385982, 69.583398023055452, 35.18937725884345, 68.033709462805746, 35.070871663059762, 66.547831607979788, 34.925018622095251, 65.125764458574849, 34.75181813594989, 63.776623829655364, 34.542154389563393, 62.482178091094283, 34.296027382935762, 61.260658873015927, 34.03166874618757, 60.102950360361319, 33.721731034137953, 59.009052553125912, 33.39356169196779, 57.978965451315162, 33.019813274496187, 57.012689054925431, 32.627833226904052, 56.11022336395672, 32.190274104010491, 55.280684193470734, 31.73448335099636, 54.514955728406676, 30.923175810631221, 53.411942106113202, 30.020710119663249, 52.463897339844152, 29.054433723273291, 51.716400504900776, 28.03346243652166, 51.187683231403753, 26.95779625940833, 50.868629704294108, 25.81831937687301, 50.759239923570931, 36.821108154634032, 50.522228732002986, 37.823847811265097, 51.278841382007158, 38.799240022715338, 52.108380552493145, 39.7472847889847, 53.019962058519923, 40.667982110073233, 54.004470085032153, 41.069077972725687, 54.469376653106337, 41.752764102246893, 55.344494898892663, 42.390871156466659, 56.25607640492035, 42.99251495044529, 57.213236986251104, 43.539463854062262, 58.206860827822311, 44.049949497438057, 59.246063744692947, 44.514856065512468, 60.321729921806764, 44.934183558285469, 61.442975174221829, 45.307931975757057, 62.609799501938141, 45.645217132987511, 63.813087089893997, 45.92780739985627, 65.052837938093944, 46.173934406483909, 66.33816786159332, 46.374482337810122, 67.669076860393943, 46.529451193834909, 69.036449119436838, 46.63884097455832, 70.449400453780981, 46.702651679980271, 71.907930863426373, 46.720883310100838, 73.402924533311307, 46.720883310100838, 74.041031587532416, 46.675304234799448, 75.371940586333039, 46.584146084196611, 76.684617955013891, 46.456524673352668, 77.979063693574062, 46.274208372147001, 79.246161986953666, 46.055428810700221, 80.504144465271565, 45.791070173952022, 81.734779498410717, 45.481132461902433, 82.947182901428278, 45.125615674551391, 84.141354674326067, 44.724519811898972, 85.308179002040561, 44.277844873945128, 86.465887514697897, 43.794706675750149, 87.596248582172848, 43.256873587193489, 88.708378019527117, 42.68257723839568, 89.802275826761615, 42.053585999236191, 90.877942003873613, 41.388131499835559, 91.926260735806864, 40.959688192002289, 92.546136159906382, 40.175728096818013, 93.576223261718042, 39.346188926332282, 94.524268027988001, 38.480186495605437, 95.399386273775235, 37.577720804637472, 96.201577999078836],
       [100.349223309743, 100.00287287921674, 93.931689507304114, 100.00287287921674, 22.71894225637692, -4.0268085887282723, 29.136476058815848, -4.0268085887282723, 100.349223309743, 100.00287287921674],
       [26.25587849976657, 100.00287287921674, 25.563076555185091, 99.993757064155943, 24.341557337107218, 99.902598913553447, 23.129153934089661, 99.729398427408341, 21.925866346132349, 99.46503979066074, 20.73169457323533, 99.127754633430413, 19.537522800338341, 98.699311325595772, 18.361582657561879, 98.179709867160454, 17.185642514785432, 97.587181888243322, 16.018818187069261, 96.903495758720965, 15.089005050920431, 96.27450451956156, 14.13184446959079, 95.545239314739774, 13.22937877862282, 94.75216340449424, 12.363376347895979, 93.895276788827687, 11.54295299247053, 92.965463652679318, 10.75899289728625, 91.980955626167997, 10.02972769246364, 90.932636894235657, 9.3369257478821623, 89.811391641820592, 8.698818693662389, 88.635451499044393, 8.0880590846234668, 87.386584835787289, 7.9422060436589268, 87.040183863495258, 7.46818366052426, 85.891591165899627, 7.0397403526909548, 84.724766838184223, 6.6568761201590974, 83.53971088034632, 6.3195909629286566, 82.336423292388645, 6.018769065939324, 81.114904074311198, 5.7726420593116918, 79.875153226113071, 5.572094127985479, 78.617170747794262, 5.4080094569004009, 77.340956639354772, 5.2986196761769966, 76.046510900794601, 5.2348089707550107, 74.733833532113749, 5.2074615255741881, 73.402924533311307, 5.2074615255741881, 73.202376601987453, 5.2439247858152953, 71.862351788126034, 5.316851306297564, 70.540558604384387, 5.435356902081252, 69.23699705076433, 5.6085573882266138, 67.96078294232484, 5.827336949673394, 66.702800464006032, 6.082579771361309, 65.47216543086688, 6.3925174834108978, 64.25976202784932, 6.7480342707619343, 63.06559025495244, 7.1491301334143591, 61.898765927236127, 7.5958050713682042, 60.750173229641405, 8.0880590846234668, 59.62892797722543, 8.4526916870347577, 58.863199512163192, 9.090798741254531, 57.641680294083926, 9.7653690557154391, 56.493087596489204, 10.47640263041748, 55.408305604314592, 11.23301528042094, 54.396450132625432, 12.035207005725789, 53.448405366352745, 12.882977806332059, 52.573287120567329, 13.767211867179469, 51.752863765141228, 14.68790918826801, 51.005366930198761, 15.66330139971825, 50.330796615738109, 16.501956385264229, 49.7929635271812, 17.623201637678989, 49.182203918140658, 18.762678520214308, 48.644370829584659, 19.920387032870192, 48.18858007657127, 21.114558805767221, 47.814831659099582, 22.326962208784781, 47.532241392230389, 23.566713056983222, 47.322577645843012, 24.824695535302201, 47.204072050060859, 26.110025458802031, 47.158492974758701, 26.565816211816159, 47.167608789820406, 27.81468287507488, 47.231419495242335, 29.036202093152731, 47.368156721145169, 30.230373866049749, 47.586936282593342, 31.39719819376592, 47.887758179581397, 32.536675076301243, 48.261506597053994, 33.648804513655712, 48.708181535008407, 34.733586505829329, 49.236898808502701, 35.791021052822089, 49.838542602483358, 36.821108154634032, 50.522228732002986, 25.81831937687301, 50.759239923570931, 25.508381664823389, 50.768355738631726, 24.223051741323559, 50.950672039835808, 23.083574858788239, 51.379115347670449, 22.071719387096859, 52.062801477190987, 21.388033257575671, 52.682676901291416, 20.604073162391391, 53.566910962137626, 19.893039587689341, 54.560534803708833, 19.264048348529851, 55.663548426003217, 18.71709944491289, 56.875951829019868, 18.252192876838478, 58.18862919770072, 18.243077061778191, 58.243324088062764, 17.987834240090301, 59.145789779029656, 17.75993886358324, 60.121181990481091, 17.55027511719674, 61.169500722414341, 17.36795881599107, 62.272514344708725, 17.203874144905988, 63.439338672424128, 17.058021103941481, 64.679089520622256, 16.9395155081578, 65.982651074242312, 16.839241542494701, 67.350023333286117, 16.766315022012432, 68.781206297749122, 16.711620131650729, 70.276199967635876, 16.684272686469878, 71.844120158004444, 16.666041056349311, 73.47585105379585, 16.675156871409602, 74.733833532113749, 16.702504316590449, 76.511417468868785, 16.766315022012432, 78.206959070081211, 16.848357357554988, 79.811342520691142, 16.957747138278361, 81.333683635759371, 17.1036001792429, 82.755750785161581, 17.267684850327981, 84.095775599023909, 17.459116966593911, 85.353758077342718, 17.677896528040691, 86.511466590000055, 17.924023534668319, 87.587132767112053, 18.197497986476801, 88.580756608684169, 18.49831988346611, 89.474106484590266, 18.81737341057601, 90.285414024955571, 19.172890197927021, 91.005563414718381, 19.555754430458901, 91.643670468936762, 20.08447170395527, 92.409398934001729, 20.977821579862962, 93.494180926176341, 21.907634716011788, 94.387530802084257, 22.88302692746203, 95.080332746664681, 23.894882399153371, 95.572586759920341, 24.952316946146141, 95.864292841849419, 26.03709893831979, 95.964566807512711, 37.577720804637472, 96.201577999078836, 36.629676038368082, 96.921727388841646, 35.636052196797287, 97.568950258120822, 34.605965094985351, 98.143246606920002, 33.5394147329323, 98.635500620174753, 32.427285295577832, 99.05482811294678, 31.269576782921948, 99.392113270178015, 30.075405010024951, 99.665587721986412, 28.844769976886791, 99.847904023192314, 27.568555868447248, 99.966409618976286, 26.25587849976657, 100.00287287921674],
     ],

 38: [ [84.204380019555003, 11.900398830358426, 62.722695368392458, 11.835972184018829, 63.14607047291409, 11.394189466257558, 64.213712040838203, 10.289732671853017, 65.262945995522244, 9.2497025237889829, 66.302976143586235, 8.2464876022058888, 67.333802485030191, 7.2984955203401114, 68.355425019854124, 6.4057262781980171, 69.358639941437971, 5.5589760691545962, 70.352651056401797, 4.7582448932116677, 71.328254558125536, 4.0127365569887843, 72.30385805984929, 3.3132472538663933, 73.261053948332972, 2.6597769838426757, 74.199842223576567, 2.0615295535408222, 75.138630498820177, 1.5185049629590139, 76.059011160823715, 1.021499405475879, 77.025410855927433, 0.5244938479963821, 78.258720943012165, -0.055345969067275291, 79.492031030096911, -0.56155533316905348, 80.716137310561606, -1.0033380509303242, 81.940243591026316, -1.3806941223519971, 83.164349871491012, -1.6844197408127002, 84.379252345335686, -1.9237187129338054, 85.603358625800368, -2.0893872320939408, 86.80905729302502, -2.1906291049153879, 88.02395976686968, -2.227444331395418, 89.008767075213456, -2.2090367181554029, 90.306503808638439, -2.1169986519544182, 91.585832928823365, -1.960533939412926, 92.828346822528147, -1.7396425805327453, 94.052453102992828, -1.4359169620720422, 95.239744156977409, -1.0677646972708317, 96.399423791101881, -0.63518578612911369, 97.531492005366218, -0.1289764220273355, 98.645152606390496, 0.4508633950354124, 99.721997980934631, 1.0951298584368487, 100.7712319356186, 1.8130267748001643, 101.79285447044251, 2.6045541441226305, 102.4647323537051, 3.1843939611862879, 103.27466733626829, 3.9575137172687391, 104.05699089897131, 4.785856313072145, 104.7932954285741, 5.6694217485946865, 105.5111923449368, 6.6082100238390922, 106.1830702281994, 7.602221138801724, 106.8273366916019, 8.6606589001057728, 94.365382528074051, 8.8723464523682196, 93.877580777212174, 8.8815502589877724, 92.662678303367485, 8.9643845185682949, 91.447775829522854, 9.1208492311079681, 90.232873355678166, 9.369352009850445, 89.027174688453542, 9.7098928547911783, 87.812272214608853, 10.124064152692881, 86.606573547384244, 10.630273516794659, 85.400874880159606, 11.228520947097422, 84.204380019555003, 11.900398830358426],
       [107.7016983205053, 19.548762131608783, 107.5084183814845, 18.904495668204618, 107.0574318571028, 17.579147514920805, 106.5236110731407, 16.355041234455712, 105.92536364283841, 15.222973020193422, 105.2534857595759, 14.182942872127569, 104.507977423353, 13.23495079026543, 103.6888386341698, 12.378996774599727, 102.7960693920264, 11.615080825136829, 102.6764199059659, 11.523042758937663, 101.6732049843821, 10.823553455814363, 100.605563416458, 10.2253060255116, 99.473495202193675, 9.7375042746498366, 98.286204148209094, 9.3601482032299828, 97.043690254504341, 9.0932378112493097, 95.727545907839286, 8.9275692920882648, 94.365382528074051, 8.8723464523682196, 106.8273366916019, 8.6606589001057728, 107.4347879285242, 9.7651156945121329, 108.0054239389664, 10.933999135256272, 108.54844852954849, 12.158105415721366, 109.0546578936505, 13.428230729284223, 109.5240520312723, 14.762782689191226, 109.965834749034, 16.152557488815546, 110.36159843369551, 17.59755512816082, 107.7016983205053, 19.548762131608783],
       [28.005936797619089, 50.482756181547302, 26.754219097294278, 49.700432618844388, 25.539316623449619, 48.918109056140565, 24.370433182705138, 48.135785493437652, 23.238364968440781, 47.353461930734738, 22.152315787276621, 46.580342174652287, 21.103081832592579, 45.807222418568927, 20.090663104388678, 45.034102662485566, 19.124263409284961, 44.260982906403115, 18.203882747281419, 43.497066956940216, 17.311113505137989, 42.733151007477318, 16.473567102714782, 41.969235058014419, 15.66363212015167, 41.214522915171074, 14.899716170688739, 40.450606965708175, 14.181819254325969, 39.69589482286483, 13.500737564443369, 38.950386486641946, 12.85647110104088, 38.195674343801329, 12.2582236707386, 37.450166007578446, 11.696791466916441, 36.704657671354653, 11.034117390273879, 35.756665589490694, 10.260997634190909, 34.578578342127003, 9.5431007178281675, 33.400491094760582, 8.8896304478056436, 32.2224038473978, 8.2821792108833279, 31.044316600033198, 7.7391546203012354, 29.866229352666778, 7.2605566760593936, 28.688142105303996, 6.8279777649177333, 27.510054857940304, 6.4598255001163229, 26.331967610574793, 6.1376922684150648, 25.153880363210192, 5.8799856830540866, 23.975793115844681, 5.6867057440333317, 22.797705868480989, 5.539444838112785, 21.619618621116388, 5.4566105785324623, 20.432327567133143, 5.4289991586723536, 19.254240319766723, 5.4474067719124264, 18.379878690863734, 5.530241031492749, 17.11895718391861, 5.6959095506533677, 15.894850903454426, 5.9352085227743032, 14.689152236229347, 6.248137947855497, 13.520268795486118, 6.6346978258969784, 12.369792967980175, 7.0948881568987474, 11.246928560337437, 7.6287089408608031, 10.151675572553359, 8.2453639844031841, 9.0748301980092947, 8.9264456742857874, 8.0348000499443515, 9.6903616237487142, 7.0131775151212423, 10.52790802617195, 6.0283702067772538, 11.42988107493542, 5.0619705116732803, 12.414688383279181, 4.1139784298093218, 12.52513406271961, 4.0219403636092466, 13.417903304863041, 3.2672282207659009, 14.34748777348662, 2.5585351110230476, 15.313887468590339, 1.8958610343797773, 16.317102390174199, 1.2884097974592805, 17.357132538238169, 0.72697759363563819, 18.433977912782321, 0.21156442291430722, 19.556842320426622, -0.24862590808788809, 20.707318147931058, -0.66279720598868153, 21.90381300853565, -1.0309494707908016, 23.127919289000339, -1.343878895871967, 24.398044602565221, -1.6199930944731022, 25.704985142610269, -1.8316806467337301, 27.048740909135439, -2.0065529725152373, 28.429311902140711, -2.1262024585748804, 29.846698121626162, -2.1998329115349406, 31.30089956759176, -2.227444331395418, 31.669051832393169, -2.227444331395418, 32.985196179058221, -2.1906291049153879, 34.29213671910324, -2.1169986519544182, 35.580669645908188, -2.0065529725152373, 36.859998766093099, -1.8500882599737452, 38.130124079658003, -1.6568083209531324, 39.381841779982807, -1.4175093488320272, 40.624355673687568, -1.1413951502308919, 41.857665760772299, -0.81926191853017372, 43.072568234616988, -0.46031346034942544, 44.278266901841612, -0.055345969067275291, 45.474761762446207, 0.38643674869490496, 46.652849009810751, 0.8742384995566681, 46.809313722351327, 0.93866514589717553, 47.757305804214973, 1.3712440570388935, 48.72370549931869, 1.8406381946597321, 49.708512807662487, 2.3468475587624198, 50.702523922626277, 2.9082797625851526, 51.72414645745021, 3.5065271928870061, 52.75497279889418, 4.1415898496688897, 53.795002946958157, 4.8318753461708184, 54.853440708262241, 5.5589760691545962, 55.93028608280639, 6.3228920186184041, 38.72837150996029, 6.4977643443980924, 38.636333443759952, 6.4977643443980924, 37.264966257374681, 6.5437833774985847, 35.93961810408959, 6.6726366701777806, 34.66028898390465, 6.8751204158197652, 33.436182703439947, 7.1604384210404532, 32.248891649455402, 7.5285906858425733, 31.116823435191041, 7.9703734036038441, 30.03077425402688, 8.5041941875660996, 28.999947912582911, 9.1116454244893248, 28.005936797619089, 9.7927271143698817, 27.05794471575544, 10.565846870455061, 26.165175473612042, 11.412597079496663, 25.318425264568759, 12.332977741501054, 24.784604480606731, 12.986448011522953, 24.01148472452374, 14.026478159586986, 23.311995421401061, 15.084915920891945, 22.695340377858681, 16.180168908675114, 22.143111980656581, 17.293829509699208, 21.66451403641474, 18.444305337205151, 21.25954654513319, 19.61318877794838, 20.9282095068119, 20.809683638552997, 20.670502921450922, 22.042993725637643, 20.495630595670239, 23.294711425963214, 20.3851849162298, 24.583244352767906, 20.348369689749688, 25.890184892812613, 20.375981109609789, 27.105087366656335, 20.486426789050199, 28.356805066980996, 20.661299114830879, 29.590115154066552, 20.91900570019186, 30.814221434531646, 21.241138931893119, 32.010716295135353, 21.646106423174668, 33.198007349121326, 22.11550056079648, 34.366890789866375, 22.66772895799858, 35.51736661736868, 23.28438400154096, 36.649434831632789, 23.9746694980436, 37.772299239279164, 24.738585447506551, 38.867552227063243, 24.95027299976735, 39.15287023228484, 25.640558496270021, 40.045639474426935, 26.37686302587284, 40.920001103329923, 27.168390395195871, 41.785158925615178, 28.005936797619089, 42.641112941277242, 28.88950223314248, 43.487863150320663, 29.819086701766061, 44.31620574612316, 30.80389401010985, 45.144548341925656, 31.834720351553809, 45.954483324489956, 32.911565726097933, 46.746010693813332, 34.034430133742262, 47.537538063135798, 35.212517381106778, 48.310657819219159, 36.436623661571481, 49.074573768682058, 37.715952781756421, 49.829285911525403, 28.005936797619089, 50.482756181547302],
       [105.6124342177572, 62.944710345073872, 75.341114244460954, 62.944710345073872, 75.341114244460954, 60.284810231883966, 75.534394183481695, 60.257198812024399, 76.859742336766786, 59.962677000183248, 78.02862577751128, 59.484079055941038, 79.031840699095142, 58.821404979299587, 79.878590908138392, 57.974654770257075, 79.933813747858608, 57.901024317296105, 80.697729697321535, 56.842586555992057, 81.286773321003778, 55.728925954967963, 81.700944618905396, 54.569246320844286, 81.958651204266374, 53.345140040379192, 82.041485463846698, 52.065810920193144, 82.023077850606626, 51.265079744250215, 81.958651204266374, 50.335495275627181, 81.839001718205921, 49.378299387142761, 81.673333199045274, 48.411899692039697, 81.461645646784476, 47.427092383694799, 81.203939061423483, 46.423877462111705, 80.900213442962297, 45.393051120668133, 80.541264984780938, 44.353020972605009, 80.136297493499384, 43.29458321130096, 79.676107162497615, 42.217737836755077, 79.179101605015703, 41.122484848970998, 78.626873207813574, 40.008824247946905, 78.019421970891244, 38.867552227063243, 77.37515550748877, 37.717076399558209, 76.675666204366081, 36.54819295881407, 75.930157868143226, 35.360901904829007, 75.138630498820177, 34.155203237603928, 74.291880289776927, 32.931096957138834, 73.408314854253533, 31.688583063433725, 72.469526579009923, 30.42766155649042, 71.475515464046111, 29.148332436306191, 70.444689122602142, 27.850595702880128, 69.358639941437971, 26.543655162835421, 75.810508382082759, 26.341171417195255, 76.5744243315457, 27.38120156525838, 77.319932667768555, 28.41202790670286, 78.065441003991424, 29.461261861387356, 78.801745533594257, 30.519699622691405, 79.52884625657704, 31.578137383995454, 80.246743172939802, 32.654982758537699, 80.964640089302563, 33.731828133081763, 81.664129392425238, 34.817877314248108, 82.363618695547942, 35.903926495411724, 83.053904192050595, 37.008383289816265, 83.734985881933184, 38.112840084219897, 84.406863765195766, 39.235704491864453, 85.069537841838326, 40.3585688995081, 85.72300811186085, 41.481433307152656, 86.376478381883345, 42.622705328037227, 87.011541038665797, 43.773181155541351, 87.011541038665797, 43.773181155541351, 87.968736927149465, 45.485089186868208, 88.889117589153003, 47.086551538754065, 89.763479218056361, 48.577568211199832, 90.601025620479575, 49.958139204206418, 91.401756796422674, 51.237468324389738, 92.165672745885615, 52.406351765134787, 92.883569662248348, 53.464789526438835, 93.564651352130966, 54.412781608302794, 94.208917815533425, 55.259531817346215, 94.807165245835748, 55.986632540327264, 95.377801256277934, 56.612491390489595, 95.902418233619954, 57.127904561212745, 96.381016177861795, 57.542075859115357, 96.896429348583766, 57.901024317296105, 97.798402397347246, 58.416437488017436, 98.810821125551115, 58.876627819018722, 99.942889339815494, 59.272391503682229, 101.1946070401403, 59.612932348622053, 102.5475666132855, 59.89825035384365, 104.02017567249111, 60.119141712724741, 105.6124342177572, 60.284810231883966, 105.6124342177572, 62.944710345073872],
       [38.507480151079449, 94.955549769558274, 38.010474593597543, 94.596601311375707, 37.025667285253753, 93.814277748672794, 36.105286623250208, 92.99513895948985, 35.249332607586922, 92.139184943826876, 34.448601431643851, 91.246415701683873, 33.703093095421004, 90.316831233059929, 33.022011405538372, 89.341227731336403, 32.396152555375977, 88.328809003131937, 31.834720351553809, 87.288778855067903, 31.328510987451871, 86.202729673904287, 30.877524463070131, 85.079865266259731, 30.500168391648678, 83.910981825514682, 30.16883135332742, 82.714486964911885, 29.901920961346381, 81.471973071204957, 29.690233409085579, 80.20184775764119, 29.542972503165, 78.88570341097693, 29.46013824358468, 77.532743837830822, 29.42332301710454, 76.142969038205592, 29.42332301710454, 75.922077679325412, 29.46013824358468, 74.688767592238946, 29.542972503165, 73.437049891914285, 29.662621989225471, 72.17612838497098, 29.837494315006118, 70.896799264785841, 30.067589480507021, 69.608266337981149, 30.334499872488038, 68.301325797934624, 30.647429297569229, 66.985181451271274, 30.702652137289451, 66.801105318871123, 30.96956252927049, 65.816298010526225, 31.282491954351691, 64.776267862463101, 31.632236605913018, 63.690218681296756, 32.028000290574539, 62.558150467032647, 32.4605792017162, 61.370859413050312, 32.939177145958041, 60.128345519344293, 33.454590316680033, 58.839812592538692, 34.01602252050219, 57.496056826013046, 34.623473757424527, 56.106282026387817, 35.267740220827001, 54.661284387044361, 34.88118034278552, 54.449596834782824, 33.426978896819918, 53.648865658838076, 32.009592677334467, 52.85733828951561, 30.62902168432916, 52.065810920193144, 29.29446972442404, 51.274283550869768, 28.005936797619089, 50.482756181547302, 37.715952781756421, 49.829285911525403, 37.761971814856558, 49.728044038703956, 38.433849698119161, 48.393492078799682, 39.087319968141657, 47.086551538754065, 39.74079023816418, 45.816426225189389, 40.385056701566661, 44.583116138104742, 41.020119358349092, 43.377417470879664, 41.645978208511508, 42.208534030134615, 42.26263325205386, 41.076465815871416, 42.870084488976197, 39.972009021466874, 43.468331919278512, 38.904367453542363, 44.066579349580792, 37.873541112097882, 44.646419166643021, 36.870326190515698, 45.217055177085228, 35.903926495411724, 45.7876911875274, 34.974342026787781, 46.155843452328838, 34.38529840310639, 46.616033783330607, 33.648993873503059, 47.113039340812492, 32.875874117419698, 47.646860124774541, 32.065939134857217, 48.217496135216741, 31.200781312572872, 48.824947372139093, 30.298808263809406, 49.469213835541552, 29.350816181946357, 50.150295525424191, 28.356805066980996, 50.868192441786931, 27.316774918917872, 51.622904584629822, 26.239929544373808, 52.414431953952878, 25.107861330109699, 53.242774549756057, 23.948181695985113, 54.107932372039393, 22.733279222139572, 55.009905420802852, 21.472357715196267, 55.948693696046462, 20.174620981771113, 56.915093391150151, 18.830865215244557, 57.927512119354049, 17.441090415620238, 58.97674607403809, 16.014500389514978, 57.9919387656943, 15.222973020193422, 56.703405838889353, 14.210554291987137, 55.470095751804621, 13.262562210124088, 54.28280469782004, 12.397404387839742, 53.15994029017574, 11.596673211896814, 52.083094915631591, 10.869572488913946, 51.061472380807693, 10.216102218892956, 50.095072685703968, 9.6270585952106558, 49.183895830320459, 9.1116454244893248, 48.318738008037137, 8.669862706726235, 47.518006832094073, 8.301710441925934, 47.48119160561393, 8.2833028286859189, 46.257085325149198, 7.8139086910641709, 45.03297904468451, 7.4089411997820207, 43.799668957599771, 7.0776041614608403, 42.547951257274967, 6.8291013827192728, 41.287029750330127, 6.6450252503191223, 40.007700630145187, 6.534579570877213, 38.72837150996029, 6.4977643443980924, 55.93028608280639, 6.3228920186184041, 57.025539070590582, 7.1328270011799759, 58.139199671614882, 7.9887810168438591, 59.262064079259169, 8.8907540656082347, 60.394132293523541, 9.8295423408517308, 61.553811927647992, 10.805145842575257, 62.722695368392458, 11.835972184018829, 84.204380019555003, 11.900398830358426, 84.121545759974694, 11.955621670080291, 83.274795550931444, 12.480238647422084, 82.418841535268143, 13.060078464483922, 81.535276099744735, 13.713548734505821, 80.633303050981283, 14.422241844247765, 79.712922388977759, 15.204565406950678, 78.774134113734149, 16.032908002754994, 77.816938225250453, 16.934881051519369, 76.832130916906664, 17.892076940001971, 75.838119801942867, 18.913699474826899, 74.825701073738969, 19.999748655991425, 73.794874732295014, 21.15022448349373, 72.745640777610987, 22.355923150718809, 73.48194530721382, 23.294711425963214, 74.264268869916819, 24.307130154166771, 75.046592432619832, 25.319548882371237, 75.810508382082759, 26.341171417195255, 69.358639941437971, 26.543655162835421, 69.054914322976785, 26.957826460737124, 68.327813599994016, 27.951837575700665, 67.609916683631255, 28.955052497284669, 66.882815960648458, 29.967471225489135, 66.164919044285696, 30.979889953692691, 65.456225934542971, 32.001512488514891, 64.738329018180224, 33.041542636580743, 64.029635908437484, 34.072368978025224, 63.320942798694773, 35.121602932706992, 62.612249688952062, 36.18004069401195, 61.912760385829358, 37.238478455315999, 61.20406727608664, 38.3061200232396, 60.504577972963943, 39.382965397783664, 59.805088669841268, 40.459810772327728, 59.114803173338629, 41.555063760112716, 58.415313870215932, 42.650316747896795, 57.725028373713279, 43.754773542301336, 57.034742877210618, 44.86843414332543, 56.353661187328008, 45.991298550969987, 55.66337569082534, 47.114162958613633, 54.982294000942737, 48.246231172877742, 54.301212311060112, 49.387503193763223, 53.620130621177509, 50.537979021267347, 52.939048931294877, 51.688454848770562, 52.26717104803231, 52.85733828951561, 51.595293164769707, 54.026221730260659, 50.923415281507147, 55.204308977624351, 50.251537398244551, 56.391600031609414, 50.987841927847398, 56.768956103030177, 52.451247180433, 57.542075859115357, 53.868633399918451, 58.315195615197808, 55.230796779683679, 59.079111564660707, 56.537737319728699, 59.833823707502233, 57.789455020053509, 60.579332043725117, 47.803324837315152, 61.076337601209161, 47.370745926173491, 62.116367749273195, 46.735683269391039, 63.625792034957158, 46.155843452328838, 65.061585867682879, 45.612818861746753, 66.432953054069912, 45.106609497644797, 67.730689787493247, 44.646419166643021, 68.945592261337879, 44.232247868741432, 70.096068088842912, 43.854891797319993, 71.182117270007438, 43.523554758998721, 72.185332191589623, 43.22903294715757, 73.114916660215385, 42.980530168416628, 73.980074482497912, 42.906899715456341, 74.237781067857213, 42.547951257274967, 75.609148254243337, 42.26263325205386, 76.934496407528968, 42.041741893173018, 78.22302933433275, 41.876073374012378, 79.465543228038769, 41.784035307812019, 80.671241895262028, 41.747220081331903, 81.840125336007986, 41.756423887951911, 82.217481407429659, 41.857665760772299, 83.367957234933783, 42.078557119653169, 84.518433062436998, 42.419097964594471, 85.678112696563403, 42.87928829559624, 86.856199943928004, 43.468331919278512, 88.034287191290787, 44.16782122240118, 89.22157824527585, 44.996163818204373, 90.418073105879557, 45.502373182306307, 91.062339569282813, 46.330715778109493, 91.927497391566249, 47.241892633492988, 92.673005727789132, 48.23590374845682, 93.308068384571925, 49.312749123000962, 93.823481555294165, 50.472428757125407, 94.228449046575406, 51.705738844210138, 94.513767051796094, 53.031086997495237, 94.688639377576692, 54.439269410360652, 94.743862217297647, 38.507480151079449, 94.955549769558274],
       [54.577326509661191, 100.00843960395832, 53.969875272738847, 99.99923579733786, 52.653730926073791, 99.944012957616906, 51.355994192648808, 99.833567278175906, 50.076665072463904, 99.66789875901668, 48.824947372139093, 99.44700740013559, 47.591637285054333, 99.170893201534454, 46.385938617829709, 98.839556163213274, 45.189443757225121, 98.452996285170229, 44.020560316480612, 98.011213567409868, 42.87928829559624, 97.514208009927643, 41.756423887951911, 96.961979612726282, 40.651967093547682, 96.345324569184413, 39.565917912383497, 95.682650492541143, 38.507480151079449, 94.955549769558274, 54.439269410360652, 94.743862217297647, 54.577326509661191, 94.743862217297647, 55.88426704970621, 94.661027957717124, 57.126780943410971, 94.440136598836034, 58.304868190775487, 94.090391947274838, 59.427732598419823, 93.611794003032628, 60.4953741663439, 92.99513895948985, 61.48938528130774, 92.240426816647414, 62.437377363171379, 91.356861381123963, 62.787122014732716, 90.961097696463185, 63.5326303509556, 89.985494194738749, 64.167693007738023, 88.954667853295177, 64.683106178459994, 87.850211058890636, 65.088073669741561, 86.672123811526035, 65.373391674962647, 85.438813724441388, 65.54826400074333, 84.141076991017144, 65.603486840463546, 82.76970980463193, 65.603486840463546, 82.373946119969332, 65.539060194123294, 81.113024613024209, 65.382595481582683, 79.861306912699547, 65.152500316081813, 78.637200632235363, 64.839570891000619, 77.440705771629837, 64.443807206339102, 76.262618524267054, 63.965209262097261, 75.112142696762021, 63.394573251655061, 73.989278289118374, 62.750306788252573, 72.875617688093371, 62.02320606526979, 71.798772313549307, 61.213271082706683, 70.731130745624796, 60.513781779583972, 69.930399569681867, 59.749865830121053, 69.120464587117567, 58.93072704093791, 68.319733411174639, 58.056365412034552, 67.528206041853991, 57.126780943410971, 66.755086285768812, 56.151177441687217, 66.000374142928194, 55.120351100243248, 65.254865806705311, 54.034301919079098, 64.527765083720624, 52.893029898194698, 63.809868167358218, 51.69653503759011, 63.101175057615364, 50.454021143885342, 62.410889561113436, 49.156284410460358, 61.739011677850613, 47.803324837315152, 61.076337601209161, 57.789455020053509, 60.579332043725117, 58.995153687278162, 61.324840379948, 60.14562951478257, 62.051941102931778, 61.240882502566791, 62.779041825914646, 62.290116457250797, 63.496938742277052, 63.284127572214629, 64.214835658640368, 64.222915847458239, 64.923528768382312, 65.115685089601655, 65.61381426488515, 65.953231492024884, 66.31330356800936, 66.735555054727897, 66.994385257890826, 67.47185958433073, 67.66626314115274, 68.152941274213333, 68.338141024414654, 68.778800124375749, 69.000815101057924, 69.331028521577863, 69.645081564461179, 70.140963504140984, 70.666704099285198, 70.868064227123767, 71.715938053968785, 71.512330690526241, 72.792783428512848, 72.092170507588477, 73.897240222918299, 72.58917606507039, 75.029308437182408, 73.012551169592015, 76.198191877924728, 73.353092014533317, 77.385482931910701, 73.620002406514345, 78.600385405756242, 73.813282345535086, 79.842899299460441, 73.932931831595553, 81.113024613024209, 73.969747058075683, 82.410761346451181, 73.969747058075683, 82.650060318569558, 73.905320411735445, 83.957000858616993, 73.75805950581487, 85.22712617218076, 73.527964340313986, 86.451232452645854, 73.215034915232792, 87.64772731325138, 72.810067423951239, 88.798203140753685, 72.313061866469326, 89.92106754840006, 71.742425856027126, 90.997912922943215, 71.070547972764544, 92.047146877626801, 70.325039636541689, 93.050361799210805, 69.48749323411846, 94.025965300935241, 68.567112572114937, 94.955549769558274, 68.511889732394721, 95.01077260927832, 67.591509070391183, 95.811503785221248, 66.625109375287465, 96.538604508204116, 65.612690647083582, 97.192074778226925, 64.563456692399541, 97.781118401909225, 63.468203704615348, 98.305735379251018, 62.326931683730947, 98.756721903632751, 61.148844436366431, 99.134077975054424, 59.924738155901728, 99.44700740013559, 58.65461284233686, 99.695510178877157, 57.338468495671798, 99.870382504656845, 55.97630511590657, 99.971624377477383, 54.577326509661191, 100.00843960395832],
     ],

 39: [ [12.84651454609096, 100.0046605464222, 12.04432282078608, 99.968197286180839, 10.76810871234653, 99.749417724732666, 9.6286318298112121, 99.339206047022344, 8.6167763581198358, 98.719330622921916, 7.7325422972724311, 97.90802308255661, 7.3132148044994381, 97.379305809058678, 6.7936133460633519, 96.458608487971105, 6.3834016683506141, 95.382942310858198, 6.0916955864215927, 94.152307277719956, 5.9184951002762034, 92.757587573497403, 5.8546843948542451, 91.207899013247697, 5.8638002099145288, 90.907077116259643, 5.9002634701556644, 90.123117021074904, 5.9731899906379047, 89.220651330107103, 6.082579771361309, 88.181448413234648, 6.2284328123258197, 87.014624085519245, 6.410749113531466, 85.720178346958164, 6.6295286749782463, 84.288995382495159, 6.8847714966661613, 82.739306822246363, 7.1855933936554939, 81.052881036092913, 7.51376273582565, 79.238833839097424, 11.4062157665663, 57.898710782976195, 14.578519407544629, 57.898710782976195, 18.470972438285258, 79.1659073186147, 18.59859384912923, 79.867825078256828, 18.926763191299379, 81.763914610795837, 19.22758508828872, 83.514151102371216, 19.491943725036919, 85.118534552980236, 19.719839101543979, 86.577064962623808, 19.911271217809912, 87.88974233130557, 20.06624007383471, 89.065682474082678, 20.184745669618401, 90.086653760832633, 20.275903820221199, 90.961772006619867, 20.330598710582908, 91.700153026504267, 20.348830340703469, 92.283565190362424, 20.275903820221199, 93.541547668681233, 20.029776813593571, 94.790414331939246, 19.610449320820582, 95.939007029534878, 19.01792134190222, 96.978209946407333, 18.252192876838478, 97.90802308255661, 17.54115930213646, 98.518782691596243, 16.51107220032452, 99.166005560876329, 15.38982694790977, 99.630912128948694, 14.16830772983192, 99.904386580758, 12.84651454609096, 100.0046605464222],
     ],

 40: [ [45.854880879374008, 102.52148980698985, 45.435553386601008, 102.33917350578577, 44.323423949246539, 101.81045623228874, 43.211294511892071, 101.26350732867195, 42.12651251971846, 100.69832679493538, 41.050846342605134, 100.11491463107632, 39.984295980552048, 99.504155022036684, 38.935977248619572, 98.87516378287819, 37.896774331747373, 98.218825098537309, 36.875803044995713, 97.544254784076657, 35.863947573304358, 96.851452839495323, 34.870323731733549, 96.140419264793309, 33.885815705223052, 95.402038244910727, 32.919539308833087, 94.645425594905646, 31.96237872750342, 93.861465499721817, 31.023449776294321, 93.068389589479011, 30.093636640145519, 92.24796623405291, 29.18205513411726, 91.400195433446243, 28.279589443149291, 90.534193002719803, 27.39535538230189, 89.649958941871773, 26.520237136514741, 88.747493250903972, 25.6542347057879, 87.817680114755603, 24.81557972024191, 86.869635348485644, 23.976924734695931, 85.894243137036028, 23.16561719433076, 84.909735110523798, 22.354309653965629, 83.897879638832819, 21.561233743721061, 82.858676721962183, 20.786389463597029, 81.801242174969047, 20.020660998533291, 80.72557599785614, 19.273164163590138, 79.631678190620732, 18.534783143707241, 78.510432938206577, 17.814633753944921, 77.370956055671741, 17.1036001792429, 76.213247543015314, 16.602230350927361, 75.35636092734876, 15.97323911176786, 74.253347305056195, 15.36247950272892, 73.150333682761811, 14.76995152381056, 72.038204245405723, 14.20477099007303, 70.907843177929863, 13.64870627139581, 69.786597925516617, 13.11998899789941, 68.647121042980871, 12.609503354523611, 67.507644160446034, 12.11724934126835, 66.359051462851312, 11.643226958133649, 65.201342950193975, 11.18743620511952, 64.034518622477663, 10.749877082225961, 62.867694294762259, 10.33966540451325, 61.691754151985151, 9.9385695418608009, 60.506698194149067, 9.5648211243892263, 59.312526421252187, 9.209304337038219, 58.118354648355307, 8.8720191798077508, 56.915067060396723, 8.5529656526978783, 55.702663657380981, 8.2521437557085449, 54.490260254361601, 7.9695534888397779, 53.259625221224269, 7.7051948520915801, 52.028990188085118, 7.46818366052426, 50.78923933988699, 7.240288284017196, 49.549488491689772, 7.0397403526909548, 48.300621828431758, 6.8574240514853102, 47.042639350111131, 6.6933393804002321, 45.775541056733346, 6.5474863394357206, 44.499326948292946, 6.4198649285917488, 43.223112839854366, 6.3195909629286566, 41.937782916354081, 6.2284328123258197, 40.643337177793001, 6.1646221069038338, 39.339775624172034, 6.1099272165421601, 38.036214070551068, 6.082579771361309, 36.723536701872035, 6.0734639563010262, 35.401743518130388, 6.082579771361309, 34.517509457284177, 6.1008114014818773, 33.232179533782983, 6.1463904767832673, 31.955965425344402, 6.2102011822052532, 30.679751316904003, 6.2922435177478064, 29.403537208465423, 6.4016332984711823, 28.127323100025023, 6.5201388942548704, 26.860224806647238, 6.665991935219381, 25.602242328325701, 6.8300766063044591, 24.344259850007802, 7.0123929075101321, 23.086277371688993, 7.2220566538966287, 21.83741070843007, 7.4408362153434089, 20.588544045171147, 7.6869632219710411, 19.339677381913134, 7.9513218587192114, 18.099926533715006, 8.2339121255879775, 16.869291500575855, 8.5438498376375946, 15.638656467439432, 8.8629033647474671, 14.408021434300281, 9.209304337038219, 13.186502216221925, 9.5739369394495082, 11.964982998143569, 9.9568011719813683, 10.743463780067032, 10.357897034633821, 9.5310603770476519, 10.786340342467099, 8.3277727890917959, 11.23301528042094, 7.1153693860751446, 11.69792184849535, 5.9211976131773554, 11.807311629218731, 5.6294915312482772, 12.308681457534281, 4.4170881282307164, 12.8191671009101, 3.2229163553320177, 13.35700018946676, 2.0378603974977523, 13.903949093083719, 0.86192025471882516, 14.46912962682123, -0.29578825793578289, 15.052541790679321, -1.4352651404706194, 15.66330139971825, -2.565626207947389, 16.283176823817449, -3.6777556453007492, 16.921283878037229, -4.780769267595133, 17.56850674731729, -5.8655512597679262, 18.243077061778191, -6.9412174368817432, 18.93587900635967, -7.9986519838748791, 19.646912581061709, -9.0469707158072197, 20.367061970824039, -10.07705781761797, 21.114558805767221, -11.098029104369743, 21.87117145577065, -12.100768761001746, 22.655131550954959, -13.094392602572043, 23.44820746119953, -14.069784814021659, 24.268630816624981, -15.026945395353323, 25.09816998711068, -15.974990161620553, 25.94594078771695, -16.913919112830627, 26.81194321844379, -17.834616433919109, 27.696177279291192, -18.737082124886001, 28.106388957003901, -19.156409617659847, 28.963275572670479, -19.976832973085948, 29.847509633517891, -20.797256328511139, 30.74997532448586, -21.59944805381474, 31.670672645574371, -22.392523964061184, 32.627833226904052, -23.176484059245013, 33.59410962329401, -23.94221252430998, 34.596849279925067, -24.698825174312333, 35.617820566676727, -25.437206194194914, 36.657023483548933, -26.1664713990167, 37.723573845601983, -26.886620788780419, 38.817471652835913, -27.588538548421639, 39.929601090190367, -28.290456308062858, 41.069077972725687, -28.96502662252442, 42.235902300441829, -29.639596936985981, 43.420958258278567, -30.295935621326862, 44.62424584623588, -30.943158490606947, 45.854880879374008, -31.572149729766352, 45.854880879374008, -28.901215917101581, 45.371742681179029, -28.563930759872164, 44.232265798643709, -27.743507404446063, 43.129252176349517, -26.913968233961896, 42.062701814296467, -26.084429063475, 41.032614712484559, -25.245774077930037, 40.03899087091375, -24.39800327732155, 39.081830289584083, -23.550232476716701, 38.161132968495572, -22.693345861050148, 37.276898907648132, -21.827343430322799, 36.429128107041862, -20.961340999597269, 35.626936381737011, -20.077106938749239, 34.852092101612982, -19.192872877901209, 34.113711081730123, -18.308638817054089, 33.512067287751449, -17.561141982110712, 32.700759747386307, -16.512823250179281, 31.925915467262289, -15.455388703185235, 31.18753444737942, -14.388838341133123, 30.476500872677381, -13.322287979079192, 29.801930558216469, -12.237505986906399, 29.154707688936409, -11.152723994732696, 28.543948079897461, -10.049710372438312, 27.96053591603939, -8.9375809350840427, 27.413587012422429, -7.8254514977288636, 26.90310136904662, -6.6950904302548224, 26.511121321454478, -5.7743931091654304, 26.110025458802031, -4.7898850826541093, 25.727161226270169, -3.750682165782564, 25.344296993738311, -2.6659001736097707, 24.979664391326988, -1.5264232910740247, 24.615031788915701, -0.35048314829691662, 24.268630816624981, 0.88015188484041573, 23.922229844334229, 2.1563659932799055, 23.594060502164069, 3.4781591770206433, 23.275006975054168, 4.8455314360644479, 22.955953447944271, 6.258482770406772, 22.655131550954959, 7.7261289951120489, 22.363425469025909, 9.2302384800595974, 22.363425469025909, 9.2393542951185736, 22.15376172263942, 10.39706280777591, 21.9532137913132, 11.554771320432337, 21.761781675047281, 12.730711463206717, 21.579465373841629, 13.924883236106325, 21.406264887696238, 15.119055009002295, 21.24218021661116, 16.331458412019856, 21.08721136058637, 17.552977630097303, 20.950474134682111, 18.783612663236454, 20.81373690877788, 20.032479326493558, 20.695231312994199, 21.290461804813276, 20.57672571721054, 22.55756009819288, 20.476451751547408, 23.842890021693165, 20.38529360094461, 25.128219945191631, 20.30325126540205, 26.431781498812597, 20.221208929859529, 27.744458867494359, 20.157398224437539, 29.075367866294982, 20.111819149136121, 30.415392680156401, 20.06624007383471, 31.764533309077706, 20.029776813593571, 33.122789753058896, 20.002429368412749, 34.499277827162587, 19.993313553352461, 35.884881716325253, 19.984197738292181, 37.279601420548715, 19.984197738292181, 37.863013584406872, 19.993313553352461, 39.18480676814761, 20.020660998533291, 40.497484136829371, 20.057124258774419, 41.810161505509313, 20.102703334075841, 43.11372305912937, 20.16651403949783, 44.408168797688631, 20.239440559980089, 45.711730351309598, 20.321482895522621, 46.997060274809883, 20.421756861185742, 48.282390198311077, 20.531146641909121, 49.558604306750567, 20.649652237692809, 50.834818415190057, 20.786389463597029, 52.111032523628637, 20.93224250456154, 53.369015001948355, 21.08721136058637, 54.63611329532614, 21.260411846731731, 55.884979958585063, 21.44272814793737, 57.133846621843077, 21.634160264203299, 58.382713285102909, 21.843824010589799, 59.622464133301037, 22.062603572036579, 60.853099166439279, 22.29961476360393, 62.08373419957843, 22.536625955171271, 63.314369232714853, 22.791868776859189, 64.535888450792299, 22.88302692746203, 64.936984313446374, 23.202080454571899, 66.340819832729721, 23.539365611802371, 67.717307906833412, 23.894882399153371, 69.066448535754716, 24.268630816624981, 70.397357534556249, 24.660610864217119, 71.69180327311642, 25.070822541929829, 72.958901566495115, 25.490150034702818, 74.207768229753128, 25.93682497265667, 75.420171632770689, 26.39261572567079, 76.614343405666659, 26.866638108805489, 77.772051918323996, 27.358892122060752, 78.911528800858832, 27.86937776543656, 80.014542423153216, 28.398095038932951, 81.090208600267033, 28.945043942549919, 82.147643147259259, 29.510224476287419, 83.177730249071828, 30.084520825085239, 84.171354090643035, 30.68616461906387, 85.146746302091742, 31.2969242281028, 86.085675253301815, 31.834757316659481, 86.869635348485644, 32.59136996666291, 87.917954080417985, 33.37533006184723, 88.929809552109873, 34.177521787152081, 89.92343339368017, 35.016176772698088, 90.880593975009106, 35.873063388364642, 91.810407111160202, 36.757297449212047, 92.712872802127094, 37.659763140180019, 93.578875232852624, 38.598692091389132, 94.417530218399406, 39.555852672718771, 95.237953573826417, 40.540360699229289, 96.012797853949451, 41.552216170920637, 96.769410503952713, 42.591419087792872, 97.498675708776318, 43.657969449845922, 98.191477653356742, 44.742751442019532, 98.856932152756599, 45.854880879374008, 99.495039206975889, 45.854880879374008, 102.52148980698985],
     ],

 41: [ [3.3387194382162591, 102.52235411093716, 3.3387194382162591, 99.495903510923199, 3.885668341833195, 99.122155093450601, 5.0251452243685151, 98.301731738026319, 6.1281588466626991, 97.481308382601128, 7.2038250237760622, 96.651769212116051, 8.2339121255879775, 95.813114226569269, 9.2275359671587864, 94.974459241024306, 10.18469654848843, 94.126688440416729, 11.10539386957697, 93.269801824750175, 11.989627930424369, 92.412915209083621, 12.837398731030669, 91.546912778356273, 13.64870627139581, 90.671794532569038, 14.42355055151981, 89.787560471722827, 15.15281575634242, 88.903326410874797, 15.69976465995938, 88.210524466294373, 16.501956385264229, 87.162205734361123, 17.276800665388262, 86.104771187367987, 18.024297500331411, 85.038220825314966, 18.735331075033461, 83.962554648202968, 19.409901389494362, 82.886888471088241, 20.06624007383471, 81.792990663854653, 20.68611549793394, 80.699092856620155, 21.278643476852299, 79.596079234325771, 21.834708195529512, 78.483949796972411, 22.363425469025909, 77.362704544558255, 22.755405516618051, 76.460238853588635, 23.147385564210229, 75.466615012019247, 23.539365611802371, 74.427412095147702, 23.913114029273942, 73.333514287913204, 24.277746631685229, 72.203153220437343, 24.633263419036268, 71.018097262600349, 24.979664391326988, 69.796578044522903, 25.31694954855746, 68.520363936084323, 25.636003075667329, 67.198570752342675, 25.95505660277723, 65.822082678238985, 26.25587849976657, 64.409131343895751, 26.547584581695592, 62.941485119191384, 26.830174848564351, 61.42825981918395, 26.830174848564351, 61.42825981918395, 27.039838594950851, 60.270551306526613, 27.249502341337351, 59.094611163752234, 27.44093445760328, 57.918671020975125, 27.62325075880895, 56.724499248078246, 27.787335429894028, 55.521211660120571, 27.95142010097911, 54.30880825710301, 28.106388957003901, 53.078173223963859, 28.24312618290816, 51.847538190825617, 28.37986340881239, 50.598671527567603, 28.498369004596071, 49.340689049248795, 28.616874600379731, 48.0735907558701, 28.717148566042852, 46.788260832369815, 28.80830671664566, 45.502930908870439, 28.899464867248501, 44.199369355248564, 28.97239138773077, 42.886691986567712, 29.036202093152731, 41.564898802827884, 29.09089698351443, 40.224873988967374, 29.127360243755561, 38.884849175105046, 29.163823503996699, 37.526592731122946, 29.19117094917755, 36.159220472080051, 29.209402579298089, 34.773616582918294, 29.209402579298089, 33.388012693753808, 29.209402579298089, 32.813716344957356, 29.200286764237831, 31.491923161215709, 29.172939319056979, 30.179245792533948, 29.136476058815848, 28.866568423854005, 29.09089698351443, 27.563006870233949, 29.036202093152731, 26.259445316613892, 28.963275572670479, 24.964999578053721, 28.88123323712793, 23.679669654554345, 28.790075086525089, 22.39433973105406, 28.68068530580172, 21.109009807553775, 28.562179710018029, 19.832795699115195, 28.434558299174089, 18.565697405734682, 28.288705258209578, 17.298599112356897, 28.133736402184748, 16.040616634038088, 27.96965173109967, 14.78263415571837, 27.787335429894028, 13.533767492460356, 27.595903313628099, 12.284900829201433, 27.39535538230189, 11.045149981002396, 27.18569163591539, 9.8145149478641542, 26.95779625940833, 8.5838799147250029, 26.720785067840978, 7.3532448815876705, 26.474658061213351, 6.1317256635093145, 26.38349991061051, 5.721513985798083, 26.064446383500641, 4.3085626514530304, 25.727161226270169, 2.9229587622912732, 25.371644438919159, 1.5647023183082638, 24.997896021447559, 0.24290913456661656, 24.605915973855421, -1.0606524190543496, 24.195704296142711, -2.3368665274929299, 23.776376803369718, -3.5766173756910575, 23.329701865415871, -4.7981365937694136, 22.873911112401739, -5.9831925516045885, 22.399888729267051, -7.1409010642610156, 21.907634716011788, -8.280377946795852, 21.388033257575671, -9.3833915690911454, 20.868431799139589, -10.459057746204962, 20.321482895522621, -11.507376478137303, 19.756302361785121, -12.528347764889077, 19.182006012987301, -13.521971606460284, 18.580362219008659, -14.488248002848195, 17.969602609969741, -15.418061138998382, 17.377074631051361, -16.274947754665845, 16.611346165987641, -17.314150671537391, 15.82738607080333, -18.326006143228369, 15.01607853043819, -19.310514169738781, 14.1774235448922, -20.25855893600783, 13.32053692922562, -21.188372072157108, 12.42718705331794, -22.09083776312491, 11.515605547289679, -22.956840193853168, 10.585792411140879, -23.804610994458017, 9.6195160147509284, -24.615918534824232, 8.6350079882404032, -25.399878630008061, 7.6231525165490552, -26.156491280011323, 6.5930654147371106, -26.885756484834019, 5.5265150526840614, -27.587674244476148, 4.441733060510443, -28.262244558934981, 3.3387194382162591, -28.90035161315609, 3.3387194382162591, -31.571285425819042, 3.8583208966523719, -31.334274234251097, 4.979566149067125, -30.805556960754984, 6.082579771361309, -30.25860805713819, 7.1764775785952111, -29.693427523400715, 8.2521437557085449, -29.110015359541649, 9.3186941177615932, -28.499255750502925, 10.367012849694101, -27.870264511344431, 11.4062157665663, -27.21392582700264, 12.42718705331794, -26.539355512542897, 13.429926709949029, -25.846553567961564, 14.43266636658009, -25.126404178197845, 15.40805857803033, -24.397138973376968, 16.37433497442029, -23.631410508312001, 17.331495555749939, -22.856566228188967, 18.270424506959039, -22.054374502882638, 19.200237643107869, -21.233951147458356, 20.111819149136121, -20.386180346852598, 21.0142848401041, -19.520177916125249, 21.898518900951501, -18.635943855279038, 22.764521331678338, -17.733478164309417, 23.630523762405179, -16.803665028161049, 24.46917874795119, -15.855620261892, 25.298717918436889, -14.880228050440564, 26.119141273862311, -13.886604208871177, 26.921332999167191, -12.874748737180198, 27.714408909411759, -11.835545820306834, 28.489253189535791, -10.787227088375403, 29.254981654599511, -9.7024450962007904, 30.002478489542678, -8.6085472889672019, 30.731743694365289, -7.4873020365512275, 31.461008899187881, -6.34782515401821, 32.16292665882964, -5.1810008263009877, 32.618717411843761, -4.41527236123693, 33.247708651003251, -3.3122587389425462, 33.849352444981918, -2.2092451166490719, 34.441880423900272, -1.0971156792948022, 35.007060957637812, 0.024129573120262648, 35.563125676315032, 1.1544906405961228, 36.091842949811429, 2.284851708070164, 36.602328593187217, 3.4243285906050005, 37.094582606442493, 4.5729212882024513, 37.568604989577182, 5.7306298008570593, 38.015279927531033, 6.8883383135125769, 38.452839050424593, 8.0642784562887755, 38.863050728137303, 9.2402185990658836, 39.26414659078975, 10.425274556901968, 39.637895008261331, 11.610330514739871, 39.993411795612332, 12.804502287636751, 40.3306969528428, 14.016905690654312, 40.649750479952672, 15.220193278611077, 40.950572376941999, 16.441712496690343, 41.233162643810772, 17.663231714765971, 41.488405465498687, 18.902982562965917, 41.734532472126318, 20.13361759610325, 41.953312033573098, 21.382484259363082, 42.153859964899297, 22.640466737680981, 42.33617626610495, 23.898449216000699, 42.500260937190028, 25.165547509380303, 42.646113978154567, 26.432645802759907, 42.77373538899851, 27.717975726258373, 42.883125169721893, 29.003305649758659, 42.965167505264439, 30.297751388318829, 43.038094025746709, 31.601312941938886, 43.083673101048127, 32.913990310618829, 43.11102054622895, 34.22666767929968, 43.120136361289241, 35.548460863042237, 43.11102054622895, 36.505621444371172, 43.092788916108411, 37.800067182931343, 43.047209840807, 39.076281291370833, 42.983399135385007, 40.361611214870209, 42.89224098478217, 41.637825323309698, 42.791967019119078, 42.904923616689302, 42.664345608275113, 44.181137725127883, 42.518492567310602, 45.439120203446691, 42.354407896225517, 46.697102681767319, 42.172091595019879, 47.955085160086128, 41.971543663693673, 49.213067638404937, 41.743648287186602, 50.452818486603064, 41.497521280558963, 51.701685149861987, 41.233162643810772, 52.941435998061024, 40.950572376941999, 54.172071031199266, 40.649750479952672, 55.402706064335689, 40.321581137782509, 56.63334109747484, 39.984295980552048, 57.854860315554106, 39.619663378140757, 59.076379533631552, 39.236799145608899, 60.288782936648204, 38.826587467896189, 61.501186339664855, 38.407259975123168, 62.70447392762344, 37.960585037169317, 63.907761515580205, 37.495678469094912, 65.11104910353788, 37.404520318492111, 65.338944480045029, 36.912266305236841, 66.55134788306259, 36.392664846800727, 67.74551965595856, 35.863947573304358, 68.930575613797373, 35.316998669687401, 70.097399941512776, 34.742702320889613, 71.255108454168294, 34.159290157031514, 72.39458533670313, 33.557646363052868, 73.524946404178081, 32.946886754013953, 74.646191656593146, 32.308779699794172, 75.740089463825825, 31.652441015453832, 76.833987271061233, 30.97787070099292, 77.90965344817414, 30.294184571471732, 78.967087995167276, 29.583150996769689, 80.015406727099617, 28.863001607007359, 81.054609643972071, 28.124620587124468, 82.075580930723845, 27.368007937121039, 83.087436402415733, 26.59316365699701, 84.081060243985121, 25.800087746752439, 85.056452455435647, 24.988780206387268, 86.031844666887082, 24.159241035901569, 86.979889433155222, 23.3114702352953, 87.918818384365295, 22.45458361962875, 88.848631520513663, 21.570349558781349, 89.769328841602146, 21.14190625094804, 90.197772149434059, 20.28501963528149, 91.027311319920955, 19.400785574434082, 91.83861886028717, 18.49831988346611, 92.640810585590771, 17.56850674731729, 93.4247706807746, 16.620461981047921, 94.199614960900362, 15.645069769597679, 94.965343425962601, 14.64233011296659, 95.721956075965863, 13.62135882621496, 96.451221280788559, 12.57304009428247, 97.180486485611254, 11.50648973222939, 97.891520060314178, 10.412591924995491, 98.593437819956307, 9.2913466725807439, 99.277123949476845, 8.1518697900454242, 99.951694263936588, 6.9759296472689982, 100.61714876333826, 5.7908736894322601, 101.26437163261835, 4.57847028641467, 101.90247868683673, 3.3387194382162591, 102.52235411093716],
     ],

 42: [ [35.626936381737011, 70.080032615322125, 35.581357306435592, 69.642473492429417, 35.40815682029023, 68.101900747242325, 35.225840519084592, 66.761875933379997, 35.034408402818627, 65.622399050845161, 34.833860471492422, 64.674354284576111, 34.742702320889613, 64.32795331228408, 34.505691129322258, 63.452835066496846, 34.186637602212357, 62.377168889384848, 33.785541739559932, 61.100954780945358, 33.302403541364953, 59.633308556240991, 32.737223007627449, 57.974230215268108, 32.409053665457272, 56.962374743577129, 32.007957802804839, 55.576770854412644, 31.670672645574371, 54.254977670672815, 31.41542982388648, 52.996995192354916, 31.23311352268081, 51.802823419457127, 31.123723741957431, 50.672462351982176, 31.087260481716299, 49.605911989930064, 31.087260481716299, 49.36890079836121, 31.1966502624397, 47.910370388715819, 31.488356344368729, 46.65238791039701, 31.95326291244314, 45.613184993524555, 32.600485781723201, 44.774530007978683, 32.919539308833087, 44.482823926051424, 33.967858040765577, 43.698863830866685, 35.061755847999478, 43.1336832971283, 36.219464360655373, 42.796398139897065, 37.422751948612671, 42.687008359174797, 37.960585037169317, 42.723471619416159, 39.04536702934297, 43.05164096158569, 40.093685761275452, 43.717095460987366, 41.1055412329668, 44.710719302556754, 41.251394273931339, 44.88391978870186, 41.944196218512808, 45.886659445334772, 42.436450231768049, 46.998788882687222, 42.737272128757382, 48.211192285704783, 42.828430279360219, 49.532985469444611, 42.828430279360219, 49.76088084595267, 42.782851204058801, 50.526609311018547, 42.673461423335389, 51.419959186923734, 42.500260937190028, 52.431814658615622, 42.272365560682971, 53.580407356212163, 41.989775293814198, 54.838389834530972, 41.63425850646319, 56.233109538755343, 41.233162643810772, 57.746334838760959, 40.76825607573636, 59.378065734552365, 40.239538802239963, 61.146533856246606, 40.184843911878261, 61.319734342391712, 39.792863864286119, 62.659759156252221, 39.455578707055679, 63.963320709873187, 39.172988440186913, 65.248650633372563, 38.945093063679849, 66.497517296632395, 38.771892577534487, 67.719036514708932, 38.644271166690523, 68.913208287606722, 38.580460461268558, 70.080032615322125, 35.626936381737011, 70.080032615322125],
       [46.948778686607909, 70.107380060503601, 35.626936381737011, 70.080032615322125, 38.580460461268558, 70.080032615322125, 39.428231261874828, 69.469273006284311, 40.503897438988162, 68.64884965085912, 41.524868725739822, 67.819310480373133, 42.500260937190028, 66.98065549482908, 43.430074073338851, 66.114653064100821, 44.314308134186263, 65.239534818313587, 45.143847304671958, 64.355300757464647, 45.92780739985627, 63.452835066496846, 46.766462385402257, 62.477442855048139, 47.851244377575881, 61.274155267089554, 48.872215664327541, 60.198489089976647, 49.82937624565718, 59.241328508646802, 50.731841936625159, 58.411789338161725, 51.570496922171181, 57.709871578519596, 52.345341202295167, 57.126459414662349, 53.0654905920575, 56.670668661648961, 54.32347307037648, 56.023445792367966, 55.544992288454353, 55.540307594172191, 56.711816616170523, 55.257717327303908, 57.823946053524992, 55.157443361640617, 58.316200066780262, 55.184790806823003, 59.510371839677241, 55.430917813449014, 60.622501277031724, 55.950519271886151, 61.643472563783376, 56.743595182129866, 61.953410275832958, 57.080880339361102, 62.664443850535001, 58.120083256231737, 63.083771343308001, 59.259560138768393, 63.22962438427254, 60.49931098696743, 63.14758204872998, 61.456471568297275, 62.846760151740646, 62.568601005650635, 62.308927063184001, 63.644267182764452, 61.55231441318054, 64.683470099635997, 60.558690571609752, 65.68620975626618, 60.166710524017589, 66.005263283376735, 59.455676949315539, 66.479285666510805, 58.607906148709283, 66.935076419525103, 57.632513937259063, 67.37263554241872, 56.538616130025162, 67.791963035191657, 55.307981096886998, 68.202174712905617, 53.949724652904898, 68.585038945437191, 52.463846798078862, 68.958787362908879, 50.850347532408847, 69.314304150258977, 49.100111040834598, 69.651589307490212, 48.316150945650293, 69.806558163514637, 46.948778686607909, 70.107380060503601],
       [57.823946053524992, 89.834003850955924, 57.814830238464708, 89.834003850955924, 56.593311020386842, 89.751961515414223, 55.390023432429551, 89.496718693724688, 54.186735844472253, 89.068275385891866, 52.992564071575231, 88.466631591913028, 52.381804462536309, 88.074651544323387, 51.661655072773982, 87.527702640703865, 50.868579162529421, 86.844016511184236, 50.00257673180257, 86.032708970817112, 49.045416150472903, 85.075548389488176, 48.015329048660988, 83.990766397315383, 46.903199611306519, 82.760131364176232, 45.718143653469781, 81.401874920194132, 45.380858496239313, 81.028126502722444, 44.496624435391908, 80.08919755151328, 43.585042929363652, 79.186731860544569, 42.646113978154567, 78.329845244878015, 41.670721766704332, 77.500306074392938, 40.667982110073233, 76.725461794269904, 39.637895008261331, 75.977964959325618, 38.580460461268558, 75.276047199684399, 26.948680444348039, 75.121078343660884, 28.25224199796844, 74.774677371368853, 29.491992846166848, 74.400928953897164, 30.695280434124161, 73.999833091245819, 31.834757316659481, 73.562273968352201, 32.928655123893378, 73.097367400277108, 33.967858040765577, 72.605113387021447, 33.785541739559932, 72.532186866539632, 32.59136996666291, 72.049048668344767, 31.388082378705629, 71.602373730391264, 30.175678975688051, 71.183046237617418, 28.954159757610199, 70.80929782014482, 27.73264053953233, 70.462896847854608, 26.492889691333922, 70.143843320745873, 25.24402302807519, 69.870368868936566, 24.934085316025602, 69.806558163514637, 23.129153934089661, 69.414578115923177, 21.52477048347993, 69.049945513509556, 20.102703334075841, 68.703544541220253, 18.881184115997989, 68.384491014110608, 17.851097014186049, 68.092784932180621, 17.02155784370035, 67.810194665312338, 16.38345078948058, 67.564067658683598, 15.90942840634588, 67.345288097239063, 14.68790918826801, 66.688949412897273, 13.63047464127524, 65.968800023137192, 12.72800895030727, 65.175724112891658, 11.980512115364091, 64.318837497225104, 11.70703766355564, 63.935973264691711, 11.02335153403444, 62.750917306854717, 10.60402404126145, 61.602324609259995, 10.4672868153572, 60.49931098696743, 10.48551844547776, 60.079983494193584, 10.749877082225961, 58.922274981538067, 11.32417343102375, 57.837492989364364, 12.199291676810869, 56.81652170261259, 12.873861991271781, 56.260456983935001, 13.93129653826457, 55.649697374896277, 15.107236681041, 55.285064772485384, 16.38345078948058, 55.157443361640617, 16.684272686469878, 55.166559176702322, 17.914907719608038, 55.330643847786632, 19.10907949250506, 55.713508080318206, 20.275903820221199, 56.315151874297044, 20.631420607572242, 56.543047250803284, 21.333338367214001, 57.035301264058944, 22.09906683227771, 57.655176688159372, 22.9377218178237, 58.384441892981158, 23.849303323851959, 59.232212693586007, 24.833811350362481, 60.198489089976647, 25.882130082294971, 61.283271082151259, 27.00337533470972, 62.486558670107115, 28.197547107606741, 63.808351853848762, 28.717148566042852, 64.364416572527261, 29.592266811829969, 65.248650633372563, 30.503848317858228, 66.114653064100821, 31.45189308412759, 66.953308049645784, 32.445516925698399, 67.764615590012909, 33.466488212450031, 68.566807315317419, 34.523922759442833, 69.332535780380567, 35.626936381737011, 70.080032615322125, 46.948778686607909, 70.107380060503601, 45.636101317927228, 70.444665217734837, 44.378118839608248, 70.80929782014482, 43.183947066711227, 71.210393682798895, 42.053585999236191, 71.638836990630807, 40.968804007062573, 72.112859373766696, 39.947832720310942, 72.605113387021447, 40.485665808867587, 72.833008763528596, 41.53398454080007, 73.243220441240737, 42.636998163094283, 73.635200488834926, 43.812938305870709, 74.01806472136559, 45.052689154069149, 74.391813138836369, 46.365366522749831, 74.747329926188286, 47.732738781792222, 75.084615083418612, 49.173037561316839, 75.421900240648029, 50.987084758313067, 75.832111918361989, 52.682626359525642, 76.251439411134925, 54.223199104713387, 76.670766903906951, 55.636150439057189, 77.090094396679888, 56.894132917376169, 77.509421889453733, 58.015378169790921, 77.92874938222667, 58.990770381241163, 78.348076874999606, 59.829425366787149, 78.767404367771633, 60.522227311368617, 79.186731860544569, 61.069176214985561, 79.596943538259438, 61.497619522818837, 79.998039400909875, 62.345390323425143, 81.000779057542786, 62.956149932464058, 82.058213604534103, 63.320782534875349, 83.179458856950077, 63.448403945719321, 84.355398999726276, 63.421056500538469, 84.929695348523637, 63.165813678850547, 86.132982936481312, 62.646212220414441, 87.245112373834672, 61.862252125230157, 88.247852030467584, 61.324419036673483, 88.712758598540859, 60.266984489680709, 89.332634022641287, 59.100160161964538, 89.715498255171951, 57.823946053524992, 89.834003850955924],
       [15.87296514610474, 89.979856891919553, 15.435406023211179, 89.961625261799782, 14.232118435253881, 89.724614070232747, 13.129104812959691, 89.205012611797429, 12.12636515632863, 88.393705071430304, 11.87112233464072, 88.129346434681793, 11.09627805451669, 87.071911887689566, 10.622255671381989, 85.959782450336206, 10.4672868153572, 84.792958122618984, 10.50375007559833, 84.109271993098446, 10.731645452105401, 82.960679295502814, 11.16008875993867, 81.875897303330021, 11.807311629218731, 80.864041831636314, 12.655082429825001, 79.906881250307379, 13.71251697681779, 79.022647189459349, 13.730748606938359, 79.013531374400372, 14.277697510555299, 78.676246217170046, 14.99784690031762, 78.320729429819039, 15.88208096116503, 77.965212642467122, 16.93039969309751, 77.600580040057139, 18.142803096115099, 77.226831622585451, 19.52840698527805, 76.843967390052057, 21.078095545526079, 76.451987342459688, 22.791868776859189, 76.041775664747547, 24.669726679277399, 75.631563987036316, 25.59953981542623, 75.4401318707678, 26.948680444348039, 75.121078343660884, 38.580460461268558, 75.276047199684399, 35.626936381737011, 75.276047199684399, 35.17114562872289, 75.55863746655541, 34.204869232332932, 76.214976150892653, 33.238592835942967, 76.926009725593758, 32.281432254613321, 77.691738190659635, 31.333387488343931, 78.521277361144712, 30.37622690701426, 79.405511421993651, 29.428182140744902, 80.353556188261791, 28.489253189535791, 81.356295844892884, 27.550324238326681, 82.41373039188602, 27.486513532904691, 82.49577272742772, 26.39261572567079, 83.708176130446191, 25.344296993738311, 84.811189752738755, 24.359788967227789, 85.7865819641911, 23.420860016018679, 86.634352764796859, 22.536625955171271, 87.372733784681259, 21.707086784685568, 87.983493393719982, 20.92312668950126, 88.466631591913028, 20.667883867813369, 88.612484632879386, 19.419017204554649, 89.214128426856405, 18.206613801537081, 89.642571734691046, 17.02155784370035, 89.897814556377853, 15.87296514610474, 89.979856891919553],
       [37.286014722708423, 102.52321841486901, 36.100958764871713, 102.41382863414583, 34.943250252215819, 102.05831184679482, 33.894931520283343, 101.4475522377561, 32.956002569074229, 100.58154980702966, 32.363474590155853, 99.815821341963783, 31.834757316659481, 98.813081685332691, 31.461008899187881, 97.655373172678082, 31.23311352268081, 96.342695803997231, 31.160187002198569, 94.884165394351839, 31.18753444737942, 94.236942525070845, 31.2969242281028, 93.361824279286338, 31.479240529308441, 92.34996880759445, 31.752714981116931, 91.192260294938023, 32.099115953407683, 89.897814556377853, 32.518443446180669, 88.457515776854052, 33.019813274496187, 86.871363956363894, 33.603225438354293, 85.148474909969082, 33.986089670886152, 84.018113842494131, 34.359838088357719, 82.778362994296913, 34.688007430527911, 81.52949633103799, 34.961481882336393, 80.289745482839862, 35.198493073903727, 79.040878819580939, 35.38992519016967, 77.782896341261221, 35.52666241607389, 76.534029678004117, 35.626936381737011, 75.276047199684399, 38.580460461268558, 75.276047199684399, 38.653386981750799, 75.977964959325618, 38.799240022715338, 77.14478928704284, 38.981556323920991, 78.338961059938811, 39.209451700428048, 79.551364462957281, 39.473810337176253, 80.800231126216204, 39.783748049225842, 82.067329419594898, 40.139264836576857, 83.352659343097002, 40.531244884169013, 84.674452526836831, 40.959688192002289, 86.01447734069734, 41.07819378778597, 86.379109943107323, 41.543100355860361, 87.910566873237258, 41.935080403452517, 89.332634022641287, 42.254133930562404, 90.663543021440091, 42.509376752250311, 91.903293869640038, 42.691693053455957, 93.042770752174874, 42.791967019119078, 94.08197366904642, 42.828430279360219, 95.030018435316379, 42.791967019119078, 96.078337167248719, 42.609650717913439, 97.427477796171843, 42.281481375743247, 98.630765384128608, 41.807458992608552, 99.679084116060949, 41.17846775344907, 100.58154980702966, 40.585939774530708, 101.19230941606838, 39.574084302839339, 101.93069043595096, 38.471070680545161, 102.37736537390356, 37.286014722708423, 102.52321841486901],
     ],

 43: [ [44.341655579367107, 87.893199547046606, 38.580460461268558, 87.893199547046606, 38.580460461268558, 52.058930545075782, 2.6823807538759179, 52.058930545075782, 2.6823807538759179, 46.151882386013312, 38.580460461268558, 46.151882386013312, 38.580460461268558, 10.171760343078859, 44.341655579367107, 10.171760343078859, 44.341655579367107, 46.151882386013312, 80.385588327724264, 46.151882386013312, 80.385588327724264, 52.058930545075782, 44.341655579367107, 52.058930545075782, 44.341655579367107, 87.893199547046606],
     ],

 44: [ [10.03884350752392, 0.081476434617798077, 10.877498493069909, -0.63867295514501166, 11.898469779821561, -1.2403167491211207, 13.0288308472966, -1.6687600569566712, 14.286813325615579, -1.9240028786443872, 15.66330139971825, -2.0151610292468831, 15.96412329670758, -2.0060452141860878, 17.212989959966279, -1.8146130979203008, 18.398045917803021, -1.3679381599686167, 19.929502847930479, -0.58397806478205894, 21.10544299070693, -0.082608236467422103, 21.86205564071037, 0.081476434617798077, 10.03884350752392, 0.081476434617798077],
       [17.24945322020741, 14.420653524442969, 16.237597748516041, 14.384190264201607, 14.97961527019706, 14.192758147937639, 13.79455931236032, 13.846357175645608, 12.69154569006613, 13.344987347329152, 11.652342773193929, 12.697764478050885, 10.68606637680398, 11.90468856780717, 10.21204399366928, 11.430666184669462, 9.4007364533041482, 10.44615815815996, 8.7626293990843749, 9.3978394262267102, 8.306838646070247, 8.2765941738125548, 8.0424800093220483, 7.1006540310354467, 7.9513218587192114, 5.842671552716638, 7.9513218587192114, 5.7788608472947089, 8.0333641942617646, 4.3932569581302232, 8.2886070159496796, 3.1261586647524382, 8.7079345087226727, 1.9866817822166922, 9.2913466725807439, 0.96571049546582799, 10.03884350752392, 0.081476434617798077, 21.86205564071037, 0.081476434617798077, 21.86205564071037, 0.081476434617798077, 22.864795297341459, -0.57486224972308264, 23.338817680476161, -1.5776019063541753, 23.51201816662152, -2.8811634599733225, 23.51201816662152, -3.373417473228983, 23.429975831078959, -4.5858208762474533, 23.256775344933601, -5.7891084642033093, 22.983300893125119, -6.9650486069804174, 22.627784105774111, -8.1409887497575255, 22.181109167820271, -9.2895814473522478, 21.64327607926359, -10.429058329886175, 21.0142848401041, -11.559419397361125, 20.29413545034177, -12.671548834716305, 19.482827909976631, -13.765446641951712, 19.400785574434082, -13.856604792554208, 18.635057109370361, -14.768186298582805, 17.805517938884631, -15.634188729309244, 16.921283878037229, -16.454612084733526, 15.991470741888399, -17.229456364859288, 15.006962715377909, -17.958721569681074, 13.95864398344542, -18.642407699202522, 12.864746176211501, -19.289630568482607, 11.71615347861592, -19.88215854739974, 10.51286589065862, -20.43822326607733, 9.2548834123396375, -20.939593094393786, 7.9513218587192114, -21.40449966246706, 7.9513218587192114, -24.576803303445558, 8.5256182075170273, -24.385371187179771, 9.9294537268005456, -23.884001358863316, 11.28771017078261, -23.364399900428907, 12.59127172440304, -22.817450996810294, 13.840138387661741, -22.252270463073728, 15.052541790679321, -21.659742484158414, 16.201134488274931, -21.048982875117872, 17.304148110569109, -20.410875820896763, 18.352466842501599, -19.754537136557701, 19.35520649913266, -19.070851007036254, 20.312367080462341, -18.359817432334239, 21.205716956370029, -17.630552227510634, 22.062603572036579, -16.883055392567258, 22.864795297341459, -16.108211112441495, 23.612292132284612, -15.306019387138804, 24.305094076866091, -14.485596031714522, 25.061706726869549, -13.510203820263996, 25.81831937687301, -12.416306013028588, 26.502005506394202, -11.313292390734205, 27.121880930493401, -10.201162953380845, 27.65971401905006, -9.0708018859077129, 28.124620587124468, -7.9222091883093526, 28.525716449776919, -6.7553848605930398, 28.853885791947079, -5.5794447178177506, 29.10001279857471, -4.3852729449208709, 29.282329099780348, -3.181985356963196, 29.39171888050376, -1.9513503238249541, 29.428182140744902, -0.71159947562591697, 29.419066325684611, -0.037029161165264668, 29.337023990142061, 1.3485747279974021, 29.172939319056979, 2.6794837267971161, 28.935928127489628, 3.9465820201785391, 28.607758785319451, 5.1589854231951904, 28.197547107606741, 6.3075781207917316, 27.705293094351472, 7.4014759280253202, 27.140112560613971, 8.4315630298387987, 26.483773876273631, 9.3978394262267102, 25.754508671451021, 10.318536747316102, 24.952316946146141, 11.129844287681408, 23.94957728951508, 12.004962533466824, 22.919490187703161, 12.743343553351224, 21.852939825650079, 13.344987347329152, 20.749926203355901, 13.819009730463222, 19.610449320820582, 14.156294887694457, 18.443624993104429, 14.35684281902104, 17.24945322020741, 14.420653524442969],
     ],

 45: [ [6.0005374358187558, 38.578427738122627, 43.26598940225378, 38.578427738122627, 43.26598940225378, 27.694144556146057, 6.0005374358187558, 27.694144556146057, 6.0005374358187558, 38.578427738122627, 6.0005374358187558, 38.578427738122627],
     ],

 46: [ [18.470972438279318, 13.993938824485667, 19.765418176839368, 13.902780673881352, 20.986937394917192, 13.629306222073865, 22.108182647331908, 13.182631284118543, 23.15650137926437, 12.544524229899253, 24.113661960594019, 11.733216689533947, 24.168356850955721, 11.687637614233608, 24.988780206381112, 10.703129587722287, 25.63600307566114, 9.6548108557908563, 26.091793828675272, 8.5244497883177246, 26.374384095544009, 7.3211622003564116, 26.474658061207119, 6.0449480919178313, 26.474658061207119, 5.9902532015566976, 26.383499910604289, 4.704923278057322, 26.100909643735552, 3.501635690099647, 25.64511889072142, 2.3712746226246963, 24.997896021441392, 1.3320717057522415, 24.168356850955721, 0.36579530936251103, 23.192964639505501, -0.48197549124597572, 22.14464590757305, -1.1383141755813995, 21.02340065515833, -1.6123365587191074, 19.838344697321642, -1.9040426406481856, 18.571246403942411, -2.0134324213686341, 18.470972438279318, -2.0134324213686341, 17.1947583298398, -1.9222742707679572, 15.99147074188255, -1.6396840038996743, 14.87934130452811, -1.1656616207637853, 13.840138387655941, -0.50932293642472359, 12.88297780632629, 0.33844786418376316, 12.84651454608516, 0.36579530936251103, 11.998743745478921, 1.3229558906932652, 11.333289246078319, 2.3621588075639011, 10.859266862943629, 3.4742882449190802, 10.567560781014601, 4.6684600178177789, 10.46728681535151, 5.9446741262563592, 10.46728681535151, 5.9902532015566976, 10.558444965954321, 7.2846989401168685, 10.84103523282309, 8.4879865280745435, 11.29682598583719, 9.6092317804886989, 11.944048855117209, 10.648434697361154, 12.76447221054263, 11.605595278690089, 12.84651454608516, 11.687637614233608, 13.81279094247509, 12.517176784718686, 14.85199385934726, 13.164399653998771, 15.98235492682227, 13.620190407013069, 17.185642514779509, 13.902780673881352, 18.470972438279318, 13.993938824485667, 18.470972438279318, 13.993938824485667, 18.470972438279318, 13.993938824485667],
     ],

 47: [ [41.395634028449869, 102.52584524096528, 6.0056902873658373, -2.0112439407494094, 0.23389517237856691, -2.0112439407494094, 35.623838913462627, 102.52584524096528, 41.395634028449869, 102.52584524096528, 41.395634028449869, 102.52584524096528],
     ],

 48: [ [23.806233131383621, 95.093455038146203, 23.447514385272981, 94.848015896070137, 22.503517684981819, 94.13057840385045, 21.587840885699411, 93.375381043617381, 20.681604053419889, 92.572983848369404, 19.813127089152019, 91.732826785111683, 18.954090091887071, 90.854909853838763, 18.123372995630842, 89.939233054556098, 17.311535833380429, 88.976356420262164, 16.518578605135861, 87.975719917949391, 15.75394127790001, 86.937323547630513, 15.00818388467, 85.851727342296726, 14.2813064254458, 84.728371268951378, 13.582748867230359, 83.567255327590829, 12.903071243020699, 82.368379518222355, 12.24227355281691, 81.122303873837154, 11.600355796618899, 79.838468361440391, 10.986757941429641, 78.507433014030539, 10.401479987249139, 77.148077765610651, 10.22212061419383, 76.713839283476773, 9.7878821320598917, 75.618803111139641, 9.3725235839317662, 74.504887004797638, 8.9854849368123961, 73.362650997443779, 8.6173262236988393, 72.210975023088395, 8.2586074775881997, 71.040419114726319, 7.9282086324862879, 69.850983272361191, 7.6166897213902161, 68.642667495987553, 7.3240507442999521, 67.415471785609043, 7.0502917012155271, 66.169396141225661, 6.8048525591398032, 64.904440562835589, 6.568853384067026, 63.620605050438826, 6.3611741100029766, 62.327329571040536, 6.1723747699447378, 61.005734190632211, 5.993015396889418, 59.665258876220832, 5.8419759248428269, 58.315343594802471, 5.7192563538049654, 56.937108412377711, 5.6059767497700497, 55.549433262949606, 5.511577079740916, 54.133438212511464, 5.4454973107205404, 52.708003195071797, 5.3982974757059727, 51.25424827662755, 5.360537607694325, 49.791053391174501, 5.3510976406914352, 48.30897857171658, 5.360537607694325, 47.449941574450349, 5.3794175417001631, 45.986746689002757, 5.4266173767147299, 44.551871704557925, 5.4926971457351073, 43.126436687118257, 5.5870968157642116, 41.710441636681935, 5.7003764197991549, 40.32276648725383, 5.8325359578399079, 38.944531304827251, 5.993015396889418, 37.585176056409182, 6.1723747699447378, 36.235260774992639, 6.3706140770058681, 34.904225427582787, 6.5971732850757538, 33.592070014179626, 6.842612427151451, 32.298794534777699, 7.1163714702359044, 31.014959022382754, 7.4090104473261666, 29.750003443994501, 7.7205293584222403, 28.503927799607482, 8.0509282035241512, 27.276732089227153, 8.4096469496347908, 26.058976345853807, 8.78724562975124, 24.860100536483515, 9.1931642108764464, 23.670664694116567, 9.6179627260074625, 22.509548752759656, 10.06164117514432, 21.357872778402452, 10.5336395252899, 20.215636771052232, 11.02451780944129, 19.101720664708409, 11.534276027598519, 17.997244525369751, 12.07235414676448, 16.911648320032327, 12.62931219993628, 15.835492081700068, 13.20515018711388, 14.787655744379663, 13.81874804230314, 13.739819407053801, 14.62114523755063, 12.418224026647295, 15.442422366803941, 11.162708415258749, 16.273139463060161, 9.9638326058902749, 17.132176460325109, 8.8215965985382354, 18.000653424592979, 7.7454403602059756, 18.888010322866691, 6.7164839568886237, 19.78480718814329, 5.7536073225910513, 20.709923954428621, 4.8473704903117323, 21.644480687716872, 4.0072134270521929, 22.597917355010949, 3.2142561988075613, 23.560793989307928, 2.4873787395827094, 36.710668024363812, 2.8177775846852455, 35.568432017011489, 2.8744173867034988, 34.463955877670841, 3.0348968257530942, 33.406679573344732, 3.3086558688373771, 32.387163137030299, 3.6956945159545285, 31.405406568727489, 4.18657280010666, 30.470849835439239, 4.790730688293479, 29.57405297016264, 5.4987282135116402, 28.71501597289766, 6.3200053427663079, 27.90317881064728, 7.2545620760538441, 27.129101516408511, 8.2929584463745414, 26.402224057184309, 9.4446344207299262, 25.713106465971759, 10.709589999121818, 25.061748742770892, 12.078385214541413, 24.45759085458452, 13.560460033999334, 24.278231481529211, 14.004138483134739, 23.900632801412758, 15.03309488645391, 23.541914055302119, 16.080931223776133, 23.202075243197282, 17.147647495105048, 22.871676398095371, 18.242683667442179, 22.550717519996379, 19.356599773787821, 22.2486385759032, 20.49883578113986, 21.96543956581586, 21.659951722496771, 21.70112048973435, 22.849387564863719, 21.446241380655731, 24.057703341237357, 21.210242205582929, 25.284899051615866, 20.983682997513071, 26.540414663004412, 20.776003723449001, 27.814810208396011, 20.587204383390759, 29.117525654797646, 20.407845010335429, 30.439121035202334, 20.247365571285961, 31.789036316620695, 20.105766066242278, 33.157831532045748, 19.973606528201501, 34.545506681472034, 19.860326924166579, 35.961501731908356, 19.756487287134561, 37.396376716351369, 19.67152758410835, 38.8595716018026, 19.60544781508797, 40.341646421258702, 19.548808013070481, 41.85204114172484, 19.51104814505884, 43.381315796197669, 19.49216821105302, 44.92947038467355, 19.482728244050111, 46.505944874159468, 19.482728244050111, 46.760823983238879, 19.49216821105302, 48.063539429642333, 19.501608178055939, 49.366254876042149, 19.529928079064671, 50.668970322443784, 19.567687947076319, 51.971685768845418, 19.614887782090861, 53.283841182250399, 19.67152758410835, 54.595996595655379, 19.747047320131639, 55.908152009060359, 19.822567056154941, 57.220307422465339, 19.90752675918112, 58.541902802873665, 20.011366396213148, 59.854058216276826, 20.115206033245201, 61.175653596685152, 20.237925604283038, 62.497248977093477, 20.37008514232382, 63.828284324503329, 20.502244680364569, 65.149879704911655, 20.65328415241116, 66.480915052321507, 20.813763591460638, 67.81195039972954, 20.983682997513071, 69.14298574714303, 21.163042370568391, 70.474021094552882, 21.351841710626601, 71.814496408966079, 21.49344121567027, 72.749053142255434, 21.76720025875473, 74.334967598742878, 22.069279202847881, 75.873682220220871, 22.390238080946901, 77.346317072671809, 22.739516860054621, 78.762312123111769, 23.117115540171071, 80.121667371529838, 23.523034121296281, 81.424382817929654, 23.957272603430209, 82.670458462314855, 24.41983098657288, 83.869334271685148, 24.910709270724301, 85.002130312035661, 25.429907455884418, 86.078286550366101, 25.967985575050381, 87.107242953683453, 26.543823562227988, 88.070119587981026, 27.13854148341143, 88.976356420262164, 27.761579305603611, 89.835393417524756, 28.41293702880451, 90.628350645769387, 29.262534059066539, 91.534587478048707, 30.282050495381, 92.459704244334716, 31.339326799707109, 93.243221505574184, 32.434362972044838, 93.885139261774384, 33.557719045391323, 94.385457512928042, 34.718834986749457, 94.744176259038795, 35.908270829116319, 94.951855533103299, 37.135466539494828, 95.027375269126424, 23.806233131383621, 95.093455038146203],
       [37.210986275518131, 99.785118638594213, 37.097706671483181, 99.785118638594213, 35.851631027098861, 99.737918803579305, 34.614995349717432, 99.615199232539453, 33.387799639338922, 99.416959925480114, 32.170043895963332, 99.143200882395831, 30.952288152587709, 98.793922103288423, 29.743972376215041, 98.36912358815789, 28.54509656684526, 97.868805337000595, 27.346220757475479, 97.292967349825631, 26.15678491510862, 96.632169659622377, 24.97678903974467, 95.905292200397525, 23.806233131383621, 95.093455038146203, 37.135466539494828, 95.027375269126424, 38.400422117884993, 94.97073546710817, 39.71257753128971, 94.772496160048831, 40.95865317567403, 94.451537281949641, 42.129209084035082, 93.988978898805726, 43.243125190378649, 93.384821010618907, 44.272081593696001, 92.648503584392529, 44.649680273812479, 92.318104739289993, 45.404877634045413, 91.57234734605845, 46.131755093269597, 90.73219028280073, 46.839752618487957, 89.816513483518065, 47.50999027569469, 88.806437014207404, 48.1613479988956, 87.701960874866927, 48.774945854084848, 86.521964999503325, 49.369663775268272, 85.247569454109907, 49.93606179544296, 83.878774238686674, 50.464699947606022, 82.434459287242134, 50.974458165763259, 80.895744665767779, 51.0971777368011, 80.489826084642118, 51.408696647897187, 79.423109813313204, 51.701335624987429, 78.328073640976072, 51.984534635074802, 77.21415753463225, 52.248853711156308, 76.07192152728021, 52.503732820234923, 74.91080558592148, 52.73029202830481, 73.721369743554533, 52.956851236374689, 72.513053967182714, 53.155090543435819, 71.276418289800858, 53.343889883494057, 70.011462711410786, 53.523249256549377, 68.727627199014023, 53.683728695598887, 67.424911752612388, 53.825328200642559, 66.084436438197372, 53.9480477716804, 64.734521156782648, 54.061327375715337, 63.346846007354543, 54.165167012747368, 61.940290923921566, 54.250126715773582, 60.514855906481898, 54.316206484793959, 59.051661021030668, 54.372846286811409, 57.579026168576092, 54.410606154823071, 56.0780714151133, 54.429486088828902, 54.548796760640471, 54.438926055831821, 52.991202205161244, 54.429486088828902, 51.877286098817422, 54.420046121825983, 50.215851906306852, 54.401166187820174, 48.582737614800863, 54.372846286811409, 46.987383191308254, 54.335086418799797, 45.410908701822336, 54.28788658378523, 43.862754113344636, 54.231246781767737, 42.352359392880317, 54.165167012747368, 40.86084460641905, 54.089647276724072, 39.39764972096782, 54.004687573697893, 37.972214703528152, 53.910287903668753, 36.565659620095175, 53.806448266636721, 35.196864404671942, 53.683728695598887, 33.856389090258745, 53.561009124561032, 32.534793709850419, 53.428849586520279, 31.250958197453656, 53.296690048479498, 29.986002619065403, 53.145650576432907, 28.758806908686893, 52.985171137383418, 27.5599310993166, 52.815251731331017, 26.379935223952998, 52.635892358275697, 25.23769921659914, 52.447093018217458, 24.123783110255317, 52.248853711156308, 23.038186904919712, 52.041174437092252, 21.980910600597781, 51.824055196025292, 20.942514230275265, 51.597495987955398, 19.94187772796613, 51.361496812882621, 18.96956112666885, 51.125497637809822, 18.02556442637615, 50.96501819876034, 17.468606373204238, 50.521339749623479, 15.9582116527381, 50.030461465472087, 14.532776635300252, 49.511263280311937, 13.201741287886762, 48.944865260137249, 11.95566564350338, 48.34070737195092, 10.794549702146469, 47.708229582755827, 9.7278334308157355, 47.028551958546203, 8.7555168295166368, 46.320554433327843, 7.8587199642406631, 45.56535707309488, 7.0657627359978505, 44.781839811853231, 6.348325243774525, 43.658483738506739, 5.4609683455000777, 42.469047896139877, 4.6491311832505744, 41.289052020775941, 3.9883334930491401, 40.1279360794178, 3.4785752748884988, 38.9762601050626, 3.1104165617744002, 37.834024097710298, 2.8932973207083705, 36.710668024363812, 2.8177775846852455, 23.560793989307928, 2.4873787395827094, 24.551990524613661, 1.8077011153764033, 25.552627026922281, 1.1941032601826009, 26.572143463236738, 0.63714520701250876, 27.610539833557009, 0.14626692286219622, 28.65837617088021, -0.29741152627502743, 29.725092442209199, -0.67501020639247145, 30.81068864754404, -0.99596908449166222, 31.91516478688472, -1.2602881605725997, 33.038520860231202, -1.4585274676337576, 34.171316900580578, -1.6095669396818266, 35.322992874935792, -1.694526642706478, 36.493548783296852, -1.7228465437146951, 36.738987925372541, -1.7228465437146951, 37.900103866730667, -1.6756467086997873, 39.070659775091698, -1.5529271376635734, 40.25065565045567, -1.3546878306024155, 41.430651525819613, -1.0809287875163136, 42.629527335189387, -0.74108997541225108, 43.828403144559182, -0.32573142728506355, 45.03671892093184, 0.15570688986372261, 46.25447466430743, 0.72210491004079813, 47.47223040768305, 1.3545826992340153, 48.70886608506445, 2.0531402574488311, 49.945501762445879, 2.8272175516885909, 51.19157740683022, 3.6768145819496567, 51.644695822969972, 4.0072134270521929, 52.541492688246571, 4.7057709852670087, 53.41940961951736, 5.442088411493387, 54.278446616782311, 6.2350456397398375, 55.118603680041453, 7.0752027029993769, 55.939880809294749, 7.9625596012720052, 56.74227800454225, 8.8971163345613604, 57.516355298780987, 9.8788729028638045, 58.280992626016833, 10.917269273182683, 59.017310052243943, 11.993425511514943, 59.744187511468141, 13.126221551865456, 60.442745069683589, 14.306217427227239, 61.13186266089614, 15.523973170604222, 61.792660351099961, 16.79836871599764, 62.434578107297938, 18.119964096407784, 63.057615929490119, 19.498199278830725, 63.661773817676448, 20.914194329267048, 63.841133190731767, 21.367312745405798, 64.265931705862783, 22.443468983739876, 64.662410319985071, 23.547945123078534, 65.040009000101534, 24.661861229422357, 65.408167713215107, 25.804097236774396, 65.748006525319894, 26.965213178131307, 66.0689654034189, 28.145209053496728, 66.371044347512083, 29.353524829870366, 66.654243357599427, 30.571280573245531, 66.918562433680961, 31.817356217630731, 67.164001575756657, 33.082311796020804, 67.381120816823625, 34.356707341412402, 67.588800090887673, 35.668862754819202, 67.777599430945912, 36.990458135225708, 67.938078869995422, 38.330933449638906, 68.089118342041985, 39.69972866506032, 68.211837913079833, 41.087403814486606, 68.315677550111872, 42.484518930919876, 68.410077220141005, 43.919393915362889, 68.476156989161382, 45.363708866807428, 68.52335682417592, 46.826903752258659, 68.551676725184677, 48.318418538721744, 68.561116692187568, 49.819373292182718, 68.561116692187568, 50.470731015382626, 68.542236758181744, 52.000005669853635, 68.495036923167191, 53.510400390321593, 68.428957154146815, 54.992475209777695, 68.3439974511206, 56.455670095228925, 68.230717847085685, 57.90942501367681, 68.098558309044904, 59.334860031114658, 67.938078869995422, 60.731975147547928, 67.758719496940103, 62.119650296977852, 67.560480189878945, 63.488445512399267, 67.333920981809058, 64.828920826812464, 67.088481839733362, 66.150516207217152, 66.814722796648937, 67.453231653620605, 66.522083819558674, 68.737067166017368, 66.210564908462601, 70.002022744407441, 65.870726096357771, 71.238658421789296, 65.512007350247131, 72.45641416516446, 65.124968703127763, 73.66472994153628, 64.719050122002557, 74.844725816903519, 64.294251606871541, 75.996401791257085, 63.841133190731767, 77.138637798609125, 63.369134840586192, 78.261993871954473, 62.878256556434799, 79.357030044293424, 62.359058371274642, 80.433186282625684, 61.811540285105771, 81.490462586951253, 61.254582231934002, 82.52885895727195, 60.659864310750557, 83.548375393585957, 60.055706422564221, 84.539571928891746, 59.423228633369149, 85.511888530190845, 58.771870910168253, 86.474765164490236, 58.092193285958587, 87.409321897775953, 57.393635727743153, 88.324998697058618, 56.600678499498571, 89.306755265362881, 55.637801865201567, 90.439551305711575, 54.656045296898789, 91.50626757703867, 53.664848761593049, 92.506904079347805, 52.654772292281507, 93.44146081263716, 51.644695822969972, 94.319377743908262, 50.606299452649701, 95.12177493915442, 49.567903082329423, 95.867532332384144, 48.501186811000402, 96.547209956594088, 47.434470539671402, 97.160807811782433, 46.348874334336557, 97.717765864956164, 45.253838161998807, 98.199204182103131, 44.139922055655241, 98.614562730232137, 43.016565982308762, 98.973281476342891, 41.883769941959358, 99.265920453433864, 40.732093967604143, 99.492479661503239, 39.570978026246038, 99.652959100552835, 38.400422117884993, 99.74735877058265, 37.210986275518131, 99.785118638594213],
     ],

 49: [ [17.32237974068968, 88.181093756200426, 18.398045917803021, 85.938603251372115, 18.60770966418951, 86.038877217035406, 20.08447170395527, 86.695215901374468, 21.45184396299766, 87.22393317487149, 22.70982644131664, 87.643260667644427, 23.85841913891224, 87.934966749575324, 24.897622055784471, 88.117283050780316, 25.81831937687301, 88.181093756200426, 17.32237974068968, 88.181093756200426],
       [43.48476896370056, 99.785526327941625, 41.1055412329668, 99.785526327941625, 17.32237974068968, 88.181093756200426, 25.81831937687301, 88.181093756200426, 26.821059033504071, 88.089935605599749, 28.015230806401089, 87.734418818248741, 29.063549538333572, 87.096311764029451, 29.154707688936409, 87.023385243546727, 29.883972893759001, 86.175614442940059, 30.45826924255681, 85.063485005586699, 30.868480920269519, 83.705228561604599, 30.95963907087236, 83.258553623649277, 31.078144666656019, 82.529288418827491, 31.18753444737942, 81.672401803161847, 31.278692597982229, 80.67877796159155, 31.360734933524778, 79.557532709175575, 31.433661454007051, 78.290434415794152, 31.488356344368729, 76.904830526633305, 31.533935419670151, 75.382489411567803, 31.561282864850991, 73.723411070594011, 31.579514494971569, 71.927595503719203, 31.588630310031849, 70.013274341059514, 31.588630310031849, 17.232705142025225, 31.588630310031849, 16.603713902863092, 31.570398679911278, 14.643813664904883, 31.52481960460986, 12.90269298838939, 31.461008899187881, 11.353004428141503, 31.378966563645349, 10.012979614279175, 31.269576782921948, 8.882618546804224, 31.132839557017721, 7.9528054106576747, 30.97787070099292, 7.2326560208930459, 30.79555439978725, 6.7130545624568185, 30.67704880400359, 6.4578117407691025, 30.011594304602969, 5.4550720841361908, 29.118244428695281, 4.5981854684723658, 27.987883361220241, 3.8962677088275086, 27.905841025677692, 3.8598044485897844, 27.2221548961565, 3.5772141817215015, 26.337920835309092, 3.3310871750927618, 25.262254658195761, 3.1305392437661794, 24.004272179876779, 2.957338757620164, 22.545741770231562, 2.8297173467763059, 20.89577924432044, 2.7294433811148338, 19.045268787083071, 2.674748490751881, 19.045268787083071, 0.0038146780898387078, 55.809350925202551, 0.0038146780898387078, 55.809350925202551, 2.674748490751881, 55.7820034800217, 2.674748490751881, 53.986187913146033, 2.7294433811148338, 52.363572832415741, 2.8297173467763059, 50.9323898679514, 2.9664545726827782, 49.683523204692683, 3.1396550588269747, 48.607857027579342, 3.3584346202715096, 47.723622966731931, 3.6045616269002494, 47.012589392029888, 3.8962677088275086, 46.474756303473207, 4.1970896058192011, 45.462900831781859, 4.9719338859431446, 44.706288181778397, 5.9017470220915129, 44.204918353462887, 6.9956448293269204, 44.195802538402603, 7.0229922745074873, 44.022602052257213, 7.6337518835462106, 43.876749011292702, 8.4268277937881066, 43.758243415509043, 9.420451635362042, 43.657969449845922, 10.596391778137331, 43.585042929363652, 11.972879852241022, 43.521232223941688, 13.531684227547885, 43.493884778760837, 15.291036534183149, 43.48476896370056, 17.232705142025225, 43.48476896370056, 99.785526327941625],
     ],

 50: [ [67.696373763810968, 18.819721266443594, 65.03455576620847, 18.819721266443594, 64.843123649942541, 18.500667739333949, 64.095626814999378, 17.352075041739226, 63.302550904754781, 16.312872124866772, 62.454780104148512, 15.383058988718403, 61.5705460433011, 14.562635633292302, 60.631617092092, 13.851602058590288, 59.747383031244603, 13.259074079671336, 58.63525359389012, 12.657430285693408, 57.47754508123424, 12.156060457378771, 56.265141678216672, 11.764080409786402, 55.016275014957962, 11.472374327857324, 54.569600077004111, 11.390331992313804, 53.69448183121699, 11.271826396530741, 52.691742174585919, 11.17155243086745, 51.570496922171181, 11.08951009532575, 50.312514443852159, 11.016583574844844, 48.936026369749499, 10.961888684480073, 47.441032699863172, 10.92542542424053, 45.809301804072589, 10.898077979058144, 44.059065312498348, 10.888962163999167, 18.543898958767532, 10.888962163999167, 11.470026471988289, 10.387592335682712, 10.34878121957354, 9.3119261585688946, 9.2001885219779354, 8.2362599814587156, 8.0333641942617646, 7.1423621742233081, 6.8483082364250256, 6.0393485519289243, 5.6450206484677494, 4.9272191145755642, 4.4326172454501602, 3.8059738621595898, 3.1928663972517479, 2.6756127946846391, 3.1928663972517479, 0.0046789820207777666, 60.85039665353878, 0.0046789820207777666, 67.696373763810968, 18.819721266443594],
       [12.13548097138891, 89.011497230621899, 11.470026471988289, 88.045220834230349, 10.841035232828769, 87.051596992660052, 10.2576230689707, 86.021509890846573, 9.6924425352331962, 84.945843713734575, 9.1728410767970843, 83.833714276379396, 8.6805870635418216, 82.69423739384365, 8.2247963105276938, 81.509181436007566, 7.8054688177546998, 80.287662217930119, 7.4226045852228424, 79.029679739611311, 7.0670877978718059, 77.726118185990345, 6.7480342707619343, 76.395209187188811, 6.4654440038931682, 75.027836928145916, 6.219316997265536, 73.614885593802683, 6.0005374358187558, 72.174586814278882, 8.6714712484815362, 72.174586814278882, 8.7170503237829564, 72.311324040181717, 9.1910727069176517, 73.624001408863478, 9.7106741653537352, 74.881983887182287, 10.26673888403098, 76.094387290197119, 10.86838267800962, 77.242979987795479, 11.515605547289679, 78.345993610089863, 12.199291676810869, 79.394312342021294, 12.928556881633479, 80.397051998652387, 13.69428534669723, 81.33598094986155, 14.496477072002079, 82.22021501070958, 15.353363687668629, 83.058869996257272, 16.237597748516041, 83.842830091440192, 17.176526699725141, 84.572095296261978, 18.17015054129595, 85.264897240844221, 19.245816718409291, 85.930351740244078, 20.348830340703469, 86.522879719163029, 21.479191408178512, 87.042481177599257, 22.627784105774111, 87.498271930613555, 23.803724248550569, 87.881136163145129, 25.00701183650785, 88.200189690256593, 26.237646869645999, 88.437200881822719, 27.495629347964979, 88.61951718302771, 28.771843456404529, 88.719791148692821, 30.075405010024951, 88.756254408932364, 12.13548097138891, 89.011497230621899],
       [33.894931520283343, 99.786390631874383, 33.430024952208917, 99.786390631874383, 32.090000138347392, 99.740811556572226, 30.777322769666679, 99.640537590908934, 29.482877031106572, 99.485568734884509, 28.224894552787589, 99.285020803556108, 26.994259519649429, 99.020662166809416, 25.790971931692159, 98.710724454760566, 24.615031788915701, 98.346091852350582, 23.466439091320101, 97.926764359577646, 22.345193838905349, 97.452741976441757, 21.260411846731731, 96.924024702944735, 20.193861484678681, 96.349728354147373, 19.15465856780645, 95.711621299928083, 18.151918911175379, 95.027935170408455, 17.176526699725141, 94.289554150524054, 16.21936611839547, 93.49647824027852, 15.298668797306959, 92.648707439673672, 15.11635249610128, 92.475506953527656, 14.323276585856719, 91.664199413162351, 13.557548120792969, 90.816428612555683, 12.828282915970391, 89.932194551707653, 12.13548097138891, 89.011497230621899, 30.075405010024951, 88.756254408932364, 30.44003761243625, 88.747138593873387, 31.707135905815509, 88.692443703510435, 32.946886754013953, 88.546590662546805, 34.150174341971223, 88.327811101100451, 35.335230299807961, 88.026989204108759, 36.483822997403571, 87.644124971575366, 37.605068249818324, 87.188334218562886, 38.689850241991941, 86.650501130008706, 39.7472847889847, 86.030625705909188, 40.786487705856928, 85.337823761328764, 41.780111547427708, 84.562979481201182, 42.75550375887795, 83.706092865535538, 43.69443271008705, 82.767163914326375, 44.004370422136638, 82.438994572157753, 44.797446332381242, 81.509181436007566, 45.535827352264128, 80.552020854676812, 46.20128185166476, 79.549281198049357, 46.812041460703682, 78.510078281176902, 47.349874549260363, 77.434412104061266, 47.833012747455307, 76.322282666706087, 48.243224425168052, 75.164574154052389, 48.589625397458782, 73.979518196214485, 48.881331479387818, 72.757998978138858, 49.100111040834598, 71.490900684759254, 49.264195711919683, 70.196454946197264, 49.35535386252252, 68.856430132336754, 49.391817122763619, 67.489057873293859, 49.391817122763619, 67.297625757028072, 49.364469677582797, 66.240191210034027, 49.300658972160811, 65.173640847982824, 49.191269191437407, 64.097974670867188, 49.054531965533187, 63.013192678694395, 48.872215664327541, 61.910179056400011, 48.653436102880761, 60.807165434107446, 48.398193281192839, 59.695035996750448, 48.097371384203512, 58.573790744336293, 47.760086226973073, 57.443429676861342, 47.38633780950147, 56.29483697926662, 46.97612613178876, 55.146244281670079, 46.529451193834909, 53.98853576901638, 46.037197180579653, 52.812595626237453, 45.508479907083277, 51.636655483462164, 44.943299373345752, 50.442483710565284, 44.33253976430683, 49.248311937668404, 43.685316895026773, 48.035908534651753, 43.010746580565858, 46.823505131631464, 42.281481375743247, 45.59287009849686, 41.524868725739822, 44.362235065358618, 40.722677000434942, 43.113368402096967, 39.884022014888949, 41.855385923778158, 39.008903769101828, 40.597403445461168, 38.589576276328842, 40.004875466540398, 38.060859002832451, 39.266494446657816, 37.504794284155203, 38.51899761171444, 36.939613750417692, 37.771500776771063, 36.347085771499337, 37.005772311709734, 35.74544197752067, 36.23092803158579, 35.125566553421471, 35.446967936401052, 34.487459499201691, 34.644776211096541, 33.822004999801067, 33.842584485790212, 33.147434685340158, 33.022161130364111, 32.45463274075869, 32.201737774941648, 31.73448335099636, 31.363082789395776, 31.00521814617375, 30.515311988787289, 30.2577213112306, 29.658425373119826, 29.491992846166848, 28.792422942393387, 28.708032750982571, 27.917304696606152, 27.905841025677692, 27.033070635758122, 27.076301855191989, 26.130604944790321, 26.237646869645999, 25.228139253822519, 25.380760253979449, 24.307441932734946, 24.5056420081923, 23.377628796584759, 23.612292132284612, 22.438699845377414, 22.700710626256381, 21.490655079107455, 21.770897490107561, 20.533494497776701, 20.822852723838171, 19.56721810138697, 19.856576327448209, 18.582710074877468, 18.872068300937709, 17.598202048366147, 17.86932864430662, 16.595462391735055, 16.848357357554988, 15.583606920043167, 15.809154440682761, 14.562635633292302, 14.751719893689989, 13.532548531480643, 13.676053716576661, 12.493345614608188, 12.58215590934276, 11.445026882676757, 11.470026471988289, 10.387592335682712, 18.543898958767532, 10.888962163999167, 18.689751999732039, 11.025699389903821, 19.081732047324209, 11.390331992313804, 19.51929117021777, 11.800543670025945, 19.984197738292181, 12.256334423040244, 20.50379919672827, 12.766820066417495, 21.059863915405518, 13.322884785093265, 21.66150770938415, 13.924528579074831, 22.29961476360393, 14.571751448353098, 22.983300893125119, 15.273669207994317, 23.703450282887449, 16.021166042939512, 24.46917874795119, 16.814241953181408, 25.280486288316329, 17.662012753789895, 26.128257088922592, 18.555362629696901, 27.01249114977, 19.494291580906065, 27.95142010097911, 20.478799607417386, 28.926812312429352, 21.518002524289841, 29.938667784120689, 22.602784516460815, 30.996102331113491, 23.742261398996561, 32.099115953407683, 24.918201541773669, 33.238592835942967, 26.14883657491373, 34.423648793779712, 27.425050683350491, 35.645168011857578, 28.755959682152024, 36.912266305236841, 30.12333194119492, 38.215827858857239, 31.545399090598949, 39.564968487779062, 33.022161130364111, 40.959688192002289, 34.535386430370636, 41.679837581764609, 35.32846234061617, 42.655229793214829, 36.422360147849759, 43.612390374544503, 37.516257955083347, 44.55131932575361, 38.601039947259778, 45.453785016721582, 39.676706124371776, 46.347134892629271, 40.752372301483774, 47.204021508295817, 41.818922663538615, 48.04267649384181, 42.885473025591637, 48.86309984926725, 43.952023387644658, 49.647059944451541, 45.000342119576089, 50.42190422457557, 46.057776666568316, 51.160285244458457, 47.096979583440771, 51.880434634220762, 48.14529831537584, 52.582352393862521, 49.175385417187499, 53.25692270832343, 50.20547251899734, 53.904145577603479, 51.235559620808999, 54.533136816762983, 52.256530907559863, 55.134780610741643, 53.268386379251751, 55.709076959539431, 54.280241850943639, 56.265141678216672, 55.292097322635527, 56.802974766773332, 56.29483697926662, 57.313460410149162, 57.288460820835098, 57.796598608344141, 58.282084662407215, 58.252389361358269, 59.266592688918536, 58.297968436659687, 59.366866654583646, 58.844917340276623, 60.597501687721888, 59.34628716859217, 61.828136720856492, 59.792962106546007, 63.058771753994733, 60.19405796919844, 64.280290972073999, 60.549574756549482, 65.510926005212241, 60.859512468599057, 66.741561038350483, 61.123871105347263, 67.972196071488725, 61.333534851733759, 69.202831104626966, 61.506735337879121, 70.433466137763389, 61.625240933662809, 71.664101170901631, 61.689051639084802, 72.885620388980897, 61.716399084265618, 74.116255422119139, 61.716399084265618, 74.426193134167988, 61.670820008964228, 75.684175612488616, 61.561430228240823, 76.93304227574481, 61.397345557155738, 78.154561493824076, 61.178565995708958, 79.348733266720956, 60.886859913779922, 80.533789224558859, 60.549574756549482, 81.691497737212558, 60.139363078836737, 82.830974619748304, 59.674456510762361, 83.952219872162459, 59.145739237265957, 85.046117679397867, 58.562327073407857, 86.121783856509865, 57.9151042041278, 87.179218403505729, 57.21318644448607, 88.209305505317388, 56.447457979422317, 89.230276792066434, 55.617918808936622, 90.214784818579574, 54.73368474808921, 91.1901770300301, 53.785639981819827, 92.147337611357216, 53.348080858926267, 92.54843347401038, 52.409151907717153, 93.377972644495458, 51.442875511327202, 94.15281692462122, 50.449251669756421, 94.882082129441187, 49.437396198065038, 95.556652443903658, 48.389077466132562, 96.176527868001358, 47.322527104079512, 96.759940031859514, 46.228629296845597, 97.279541490295742, 45.116499859491107, 97.75356387343345, 43.967907161895539, 98.182007181263543, 42.801082834179368, 98.55575559873796, 41.606911061282347, 98.8839249409084, 40.385391843204502, 99.157399392715888, 39.136525179945778, 99.385294769221218, 37.860311071506231, 99.558495255367234, 36.565865332946117, 99.686116666211092, 35.244072149205152, 99.759043186695635, 33.894931520283343, 99.786390631874383],
     ],

 51: [ [11.770848368977591, 11.254459070341909, 11.041583164155011, 11.217995810102366, 9.8200639460771413, 10.953637173353854, 8.7170503237829564, 10.434035714915808, 7.7325422972724311, 9.6683072498544789, 7.377025509921423, 9.3219062775624479, 6.611297044857678, 8.3009349908115837, 6.155506291843551, 7.1888055534582236, 6.0005374358187558, 5.9946337805577059, 6.018769065939324, 5.5935379179063602, 6.2375486273861043, 4.5634508160947007, 6.7115710105207986, 3.5698269745225844, 7.4226045852228424, 2.5944347630738775, 8.3888809816127718, 1.6463899968039186, 9.6104001996906447, 0.72569267571452656, 10.239391438850131, 0.33371262812215718, 11.041583164155011, -0.058267419466574211, 11.944048855122981, -0.40466839176042413, 12.955904326814331, -0.71460610380927392, 14.068033764168799, -0.97896474055778526, 15.28955298224667, -1.2068601170649345, 16.620461981047921, -1.3982922333289025, 18.060760760572549, -1.5350294592353748, 19.601333505760291, -1.6444192399576423, 21.251296031671441, -1.699114130320595, 23.01064833830597, -1.7264615755011619, 23.375280940717289, -1.7264615755011619, 24.824695535302201, -1.699114130320595, 26.237646869645999, -1.6444192399576423, 27.641482388929489, -1.5532610893533274, 29.00885464797188, -1.4256396785112884, 30.348879461833409, -1.2706708224868635, 31.670672645574371, -1.0883545212836907, 32.965118384134513, -0.86957495983187982, 34.232216677513783, -0.61433213814416376, 35.471967525712223, -0.33174187127588084, 36.693486743790061, -0.012688344166235765, 37.88765851668709, 0.34282844318477146, 39.054482844403253, 0.72569267571452656, 40.193959726938537, 1.1359043534284865, 41.306089164293013, 1.5916951064427849, 42.399986971526943, 2.0657174895768549, 43.466537333579993, 2.5853189480130823, 44.505740250452192, 3.1322678516298765, 45.517595722143568, 3.7065642004272377, 46.502103748654058, 4.3173238094677799, 32.67341230220547, 4.5452191859749291, 31.980610357623991, 4.5543350010357244, 30.67704880400359, 4.636377336575606, 29.409950510624331, 4.7913461926018499, 28.17931547748617, 5.0283573841679754, 26.976027889528869, 5.3382950962204632, 26.875753923865769, 5.365642541399211, 26.100909643741751, 5.6300011781477224, 25.125517432291531, 6.031097040800887, 23.94957728951508, 6.568930129358705, 22.573089215412409, 7.2526162588783336, 20.996053209983529, 8.0821554293634108, 19.656028396122, 8.7658415588848584, 18.197497986476801, 9.4859909486476681, 17.012442028640059, 10.051171482384234, 16.09174470755152, 10.443151529976603, 15.44452183827147, 10.680162721546367, 14.26858169549501, 10.980984618532602, 13.010599217176029, 11.181532549859185, 11.770848368977591, 11.254459070341909],
       [14.20477099007303, 90.489123574319819, 13.43904252500931, 89.541078808049861, 12.700661505126419, 88.556570781538539, 11.980512115364091, 87.52648367972688, 11.27859435572233, 86.450817502613063, 10.60402404126145, 85.338688065257884, 9.9476853569210846, 84.190095367661343, 9.3095783027013113, 82.995923594764463, 8.6897028786021053, 81.756172746567245, 8.0880590846234668, 80.479958638126845, 7.51376273582565, 79.167281269446903, 9.8929904665594108, 78.009572756791385, 10.622255671381989, 79.139933824268155, 11.45179484186772, 80.306758151982649, 12.29044982741371, 81.418887589337828, 13.15645225814054, 82.448974691149488, 14.04068631898795, 83.424366902598194, 14.94315200995592, 84.326832593567815, 15.863849331044459, 85.165487579113687, 16.81189409731385, 85.931216044176836, 17.778170493703779, 86.633133803819874, 18.762678520214308, 87.271240858037345, 19.765418176845401, 87.83642139177573, 20.79550527865732, 88.337791220090367, 21.843824010589799, 88.775350342984893, 22.910374372642881, 89.149098760455672, 24.004272179876779, 89.449920657445546, 25.10728580217096, 89.677816033952695, 26.237646869645999, 89.851016520096891, 27.386239567241599, 89.951290485760182, 28.562179710018029, 89.978637930940749, 14.20477099007303, 90.489123574319819],
       [33.967858040765577, 99.787254935805322, 33.129203055219591, 99.778139120746346, 31.770946611237491, 99.714328415322598, 30.44003761243625, 99.586707004480559, 29.145591873876128, 99.413506518334543, 27.887609395557121, 99.176495326766599, 26.66609017747928, 98.88478924483934, 25.481034219642542, 98.529272457486513, 24.323325706986651, 98.119060779774372, 23.202080454571899, 97.654154211699279, 22.117298462398281, 97.125436938202256, 21.059863915405518, 96.5420247743441, 20.048008443714139, 95.903917720126628, 19.063500417203642, 95.20199996048359, 18.106339835873971, 94.454503125540214, 17.45000115153362, 93.871090961680238, 16.602230350927361, 93.087130866497318, 15.78180699550191, 92.266707511074856, 14.97961527019706, 91.400705080344778, 14.20477099007303, 90.489123574319819, 28.562179710018029, 89.978637930940749, 28.87211742206765, 89.978637930940749, 30.193910605808611, 89.91482722551882, 31.470124714248161, 89.768974184555191, 32.709875562446598, 89.531962992987246, 33.90404733534362, 89.203793650818625, 35.052640032939202, 88.793581973104665, 36.15565365523338, 88.301327959849004, 37.222204017286458, 87.708799980931872, 38.252291119098381, 87.043345481528377, 39.227683330548608, 86.286732831527843, 40.166612281757722, 85.438962030922994, 40.677097925133523, 84.910244757424152, 41.451942205257552, 83.980431621275784, 42.153859964899297, 83.005039409825258, 42.764619573938234, 81.974952308013599, 43.302452662494908, 80.899286130899782, 43.749127600448759, 79.778040878485626, 44.122876017920333, 78.602100735710337, 44.4054662847891, 77.380581517632891, 44.615130031175589, 76.104367409190672, 44.733635626959249, 74.773458410390958, 44.779214702260667, 73.396970336287268, 44.77009888720039, 72.640357686286734, 44.68805655165783, 71.336796132665768, 44.542203510693327, 70.06058202422355, 44.323423949246539, 68.811715360965536, 44.04083368237778, 67.59019614288809, 43.685316895026773, 66.386908554930415, 43.256873587193489, 65.220084227214102, 42.75550375887795, 64.071491529621198, 42.181207410080162, 62.941130462144429, 42.026238554055332, 62.658540195276146, 41.406363129956127, 61.655800538643234, 40.722677000434942, 60.689524142253504, 39.956948535371232, 59.75059519104434, 39.127409364885501, 58.848129500076539, 38.224943673917522, 57.973011254289304, 37.249551462467309, 57.134356268743431, 36.201232730534798, 56.323048728378126, 35.08910329318033, 55.548204448254182, 33.894931520283343, 54.800707613310806, 33.147434685340158, 54.372264305478893, 31.95326291244314, 53.734157251257784, 30.75909113954614, 53.150745087399628, 29.564919366649121, 52.622027813906243, 28.3707475937521, 52.157121245831149, 27.17657582085511, 51.746909568117189, 25.991519863018372, 51.400508595825158, 24.80646390518163, 51.099686698837104, 23.621407947344888, 50.871791322331774, 22.436351989508179, 50.689475021123144, 22.436351989508179, 48.529026851836534, 24.742653199759651, 48.529026851836534, 25.882130082294971, 48.501679406657786, 27.140112560613971, 48.419637071114266, 28.388979223872671, 48.282899845209613, 29.628730072071111, 48.08235191388485, 30.868480920269519, 47.827109092195315, 32.099115953407683, 47.50805556508567, 33.329750986545811, 47.143422962673867, 34.551270204623677, 46.705863839781159, 35.772789422701521, 46.222725641588113, 36.939613750417692, 45.684892553028476, 38.206712043796962, 45.055901313869981, 39.400883816693977, 44.417794259650691, 40.531244884169013, 43.761455575311629, 41.579563616101488, 43.077769445788363, 42.545840012491453, 42.38496750120612, 43.448305703459418, 41.683049741564901, 44.277844873945128, 40.953784536741296, 44.897720298044327, 40.324793297582801, 45.636101317927228, 39.458790866856361, 46.356250707689547, 38.474282840343221, 47.04905265227103, 37.371269218050656, 47.723622966731931, 36.158865815034005, 48.379961651072271, 34.827956816234291, 48.389077466132562, 34.800609371051905, 48.91779473962896, 33.59732178309423, 49.382701307703343, 32.394034195138374, 49.792912985416081, 31.172514977059109, 50.13019814264652, 29.950995758983481, 50.412788409515287, 28.72036072584342, 50.622452155901783, 27.480609877646202, 50.777421011926577, 26.240859029445346, 50.877694977589691, 24.982876551126537, 50.905042422770549, 23.724894072809548, 50.877694977589691, 22.558069745091416, 50.768305196866287, 21.290971451713631, 50.585988895660648, 20.051220603514594, 50.32163025891245, 18.847933015558738, 49.98434510168201, 17.662877057720834, 49.5741334239693, 16.514284360124293, 49.081879410714031, 15.393039107710138, 48.525814692036789, 14.308257115535525, 47.878591822756732, 13.250822568543299, 47.158442432994399, 12.220735466731639, 46.365366522749831, 11.217995810102366, 45.499364092023001, 10.242603598650021, 44.943299373345752, 9.6865388799724315, 43.967907161895539, 8.7931890040654253, 42.965167505264439, 7.9909972787627339, 41.935080403452517, 7.2708478889981052, 40.877645856459729, 6.632740834778815, 39.783748049225842, 6.0766761161012255, 38.671618611871367, 5.6117695480261318, 37.523025914275763, 5.2289053154945577, 36.356201586559621, 4.9280834185065032, 35.152913998602308, 4.7184196721191256, 33.922278965464159, 4.5907982612752676, 32.67341230220547, 4.5452191859749291, 46.502103748654058, 4.3173238094677799, 47.468380145044023, 4.9645466787460464, 48.40730909625313, 5.6391169932066987, 49.318890602281378, 6.3501505679087131, 50.20312466312879, 7.0885315877931134, 51.069127093855627, 7.8633758679170569, 51.907782079401613, 8.6746834082841815, 52.7099738047065, 9.513338393828235, 53.503049714951061, 10.38845663961547, 53.566860420373047, 10.470498975155351, 54.387283775798458, 11.455007001668491, 55.162128055922501, 12.457746658299584, 55.90050907580536, 13.478717945052267, 56.584195205326552, 14.527036676985517, 57.231418074606609, 15.584471223975925, 57.823946053524992, 16.660137401089742, 58.380010772202212, 17.763151023384125, 58.890496415578042, 18.875280460737486, 59.355402983652453, 20.005641528210617, 59.774730476425439, 21.163350040869773, 60.148478893897021, 22.330174368586086, 60.485764051127489, 23.524346141481146, 60.777470133056532, 24.736749544499617, 61.014481324623887, 25.958268762575244, 61.215029255950093, 27.207135425836896, 61.369998111974887, 28.474233719214681, 61.47938789269827, 29.750447827656899, 61.55231441318054, 31.054009381276046, 61.5705460433011, 32.375802565016784, 61.543198598120263, 33.67936411863775, 61.461156262577731, 35.010273117437464, 61.333534851733759, 36.31383467105843, 61.14210273546783, 37.580932964439853, 60.895975728840199, 38.829799627696048, 60.595153831850858, 40.051318845773494, 60.239637044499858, 41.236374803611398, 59.829425366787149, 42.403199131329529, 59.364518798712737, 43.533560198802661, 58.844917340276623, 44.64568963615784, 58.270620991478843, 45.730471628330633, 57.641629752319339, 46.778790360263883, 56.957943622798162, 47.808877462075543, 56.538616130025162, 48.383173810872904, 55.809350925202551, 49.312986947021272, 55.025390830018239, 50.206336822928279, 54.20496747459282, 51.072339253656537, 53.329849228805692, 51.901878424143433, 52.409151907717153, 52.694954334387148, 51.442875511327202, 53.460682799450296, 50.431020039635861, 54.189948004273901, 49.364469677582797, 54.891865763913302, 48.2523402402283, 55.557320263314978, 47.094631727572448, 56.195427317534268, 45.891344139615143, 56.797071111515834, 44.633361661296163, 57.362251645250581, 43.338915922736021, 57.90008473380658, 43.831169935991277, 58.328528041640311, 45.034457523948589, 59.385962588632538, 46.173934406483909, 60.443397135626583, 47.258716398657519, 61.500831682618809, 48.279687685409158, 62.549150414553878, 49.245964081799123, 63.59746914648349, 50.157545587827371, 64.645787878416741, 51.005316388433641, 65.694106610348172, 51.79839229867823, 66.733309527220626, 52.527657503500819, 67.763396629032286, 53.20222781796172, 68.802599545904741, 53.812987427000671, 69.8326866477164, 54.369052145677898, 70.853657934469084, 54.870421973993437, 71.883745036280743, 55.307981096886998, 72.904716323033426, 55.690845329418863, 73.916571794723495, 56.009898856528757, 74.937543081476178, 56.274257493276963, 75.949398553166247, 56.474805424603183, 76.95213820979734, 56.62977428062797, 77.954877866428433, 56.711816616170523, 78.957617523059525, 56.739164061351381, 79.960357179690618, 56.730048246291091, 80.726085644755585, 56.62977428062797, 81.929373232711441, 56.447457979422317, 83.123545005608321, 56.19221515773441, 84.299485148385429, 55.836698370383402, 85.457193661040947, 55.408255062550118, 86.605786358637488, 54.888653604114012, 87.745263241173234, 54.29612562519565, 88.866508493587389, 53.603323680614182, 89.969522115883592, 52.837595215550436, 91.063419923115362, 51.989824414944167, 92.148201915289974, 51.725465778195968, 92.449023812279847, 50.923274052891109, 93.342373688183216, 50.084619067345102, 94.17191285867375, 49.200385006497697, 94.946757138797693, 48.270571870348867, 95.657790713499708, 47.304295473958938, 96.323245212897746, 46.301555817327852, 96.924889006879312, 45.253237085395369, 97.462722095433492, 44.159339278161468, 97.954976108690971, 43.028978210686432, 98.383419416522884, 41.862153882970262, 98.757167833993662, 40.649750479952672, 99.067105546042512, 39.3917680016337, 99.331464182791024, 38.097322263073579, 99.532012114117606, 36.757297449212047, 99.668749340022259, 35.380809375109379, 99.759907490626574, 33.967858040765577, 99.787254935805322],
     ],

 52: [ [55.590571363755771, 99.788119239750813, 47.659812261309952, 99.788119239750813, 2.3268639665248818, 35.047600681620679, 2.3268639665248818, 25.813280025560744, 43.69443271008705, 25.813280025560744, 43.69443271008705, 0.0064075899008457782, 55.590571363755771, 0.0064075899008457782, 55.590571363755771, 25.813280025560744, 68.70822923550233, 25.813280025560744, 68.70822923550233, 36.050340338260867, 55.590571363755771, 36.050340338260867, 9.3916206382438645, 36.050340338260867, 43.69443271008705, 84.573823904140227, 55.590571363755771, 99.788119239750813],
       [55.590571363755771, 99.788119239750813, 43.69443271008705, 84.573823904140227, 43.69443271008705, 36.050340338260867, 9.3916206382438645, 36.050340338260867, 55.590571363755771, 36.050340338260867, 55.590571363755771, 99.788119239750813],
     ],

 53: [ [12.919441066573199, 12.988192539669399, 12.071670265966929, 12.942613464370879, 10.831919417768489, 12.678254827620549, 9.7197899804140206, 12.186000814370345, 8.7443977689638075, 11.474967239659236, 8.4800391322156088, 11.201492787860843, 7.7051948520915801, 10.171405686040089, 7.240288284017196, 9.0592762486903666, 7.0853194279923741, 7.8651044757898489, 7.1035510581129406, 7.3363872023001022, 7.2949831743788698, 6.2607210251808283, 7.6778474069107574, 5.2032864781904209, 8.2430279406482612, 4.1823151914395567, 9.0087564057120062, 3.1978071649300546, 9.9659169870416502, 2.2315307685403241, 11.123625499697541, 1.3017176323901367, 11.561184622591099, 0.98266410528049164, 12.408955423197369, 0.47217846189960255, 13.338768559346191, 0.0072718938299658475, 14.350624031037571, -0.39382396881956083, 15.45363765333175, -0.74934075617056806, 16.638693611168492, -1.0410468380996463, 17.914907719608038, -1.287173844730205, 19.273164163590138, -1.47860596099963, 20.72257875817505, -1.6153431869006454, 22.25403568830254, -1.697385522440527, 23.87665076903281, -1.7247329676301888, 24.943201131085889, -1.7065013374995033, 26.201183609404868, -1.6518064471401885, 27.45005027266356, -1.5515324814805354, 28.689801120862001, -1.41479525557952, 29.929551969060409, -1.2324789543708903, 31.169302817258849, -1.0136993929208984, 32.399937850396981, -0.74934075617056806, 33.621457068474847, -0.44851885918069456, 34.842976286552698, -0.10211788689048262, 36.064495504630571, 0.28074634563927248, 37.276898907648132, 0.70918965346936602, 38.480186495605437, 1.1832120366107119, 39.683474083562743, 1.6936976799806871, 40.886761671520013, 2.2406465835993004, 41.087309602846233, 2.3409205492607725, 42.217670670321269, 2.9152168980599527, 43.32980010767573, 3.5259765071004949, 44.423697914909667, 4.1731993763805804, 45.499364092023001, 4.856885505900209, 46.547682823955483, 5.5679190806004044, 31.95326291244314, 5.7046563064996008, 31.570398679911278, 5.7046563064996008, 30.38534272207454, 5.777582826989601, 29.200286764237831, 5.9325516830103879, 28.015230806401089, 6.1786786896391277, 26.839290663624642, 6.5068480318095681, 25.663350520848191, 6.9261755245806853, 24.487410378071761, 7.4275453529007791, 23.32058605035559, 8.0200733318197308, 22.15376172263942, 8.6946436462803831, 20.996053209983529, 9.451256296279098, 20.421756861185742, 9.8523521589304437, 19.063500417203642, 10.773049480019836, 17.905791904547751, 11.502314684850717, 16.966862953338651, 12.049263588460235, 16.237597748516041, 12.404780375809423, 15.49921672863317, 12.660023197500777, 14.26858169549501, 12.906150204129517, 12.919441066573199, 12.988192539669399],
       [64.095626814999378, 97.765272600299795, 29.063549538333572, 97.765272600299795, 10.33054958945297, 59.770555429040542, 10.51286589065862, 59.770555429040542, 12.071670265966929, 59.697628908559636, 13.594011381034109, 59.606470757960778, 15.07077342079989, 59.497080977229416, 16.5201880153848, 59.369459566389196, 17.924023534668319, 59.232722340480905, 19.282279978650418, 59.068637669399322, 20.613188977451671, 58.877205553129897, 21.898518900951501, 58.676657621810591, 23.147385564210229, 58.457878060360599, 24.359788967227789, 58.220866868790836, 25.52661329494396, 57.965624047099482, 26.656974362418989, 57.683033780240294, 27.75087216965289, 57.391327698309397, 28.80830671664566, 57.081389986260547, 29.82016218833704, 56.744104829029311, 30.79555439978725, 56.397703856739099, 31.73448335099636, 56.023955439259225, 32.627833226904052, 55.64109120672947, 33.858468260042201, 55.07591067300018, 35.061755847999478, 54.48338269407941, 36.219464360655373, 53.854391454919096, 37.349825428130401, 53.207168585640829, 38.443723235364303, 52.532598271180177, 39.501157782357097, 51.821564696470887, 40.522129069108729, 51.092299491649101, 41.515752910679531, 50.32657102658959, 42.4637976769489, 49.533495116340418, 43.384494998037432, 48.713071760919775, 44.268729058884837, 47.865300960309469, 45.116499859491107, 46.999298529579391, 45.92780739985627, 46.08771702355989, 46.702651679980271, 45.157903887409702, 47.441032699863172, 44.200743306080767, 47.568654110707143, 44.03665863499009, 48.33438257577086, 42.942760827760139, 49.045416150472903, 41.830631390399503, 49.701754834813237, 40.709386137990805, 50.294282813731598, 39.579025070510397, 50.832115902288272, 38.430432372919313, 51.315254100483251, 37.281839675319134, 51.743697408316542, 36.115015347610097, 52.11744582578811, 34.929959389770374, 52.427383537837727, 33.744903431930652, 52.682626359525642, 32.541615843980253, 52.883174290851862, 31.329212440959964, 53.029027331816359, 30.107693222880698, 53.111069667358912, 28.867942374679842, 53.13841711253977, 27.61907571142001, 53.120185482419203, 26.598104424669145, 53.029027331816359, 25.303658686110793, 52.883174290851862, 24.045676207790166, 52.664394729405082, 22.815041174650105, 52.372688647476018, 21.611753586699706, 52.026287675185301, 20.435813443920779, 51.606960182412308, 19.29633656139049, 51.114706169157039, 18.184207124029854, 50.567757265540081, 17.099425131860698, 49.947881841440882, 16.041990584870291, 49.255079896859392, 15.021019298110332, 48.507583061916222, 14.018279641479239, 47.687159706490803, 13.052003245089509, 46.793809830583108, 12.122190108939321, 46.502103748654058, 11.830484027019338, 45.517595722143568, 10.918902520990741, 44.514856065512468, 10.089363350500207, 43.48476896370056, 9.3327507004996733, 42.436450231768049, 8.6399487559192494, 41.360784054654708, 8.0200733318197308, 40.266886247420807, 7.4822402432600938, 39.145640995006062, 7.0082178601205669, 38.006164112470742, 6.6071219974692212, 36.839339784754571, 6.2880684703595762, 35.645168011857578, 6.0328256486791361, 34.441880423900272, 5.8505093474705063, 33.202129575701861, 5.7411195667500579, 31.95326291244314, 5.7046563064996008, 46.547682823955483, 5.5679190806004044, 47.577769925767427, 6.3245317305991193, 48.580509582398491, 7.108491825789315, 49.56501760890901, 7.928915181209959, 50.531294005298939, 8.7766859818202647, 51.479338771568337, 9.6700358577309089, 52.172140716149812, 10.353721987250537, 53.019911516756082, 11.256187678220158, 53.840334872181529, 12.186000814370345, 54.633410782426097, 13.152277210760076, 55.390023432429551, 14.155016867389349, 56.128404452312417, 15.18510396919919, 56.839438027014459, 16.251654331250393, 57.523124156535658, 17.345552138489438, 58.179462840875999, 18.475913205960751, 58.808454080035489, 19.642737533680702, 59.410097874014163, 20.846025121629282, 59.710919771003461, 21.502363805979257, 60.19405796919844, 22.650956503570342, 60.631617092092, 23.817780831290293, 61.032712954744419, 25.011952604179896, 61.379113927035178, 26.21524019213939, 61.679935824024511, 27.436759410220475, 61.926062830652107, 28.667394443360536, 62.135726577038632, 29.925376921679344, 62.299811248123717, 31.201591030119744, 62.418316843907377, 32.486920953619119, 62.482127549329363, 33.790482507240085, 62.509474994510207, 35.121391506039799, 62.50035917944993, 35.786846005439656, 62.454780104148512, 37.063060113880056, 62.363621953545703, 38.321042592200683, 62.226884727641441, 39.560793440390626, 62.044568426435802, 40.791428473530686, 61.816673049928738, 42.003831876549157, 61.543198598120263, 43.198003649449674, 61.224145071010383, 44.373943792219507, 60.859512468599057, 45.531652304880481, 60.449300790886348, 46.680245002469746, 59.99351003787222, 47.810606069950154, 59.49214020955668, 48.92273550731079, 58.945191305939737, 50.016633314540741, 58.343547511961077, 51.092299491649101, 57.705440457741297, 52.158849853700303, 57.021754328220112, 53.207168585640829, 56.29248912339753, 54.23725568745067, 55.517644843273501, 55.249111159140739, 54.697221487848083, 56.242735000709217, 53.831219057121238, 57.227243027220538, 52.91963755109299, 58.184403608549474, 52.901405920972422, 58.21175105373004, 52.062750935426401, 59.041290224220575, 51.205864319759847, 59.843481949519628, 50.32163025891245, 60.627442044709824, 49.419164567944478, 61.393170509769334, 48.498467246855938, 62.131551529650096, 47.550422480586569, 62.842585104350292, 46.584146084196611, 63.526271233880834, 45.590522242625809, 64.200841548339667, 44.578666770934461, 64.838948602560777, 43.54857966912251, 65.458824026660295, 42.491145122129751, 66.051352005579247, 41.41547894501641, 66.625648354369332, 40.312465322722232, 67.172597257989764, 39.19122007030748, 67.701314531490425, 38.051743187772161, 68.202684359799605, 36.88491886005599, 68.676706742939132, 35.69986290221928, 69.132497495949792, 34.496575314261968, 69.570056618840681, 33.265940281123818, 69.971152481499303, 32.01707361786513, 70.363132529089853, 30.740859509425579, 70.71864931644086, 29.446413770865441, 71.055934473670277, 28.133736402184748, 71.374988000779922, 26.79371158832322, 71.657578267650024, 25.43545514434112, 71.931052719459331, 24.049851255178201, 72.168063911019999, 22.655131550954959, 72.395959287530786, 29.063549538333572, 85.513617159280329, 58.471168922805049, 85.513617159280329, 64.095626814999378, 97.765272600299795],
     ],

 54: [ [24.924969500965322, 56.106862078739141, 23.74902935818886, 55.368481058860198, 22.582205030472689, 54.584520963670002, 30.649701358822739, 54.292814881739105, 31.552167049790711, 54.611868408850569, 32.837496973290541, 54.976501011260552, 34.086363636549272, 55.240859648010883, 35.30788285462711, 55.395828504040765, 36.492938812463848, 55.450523394400079, 24.924969500965322, 56.106862078739141],
       [43.411842443218291, 61.722204155870713, 42.573187457672297, 61.713088340809918, 41.39724731489585, 61.658393450450603, 40.212191357059112, 61.558119484789131, 39.036251214282693, 61.412266443820045, 37.860311071506231, 61.220834327559714, 36.684370928729777, 60.983823135989951, 35.499314970893039, 60.701232869119849, 34.323374828116613, 60.373063526949409, 33.147434685340158, 59.999315109480449, 31.971494542563711, 59.579987616709332, 30.79555439978725, 59.1150810486306, 29.61961425701082, 58.604595405260625, 28.443674114234369, 58.048530686579397, 27.276849786518198, 57.44688689259965, 26.100909643741751, 56.799664023319565, 24.924969500965322, 56.106862078739141, 36.492938812463848, 55.450523394400079, 36.894034675116281, 55.441407579339284, 38.12466970825443, 55.368481058860198, 39.30972566609114, 55.213512202830316, 40.449202548626452, 54.967385196199757, 41.552216170920637, 54.63010003897034, 42.618766532973723, 54.201656731140247, 43.639737819725347, 53.691171087759358, 44.633361661296163, 53.089527293790525, 45.572290612505242, 52.405841164259982, 46.474756303473207, 51.630996884139677, 47.34075873420008, 50.764994453409599, 48.170297904685782, 49.81694968713964, 48.954257999870059, 48.777746770270824, 49.692639019752953, 47.656501517860306, 50.403672594455003, 46.434982299779222, 50.64068378602235, 45.988307361829357, 51.169401059518719, 44.939988629890649, 51.670770887834259, 43.86432245278047, 52.135677455908677, 42.761308830489725, 52.573236578802238, 41.640063578070112, 52.974332441454663, 40.500586695539823, 53.348080858926267, 39.333762367819872, 53.685366016156699, 38.14870640998015, 53.995303728206324, 36.945418822029751, 54.268778180014799, 35.71478378888969, 54.51490518664243, 34.465917125629858, 54.724568933028941, 33.189703017189458, 54.897769419174303, 31.895257278629288, 55.043622460138799, 30.582579909949345, 55.153012240862211, 29.242555096090655, 55.235054576404742, 27.884298652110374, 55.280633651706147, 26.498694762940431, 55.298865281826721, 25.094859243659812, 55.298865281826721, 24.711995011130057, 55.262402021585579, 23.207885526180689, 55.180359686043062, 21.758470931590637, 55.043622460138799, 20.354635412310017, 54.861306158933161, 19.005494783390532, 54.633410782426097, 17.701933229769566, 54.359936330617607, 16.453066566509733, 54.031766988447451, 15.249778978550239, 53.658018570975862, 14.101186280959155, 53.238691078202862, 12.998172658659314, 52.76466869506816, 11.940738111670726, 52.245067236632082, 10.937998455039633, 51.679886702894549, 9.989953688769674, 51.060011278795344, 9.0783721827392583, 50.403672594455003, 8.2306013821398665, 49.856723690838038, 7.6016101429795526, 48.890447294448109, 6.598870486339365, 47.896823452877292, 5.6964047953806585, 46.884967981185937, 4.9033288851296675, 45.854880879374008, 4.2196427556100389, 44.797446332381242, 3.6362305917500635, 43.712664340207617, 3.1622082086196315, 42.609650717913439, 2.7884597911506717, 41.479289650438403, 2.5241011544003413, 40.3306969528428, 2.3691322983704595, 39.154756810066353, 2.3144374080093257, 51.597844367352018, 2.0500787712608144, 52.618815654103663, 2.6790700104193093, 53.603323680614182, 3.3536403248799616, 54.569600077004111, 4.0829055297108425, 55.517644843273501, 4.857749809829329, 56.438342164362041, 5.6872889803198632, 57.340807855330013, 6.5532914110408456, 58.215926101117127, 7.4739887321302376, 59.07281271678368, 8.4493809435807634, 59.902351887269411, 9.4703522303298087, 60.70454361257427, 10.536902592390106, 60.713659427634553, 10.536902592390106, 61.470272077638022, 11.60345295443949, 62.190421467400313, 12.688234946610464, 62.864991781861221, 13.78213275384951, 63.503098836080987, 14.885146376140256, 64.104742630059661, 15.997275813489978, 64.651691533676612, 17.127636880970385, 65.171292992112711, 18.267113763509769, 65.645315375247407, 19.42482227615983, 66.073758683080683, 20.582530788820804, 66.465738730672825, 21.758470931590637, 66.812139702963563, 22.952642704489335, 67.12207741501318, 24.146814477389853, 67.386436051761365, 25.359217880399228, 67.614331428268429, 26.580737098480313, 67.805763544534358, 27.82048794667935, 67.942500770438599, 29.069354609939182, 68.051890551161989, 30.32733708825981, 68.106585441523691, 31.603551196700209, 68.133932886704542, 32.888881120199585, 68.106585441523691, 34.274485009360433, 68.042774736101705, 35.64185726839969, 67.924269140318032, 36.981882082269294, 67.769300284293223, 38.294559450949237, 67.559636537906741, 39.570773559389636, 67.313509531279109, 40.828756037710264, 67.02180344935006, 42.050275255780434, 66.675402477059336, 43.253562843739928, 66.292538244527464, 44.420387171459879, 65.864094936694187, 45.559864053990168, 65.380956738499194, 46.671993491350804, 64.861355280063108, 47.747659668459164, 64.29617474632559, 48.805094215449571, 63.685415137286668, 49.826065502200436, 63.029076452946327, 50.828805158840623, 62.318042878244277, 51.795081555230354, 61.5705460433011, 52.734010506430423, 60.777470133056532, 53.645592012460838, 59.966162592691383, 54.50247862813012, 59.018117826421978, 55.432291764280308, 58.033609799911488, 56.298294195010385, 57.039985958340679, 57.100485920309438, 56.019014671589048, 57.838866940190201, 54.97981175471682, 58.513437254650853, 53.91326139266377, 59.124196863689576, 52.837595215550436, 59.671145767310009, 51.734581593256252, 60.154283965510331, 50.604220525781223, 60.564495643220653, 49.455627828185612, 60.920012430569841, 48.288803500469442, 61.211718512500738, 47.103747542632732, 61.430498073939816, 45.891344139615143, 61.594582745030493, 44.660709106477007, 61.685740895629351, 43.411842443218291, 61.722204155870713],
       [66.183148463804073, 99.789847847610872, 62.00810516619466, 99.789847847610872, 61.607009303542242, 99.789847847610872, 60.440184975826071, 99.75338458736951, 59.255129017989333, 99.6895738819494, 58.060957245092332, 99.589299916289747, 56.84855384207475, 99.452562690379636, 55.627034623996899, 99.279362204240897, 54.396399590858749, 99.069698457849881, 53.147532927600061, 98.823571451219323, 51.880434634220762, 98.550096999410016, 50.604220525781223, 98.231043472309466, 49.309774787221102, 97.884642500010159, 48.006213233600697, 97.492662452419609, 46.68442004985971, 97.07333495965031, 45.353511051058462, 96.61754420663965, 44.651593291416717, 96.362301384950115, 43.639737819725347, 95.952089707230698, 42.618766532973723, 95.514530584339809, 41.588679431161772, 95.031392386150401, 40.558592329349857, 94.511790927710535, 39.519389412477643, 93.955726209029308, 38.480186495605437, 93.363198230110356, 37.431867763672948, 92.725091175889247, 36.383549031740444, 92.05963667648939, 35.326114484747677, 91.348603101789195, 34.259564122694627, 90.601106266849456, 33.193013760641577, 89.808030356600284, 32.126463398588498, 88.98760700117964, 31.050797221475172, 88.121604570449563, 29.966015229301551, 87.219138879479942, 28.88123323712793, 86.280209928270779, 27.787335429894028, 85.304817716820253, 26.68432180759984, 84.283846430069389, 26.29234176000768, 83.919213827659405, 25.353412808798598, 83.007632321630808, 24.432715487710059, 82.086935000539597, 23.539365611802371, 81.148006049339529, 22.66424736601525, 80.209077098130365, 21.807360750348689, 79.242800701740634, 20.977821579862962, 78.276524305350904, 20.16651403949783, 77.282900463780607, 19.382553944313511, 76.289276622210309, 18.616825479249801, 75.277421150509326, 17.86932864430662, 74.256449863760281, 17.14917925454429, 73.217246946889645, 16.447261494902531, 72.168928214960033, 15.763575365381341, 71.102377852899735, 15.107236681041, 70.026711675789556, 14.47824544188151, 68.941929683620401, 13.858370017782301, 67.83891606132056, 13.26584203886395, 66.726786623970838, 12.700661505126419, 65.596425556490431, 12.153712601509479, 64.456948673960142, 11.62499532801308, 63.308355976359962, 11.53383717741025, 63.107808045040656, 11.03246734909473, 61.93186790225991, 10.54932915089975, 60.746811944420188, 10.1026542129459, 59.56175598658956, 9.6742109051126306, 58.358468398630066, 9.2731150424601765, 57.164296625729548, 8.8993666249886019, 55.951893222709259, 8.5438498376375946, 54.739489819690789, 8.2247963105276938, 53.517970601620618, 7.9239744135383603, 52.287335568480557, 7.65961577679019, 51.056700535340497, 7.4134887701625578, 49.81694968713964, 7.1855933936554939, 48.568083023890722, 6.9941612773895647, 47.310100545570094, 6.8300766063044591, 46.052118067249467, 6.6842235653399484, 44.785019773869863, 6.5657179695562879, 43.517921480490259, 6.474559818953451, 42.241707372049859, 6.410749113531466, 40.956377448550484, 6.3742858532903313, 39.661931709990313, 6.3651700382300467, 38.367485971430142, 6.3742858532903313, 37.191545828649396, 6.4198649285917488, 35.84240519972991, 6.4836756340137347, 34.502380385869401, 6.5930654147371106, 33.180587202130482, 6.7206868255810832, 31.886141463570311, 6.8938873117264441, 30.600811540069117, 7.0853194279923741, 29.333713246689513, 7.3132148044994381, 28.075730768370704, 7.5684576261873531, 26.845095735230643, 7.8510478930561192, 25.632692332219449, 8.1701014201659916, 24.429404744259955, 8.5256182075170273, 23.253464601479209, 8.8993666249886019, 22.086640273759258, 9.3095783027013113, 20.938047576169993, 9.7562532406551554, 19.807686508689585, 10.22115980872956, 18.695557071339863, 10.731645452105401, 17.601659264109912, 11.260362725601791, 16.516877271929843, 11.8255432593393, 15.459442724939436, 12.418071238257649, 14.411123993009824, 13.047062477417169, 13.390152706249864, 13.70340116175751, 12.378297234559795, 14.3870872912787, 11.384673392989498, 15.107236681041, 10.409281181540791, 15.854733515984179, 9.4521206002100371, 16.629577796108201, 8.5040758339400782, 17.44088533647334, 7.583378512859781, 18.279540322019329, 6.6717970068293653, 19.15465856780645, 5.7875629459795164, 20.057124258774419, 4.9124447001904628, 20.968705764802682, 4.0829055297108425, 21.94409797625292, 3.2807138044008752, 22.94683763288398, 2.5423327845201129, 23.976924734695931, 1.8586466550004843, 25.02524346662841, 1.2387712308991468, 26.110025458802031, 0.67359069716076192, 27.2221548961565, 0.17222086884976306, 28.352515963631529, -0.27445406910919701, 29.51934029134771, -0.6573183016407711, 30.713512064244728, -0.97637182875041617, 31.925915467262289, -1.2498462805597228, 33.17478213052101, -1.4503942118808482, 34.441880423900272, -1.60536306791073, 35.736326162460387, -1.6874054034506116, 37.067235161261642, -1.7238686636901548, 37.650647325119728, -1.7147528486293595, 38.945093063679849, -1.66917377333084, 40.212191357059112, -1.5780156227301632, 41.451942205257552, -1.4321625817701715, 42.673461423335389, -1.2407304655007465, 43.867633196232411, -0.99460345887018775, 45.043573339008873, -0.71201319200008584, 46.192166036604469, -0.37472803477066918, 47.322527104079512, 0.017252012819881202, 48.42554072637369, 0.45481113571077003, 49.501206903487031, 0.93794933390927326, 50.567757265540081, 1.4666666074099339, 51.597844367352018, 2.0500787712608144, 39.154756810066353, 2.3144374080093257, 38.069974817892728, 2.3509006682506879, 36.793760709453181, 2.4967537092197745, 35.572241491375308, 2.7519965309093095, 34.396301348598861, 3.1257449483800883, 33.275056096184102, 3.5997673315105203, 32.199389919070768, 4.192295310429472, 31.18753444737942, 4.8942130700706912, 30.221258050989469, 5.7055206104396348, 29.446413770865441, 6.4621332604401687, 28.653337860620869, 7.328135691170246, 27.896725210617412, 8.2397171972006618, 27.167460005794819, 9.2059935935903923, 26.483773876273631, 10.217849065280461, 25.82743519193329, 11.266167797210073, 25.207559767834059, 12.378297234559795, 24.624147603975981, 13.526889932159975, 24.07719870035902, 14.721061705060492, 23.566713056983222, 15.969928368320325, 23.092690673848519, 17.264374106880496, 22.655131550954959, 18.613514735799981, 22.25403568830254, 19.898844659299357, 21.87117145577065, 21.22975365810089, 21.52477048347993, 22.533315211720037, 21.214832771430309, 23.827760950280208, 20.94135831962183, 25.113090873779583, 20.713462943114759, 26.371073352100211, 20.51291501178855, 27.619940015360044, 20.348830340703469, 28.850575048489191, 20.221208929859529, 30.06297845150948, 20.130050779256688, 31.257150224409997, 20.07535588889499, 32.44220618224972, 20.057124258774419, 33.609030509960576, 20.057124258774419, 33.909852406950449, 20.07535588889499, 34.921707878640518, 20.102703334075841, 35.988258240700816, 20.148282409377259, 37.100387678050538, 20.212093114799249, 38.258096190709693, 20.29413545034177, 39.470499593720888, 20.394409416004891, 40.728482072039697, 20.51291501178855, 42.032043625660663, 20.649652237692809, 43.390300069639125, 20.79550527865732, 44.803251403989634, 20.968705764802682, 46.261781813629568, 21.15102206600832, 47.765891298580755, 21.351569997334568, 49.324695673889437, 21.725318414806139, 49.552591050400224, 23.138269749149941, 50.418593481119387, 24.478294563011481, 51.211669391370378, 25.718045411209889, 51.913587151009779, 26.88486973892606, 52.551694205230888, 27.95142010097911, 53.107758923910296, 28.935928127489628, 53.581781307040728, 29.8383938184576, 53.97376135462946, 30.649701358822739, 54.292814881739105, 22.582205030472689, 54.584520963670002, 22.691594811196101, 55.022080086569986, 23.065343228667668, 56.380336530550267, 23.45732327625981, 57.711245529349981, 23.849303323851959, 59.014807082969128, 24.25951500156469, 60.300137006470322, 24.68795830939797, 61.549003669730155, 25.125517432291531, 62.779638702870216, 25.572192370245379, 63.982926290820615, 26.027983123259499, 65.158866433599542, 26.502005506394202, 66.307459131199721, 26.994259519649429, 67.437820198669215, 27.495629347964979, 68.531718005899165, 28.006114991340809, 69.607384183020258, 28.525716449776919, 70.65570291494987, 29.063549538333572, 71.667558386639939, 29.51934029134771, 72.497097557130473, 30.148331530507189, 73.6001111794194, 30.80467021484754, 74.684893171590375, 31.488356344368729, 75.751443533650672, 32.199389919070768, 76.808878080639261, 32.937770938953662, 77.838965182449101, 33.694383588957102, 78.859936469199965, 34.478343684141407, 79.862676125840153, 35.289651224506542, 80.85629996741045, 36.128306210052557, 81.822576363800181, 36.994308640779387, 82.779736945120021, 37.878542701626799, 83.727781711400894, 38.799240022715338, 84.648479032490286, 39.40999963175426, 85.259238641519914, 40.421855103445608, 86.216399222850669, 41.433710575136978, 87.127980728879265, 42.445566046828333, 87.993983159609343, 43.466537333579993, 88.823522330090782, 44.487508620331617, 89.598366610220182, 45.517595722143568, 90.336747630099126, 46.538567008895193, 91.038665389740345, 47.577769925767427, 91.68588825902043, 48.607857027579342, 92.287532053000177, 49.647059944451541, 92.852712586740381, 50.686262861323769, 93.372314045169333, 51.224095949880422, 93.618441051799891, 52.217719791451231, 94.03776854456919, 53.266038523383713, 94.43886440722963, 54.359936330617607, 94.812612824700409, 55.49029739809265, 95.168129612049597, 56.666237540869098, 95.496298954220038, 57.896872574007233, 95.797120851209911, 59.163970867386517, 96.079711118080013, 60.476648236067199, 96.334953939760453, 61.834904680049299, 96.562849316269421, 63.238740199332817, 96.772513062660437, 64.688154793917732, 96.963945178920767, 66.183148463804073, 97.118914034950649, 66.183148463804073, 99.789847847610872],
     ],

 55: [ [67.262350087051502, 95.028036630130373, 55.809931871159151, 86.016297706149999, 26.620593295019411, -2.0062574855401181, 34.683728121739144, -2.0062574855401181, 67.262350087051502, 95.028036630130373],
       [67.262350087051502, 97.775035995120561, 14.871736298732969, 97.775035995120561, 5.4943895455993887, 74.63304853902082, 7.5892235937177333, 73.832663831950413, 7.9647127155502773, 74.52435431953927, 8.7058096665355578, 75.769397197200306, 9.4963130809198191, 76.955152318769251, 10.31646037334353, 78.07173839159077, 11.19589542184603, 79.119155415650312, 12.10497434838798, 80.107284683630496, 13.063459738328911, 81.036126195529505, 14.061470298989081, 81.885917365989371, 15.108887323048229, 82.686302073059778, 16.185948225146831, 83.407636438680129, 17.322296883324238, 84.069683048230218, 17.905293151432659, 84.366121828630639, 18.844015956014001, 84.761373535820894, 19.911195565432791, 85.087456194249171, 21.106831979689019, 85.374013681959696, 22.421043906102881, 85.611164706280761, 23.863712637354212, 85.78902797452065, 25.42495688076318, 85.917484779349252, 27.114657929009581, 85.996535120790213, 28.922934489413649, 86.016297706149999, 55.809931871159151, 86.016297706149999, 67.262350087051502, 95.028036630130373, 67.262350087051502, 97.775035995120561],
     ],

 56: [ [25.462216508672579, 47.104359469900373, 24.101485090742791, 46.032917408540015, 22.794325775881081, 44.982904188400425, 21.56216740531471, 43.93289096826993, 20.38358113781646, 42.904306589360203, 19.279995814613532, 41.897151051680339, 18.240697015092341, 40.900709934610859, 17.26568473925289, 39.914983238160858, 16.354958987095131, 38.939970962319421, 15.50851975861911, 37.986387527709667, 14.726367053824809, 37.032804093099912, 14.008500872712229, 36.111363920330405, 13.35492121528139, 35.189923747560897, 12.93705881135017, 34.568487351969452, 12.10133400348778, 33.207755934039596, 11.36203898114797, 31.847024516109741, 10.72988816494435, 30.486293098179885, 10.1834527136497, 29.12556168025003, 9.7441614684912565, 27.764830262320174, 9.4013000088554008, 26.39338442377084, 9.1548683347421331, 25.0219385852306, 9.0048664461514534, 23.661207167300745, 8.9620087636969572, 22.289761328760505, 8.9727231843105812, 21.41117883843981, 9.0798673904467933, 20.007589738059323, 9.2727269614919692, 18.614715058289221, 9.5620163180597046, 17.253983640359365, 9.9370210395364325, 15.903966643039894, 10.40845554653575, 14.575378486950285, 10.965605418443999, 13.268219172090539, 11.61918507587486, 11.971774277839359, 12.369194518828291, 10.69675822481986, 13.20491932669068, 9.4538854336406075, 14.137073920075689, 8.2217270630808343, 15.154943878369631, 7.0002831131205312, 15.86209563886859, 6.2502736701699178, 16.847822335321659, 5.2859758149406844, 17.876406714229262, 4.3752500627797417, 18.9478487755913, 3.5395252549205907, 20.062148519407831, 2.7573725501297304, 21.219305945678851, 2.0502207896297477, 38.008803047222251, 2.1787938369907351, 37.880229999858791, 2.1787938369907351, 36.358782272724682, 2.2430803606694099, 34.880192228045047, 2.414511090490123, 33.465888707047128, 2.6930860264401417, 32.105157289117329, 3.0895195891498588, 30.797997974255619, 3.6038117785992654, 29.555125183075631, 4.2145337535803264, 28.35511007435014, 4.943114355310172, 27.219381489306361, 5.789553583779707, 26.126510586717071, 6.7324225977808965, 25.097926207809479, 7.7931502385308704, 25.022925263514139, 7.889580024049792, 24.144342773197248, 8.928878823569903, 23.351475647789329, 10.021749726160124, 22.644323887290401, 11.178907152430838, 22.022887491700398, 12.400351102380228, 21.48716646101937, 13.686081576019205, 21.026446374633679, 15.025384152719198, 20.651441653156979, 16.428973253110598, 20.362152296589208, 17.886134456559375, 20.147863884316791, 19.418296604309944, 20.03000525756698, 21.004030855119709, 19.987147575112491, 22.643337209010497, 19.987147575112491, 22.729052573920853, 20.01929083695336, 24.250500301050124, 20.137149463703199, 25.739804766350062, 20.308580193521131, 27.207680390409223, 20.565726288248019, 28.664841593859819, 20.887158906656619, 30.089859535470168, 21.27287804874695, 31.482734215240271, 21.733598135132642, 32.864894474399989, 22.26931916581367, 34.225625892329845, 22.869326720176421, 35.554214048419453, 23.255045862266769, 36.32565233259993, 23.93005436092486, 37.52566744133037, 24.66934938326466, 38.714968129439512, 25.483645349899831, 39.882839976320611, 26.362227840216718, 41.039997402589506, 27.294382433601701, 42.165011567019974, 28.31225239189564, 43.279311310840058, 29.383694453257711, 44.382896634040662, 30.519423038301479, 45.454338695410115, 31.730152567640602, 46.515066336149175, 25.462216508672579, 47.104359469900373],
       [52.516128558064452, 95.908545364940437, 37.065934033223641, 95.608541587760556, 38.340950086244483, 95.576398325920309, 39.915969916446699, 95.437110857950756, 41.405274381739957, 95.179964763219687, 42.819577902737848, 94.826388882969695, 44.148166058826803, 94.344239955360536, 45.401753270620389, 93.765661242219721, 46.569625117505041, 93.069223902339218, 47.662496020094324, 92.265642356320313, 48.669651557774671, 91.354916604159371, 49.52680520686431, 90.390618748930137, 50.330386752885858, 89.308462266950301, 51.016109672157569, 88.140590420069202, 51.594688385293061, 86.89771762888995, 52.076837312906001, 85.569129472800341, 52.441127613769083, 84.165540372419855, 52.708988129109599, 82.676235907119917, 52.869704438313903, 81.111930497540015, 52.923276541382023, 79.461909723040662, 52.923276541382023, 79.215478048919977, 52.8589900177003, 77.651172639329161, 52.708988129109599, 76.140439332810274, 52.473270875609963, 74.672563708749294, 52.141123836587717, 73.258260187749329, 51.723261432656528, 71.886814349210908, 51.21968366381634, 70.568940613729865, 50.619676109453593, 69.293924560710366, 50.523246323931012, 69.122493830889653, 50.041097396318087, 68.276054602420118, 49.462518683182601, 67.376043270869559, 48.776795763910883, 66.422459836259804, 47.983928638502952, 65.426018719190324, 47.105346148186072, 64.365291078449445, 46.108905031119342, 63.261705755239745, 45.02674854914369, 62.10454832897085, 43.837447861031791, 60.904533220249505, 42.541002966783701, 59.64023158784039, 41.158842707626647, 58.333072272980644, 39.658823821719807, 56.961626434440404, 46.858914474072797, 56.629479395409362, 48.337504518752439, 57.647349353710524, 49.741093619136699, 58.643790470770909, 51.069681775225661, 59.629517167230006, 52.301840145792028, 60.58310060183976, 53.458997572063048, 61.525969615839131, 54.541154054038721, 62.447409788610457, 55.526880750491813, 63.347421120150102, 56.437606502649551, 64.226003610470798, 57.273331310511963, 65.093871680170196, 58.01262633285176, 65.940310908650645, 58.687634831509847, 66.765321295899412, 59.266213544645382, 67.568902841920135, 59.459073115690551, 67.858192198480538, 60.326941185393821, 69.240352457640256, 61.076950628347248, 70.61179829618959, 61.719815865164492, 71.98324413472983, 62.234108054618282, 73.354689973270069, 62.64125603793584, 74.704706970589541, 62.930545394503611, 76.054723967899918, 63.101976124321538, 77.404740965219389, 63.15554822738963, 78.733329121310817, 63.134119386162382, 79.69762697654005, 63.005546338798951, 81.06907281508029, 62.780543505912902, 82.419089812399761, 62.437682046277047, 83.736963547869891, 61.99839080111861, 85.033408442119253, 61.451955349823983, 86.308424495140571, 60.798375692393108, 87.551297286319823, 60.037651828826057, 88.772741236269212, 59.180498179736418, 89.962041924389268, 58.205485903896943, 91.119199350659983, 57.134043842534879, 92.265642356320313, 55.955457575036633, 93.369227679519099, 55.794741265832329, 93.508515147490471, 54.755442466311131, 94.376383217200782, 53.651857143108202, 95.169250342609303, 52.516128558064452, 95.908545364940437],
       [36.926646565246557, 99.787165627079958, 35.887347765725373, 99.776451206460479, 34.269470253068683, 99.701450262169601, 32.705164843480077, 99.572877214799519, 31.183717116345949, 99.369303223140378, 29.705127071666311, 99.101442707800743, 28.269394709441169, 98.780010089389179, 26.876520029670498, 98.383576526690376, 25.53721745296793, 97.922856440300166, 24.230058138106219, 97.408564250850759, 22.976470926312629, 96.819271117099561, 21.776455817587141, 96.176405880280072, 20.60858397070248, 95.458539699169705, 19.494284226885949, 94.687101414989229, 18.422842165523889, 93.840662186519694, 17.394257786616318, 92.940650854969135, 16.451388772617719, 92.019210682199628, 15.43351881432377, 90.89419651776916, 14.490649800325169, 89.747753512110648, 13.644210571849131, 88.569167244610071, 12.8942011288957, 87.347723294660682, 12.219192630237609, 86.104850503479611, 11.64061391710208, 84.829834450460112, 11.14775056887555, 83.522675135600366, 10.7513170061716, 82.183372558900373, 10.44059880837659, 80.81192672034922, 10.215595975490571, 79.408337619970553, 10.08702292812711, 77.972605257740724, 10.044165245672639, 76.504729633679744, 10.05487966628627, 75.669004825809679, 10.151309451808849, 74.233272463590765, 10.344169022854, 72.8189689425908, 10.633458379421761, 71.40466542159993, 11.00846310089849, 70.011790741820732, 11.469183187284161, 68.61891606205063, 12.02633305919244, 67.24747022351039, 12.67991271662328, 65.886738805580535, 13.42992215957673, 64.536721808259244, 13.676353833689999, 64.118859404330578, 14.212074864371029, 63.293849017079992, 14.822796839347401, 62.425980947380594, 15.51923417923274, 61.515255195219652, 16.290672463413411, 60.58310060183976, 17.147826112503051, 59.608088326000143, 18.069266285274409, 58.600932788320279, 19.087136243568381, 57.561633988800168, 20.16929272554404, 56.479477506820331, 21.337164572428691, 55.365177763009342, 22.58003736360866, 54.208020336729533, 23.908625519697608, 53.029434069239869, 25.301500199468279, 51.797275698669182, 26.790804664761541, 50.543688486879546, 28.344395653736509, 49.247243592630184, 26.89794887089775, 48.18651595188021, 25.462216508672579, 47.104359469900373, 31.730152567640602, 46.515066336149175, 32.523019693048518, 45.882915519949165, 34.065896261409883, 44.640042728769913, 35.555200726703141, 43.429313199430908, 36.980218668314649, 42.240012511319946, 38.362378927471731, 41.072140664440667, 39.680252662947026, 39.93641207939072, 40.944554295354258, 38.811397914960253, 42.165998245307009, 37.718527012370032, 43.323155671578007, 36.657799371620058, 44.416026574167319, 35.607786151489563, 45.466039794302127, 34.58991619319022, 46.462480911368822, 33.604189496740219, 47.394635504753843, 32.629177220900601, 48.283932415684319, 31.686308206899412, 49.108942802933107, 30.764868034129904, 49.880381087113783, 29.875571123200643, 50.598247268226373, 29.007703053499426, 51.262541346270837, 28.161263825020797, 51.862548900633577, 27.33625343777021, 52.419698772541857, 26.543386312370785, 52.976848644450108, 25.643374980820226, 53.641142722494607, 24.368358927800728, 54.187578173789227, 23.0397707717093, 54.616154998334054, 21.657610512560495, 54.916158775515441, 20.232592570939232, 55.098303925946993, 18.764716946880071, 55.162590449628709, 17.243269219739886, 55.151876029015092, 16.771834712739292, 55.044731822878873, 15.303959088680131, 54.798300148765613, 13.889655567680165, 54.412581006675282, 12.539638570360694, 53.898288817221498, 11.232479255499129, 53.244709159790631, 9.989606464319877, 52.4518420343827, 8.8003057762107346, 51.530401861611352, 7.6538627705504041, 50.469674220862913, 6.5717062885796622, 50.116098340613433, 6.2502736701699178, 49.055370699864987, 5.3931200210809038, 47.919642114821208, 4.6431105781193764, 46.719627006095713, 3.9895309206895035, 45.444610953074893, 3.4323810487803712, 44.094593955758711, 2.9823753830096393, 42.680290434760792, 2.628799502759648, 41.190985969467533, 2.3716534080394922, 39.637394980492559, 2.2216515194504609, 38.008803047222251, 2.1787938369907351, 21.219305945678851, 2.0502207896297477, 22.41932105440435, 1.3966411321998748, 23.662193845584341, 0.79663357782919775, 24.958638739832431, 0.2716269677694072, 26.287226895921378, -0.19980753922936856, 27.669387155078429, -0.59624110194090463, 29.09440509668994, -0.93910256156959804, 30.551566300142358, -1.2176774975196167, 32.062299606662833, -1.4426803304104396, 33.615890595637808, -1.5926822189994709, 35.212339267067279, -1.6891120045202115, 36.851645620951217, -1.7212552663695533, 37.623083905131892, -1.7105408457500744, 39.230246997174987, -1.6569687426799646, 40.805266827377181, -1.5283956953207962, 42.326714554511312, -1.3462505448896991, 43.816019019804571, -1.1105332913903112, 45.262465802643327, -0.79981509358913172, 46.666054903027629, -0.43552479273057543, 48.026786320957427, -0.0069479681897064438, 49.355374477046382, 0.48591538004075119, 50.630390530067217, 1.0323508313394996, 51.873263321247208, 1.6537872269291256, 53.07327842997271, 2.3180813049693825, 54.23043585624373, 3.057376327309612, 55.355450020673878, 3.8609578733303351, 56.426892082035913, 4.7181115224193491, 57.466190881557139, 5.6288372745802917, 58.312630110033147, 6.4431332412095799, 59.341214488940722, 7.5467185644192796, 60.294797923552949, 8.6824471494601312, 61.173380413869829, 9.8396045757308457, 61.955533118664128, 11.039619684459467, 62.662684879163102, 12.261063634410675, 63.284121274753062, 13.514650846200311, 63.830556726047718, 14.811095740449673, 64.280562391819785, 16.128969475930717, 64.655567113296513, 17.489700893860572, 64.944856469864249, 18.871861153009377, 65.159144882136673, 20.29687909463064, 65.277003508886494, 21.743325877459938, 65.319861191340976, 23.221915922140397, 65.309146770727352, 23.886210000189749, 65.234145826432012, 25.289799100570235, 65.062715096614085, 26.693388200959816, 64.816283422500817, 28.07554846011044, 64.494850804092209, 29.446994298659774, 64.076988400160985, 30.80772571658963, 63.58412505193445, 32.157742713900006, 62.994831918185326, 33.497045290599999, 62.330537840140828, 34.825633446689608, 61.591242817801032, 36.132792761560268, 60.75551800993864, 37.439952076420013, 59.844792257780881, 38.725682550049896, 59.598360583667613, 39.047115168459641, 58.998353029304873, 39.807839032029733, 58.323344530646779, 40.611420578050456, 57.58404950830694, 41.436430965299223, 56.769753541671797, 42.30429903500044, 55.880456630741293, 43.204310366540085, 54.916158775515441, 44.147179380539455, 53.887574396607867, 45.122191656380892, 52.783989073404939, 46.129347194060756, 51.616117226520323, 47.168645993589962, 50.362530014726701, 48.24008805495032, 49.044656279251399, 49.35438779875949, 47.651781599480728, 50.50083080441982, 46.194620396028313, 51.679417071920398, 44.651743827666962, 52.900861021869787, 43.044580735623889, 54.154448233670337, 43.644588289986643, 54.529452955139277, 45.294609064484199, 55.590180595889251, 46.858914474072797, 56.629479395409362, 39.658823821719807, 56.961626434440404, 27.840817884896349, 66.776035716509796, 27.744388099373769, 66.872465502030536, 26.630088355557241, 67.997479666459185, 25.612218397263259, 69.133208251509132, 24.680063803878291, 70.30108009839023, 23.844338996015889, 71.479666365890807, 23.09432955306244, 72.690395895229813, 22.440749895631601, 73.911839845179202, 22.215747062745582, 74.35113109033955, 21.594310667155579, 75.765434611339515, 21.112161739542639, 77.17973813233948, 20.769300279906791, 78.583327232719967, 20.555011867634391, 79.997630753719932, 20.490725343952651, 81.401219854100418, 20.544297447020771, 82.601234962830858, 20.747871438679539, 83.994109642599142, 21.090732898315419, 85.333412219299134, 21.594310667155579, 86.640571534160699, 22.247890324586422, 87.883444325339951, 23.051471870607969, 89.094173854680776, 24.0050553052202, 90.240616860339287, 25.097926207809479, 91.354916604159371, 26.126510586717071, 92.222784673860588, 27.262239171760829, 93.015651799269108, 28.451539859872721, 93.701374718539228, 29.715841492279932, 94.290667852290426, 31.055144068982511, 94.762102359289202, 32.458733169366809, 95.137107080759961, 33.92660879343282, 95.394253175489212, 35.458770941180553, 95.554969484690446, 37.065934033223641, 95.608541587760556, 52.516128558064452, 95.908545364940437, 51.326827869952552, 96.583553863600173, 50.094669499386193, 97.194275838579415, 48.819653446365351, 97.740711289870887, 47.491065290276389, 98.222860217489142, 46.119619451732973, 98.640722621419627, 44.705315930735082, 98.98358408105014, 43.237440306669043, 99.272873437619637, 41.726707000148558, 99.49787627051046, 40.173116011173583, 99.658592579709875, 38.565952919130503, 99.755022365230616, 36.926646565246557, 99.787165627079958],
     ],

 57: [ [42.60530352945969, 43.174540305499249, 40.973872405918712, 42.734863832489282, 39.435004750380067, 42.434032561490312, 37.988700562843754, 42.248905625479892, 36.63495984330973, 42.191053457980161, 49.732690565638713, 41.901792620470587, 51.340980822179091, 42.908420334999391, 42.60530352945969, 43.174540305499249],
       [21.038015484917992, 95.310913657809579, 19.811549533887192, 94.443131145289954, 18.63136531685754, 93.494355598269976, 17.47432196682848, 92.476157450240862, 16.351989917300301, 91.376966267709577, 15.27593960177327, 90.196782050679758, 14.22303015324681, 88.935604799149587, 13.216402438721531, 87.605004946619374, 12.6494511972073, 86.818215468600101, 11.7700982511852, 85.510756483070509, 10.96016790616485, 84.168586197030891, 10.19651929514569, 82.814845477500057, 9.5138637186285262, 81.437963890959509, 8.8774898761125485, 80.037941437429254, 8.2989682010980346, 78.614778116889283, 7.7898691270852387, 77.168473929359607, 7.3386222205739102, 75.699028874820215, 6.945227481564018, 74.194872519779892, 6.6096849100555906, 72.679145731250173, 6.3435649395489122, 71.140278075710739, 6.1352971365436701, 69.578269553170685, 5.9848815010398928, 67.99312016363001, 5.8923180330375819, 66.384829907090534, 5.8576067325367092, 64.753398783539524, 5.8807475995372718, 63.434369364509621, 5.9617406340393302, 61.710374772970681, 6.1121562695431058, 60.021091481930853, 6.3319945060486296, 58.389660358379842, 6.6212553435558732, 56.804510968850082, 6.9799387820648908, 55.265643313310647, 7.3964743880753474, 53.784627825269126, 7.8824325950875496, 52.349894071230665, 8.449383836601811, 50.94987161770041, 9.0741872456174804, 49.607701331660792, 9.7684132556349255, 48.323383213130001, 10.52049143315381, 47.07377639510014, 11.353562645174749, 45.882021744570011, 12.244486024697119, 44.724978394540813, 13.216402438721531, 43.625787212009527, 14.29245275424856, 42.515025595990664, 15.472636971278201, 41.415834413459379, 16.69910292230901, 40.409206698930575, 17.96028017384069, 39.495142452409709, 19.256168725873241, 38.685212107389816, 20.575198144906349, 37.967845230370585, 21.94050929794065, 37.343041821359293, 23.340531751475819, 36.822372313839878, 24.775265505511872, 36.394266274330221, 26.244710560048759, 36.058723702819407, 27.748866915086548, 35.815744599320169, 29.28773457062519, 35.676899397309171, 30.872883960165009, 35.630617663309749, 30.907595260665889, 35.630617663309749, 32.226624679699, 35.66532896381068, 33.557224532232432, 35.781033298819239, 34.92253568526673, 35.966160234820563, 36.299417271801303, 36.232280205329516, 37.711010158836757, 36.55625234334002, 39.134173479372521, 36.972787949349367, 40.58047766690882, 37.458746156360576, 42.049922721445739, 38.014126964370007, 43.542508642983222, 38.638930373390394, 45.05823543152129, 39.344726816909315, 46.597103087059963, 40.131516294930407, 48.159111609599186, 40.976157940449411, 49.732690565638713, 41.901792620470587, 36.63495984330973, 42.191053457980161, 35.315930424276623, 42.248905625479892, 33.846485369739703, 42.457173428489114, 32.434892482704242, 42.838997733999349, 31.069581329669941, 43.371237675009979, 29.7736927776374, 44.053893251519185, 28.52408595960603, 44.898534897049103, 27.32076087557579, 45.905162611570631, 26.186858392547322, 47.06220596159983, 25.099237643519992, 48.392805814130043, 25.08766721001971, 48.415946681130663, 24.312448165500228, 49.515137863660129, 23.58351085498191, 50.660610780190837, 22.91242571196506, 51.863935864219457, 22.287622302949391, 53.113542682249317, 21.709100627934848, 54.421001667789824, 21.188431120421772, 55.774742387320657, 20.71404334690985, 57.186335274360317, 20.285937307399109, 58.644209895390304, 19.915683435389809, 60.148366250430627, 19.591711297381661, 61.721945206469172, 19.314020893374671, 63.330235463010467, 19.082612223368869, 64.996377887049675, 18.909055720864501, 66.720372478590434, 18.793351385861602, 68.4790783706394, 18.712358351359569, 70.307206863679312, 18.689217484358998, 72.18161709072956, 18.70078791785928, 73.442794342259731, 18.781780952361309, 75.305634135809669, 18.943767021365371, 77.075910461360763, 19.163605257870898, 78.776764185900902, 19.464436528878451, 80.385054442440378, 19.82311996738747, 81.912351664479502, 20.262796440398521, 83.358655852009178, 20.771895514411309, 84.712396571549107, 21.350417189425819, 85.996714690079898, 21.99836146544212, 87.188469340610027, 22.72729877596041, 88.310801390140114, 23.514088253980191, 89.340569971660443, 24.081039495494419, 89.976943814179322, 25.261223712524071, 91.180268898209761, 26.487689663554882, 92.2216079132304, 27.748866915086548, 93.10096085925943, 29.06789633411967, 93.81832773628048, 30.421637053653679, 94.385278977790222, 31.82165950718883, 94.790244150299259, 33.267963694725161, 95.021652820300005, 34.760549616262672, 95.102645854809452, 21.038015484917992, 95.310913657809579],
       [36.345699005802459, 99.788671422429616, 35.119233054771662, 99.7655305554199, 33.557224532232432, 99.672967087419238, 32.029927310194068, 99.499410584920042, 30.5257709551563, 99.244861047909581, 29.06789633411967, 98.909318476400585, 27.644733013583931, 98.504353303889729, 26.256280993549041, 98.01839509688034, 24.902540274015049, 97.463014288870909, 23.571940421481631, 96.826640446350211, 22.287622302949391, 96.109273569329162, 21.038015484917992, 95.310913657809579, 34.760549616262672, 95.102645854809452, 35.038240020269633, 95.102645854809452, 36.553966808807701, 94.986941519800894, 38.02341186334462, 94.709251115800726, 39.458145617380637, 94.258004209290448, 40.83502720391521, 93.63320080027006, 42.165627056448642, 92.857981755749279, 43.461515608481193, 91.89763577523081, 44.711122426512581, 90.775303725700724, 44.745833727013462, 90.740592425199793, 45.683038840536987, 89.73396471066917, 46.562391786559083, 88.634773528139704, 47.395462998580001, 87.443018877609575, 48.182252476599757, 86.158700759080602, 48.922760220618351, 84.793389606049459, 49.616986230635803, 83.323944551510067, 50.264930506652057, 81.761936028970013, 50.855022615166888, 80.118934471929606, 51.410403423180838, 78.383369446890356, 51.734375561188983, 77.214755663360847, 52.174052034200031, 75.560183672820131, 52.544305906209331, 73.940322982780344, 52.879848477717758, 72.332032726229954, 53.157538881724719, 70.758453770200504, 53.388947551730553, 69.208015681160759, 53.562504054234893, 67.680718459119817, 53.689778822738099, 66.176562104079494, 53.759201423739853, 64.695546616039792, 53.79391272424072, 63.237671995009805, 53.782342290740417, 62.67072075348915, 53.759201423739853, 61.397973068460487, 53.701349256238387, 60.044232348929654, 53.608785788236077, 58.609498594889374, 53.504651886733463, 57.09377180635056, 53.354236251229679, 55.485481549809265, 53.180679748725311, 53.807768692269747, 52.983982379220379, 52.037492366729566, 52.752573709214573, 50.174652573179628, 52.486453738707858, 48.242390178629648, 51.491396457682903, 47.455600700610375, 50.218648772650909, 46.56467732109013, 48.888048920117477, 45.754746976070237, 47.48802646658234, 45.014239232050386, 46.018581412045421, 44.354724522530887, 44.491284190007057, 43.776202847520835, 44.340868554503281, 43.718350680019284, 42.60530352945969, 43.174540305499249, 51.340980822179091, 42.908420334999391, 51.283128654677661, 42.653870797990749, 50.889733915667762, 41.103432708949185, 50.461627876157031, 39.564565053409751, 50.010380969645702, 38.048838264880033, 49.512852329133182, 36.54468190983971, 48.992182821620098, 35.063666421800008, 48.425231580105873, 33.594221367260616, 47.82356903809076, 32.136346746230629, 47.198765629075069, 30.701612992190348, 46.527680486058209, 29.278449671650378, 45.821884042540489, 27.866856784619813, 45.09294673202217, 26.478404764580773, 44.317727687502703, 25.10152317804932, 43.507797342482341, 23.747782458509391, 42.674726130461437, 22.405612172480687, 41.795373184439342, 21.075012319950474, 40.892879371416683, 19.767553334420882, 40.071378592896053, 18.645221284890795, 38.960616976868153, 17.198917097350204, 37.849855360840252, 15.822035510820569, 36.727523311312069, 14.503006091779753, 35.605191261783858, 13.253399273749892, 34.471288778755401, 12.073215056720073, 33.337386295726901, 10.962453440690297, 32.203483812698437, 9.9211144256696571, 31.058010896169659, 8.9376275781396544, 29.90096754614061, 8.0351337651190988, 28.743924196111521, 7.1904921196000942, 27.586880846082469, 6.4152730750793125, 26.418267062553131, 5.6979061980600818, 25.249653279023761, 5.0615323555502982, 24.520715968505471, 4.6797080500400625, 23.09755264796971, 4.0086229070202535, 21.651248460433379, 3.3953899315001763, 20.19337383939677, 2.840009123490745, 18.712358351359569, 2.3540509164795367, 17.208201996321801, 1.9259448769698793, 15.69247520778373, 1.5556910049599537, 14.15360755224506, 1.2548597339500702, 12.591599029705829, 1.0118806304399186, 11.018020073666319, 0.83832412794072297, 9.4213002506262171, 0.71104935943913006, 7.8014395605855213, 0.66476762543970835, 7.8014395605855213, -2.0080025131301227, 11.9089434531887, -2.0080025131301227, 12.070929522192751, -2.0080025131301227, 13.66764934523286, -1.9732912126291922, 15.2412283012724, -1.8922981781306589, 16.803236823811631, -1.7534529761196609, 18.353674912850551, -1.5683260401201551, 19.892542568389221, -1.3253469366100035, 21.41983979042757, -1.0360860991095251, 22.92399614546537, -0.6889730941002199, 24.416582067002849, -0.29557835508967401, 25.897597555040051, 0.15566855142060376, 27.35547217607666, 0.65319719193939818, 28.813346797113269, 1.2085779999506485, 30.248080551149311, 1.8218109754598117, 31.67124387168505, 2.4813256849793106, 33.071266325220222, 3.1871221285000502, 34.471288778755401, 3.9507707395205216, 35.848170365289981, 4.7722715180407249, 37.213481518324272, 5.6400540305603499, 38.185397932348678, 6.2879983065795386, 39.527568218382392, 7.2020625531004043, 40.84659763741552, 8.1508381001203816, 42.130915755947761, 9.1227545141500741, 43.380522573979157, 10.117811795169473, 44.60698852500996, 11.136009943200406, 45.79874317553989, 12.177348958219227, 46.967356959069257, 13.230258406749272, 48.11282987559801, 14.317879155780247, 49.212021058125629, 15.417070338309713, 50.299641807152931, 16.550972821329196, 51.352551255679401, 17.696445737859904, 52.370749403704963, 18.876629954889722, 53.354236251229679, 20.068384605419851, 54.326152665254092, 21.2832801229506, 55.251787345277343, 22.521316507480151, 56.154281158299987, 23.794064192519727, 57.03363410432209, 25.078382311050518, 57.878275749843311, 26.385841296580111, 58.699776528363941, 27.716441149119419, 59.48656600638369, 29.070181868650252, 59.625411208387192, 29.31316097214949, 60.389059819406363, 30.713183425690659, 61.117997129924682, 32.124776312730319, 61.800652706441809, 33.547939633259375, 62.448596982458099, 34.982673387299656, 63.061829957973487, 36.428977574829332, 63.62878119948774, 37.886852195870233, 64.161021140501106, 39.356297250409625, 64.658549781013591, 40.825742304939922, 65.109796687524948, 42.318328226479935, 65.514761860035094, 43.822484581520257, 65.896586165544704, 45.32664093656058, 66.220558303552821, 46.853938158599703, 66.521389574560402, 48.381235380629732, 66.775939111566771, 49.931673469669477, 66.995777348072295, 51.482111558709221, 67.169333850576663, 53.044120081249275, 67.308179052580158, 54.61769903728964, 67.400742520582469, 56.214418860330625, 67.458594688083934, 57.811138683369791, 67.481735555084498, 59.419428939909267, 67.481735555084498, 59.616126309419997, 67.458594688083934, 61.316980033960135, 67.377601653581905, 62.983122457999343, 67.250326885078692, 64.63769444854006, 67.088340816074634, 66.257555138579846, 66.86850257956911, 67.854274961620831, 66.602382609062431, 69.416283484160886, 66.289980904554568, 70.95515113970032, 65.931297466045564, 72.482448361739443, 65.526332293535404, 73.963463849779146, 65.063514953523764, 75.432908904309443, 64.56598631301128, 76.867642658349723, 64.022175938497611, 78.290805978880599, 63.420513396482498, 79.667687565419328, 62.784139553966519, 81.032998718450472, 62.089913543949081, 82.37516900449009, 61.34940579993048, 83.682627990019682, 60.574186755410999, 84.966946108550474, 59.741115543390087, 86.228123360080644, 58.861762597367992, 87.454589311120799, 57.936127917344741, 88.657914395149419, 56.964211503320342, 89.838098612170143, 56.57081676431045, 90.289345518689515, 55.425343847781697, 91.504241036220265, 54.256730064252338, 92.649713952740058, 53.053404980222119, 93.702623401270102, 51.826939029191323, 94.674539815299795, 50.565761777659652, 95.56546319482004, 49.281443659127369, 96.363823106339623, 47.962414240094233, 97.081189983360673, 46.608673520560238, 97.717563825870457, 45.231791934025658, 98.272944633890802, 43.820199046990211, 98.735761973899571, 42.385465292954159, 99.117586279409807, 40.916020238417268, 99.406847116910285, 39.423434316879771, 99.626685353419816, 37.896137094841407, 99.75396012191959, 36.345699005802459, 99.788671422429616],
     ],

 58: [ [20.704347128054479, 14.068239295800595, 20.658768052753089, 14.068239295800595, 19.382553944313511, 13.967965330139123, 18.188382171416521, 13.676259248210044, 17.076252734062049, 13.202236865070518, 16.037049817189821, 12.536782365670661, 15.079889235860181, 11.68901156506945, 15.01607853043819, 11.616085044579449, 14.1774235448922, 10.631577018069947, 13.5393164906724, 9.5832582861403353, 13.07440992259799, 8.4620130337207229, 12.80093547078954, 7.2587254457703239, 12.700661505126419, 5.9916271523907199, 12.709777320186699, 5.9460480770903814, 12.80093547078954, 4.6698339686499821, 13.092641552718559, 3.4756621957494644, 13.56666393585326, 2.3635327583997423, 14.232118435253881, 1.3243298415200115, 15.079889235860181, 0.36716926018925733, 15.11635249610128, 0.33982181501050945, 16.07351307743096, -0.50794898559070134, 17.112715994303159, -1.1642876699297631, 18.233961246717911, -1.63831005306929, 19.428133019614929, -1.9209003199393919, 20.704347128054479, -2.0120584705400688, 20.8046210937176, -2.0120584705400688, 22.071719387096859, -1.9026686898196203, 23.256775344933601, -1.6109626078905421, 24.37802059734835, -1.1369402247491962, 25.42633932928084, -0.48060154041013448, 26.401731540731081, 0.36716926018925733, 26.429078985911929, 0.39451670538073813, 27.276849786518198, 1.3607931017595547, 27.933188470858539, 2.3999960186392855, 28.398095038932951, 3.5121254559908266, 28.68068530580172, 4.7154130439503206, 28.780959271464809, 5.9916271523907199, 28.780959271464809, 6.0463220427500346, 28.68068530580172, 7.3225361511904339, 28.398095038932951, 8.5258237391499279, 27.94230428591883, 9.6561848066194216, 27.295081416638769, 10.704503538550853, 26.474658061213351, 11.68901156506945, 26.347036650369368, 11.807517160850693, 25.371644438919159, 12.618824701210542, 24.323325706986651, 13.256931755429832, 23.192964639511612, 13.703606693390611, 21.989677051554342, 13.977081145199918, 20.704347128054479, 14.068239295800595],
       [20.850200169019018, 68.061211897849716, 19.564870245519181, 67.970053747250859, 18.361582657561879, 67.696579295439733, 17.23122159008684, 67.231672727370096, 16.192018673214641, 66.593565673150806, 15.22574227682469, 65.754910687599477, 15.15281575634242, 65.68198416712039, 14.323276585856719, 64.706591955669865, 13.676053716576661, 63.658273223740252, 13.220262963562529, 62.527912156259845, 12.93767269669376, 61.333740383359327, 12.84651454609096, 60.066642089979723, 12.84651454609096, 60.021063014679385, 12.94678851175405, 58.744848906240804, 13.2384945936831, 57.550677133349382, 13.71251697681779, 56.429431880929769, 14.37797147621842, 55.399344779119929, 15.22574227682469, 54.442184197789175, 15.262205537065819, 54.405720937549631, 16.21936611839547, 53.567065952000121, 17.258569035267701, 52.901611452600264, 18.370698472622159, 52.436704884530627, 19.57398606057944, 52.154114617660525, 20.850200169019018, 52.062956467059848, 20.950474134682111, 52.062956467059848, 22.217572428061398, 52.163230432719502, 23.402628385898112, 52.454936514650399, 24.523873638312871, 52.938074712839807, 25.572192370245379, 53.594413397180688, 26.547584581695592, 54.442184197789175, 27.377123752181319, 55.399344779119929, 28.015230806401089, 56.447663511049541, 28.4801373744755, 57.568908763469153, 28.75361182628399, 58.772196351419552, 28.853885791947079, 60.066642089979723, 28.853885791947079, 60.121336980349952, 28.75361182628399, 61.397551088779437, 28.47102155941522, 62.60083867674075, 28.006114991340809, 63.722083929160362, 27.368007937121039, 64.77951847615077, 26.547584581695592, 65.754910687599477, 26.502005506394202, 65.800489762899815, 25.517497479883669, 66.611797303270578, 24.46006293289091, 67.249904357489868, 23.329701865415871, 67.705695110500528, 22.126414277458569, 67.979169562309835, 20.850200169019018, 68.061211897849716],
     ],

 59: [ [12.34514471777541, 0.076386541539250175, 13.1837997033214, -0.64376284823083552, 14.20477099007303, -1.2454066421996686, 15.33513205754806, -1.673849950040676, 16.59311453586707, -1.9290927717302111, 17.969602609969741, -2.0111351072700927, 18.270424506959039, -2.0111351072700927, 19.51929117021777, -1.8197029910006677, 20.704347128054479, -1.3639122379900073, 22.24491987324225, -0.57995214279981155, 23.411744200958388, -0.087698129549607984, 24.16835685096186, 0.076386541539250175, 12.34514471777541, 0.076386541539250175],
       [19.555754430458901, 14.424679446419759, 18.543898958767532, 14.379100371119421, 17.285916480448549, 14.187668254859091, 16.100860522611811, 13.841267282559784, 14.99784690031762, 13.34901326930958, 13.95864398344542, 12.701790400029495, 12.992367587055471, 11.899598674719527, 12.51834520392077, 11.434692106649891, 11.70703766355564, 10.450184080140389, 11.06893060933583, 9.4018653482107766, 10.613139856321711, 8.2806200957893452, 10.34878121957354, 7.0955641379496228, 10.2576230689707, 5.8466974747007043, 10.2576230689707, 5.7828867692805943, 10.33966540451325, 4.3881670650498563, 10.59490822620117, 3.1210687716702523, 11.01423571897416, 1.9815918891399633, 11.597647882832231, 0.96973641744989436, 12.34514471777541, 0.076386541539250175, 24.16835685096186, 0.076386541539250175, 24.16835685096186, 0.076386541539250175, 25.171096507592949, -0.57083632774083526, 25.64511889072762, -1.5735759843701089, 25.81831937687301, -2.8771375379892561, 25.81831937687301, -3.3693915512503736, 25.73627704133045, -4.5909107693296392, 25.563076555185091, -5.7850825422301568, 25.289602103376609, -6.9701385000607843, 24.934085316025602, -8.1369628277807351, 24.487410378071761, -9.2946713404307957, 23.94957728951508, -10.43414822297018, 23.32058605035559, -11.555393475380697, 22.60043666059326, -12.667522912739514, 21.789129120228129, -13.77053653503026, 21.707086784685568, -13.861694685629118, 20.94135831962183, -14.773276191659534, 20.111819149136121, -15.630162807330635, 19.236700903349, -16.45058616274946, 18.2977719521399, -17.225430442880679, 17.3132639256294, -17.954695647700646, 16.264945193696889, -18.647497592279251, 15.171047386462989, -19.28560464650036, 14.022454688867381, -19.887248440480107, 12.8191671009101, -20.434197344100539, 11.561184622591099, -20.944682987479609, 10.2576230689707, -21.409589555549246, 10.2576230689707, -24.581893196529563, 10.831919417768489, -24.390461080260138, 12.235754937052009, -23.889091251949139, 13.594011381034109, -23.369489793509274, 14.8975729346545, -22.822540889890661, 16.155555412973509, -22.257360356150457, 17.35884300093079, -21.6648323772406, 18.50743569852639, -21.054072768200058, 19.610449320820582, -20.415965713980768, 20.658768052753089, -19.750511214579092, 21.66150770938415, -19.066825085059463, 22.618668290713831, -18.364907325420063, 23.51201816662152, -17.635642120589182, 24.36890478228807, -16.879029470590467, 25.171096507592949, -16.104185190470162, 25.918593342536099, -15.311109280219171, 26.611395287117571, -14.490685924789432, 27.368007937121039, -13.50617789827993, 28.124620587124468, -12.421395906110774, 28.80830671664566, -11.318382283820029, 29.428182140744902, -10.197137031400416, 29.966015229301551, -9.0667759639291035, 30.430921797375959, -7.9181832663307432, 30.832017660028392, -6.7604747536697687, 31.160187002198569, -5.5845346108999365, 31.4063140088262, -4.3903628379994188, 31.588630310031849, -3.1779594349791296, 31.698020090755222, -1.956440216910778, 31.73448335099636, -0.71668936870992184, 31.725367535936069, -0.033003239190293243, 31.643325200393551, 1.3526006499796495, 31.479240529308441, 2.6835096487793635, 31.242229337741101, 3.9506079421607865, 30.914059995570941, 5.1538955301202805, 30.503848317858228, 6.311604042770341, 30.011594304602969, 7.3963860349394963, 29.446413770865441, 8.4264731367602508, 28.790075086525089, 9.4018653482107766, 28.060809881702511, 10.313446854239373, 27.258618156397631, 11.133870209660017, 26.25587849976657, 11.999872640390095, 25.22579139795463, 12.747369475329833, 24.159241035901569, 13.34901326930958, 23.056227413607392, 13.813919837379217, 21.916750531072068, 14.151204994610453, 20.749926203355901, 14.351752925940673, 19.555754430458901, 14.424679446419759],
       [20.348830340703469, 68.135061781609693, 19.063500417203642, 68.043903630999921, 17.851097014186049, 67.761313364129819, 16.7298517617713, 67.305522611119159, 15.6906488448991, 66.658299741840892, 14.72437244850914, 65.828760571350358, 14.68790918826801, 65.792297311110815, 13.849254202722021, 64.835136729780061, 13.19291551838168, 63.795933812909425, 12.718893135246979, 62.683804375559703, 12.43630286837822, 61.480516787600209, 12.34514471777541, 60.204302679159809, 12.34514471777541, 60.158723603859471, 12.445418683438501, 58.882509495420891, 12.73712476536755, 57.688337722520373, 13.211147148502249, 56.576208285170651, 13.86748583284259, 55.537005368300015, 14.72437244850914, 54.579844786969261, 14.751719893689989, 54.552497341790513, 15.70888047501967, 53.704726541180207, 16.748083391891871, 53.048387856839327, 17.86932864430662, 52.5743654736998, 19.063500417203642, 52.291775206829698, 20.348830340703469, 52.20061705623084, 20.449104306366589, 52.20061705623084, 21.707086784685568, 52.310006836960383, 22.90125855758259, 52.601712918889461, 24.02250380999735, 53.075735302019893, 25.061706726869549, 53.732073986360774, 26.03709893831979, 54.579844786969261, 26.866638108805489, 55.54612118336081, 27.51386097808555, 56.585324100229627, 27.978767546159961, 57.715685167699121, 28.25224199796844, 58.918972755660434, 28.343400148571249, 60.204302679159809, 28.25224199796844, 61.489632602659185, 27.978767546159961, 62.692920190620498, 27.51386097808555, 63.823281258089992, 26.866638108805489, 64.862484174969723, 26.03709893831979, 65.828760571350358, 26.000635678078648, 65.865223831600815, 25.01612765156813, 66.68564718701964, 23.95869310457536, 67.314638426179954, 22.828332037100321, 67.770429179199709, 21.625044449143019, 68.043903630999921, 20.348830340703469, 68.135061781609693],
     ],

 60: [ [80.239735286759725, 84.498814118749578, 2.6823807538759179, 50.907035621599789, 2.6823807538759179, 47.370099378220402, 80.239735286759725, 13.486614799139716, 80.239735286759725, 19.977075122060342, 13.49373741537101, 49.247957280629635, 80.239735286759725, 78.22713335726985, 80.239735286759725, 84.498814118749578],
     ],

 61: [ [80.458514848206534, 40.16035396946063, 2.6823807538759179, 40.16035396946063, 2.6823807538759179, 34.253305810399979, 80.458514848206534, 34.253305810399979, 80.458514848206534, 40.16035396946063],
       [80.458514848206534, 63.670041009929264, 2.6823807538759179, 63.670041009929264, 2.6823807538759179, 57.753877035809637, 80.458514848206534, 57.753877035809637, 80.458514848206534, 63.670041009929264],
     ],

 62: [ [17.016007198974918, 71.65937211084929, 32.070464792844987, 71.65937211084929, 80.242709715952984, 50.617460893119642, 80.242709715952984, 47.083550659819593, 2.6885254245271559, 13.481112784300421, 2.6885254245271559, 19.680601022149858, 69.499622606712393, 48.668761821609223, 17.016007198974918, 71.65937211084929],
     ],

 63: [ [31.73502613442372, 14.132273424480445, 31.11813251291537, 14.111361776289414, 29.717052084404859, 13.902245294419117, 28.410074072734599, 13.442189034320108, 27.207654301997991, 12.752104644150677, 26.109792772194972, 11.831992123939926, 25.587001567526869, 11.256921798800249, 24.771447288244651, 10.10678114852999, 24.196376963109739, 8.8520822573300393, 23.85133476802881, 7.5032809492895467, 23.736320703001809, 6.0603772243994172, 23.757232351188549, 5.4121161306102294, 23.98726048124249, 4.0110357021003438, 24.44731674135042, 2.7145135145201493, 25.158312779699031, 1.5225495678805601, 26.109792772194972, 0.43514386217066203, 26.58030485639625, -0.014456573839197517, 27.719989682572731, -0.86137832540043746, 28.953776925589441, -1.457360298729327, 30.292122409539761, -1.8233141419896128, 31.73502613442372, -1.9383282070193673, 32.435566348678982, -1.9174165588392498, 33.826190953096102, -1.6873884287797409, 35.122713140673, -1.216876344580669, 36.314677087316262, -0.50588030622930091, 37.422994441212609, 0.43514386217066203, 37.883050701320542, 0.90565594636973401, 38.719516628789513, 2.0453407725508441, 39.325954426204511, 3.2791280155706772, 39.681452445378788, 4.6174734995202016, 39.806922334499149, 6.0603772243994172, 39.77555486221906, 6.8027407350291469, 39.545526732165087, 8.2038211635408516, 39.095926296150537, 9.5107991752101952, 38.405841905988638, 10.723674770040816, 37.496185209866148, 11.831992123939926, 36.95248235701132, 12.312960032229967, 35.802341706741522, 13.107602663330908, 34.547642815538069, 13.682672988459672, 33.188385683401037, 14.017259359450691, 31.73502613442372, 14.132273424480445],
       [16.772741856822758, 96.074566844150468, 15.68533615111309, 95.35311498170995, 14.6397537417769, 94.568928174710891, 13.64645045290751, 93.732462247240619, 12.79952870134519, 92.94827544023974, 11.73303464382229, 91.83995808634063, 10.77109882723297, 90.710729084259583, 9.9032654274839444, 89.550132609900174, 9.1399902686685266, 88.368624487349734, 8.4812733507867222, 87.155748892519114, 7.9271146738385312, 85.911505825410131, 7.4670584137305971, 84.646351110110118, 7.1115603945563057, 83.349828922529923, 6.8501647922222437, 82.032395086769611, 6.7037832549151801, 80.683593778720024, 6.6515041344483734, 79.313880822490319, 6.6515041344483734, 78.937471155140884, 6.7456065512886312, 77.30636259656967, 6.9756346813425969, 75.800723927130093, 7.3311327005168891, 74.420555146800325, 7.8121006088115621, 73.165856255600374, 8.4289942303199155, 72.026171429419264, 9.1713577409485936, 71.022412316460759, 9.8405304829237821, 70.269592981740061, 10.95930366091349, 69.265833868770642, 12.14081178346339, 68.554837830430188, 13.364143202386741, 68.136604866689595, 14.650209565870281, 67.990223329390574, 14.984795936857861, 68.000679153479723, 16.35450889308828, 68.251618931719349, 17.58829613610499, 68.847600905039144, 18.686157665907981, 69.788625073439107, 19.020744036895561, 70.165034740799456, 19.752651723430908, 71.325631215169778, 20.202252159445472, 72.64306505093009, 20.348633696752529, 74.117336248100401, 20.327722048565821, 74.514657563640867, 20.118605566698559, 75.602063269350765, 19.700372602964109, 76.888129632839991, 19.05211150917566, 78.362400829999387, 18.1842781094266, 80.024876860839868, 17.494193719264729, 81.363222344789392, 16.84593262547628, 82.827037717859639, 16.38587636536835, 84.186294850000195, 16.114024938940961, 85.44099374120924, 16.0199225221007, 86.5911343914795, 16.040834170287411, 87.113925596140689, 16.270862300341371, 88.368624487349734, 16.741374384542659, 89.581500082180355, 17.452370422891281, 90.752552380630732, 18.41430623948056, 91.902693030899172, 19.627181834310559, 93.011010384800102, 20.0035915016716, 93.303773459410877, 21.070085559194531, 94.014769497760426, 22.230682033557692, 94.610751471080221, 23.485380924761131, 95.091719379379356, 24.844638056898191, 95.478584870830673, 26.29799760587548, 95.750436297259512, 27.845459571693059, 95.907273658660415, 29.497479778444241, 95.959552779129808, 16.772741856822758, 96.074566844150468],
       [32.602859534172751, 99.995500879169413, 31.96505426447769, 99.995500879169413, 30.344401530006571, 99.94322175870002, 28.765572091908918, 99.828207693670265, 27.239021774278061, 99.650458684089244, 25.764750577114029, 99.420430554029736, 24.34275850041681, 99.117211655320716, 22.95213389599968, 98.76171363614958, 21.62424423614269, 98.343480672419901, 20.33817787265917, 97.872968588209915, 19.10439062964247, 97.329265735359513, 17.912426682999211, 96.733283762039719, 16.772741856822758, 96.074566844150468, 29.497479778444241, 95.959552779129808, 30.37576900228666, 95.938641130940596, 31.797761078983878, 95.813171241819873, 33.167474035214298, 95.562231463580247, 34.495363695071262, 95.196277620310866, 35.77097423446142, 94.715309712020826, 37.004761477478127, 94.119327738690117, 38.186269600028062, 93.408331700349663, 39.325954426204511, 92.571865772879391, 40.423815956007502, 91.620385780379365, 41.458942541250337, 90.553891722860499, 41.511221661717137, 90.51206842648935, 42.337231765092753, 89.497853489430781, 43.090051099814787, 88.420903607810033, 43.759223841789982, 87.281218781639836, 44.355205815111582, 86.089254834989333, 44.867541195686321, 84.834555943789383, 45.306685807607522, 83.506666283930826, 45.662183826781842, 82.126497503610153, 45.934035253209252, 80.683593778720024, 46.132695910983131, 79.188410933369596, 46.2477099760101, 77.620037319369658, 46.289533272383551, 75.988928760809358, 46.289533272383551, 75.758900630749849, 46.2477099760101, 74.305541081779666, 46.132695910983131, 72.873093180980504, 45.954946901395971, 71.440645280190438, 45.704007123155293, 70.018653203500435, 45.379876576261061, 68.607116950890486, 44.993011084806668, 67.195580698289632, 44.857085371592973, 66.735524438179709, 44.51204317651203, 65.721309501119322, 44.104266036870911, 64.633903795409424, 43.633753952669622, 63.452395672869898, 43.090051099814787, 62.197696781660852, 42.483613302399817, 60.84889547362036, 41.803984736331273, 59.426903396919442, 41.061621225702559, 57.921264727479866, 40.246066946420342, 56.331979465279801, 39.378233546671311, 54.648591786250108, 38.970456407030177, 53.885316627440261, 38.123534655467871, 52.233296420690749, 37.328892024372351, 50.654466982590748, 36.586528513743673, 49.127916664960139, 35.885988299488417, 47.664101291889892, 35.248183029793317, 46.263020863380007, 34.641745232378327, 44.924675379430482, 34.09804237952352, 43.638609015939437, 33.596162823042143, 42.425733421110635, 33.146562387027593, 41.265136946749408, 32.749241071479808, 40.156819592859392, 32.393743052305531, 39.121693007609792, 32.090524153598011, 38.1388455428405, 31.91277514401088, 37.521951921329673, 31.599100421210011, 36.329987974690084, 31.295881522502501, 35.07528908347922, 31.034485920168461, 33.768311071809876, 30.78354614192779, 32.40905393966932, 30.55351801187382, 30.997517687070285, 30.35485735409992, 29.523246489910889, 30.177108344512789, 27.996696172269367, 30.030726807205731, 26.407410910080216, 29.894801093992019, 24.765846527430767, 29.790242853058398, 23.072003024299192, 32.73878524738646, 23.072003024299192, 32.822431840133362, 24.305790267320845, 32.979269201533782, 25.999633770439686, 33.167474035214298, 27.609830680819869, 33.397502165268271, 29.146836822539626, 33.669353591695682, 30.600196371520724, 33.983028314496522, 31.969909327750429, 34.338526333670842, 33.276887339419773, 34.725391825125229, 34.489762934250393, 35.154080612953067, 35.639903584520653, 35.624592697154362, 36.69594181795037, 35.812797530834871, 37.082807309410782, 36.210118846382642, 37.825170820040512, 36.691086754677293, 38.630269275230603, 37.234789607532093, 39.508558499070205, 37.862139053133831, 40.449582667470168, 38.573135091482442, 41.453341780430492, 39.357321898484571, 42.519835837949358, 40.214699474140268, 43.659520664130469, 41.145267818449462, 44.851484610770058, 42.159482755505593, 46.116639326070072, 43.257344285308591, 47.454984810019596, 44.417940759671779, 48.845609414440332, 45.662183826781842, 50.309424787510579, 46.990073486638799, 51.835975105139369, 48.380698091055962, 53.425260367330338, 49.509927093139048, 54.74269420309065, 50.607788622942053, 56.060128038860057, 51.632459384091533, 57.346194402340188, 52.583939376587459, 58.600893293540139, 53.472684424523237, 59.824224712470823, 54.288238703805462, 61.016188659110412, 55.030602214434161, 62.166329309380671, 55.710230780502677, 63.295558311459899, 56.316668577917682, 64.382964017169797, 56.84991560667914, 65.449458074699578, 57.320427690880422, 66.474128835849115, 57.728204830521548, 67.49879959700047, 58.230084387002897, 68.920791673690474, 58.65877317483077, 70.342783750389572, 59.003815369911699, 71.754320002999521, 59.275666796339117, 73.155400431509406, 59.474327454112988, 74.535569211830079, 59.589341519139971, 75.915737992150753, 59.631164815513422, 77.285450948380458, 59.599797343233348, 78.341489181810175, 59.484783278206351, 79.753025434420124, 59.286122620432479, 81.133194214740797, 58.99335954581835, 82.492451346879534, 58.616949878457319, 83.830796830830877, 58.14643779425603, 85.14823066658937, 57.581823293214477, 86.434297030069501, 56.933562199426042, 87.699451745369515, 56.191198688797328, 88.933238988389348, 55.354732761328393, 90.156570407309118, 54.434620241112519, 91.348534353959622, 54.183680462871841, 91.651753252659546, 53.336758711309528, 92.61368906925054, 52.42710201518701, 93.502434117190205, 51.475622022691077, 94.338900044660477, 50.471862909728351, 95.123086851659536, 49.40536885220542, 95.844538714100054, 48.29705149830906, 96.50325563198021, 47.125999199852508, 97.109693429400068, 45.91312360502252, 97.663852106339618, 44.647968889725739, 98.155275838729722, 43.320079229868753, 98.583964626559464, 41.95036627363833, 98.960374293919813, 40.51791837284776, 99.2740490167198, 39.043647175683731, 99.53544461905949, 37.506641033959511, 99.744561100920691, 35.927811595861868, 99.880486814139658, 34.286247213204028, 99.9745892309802, 32.602859534172751, 99.995500879169413],
     ],

 64: [ [132.34781478846779, 12.407730631750383, 128.1715936998161, 12.407730631750383, 127.7345473068176, 11.39766785681968, 127.13239449868639, 10.067104393690897, 126.51081740642201, 8.7559652146992448, 125.8698160300243, 7.4739624619105598, 125.21910251156, 6.2113839932408155, 124.5489647089623, 4.9682298087100207, 123.8691147642981, 3.7542120503803744, 123.16012839343399, 2.5596185761896777, 122.44142988050319, 1.3844493861306546, 121.7033070834392, 0.23841662226004701, 120.9554721443085, -0.88819185746979201, 120.17850077897801, -1.9953760530606814, 119.39181727158081, -3.0734238224595174, 118.595421622117, -4.1320473077194038, 117.7698895464532, -5.1712465088494355, 116.93464532872289, -6.1910214258496126, 116.07997682685929, -7.1816599166395463, 115.2058840408624, -8.1431619812392455, 114.3220791127989, -9.0949519037694699, 113.4188499006021, -10.017605400100365, 112.4961964042721, -10.911122470230112, 111.56383076587539, -11.794927398290383, 110.60232870127891, -12.649595900160421, 109.6311144946156, -13.475127975820214, 108.65018814588581, -14.290947909419629, 107.6401253709561, -15.077631416810618, 106.6203504539597, -15.835178498009554, 105.5811512528301, -16.583013437140835, 104.5322399096339, -17.301711950080062, 104.396269920701, -17.389121228679869, 103.2599492989051, -18.117531883670381, 102.11391653504251, -18.826518254529219, 100.9484594870467, -19.496656057130167, 99.783002439050875, -20.147369575599441, 98.607833248988385, -20.768946667860291, 97.42295191685929, -21.371099475989467, 96.21864630059693, -21.934403715860753, 95.01434068433457, -22.468571529519977, 93.800322926005578, -22.983315059049346, 92.576593025609924, -23.468922162379386, 91.333438841081048, -23.925392839519191, 90.090284656552157, -24.352727090450571, 88.837418329956634, -24.750924915180804, 87.565127719227846, -25.129698455779362, 86.292837108499057, -25.469623428109117, 85.010834355703651, -25.790124116310835, 83.709407318774964, -26.081488378309587, 82.407980281846264, -26.343716214110827, 81.087128960784327, -26.576807623709101, 79.766277639722375, -26.790474749170244, 78.435714176593805, -26.965293306369858, 77.085726429331956, -27.120687579439618, 75.735738682070121, -27.246945426310049, 74.366326650675006, -27.344066846970236, 72.996914619279892, -27.412051841440189, 71.617790445818173, -27.450900409699898, 70.21924198822316, -27.460612551769373, 46.191402515375671, -27.54802183036918, 47.434556699904547, -28.014204649569365, 48.697135168566717, -28.45125104257022, 49.959713637228873, -28.868873151430307, 51.222292105891029, -29.247646692030685, 52.50429485868645, -29.606995948499389, 53.79600975354851, -29.946920920829143, 55.08772464841055, -30.247997324890093, 56.389151685339243, -30.529649444830284, 57.700290864334562, -30.782165138560231, 59.021142185396513, -31.005544406090848, 60.351705648525098, -31.209499389489793, 61.68226911165366, -31.384317946689407, 63.02254471684887, -31.530000077689692, 64.372532464110719, -31.646545782490648, 65.732232353439201, -31.74366720315993, 67.101644384834273, -31.811652197620788, 68.480768558296035, -31.850500765889592, 69.859892731757782, -31.860212907960886, 69.918165584157578, -31.860212907960886, 71.326426183819194, -31.850500765889592, 72.715262499347574, -31.811652197620788, 74.094386672809321, -31.74366720315993, 75.473510846271054, -31.656257924560123, 76.833210735599536, -31.539712219759167, 78.183198482861371, -31.394030088760701, 79.523474088056588, -31.228923673619647, 80.854037551185158, -31.034680832290178, 82.184601014313728, -30.821013706830854, 83.495740193309075, -30.578210155159468, 84.797167230237747, -30.306270177290571, 86.088882125099786, -30.014905915290001, 87.370884877895193, -29.694405227090101, 88.643175488623996, -29.354480254760347, 89.905753957286151, -28.985418856229444, 91.158620283881675, -28.587221031499212, 92.401774468410565, -28.169598922639125, 93.635216510872823, -27.722840387570614, 94.858946411268448, -27.246945426310049, 96.072964169597455, -26.751626180910534, 97.277269785859815, -26.227170509309872, 98.471863260055557, -25.683290553579354, 99.656744592184651, -25.110274171649507, 100.8319137822471, -24.508121363520331, 101.9973708302429, -23.886544271250386, 103.1531157361721, -23.235830752790207, 104.2991485000347, -22.555980808119784, 105.43546912183059, -21.856706579319507, 106.56207760156001, -21.138008066389375, 107.6789739392226, -20.380460985199534, 108.776445992752, -19.603489619870743, 109.0775223968176, -19.389822494400505, 110.19441873448029, -18.564290418740711, 111.28217864594311, -17.729046201009623, 112.340802131206, -16.874377699139586, 113.3897134744022, -16.000284913150608, 114.4094883913986, -15.116479985079422, 115.400126882195, -14.203538630819821, 116.3713410888582, -13.290597276549306, 117.3231310113882, -12.348519496090375, 118.2457845077182, -11.396729573560151, 119.149013719915, -10.425515366900072, 120.0328186479785, -9.4445890181705181, 120.8874871498421, -8.4345262432398158, 121.72273136757239, -7.4244634683091135, 122.5288391591029, -6.3852642671809008, 123.3155226665001, -5.3363529239795753, 124.08278188976399, -4.2680172966502141, 124.820904686828, -3.1802573851891793, 125.5396031997588, -2.0827853316604887, 126.23887742855629, -0.96588899400012451, 126.9090152311539, 0.1704316277991893, 127.5500166075516, 1.3164643916607019, 128.1813058418827, 2.4819214396593452, 128.7834586500139, 3.6668027717805671, 129.35647503194519, 4.8711083880498336, 129.9197792718098, 6.0851261463794799, 130.44423494340799, 7.3185681888407998, 130.95897847293941, 8.5617223733697756, 131.44458557627109, 9.824300842030425, 131.9107683954694, 11.10630359481911, 132.34781478846779, 12.407730631750383],
       [88.29353837422525, 23.440724019450499, 77.143999281731752, 22.712313364450893, 76.86234716179942, 21.284628480649189, 76.590407183933735, 19.730685749989789, 76.367027916401199, 18.254440155869815, 76.17278507506856, 16.865603840340555, 76.027102944069071, 15.554464661339807, 75.929981523402759, 14.330734760940686, 75.861996528936331, 13.184701997079173, 75.842572244803065, 12.116366369760726, 75.842572244803065, 11.980396380820821, 75.929981523402759, 10.504150786689934, 76.17278507506856, 9.1444508973600023, 76.57098289980047, 7.9012967128401215, 77.114862855531854, 6.7649760910408077, 77.804424942262727, 5.7452011740406306, 78.649381302059695, 4.8322598197792104, 79.222397683990991, 4.3466527164491708, 80.183899748587564, 3.7056513400493714, 81.271659660050332, 3.1811956684505276, 82.485677418379339, 2.7635735595904407, 83.825953023574542, 2.4722092975898704, 85.282774333569336, 2.2973907403902558, 86.865853490430354, 2.239117887989778, 86.914414200763488, 2.239117887989778, 88.225553379758836, 2.2682543141891074, 89.526980416687508, 2.3459514507194399, 90.818695311549547, 2.4819214396593452, 92.110410206411615, 2.6664521389193396, 93.392412959207036, 2.8995435485194321, 94.664703569935796, 3.1909078105200024, 95.936994180664598, 3.5308327828497568, 97.199572649326754, 3.929030607579989, 98.452438975922277, 4.3757891426503193, 99.695593160451196, 4.8711083880498336, 100.93874734498, 5.4247004858407308, 102.1721893874423, 6.026853293980821, 103.3959192878379, 6.6872789545104752, 104.60993704616691, 7.3865531833107525, 91.770485234079487, 7.4254017515704618, 91.459696687947272, 7.4351138936399366, 90.13884536688532, 7.6584931611705542, 88.963676176822844, 8.182948832769398, 87.953613401893122, 9.0181930505004857, 87.701097708160702, 9.2804208862999076, 86.962974911096666, 10.348756513629269, 86.516216376031593, 11.562774271960734, 86.360822102965486, 12.912762019219372, 86.370534245032118, 13.077868434349512, 86.419094955365296, 14.175340487880021, 86.545352802231477, 15.389358246209667, 86.739595643564144, 16.739345993470124, 87.021247763496476, 18.225303729659572, 87.370884877895193, 19.82780717066089, 87.468006298561534, 20.206580711259448, 87.623400571627656, 20.867006371789103, 87.81764341296028, 21.624553452989858, 88.041022680492816, 22.488934096920275, 88.29353837422525, 23.440724019450499],
       [84.398969405505824, 66.232421965030881, 76.201921501268458, 66.115876260229925, 76.823498593532904, 66.096451976089156, 78.124925630461576, 65.911921276829162, 79.358367672923833, 65.542859878300078, 80.514112578853045, 64.989267780500086, 81.601872490315827, 64.241432841370624, 82.621647407312182, 63.29935506090078, 82.757617396245024, 63.143960787840115, 83.515164477442326, 62.163034439110561, 84.127029427640124, 61.084986669709906, 84.602924388905095, 59.900105337579589, 84.942849361237222, 58.60839044271961, 87.807931270893647, 59.550468223189455, 87.574839861294478, 60.463409577450875, 87.118369184162773, 61.842533750910661, 86.574489228431389, 63.105112219569492, 85.943199994100297, 64.260857125500479, 85.214789339102936, 65.300056326630511, 84.398969405505824, 66.232421965030881],
       [101.50205158484469, 69.068367448480785, 90.187406077218483, 67.485288291620236, 87.807931270893647, 59.550468223189455, 84.942849361237222, 58.60839044271961, 85.146804344636493, 57.219554127190349, 85.214789339102936, 55.733596391000901, 85.214789339102936, 55.549065691729993, 85.185652912903024, 54.500154348539581, 85.117667918436595, 53.412394437069452, 85.010834355703651, 52.285785957339613, 84.865152224704161, 51.11061676728059, 84.670909383371523, 49.896599008949124, 84.447530115838987, 48.634020540290294, 84.175590137973302, 47.342305645430315, 83.864801591841086, 46.002030040230238, 83.515164477442326, 44.613193724699158, 83.126678794777064, 43.185508840910188, 82.699344543845228, 41.718975388850595, 82.233161724646905, 40.213593368520378, 81.728130337182037, 38.659650637859158, 81.174538239384034, 37.057147196870574, 81.087128960784327, 36.814343645199187, 80.650082567785887, 35.62946231307069, 80.164475464454299, 34.444580980940373, 79.630307650789533, 33.269411790879531, 79.057291268858251, 32.084530458749214, 78.435714176593805, 30.909361268690191, 77.77528851606283, 29.734192078620254, 77.076014287265323, 28.559022888559412, 76.328179348134654, 27.383853698500388, 75.541495840737483, 26.208684508439546, 74.706251623007134, 25.043227460440903, 73.822446694943608, 23.868058270380061, 73.618491711544351, 23.596118292509345, 72.637565362814513, 22.34325196591999, 71.656639014084703, 21.158370633789673, 70.695136949488131, 20.041474296129309, 69.733634884891543, 18.982850810860327, 68.79155710442825, 18.001924462130773, 67.849479323964971, 17.079270965799878, 66.917113685568296, 16.224602463940755, 65.994460189238254, 15.43791895654067, 65.071806692908211, 14.719220443610538, 64.168577480711434, 14.058794783080884, 64.042319633845239, 13.981097646550552, 62.760316881049818, 13.165277712949319, 61.478314128254389, 12.46600348415086, 60.225447801658873, 11.902699244290488, 58.992005759196608, 11.455940709220158, 57.76827585880099, 11.145152163089733, 56.56397024253863, 10.950909321760264, 55.369376768342882, 10.892636469359786, 55.369376768342882, 10.892636469359786, 65.547701654173181, 10.203074382630803, 66.470355150503224, 11.057742884489926, 67.412432930966531, 11.960972096689147, 68.383647137629694, 12.922474161279752, 69.383997770492812, 13.942249078279929, 70.413484829555813, 15.030008989739144, 71.462396172752051, 16.166329611540277, 72.550156084214819, 17.360923085740069, 73.657340279810882, 18.613789412329425, 74.793660901606813, 19.924928591330172, 75.949405807536024, 21.284628480649189, 77.143999281731752, 22.712313364450893, 88.29353837422525, 23.440724019450499, 88.584902636224186, 24.489635362639092, 88.89569118235643, 25.6356681265097, 89.235616154688529, 26.878822311040494, 89.614389695287187, 28.219097916229657, 90.01258752001911, 29.656494942089921, 90.449633913017536, 31.191013388619467, 90.915816732215873, 32.8226532558092, 91.401423835547476, 34.541702401609655, 91.925879507145595, 36.367585110130676, 92.479471604943626, 38.290589239330075, 93.071912271008173, 40.301002647120185, 101.50205158484469, 69.068367448480785],
       [75.405525851804626, 69.505413841479822, 75.230707294605253, 69.505413841479822, 74.14294738314247, 69.447140989079344, 73.026051045479775, 69.311171000150352, 71.880018281617225, 69.097503874680115, 70.714561233621396, 68.806139612679544, 69.529679901492301, 68.427366072090081, 68.315662143163308, 67.970895394950276, 67.082220100701022, 67.427015439219758, 65.829353774105485, 66.805438346960727, 64.547351021310106, 66.10616411816045, 63.24592398438142, 65.32919275282984, 61.915360521252829, 64.464812108899423, 60.56537277399098, 63.522734328440492, 59.70099213006074, 62.881732952040693, 58.64236864479787, 62.06591301843946, 57.612881585734868, 61.230668800710191, 56.602818810805132, 60.376000298849249, 55.60246817794205, 59.501907512849357, 54.631253971278852, 58.59867830065923, 53.689176190815537, 57.676024804319241, 52.756810552418891, 56.724234881790835, 51.843869198155481, 55.762732817200231, 50.960064270091969, 54.772094326399383, 50.085971484095097, 53.75231940941012, 49.241015124298109, 52.722832350340468, 48.4154830486344, 51.664208865080582, 47.609375257103949, 50.586161095679927, 46.822691749706763, 49.478976900090856, 46.055432526442843, 48.352368420359198, 45.317309729378792, 47.20633565649041, 44.588899074381402, 46.040878608500861, 43.889624845583903, 44.846285134310165, 43.209774900919648, 43.632267375969604, 42.539637098322061, 42.398825333510104, 42.306545688722899, 41.952066798450687, 41.597559317858753, 40.543806198789753, 40.927421515261159, 39.154969883260492, 40.286420138863427, 37.785557851859267, 39.693979472798901, 36.425857962529335, 39.150099517067503, 35.075870215270697, 38.635355987536002, 33.745306752140095, 38.169173168337657, 32.434167573150262, 37.741838917405858, 31.132740536220808, 37.353353234740581, 29.85073778341939, 37.003716120341842, 28.57844717270018, 36.692927574209619, 27.325580846099911, 36.430699738410567, 26.082426661569116, 36.207320470878017, 24.858696761180909, 36.022789771612032, 23.654391144909823, 35.877107640612543, 22.459797670719126, 35.77998621994621, 21.274916338590629, 35.721713367546407, 20.119171432659641, 35.692576941346523, 18.963426526730473, 35.731425509613047, 17.671711631870494, 35.838259072346013, 16.2051781798109, 36.032501913678658, 14.806629722210346, 36.30444189154435, 13.466354117010269, 36.654079005943089, 12.19406350628924, 37.091125398941529, 10.980045747959593, 37.615581070539662, 9.8340129840998998, 38.217733878670828, 8.7559652146992448, 38.897583823335083, 7.7361902977008867, 39.664843046599003, 6.7844003751706623, 40.665193679462078, 5.7063526057791023, 41.714105022658337, 4.7642748253092577, 42.792152792054473, 3.9678791758506122, 43.909049129717168, 3.3268777994508127, 45.064794035646372, 2.8121342699196248, 46.24967536777546, 2.4527850134600158, 47.483117410237718, 2.239117887989778, 48.74569587889988, 2.1711328935198253, 49.852880074495943, 2.2099814617904485, 50.998912838358507, 2.3556635927907337, 52.174082028420969, 2.5887550023908261, 53.397811928816587, 2.9189678326492867, 54.65067825541211, 3.3463020835897623, 55.952105292340804, 3.8610456131191313, 57.282668755469388, 4.4826227053799812, 58.652080786864502, 5.1818969341802585, 60.060341386526119, 5.9880047257101978, 60.604221342257517, 6.3279296980399522, 61.361768423454812, 6.8232489434394665, 62.138739788785351, 7.3865531833107525, 62.954559722382442, 8.0081302755697834, 63.78980394011279, 8.6782680781707313, 64.654184584043037, 9.4163908752307179, 65.547701654173181, 10.203074382630803, 55.369376768342882, 10.892636469359786, 54.126222583813977, 11.009182174160742, 52.941341251684889, 11.349107146490496, 51.805020629888958, 11.931835670489818, 50.717260718426182, 12.737943462019757, 49.678061517296548, 13.777142663149789, 49.668349375229923, 13.786854805210169, 48.871953725766097, 14.777493296009197, 48.23095234936838, 15.855541065409852, 47.725920961903533, 17.030710255470694, 47.366571705438133, 18.303000866200819, 47.152904579972237, 19.66270075553075, 47.084919585505808, 21.129234207590343, 47.104343869639081, 21.983902709449467, 47.172328864105509, 23.042526194709353, 47.298586710971733, 24.139998248239863, 47.463693126104459, 25.29574315417085, 47.68707239363701, 26.490336628370642, 47.96872451356932, 27.743202954969092, 48.289225201768168, 29.03491784983089, 48.667998742366819, 30.384905597089528, 49.105045135365259, 31.783454054690083, 49.580940096630229, 33.230563222610726, 50.115107910295002, 34.716520958809269, 50.697836434292931, 36.260751547399195, 51.33883781069062, 37.853542846329219, 51.775884203689053, 38.921878473660399, 52.378037011820247, 40.330139073319515, 52.989901962018052, 41.699551104709826, 53.611479054282512, 43.039826709909903, 54.252480430680201, 44.35096588891065, 54.893481807077933, 45.632968641699335, 55.553907467608887, 46.87612282623013, 56.224045270206481, 48.099852726629251, 56.913607356937383, 49.294446200819948, 57.612881585734868, 50.450191106749116, 58.321867956598993, 51.586511728550249, 59.040566469529779, 52.683983782080759, 59.768977124527169, 53.7620315514705, 60.516812063657817, 54.801230752600532, 61.274359144855111, 55.811293527529415, 62.04161836811906, 56.792219876260788, 62.828301875516239, 57.744009798789193, 63.624697524980057, 58.666663295120088, 64.430805316510515, 59.560180365249835, 65.246625250107599, 60.424561009180252, 65.926475194771825, 61.094698811779381, 67.082220100701022, 62.143610154980706, 68.228252864563615, 63.075975793370162, 69.374285628426179, 63.882083584900101, 70.520318392288743, 64.561933529570524, 71.666351156151336, 65.125237769430896, 72.802671777947253, 65.562284162429933, 73.938992399743199, 65.863360566499978, 75.075313021539145, 66.057603407829447, 76.201921501268458, 66.115876260229925, 84.398969405505824, 66.232421965030881, 83.486028051242414, 67.048241898619381, 83.039269516177356, 67.36874258681928, 81.961221746781206, 68.019456105290374, 80.805476840852009, 68.553623918949597, 79.572034798389737, 68.971246027820598, 78.260895619394432, 69.262610289819349, 76.872059303866052, 69.447140989079344, 75.405525851804626, 69.505413841479822],
       [96.510010562595895, 98.874931450980512, 75.628905119337162, 98.845795024779363, 76.29904292193477, 98.845795024779363, 77.707303521596401, 98.806946456510559, 79.105851979191414, 98.748673604110081, 80.484976152653147, 98.651552183440799, 81.854388184048261, 98.525294336579464, 83.204375931310096, 98.360187921449324, 84.544651536505313, 98.16594508011076, 85.875214999633883, 97.942565812580142, 87.196066320695834, 97.68033797678072, 88.497493357624506, 97.38897371478015, 89.779496110419942, 97.05876088451987, 91.061498863215377, 96.709123770120641, 92.324077331877518, 96.310925945390409, 93.576943658473041, 95.893303836519408, 94.810385700935285, 95.436833159390517, 96.034115601330925, 94.951226056060477, 97.248133359659917, 94.436482526529289, 98.442726833855644, 93.882890428729297, 99.627608165984753, 93.300161904729976, 100.3463066789155, 92.911676222060123, 101.5409001531112, 92.241538419470089, 102.7063572011071, 91.532552048600337, 103.842677822903, 90.79442925154035, 104.9401498764324, 90.02717002827012, 106.0084855037619, 89.230774378809656, 107.04768470489149, 88.405242303149862, 108.0577474798213, 87.540861659219445, 109.0386738285511, 86.647344589089698, 109.9807516090144, 85.724691092760622, 110.8936929632778, 84.772901170230398, 111.7774978913413, 83.78226267942955, 112.6321663932049, 82.772199904500667, 113.447986326802, 81.723288561310255, 114.2346698341992, 80.6452407919096, 115.0019290574631, 79.528344454249236, 115.7206275703939, 78.392023832449922, 116.41990179919139, 77.216854642390899, 116.8860846183897, 76.371898282590337, 117.5076617106542, 75.17730480839964, 118.09039023465211, 73.972999192130374, 118.6342701903835, 72.749269291740347, 119.149013719915, 71.525539391339407, 119.6151965391133, 70.282385206810432, 120.0522429321117, 69.029518880219257, 120.4504407568437, 67.757228269489133, 120.80007787124239, 66.484937658760828, 121.1205785594413, 65.193222763900849, 121.41194282144021, 63.891795726969576, 121.65474637310599, 62.570944405910268, 121.85870135650531, 61.250093084849141, 122.03351991370469, 59.909817479650883, 122.1597777605709, 58.559829732390426, 122.2568991812372, 57.200129843060495, 122.315172033637, 55.821005669600709, 122.33459631777031, 54.432169354069629, 122.315172033637, 53.30556087433979, 122.2763234653705, 51.955573127079333, 122.208338470904, 50.605585379820695, 122.1112170502377, 49.255597632560239, 121.9849592033715, 47.925034169429637, 121.82956493030539, 46.58475856422956, 121.6353220889728, 45.263907243170252, 121.4216549635068, 43.943055922109124, 121.1691392697744, 42.622204601049816, 120.89719929190871, 41.311065422050888, 120.5864107457765, 40.009638385119615, 120.256197915511, 38.708211348190162, 119.887136516979, 37.416496453330183, 119.4889386922471, 36.134493700539679, 119.0713165833819, 34.85249094774008, 118.6148459062502, 33.570488194940481, 118.12923880291859, 32.298197584210357, 117.61449527338711, 31.035619115549707, 117.07061531765569, 29.782752788960352, 116.4101896571248, 28.335643621030613, 115.7206275703939, 26.927383021369678, 115.0213533415964, 25.577395274100127, 114.3123669707323, 24.285680379240148, 113.57424417366821, 23.032814052650792, 112.82640923453761, 21.838220578449182, 112.06886215334031, 20.692187814589488, 111.28217864594311, 19.594715761060797, 110.4857829964793, 18.555516559930766, 109.67967520494879, 17.564878069140832, 108.8444309872185, 16.622800288669168, 107.99947462742151, 15.738995360610716, 107.14480612555791, 14.894039000810153, 106.26100119749429, 14.107355493410068, 105.36748412736419, 13.378944838419557, 104.4545427731008, 12.689382751679659, 103.86210210703631, 12.281472784890866, 102.4732657915079, 11.358819288559971, 101.12327804424611, 10.533287212889263, 99.821851007317406, 9.8048765578896564, 98.549560396588603, 9.1735873235593317, 97.316118354126345, 8.6394195099001081, 96.131237021997251, 8.2023731168992526, 94.985204258134672, 7.8624481445694983, 93.868307920471992, 7.619644592899931, 92.799972293142474, 7.4739624619105598, 91.770485234079487, 7.4254017515704618, 104.60993704616691, 7.3865531833107525, 105.8239548044959, 8.1538124065700686, 106.0570462140951, 8.2994945375703537, 107.0379725628249, 8.9793444822298625, 107.99947462742151, 9.6980429951599945, 108.9415524078848, 10.465302218430224, 109.8642059042148, 11.271410009960164, 110.77714725847819, 12.126078511819287, 111.66095218654171, 13.019595581950853, 112.525332830472, 13.951961220349403, 113.3800013323356, 14.932887569080776, 114.2055334079993, 15.952662486070039, 115.0213533415964, 17.01128597134084, 115.80803684899359, 18.11847016692991, 116.58500821432411, 19.264502930800518, 117.3328431534548, 20.449384262930835, 118.0709659505188, 21.682826305390336, 118.7896644634496, 22.955116916109546, 119.4792265501805, 24.275968237179768, 120.1590764948447, 25.6356681265097, 120.8195021553757, 27.043928726170634, 121.3730942531737, 28.306507194829464, 121.9169742089051, 29.598222089689443, 122.4317177384366, 30.899649126620716, 122.9076126997016, 32.191364021480695, 123.36408337683331, 33.492791058410148, 123.7914176277651, 34.794218095339602, 124.1799033104303, 36.095645132270874, 124.5489647089623, 37.397072169200328, 124.8888896812945, 38.698499206129782, 125.1899660853601, 40.009638385119615, 125.4716182052924, 41.311065422050888, 125.7144217569582, 42.622204601049816, 125.9378010244907, 43.93334378003965, 126.13204386582331, 45.244482959040397, 126.2874381388895, 46.55562213803023, 126.4234081278223, 47.866761317029159, 126.5205295484886, 49.187612638090286, 126.5982266850217, 50.49875181708012, 126.6370752532882, 51.819603138150342, 126.6564995374215, 53.14045445920965, 126.64678739535491, 53.849440830070307, 126.61765096915499, 55.209140719400239, 126.54966597468849, 56.559128466660695, 126.4525445540222, 57.899404071860772, 126.3165745650894, 59.239679677049935, 126.1514681499566, 60.560530998109243, 125.957225308624, 61.88138231917037, 125.72413389902481, 63.202233640240593, 125.4619060632258, 64.503660677170046, 125.1608296591601, 65.8050877140995, 124.8306168288947, 67.096802608959479, 124.4712675724293, 68.378805361749983, 124.0730697476974, 69.651095972480107, 123.6457354967656, 70.923386583210231, 123.18926481963391, 72.18596505187088, 122.6939455742356, 73.438831378469331, 122.1597777605709, 74.681985563000126, 121.6061856627729, 75.915427605459627, 121.0137449967083, 77.148869647919128, 120.38245576237721, 78.372599548320068, 120.08137935831159, 78.93590378818044, 119.4015294136474, 80.120785120310757, 118.7022551848499, 81.276530026239925, 117.9738445298525, 82.403138505969764, 117.20658530658859, 83.500610559500274, 116.4101896571248, 84.568946186829635, 115.5846575814611, 85.608145387959667, 114.73970122166411, 86.618208162890369, 113.85589629360059, 87.589422369550448, 112.9429549393371, 88.541212292080672, 111.9911650168072, 89.463865788409748, 111.019950810144, 90.34767071647002, 110.01960017728091, 91.212051360400437, 108.9804009761513, 92.037583436069326, 107.9217774908884, 92.843691227599265, 106.824305437359, 93.6109504508604, 105.6976969576297, 94.349073247929482, 104.5516641937671, 95.058059618790139, 103.366782861638, 95.747621705519123, 102.15276510330899, 96.398335223990216, 101.29809660144539, 96.815957332850303, 100.122927411383, 97.37926157271977, 98.928333937187233, 97.903717244309519, 97.724028320924873, 98.399036489710852, 96.510010562595895, 98.874931450980512],
       [75.191858726338722, 102.52669686802983, 74.308053798275225, 102.51698472596036, 72.958066051013361, 102.48784829977012, 71.60807830375154, 102.42957544736055, 70.267802698556324, 102.35187831083022, 68.937239235427739, 102.24504474810055, 67.606675772299155, 102.10907475916974, 66.285824451237204, 101.94396834403051, 64.974685272241913, 101.75943764477051, 63.663546093246588, 101.55548266136975, 62.352406914251269, 101.31267910970018, 61.05097987732259, 101.05045127390076, 59.759264982460529, 100.75908701190019, 58.467550087598482, 100.44829846576977, 57.185547334803061, 100.09866135137054, 55.913256724074273, 99.729599952839635, 54.640966113345478, 99.341114270169783, 53.378387644683329, 98.923492161309696, 52.115809176021173, 98.476733626250279, 50.86294284942565, 98.00083866498062, 49.61007652283012, 97.505519419579286, 48.366922338301237, 96.981063747980443, 47.133480295838972, 96.437183792249925, 45.900038253376721, 95.854455268259699, 44.676308352981088, 95.252302460119608, 43.452578452585463, 94.630725367860578, 42.238560694256471, 93.970299707329104, 41.034255077994111, 93.300161904729976, 40.869148662861363, 93.203040484060693, 39.684267330732268, 92.503766255269511, 38.528522424803072, 91.785067742339379, 37.392201803007111, 91.046944945270297, 36.275305465344438, 90.289397864080456, 35.177833411815037, 89.522138640810226, 34.09978564241888, 88.725742991349762, 33.031450015089383, 87.909923057750348, 31.99225081395975, 87.07467884001926, 30.972475896963399, 86.220010338160137, 29.972125264100299, 85.345917552160245, 28.991198915370461, 84.462112624099973, 28.02969685077392, 83.549171269829458, 27.087619070310609, 82.616805631440002, 26.16496557398057, 81.665015708909777, 25.26173636178379, 80.703513644310078, 24.377931433720281, 79.712875153509231, 23.513550789790031, 78.702812378580347, 22.66859442999305, 77.67332531951979, 21.84306235432933, 76.624413976320284, 21.036954562798879, 75.565790491060397, 20.250271055401701, 74.478030579599363, 19.48301183213778, 73.370846383999378, 18.735176893007122, 72.244237904269539, 18.016478380076329, 71.10791728247932, 17.307492009212211, 69.942460234480677, 16.617929922481348, 68.75757890235036, 15.947792119883729, 67.553273286090189, 15.607867147551611, 66.912271909690389, 14.976577913220551, 65.707966293430218, 14.37442510508936, 64.493948535100571, 13.80140872315809, 63.270218634699631, 13.247816625360061, 62.046488734309605, 12.71364881169529, 60.813046691850104, 12.20861742423042, 59.579604649379689, 11.723010320898821, 58.326738322790334, 11.266539643767141, 57.073871996190064, 10.829493250768699, 55.821005669600709, 10.421583283970159, 54.548715058870584, 10.03309760130486, 53.27642444814046, 9.6640362027728486, 52.004133837410336, 9.3241112304407352, 50.712418942550357, 9.0036105422418871, 49.420704047690379, 8.7122462802429368, 48.119277010759106, 8.4403063023772233, 46.817849973829652, 8.1877906086448036, 45.506710794830724, 7.9644113411122532, 44.185859473769597, 7.7701684997796292, 42.865008152710288, 7.5856378005136094, 41.524732547510212, 7.4399556695141484, 40.18445694231923, 7.3039856805812908, 38.844181337130067, 7.197152117848332, 37.494193589860515, 7.119454981315271, 36.134493700539679, 7.0611821289155037, 34.765081669140272, 7.0223335606489741, 33.395669637749961, 7.0126214185823406, 32.016545464279261, 7.0126214185823406, 31.511514076819367, 7.0320457027156058, 30.112965619220631, 7.0806064130487689, 28.724129303689551, 7.1583035495818024, 27.335292988169385, 7.2554249702481277, 25.965880956769979, 7.3719706750477201, 24.596468925370573, 7.5273649481138127, 23.246481178110116, 7.6924713632465682, 21.896493430849659, 7.8964263466458533, 20.556217825660497, 8.1198056141783752, 19.235366504590274, 8.3723213079107932, 17.914515183529147, 8.6442612857765084, 16.603376004539314, 8.9453376898420913, 15.311661109679335, 9.2755505201075721, 14.019946214810261, 9.6251876345063181, 12.737943462019757, 9.9942490330383578, 11.465652851289633, 10.4021589998369, 10.212786524689363, 10.829493250768699, 8.9599201981000078, 11.276251785833781, 7.7167660135692131, 11.761858889165349, 6.4833239711097121, 12.25717813456359, 5.259594070710591, 12.791345948228351, 4.0455763123791257, 13.34493804602638, 2.8412706961207732, 13.91795442795765, 1.6466772219191625, 14.52981937815548, 0.46179588979975961, 15.151396470419909, -0.71337330027017742, 15.51074572688529, -1.3543746766699769, 16.190595671549541, -2.5489681508606736, 16.89958204241367, -3.7144251988593169, 17.627992697411059, -4.8604579627208295, 18.385539778608369, -5.9870664424506685, 19.162511143938929, -7.094250638039739, 19.949194651336111, -8.1722984074403939, 20.77472672699983, -9.2309218927002803, 21.609970944730179, -10.260408951769932, 22.474351588660429, -11.280183868759195, 23.358156516723941, -12.261110217490568, 24.261385728920711, -13.232324424159742, 25.184039225250729, -14.174402204620492, 26.135829147780669, -15.097055700949568, 27.107043354443881, -15.990572771079314, 28.09768184524032, -16.864665557079206, 29.107744620170049, -17.719334058940149, 30.14694382129969, -18.544866134610857, 31.205567306562561, -19.350973926129882, 32.283615075958693, -20.137657433529967, 33.381087129488122, -20.895204514730722, 34.507695609217421, -21.633327311790708, 35.653728373079993, -22.35202582472084, 36.819185421075851, -23.041587911449824, 38.004066753204938, -23.711725714050772, 38.878159539201818, -24.187620675320431, 40.072753013397538, -24.818909909650756, 41.28677077172653, -25.411350575710458, 42.50078853005553, -25.984366957640304, 43.724518430451148, -26.537959055440297, 44.948248330846781, -27.052702584969666, 46.191402515375671, -27.54802183036918, 70.21924198822316, -27.460612551769373, 70.131832709623467, -27.460612551769373, 68.752708536161748, -27.450900409699898, 67.383296504766633, -27.402339699370714, 66.013884473371519, -27.324642562840381, 64.66389672610967, -27.22752114216928, 63.31390897884782, -27.091551153240289, 61.973633373652632, -26.936156880170529, 60.643069910524041, -26.751626180910534, 59.322218589462103, -26.528246913370822, 58.01107941046677, -26.28544336171035, 56.699940231471459, -26.013503383839634, 55.408225336609398, -25.702714837709209, 54.116510441747351, -25.372502007450748, 52.834507688951931, -25.013152750980225, 51.562217078223142, -24.624667068310373, 50.299638609561008, -24.207044959450286, 49.037060140898859, -23.760286424379956, 47.79390595636994, -23.284391463119391, 46.550751771841043, -22.779360075650402, 45.327021871445417, -22.245192261989359, 44.103291971049799, -21.681888022130806, 42.8892742127208, -21.089447356060191, 41.675256454391807, -20.467870263799341, 41.675256454391807, -20.467870263799341, 40.48066298019608, -19.826868887399542, 39.315205932200257, -19.156731084800413, 38.169173168337657, -18.457456856000135, 37.052276830674998, -17.729046201009623, 35.954804777145597, -16.981211261880162, 34.886469149816072, -16.204239896549552, 33.84726994868646, -15.388419962950138, 32.827495031690091, -14.56288788727943, 31.82714439882702, -13.698507243350832, 30.855930192163811, -12.804990173219267, 29.9138524117005, -11.892048818959665, 28.991198915370461, -10.949971038500735, 28.09768184524032, -9.9690446897693619, 27.223589059243469, -8.9784061989703332, 26.378632699446491, -7.9489191399097763, 25.55310062378274, -6.8902956546498899, 24.756704974318922, -5.812247885249235, 23.979733608988369, -4.7050636896492506, 23.23189866985771, -3.5687430678608507, 22.51320015692696, -2.4032860198603885, 21.813925928129439, -1.2184046877300716, 21.134075983465209, 0.0053252126599545591, 20.949545284199189, 0.36467446913047752, 20.337680334001391, 1.5398436591895006, 19.754951810003458, 2.7150128492503427, 19.201359712205459, 3.9096063234501344, 18.66719189854069, 5.1139119397103059, 18.171872653142451, 6.337641840109427, 17.695977691877491, 7.5613717404994532, 17.249219156812408, 8.8045259250302479, 16.831597047947241, 10.047680109559224, 16.443111365281961, 11.310258578219873, 16.07404996674995, 12.582549188949997, 15.73412499441784, 13.864551941749596, 15.423336448285619, 15.165978978680869, 15.14168432835328, 16.467406015599408, 14.879456492554221, 17.788257336669631, 14.65607722502167, 19.118820799800233, 14.452122241622421, 20.449384262930835, 14.27730368442303, 21.799372010189472, 14.12190941135694, 23.168784041579784, 14.00536370655735, 24.53819607297919, 13.908242285891021, 25.917320246440795, 13.84025729142459, 27.315868704030436, 13.80140872315809, 28.724129303689551, 13.78198443902482, 30.142102045419961, 13.791696581091459, 30.91907341075057, 13.820833007291331, 32.259349015950647, 13.86939371762449, 33.59962462113981, 13.93737871209092, 34.930188084270412, 14.034500132757239, 36.260751547399195, 14.151045837556831, 37.591315010529797, 14.29672796855629, 38.912166331589106, 14.46183438368905, 40.233017652650233, 14.65607722502167, 41.544156831649161, 14.86974435048759, 42.865008152710288, 15.112547902153381, 44.166435189639742, 15.37477573795246, 45.477574368629575, 15.656427857884781, 46.769289263500468, 15.967216404016989, 48.070716300429922, 16.2974292342825, 49.362431195289901, 16.656778490747879, 50.654146090149879, 17.035552031346519, 51.945860985009858, 17.443461998145072, 53.227863737809457, 17.870796249076871, 54.500154348539581, 18.32726692620858, 55.782157101330085, 18.80316188747355, 57.044735569990735, 19.29848113287176, 58.317026180720859, 19.82293680446989, 59.579604649379689, 20.366816760201289, 60.842183118049434, 20.93983314213256, 62.095049444640608, 21.532273808197122, 63.347915771240878, 22.144138758394948, 64.600782097830233, 22.590897293460021, 65.474874883830125, 23.261035096057611, 66.737453352490775, 23.940885040721842, 67.98060753701975, 24.649871411585991, 69.194625295349397, 25.368569924516748, 70.389218769549188, 26.106692721580771, 71.564387959610031, 26.864239802778059, 72.710420723469724, 27.64121116810864, 73.827317061130088, 28.437606817572458, 74.934501256730073, 29.243714609102909, 76.012549026119814, 30.078958826833261, 77.06146036931932, 30.923915186630239, 78.090947428390791, 31.788295830560489, 79.10101020331058, 32.672100758623998, 80.081936552040133, 33.575329970820754, 81.043438616639833, 34.497983467150789, 81.975804255040202, 35.440061247614103, 82.888745609299804, 36.391851170144037, 83.78226267942955, 37.372777518873853, 84.646643323359967, 38.363416009670317, 85.481887541089236, 39.37347878460006, 86.307419616759944, 40.402965843663019, 87.103815266220408, 41.451877186859292, 87.871074489479724, 42.520212814188788, 88.618909428609186, 43.607972725651557, 89.347320083610612, 44.705444779180993, 90.046594312410889, 45.035657609446467, 90.250549295809833, 46.220538941575569, 90.95953566667049, 47.415132415771303, 91.629673469269619, 48.609725889967052, 92.270674845669419, 49.814031506229412, 92.882539795869889, 51.028049264558398, 93.465268319860115, 52.25177916495403, 94.009148275590633, 53.485221207416288, 94.533603947189476, 54.718663249878539, 95.02892319259081, 55.961817434407443, 95.495106011789176, 57.214683761002959, 95.922440262720556, 58.477262229665108, 96.330350229520263, 59.749552840393903, 96.699411628049347, 61.031555593189317, 97.039336600379102, 62.313558345984738, 97.35983728858082, 63.614985382913432, 97.641489408510097, 64.916412419842104, 97.894005102249139, 66.227551598837437, 98.117384369779757, 67.548402919899345, 98.311627211109226, 68.869254240961311, 98.476733626250279, 70.209529846156528, 98.612703615179271, 71.549805451351745, 98.709825035839458, 72.899793198613594, 98.787522172380704, 74.259493087942062, 98.836082882709889, 75.628905119337162, 98.845795024779363, 96.510010562595895, 98.874931450980512, 95.276568520133637, 99.311977843979548, 94.033414335604746, 99.729599952839635, 92.770835866942576, 100.11808563550039, 91.498545256213802, 100.46772274991054, 90.216542503418367, 100.79793558017082, 88.915115466489695, 101.09901198424086, 87.603976287494376, 101.37095196210066, 86.283124966432425, 101.61375551377023, 84.942849361237222, 101.82742263922955, 83.592861613975373, 102.01195333850046, 82.223449582580272, 102.16734761157022, 80.844325409118525, 102.29360545842974, 79.45548909359016, 102.39072687910084, 78.047228493928515, 102.46842401562935, 76.629255752200251, 102.50727258389998, 75.191858726338722, 102.52669686802983],
     ],

 65: [ [54.150272584231118, 100.00008030024037, 51.62519181253284, 100.00008030024037, 17.24945322020741, 19.54389657819047, 16.675156871409602, 18.203871764320866, 15.991470741888399, 16.672414834200026, 15.3169004274275, 15.223000239609974, 14.65144592802687, 13.855627980570716, 13.99510724368653, 12.579413872130317, 13.34788437440648, 11.385242099229799, 12.709777320186699, 10.282228476940872, 12.0899018960875, 9.2703730052508035, 11.470026471988289, 8.3405598691006162, 10.86838267800962, 7.4927890684903105, 10.26673888403098, 6.7361764184897766, 9.6833267201729143, 6.0707219190899195, 9.0999145563148147, 5.4873097552299441, 8.6623554334212542, 5.1226771528199606, 7.8966269683575367, 4.6395389546196384, 6.9303505719675789, 4.1928640166697733, 5.7817578743719764, 3.7644207088396797, 4.4326172454501602, 3.3724406612400344, 2.9011603153226981, 3.0078080588300509, 1.1691554538690241, 2.6705229016006342, 1.1691554538690241, 0.0087049039993871702, 31.95326291244314, 0.0087049039993871702, 31.95326291244314, 2.6705229016006342, 30.95963907087236, 2.7525652371405158, 29.273213284720072, 2.9257657232901693, 27.75087216965289, 3.1536610997991374, 26.410847355791361, 3.4180197365403728, 25.24402302807519, 3.7279574486001366, 24.25039918650441, 4.0743584208903485, 23.43909164613925, 4.4663384684808989, 22.791868776859189, 4.9038975913699687, 22.026140311795469, 5.578467905830621, 21.251296031671441, 6.5720917474100133, 20.786389463597029, 7.6477579245201923, 20.631420607572242, 8.7963506221094576, 20.68611549793394, 9.6532372377805586, 20.831968538898451, 10.628629449229265, 21.078095545526079, 11.731643071520011, 21.43361233287709, 12.944046474540301, 21.88028727083093, 14.28407128840081, 22.436351989508179, 15.733485882990863, 23.083574858788239, 17.310521888419316, 29.710772407613629, 32.734480970419099, 67.550520722846457, 32.734480970419099, 31.95326291244314, 38.06723278068057, 48.954257999870059, 77.575175251940891, 54.150272584231118, 100.00008030024037],
       [54.150272584231118, 100.00008030024037, 48.954257999870059, 77.575175251940891, 65.535925594524016, 38.06723278068057, 31.95326291244314, 38.06723278068057, 67.550520722846457, 32.734480970419099, 73.466684696969821, 18.677894147460393, 73.612537737934346, 18.313261545050409, 74.259760607214403, 16.727109724559341, 74.806709510831354, 15.241231869729745, 75.280731893966049, 13.873859610690488, 75.663596126497893, 12.61587713236986, 75.964418023487241, 11.4581686197198, 76.174081769873737, 10.418965702840069, 76.301703180717695, 9.4800367516309052, 76.347282256019099, 8.6596133962102613, 76.26523992047656, 7.7206844449992786, 75.900607318065255, 6.5812075624708086, 75.253384448785198, 5.5511204606500542, 74.332687127696659, 4.6213073244998668, 73.9498228951648, 4.3478328726905602, 73.129399539739367, 3.9102737497996714, 72.135775698168572, 3.5365253323307115, 70.959835555392118, 3.2265876202800428, 69.619810741530586, 2.980460613649484, 68.097469626463393, 2.7890284973891539, 66.401928025250854, 2.6705229016006342, 66.401928025250854, 0.0087049039993871702, 104.96182573024601, 0.0087049039993871702, 104.96182573024601, 2.6705229016006342, 103.5215269507213, 2.7981443124499492, 102.1450388766186, 3.0169238738908462, 100.8597089531188, 3.3086299558199244, 99.647305550101265, 3.6823783732907032, 98.526060297686513, 4.1381691263104585, 97.486857380814314, 4.6668863998093002, 96.52969679948464, 5.2867618239106378, 95.663694368757788, 5.9886795835500379, 95.271714321165646, 6.3441963708992262, 94.679186342247277, 6.9549559799397684, 94.077542548268639, 7.6659895546399639, 93.457667124169447, 8.4864129100606078, 92.837791700070198, 9.4071102311499999, 92.199684645850425, 10.428081517900864, 91.552461776570397, 11.549326770320476, 90.896123092230027, 12.770845988399742, 90.230668592829389, 14.09263917214048, 89.556098278368495, 15.523822136599847, 88.863296333787034, 17.046163251670805, 88.170494389205544, 18.677894147460393, 54.150272584231118, 100.00008030024037],
     ],

 66: [ [75.098415592760389, 47.913177349719263, 43.19306288177151, 47.803787568989719, 44.496624435391908, 47.794671753930743, 45.92780739985627, 47.749092678630404, 47.331642919139789, 47.676166158149499, 48.699015178182179, 47.56677637743087, 50.029924176983428, 47.430039151520759, 51.333485730603819, 47.256838665380201, 52.600584023983089, 47.056290734049981, 53.831219057121238, 46.828395357550107, 55.025390830018239, 46.564036720790682, 56.183099342674119, 46.272330638870699, 57.313460410149162, 45.944161296700258, 58.407358217383063, 45.588644509340156, 59.464792764375829, 45.196664461749606, 60.485764051127489, 44.777336968980308, 61.187681810769249, 44.467399256929639, 62.436548474027937, 43.84752383283012, 63.621604431864682, 43.19118514848924, 64.742849684279435, 42.498383203910635, 65.782052601151648, 41.760002184029872, 66.757444812601875, 40.976042088839677, 67.669026318630131, 40.164734548479828, 68.498565489115833, 39.298732117749751, 69.264293954179564, 38.405382241839106, 69.95709589876104, 37.466453290629943, 70.57697132286026, 36.481945264120441, 70.640782028282231, 36.372555483399992, 71.278889082502005, 35.214846970740837, 71.844069616239523, 34.038906827969186, 72.327207814434502, 32.853850870129463, 72.746535307207495, 31.659679097230764, 73.083820464437949, 30.456391509280365, 73.339063286125864, 29.234872291199281, 73.530495402391793, 28.013353073120015, 73.639885183115183, 26.773602224919159, 73.676348443356318, 25.524735561659327, 73.676348443356318, 25.087176438770257, 73.612537737934346, 23.820078145390653, 73.466684696969821, 22.580327297189797, 73.247905135523041, 21.367923894180421, 72.956199053593991, 20.191983751399675, 72.582450636122417, 19.052506868860291, 72.135775698168572, 17.940377431510569, 71.607058424672189, 16.8555954393305, 71.005414630693537, 15.807276707400888, 70.321728501172345, 14.786305420650024, 69.565115851168883, 13.801797394140522, 68.735576680683181, 12.853752627870563, 67.823995174654925, 11.923939491720375, 66.83037133308413, 11.039705430870526, 66.101106128261534, 10.438061636899874, 65.235103697534683, 9.790838767619789, 64.314406376446158, 9.189194973640042, 63.357245795116476, 8.6331302549606335, 62.354506138485412, 8.1135287965207681, 61.315303221613192, 7.6303905983295408, 60.221405414379291, 7.2019472904994473, 59.091044346904262, 6.8008514278408256, 57.9151042041278, 6.4544504555506137, 56.693584986049963, 6.1445127434999449, 55.435602507730941, 5.8710382916906383, 54.12292513905026, 5.6431429151907651, 52.773784510128451, 5.451710798919521, 51.379064805905237, 5.3149735730203247, 49.947881841440882, 5.2055837922907813, 48.462003986614832, 5.1417730868706712, 46.939662871547618, 5.1235414567508997, 13.302305299105059, 4.786256299519664, 12.372492162956259, 4.1390334302395786, 11.33328924608403, 3.6103161567407369, 10.193812363548711, 3.200104479030415, 8.9449457002900203, 2.9083983970995178, 7.5958050713682042, 2.7351979109607782, 6.1463904767832673, 2.6713872055297543, 2.4727170074894209, 2.6713872055297543, 2.4727170074894209, 0.009569207930326229, 48.598741212519052, 0.009569207930326229, 49.464743643245903, 0.009569207930326229, 51.114706169157039, 0.027800838050097809, 52.7099738047065, 0.055148283230664674, 54.268778180014799, 0.10984317358997941, 55.7820034800217, 0.17365387901918439, 57.25876551978746, 0.25569621456088498, 58.680832669191538, 0.34685436515974288, 60.057320743294213, 0.46535996095008159, 61.397345557155738, 0.59298137179030164, 62.691791295715859, 0.73883441275938821, 63.940657958974548, 0.90291908383915143, 65.14394554693186, 1.0852353850496002, 66.301654059587733, 1.2766675013099302, 67.413783496942216, 1.4954470627599221, 68.48944967405555, 1.7233424392707093, 69.510420960807195, 1.9694694458903541, 70.494928987317707, 2.2247122675798892, 71.433857938526813, 2.4981867193891958, 72.327207814434502, 2.7990086163808883, 73.174978615040786, 3.1089463284297381, 74.186834086732134, 3.5100421910792647, 75.381005859629155, 4.0387594645799254, 76.529598557224759, 4.6130558133791055, 77.641727994579227, 5.2329312374804431, 78.708278356632263, 5.8983857368803001, 79.738365458444207, 6.6094193115804956, 80.731989300015016, 7.3660319615792105, 81.670918251224094, 8.1682236868891778, 82.582499757252364, 9.0159944874903886, 83.439386372918904, 9.9002285483402375, 84.268925543404634, 10.839157499549401, 85.043769823528635, 11.814549710999927, 85.791266658471827, 12.835520997750791, 86.392910452450465, 13.737986688720412, 87.085712397031926, 14.868347756189905, 87.714703636191416, 16.016940453790085, 88.279884169928934, 17.174648966440145, 88.772138183184197, 18.341473294160096, 89.209697306077757, 19.508297621880047, 89.574329908489048, 20.693353579710674, 89.866035990418126, 21.887525352609373, 90.103047181985445, 23.090812940570686, 90.267131853070538, 24.303216343589156, 90.367405818733644, 25.524735561659327, 90.403869078974765, 26.755370594799388, 90.385637448854197, 27.511983244810835, 90.321826743432226, 28.797313168299297, 90.185089517527985, 30.055295646619925, 89.975425771141516, 31.285930679759986, 89.711067134393303, 32.48921826771948, 89.373781977162835, 33.665158410500226, 88.972686114510424, 34.804635293030515, 88.507779546436026, 35.925880545450127, 87.979062272939615, 37.019778352680078, 87.377418478960976, 38.077212899670485, 86.721079794620636, 39.116415816539302, 85.991814589798025, 40.119155473170395, 85.198738679553443, 41.103663499690811, 84.332736248826606, 42.051708265960769, 83.412038927738067, 42.972405587039248, 83.138564475929584, 43.218532593669806, 82.336372750624733, 43.91133453825023, 81.470370319897896, 44.567673222589292, 80.558788813869654, 45.196664461749606, 79.574280787359115, 45.798308255729353, 78.544193685547199, 46.372604604530352, 77.450295878313284, 46.910437693089989, 76.301703180717695, 47.430039151520759, 75.098415592760389, 47.913177349719263],
       [71.397394678285679, 93.373747055340573, 43.411842443218291, 92.936187932449684, 43.885864826352979, 92.936187932449684, 45.39909012635988, 92.899724672210141, 46.875852166125668, 92.826798151729236, 48.297919315529718, 92.717408371010606, 49.683523204692683, 92.562439514980724, 51.032663833614492, 92.361891583659599, 52.327109572174599, 92.133996207150631, 53.585092050493621, 91.860521755339505, 54.797495453511182, 91.54146822822986, 55.973435596287629, 91.185951440880672, 57.103796663762658, 90.784855578229326, 58.188578655936283, 90.347296455329342, 59.22778157280851, 89.873274072200729, 60.230521229439567, 89.353672613760864, 61.187681810769249, 88.79760789509055, 62.108379131857788, 88.195964101110803, 62.974381562584618, 87.557857046880599, 63.803920733070321, 86.883286732419947, 64.29617474632559, 86.445727609530877, 65.262451142715534, 85.51591447338069, 66.146685203562939, 84.567869707110731, 66.948876928867804, 83.58336168059941, 67.678142133690415, 82.571506208909341, 68.334480818030755, 81.5414191070995, 68.908777166828557, 80.474868745050117, 69.410146995144089, 79.380970937809252, 69.838590302977366, 78.259725685400554, 70.184991275268104, 77.111132987800374, 70.449349912016302, 75.935192845019628, 70.640782028282231, 74.731905257069229, 70.759287624065905, 73.501270223929168, 70.79575088430704, 72.24328774561036, 70.786635069246756, 71.614296506450046, 70.713708548764501, 70.32896658295067, 70.558739692739692, 69.070984104630043, 70.321728501172345, 67.831233256429186, 70.011790789122742, 66.618829853419811, 69.619810741530586, 65.424658080519293, 69.154904173456174, 64.266949567860138, 68.607955269839223, 63.127472685329849, 67.988079845740003, 62.006227432910237, 67.596099798147861, 61.386352008810718, 66.866834593325265, 60.365380722059854, 66.073758683080683, 59.417335955789895, 65.21687206741413, 58.523986079890165, 64.287058931265307, 57.703562724460426, 63.293435089694498, 56.946950074459892, 62.236000542701731, 56.263263944940263, 61.105639475226702, 55.643388520840745, 59.911467702329666, 55.087323802159517, 59.34628716859217, 54.850312610589754, 58.42558984750363, 54.522143268419313, 57.441081820993098, 54.22132137142944, 56.401878904120899, 53.947846919620133, 55.289749466766438, 53.701719913000488, 54.113809323989983, 53.482940351550496, 52.864942660731288, 53.300624050340048, 51.56138110711089, 53.136539379260284, 50.194008848068499, 53.00891796840915, 48.753710068543853, 52.908644002749497, 47.249600583597243, 52.835717482270411, 45.69079620828893, 52.790138406970073, 44.059065312498348, 52.781022591909277, 74.068328490948474, 52.389042544320546, 75.162226298182375, 53.027149598539836, 76.210545030114844, 53.701719913000488, 77.213284686745951, 54.412753487700684, 78.152213637955043, 55.169366137699399, 79.036447698802434, 55.953326232880499, 79.875102684348448, 56.782865403369215, 80.659062779532746, 57.648867834099292, 81.388327984355357, 58.542217710009936, 81.561528470500704, 58.770113086509809, 82.309025305443896, 59.818431818450335, 82.983595619904776, 60.884982180499719, 83.585239413883443, 61.987995802790465, 84.123072502440095, 63.109241055210077, 84.578863255454223, 64.257833752810257, 84.970843303046365, 65.424658080519293, 85.289896830156266, 66.627945668480606, 85.545139651844167, 67.849464886559872, 85.718340137989557, 69.098331549810609, 85.827729918712933, 70.365429843190213, 85.864193178954068, 71.668991396809361, 85.855077363893784, 71.960697478740258, 85.809498288592366, 73.236911587180657, 85.700108507868975, 74.494894065499466, 85.51779220666333, 75.734644913700322, 85.280781015095968, 76.947048316720611, 84.970843303046365, 78.141220089610215, 84.597094885574805, 79.317160232389142, 84.159535762681244, 80.456637114930345, 83.658165934365684, 81.586998182399839, 83.092985400628166, 82.690011804699679, 82.454878346408407, 83.774793796870654, 81.762076401826945, 84.832228343859242, 80.996347936763215, 85.862315445670902, 80.166808766277484, 86.883286732419947, 80.011839910252704, 87.0564872185696, 79.236995630128661, 87.895142204119111, 78.407456459642958, 88.697333929419983, 77.541454028916121, 89.472178209549384, 76.629872522887865, 90.201443414369351, 75.672711941558191, 90.90336117401057, 74.669972284927113, 91.568815673410427, 73.62165355299463, 92.206922727629717, 72.536871560820998, 92.808566521609464, 71.397394678285679, 93.373747055340573],
       [44.706288181778397, 97.767569914400156, 2.4727170074894209, 97.767569914400156, 2.4727170074894209, 95.096636101739932, 6.1463904767832673, 95.096636101739932, 6.7571500858222171, 95.087520286679137, 8.1609856051057061, 94.987246321019484, 9.4736629737864178, 94.759350944510516, 10.67695056174369, 94.42206578727928, 11.77996418403788, 93.975390849329415, 12.791819655729251, 93.410210315589211, 13.69428534669723, 92.726524186069582, 14.50559288706236, 91.924332460759615, 14.67879337320772, 91.714668714379513, 15.079889235860181, 91.067445845099428, 15.435406023211179, 90.274369934850256, 15.7453437352608, 89.335440983639273, 16.00970237200897, 88.232427361350346, 16.21936611839547, 86.983560698090514, 16.38345078948058, 85.5797251788008, 16.501956385264229, 84.030036618560189, 16.574882905746499, 82.325379202280601, 16.59311453586707, 80.465752929989321, 16.59311453586707, 17.311386192350255, 16.58399872080679, 16.080751159210195, 16.538419645505371, 14.35786211281993, 16.438145679842251, 12.789941922450453, 16.30140845393802, 11.376990588110857, 16.119092152732382, 10.109892294720339, 15.891196776225311, 8.997762857370617, 15.61772232441683, 8.0314864609808865, 15.298668797306959, 7.2201789206101239, 14.94315200995592, 6.5638402362801571, 14.85199385935311, 6.4362188254308421, 14.1227286545305, 5.5519847645791742, 13.302305299105059, 4.786256299519664, 46.939662871547618, 5.1235414567508997, 46.921431241427051, 5.1235414567508997, 45.663448763108072, 5.132657271809876, 44.414582099849383, 5.1691205320494191, 43.156599621530368, 5.2329312374804431, 41.889501328151113, 5.3058577579595294, 40.631518849832133, 5.4152475386799779, 39.364420556452842, 5.5428689495201979, 38.097322263073579, 5.6887219904892845, 36.830223969694288, 5.861922476629843, 35.554009861254741, 6.0624704079600633, 34.277795752815187, 6.2812499694100552, 33.001581644375648, 6.5182611609707237, 31.716251720875789, 6.7826197977192351, 30.430921797375959, 7.0743258796501323, 30.430921797375959, 47.156564699709634, 30.44915342749653, 47.156564699709634, 31.497472159429009, 47.320649370800311, 32.700759747386307, 47.466502411760302, 34.04990037630813, 47.575892192489846, 35.554009861254741, 47.657934528029728, 36.611444408247507, 47.703513603330066, 37.778268735963678, 47.739976863569609, 39.027135399222402, 47.767324308750176, 40.339812767903076, 47.785555938869948, 41.725416657066027, 47.803787568989719, 43.19306288177151, 47.803787568989719, 75.098415592760389, 47.913177349719263, 73.831317299381126, 48.368968102729923, 72.509524115640147, 48.788295595510135, 71.133036041537494, 49.189391458159662, 69.692737262012855, 49.554024060569645, 68.197743592126514, 49.891309217800881, 69.136672543335621, 50.210362744910526, 70.449349912016302, 50.693500943099934, 71.707332390335296, 51.222218216600595, 72.910619978292587, 51.787398750340799, 74.068328490948474, 52.389042544320546, 44.059065312498348, 52.781022591909277, 42.874009354661609, 52.781022591909277, 41.524868725739822, 52.808370037089844, 40.221307172119388, 52.844833297329387, 38.963324693800409, 52.899528187690521, 37.741805475722543, 52.981570523230403, 36.565865332946117, 53.063612858779379, 35.40815682029023, 53.145655194319261, 34.068132006428698, 53.273276605159481, 32.782802082928868, 53.419129646130386, 31.579514494971569, 53.592330132269126, 30.430921797375959, 53.792878063599346, 30.430921797375959, 91.350036111960435, 30.722627879305008, 91.422962632450435, 31.871220576900608, 91.714668714379513, 33.038044904616761, 91.969911536059954, 34.24133249257406, 92.197806912570741, 35.471967525712223, 92.389239028840166, 36.720834188970912, 92.562439514980724, 38.006164112470742, 92.690060925819125, 39.318841481151431, 92.799450706550488, 40.649750479952672, 92.872377227029574, 42.017122738995049, 92.917956302329912, 43.411842443218291, 92.936187932449684, 71.397394678285679, 93.373747055340573, 70.221454535509238, 93.902464328839415, 68.99993531743138, 94.394718342100532, 67.732837024052102, 94.859624910170169, 66.420159655371421, 95.288068218000262, 65.061903211389321, 95.680048265599908, 63.658067692105817, 96.035565052949096, 62.773833631258412, 96.245228799329197, 61.752862344506752, 96.454892545720213, 60.695427797513979, 96.646324661989638, 59.592414175219801, 96.828640963189173, 58.452937292684481, 96.983609819220874, 57.267881334847743, 97.138578675239842, 56.037246301709622, 97.266200086089157, 54.770148008330317, 97.3847056818704, 53.457470639649642, 97.484979647530054, 52.108330010727819, 97.576137798139825, 50.71361030650462, 97.639948503559935, 49.273311526979967, 97.69464339391925, 47.796549487214207, 97.731106654160612, 46.274208372147001, 97.75845409933936, 44.706288181778397, 97.767569914400156],
     ],

 67: [ [91.124018468737091, 24.377007168010095, 90.157742072347148, 23.064329799330153, 89.209697306077757, 21.788115690889754, 88.261652539808367, 20.566596472819583, 87.322723588599274, 19.390656330040656, 86.392910452450465, 18.269411077619225, 85.472213131361926, 17.202860715569841, 84.560631625333656, 16.181889428820796, 83.658165934365684, 15.20649721737027, 82.764816058457995, 14.285799896280878, 81.880581997610605, 13.410681650490005, 81.005463751823484, 12.590258295069361, 80.139461321096647, 11.815414014950875, 79.282574705430079, 11.095264625180789, 78.425688089763526, 10.420694310720137, 77.587033104217525, 9.791703071559823, 76.757493933731823, 9.2265225378196192, 75.93707057830639, 8.6978052643298724, 75.12576303794124, 8.2237828811903455, 74.287108052395254, 7.7679921281796851, 73.193210245161339, 7.2301590396200481, 72.090196622867154, 6.7287892113108683, 70.950719740331834, 6.2821142733500892, 69.793011227675962, 5.8627867805807909, 68.617071084899507, 5.4981541781708074, 67.413783496942216, 5.1791006510593434, 66.183148463804073, 4.8965103841892414, 64.934281800545364, 4.659499192619478, 63.658067692105817, 4.4589512613001716, 62.363621953545703, 4.313098220329266, 61.04182876980471, 4.2037084396106366, 59.692688140882893, 4.1398977341905265, 58.325315881840531, 4.1125502890099597, 76.629872522887865, 4.0943186588792742, 77.577917289157241, 4.723309898039588, 78.516846240366348, 5.3796485823895637, 79.437543561454888, 6.0724505269699875, 80.349125067483143, 6.7925999167291593, 81.251590758451087, 7.5492125667296932, 82.144940634358775, 8.3422884769806842, 83.020058880145925, 9.1627118323995091, 83.886061310872776, 10.028714263129586, 84.733832111479018, 10.912948323979435, 85.581602912085316, 11.842761460129623, 86.411142082571018, 12.799922041460377, 87.231565437996437, 13.793545883030674, 88.033757163301317, 14.81451716977972, 88.826833073545885, 15.881067531829103, 89.610793168730197, 16.965849524000078, 90.385637448854197, 18.096210591480485, 91.142250098857659, 19.253919104139641, 91.898862748861106, 20.448090877029244, 92.628127953683716, 21.669610095110329, 93.357393158506312, 22.936708388489933, 91.124018468737091, 24.377007168010095],
       [75.982649653607794, 94.814910138820778, 56.237794233035828, 94.814910138820778, 57.559587416776793, 94.787562693640211, 58.890496415578042, 94.723751988209187, 60.203173784258723, 94.614362207490558, 61.488503707758547, 94.450277536399881, 62.755602001137838, 94.249729605080574, 63.995352849336257, 93.99448678338922, 65.21687206741413, 93.702780701460142, 66.411043840311123, 93.365495544230725, 67.577868168027308, 92.973515496640175, 80.312661807241994, 93.22875831832971, 79.793060348805895, 93.274337393630049, 78.781204877114547, 93.547811845439355, 77.51410658373527, 94.05829748880933, 75.982649653607794, 94.814910138820778],
       [88.890643778967871, 100.00180890812044, 86.365563007269614, 100.00180890812044, 86.064741110280281, 98.87144784064003, 85.608950357266167, 97.604349547260426, 85.071117268709486, 96.473988479789114, 84.433010214489727, 95.47124882315984, 83.694629194606833, 94.596130577370786, 82.682773722915485, 93.839517927370252, 81.552412655440435, 93.374611359289702, 80.312661807241994, 93.22875831832971, 67.577868168027308, 92.973515496640175, 68.726460865622897, 92.545072188810082, 69.856821933097933, 92.071049805670555, 70.959835555392118, 91.542332532180808, 72.035501732505466, 90.977151998440604, 73.092936279498232, 90.366392389400062, 74.132139196370446, 89.710053705059181, 75.143994668061808, 88.999020130360805, 76.128502694572319, 88.251523295410152, 76.201429215054588, 88.196828405050837, 77.012736755419724, 87.51314227552939, 77.814928480724589, 86.792992885770218, 78.589772760848604, 86.036380235769684, 79.346385410852051, 85.234188510459717, 80.084766430734945, 84.395533524910206, 80.804915820497257, 83.511299464069452, 81.506833580139016, 82.581486327919265, 82.181403894599924, 81.615209931529535, 82.846858394000535, 80.603354459839466, 83.494081263280606, 79.555035727909853, 84.113956687379826, 78.461137920670808, 84.724716296418748, 77.3307768531904, 85.308128460276833, 76.154836710420568, 85.873308994014337, 74.933317492339484, 86.429373712691586, 73.675335014020675, 86.958090986187983, 72.380889275460504, 87.468576629563785, 71.040864461599995, 87.960830642819076, 69.655260572439147, 88.434853025953728, 68.233193423029661, 88.890643778967871, 66.765547198330751, 91.124018468737091, 66.765547198330751, 88.890643778967871, 100.00180890812044],
       [55.089201535440218, 100.00180890812044, 54.12292513905026, 99.992693093059643, 52.819363585429869, 99.9562298328201, 51.534033661930032, 99.883303312330099, 50.248703738430208, 99.783029346670446, 48.981605445050917, 99.655407935830226, 47.714507151671647, 99.491323264739549, 46.46564048841293, 99.290775333420243, 45.225889640214511, 99.071995771970251, 43.995254607076362, 98.816752950280716, 42.77373538899851, 98.525046868349818, 41.561331985980928, 98.205993341240173, 40.358044398023637, 97.850476553889166, 39.163872625126629, 97.476728136420206, 37.987932482350182, 97.057400643650908, 36.821108154634032, 96.619841520749105, 35.654283826917862, 96.136703322559697, 34.505691129322258, 95.635333494239603, 33.366214246786939, 95.09750040569088, 32.23585317931191, 94.532319871950676, 31.11460792689715, 93.93067607796911, 30.002478489542678, 93.301684838810615, 30.002478489542678, 93.29256902374982, 28.908580682308781, 92.636230339410758, 27.851146135316021, 91.952544209889311, 26.80282740338351, 91.250626450249911, 25.790971931692159, 90.512245430360053, 24.78823227506107, 89.75563278035952, 23.812840063610849, 88.971672685180238, 22.864795297341459, 88.16948095987027, 21.934982161192639, 87.339941789379736, 21.03251647022466, 86.483055173719549, 20.148282409377259, 85.5988211128697, 19.282279978650418, 84.69635542190008, 18.443624993104429, 83.757426470689097, 17.632317452739269, 82.809381704419138, 16.839241542494701, 81.82487367792055, 16.064397262370669, 80.822134021280363, 15.3169004274275, 79.792046919470522, 14.587635222604909, 78.734612372480115, 13.885717462963161, 77.64983038030914, 13.20203133344196, 76.5468167580093, 12.545692649101619, 75.416455690539806, 11.91670140994213, 74.267862992939627, 11.898469779821561, 74.231399732700083, 11.31505761596347, 73.119270295350361, 10.75899289728625, 71.988909227869954, 10.230275623789851, 70.84943234533057, 9.738021610534588, 69.700839647739485, 9.2639992273998928, 68.54313113508033, 8.8173242894460486, 67.376306807369474, 8.3979967966730555, 66.200366664590547, 8.0060167490809135, 65.015310706759919, 7.6413841466696217, 63.821138933859402, 7.3040989894391544, 62.617851345899908, 6.985045462329281, 61.396332127820642, 6.7024551954605149, 60.174812909739558, 6.4472123737725999, 58.935062061540521, 6.219316997265536, 57.686195398289783, 6.018769065939324, 56.437328735029951, 5.8364527647336777, 55.170230441650347, 5.6905997237691386, 53.894016333209947, 5.572094127985479, 52.608686409710572, 5.4718201623223592, 51.314240671150401, 5.4080094569004009, 50.010679117529435, 5.371546196659267, 48.698001748849492, 5.3533145665386987, 47.376208565110574, 5.3624303815989833, 46.391700538599252, 5.3988936418401181, 45.042559909670672, 5.453588532201791, 43.720766725929934, 5.5447466828046279, 42.398973542189196, 5.6632522785883159, 41.095411988570049, 5.8091053195528266, 39.810082065070674, 5.9823058056981893, 38.533867956630274, 6.1828537370244021, 37.26676966325067, 6.410749113531466, 36.017902999990838, 6.6751077502796639, 34.778152151800896, 6.9576980171484299, 33.556632933719811, 7.2676357291980187, 32.344229530699522, 7.604920886428487, 31.150057757800823, 7.9786693039000616, 29.965001799970196, 8.3706493514922045, 28.798177472250245, 8.7990926593255097, 27.640468959600184, 9.2457675972793538, 26.491876262000005, 9.7289057954743043, 25.370631009580393, 10.239391438850131, 24.249385757169875, 10.76810871234653, 23.146372134870035, 11.33328924608403, 22.052474327640084, 11.925817225002421, 20.976808150529905, 12.545692649101619, 19.919373603539498, 13.19291551838168, 18.861939056539995, 13.86748583284259, 17.831851954730155, 14.569403592484351, 16.801764852920314, 15.298668797306959, 15.799025196289222, 15.39894276297005, 15.662287970379111, 16.1646712280338, 14.659548313749838, 16.957747138278361, 13.675040287240336, 17.75993886358324, 12.726995520970377, 18.580362219008659, 11.806298199879166, 19.428133019614929, 10.922064139040231, 20.28501963528149, 10.056061708310153, 21.160137881068611, 9.2265225378196192, 22.053487756976288, 8.4243308125205658, 22.965069263004551, 7.6494865324002603, 23.894882399153371, 6.9019896974496078, 24.842927165422768, 6.181840307690436, 25.809203561812719, 5.4981541781708074, 26.79371158832322, 4.8418154938299267, 27.796451244954309, 4.2128242546696129, 28.817422531705951, 3.6111804606898659, 29.847509633517891, 3.045999926949662, 30.90494418051065, 2.50816683839912, 31.980610357623991, 1.9885653799592546, 33.065392349797612, 1.5145429968306416, 34.177521787152081, 1.0587522438108863, 35.298767039566833, 0.63030893598079274, 36.447359737162429, 0.23832888839024235, 37.605068249818324, -0.1263037140306551, 38.781008392594771, -0.46358887126007176, 39.984295980552048, -0.7644107682408503, 41.19669938356963, -1.0470010351091332, 42.427334416707758, -1.293128041739692, 43.676201079966489, -1.5119076031896839, 44.943299373345752, -1.7033397194500139, 46.228629296845597, -1.8674243905406911, 47.532190850466009, -1.9950458013790922, 48.853984034206981, -2.0953197670496593, 50.194008848068499, -2.1682462875305646, 51.552265292050599, -2.213825362830903, 52.91963755109299, -2.2320569929506746, 53.275154338443997, -2.2320569929506746, 54.660758227606948, -2.2047095477701077, 56.019014671589048, -2.150014657410793, 57.368155300510857, -2.0588565068101161, 58.699064299312113, -1.9312350959608011, 60.00262585293251, -1.7762662399400142, 61.287955776432341, -1.5939499387295655, 62.555054069811632, -1.3660545622205973, 63.803920733070321, -1.1199275555991335, 65.025439951148186, -0.82822147367005527, 66.237843354165761, -0.5091679465604102, 67.4228993120025, -0.16276697427019826, 68.589723639718656, 0.22009725827047077, 69.738316337314259, 0.63942475103976903, 70.859561589729012, 1.0860996889896342, 71.97169102708348, 1.5692378871899564, 73.056473019257112, 2.0888393456207268, 74.123023381310162, 2.6357882492393401, 75.171342113242659, 3.2100845980403392, 76.201429215054588, 3.8299600221398578, 76.629872522887865, 4.0943186588792742, 58.325315881840531, 4.1125502890099597, 58.179462840875999, 4.1125502890099597, 56.830322211954183, 4.1398977341905265, 55.499413213152927, 4.2037084396106366, 54.186735844472253, 4.313098220329266, 52.892290105912132, 4.4498354462393763, 51.62519181253284, 4.6412675624997064, 50.367209334213868, 4.8600471239496983, 49.13657430107574, 5.1244057607000286, 47.915055082997867, 5.4343434727506974, 46.720883310100838, 5.7716286299801141, 45.544943167324419, 6.1636086775706644, 44.387234654668532, 6.5829361703399627, 43.238641957072929, 7.0478427384205133, 42.117396704658169, 7.5492125667296932, 41.014383082363977, 8.0961614703501255, 39.929601090190367, 8.6795736342101009, 38.872166543197579, 9.3085648733704147, 37.960585037169317, 9.8737454071106185, 36.930497935357408, 10.575663166750019, 35.927758278726323, 11.323160001689757, 34.961481882336393, 12.098004281810063, 34.022552931127279, 12.909311822180825, 33.129203055219591, 13.757082622780217, 32.263200624492747, 14.641316683630066, 31.433661454007051, 15.562014004719458, 30.640585543762452, 16.519174586050212, 29.874857078698739, 17.51279842762051, 29.154707688936409, 18.54288552943035, 28.46190574435494, 19.609435891490648, 27.805567060014599, 20.712449513779575, 27.17657582085511, 21.842810581259982, 26.59316365699701, 23.018750724029815, 26.03709893831979, 24.231154127050104, 25.81831937687301, 24.750755585489969, 25.380760253979449, 25.826421762600148, 24.970548576266712, 26.920319569830099, 24.58768434373485, 28.032449007190735, 24.223051741323559, 29.171925889719205, 23.885766584093091, 30.320518587319384, 23.575828872043498, 31.496458730089216, 23.293238605174739, 32.699746318050529, 23.028879968426541, 33.912149721070818, 22.791868776859189, 35.151900569269856, 22.582205030472689, 36.409883047590483, 22.399888729267051, 37.695212971080764, 22.235804058181969, 38.98965870965003, 22.09906683227771, 40.311451893390768, 21.989677051554342, 41.651476707249458, 21.898518900951501, 43.018848966290534, 21.834708195529512, 44.404452855460477, 21.798244935288409, 45.808288374739277, 21.789129120228129, 47.230355524139668, 21.789129120228129, 48.032547249449635, 21.807360750348689, 49.500193474150365, 21.852939825650079, 50.949608068740417, 21.907634716011788, 52.371675218140808, 21.989677051554342, 53.775510737419609, 22.08995101721743, 55.151998811530575, 22.208456613001118, 56.510255255510856, 22.345193838905349, 57.84116425431057, 22.50016269493014, 59.153841622990512, 22.67336318107553, 60.439171546489888, 22.873911112401739, 61.706269839869492, 23.092690673848519, 62.946020688070348, 23.329701865415871, 64.167539906149614, 23.584944687103789, 65.361711679039217, 23.85841913891224, 66.537651821819964, 24.150125220841289, 67.686244519420143, 24.46006293289091, 68.816605586889636, 24.79734809012135, 69.919619209189477, 25.152864877472378, 71.004401201360452, 25.52661329494396, 72.070951563409835, 25.918593342536099, 73.101038665219676, 26.328805020248812, 74.122009951979635, 26.39261572567079, 74.286094623059398, 26.966912074468581, 75.598771991739341, 27.559440053386961, 76.865870285120764, 28.188431292546451, 78.087389503200029, 28.835654161826511, 79.272445461039752, 29.510224476287419, 80.402806528509245, 30.212142235929178, 81.48758852068022, 30.932291625691509, 82.535907252620746, 31.688904275694942, 83.529531094189224, 32.47286437087925, 84.486691675519978, 33.275056096184102, 85.39827318153948, 34.104595266669833, 86.264275612269557, 34.961481882336393, 87.084698967699296, 35.845715943183791, 87.859543247819602, 36.757297449212047, 88.588808452650483, 37.68711058536087, 89.272494582170111, 38.653386981750799, 89.910601636380306, 39.318841481151431, 90.311697499040747, 40.412739288385318, 90.931572923140266, 41.524868725739822, 91.505869271930351, 42.655229793214829, 92.034586545429192, 43.803822490810433, 92.517724743629515, 44.970646818526603, 92.955283866520404, 46.146586961303051, 93.347263914109135, 47.349874549260363, 93.684549071340371, 48.562277952277917, 93.985370968330244, 49.802028800476357, 94.240613790019779, 51.050895463735053, 94.441161721349999, 52.327109572174599, 94.605246392429763, 53.612439495674458, 94.723751988209187, 54.916001049294863, 94.787562693640211, 56.237794233035828, 94.814910138820778, 75.982649653607794, 94.814910138820778, 75.855028242763851, 94.878720844240888, 74.651740654806545, 95.462133008100864, 73.43933725178897, 96.009081911710382, 72.236049663831679, 96.528683370150247, 71.023646260814104, 97.002705753280679, 69.811242857796529, 97.449380691239639, 68.589723639718656, 97.859592368949961, 67.377320236701081, 98.224224971359945, 66.155801018623222, 98.561510128589362, 64.934281800545364, 98.862332025579235, 63.703646767407243, 99.135806477390361, 62.482127549329363, 99.363701853899329, 61.251492516191199, 99.555133970159659, 60.020857483053078, 99.719218641250336, 58.790222449914921, 99.846840052090556, 57.559587416776793, 99.928882387639533, 56.319836568578353, 99.983577278000666, 55.089201535440218, 100.00180890812044],
     ],

 68: [ [13.767211867179469, 92.728252793940555, 14.578519407544629, 91.926061068639683, 14.742604078629711, 91.734628952370258, 15.125468311161571, 91.105637713209944, 15.471869283452319, 90.321677618030662, 15.772691180441621, 89.38274866681968, 16.027934002129541, 88.279735044530753, 16.22848193345575, 87.030868381269102, 16.39256660454086, 85.627032861979387, 16.501956385264229, 84.059112671620824, 16.574882905746499, 82.336223625219645, 16.59311453586707, 80.467481537860294, 16.59311453586707, 17.313114800230323, 16.59311453586707, 16.182753732749916, 16.538419645505371, 14.432517241180904, 16.456377309962821, 12.837249605630859, 16.319640084058591, 11.406066641160578, 16.146439597913229, 10.129852532720179, 15.927660036466451, 9.0177230953704566, 15.66330139971825, 8.0696783291004976, 15.36247950272892, 7.2766024188604206, 15.006962715377909, 6.6384953646302165, 14.88845711959422, 6.4561790634306817, 14.1774235448922, 5.5719450025808328, 13.36611600452704, 4.7971007224605273, 12.445418683438501, 4.1498778531804419, 11.415331581626591, 3.6211605796797812, 10.275854699091269, 3.201833086910483, 9.0269880358325736, 2.9101270049795858, 7.6778474069107574, 2.7369265188408463, 6.219316997265536, 2.6731158134098223, 2.545643527971662, 2.6731158134098223, 2.545643527971662, 0.011297815810394241, 46.219513481785327, 0.011297815810394241, 46.611493529377469, 0.011297815810394241, 48.124718829384364, 0.020413630869370536, 49.6105966842104, 0.065992706169708981, 51.087358723976202, 0.12068759653084271, 52.536773318561103, 0.20272993207981926, 53.958840467965189, 0.31211971280026773, 55.371791802308991, 0.43974112364048779, 56.757395691471942, 0.58559416460957436, 58.124767950514297, 0.75879465075013286, 59.464792764375829, 0.95022676701955788, 60.786585948116823, 1.1690063284695498, 62.090147501737221, 1.4060175200302183, 63.375477425237051, 1.6612603417197533, 64.633459903556044, 1.9438506085898553, 65.87321075175447, 2.2446725055797287, 67.094729969832329, 2.5728418477501691, 68.288901742729337, 2.919242820040381, 69.464841885505791, 3.2838754224503646, 70.622550398161664, 3.675855470039096, 71.762027280696984, 4.0860671477603319, 72.874156718051452, 4.5236262706494017, 73.968054525285353, 4.9794170236691571, 45.791070173952022, 5.0523435441500624, 45.663448763108072, 5.0523435441500624, 44.615130031175589, 5.070575174269834, 43.530348039001979, 5.1161542495701724, 42.399986971526943, 5.1890807700492587, 41.233162643810772, 5.2893547357107309, 40.020759240793183, 5.4169761465600459, 38.771892577534487, 5.5719450025808328, 37.486562654034657, 5.7542613037894625, 36.15565365523338, 5.9639250501695642, 34.788281396191017, 6.2009362417393277, 33.37533006184723, 6.465294878489658, 31.925915467262289, 6.7570009604205552, 30.430921797375959, 7.0760544875302003, 30.430921797375959, 90.194056207179528, 31.41542982388648, 90.440183213810087, 32.801033713049407, 90.759236740919732, 34.159290157031514, 91.050942822850629, 35.490199155832762, 91.306185644540165, 36.802876524513472, 91.543196836109928, 38.079090632953012, 91.734628952370258, 39.337073111271991, 91.907829438519911, 40.558592329349857, 92.044566664419108, 41.761879917307141, 92.15395644515047, 42.937820060083588, 92.226882965629557, 44.086412757679192, 92.272462040929895, 45.207658010093951, 92.290693671049667, 13.767211867179469, 92.728252793940555],
       [42.327060451044673, 97.769298522280224, 2.545643527971662, 97.769298522280224, 2.545643527971662, 95.09836470962, 6.219316997265536, 95.09836470962, 6.8300766063044591, 95.089248894559205, 8.2339121255879775, 94.988974928890457, 9.5374736792083752, 94.761079552390584, 10.749877082225961, 94.423794395159348, 11.852890704520149, 93.977119457200388, 12.864746176211501, 93.411938923460184, 13.767211867179469, 92.728252793940555, 45.207658010093951, 92.290693671049667, 45.626985502866937, 92.290693671049667, 46.985241946849037, 92.254230410810123, 48.316150945650293, 92.190419705390013, 49.628828314330967, 92.09014573973036, 50.914158237830833, 91.95340851382025, 52.190372346270372, 91.771092212620715, 53.439239009529082, 91.5614284662297, 54.678989857727522, 91.315301459599141, 55.891393260745083, 91.032711192730858, 57.085565033642098, 90.704541850560418, 58.261505176418552, 90.34902506320941, 59.419213689074432, 89.957045015620679, 60.549574756549482, 89.528601707779671, 61.670820008964228, 89.063695139710035, 62.764717816198129, 88.553209496329146, 63.840383993311463, 88.015376407780423, 64.897818540304229, 87.441080058979423, 65.937021457176442, 86.8303204499407, 66.957992743928074, 86.173981765599819, 67.951616585498883, 85.490295636080191, 68.936124612009394, 84.7701462463192, 69.893285193339054, 84.013533596309571, 70.832214144548161, 83.211341871010518, 71.7529114656367, 82.381802700519984, 72.655377156604672, 81.51580026980082, 73.539611217452077, 80.613334578829381, 74.05921267588819, 80.048154045089177, 74.815825325891637, 79.173035799300123, 75.554206345774503, 78.279685923400393, 76.26523992047656, 77.368104417369977, 76.939810234937468, 76.429175466160814, 77.587033104217525, 75.47201488483006, 78.206908528316745, 74.487506858320558, 78.7994365072351, 73.484767201689465, 79.364617040972604, 72.454680099879624, 79.893334314469016, 71.406361367939098, 80.394704142784533, 70.330695190830738, 80.877842340979527, 69.236797383600788, 81.324517278933385, 68.124667946240152, 81.734728956646066, 66.985191063709863, 82.126709004238236, 65.818366735989912, 82.491341606649527, 64.633310778150189, 82.819510948819698, 63.43002319019979, 83.120332845809045, 62.19938815705973, 83.393807297617485, 60.950521493799897, 83.639934304245116, 59.674307385359498, 83.858713865691897, 58.379861646799327, 84.041030166897585, 57.058068463060408, 84.205114837982634, 55.718043649199899, 84.332736248826606, 54.350671390160642, 84.433010214489727, 52.965067500990699, 84.505936734971968, 51.552116166649284, 84.551515810273386, 50.120933202180822, 84.560631625333656, 48.671518607599864, 84.560631625333656, 47.805516176869787, 84.524168365092535, 46.37433321241042, 84.469473474730833, 44.96138187805991, 84.378315324128025, 43.575777988900882, 84.259809728344365, 42.208405729859805, 84.113956687379826, 40.85926510094032, 83.931640386174195, 39.537471917190487, 83.731092454847953, 38.233910363569521, 83.494081263280606, 36.948580440070145, 83.229722626532435, 35.690597961760432, 82.938016544603357, 34.459962928620371, 82.618963017493485, 33.247559525600082, 82.263446230142463, 32.053387752699564, 81.889697812670875, 30.877447609929732, 81.479486134958165, 29.728854912329552, 81.041927012064605, 28.607609659920854, 80.577020443990193, 27.504596037619194, 80.075650615674675, 26.419814045450039, 79.556049157238562, 25.362379498450537, 78.999984438561327, 24.323176581579901, 78.416572274703242, 23.302205294830856, 77.805812665664305, 22.308581453260558, 77.167705611444532, 21.342305056870828, 76.502251112043908, 20.385144475540073, 75.800333352402149, 19.455331339389886, 75.080183962639836, 18.552865648420266, 74.323571312636375, 17.668631587579512, 73.539611217452077, 16.802629156849434, 72.728303677086942, 15.963974171299924, 71.816722171058686, 15.07974011045917, 70.886909034909863, 14.222853494789888, 69.938864268640472, 13.411545954430039, 68.972587872250529, 12.636701674300639, 67.988079845740003, 11.898320654419877, 66.985340189108939, 11.196402894780476, 65.964368902357293, 10.530948395380619, 64.92516598548508, 9.9019571562203055, 63.867731438492306, 9.3185449923603301, 62.792065261378973, 8.7715960887398978, 61.689051639084802, 8.2519946303091274, 60.576922201730298, 7.7779722471696005, 59.44656113425529, 7.3495289393395069, 58.297968436659687, 6.9484330766899802, 57.131144108943523, 6.5929162893298781, 55.946088151106778, 6.2647469471594377, 54.73368474808921, 5.9821566803002497, 53.512165530011337, 5.736029673669691, 52.272414681812933, 5.5263659272804944, 51.014432203493918, 5.3531654411399359, 49.729102279994102, 5.2255440302906209, 48.434656541433981, 5.1252700646291487, 47.121979172753299, 5.070575174269834, 45.791070173952022, 5.0523435441500624, 73.968054525285353, 4.9794170236691571, 75.034604887338418, 5.4625552218603843, 76.092039434331198, 5.9639250501695642, 77.122126536143114, 6.4835265086094296, 78.124866192774192, 7.0304754122298618, 79.118490034344987, 7.5956559459700657, 80.084766430734945, 8.1881839248799224, 81.032811197004307, 8.7989435339204647, 81.953508518092846, 9.4279347730807785, 82.855974209060847, 10.08427345741984, 83.740208269908237, 10.767959586939469, 84.606210700635074, 11.460761531530807, 85.444865686181075, 12.180910921289978, 86.265289041606493, 12.928407756229717, 87.067480766911373, 13.694136221289227, 87.842325047035374, 14.478096316479423, 88.598937697038835, 15.289403856839272, 89.127654970535218, 15.881931835760042, 89.929846695840084, 16.829976602030001, 90.704690975964098, 17.787137183360755, 91.452187810907262, 18.753413579750486, 92.172337200669588, 19.747037421320783, 92.865139145251064, 20.749777077950057, 93.530593644651688, 21.761632549649221, 94.168700698871461, 22.800835466519857, 94.770344492850114, 23.849154198449469, 95.353756656708185, 24.906588745439876, 95.90070556032515, 25.991370737619945, 96.42030701876125, 27.085268544849896, 96.921676847076796, 28.188282167140642, 97.386583415151193, 29.31864323461923, 97.824142538044768, 30.45812011714952, 98.234354215757477, 31.615828629810494, 98.608102633229066, 32.782652957530445, 98.963619420580073, 33.967708915359253, 99.291788762750244, 35.170996503320566, 99.583494844679294, 36.383399906340856, 99.856969296487762, 37.623150754539893, 100.0939804880551, 38.862901602729835, 100.30364423444161, 40.129999896109439, 100.48596053564719, 41.406214004549838, 100.640929391672, 42.700659743110009, 100.768550802516, 44.004221296729156, 100.8688247681791, 45.326014480480808, 100.94175128866139, 46.666039294339498, 100.9782145489025, 48.024295738319779, 100.9964461790231, 49.391667997360855, 100.9964461790231, 49.564868483510509, 100.9782145489025, 50.932240742549766, 100.9326354736011, 52.281381371469251, 100.8597089531188, 53.621406185329761, 100.75943498745571, 54.943199369070499, 100.62269776155151, 56.246760922689646, 100.4677289055267, 57.541206661249817, 100.2762967892607, 58.817420769690216, 100.0666330428742, 60.08451906306982, 99.820506036246641, 61.333385726329652, 99.547031584438159, 62.564020759469713, 99.24620968744884, 63.785539977550798, 98.918040345278669, 64.988827565499378, 98.562523557927648, 66.1738835233391, 98.179659325395775, 67.349823666119846, 97.760331832622782, 68.507532178769907, 97.322772709729222, 69.656124876370086, 96.848750326594526, 70.786485943850494, 96.356496313339278, 71.898615381200216, 95.827779039842881, 73.001629003489143, 95.271714321165646, 74.086410995669212, 94.688302157307575, 75.152961357720415, 94.077542548268639, 76.210395904710822, 93.412088048868014, 77.286062081830096, 92.673707028985135, 78.407307334240613, 91.917094378981659, 79.492089326409769, 91.142250098857659, 80.540408058350295, 90.340058373552779, 81.552263530040364, 89.519635018127374, 82.536771556549866, 88.680980032581374, 83.484816322819825, 87.814977601854537, 84.405513643909217, 86.921627725946834, 85.289747704749971, 86.019162034978876, 86.137518505360276, 85.080233083769755, 86.94882604572922, 84.132188317500393, 87.732786140910321, 83.147680290989882, 88.480282975850059, 82.154056449419073, 89.200432365609231, 81.133085162667442, 89.884118495139774, 80.093882245795214, 90.531341364410764, 79.027331883742164, 91.142100973449487, 77.942549891568547, 91.725513137309463, 76.830420454214078, 92.28157785599069, 75.700059386739042, 92.79206349936976, 75.12576303794124, 93.038190505989405, 74.232413162033552, 93.393707293349507, 73.311715840945013, 93.740108265639719, 72.354555259615353, 94.06827760781016, 71.379163048165125, 94.378215319849915, 70.367307576473763, 94.679037216839788, 69.318988844541266, 94.970743298770685, 68.252438482488202, 95.244217750579992, 67.149424860194017, 95.499460572269527, 66.019063792718981, 95.745587578900086, 64.861355280063108, 95.973482955399959, 63.676299322226377, 96.192262516849951, 62.463895919208802, 96.392810448180171, 61.215029255950093, 96.584242564440501, 59.938815147510518, 96.757443050590155, 58.63525359389012, 96.921527721669918, 57.295228780028587, 97.067380762640823, 55.927856520986211, 97.20411798854002, 54.533136816762983, 97.322623584330358, 53.111069667358912, 97.422897549990012, 51.661655072773982, 97.514055700590689, 50.175777217947932, 97.59609803613057, 48.671667733001328, 97.659908741559775, 47.131094987813547, 97.705487816860114, 45.554058982384703, 97.741951077099657, 43.958791346835248, 97.760182707219428, 42.327060451044673, 97.769298522280224],
     ],

 69: [ [86.795499715232339, 24.519505889280481, 83.918910769228205, 24.519505889280481, 83.1899122007203, 23.140319408319556, 82.411656972178093, 21.721727599329824, 81.633401743635886, 20.372095114389595, 80.855146515093665, 19.071719289480825, 80.076891286551444, 17.850154120629668, 79.308487390016069, 16.677845611809971, 78.549934825487583, 15.584347759049706, 77.781530928952236, 14.540106566329996, 77.02297836442375, 13.574676029649709, 76.264425799895264, 12.658502153020891, 75.515724567373638, 11.81128760043066, 74.757172002845152, 11.033032371880836, 74.422226714611782, 10.707938415660465, 73.318877529843064, 9.7228052149694122, 72.195825681060626, 8.8558879983702354, 71.053071168264466, 8.0973354338402714, 69.900465323461447, 7.4471475213795202, 68.738008146651538, 6.9151755930106447, 67.555848305827936, 6.4915683167200768, 66.79729574129945, 6.2846903445806674, 65.792459876599366, 6.058109708419579, 64.679259359823774, 5.8709344002891157, 63.437991526959003, 5.7034617561694176, 62.088359042018681, 5.5753944400803448, 60.620510572996039, 5.4670297880002181, 59.034446119891008, 5.3980704639598116, 57.330165682703608, 5.3586651359291864, 55.517520593440743, 5.3389624719202402, 38.937728825889472, 5.3389624719202402, 14.24043948468268, 5.0631251757204154, 13.06813097586593, 4.3341266072202416, 13.048428311852181, 4.3144239432003815, 11.79730914698052, 3.7233440227901156, 10.516635986088261, 3.2603314184707415, 9.206408829175416, 2.9352374622394564, 7.8764790082488503, 2.7382108221008821, 6.5071438592948416, 2.6692514980604756, 3.0493263248857541, 2.6692514980604756, 3.0493263248857541, -0.00045947581020300277, 78.362759517357176, -0.00045947581020300277, 86.795499715232339, 24.519505889280481],
       [70.363477927784032, 67.993434035570317, 67.693766953924012, 67.993434035570317, 67.644510293889709, 67.146219482980086, 67.477037649773024, 65.501047037829267, 67.240605681608287, 63.954387912750462, 66.935214389395526, 62.525944771759896, 66.551012441127853, 61.205866282840361, 66.087999836805267, 60.004003777999969, 65.556027908434629, 58.910505925239704, 64.955096656015968, 57.935224056560401, 64.275354747542394, 57.068306839959405, 63.516802183013908, 56.309754275429441, 63.063640910698183, 55.94525499116935, 62.236129022121638, 55.44283705881935, 61.270698485449032, 54.999527118510741, 60.157497968673447, 54.625176502249815, 58.886676139788051, 54.329636542050139, 57.477935662806573, 54.09320457387912, 55.91157387371527, 53.925731929770336, 54.207293436527891, 53.817367277690209, 52.345391687230681, 53.787813281669514, 30.869487912268269, 53.787813281669514, 52.345391687230681, 48.527201990009416, 53.72457816819157, 48.507499325989556, 55.35004794932405, 48.42868866993922, 56.847450414367302, 48.280918689830287, 58.197082899307617, 48.074040717690877, 59.408796736151821, 47.808054753499164, 60.492443256906789, 47.473109465270682, 61.428319797558821, 47.079056185000809, 61.920886397902031, 46.822921552820844, 63.122748902739339, 46.06436898829088, 64.147287431453151, 45.197451771689884, 65.00435331605027, 44.212318571000651, 65.684095224523873, 43.118820718240386, 65.930378524695442, 42.537592129829136, 66.225918484901371, 41.650972249210099, 66.521458445107271, 40.547623064439904, 66.816998405313171, 39.227544575529464, 67.112538365519072, 37.690736782449676, 67.408078325724972, 35.937199685229643, 67.693766953924012, 33.957081951850341, 70.363477927784032, 33.957081951850341, 70.363477927784032, 67.993434035570317],
       [14.34880413675817, 92.976412004969461, 15.156613361320989, 92.217859440439497, 15.442301989520031, 91.813954828159694, 15.81665260578084, 91.094807591660356, 16.141746562007349, 90.178633715020624, 16.407732526192639, 89.085135862260358, 16.634313162350519, 87.7946113693597, 16.811637138474069, 86.316911568330397, 16.92985312255642, 84.652036459170631, 17.008663778611329, 82.790134709879567, 17.02836644262506, 80.750908984460693, 17.02836644262506, 17.239371536210456, 17.018515110618189, 15.397172450919243, 16.969258450583862, 13.63378402168928, 16.890447794528981, 12.057570900600695, 16.772231810446598, 10.688235751640605, 16.624461830343659, 9.5257785748308379, 16.44713785422012, 8.5603480381596455, 16.240259882075989, 7.7919441416197515, 15.915165925849481, 7.0727969051204127, 15.196018689348429, 5.9792990523601475, 14.24043948468268, 5.0631251757204154, 38.937728825889472, 5.3389624719202402, 38.720999521738491, 5.3389624719202402, 36.947759760503047, 5.3980704639598116, 35.479911291480377, 5.5655431080704147, 34.317454114670497, 5.8315290722603095, 33.460388230073377, 6.205879688519417, 33.125442941840006, 6.4029063286598102, 32.120607077139923, 7.2993775412796822, 31.440865168666349, 8.4421320540805027, 31.302946520570242, 8.8952933263899467, 31.145325208460449, 9.7622105430000374, 31.027109224378101, 10.934519051810639, 30.938447236316321, 12.412218852839942, 30.88919057628199, 14.2051612780906, 30.869487912268269, 16.293643663550029, 30.869487912268269, 48.527201990009416, 52.345391687230681, 48.527201990009416, 30.869487912268269, 53.787813281669514, 30.869487912268269, 92.43458874459975, 57.674962302943833, 92.43458874459975, 14.34880413675817, 92.976412004969461],
       [78.362759517357176, 97.76415936030935, 3.0493263248857541, 97.76415936030935, 3.0493263248857541, 95.094448386449585, 6.5071438592948416, 95.094448386449585, 6.536697855315424, 95.094448386449585, 8.1917216324685, 95.035340394410014, 9.7088267615254722, 94.858016418280386, 11.07816191047948, 94.56247645808071, 12.309578411337441, 94.148720513789158, 13.39322493209241, 93.626599917430212, 14.34880413675817, 92.976412004969461, 57.674962302943833, 92.43458874459975, 58.620690175602732, 92.42473741258982, 60.403781268845023, 92.385332084559195, 62.039102381984378, 92.306521428510678, 63.506950851007019, 92.198156776430551, 64.827029339926753, 92.040535464320783, 65.989486516736633, 91.85336015619032, 66.994322381436703, 91.616928188030215, 67.841536934026976, 91.35094222384032, 68.196184886274068, 91.193320911730552, 69.467006715159442, 90.543132999280715, 70.619612559962462, 89.794431766760681, 71.644151088676253, 88.94721721417045, 72.540622301300857, 88.001489341510023, 73.318877529843064, 86.947396816769469, 73.387836853891116, 86.848883496699273, 73.82129546219312, 86.050925604149597, 74.244902738488236, 85.09534639947924, 74.668510014783379, 84.001848546720794, 75.082265959071634, 82.770432045859707, 75.476319239346154, 81.381394232899765, 75.87037251962073, 79.854437771829907, 76.254574467888403, 78.169859998659376, 76.638776416156077, 76.357214909390677, 79.446406038112173, 76.357214909390677, 78.362759517357176, 97.76415936030935],
     ],

 70: [ [63.448403945719321, 67.415422038740871, 60.777470133056532, 67.415422038740871, 60.750122687875688, 67.169295032110313, 60.513111496308341, 65.501100876079363, 60.239637044499858, 63.960528130899547, 59.911467702329666, 62.547576796550857, 59.546835099918383, 61.253131057990686, 59.12750760714539, 60.095422545340625, 58.671716854131262, 59.065335443519871, 58.170347025815722, 58.162869752559345, 57.623398122198772, 57.388025472429945, 57.030870143280403, 56.740802603149859, 56.483921239663452, 56.266780220019427, 55.599687178816062, 55.66513642603968, 54.606063337245239, 55.15465078266061, 53.512165530011337, 54.744439104950288, 52.299762126993762, 54.416269762779848, 50.987084758313067, 54.188374386279975, 49.55590179384874, 54.051637160369864, 48.024444863721271, 54.006058085069526, 30.221258050989469, 54.006058085069526, 48.024444863721271, 48.016967590459899, 49.56501760890901, 47.980504330220356, 51.005316388433641, 47.880230364560703, 52.317993757114323, 47.697914063350254, 53.493933899890777, 47.442671241660719, 54.533136816762983, 47.123617714560169, 55.444718322791232, 46.722521851899728, 55.973435596287629, 46.403468324790083, 56.957943622798162, 45.665087304909321, 57.851293498705843, 44.799084874179243, 58.644369408950411, 43.805461032610765, 59.337171353531879, 42.684215780200248, 59.619761620400652, 42.073456171159705, 59.957046777631092, 41.11629558983077, 60.230521229439567, 40.022397782600819, 60.458416605946638, 38.800878564519735, 60.622501277031724, 37.442622120539454, 60.731891057755121, 35.947628450650882, 60.777470133056532, 34.325013369920271, 63.448403945719321, 34.325013369920271, 63.448403945719321, 67.415422038740871],
       [13.06529410753774, 93.012630728020667, 14.104497024409939, 92.183091557530133, 14.8975729346545, 91.262394236440741, 15.44452183827147, 90.268770394870444, 15.61772232441683, 89.758284751500469, 15.818270255743039, 88.93786139607073, 15.991470741888399, 87.944237554500432, 16.128207967792662, 86.786529041850372, 16.237597748516041, 85.455620043039744, 16.319640084058591, 83.960626373160267, 16.365219159360009, 82.292432217129317, 16.38345078948058, 80.460153390009509, 16.38345078948058, 17.305786652370443, 16.356103344299719, 15.446160380070069, 16.29229263887774, 13.7323871487406, 16.192018673214641, 12.173582773430098, 16.037049817189821, 10.778863069210274, 15.84561770092389, 9.5391122210094181, 15.60860650935655, 8.4634460438992392, 15.33513205754806, 7.5518645378706424, 15.01607853043819, 6.7952518878591945, 14.65144592802687, 6.2027239089493378, 13.95864398344542, 5.4187638137591421, 13.11998899789941, 4.689498608939175, 12.17194423163005, 4.0787389999004517, 11.123625499697541, 3.5682533565304766, 9.9659169870416502, 3.1762733089308313, 8.698818693662389, 2.8936830420607293, 7.3314464346200046, 2.7295983709791471, 5.8546843948542451, 2.6749034806198324, 2.3997904870071518, 2.6749034806198324, 2.3997904870071518, 0.0039696679505141219, 44.341655579367107, 0.0039696679505141219, 44.341655579367107, 2.6749034806198324, 40.813835151037779, 2.6749034806198324, 40.239538802239963, 2.6840192956806277, 38.990672138981267, 2.7934090763992572, 37.760037105843111, 3.0213044529100443, 36.54763370282555, 3.3677054252002563, 35.353461929928528, 3.8234961782090977, 34.186637602212357, 4.3977925270100968, 33.548530547992591, 4.7897725746006472, 32.491096000999818, 5.6101959300303861, 31.698020090755222, 6.5126616210000066, 31.160187002198569, 7.5062854625703039, 30.986986516053211, 8.0076552908794838, 30.777322769666679, 8.837194461370018, 30.613238098581611, 9.82170248787952, 30.46738505761709, 10.988526815590376, 30.357995276893689, 12.310319999340209, 30.285068756411452, 13.805313669219686, 30.230373866049749, 15.473507825250636, 30.221258050989469, 17.305786652370443, 30.221258050989469, 48.016967590459899, 48.024444863721271, 48.016967590459899, 30.221258050989469, 54.006058085069526, 30.221258050989469, 92.429218564160692, 51.771044853497379, 92.429218564160692, 13.06529410753774, 93.012630728020667],
       [75.12576303794124, 97.761970374420343, 2.3997904870071518, 97.761970374420343, 2.3997904870071518, 95.100152376819096, 5.8546843948542451, 95.100152376819096, 6.4563281888328836, 95.081920746699325, 7.7143106671518629, 94.972530965980695, 8.954061515350304, 94.744635589469908, 10.15734910330761, 94.398234617179696, 11.342405061144319, 93.942443864170855, 12.490997758739921, 93.368147515369856, 13.06529410753774, 93.012630728020667, 51.771044853497379, 92.429218564160692, 53.402775749287969, 92.410986934039101, 54.961580124596281, 92.356292043679787, 56.41099471918119, 92.27424970813081, 57.76925116316329, 92.14662829729059, 59.027233641482269, 91.982543626210827, 60.19405796919844, 91.791111509939583, 61.251492516191199, 91.554100318369819, 62.217768912581157, 91.289741681619489, 63.083771343308001, 90.988919784629616, 63.220508569212257, 90.934224894270301, 64.369101266807846, 90.405507620780554, 65.453883258981463, 89.785632196679217, 66.474854545733109, 89.065482806909131, 67.450246757183351, 88.263291081610078, 68.361828263211606, 87.360825390640457, 69.209599063817876, 86.376317364129136, 69.583347481289465, 85.856715905689271, 70.130296384906416, 84.999829290030902, 70.659013658402799, 84.042668708700148, 71.178615116838898, 82.985234161709741, 71.679984945154445, 81.836641464109562, 72.172238958409693, 80.596890615910525, 72.637145526484105, 79.256865802050015, 73.092936279498232, 77.816567022529853, 73.539611217452077, 76.285110092399918, 76.055576174090064, 76.285110092399918, 75.12576303794124, 97.761970374420343],
     ],

 71: [ [104.5242666073524, 53.35969951972038, 66.684518292119606, 53.35969951972038, 66.684518292119606, 50.615839186570156, 67.769300284293223, 50.606723371509361, 69.373683734902954, 50.542912666089251, 70.813982514427593, 50.433522885370621, 72.099312437927438, 50.269438214279944, 73.22055769034219, 50.050658652840866, 74.177718271671864, 49.786300016090536, 74.979909996976716, 49.458130673920095, 76.009997098788645, 48.820023619700805, 76.967157680118319, 48.008716079330043, 77.778465220483454, 47.069787128129974, 78.434803904823809, 46.003236766069676, 78.617120206029455, 45.556561828119811, 78.854131397596802, 44.754370102809844, 79.054679328923015, 43.778977891359318, 79.227879815068391, 42.639501008830848, 79.355501225912334, 41.31770782509011, 79.446659376515171, 39.831829970260515, 79.501354266876859, 38.17275162929036, 79.519585896997427, 36.340472802170552, 79.519585896997427, 8.0814461153004231, 79.227879815068391, 7.917361444209746, 78.079287117472788, 7.2974860201102274, 76.930694419877184, 6.714073856250252, 75.763870092161014, 6.17624076769971, 74.587929949384574, 5.6748709393796162, 73.40287399154785, 5.2099643713099795, 72.208702218650828, 4.781521063470791, 71.005414630693537, 4.3895410158802406, 69.783895412615664, 4.0431400435900287, 69.455726070445493, 3.9519818929893518, 68.234206852367649, 3.6511599959994783, 66.994456004169223, 3.3959171743099432, 65.745589340910513, 3.1771376128599513, 64.478491047531236, 2.9948213116604165, 63.211392754151973, 2.8489682707004249, 61.935178645712398, 2.7486943050298578, 60.640732907152277, 2.693999414670543, 59.337171353531879, 2.6757677845507715, 33.803773369680499, 2.5481463736996375, 34.906786991974691, 2.0741239905692055, 36.028032244389443, 1.6365648676801356, 37.167509126924763, 1.2172373748999235, 38.32521763958065, 0.82525732730937307, 39.501157782357097, 0.45150890984041325, 40.695329555254091, 0.10510793755020131, 41.898617143211389, -0.21394558955944376, 43.129252176349517, -0.51476748654931725, 44.378118839608248, -0.78824193836044287, 45.636101317927228, -1.0343689449800877, 46.921431241427051, -1.2622643214908749, 48.224992795047477, -1.4628122528192762, 49.537670163728158, -1.64512855402063, 50.877694977589691, -1.8000974100505118, 52.226835606511521, -1.9277188208907319, 53.603323680614182, -2.0371086016202753, 54.988927569777097, -2.1191509371601569, 56.392763089060622, -2.1829616425802669, 57.823946053524992, -2.2194249028198101, 59.264244833049617, -2.2285407178806054, 59.49214020955668, -2.2285407178806054, 60.877744098719631, -2.2194249028198101, 62.245116357762022, -2.1829616425802669, 63.58514117162354, -2.1282667522191332, 64.916050170424796, -2.0462244166792516, 66.228727539105492, -1.9550662660694798, 67.523173277665606, -1.836560670290055, 68.790271571044883, -1.6907076293300634, 70.048254049363862, -1.5357387733001815, 71.288004897562288, -1.3534224721006467, 72.509524115640147, -1.1528745407704264, 73.712811703597453, -0.9340949793204345, 74.897867661434177, -0.68796797270078969, 76.064691989150347, -0.42360933595045935, 77.213284686745951, -0.14101906908035744, 78.161329453015327, 0.11422375260917761, 79.337269595791781, 0.45150890984041325, 80.504093923507924, 0.80702569718960149, 81.689149881344676, 1.1990057447801519, 82.865090024121116, 1.6092174224995688, 84.041030166897585, 2.0376607303296623, 85.226086124734294, 2.502567298399299, 86.411142082571018, 2.9857054965996213, 87.596198040407756, 3.4961911399695964, 88.790369813304764, 4.0340242285292334, 89.984541586201786, 4.5900889472104609, 91.178713359098793, 5.1735011110704363, 92.372885131995801, 5.7842607201091596, 93.576172719953092, 6.4223677743193548, 93.576172719953092, 36.340472802170552, 93.576172719953092, 37.115317082299953, 93.612635980194227, 38.847321943749193, 93.694678315736766, 40.433473764240262, 93.81318391152044, 41.873772543760424, 93.968152767545249, 43.1591024672598, 94.168700698871461, 44.307695164859979, 94.414827705499079, 45.310434821489252, 94.688302157307575, 46.158205622099558, 95.016471499477746, 46.869239196799754, 95.244366875984795, 47.242987614270533, 95.918937190445718, 48.136337490179358, 96.730244730810853, 48.892950140179892, 97.669173682019959, 49.51282556427941, 98.73572404407301, 49.995963762479732, 99.939011632030315, 50.342364734769944, 101.26992063083151, 50.542912666089251, 102.7284510404767, 50.615839186570156, 104.5242666073524, 50.615839186570156, 104.5242666073524, 53.35969951972038],
       [79.009100253621597, 95.310680427139232, 58.325315881840531, 94.955163639790044, 59.22778157280851, 94.946047824729249, 60.595153831850858, 94.891352934369934, 61.935178645712398, 94.800194783760162, 63.247856014393108, 94.663457557859147, 64.533185937892938, 94.481141256650517, 65.791168416211917, 94.253245880150644, 67.030919264410343, 93.988887243400313, 68.234206852367649, 93.678949531349645, 84.414778584369145, 93.797455127130888, 84.141304132560677, 93.81568675725066, 83.266185886773528, 93.95242398316077, 82.126709004238236, 94.253245880150644, 80.704641854834136, 94.709036633159485, 79.009100253621597, 95.310680427139232],
       [90.613532825361276, 100.00532518317959, 87.951714827758764, 100.00532518317959, 87.951714827758764, 99.950630292820279, 87.796745971733955, 98.291551951850124, 87.550618965106338, 96.924179692810867, 87.222449622936168, 95.857629330759664, 86.794006315102877, 95.101016680750035, 86.547879308475245, 94.809310598830052, 85.554255466904465, 94.052697948820423, 84.414778584369145, 93.797455127130888, 68.234206852367649, 93.678949531349645, 69.419262810204373, 93.323432744000456, 70.57697132286026, 92.922336881349111, 71.716448205395579, 92.475661943390151, 72.819461827689764, 91.992523745200742, 73.895128004803098, 91.454690656639286, 74.952562551795879, 90.880394307840106, 75.982649653607794, 90.269634698799564, 76.985389310238887, 89.604180199399707, 77.960781521689114, 88.902262439760307, 78.917942103018774, 88.145649789759773, 79.838639424107313, 87.352573879510601, 80.741105115075285, 86.523034709029162, 81.406559614475896, 85.848464394570328, 82.144940634358775, 85.055388484319337, 82.865090024121116, 84.207617683719945, 83.567007783762875, 83.323383622870097, 84.250693913284067, 82.393570486719909, 84.925264227744975, 81.409062460210407, 85.572487097025046, 80.388091173459543, 86.201478336184508, 79.321540811399245, 86.812237945223444, 78.209411374049523, 87.413881739202097, 77.042587046329572, 87.988178087999898, 75.839299458379173, 88.553358621737416, 74.590432795119341, 89.091191710294069, 73.29598705655917, 89.619908983790467, 71.95596224270048, 90.130394627166297, 70.570358353530537, 90.613532825361276, 69.148291204130146, 93.138613597059532, 69.148291204130146, 90.613532825361276, 100.00532518317959],
       [56.957943622798162, 100.00532518317959, 55.754656034840849, 99.987093553070736, 54.369052145677898, 99.950630292820279, 53.010795701695798, 99.886819587400169, 51.670770887834259, 99.786545621740515, 50.348977704093301, 99.658924210900295, 49.036300335412612, 99.503955354870413, 47.750970411912789, 99.321639053670879, 46.48387211853349, 99.111975307279863, 45.225889640214511, 98.865848300649304, 43.995254607076362, 98.601489663900793, 42.77373538899851, 98.3006677669091, 41.579563616101488, 97.972498424740479, 40.394507658264793, 97.616981637389472, 39.227683330548608, 97.234117404859717, 38.088206448013288, 96.814789912090419, 36.957845380538259, 96.377230789190435, 35.845715943183791, 95.903208406060003, 34.760933951010173, 95.401838577739909, 33.68526777389684, 94.873121304250162, 32.627833226904052, 94.317056585570754, 31.588630310031849, 93.724528606649983, 30.859365105209228, 93.286969483759094, 29.792814743156189, 92.621514984359237, 28.75361182628399, 91.928713039780632, 27.73264053953233, 91.217679465069523, 26.729900882901259, 90.47929844519058, 25.74539285639074, 89.722685795190046, 24.78823227506107, 88.93872569999985, 23.840187508791669, 88.136533974700797, 22.919490187703161, 87.306994804210262, 22.017024496735189, 86.459224003610871, 21.132790435887792, 85.584105757819998, 20.266788005160919, 84.681640066850377, 19.419017204554649, 83.760942745759166, 18.59859384912923, 82.812897979489208, 17.78728630876407, 81.846621583099477, 17.003326213579779, 80.862113556589975, 16.22848193345575, 79.841142269839111, 15.480985098512599, 78.81105516802927, 14.76083570875028, 77.744504805970791, 14.04980213404823, 76.668838628860613, 13.35700018946676, 75.55670919151089, 12.69154569006613, 74.426348124030483, 12.035207005725789, 73.277755426439398, 11.4062157665663, 72.101815283660471, 11.24213109548122, 71.782761756550826, 10.658718931623129, 70.615937428830875, 10.09353839788562, 69.439997286059224, 9.5648211243892263, 68.254941328219502, 9.0725671111339636, 67.069885370379779, 8.5985447279992684, 65.875713597490176, 8.1701014201659916, 64.681541824589658, 7.7598897424532822, 63.478254236630164, 7.377025509921423, 62.274966648679765, 7.0306245376306711, 61.062563245659476, 6.7206868255810832, 59.84104402758021, 6.4289807436520334, 58.619524809499126, 6.1737379219641184, 57.388889776360884, 5.9458425454570536, 56.158254743229918, 5.7544104291911253, 54.918503895030881, 5.5903257581060473, 53.669637231769229, 5.453588532201791, 52.420770568509397, 5.3441987514784151, 51.171903905249565, 5.2712722309961464, 49.904805611869961, 5.2256931556947563, 48.637707318490357, 5.2074615255741881, 47.370609025110753, 5.2074615255741881, 47.33414576486939, 5.2256931556947563, 46.030584211250243, 5.2712722309961464, 44.727022657629277, 5.3441987514784151, 43.441692734129902, 5.453588532201791, 42.156362810630526, 5.5903257581060473, 40.898380332309898, 5.7544104291911253, 39.640397853989271, 5.9549583605173382, 38.400647005790233, 6.1828537370244021, 37.160896157600291, 6.4380965587123171, 35.948492754580002, 6.729802640641366, 34.736089351559713, 7.0488561677512394, 33.541917578670109, 7.3952571400419913, 32.347745805769591, 7.769005557513565, 31.18092147804964, 8.1792172352262753, 30.014097150340604, 8.6167763581198358, 28.865504452740424, 9.090798741254531, 27.726027570199221, 9.5830527545097937, 26.595666502729728, 10.111770028006189, 25.47442125031921, 10.67695056174369, 24.371407628019369, 11.260362725601791, 23.277509820789419, 11.880238149701, 22.19272782860935, 12.536576834041339, 21.126177466559966, 13.211147148502249, 20.059627104510582, 13.92218072320429, 19.011308372570056, 14.660561743087159, 17.981221270760216, 15.435406023211179, 16.951134168950375, 16.237597748516041, 15.939278697260306, 16.246713563576321, 15.921047067140535, 17.012442028640059, 15.000349746049324, 17.79640212382435, 14.106999870140498, 18.58947803406895, 13.240997439410421, 19.409901389494362, 12.39322663880921, 20.239440559980089, 11.563687468320495, 21.09632717564665, 10.770611558080418, 21.962329606373491, 9.9866514628902223, 22.855679482281179, 9.2391546279504837, 23.758145173249151, 8.5098894231305167, 24.68795830939797, 7.8079716634892975, 25.626887260607049, 7.1242855339696689, 26.58404784193673, 6.4679468496306072, 27.559440053386961, 5.8389556104702933, 28.562179710018029, 5.228196001429751, 29.574035181709409, 4.6447838375697756, 30.60412228352132, 4.0796033038295718, 31.652441015453832, 3.5508860303398251, 32.718991377506882, 3.0312845718999597, 33.803773369680499, 2.5481463736996375, 59.337171353531879, 2.6757677845507715, 59.337171353531879, 2.6757677845507715, 58.106536320393751, 2.693999414670543, 56.885017102315878, 2.7669259351496294, 55.663497884238012, 2.8854315309399681, 54.451094481220451, 3.0586320170805266, 53.238691078202862, 3.2774115785305185, 52.035403490245578, 3.5417702152699349, 50.832115902288272, 3.8517079273296986, 49.637944129391258, 4.2072247146807058, 48.443772356494257, 4.6174363923892088, 47.258716398657519, 5.0732271453998692, 46.073660440820788, 5.5837127887807583, 44.897720298044327, 6.1306616923902766, 43.721780155267908, 6.7323054863700236, 42.55495582755173, 7.379528355659204, 41.388131499835559, 8.0814461153004231, 40.704445370314367, 8.5098894231305167, 39.729053158864161, 9.1571122924106021, 38.790124207655047, 9.849914236989207, 37.860311071506231, 10.579179441809174, 36.957845380538259, 11.354023721940393, 36.082727134751138, 12.156215447239447, 35.216724704024301, 13.003986247849753, 34.378069718478287, 13.897336123760397, 33.566762178113152, 14.818033444849789, 32.773686267868577, 15.793425656289401, 31.998841987744552, 16.796165312929588, 31.242229337741101, 17.8444840448592, 30.512964132918508, 18.929266037030175, 29.811046373276749, 20.050511289449787, 29.118244428695281, 21.217335617160643, 28.452789929294649, 22.420623205120137, 27.81468287507488, 23.669489868379969, 27.194807450975649, 24.945703976820369, 26.848406478684922, 25.702316626820902, 26.356152465429659, 26.832677694299491, 25.882130082294971, 27.97215457682978, 25.44457095940141, 29.120747274429959, 25.02524346662841, 30.287571602140815, 24.633263419036268, 31.463511744919742, 24.268630816624981, 32.648567702759465, 23.922229844334229, 33.851855290709864, 23.612292132284612, 35.055142878669358, 23.32058605035559, 36.276662096750442, 23.047111598547101, 37.516412944949479, 22.81010040697976, 38.756163793150336, 22.60043666059326, 40.014146271469144, 22.409004544327331, 41.281244564839653, 22.24491987324225, 42.557458673289148, 22.09906683227771, 43.851904411849318, 21.989677051554342, 45.146350150409489, 21.898518900951501, 46.459027519089432, 21.834708195529512, 47.789936517889146, 21.798244935288409, 49.120845516690679, 21.789129120228129, 50.469986145610164, 21.789129120228129, 51.44537835706069, 21.825592380469232, 52.821866431160743, 21.88028727083093, 54.189238690209095, 21.971445421433771, 55.529263504069604, 22.08083520215715, 56.860172502869318, 22.217572428061398, 58.172849871549261, 22.38165709914648, 59.476411425170227, 22.582205030472689, 60.752625533610626, 22.80098459191947, 62.01972382699023, 23.047111598547101, 63.277706305310858, 23.3114702352953, 64.5083413384491, 23.612292132284612, 65.72986055651927, 23.940461474454789, 66.933148144480583, 24.2959782618058, 68.127319917379282, 24.669726679277399, 69.294144245090138, 25.079938356990109, 70.451852757749293, 25.508381664823389, 71.600445455340378, 25.973288232897801, 72.72169070775999, 26.45642643109278, 73.833820145120626, 26.966912074468581, 74.927717952350577, 27.50474516302527, 76.012499944519732, 28.069925696762802, 77.079050306580029, 28.662453675681149, 78.127369038509642, 29.282329099780348, 79.157456140319482, 29.929551969060409, 80.178427427070346, 30.093636640145519, 80.41543861864011, 30.822901844968101, 81.472873165630517, 31.579514494971569, 82.493844452379562, 32.363474590155853, 83.469236663830088, 33.165666315460733, 84.408165615039252, 33.995205485946428, 85.301515490949896, 34.842976286552698, 86.158402106619178, 35.727210347400103, 86.978825462039822, 36.629676038368082, 87.753669742169222, 37.550373359456621, 88.492050762049985, 38.498418125726012, 89.193968521689385, 39.473810337176253, 89.850307206030266, 40.467434178747027, 90.470182630129784, 41.488405465498687, 91.044478978930783, 42.53672419743117, 91.582312067479506, 43.612390374544503, 92.0836818957996, 44.706288181778397, 92.539472648810261, 45.818417619132873, 92.958800141590473, 46.967010316728469, 93.341664374120228, 48.124718829384364, 93.678949531349645, 49.318890602281378, 93.979771428339518, 50.531294005298939, 94.235014250030872, 51.771044853497379, 94.45379381146995, 53.038143146876649, 94.636110112680399, 54.32347307037648, 94.772847338579595, 55.636150439057189, 94.873121304250162, 56.967059437858431, 94.936932009670272, 58.325315881840531, 94.955163639790044, 79.009100253621597, 95.310680427139232, 78.881478842777653, 95.365375317500366, 77.340906097589894, 95.921440036179774, 75.864144057824134, 96.450157309669521, 74.4694243536009, 96.924179692810867, 73.138515354799651, 97.361738815699937, 71.880532876480657, 97.762834678360377, 70.695476918643934, 98.118351465709566, 69.592463296349749, 98.437404992819211, 68.553260379477535, 98.710879444619422, 67.586983983087578, 98.947890636189186, 66.684518292119606, 99.13932275246043, 65.946137272236726, 99.276059978359626, 64.751965499339718, 99.46749209463087, 63.539562096322129, 99.631576765710633, 62.28157961800315, 99.768313991620744, 61.005365509563603, 99.868587957280397, 59.68357232582261, 99.941514477759483, 58.334431696900822, 99.987093553070736, 56.957943622798162, 100.00532518317959],
     ],

 72: [ [103.58812744744471, 97.769849418080412, 61.783778797168317, 97.769849418080412, 61.783778797168317, 95.108620205759507, 65.251758597479466, 95.108620205759507, 66.351873035644616, 95.056233803939904, 67.766305884714114, 94.867642757399153, 69.138829612329715, 94.521892505399592, 70.490398779218339, 94.018983047950314, 71.810536105016553, 93.369391665419244, 71.946740749741764, 93.296050702880166, 73.23544623444954, 92.395004591620818, 74.199356027889479, 91.389185676720444, 74.838470130061637, 90.278593958200872, 75.058493017694673, 89.58709345419993, 75.278515905327708, 88.591751819669298, 75.456629671506818, 87.386864577869346, 75.592834316232029, 85.961954448439428, 75.687129839503342, 84.327498711740191, 75.749993521684175, 82.473020087400073, 75.770948082411167, 80.398518575440903, 75.770948082411167, 52.424180004949449, 30.36241498709844, 52.424180004949449, 75.770948082411167, 47.091244299939717, 75.770948082411167, 17.314813506940482, 75.749993521684175, 15.313652957509476, 75.666175278776365, 13.396310650989108, 75.519493353687693, 11.688513951750792, 75.330902307145095, 10.179785579410236, 75.068970298058133, 8.8806028143408184, 74.765129167517273, 7.7804883761691599, 74.398424354795566, 6.8899195452795539, 73.968855859892983, 6.2088963216501725, 73.162105271905176, 5.3183274907496525, 72.17724091773826, 4.5115769027597707, 71.066649199209621, 3.8515082398698723, 69.809375555592283, 3.3381215020599484, 68.426374547613221, 2.9714166893390939, 66.907168894908949, 2.7513938017000328, 65.251758597479466, 2.6780528391591361, 61.783778797168317, 2.6780528391591361, 61.783778797168317, 0.0063463464703090722, 103.58812744744471, 0.0063463464703090722, 103.58812744744471, 2.6780528391591361, 100.130624927497, 2.6780528391591361, 98.978124087514459, 2.7304392409805587, 97.574168518808435, 2.9190302875194902, 96.191167510829374, 3.2647805395099567, 94.829121063577261, 3.7676899969592341, 93.498506457415573, 4.4068040991296584, 93.425165494871237, 4.4591905009492621, 92.136460010163461, 5.3602366122104286, 91.183027497086982, 6.3870100878302765, 90.543913394914838, 7.5080790867195901, 90.334367787645277, 8.1576704692597559, 90.114344900012256, 9.1425348234206467, 89.925753853469644, 10.347422065220599, 89.789549208744432, 11.76185491428987, 89.684776405109659, 13.396310650989108, 89.632390003292272, 15.250789275329225, 89.611435442565309, 17.314813506940482, 89.611435442565309, 80.398518575440903, 89.621912722928798, 81.791996863779787, 89.663821844382724, 83.698861889930413, 89.747640087290506, 85.396181308809901, 89.873367451652257, 86.863000559700595, 90.030526657104431, 88.12027420332015, 90.229594984010504, 89.157524959300645, 90.470572432370474, 89.985230108019095, 90.659163478913101, 90.467185004739804, 91.361141263266106, 91.661594966170014, 92.335528337069547, 92.656936600700647, 93.571847419959909, 93.442732627969235, 94.556711774126839, 93.924687524680849, 95.897803660651974, 94.438074262499867, 97.280804668631063, 94.804779075220722, 98.684760237337088, 95.035279243209516, 100.130624927497, 95.108620205759507, 103.58812744744471, 95.108620205759507, 103.58812744744471, 97.769849418080412],
       [44.422925234885618, 97.769849418080412, 2.5452356220648791, 97.769849418080412, 2.5452356220648791, 95.108620205759507, 6.0027381420125741, 95.108620205759507, 7.1552389819951108, 95.056233803939904, 8.5696718310646105, 94.857165477029412, 9.9421955586802113, 94.511415225040764, 11.30424200593232, 94.018983047950314, 12.634856612094, 93.369391665419244, 12.70819757463833, 93.327482543969381, 13.99690305934611, 92.415959152340292, 14.95033557242259, 91.399662957090186, 15.589449674594739, 90.278593958200872, 15.80947256222778, 89.58709345419993, 16.029495449860811, 88.591751819669298, 16.207609216039931, 87.386864577869346, 16.343813860765142, 85.961954448439428, 16.448586664399912, 84.327498711740191, 16.500973066217298, 82.473020087400073, 16.521927626944269, 80.398518575440903, 16.521927626944269, 17.314813506940482, 16.500973066217298, 15.355562078970252, 16.427632103672959, 13.427742492089237, 16.291427458947751, 11.709468512479361, 16.10283641240515, 10.190262859770883, 15.861858964045171, 8.891080094699646, 15.55801783350431, 7.7909656565298064, 15.20179030114606, 6.9003968256402004, 14.79317636697043, 6.2088963216501725, 13.95499393789221, 5.2764183692997904, 12.97012958372529, 4.4801450616796501, 11.84906058483317, 3.8305536791394843, 10.59178694121583, 3.3276442216902069, 9.1983086528732798, 2.9714166893390939, 7.6686257198055179, 2.7513938017000328, 6.0027381420125741, 2.6780528391591361, 2.5452356220648791, 2.6780528391591361, 2.5452356220648791, 0.0063463464703090722, 44.422925234885618, 0.0063463464703090722, 44.422925234885618, 2.6780528391591361, 40.881604472030133, 2.6780528391591361, 39.781490033864962, 2.7199619606108172, 38.377534465158952, 2.9190302875194902, 36.994533457179863, 3.2647805395099567, 35.642964290291232, 3.7572127165894926, 34.322826964493018, 4.4068040991296584, 34.186622319767807, 4.4906223420402966, 32.897916835060059, 5.3916684532996442, 31.934007041620092, 6.397487368189104, 31.305370219811429, 7.5080790867195901, 31.08534733217839, 8.1576704692597559, 30.865324444545351, 9.1425348234206467, 30.687210678366242, 10.347422065220599, 30.540528753277538, 11.76185491428987, 30.446233230006261, 13.396310650989108, 30.383369547825382, 15.250789275329225, 30.36241498709844, 17.314813506940482, 30.36241498709844, 47.091244299939717, 75.770948082411167, 47.091244299939717, 30.36241498709844, 52.424180004949449, 30.36241498709844, 80.398518575440903, 30.372892267461889, 81.791996863779787, 30.414801388915819, 83.698861889930413, 30.49861963182364, 85.396181308809901, 30.62434699618537, 86.863000559700595, 30.791983482001012, 88.12027420332015, 30.991051808907098, 89.157524959300645, 31.23202925726709, 89.985230108019095, 31.420620303809681, 90.446230444009416, 32.143552648889639, 91.651117685809368, 33.117939722693102, 92.656936600700647, 34.322826964493018, 93.442732627969235, 35.307691318659927, 93.924687524680849, 36.659260485548593, 94.438074262499867, 38.031784213164158, 94.804779075220722, 39.446217062233657, 95.035279243209516, 40.881604472030133, 95.108620205759507, 44.422925234885618, 95.108620205759507, 44.422925234885618, 97.769849418080412],
     ],

 73: [ [45.571828439943019, 97.768742889089481, 3.694738030132569, 97.768742889089481, 3.694738030132569, 95.098319732520395, 7.1596672498112213, 95.098319732520395, 8.0424517643790381, 95.065215313219596, 9.5211158262801092, 94.88865841030929, 10.966675468884899, 94.546579410920458, 12.3901654986255, 94.038978315040367, 13.7915859155019, 93.365855122679932, 15.038519042328931, 92.505140220979229, 16.064756040513981, 91.445798803490106, 16.737879232871951, 90.265074515260494, 16.88133171648921, 89.856786677270065, 17.124097457995369, 88.885723711249739, 17.32272397377314, 87.671895003719328, 17.4772112638225, 86.226335361110614, 17.587559328143449, 84.549044783430872, 17.65376816673604, 82.617953657820181, 17.675837779600261, 80.466166403559328, 17.675837779600261, 17.302934386230845, 17.664802973168161, 16.033931646539713, 17.609628941007671, 13.948353230869543, 17.4772112638225, 12.094505750279495, 17.300654360908919, 10.461354398330514, 17.046853812970689, 9.0599339814507402, 16.74891403930404, 7.879209693219309, 16.373730620612729, 6.9302163400607242, 15.95440797619302, 6.2019191155395674, 15.35852842885974, 5.5287959231791319, 14.365395849970961, 4.6570462150502863, 13.217775981032799, 3.939783796959091, 11.926703628477391, 3.3880434753591544, 10.492178792304699, 2.9907904438005062, 8.8921318596505472, 2.7480247022904223, 7.1596672498112213, 2.6707810572697781, 3.694738030132569, 2.6707810572697781, 3.694738030132569, 0.000357900700691971, 45.571828439943019, 0.000357900700691971, 45.571828439943019, 2.6707810572697781, 42.04069038167178, 2.6707810572697781, 41.21307989926445, 2.692850670129701, 39.723381030931272, 2.8694075730491022, 38.277821388326473, 3.2114865724397532, 36.865366165017988, 3.7301224747498054, 35.486015361005791, 4.4032456671102409, 34.161838589154073, 5.2970649881099234, 33.124566784536903, 6.3343367927300278, 32.451443592178961, 7.5040262745296786, 32.307991108561673, 7.9123141125201073, 32.065225367055533, 8.883377078540434, 31.866598851277772, 10.097205786070845, 31.712111561228411, 11.542765428679559, 31.60176349690742, 13.220056006350205, 31.53555465831484, 15.151147131969992, 31.513485045450651, 17.302934386230845, 31.513485045450651, 80.466166403559328, 31.524519851882751, 81.7793083689794, 31.590728690475331, 83.853851978210514, 31.723146367660512, 85.6966646523706, 31.921772883438269, 87.329816004319582, 32.17557343137652, 88.720201614769394, 32.495582817907327, 89.900925903000825, 32.870766236598669, 90.838884449729449, 33.323193300314657, 91.567181674250605, 33.863898815487438, 92.207200447310242, 34.857031394376222, 93.089984961879964, 36.004651263314393, 93.807247379960245, 37.284688809437696, 94.370022507999238, 38.730248452042488, 94.778310345989667, 40.308225771832447, 95.021076087490655, 42.04069038167178, 95.098319732520395, 45.571828439943019, 95.098319732520395, 45.571828439943019, 97.768742889089481],
     ],

 74: [ [10.394360294874931, 16.370314916899588, 9.2639992273998928, 16.297388396420502, 8.0607116394426157, 16.033029759670171, 6.9212347569072961, 15.586354821720306, 5.8546843948542451, 14.957363582559992, 4.8519447382231533, 14.136940227130253, 4.3961539852090246, 13.617338768699483, 3.8036260062906702, 12.660178187370548, 3.3842985135176771, 11.538932934949116, 3.1290556918297621, 10.253603011449741, 3.0470133562872088, 8.8041884168706019, 3.0470133562872088, 8.6401037457799248, 3.147287321950329, 7.4550477879492973, 3.3934143285779612, 6.3064550903491181, 3.794510191230386, 5.194325652999396, 4.3505749099076061, 4.1277752909390983, 5.061608484609649, 3.0976881891292578, 5.9276109153364871, 2.1131801626197557, 23.44820746119953, 2.8880244427491562, 23.393512570837832, 2.8880244427491562, 22.409004544327331, 3.0612249288897146, 21.497423038299079, 3.5352473120201466, 20.649652237692809, 4.3100915921495471, 19.883923772629061, 5.3948735843205213, 19.191121828047581, 6.780477473490464, 18.926763191299379, 7.4003528975899826, 18.197497986476801, 9.0229679783096799, 17.495580226835042, 10.463266757840756, 16.839241542494701, 11.721249236159565, 16.21936611839547, 12.778683783149972, 15.635953954537399, 13.662917843999821, 15.089005050920431, 14.355719788580245, 14.578519407544629, 14.857089616900339, 13.940412353324859, 15.321996184969976, 12.8191671009101, 15.905408348829951, 11.643226958133649, 16.260925136179139, 10.394360294874931, 16.370314916899588],
       [56.602426835447119, 97.765427590169566, 14.72437244850914, 97.765427590169566, 14.72437244850914, 95.103609592559224, 18.252192876838478, 95.103609592559224, 18.771794335274588, 95.094493777500247, 20.029776813593571, 94.985103996779799, 21.260411846731731, 94.757208620270831, 22.472815249749321, 94.410807647980619, 23.65787120758603, 93.955016894969958, 24.81557972024191, 93.371604731109983, 25.453686774461691, 92.979624683519432, 26.502005506394202, 92.159201328089694, 27.30419723169905, 91.256735637120073, 27.842030320255731, 90.272227610610571, 28.015230806401089, 89.761741967240596, 28.215778737727309, 88.941318611810857, 28.388979223872671, 87.94769477024056, 28.525716449776919, 86.789986257579585, 28.635106230500298, 85.459077258790785, 28.717148566042852, 83.964083588900394, 28.762727641344242, 82.295889432869444, 28.780959271464809, 80.463610605749636, 28.780959271464809, 13.70849691930016, 28.75361182628399, 12.204387434350792, 28.653337860620869, 10.663814689169158, 28.489253189535791, 9.2690949849402386, 28.25224199796844, 8.0384599518092728, 27.94230428591883, 6.9627937746899988, 27.568555868447248, 6.0420964536006068, 27.121880930493401, 5.2672521734803013, 26.474658061213351, 4.4741762632402242, 25.499265849763109, 3.5990580174493516, 24.487410378071761, 3.0703407439505099, 23.44820746119953, 2.8880244427491562, 5.9276109153364871, 2.1131801626197557, 6.9394663870278626, 1.1651353963497968, 7.0397403526909548, 1.0739772457491199, 7.9330902285986431, 0.38117530117051501, 8.8993666249886019, -0.22958430787002726, 9.9385695418608009, -0.75830158137068793, 11.041583164155011, -1.2049765193205531, 12.21752330693144, -1.5787249367895129, 13.45727415512988, -1.8613152036596148, 14.76995152381056, -2.0618631349898351, 16.155555412973509, -2.1894845458300551, 17.604970007558421, -2.2259478060695983, 18.07899239069312, -2.2259478060695983, 19.409901389494362, -2.1621371006494883, 20.704347128054479, -2.0436315048700635, 21.962329606373491, -1.8521993886006385, 23.192964639511612, -1.5878407518503082, 24.38713641240864, -1.2687872247406631, 25.553960740124811, -0.87680717715011269, 26.693437622660131, -0.41190060908047599, 27.796451244954309, 0.11681666442018468, 28.863001607007359, 0.70934464333913638, 29.902204523879561, 1.3656833276800171, 30.90494418051065, 2.0949485324999841, 31.880336391960899, 2.8880244427491562, 32.481980185939527, 3.4167417162407219, 33.439140767269208, 4.3192074072103424, 34.350722273297457, 5.2399047282997344, 35.207608888964018, 6.1970653096304886, 36.018916429329153, 7.1815733361399907, 36.775529079332607, 8.1843129927692644, 37.486562654034657, 9.2144000945791049, 38.133785523314707, 10.280950456630308, 38.735429317293352, 11.365732448810377, 39.291494035970572, 12.477861886160099, 39.792863864286119, 13.617338768699483, 40.239538802239963, 14.784163096410339, 40.303349507661949, 14.966479397620787, 40.622403034771843, 15.960103239189266, 40.914109116700871, 16.999306156059902, 41.187583568509353, 18.074972333179176, 41.433710575136978, 19.196217585589693, 41.661605951644049, 20.353926098250668, 41.862153882970262, 21.557213686199248, 42.035354369115623, 22.796964534400104, 42.190323225140453, 24.082294457899479, 42.317944635984389, 25.413203456699193, 42.427334416707758, 26.78057571574027, 42.509376752250311, 28.193527050090779, 42.573187457672297, 29.642941644669918, 42.600534902853148, 31.128819499499514, 42.618766532973723, 32.669392244690243, 42.618766532973723, 80.463610605749636, 42.636998163094283, 82.323236878050011, 42.700808868516248, 84.046125924440275, 42.810198649239652, 85.595814484689981, 42.956051690204163, 86.999650003970601, 43.147483806470092, 88.230285037110662, 43.384494998037432, 89.30595121422084, 43.657969449845922, 90.217532720249437, 43.986138792016114, 90.974145370260885, 44.341655579367107, 91.566673349170742, 44.997994263707447, 92.314170184119575, 45.836649249253441, 93.052551204000338, 46.784694015522831, 93.681542443160652, 47.833012747455307, 94.192028086539722, 48.981605445050917, 94.593123949189248, 50.239587923369918, 94.87571421605935, 51.597844367352018, 95.039798887139114, 53.0654905920575, 95.103609592559224, 56.602426835447119, 95.103609592559224, 56.602426835447119, 97.765427590169566],
     ],

 75: [ [95.016471499477746, 97.7662918941096, 59.118391792085099, 97.7662918941096, 59.118391792085099, 95.104473896510171, 61.35176648185432, 95.104473896510171, 61.780209789687603, 95.095358081449376, 63.302550904754781, 94.995084115789723, 64.587880828254626, 94.75807292421996, 65.645315375247407, 94.384324506749181, 66.474854545733109, 93.873838863370111, 67.195003935495436, 93.135457843489348, 67.787531914413805, 92.078023296489846, 67.988079845740003, 90.920314783839785, 67.96984821561945, 90.583029626610369, 67.796647729474088, 89.516479264559166, 67.4228993120025, 88.377002382019782, 66.83037133308413, 87.164598978999493, 66.037295422839549, 85.870153240439322, 65.782052601151648, 85.505520638029338, 65.417419998740343, 85.013266624779135, 65.016324136087903, 84.484549351280293, 64.569649198134059, 83.919368817540089, 64.086510999939094, 83.335956653689209, 63.557793726442704, 82.7069654145198, 62.992613192705193, 82.059742545250629, 62.381853583666242, 81.376056415720086, 61.734630714386178, 80.655907025959095, 61.04182876980471, 79.908410191019357, 60.312563564982128, 79.124450095829161, 59.546835099918383, 78.313142555469312, 58.726411744492957, 77.474487569919802, 57.878640943886701, 76.599369324139843, 56.985291067978999, 75.696903633170223, 56.046362116769892, 74.75797468195924, 55.070969905319657, 73.782582470510533, 54.049998618568019, 72.788958628940236, 52.992564071575231, 71.7497557120696, 51.89866626434133, 70.692321165070098, 50.75918938180601, 69.598423357840147, 49.5741334239693, 68.46806229035974, 48.352614205891427, 67.310353777709679, 47.094631727572448, 66.125297819869957, 45.791070173952022, 64.903778601790691, 44.441929545030227, 63.645796123479158, 43.056325655867283, 62.369582015040578, 41.63425850646319, 61.047788831290745, 40.166612281757722, 59.698648202369441, 39.373536371513133, 58.978498812610269, 37.896774331747373, 57.611126553569193, 36.54763370282555, 56.36225989030936, 35.316998669687401, 55.222783007769976, 34.223100862453492, 54.210927536079907, 33.247708651003251, 53.308461845110287, 32.399937850396981, 52.524501749929186, 31.688904275694942, 51.849931435470353, 31.09637629677659, 51.302982531849921, 30.631469728702172, 50.865423408960851, 30.294184571471732, 50.546369881849387, 30.294184571471732, 48.814365020389232, 64.022700294517094, 15.441366084700348, 64.524070122832654, 14.93999625638935, 65.76382097103108, 13.682013778070541, 66.784792257782726, 12.597231785890472, 67.596099798147861, 11.667418649749379, 68.18862777706623, 10.91080599973975, 68.562376194537819, 10.318278020820799, 68.799387386105167, 9.7439816720197996, 69.10932509815477, 8.5406940840694006, 69.209599063817876, 7.2189009003195679, 69.209599063817876, 7.2097850852696865, 69.009051132491663, 6.0976556479108694, 68.407407338513011, 5.0675685460992099, 67.413783496942216, 4.119523779829251, 67.395551866821648, 4.1104079647702747, 66.556896881275662, 3.5908065063304093, 65.526809779463733, 3.1897106436808826, 64.323522191506441, 2.9071203768107807, 62.9288024872832, 2.7339198906702222, 61.35176648185432, 2.6792250003109075, 61.35176648185432, 0.0082911876397702144, 107.8424232892952, 0.0082911876397702144, 107.8424232892952, 2.6792250003109075, 107.4322116115825, 2.7065724454896554, 106.219808208565, 2.8341938563298754, 105.0074048055474, 3.0165101575403241, 103.79500140252981, 3.2444055340401974, 102.5825979995122, 3.5361116159692756, 101.3701945964947, 3.8733967732005112, 100.1577911934771, 4.2653768208001566, 98.94538779045952, 4.7029359436892264, 97.732984387441931, 5.2043057720002253, 96.511465169364072, 5.7512546756206575, 95.299061766346497, 6.3528984696004045, 95.134977095261405, 6.4349408051402861, 94.296322109715419, 6.8907315581600415, 93.430319678988567, 7.3921013864692213, 92.546085618141177, 7.9390502900896536, 91.643619927173205, 8.5406940840694006, 90.704690975964098, 9.187916953349486, 89.756646209694736, 9.8898347129907052, 88.78125399824448, 10.637331547930444, 87.778514341613388, 11.430407458179616, 86.757543054861756, 12.278178258780827, 85.718340137989557, 13.171528134689652, 84.651789775936507, 14.119572900959611, 83.567007783762875, 15.113196742529908, 82.454878346408407, 16.16151547445952, 81.324517278933385, 17.246297466639589, 80.166808766277484, 18.394890164230674, 44.13199183298061, 54.220043351140703, 59.045465271602843, 69.078821899400282, 59.400982058953872, 69.43433868674947, 60.941554804141617, 71.011374692179743, 62.400085213786809, 72.497252547009339, 63.776573287889477, 73.901088066289958, 65.061903211389321, 75.204649619909105, 66.256074984286329, 76.42616883799019, 67.368204421640797, 77.556529905459684, 68.389175708392443, 78.595732822339414, 69.32810465960155, 79.534661773550397, 70.17587546020782, 80.391548389219679, 70.941603925271551, 81.157276854279189, 71.616174239732459, 81.831847168739841, 72.199586403590544, 82.424375147660612, 72.70095623190609, 82.916629160910816, 73.1111679096188, 83.317725023560342, 73.43933725178897, 83.627662735609192, 73.676348443356318, 83.855558112119979, 73.9498228951648, 84.101685118750538, 75.107531407820673, 85.15000385068015, 76.219660845175142, 86.134511877189652, 77.29532702228849, 87.046093383220068, 78.334529939160674, 87.90297999888935, 79.328153780731498, 88.696055909129427, 80.285314362061143, 89.416205298890418, 81.196895868089413, 90.081659798290275, 82.072014113876534, 90.674187777209227, 82.901553284362265, 91.212020865770683, 83.585239413883443, 91.604000913359414, 84.870569337383273, 92.324150303120405, 86.073856925340564, 92.944025727219923, 87.213333807875884, 93.472743000720584, 88.270768354868665, 93.901186308550677, 89.246160566318878, 94.238471465780094, 89.911615065719516, 94.420787766990543, 91.105786838616524, 94.69426221879985, 92.354653501875234, 94.903925965179951, 93.658215055495646, 95.031547376029266, 95.016471499477746, 95.104473896510171, 95.016471499477746, 97.7662918941096],
       [44.13199183298061, 97.7662918941096, 2.4727170074894209, 97.7662918941096, 2.4727170074894209, 95.104473896510171, 5.9276109153364871, 95.104473896510171, 6.5110230791945858, 95.0862422663904, 7.7598897424532822, 94.976852485669951, 8.9905247755914388, 94.748957109159164, 10.193812363548711, 94.411671951929748, 11.387984136445739, 93.946765383849197, 12.56392427922219, 93.372469035050017, 13.083525737658279, 93.044299692879576, 14.150076099711351, 92.223876337460752, 14.961383640076489, 91.321410646489312, 15.51744835875374, 90.346018435040605, 15.69976465995938, 89.789953716370292, 15.9003125912856, 88.942182915759986, 16.064397262370669, 87.939443259130712, 16.21025030333519, 86.772618931410761, 16.3105242689983, 85.441709932609228, 16.39256660454086, 83.946716262720656, 16.438145679842251, 82.287637921750502, 16.456377309962821, 80.46447490968967, 16.456377309962821, 17.310108172059699, 16.429029864781992, 15.450481899759325, 16.365219159360009, 13.736708668429856, 16.264945193696889, 12.177904293119354, 16.109976337672091, 10.78318458889953, 15.91854422140616, 9.5434337407004932, 15.681533029838819, 8.4677675635794003, 15.40805857803033, 7.5561860575598985, 15.089005050920431, 6.7995734075502696, 14.72437244850914, 6.2070454286404129, 14.03157050392767, 5.4230853334502171, 13.19291551838168, 4.6938201286302501, 12.244870752112289, 4.0830605195897078, 11.18743620511952, 3.5725748762106377, 10.03884350752392, 3.1805948286200874, 8.7717452141446586, 2.8980045617499854, 7.404372955102275, 2.7339198906702222, 5.9276109153364871, 2.6792250003109075, 2.4727170074894209, 2.6792250003109075, 2.4727170074894209, 0.0082911876397702144, 44.13199183298061, 0.0082911876397702144, 44.13199183298061, 2.6792250003109075, 40.813835151037779, 2.6792250003109075, 40.294233692601658, 2.6883408153698838, 39.036251214282693, 2.7977305960903323, 37.805616181144529, 3.0165101575403241, 36.593212778126968, 3.3629111298305361, 35.417272635350507, 3.8278176979001728, 34.259564122694627, 4.4021140466993529, 33.621457068474847, 4.7940940942899033, 32.564022521482087, 5.6145174497196422, 31.770946611237491, 6.5169831406801677, 31.22399770762053, 7.5106069822504651, 31.059913036535448, 8.0119768105705589, 30.850249290148948, 8.8415159810592741, 30.67704880400359, 9.8260240075705951, 30.540311578099359, 10.992848335279632, 30.430921797375959, 12.31464151902037, 30.357995276893689, 13.809635188910761, 30.303300386532019, 15.477829344939892, 30.294184571471732, 17.310108172059699, 30.294184571471732, 48.814365020389232, 30.294184571471732, 50.546369881849387, 30.294184571471732, 80.46447490968967, 30.294184571471732, 81.421635491020425, 30.330647831712842, 83.171871982600351, 30.38534272207454, 84.739792172969828, 30.476500872677381, 86.134511877189652, 30.60412228352132, 87.356031095270737, 30.75909113954614, 88.404349827200349, 30.941407440751789, 89.279468072989403, 31.160187002198569, 89.981385832630622, 31.579514494971569, 90.902083153720014, 32.281432254613321, 91.904822810349287, 33.17478213052101, 92.752593610959593, 34.259564122694627, 93.445395555540017, 34.706239060648471, 93.673290932050804, 35.900410833545493, 94.183776575420779, 37.10369842150277, 94.584872438070306, 38.32521763958065, 94.876578519999384, 39.564968487779062, 95.040663191090061, 40.813835151037779, 95.104473896510171, 44.13199183298061, 95.104473896510171, 44.13199183298061, 97.7662918941096],
     ],

 76: [ [84.633558145815925, 27.037606204639815, 84.013682721716705, 25.579075794990786, 83.393807297617485, 24.166124460649371, 82.764816058457995, 22.816983831729885, 82.144940634358775, 21.540769723289486, 81.515949395199286, 20.328366320269197, 80.886958156039825, 19.188889437729813, 80.267082731940576, 18.113223260619634, 79.638091492781101, 17.11048360399036, 79.01821606868188, 16.171554652779378, 78.389224829522391, 15.305552222060214, 77.760233590362901, 14.503360496750247, 77.140358166263681, 13.77409529193028, 77.040084200600575, 13.664705511200737, 76.101155249391454, 12.661965854569644, 75.134878853001524, 11.741268533480252, 74.150370826491013, 10.89349773288086, 73.138515354799651, 10.127769267810436, 72.099312437927438, 9.4440831382908073, 71.041877890934671, 8.8424393443092413, 69.95709589876104, 8.3137220708194945, 68.854082276466855, 7.8670471328605345, 68.48944967405555, 7.7394257220203144, 67.678142133690415, 7.4932987153897557, 66.775676442722443, 7.2654033388807875, 65.791168416211917, 7.0648554075596621, 64.724618054158853, 6.8825391063492134, 63.56690954150298, 6.7275702503302455, 62.327158693304568, 6.5908330244201352, 60.996249694503312, 6.4723274286407104, 59.583298360159517, 6.3720534629792382, 58.079188875212907, 6.299126942489238, 56.493037054723743, 6.2444320521299232, 54.824842898692019, 6.2170846069493564, 53.0654905920575, 6.2079687918903801, 45.92780739985627, 6.2079687918903801, 14.61498266778576, 5.5607459226102947, 13.78544349730004, 4.7950174575507845, 12.85563036115121, 4.147794588270699, 11.816427444279009, 3.6190773147700384, 10.68606637680398, 3.1997498220007401, 9.4463155286055667, 2.9080437400698429, 8.0971748996837505, 2.7348432539292844, 6.6477603050988128, 2.6710325485000794, 2.9740868358049681, 2.6710325485000794, 2.9740868358049681, 0.0092145509006513748, 78.653583466270589, 0.0092145509006513748, 87.012785876549657, 26.536236376319721, 84.633558145815925, 27.037606204639815],
       [47.231368953476668, 97.767215257370481, 2.9740868358049681, 97.767215257370481, 2.9740868358049681, 95.096281444710257, 6.6477603050988128, 95.096281444710257, 7.258519914137735, 95.087165629649462, 8.6714712484815362, 94.986891663980714, 9.9750328021019357, 94.758996287480841, 11.178320390059239, 94.421711130249605, 12.29044982741371, 93.975036192290645, 13.293189484044801, 93.409855658559536, 14.20477099007303, 92.726169529039908, 15.006962715377909, 91.92397780372994, 15.171047386462989, 91.732545687460515, 15.56302743405513, 91.103554448300201, 15.90942840634588, 90.319594353119101, 16.201134488274931, 89.371549586849142, 16.456377309962821, 88.277651779619191, 16.666041056349311, 87.028785116359359, 16.821009912374141, 85.615833782010668, 16.9395155081578, 84.057029406709262, 17.003326213579779, 82.334140360309902, 17.03067365876063, 80.465398272950551, 17.03067365876063, 17.383958055799667, 17.02155784370035, 16.271828618449945, 16.975978768398932, 14.503360496750247, 16.893936432856378, 12.898977046139407, 16.766315022012432, 11.449562451549355, 16.602230350927361, 10.173348343119869, 16.39256660454086, 9.0612189057592332, 16.137323782852938, 8.1131741394892742, 15.84561770092389, 7.3292140443099925, 15.51744835875374, 6.7093386202104739, 15.33513205754806, 6.4540957985191199, 14.61498266778576, 5.5607459226102947, 45.92780739985627, 6.2079687918903801, 44.195802538402603, 6.2079687918903801, 42.317944635984389, 6.235316237069128, 40.649750479952672, 6.2808953123694664, 39.163872625126629, 6.3447060178004904, 37.878542701626799, 6.4176325382795767, 36.784644894392898, 6.5179065039392299, 35.891295018485209, 6.6364120997204736, 35.18937725884345, 6.7731493256305839, 34.688007430527911, 6.9281181816495518, 33.721731034137953, 7.4112563798498741, 32.755454637748016, 8.1861006599701795, 32.01707361786513, 9.1614928714298003, 31.82564150159919, 9.5808203641990985, 31.533935419670151, 10.446822794920081, 31.2969242281028, 11.486025711799812, 31.10549211183687, 12.698429114809187, 30.97787070099292, 14.08403300397913, 30.89582836545037, 15.642837379280536, 30.868480920269519, 17.383958055799667, 30.868480920269519, 78.806319931980397, 30.87759673532981, 80.264850341629426, 30.914059995570941, 82.051550093439801, 30.97787070099292, 83.665049359109616, 31.078144666656019, 85.105348138640693, 31.205766077499991, 86.390678062140069, 31.369850748585069, 87.502807499489791, 31.552167049790711, 88.45085226575975, 31.770946611237491, 89.22569654588915, 32.01707361786513, 89.836456154920597, 32.390822035336697, 90.474563209139887, 33.10185561003874, 91.386144715170303, 33.995205485946428, 92.215683885660837, 35.079987478120053, 92.972296535659552, 36.347085771499337, 93.655982665179181, 36.866687229935422, 93.883878041689968, 37.73268966066226, 94.184699938679842, 38.717197687172792, 94.439942760369377, 39.829327124527261, 94.658722321810274, 41.059962157665403, 94.831922807959927, 42.418218601647503, 94.959544218800147, 43.894980641413269, 95.050702369409919, 45.499364092023001, 95.096281444710257, 47.231368953476668, 95.096281444710257, 47.231368953476668, 97.767215257370481],
     ],

 77: [ [16.283176823817449, 82.489973520279818, 16.3105242689983, 80.821779364250688, 16.3105242689983, 16.947263236850631, 16.30140845393802, 16.017450100700444, 16.255829378636601, 14.239866163950865, 16.17378704309408, 12.635482713340025, 16.037049817189821, 11.186068118749972, 15.863849331044459, 9.9098540103095729, 15.645069769597679, 8.7886087579008745, 15.380711132849481, 7.8405639916290966, 15.07077342079989, 7.0474880813908385, 14.72437244850914, 6.4184968422196107, 14.669677558147439, 6.3546861367995007, 13.96775979850568, 5.4886837060803373, 13.14733644308026, 4.7411868711296847, 12.22663912199172, 4.1121956319693709, 11.18743620511952, 3.5925941735404194, 10.03884350752392, 3.1914983108908928, 8.7808610292049423, 2.8997922289599956, 7.4134887701625578, 2.7265917428103421, 5.9276109153364871, 2.6718968524492084, 2.4727170074894209, 2.6718968524492084, 2.4727170074894209, 0.010078854849780328, 36.492938812463848, 0.010078854849780328, 36.492938812463848, 2.6718968524492084, 33.02892908955647, 2.6718968524492084, 32.381706220276421, 2.6810126675100037, 30.932291625691509, 2.7812866331696569, 29.592266811829969, 3.0000661946196487, 28.3707475937521, 3.3191197217292938, 27.258618156397631, 3.7475630295593874, 26.25587849976657, 4.2853961181208433, 25.371644438919159, 4.941734802459905, 24.59680015879513, 5.6983474524604389, 24.51475782325258, 5.7986214181200921, 24.122777775660438, 6.3911493970408628, 23.776376803369718, 7.1477620470504917, 23.484670721440668, 8.0684593681307888, 23.22942789975275, 9.1441255452500627, 23.01976415336625, 10.3838763934491, 22.855679482281179, 11.787711912729719, 22.746289701557771, 13.34651628804022, 22.67336318107553, 15.069405334430485, 22.655131550954959, 16.947263236850631, 22.655131550954959, 82.262078143779945, 16.283176823817449, 82.489973520279818],
       [114.3784626875178, 83.529176437159549, 100.49507635070751, 82.262078143779945, 100.49507635070751, 16.947263236850631, 100.48596053564719, 16.017450100700444, 100.4403814603458, 14.239866163950865, 100.35833912480329, 12.635482713340025, 100.221601898899, 11.186068118749972, 100.04840141275371, 9.9098540103095729, 99.829621851306925, 8.7886087579008745, 99.565263214558726, 7.8405639916290966, 99.255325502509123, 7.0474880813908385, 98.908924530218385, 6.4184968422196107, 98.8451138247964, 6.3364545066797291, 98.152311880214938, 5.479567891019542, 97.350120154910087, 4.7320710560707084, 96.429422833821533, 4.1030798169103946, 95.399335732009604, 3.5925941735404194, 94.250743034414, 3.1914983108908928, 92.983644741034738, 2.8997922289599956, 91.60715666693207, 2.7265917428103421, 90.112162997045729, 2.6718968524492084, 86.657269089198635, 2.6718968524492084, 86.657269089198635, 0.010078854849780328, 128.17069087372531, 0.010078854849780328, 128.17069087372531, 2.6718968524492084, 124.7796076713002, 2.6718968524492084, 124.1323848020202, 2.6810126675100037, 122.6829702074352, 2.7812866331696569, 121.3429453935737, 3.0000661946196487, 120.1214261754958, 3.3191197217292938, 119.0092967381414, 3.7475630295593874, 118.00655708151029, 4.2853961181208433, 117.1223230206629, 4.941734802459905, 116.3474787405389, 5.6983474524604389, 116.256320589936, 5.8077372331899824, 115.8461089122233, 6.4093810271606344, 115.49059212487229, 7.1659936771702633, 115.1806544128227, 8.0866909982596553, 114.9254115911348, 9.1623571753698343, 114.706632029688, 10.40210802357069, 114.5425473586029, 11.796827727790514, 114.4240417628192, 13.355632103099197, 114.351115242337, 15.069405334430485, 114.33288361221641, 16.947263236850631, 114.33288361221641, 80.821779364250688, 114.33288361221641, 81.760708315459851, 114.3784626875178, 83.529176437159549],
       [128.17069087372531, 97.768079561310515, 100.49507635070751, 97.768079561310515, 65.608852115006272, 21.277275390490104, 60.421953345705496, 0.010078854849780328, 62.801181076439264, 0.010078854849780328, 100.49507635070751, 82.262078143779945, 114.3784626875178, 83.529176437159549, 114.4696208381207, 85.14267570282027, 114.5972422489646, 86.582974482349528, 114.77044273511, 87.868304405850722, 114.9892222965567, 88.980433843200444, 115.2535809333049, 89.937594424529379, 115.56351864535461, 90.721554519719575, 115.9190354327056, 91.350545758879889, 116.00107776824809, 91.469051354659314, 116.71211134295019, 92.31682215526962, 117.5325346983756, 93.055203175150382, 118.46234783452439, 93.684194414310696, 119.50155075139661, 94.194680057689766, 120.6501434489922, 94.586660105280316, 121.9172417423715, 94.869250372150418, 123.2937298164741, 95.042450858289158, 124.7796076713002, 95.097145748650291, 128.17069087372531, 95.097145748650291, 128.17069087372531, 97.768079561310515],
       [30.148331530507189, 97.768079561310515, 2.4727170074894209, 97.768079561310515, 2.4727170074894209, 95.097145748650291, 4.1135637183402594, 95.069798303469724, 5.6176732032868983, 94.987755967929843, 7.0032770924498493, 94.851018742030647, 8.2430279406482612, 94.650470810700426, 9.3642731930630134, 94.404343804069867, 10.33966540451325, 94.094406092019199, 11.18743620511952, 93.729773489609215, 11.33328924608403, 93.656846969130129, 12.50922938886049, 92.900234319129595, 13.49373741537101, 92.079810963699856, 14.277697510555299, 91.177345272730236, 14.870225489473651, 90.192837246220734, 15.06165760573961, 89.782625568510412, 15.38982694790977, 88.889275692599767, 15.67241721477853, 87.868304405850722, 15.9003125912856, 86.710595893189748, 16.08262889249124, 85.434381784749348, 16.21025030333519, 84.021430450409753, 16.283176823817449, 82.489973520279818, 22.655131550954959, 82.262078143779945, 60.421953345705496, 0.010078854849780328, 65.608852115006272, 21.277275390490104, 30.148331530507189, 97.768079561310515],
     ],

 78: [ [15.3715953177892, 84.933876260369289, 15.3715953177892, 16.948127540779751, 15.36247950272892, 16.018314404640478, 15.32601624248778, 14.240730467879985, 15.23485809188497, 12.636347017269145, 15.107236681041, 11.186932422679092, 14.924920379835349, 9.910718314240512, 14.706140818388571, 8.7894730618299945, 14.441782181640381, 7.8414282955600356, 14.14096028465107, 7.0483523853199586, 13.78544349730004, 6.4193611461596447, 13.70340116175751, 6.300855550369306, 12.992367587055471, 5.4530847497699142, 12.17194423163005, 4.7147037298800569, 11.24213109548122, 4.0948283057805384, 10.202928178609, 3.5843426624105632, 9.0452196659531126, 3.1832467997592175, 7.7872371876341333, 2.9006565328891156, 6.410749113531466, 2.7274560467394622, 4.924871258705422, 2.6727611563801474, 1.533788056280315, 2.6727611563801474, 1.533788056280315, 0.010943158780719386, 35.554009861254741, 0.010943158780719386, 35.554009861254741, 2.6727611563801474, 32.090000138347392, 2.6727611563801474, 31.470124714248161, 2.6818769714391237, 30.029825934723529, 2.7821509371005959, 28.698916935922281, 2.9918146834897925, 27.477397717844411, 3.3199840256602329, 26.36526828048995, 3.7484273334903264, 25.353412808798598, 4.2862604220499634, 24.450947117830619, 4.9425991063908441, 23.65787120758603, 5.699211756400473, 23.584944687103789, 5.7994857220601261, 23.192964639511612, 6.3920137009808968, 22.846563667220892, 7.1486263509796117, 22.545741770231562, 8.0693236720708228, 22.29049894854364, 9.1449898491791828, 22.08083520215715, 10.384740697380039, 21.925866346132349, 11.788576216660658, 21.807360750348689, 13.34738059196934, 21.734434229866419, 15.070269638359605, 21.716202599745859, 16.948127540779751, 21.716202599745859, 77.148970198890311, 15.3715953177892, 84.933876260369289],
       [22.655131550954959, 97.768943865250549, -3.871890274467233, 97.768943865250549, -3.871890274467233, 95.098010052590325, -3.8627744594069489, 95.098010052590325, -2.249275193736934, 95.070662607400664, -0.80897641421231015, 94.997736086919758, 0.45812187916698133, 94.870114676079538, 1.5520196864008819, 94.687798374870908, 2.4727170074894209, 94.450787183299326, 3.356951068336826, 94.159081101370248, 4.7334391424394928, 93.648595458000273, 5.9823058056981893, 93.128993999569502, 7.1035510581129406, 92.600276726070661, 8.0971748996837505, 92.053327822450228, 8.954061515350304, 91.49726310377082, 9.0634512960736782, 91.415220768229119, 9.7289057954743043, 90.877387679680396, 10.4672868153572, 90.22104899533042, 11.27859435572233, 89.427973085090343, 12.1810600466903, 88.498159948940156, 13.165568073200831, 87.440725401949749, 14.232118435253881, 86.255669444110026, 15.3715953177892, 84.933876260369289, 21.716202599745859, 77.148970198890311, 86.146783445822834, -1.5752086617103487, 82.400183456046705, 24.450443335390446, 22.655131550954959, 97.768943865250549],
       [102.5825979995122, 97.768943865250549, 68.562376194537819, 97.768943865250549, 68.562376194537819, 95.098010052590325, 71.953459396962913, 95.098010052590325, 72.600682266242984, 95.08889423752953, 74.050096860827907, 94.988620271860782, 75.381005859629155, 94.77895652548068, 76.611640892767298, 94.459902998360121, 77.723770330121766, 94.022343875469232, 78.717394171692561, 93.484510786909595, 79.610744047600249, 92.828172102579629, 80.385588327724264, 92.07155945257, 80.476746478327087, 91.962169671849551, 80.877842340979527, 91.360525877869804, 81.233359128330534, 90.60391322786927, 81.543296840380165, 89.683215906779878, 81.807655477128336, 88.607549729660604, 82.017319223514846, 87.367798881470662, 82.190519709660194, 85.973079177239924, 82.309025305443896, 84.414274801940337, 82.372836010865853, 82.700501570599954, 82.400183456046705, 80.822643668179808, 82.400183456046705, 24.450443335390446, 86.146783445822834, -1.5752086617103487, 88.744790738003346, -1.5752086617103487, 88.744790738003346, 80.822643668179808, 88.744790738003346, 81.76157261939079, 88.790369813304764, 83.530040741090488, 88.881527963907587, 85.143540006760304, 89.009149374751544, 86.583838786280467, 89.191465675957204, 87.869168709779842, 89.410245237403984, 88.981298147129564, 89.674603874152169, 89.938458728469413, 89.975425771141516, 90.722418823650514, 90.330942558492509, 91.351410062810828, 90.376521633793928, 91.424336583289914, 91.087555208495957, 92.281223198959196, 91.898862748861106, 93.028720033900754, 92.828675885009929, 93.666827088120044, 93.867878801882128, 94.177312731499114, 95.016471499477746, 94.57840859415046, 96.274453977796725, 94.870114676079538, 97.641826236839108, 95.043315162220097, 99.118588276604882, 95.098010052590325, 102.5825979995122, 95.098010052590325, 102.5825979995122, 97.768943865250549],
     ],

 79: [ [32.32701132991474, 95.107990171580241, 31.23311352268081, 94.542809637840037, 30.15744734556748, 93.950281658919266, 29.10001279857471, 93.330406234819748, 28.051694066642231, 92.674067550480686, 27.01249114977, 91.990381420959238, 25.991519863018372, 91.279347846260862, 24.979664391326988, 90.531851011310209, 23.976924734695931, 89.757006731189904, 22.992416708185399, 88.945699190830055, 22.026140311795469, 88.107044205280545, 21.068979730465799, 87.241041774550467, 21.02340065516438, 87.204578514309105, 20.102703334075841, 86.329460268529147, 19.218469273228429, 85.445226207679298, 18.352466842501599, 84.542760516709677, 17.522927672015889, 83.622063195620285, 16.711620131650729, 82.692250059470098, 15.936775851526731, 81.744205293200139, 15.180163201523269, 80.787044711869385, 14.460013811760939, 79.811652500420678, 13.75809605211918, 78.81802865885038, 13.092641552718559, 77.815289002219288, 12.445418683438501, 76.794317715470243, 11.83465907439958, 75.764230613660402, 11.24213109548122, 74.7067960666609, 10.67695056174369, 73.649361519670492, 10.148233288247321, 72.564579527499518, 9.6377476448714958, 71.470681720260473, 9.1637252617368006, 70.367668097969727, 8.7079345087226727, 69.237307030489319, 8.2886070159496796, 68.097830147960849, 7.8875111532972531, 66.94923745036067, 7.5228785508859337, 65.782413122649814, 7.1764775785952111, 64.597357164810091, 6.866539866545593, 63.403185391920488, 6.5748337846165441, 62.190781988889285, 6.3195909629286566, 60.960146955760138, 6.082579771361309, 59.720396107559282, 5.882031840035097, 58.462413629240473, 5.6997155388294232, 57.186199520800074, 5.5538624978649116, 55.900869597300698, 5.4262410870209692, 54.597308043679732, 5.3350829364181322, 53.284630674999789, 5.2621564159358618, 51.953721676200075, 5.2256931556947563, 50.60458104728059, 5.2074615255741881, 49.246324603300309, 5.2165773406344718, 48.589985918959428, 5.2348089707550107, 47.204382029789485, 5.2895038611167129, 45.837009770750228, 5.3624303815989833, 44.478753326769947, 5.4718201623223592, 43.138728512909438, 5.5994415731663301, 41.816935329159605, 5.7544104291911253, 40.504257960490577, 5.9367267303967699, 39.209812221930406, 6.1463904767832673, 37.933598113479093, 6.3834016683506141, 36.675615635169379, 6.6386444900385291, 35.435864786970342, 6.9303505719675789, 34.205229753830281, 7.240288284017196, 32.992826350809992, 7.5775734412476359, 31.798654577909474, 7.9422060436589268, 30.622714435139642, 8.3341860912510981, 29.455890107419691, 8.7535135840240912, 28.307297409830426, 9.1910727069176517, 27.176936342350018, 9.6650950900523451, 26.055691089939501, 10.15734910330761, 24.96179328270955, 10.67695056174369, 23.877011290529481, 11.22389946536066, 22.810460928480097, 11.79819581415844, 21.753026381480595, 12.39983960813708, 20.722939279670754, 13.0288308472966, 19.70196799291989, 13.676053716576661, 18.699228336290616, 14.359739846097851, 17.705604494720319, 15.06165760573961, 16.739328098330589, 15.79092281056219, 15.782167516999834, 16.547535460565651, 14.843238565790671, 17.331495555749939, 13.92254124469946, 18.142803096115099, 13.010959738670863, 18.972342266600801, 12.117609862769314, 19.30962742383127, 11.780324705530802, 20.221208929859529, 10.859627384450505, 21.15102206600832, 9.975393323600656, 22.08995101721743, 9.118506707929555, 23.047111598547101, 8.2889675374499348, 24.013387994937059, 7.4958916272007627, 24.997896021447559, 6.7392789772002288, 26.000635678078648, 6.0008979573194665, 27.01249114977, 5.2989801976691524, 28.04257825158194, 4.6335256982692954, 29.081781168454139, 3.9954186440500052, 30.139215715446909, 3.3937748500793532, 31.205766077499991, 2.8103626862193778, 52.7099738047065, 2.8924050217592594, 52.427383537837727, 2.8924050217592594, 51.105590354096762, 2.9288682820006215, 49.811144615536648, 3.0200264325994794, 48.544046322157357, 3.165879473570385, 47.295179658898661, 3.3573115898307151, 46.082776255881072, 3.6125544115202501, 44.897720298044327, 3.9133763085101236, 43.740011785388468, 4.2688930958593119, 42.600534902853148, 4.6791047735696338, 41.497521280558963, 5.1440113416501845, 40.421855103445608, 5.6636128000791359, 39.373536371513133, 6.2287933338193398, 38.34344926970121, 6.8486687579206773, 37.349825428130401, 7.5232390723795106, 36.383549031740444, 8.2525042771994777, 35.444620080531372, 9.0364643723896734, 34.523922759442833, 9.8751193579391838, 33.639688698595421, 10.759353418779938, 32.782802082928868, 11.698282369989101, 31.95326291244314, 12.691906211559399, 31.333387488343931, 13.494097936869366, 30.704396249184441, 14.360100367590348, 30.093636640145519, 15.244334428440197, 29.510224476287419, 16.165031749529589, 28.945043942549919, 17.094844885679777, 28.398095038932951, 18.061121282069507, 27.86937776543656, 19.036513493520033, 27.368007937121039, 20.048368965210102, 26.88486973892606, 21.078456067019943, 26.429078985911929, 22.126774798949555, 25.991519863018372, 23.202440976070648, 25.572192370245379, 24.296338783300598, 25.180212322653212, 25.417584035720211, 24.80646390518163, 26.566176733309476, 24.450947117830619, 27.733001061029427, 24.122777775660438, 28.918057018860054, 23.812840063610849, 30.130460421880343, 23.5211339816818, 31.37021127007938, 23.256775344933601, 32.628193748400008, 23.01064833830597, 33.913523671899384, 22.782752961798909, 35.21708522552035, 22.582205030472689, 36.547994224320064, 22.399888729267051, 37.89713485323955, 22.235804058181969, 39.273622927350516, 22.09906683227771, 40.66834263157034, 21.980561236494061, 42.090409780970731, 21.889403085891221, 43.530708560499988, 21.807360750348689, 44.998354785200718, 21.75266585998699, 46.484232640030314, 21.725318414806139, 47.997457940040476, 21.716202599745859, 49.538030685229387, 21.725318414806139, 50.832476423789558, 21.75266585998699, 52.363933353910397, 21.807360750348689, 53.868042838859765, 21.88028727083093, 55.353920693689361, 21.971445421433771, 56.812451103329295, 22.08995101721743, 58.243634067790481, 22.235804058181969, 59.647469587080195, 22.39077291420676, 61.023957661180248, 22.582205030472689, 62.382214105160529, 22.782752961798909, 63.713123103960243, 23.01976415336625, 65.01668465757939, 23.265891159993888, 66.292898766019789, 23.539365611802371, 67.550881244340417, 23.840187508791669, 68.781516277480478, 24.159241035901569, 69.984803865439972, 24.496526193132041, 71.160744008220718, 24.861158795543329, 72.318452520870778, 25.24402302807519, 73.439697773290391, 25.64511889072762, 74.542711395579317, 26.08267801362118, 75.627493387750292, 26.529352951575021, 76.675812119690818, 27.00337533470972, 77.705899221500658, 27.495629347964979, 78.708638878129932, 28.015230806401089, 79.684031089580458, 28.553063894957749, 80.632075855850417, 29.118244428695281, 81.552773176939809, 29.701656592553348, 82.455238867909429, 30.312416201592299, 83.330357113689388, 30.941407440751789, 84.187243729360489, 31.588630310031849, 85.007667084779314, 31.898568022081442, 85.381415502250093, 32.737223007627449, 86.338576083589942, 33.61234125341457, 87.241041774550467, 34.505691129322258, 88.097928390219749, 35.435504265471081, 88.909235930590512, 36.383549031740444, 89.656732765530251, 37.368057058250969, 90.358650525169651, 38.370796714882061, 91.005873394449736, 39.40999963175426, 91.598401373370507, 40.476549993807311, 92.14535027698912, 41.570447801041212, 92.637604290239324, 42.68257723839568, 93.084279228189189, 43.831169935991277, 93.467143460729858, 45.007110078767731, 93.804428617959275, 46.210397666725036, 94.096134699890172, 47.441032699863172, 94.324030076390045, 48.699015178182179, 94.506346377600494, 49.98434510168201, 94.633967788440714, 51.297022470362691, 94.71601012398969, 52.637047284224217, 94.743357569170257, 32.32701132991474, 95.107990171580241],
       [54.004419543266607, 100.00318285895082, 52.801131955309302, 99.994067043890027, 51.497570401688897, 99.948487968589689, 50.20312466312879, 99.875561448110602, 48.91779473962896, 99.76617166737924, 47.650696446249668, 99.638550256540839, 46.392713967930689, 99.474465585450162, 45.152963119732249, 99.273917654130855, 43.922328086594121, 99.046022277620068, 42.700808868516248, 98.790779455930533, 41.497521280558963, 98.508189189060431, 40.303349507661949, 98.189135661950786, 39.127409364885501, 97.833618874599779, 37.960585037169317, 97.459870457130819, 36.811992339573749, 97.049658779420497, 35.663399641978152, 96.612099656520513, 34.542154389563393, 96.138077273390081, 33.430024952208917, 95.636707445069987, 32.32701132991474, 95.107990171580241, 52.637047284224217, 94.743357569170257, 52.71908961976677, 94.743357569170257, 54.095577693869423, 94.71601012398969, 55.444718322791232, 94.633967788440714, 56.766511506532197, 94.51546219265947, 58.051841430032063, 94.342261706509817, 59.309823908351042, 94.114366330009943, 60.531343126428908, 93.840891878200637, 61.725514899325901, 93.521838351089173, 62.892339227042072, 93.157205748679189, 64.031816109577392, 92.737878255900796, 65.134829731871577, 92.27297168782934, 66.210495908984925, 91.76248604445027, 67.258814640917407, 91.197305510719161, 68.279785927669053, 90.586545901680438, 69.264293954179564, 89.921091402280581, 70.221454535509238, 89.210057827580385, 71.142151856597764, 88.453445177570757, 72.035501732505466, 87.651253452269884, 72.901504163232303, 86.794366836600602, 73.740159148778304, 85.891901145629163, 74.542350874083155, 84.934740564300228, 74.733782990349098, 84.688613557669669, 75.353658414448304, 83.886421832370615, 75.946186393366673, 83.047766846819286, 76.520482742164475, 82.190880231159099, 77.076547460841709, 81.297530355250274, 77.605264734338093, 80.385948849219858, 78.124866192774192, 79.447019898010694, 78.617120206029455, 78.480743501619145, 79.09114258916415, 77.496235475109643, 79.546933342178278, 76.475264188360597, 79.975376650011555, 75.436061271489962, 80.385588327724264, 74.360395094370688, 80.786684190376704, 73.266497287140737, 81.151316792787995, 72.14525203473022, 81.506833580139016, 71.005775152190836, 81.844118737369456, 69.82983500941009, 82.154056449419073, 68.626547421450596, 82.445762531348123, 67.405028203380425, 82.719236983156577, 66.156161540120593, 82.965363989784237, 64.879947431680193, 83.202375181351556, 63.576385878059227, 83.412038927738067, 62.245476879259513, 83.603471044003996, 60.887220435279232, 83.776671530149386, 59.510732361170085, 83.922524571113897, 58.097781026830489, 84.059261797018124, 56.666598062360208, 84.168651577741514, 55.208067652720274, 84.259809728344365, 53.722189797890678, 84.332736248826606, 52.20896449788961, 84.378315324128025, 50.6683917527007, 84.405662769308847, 49.109587377390199, 84.414778584369145, 47.514319741840154, 84.414778584369145, 46.867096872560069, 84.396546954248578, 45.262713421949229, 84.350967878947174, 43.694793231579752, 84.287157173525188, 42.154220486399936, 84.205114837982634, 40.640995186389773, 84.095725057259244, 39.164233146619154, 83.968103646415287, 37.714818552040015, 83.813134790390507, 36.301867217689505, 83.639934304245116, 34.916263328530476, 83.439386372918904, 33.558006884550196, 83.220606811472123, 32.227097885750482, 82.974479804844506, 30.932652147190311, 82.719236983156577, 29.674669668869683, 82.427530901227556, 28.444034635729622, 82.117593189177953, 27.240747047770128, 81.789423847007782, 26.064806905000296, 81.443022874717045, 24.925330022459093, 81.060158642185186, 23.813200585109371, 80.668178594593044, 22.737534407990097, 80.248851101820037, 21.689215676060485, 79.811291978926462, 20.668244389309621, 79.346385410852051, 19.683736362800119, 78.863247212657086, 18.726575781469364, 78.352761569281256, 17.796762645319177, 77.824044295784873, 16.903412769410352, 77.267979577107639, 16.037410338689369, 76.693683228309837, 15.207871168200654, 76.101155249391454, 14.405679442899782, 75.481279825292262, 13.630835162770381, 74.624393209625708, 12.646327136260879, 73.73104333371802, 11.689166554930125, 72.819461827689764, 10.786700863960505, 71.880532876480657, 9.9389300633592939, 70.932488110211281, 9.1367383380493266, 69.947980083700756, 8.3801256880506116, 68.954356242129961, 7.6690921133504162, 67.933384955378315, 7.0127534290095355, 66.894182038506116, 6.4019938199708122, 65.827631676453052, 5.8368132862306084, 64.742849684279435, 5.3263276428606332, 63.63983606198525, 4.8614210747800826, 62.509474994510207, 4.4512093970697606, 61.36088229691461, 4.0865767946506821, 60.184942154138163, 3.767523267550132, 58.990770381241163, 3.5031646307998017, 57.778366978223573, 3.2843850693498098, 56.547731945085417, 3.1111845832092513, 55.289749466766438, 2.9926789874207316, 54.004419543266607, 2.9197524669398263, 52.7099738047065, 2.8924050217592594, 31.205766077499991, 2.8103626862193778, 32.290548069673612, 2.2725295976597408, 33.384445876907513, 1.7529281392198754, 34.496575314261968, 1.2697899410304672, 35.617820566676727, 0.8231150030696881, 36.757297449212047, 0.40378751030038984, 37.915005961867926, 0.011807462709839456, 39.081830289584083, -0.34370932463934878, 40.25777043236053, -0.67187866680978914, 41.461058020317829, -0.96358474874068634, 42.664345608275113, -1.2279433854891977, 43.894980641413269, -1.4649545770607801, 45.125615674551391, -1.6655025083800865, 46.383598152870398, -1.83870299452974, 47.650696446249668, -1.9754402204307553, 48.926910554689222, -2.0848300011602987, 50.22135629324935, -2.1668723367001803, 51.524917846869762, -2.2124514120005188, 52.84671103061072, -2.2306830421202903, 53.612439495674458, -2.2215672270594951, 54.906885234234572, -2.1851039668199519, 56.183099342674119, -2.1212932613998419, 57.450197636053389, -2.0210192957292747, 58.708180114372396, -1.8933978848908737, 59.947930962570808, -1.7384290288591728, 61.178565995708958, -1.5469969126006617, 62.390969398726519, -1.3191015360898746, 63.594256986683831, -1.0638587144003395, 64.788428759580839, -0.78126844753023761, 65.964368902357293, -0.46221492042059253, 67.13119323007345, -0.1158139481303806, 68.279785927669053, 0.2670502843993745, 69.419262810204373, 0.67726196210969647, 70.549623877679409, 1.1148210850005853, 71.661753315033877, 1.5888434681401122, 72.764766937328062, 2.0993291115191823, 73.858664744561963, 2.6371622000697243, 74.934330921675311, 3.2023427338099282, 76.000881283728361, 3.8039865277896752, 77.049200015660858, 4.432977766949989, 78.088402932533072, 5.098432266349846, 79.109374219284717, 5.7912342109302699, 80.130345506036335, 6.5204994157502369, 81.123969347607144, 7.2771120657507709, 82.117593189177953, 8.0610721609391476, 83.092985400628166, 8.8814955163707054, 84.059261797018124, 9.7383821320308925, 85.007306563287514, 10.622616192880741, 85.946235514496635, 11.534197698909338, 86.866932835585146, 12.482242465170202, 87.240681253056735, 12.874222512769848, 88.088452053663005, 13.79491983385924, 88.899759594028154, 14.733848785070222, 89.692835504272736, 15.681893551340181, 90.449448154276169, 16.648169947729912, 91.187829174159077, 17.623562159169524, 91.889746933800836, 18.617186000750735, 92.573433063322014, 19.619925657380008, 93.229771747662355, 20.640896944130873, 93.858762986821858, 21.68009986099969, 94.460406780800497, 22.728418592929302, 95.034703129598299, 23.794968954989599, 95.581652033215263, 24.870635132099778, 96.101253491651363, 25.964532939340643, 96.593507504906626, 27.06754656162957, 97.067529888041307, 28.188791814040087, 97.505089010934867, 29.328268696579471, 97.915300688647591, 30.476861394170555, 98.307280736239733, 31.643685721890506, 98.662797523590754, 32.819625864669433, 99.000082680821208, 34.013797637560856, 99.310020392870811, 35.226201040579326, 99.592610659739577, 36.447720258660411, 99.838737666367209, 37.687471106859448, 100.0666330428742, 38.936337770110185, 100.2671809742005, 40.203436063500703, 100.4403814603458, 41.479650171939284, 100.5862345013103, 42.774095910499454, 100.7138559121543, 44.086773279170302, 100.8050140627571, 45.408566462920135, 100.8688247681791, 46.748591276780644, 100.9144038434805, 48.09773190570013, 100.9235196585408, 49.465104164739387, 100.9144038434805, 50.476959636429456, 100.87794058323939, 51.816984450289965, 100.82324569287771, 53.147893449100593, 100.7320875422749, 54.469686632839512, 100.61358194649119, 55.764132371399683, 100.4677289055267, 57.058578109959853, 100.29452841938129, 58.334792218400253, 100.0939804880551, 59.59277469672088, 99.866085111548045, 60.841641359969799, 99.610842289860145, 62.07227639310986, 99.328252022991379, 63.284679796130149, 99.018314310941776, 64.487967384089643, 98.681029153711322, 65.682139156979247, 98.316396551300016, 66.858079299759993, 97.924416503707874, 68.015787812419148, 97.505089010934867, 69.164380510010233, 97.058414072981023, 70.29474157749064, 96.575275874786058, 71.415986829899339, 96.073906046470512, 72.51900045219918, 95.545188772974129, 73.603782444370154, 94.980008239236611, 74.679448621480333, 94.396596075378525, 75.74599898354063, 93.785836466339603, 76.794317715470243, 93.138613597059532, 77.824404817280083, 92.473159097658908, 78.845376104029128, 91.771241338017177, 79.848115760660221, 91.051091948254836, 80.841739602239613, 90.294479298251375, 81.817131813679225, 89.519635018127374, 82.78340821007987, 88.708327477762225, 83.731452976340734, 87.878788307276508, 84.661266112489102, 87.012785876549657, 85.581963433580313, 86.356447192209316, 86.256533748039146, 85.399286610879656, 87.186346884189334, 84.433010214489727, 88.088812575160773, 83.457618003039485, 88.95481500589085, 82.463994161468705, 89.784354176370471, 81.461254504837612, 90.586545901680438, 80.449399033146264, 91.352274366739948, 79.428427746394604, 92.09065538662071, 78.389224829522391, 92.792573146260111, 77.340906097589894, 93.467143460729858, 76.283471550597127, 94.105250514949148, 75.216921188544063, 94.7068943089198, 74.132139196370446, 95.281190657720799, 73.038241389136545, 95.819023746280436, 71.93522776684236, 96.32039357460053, 70.823098329487891, 96.794415957729143, 69.692737262012855, 97.241090895680827, 68.553260379477535, 97.651302573400244, 67.404667681881932, 98.025050990869204, 66.246959169226045, 98.371451963159416, 65.071019026449605, 98.681389675210085, 63.885963068612881, 98.954864127019391, 62.691791295715859, 99.200991133640855, 61.488503707758547, 99.410654880030052, 60.266984489680709, 99.5929711812405, 59.036349456542553, 99.738824222200492, 57.796598608344141, 99.857329817990831, 56.547731945085417, 99.939372153530712, 55.280633651706147, 99.984951228829232, 54.004419543266607, 100.00318285895082],
     ],

 80: [ [60.257868674613093, 45.901684780119467, 30.294184571465369, 45.792294999389924, 31.579514494965171, 45.518820547580617, 32.883076048585536, 45.263577725900177, 34.177521787145601, 45.017450719269618, 35.435504265464552, 44.798671157819626, 36.675255113662928, 44.607239041559296, 37.896774331740751, 44.434038555409643, 39.081830289577461, 44.26995388432988, 40.412739288378638, 44.124100843360793, 41.743648287179859, 43.996479432520573, 43.038094025739923, 43.896205466850006, 44.296076504058867, 43.823278946369101, 45.526711537196967, 43.786815686129557, 46.720883310093967, 43.768584056009786, 47.158442432987492, 43.768584056009786, 48.626088657692947, 43.805047316249329, 50.057271622157259, 43.877973836730234, 51.451991326380437, 43.987363617459778, 52.819363585422757, 44.142332473480565, 54.1411567691637, 44.33376458974999, 55.435602507723793, 44.570775781310658, 56.693584986042737, 44.844250233119965, 57.915104204120553, 45.154187945170634, 59.109275977017518, 45.509704732519822, 60.257868674613093, 45.901684780119467],
       [14.50559288705654, 91.927435019479162, 14.65144592802104, 91.745118718279628, 15.0343101605529, 91.134359109240904, 15.36247950272306, 90.359514829109685, 15.65418558465208, 89.420585877900521, 15.900312591279709, 88.326688070670571, 16.100860522605931, 87.077821407410738, 16.255829378630722, 85.664870073069324, 16.365219159354101, 84.08783406764087, 16.42902986477608, 82.355829206180715, 16.456377309956931, 80.468855488710687, 16.456377309956931, 17.314488751069803, 16.447261494896651, 16.329980724560301, 16.410798234655509, 14.534165157680036, 16.328755899112991, 12.911550076960339, 16.2102503033293, 11.453019667309491, 16.046165632244222, 10.167689743810115, 15.845617700918011, 9.0464444913995976, 15.60860650935069, 8.0983997251205437, 15.326016242481931, 7.3235554450002383, 15.006962715372049, 6.712795835959696, 14.833762229226689, 6.4575530142792559, 14.113612839464389, 5.5642031383704307, 13.284073668978721, 4.7984746733000065, 12.354260532829921, 4.1512518040199211, 11.31505761595775, 3.6225345305301744, 10.175580733422461, 3.2032070377499622, 8.9358298852240807, 2.911500955820884, 7.5958050713626051, 2.7383004696803255, 6.1463904767777251, 2.6744897642602155, 2.4727170074839928, 2.6744897642602155, 2.4727170074839928, 0.012671766660787398, 44.341655579360292, 0.012671766660787398, 44.341655579360292, 2.6744897642602155, 40.595055589584291, 2.6744897642602155, 40.048106685967348, 2.6836055793191917, 38.635155351623609, 2.7838795449806639, 37.322477982942992, 3.0026591064306558, 36.110074579925417, 3.3399442636600725, 35.007060957631303, 3.7866192016099376, 34.004321301000232, 4.3609155504091177, 33.101855610032288, 5.0446016799305653, 32.308779699787749, 5.8467934052405326, 32.144695028702671, 6.047341336559839, 31.752714981110529, 6.6581009456003812, 31.415429823880089, 7.4329452257206867, 31.114607926890759, 8.3718741769298504, 30.859365105202869, 9.4657719841707149, 30.65881717387666, 10.714638647430547, 30.494732502791582, 12.127589981770143, 30.385342722068199, 13.69551017213962, 30.312416201585929, 15.42751503359068, 30.294184571465369, 17.314488751069803, 30.294184571465369, 45.792294999389924, 60.257868674613093, 45.901684780119467, 61.379113927027788, 46.339243903010356, 62.463895919201377, 46.813266286149883, 63.512214651133831, 47.332867744580653, 64.524070122825165, 47.888932463260062, 42.10828088959115, 48.454112996989352, 41.059962157658703, 48.472344627109123, 39.838442939580858, 48.545271147599124, 38.507533940779673, 48.654660928319572, 37.06723516125507, 48.818745599410249, 36.675255113662928, 48.864324674710588, 35.517546601007098, 49.019293530729556, 34.305143197989572, 49.201609831940004, 33.028929089550047, 49.411273578329201, 31.68890427568854, 49.639168954830893, 30.294184571465369, 49.894411776520428, 30.294184571465369, 90.560062760439905, 31.01433396122767, 90.724147431519668, 32.481980185933111, 91.043200958629313, 33.876699890156289, 91.316675410440439, 35.198493073897232, 91.535454971890431, 36.447359737155871, 91.70865545802917, 37.614184064872013, 91.827161053819509, 38.708081872105879, 91.909203389359391, 39.729053158857482, 91.927435019479162, 14.50559288705654, 91.927435019479162],
       [38.288754379332893, 97.770672473119703, 2.4727170074839928, 97.770672473119703, 2.4727170074839928, 95.099738660459479, 6.1463904767777251, 95.099738660459479, 6.757150085816618, 95.090622845400503, 8.1609856051001088, 94.990348879729936, 9.4736629737807334, 94.762453503230063, 10.67695056173798, 94.425168346000646, 11.77996418403214, 93.978493408039867, 12.791819655723479, 93.413312874310577, 13.6942853466914, 92.72962674478913, 14.50559288705654, 91.927435019479162, 39.729053158857482, 91.927435019479162, 40.914109116694164, 91.900087574300414, 42.2359023004351, 91.808929423699738, 43.521232223934902, 91.644844752610879, 44.770098887193569, 91.416949376109187, 45.991618105271378, 91.125243294180109, 47.176674063108059, 90.760610691770125, 48.334382575763932, 90.332167383929118, 49.455627828178621, 89.830797555619938, 50.54040982035221, 89.265617021879734, 51.415528066139302, 88.727783933320097, 52.418267722770359, 88.016750358619902, 53.3663124890397, 87.232790263429706, 54.25966236494736, 86.385019462830314, 55.098317350493353, 85.473437956799899, 55.882277445677602, 84.479814115229601, 56.611542650500191, 83.431495383299989, 57.27699714990078, 82.310250130880377, 57.896872573999978, 81.116078357990773, 58.206810286049567, 80.43239222846023, 58.689948484244532, 79.265567900749375, 59.109275977017518, 78.089627757970447, 59.473908579428809, 76.886340170020048, 59.78384629147839, 75.664820951940783, 60.039089113166312, 74.434185918800722, 60.239637044492518, 73.176203440480094, 60.376374270396752, 71.899989332039695, 60.458416605939277, 70.605543593479524, 60.485764051120121, 69.292866224799582, 60.485764051120121, 69.219939704320495, 60.458416605939277, 67.834335815159648, 60.358142640276178, 66.476079371170272, 60.194057969191107, 65.172517817549306, 59.966162592684043, 63.896303709110725, 59.683572325815312, 62.665668675979759, 59.328055538464298, 61.480612718140037, 58.908728045691312, 60.332020020539858, 58.434705662556638, 59.219890583190136, 57.887756758939702, 58.153340221129838, 57.286112964961063, 57.132368934380793, 56.611542650500191, 56.147860907869472, 55.882277445677602, 55.199816141599513, 55.089201535433062, 54.297350450640806, 54.369052145670757, 53.568085245809925, 53.402775749280842, 52.683851184960076, 52.400036092649799, 51.881659459659204, 51.37906480589816, 51.161510069900032, 50.321630258905429, 50.523403015680742, 49.236848266731869, 49.97645411206031, 48.124718829377422, 49.511547543990673, 46.976126131781847, 49.128683311459099, 45.80930180406574, 48.836977229530021, 44.606014216108477, 48.627313483140824, 43.375379182970391, 48.499692072300604, 42.10828088959115, 48.454112996989352, 64.524070122825165, 47.888932463260062, 65.499462334275364, 48.481460442180833, 66.447507100544712, 49.119567496400123, 67.349972791512656, 49.794137810860775, 68.225091037299734, 50.514287200619947, 69.06374602284572, 51.270899850620481, 69.355452104774756, 51.544374302429787, 70.221454535501564, 52.437724178340432, 71.032762075866685, 53.358421499429824, 71.789374725870104, 54.306466265699783, 72.500408300572118, 55.290974292209285, 73.156746984912445, 56.293713948840377, 73.758390778891069, 57.332916865709194, 74.305339682508006, 58.408583042819373, 74.806709510823524, 59.502480850060238, 75.244268633717084, 60.632841917529731, 75.636248681309212, 61.790550430190706, 75.982649653599935, 62.975606388019514, 76.265239920468687, 64.197125606100599, 76.502251112036021, 65.445992269360431, 76.684567413241666, 66.722206377800831, 76.821304639145907, 68.025767931419978, 76.894231159628163, 69.365792745280487, 76.921578604809014, 70.733165004319744, 76.921578604809014, 70.787859894689973, 76.894231159628163, 72.118768893489687, 76.793957193965056, 73.422330447110653, 76.638988337940262, 74.707660370610029, 76.429324591553765, 75.956527033869861, 76.146734324685013, 77.178046251940032, 75.809449167454574, 78.372218024840549, 75.408353304802162, 79.5390423525605, 74.952562551788048, 80.678519235090789, 74.432961093351963, 81.78153285739063, 73.849548929493892, 82.866314849559785, 73.202326060213835, 83.923749396550193, 72.500408300572118, 84.944720683299238, 71.734679835508416, 85.947460339930331, 71.269773267434019, 86.503525058609739, 70.412886651767494, 87.478917270060265, 69.519536775859834, 88.408730406210452, 68.607955269831606, 89.283848651999506, 67.650794688501975, 90.113387822479126, 66.675402477051776, 90.906463732730117, 65.663547005360442, 91.644844752610879, 64.624344088488272, 92.337646697189484, 63.557793726435243, 92.98486956646957, 62.454780104141093, 93.586513360449317, 61.324419036666107, 94.133462264069749, 60.166710524010263, 94.643947907439724, 58.972538751113291, 95.099738660459479, 58.589674518581432, 95.236475886360495, 57.632513937251787, 95.537297783350368, 56.629774280620751, 95.829003865279446, 55.59057136374858, 96.093362502029777, 54.505789371574991, 96.339489508660336, 53.384544119160267, 96.567384885160209, 52.217719791444154, 96.777048631549405, 51.005316388426621, 96.968480747820649, 49.756449725167947, 97.132565418900413, 48.471119801668152, 97.287534274930294, 47.140210802866932, 97.415155685770515, 45.772838543824598, 97.524545466489144, 44.35988720948086, 97.60658780203994, 42.901356799835703, 97.679514322520845, 41.406363129949419, 97.725093397819364, 39.865790384761709, 97.761556658060726, 38.288754379332893, 97.770672473119703],
     ],

 81: [ [31.559726130549489, 94.696122435470897, 30.38114598061183, 94.056031491969406, 29.212726004380539, 93.365139679939603, 28.064626375561961, 92.6437673467899, 26.92668692044974, 91.881754318810636, 25.809067812750261, 91.089260769709654, 24.70160887875711, 90.245966352089454, 23.614470292176708, 89.382351587049925, 22.537491879302639, 88.46793595346935, 21.480833813841301, 87.523039798779791, 20.434335922086301, 86.537502949269765, 19.408158377744041, 85.511325404919262, 19.32687698809319, 85.440204188980715, 18.371820659695441, 84.424186818339876, 17.447244852416741, 83.408169447709952, 16.563309739963511, 82.361671555949215, 15.70985514862936, 81.305013490489728, 14.88688107841428, 80.228035077620007, 14.094387529318279, 79.130736317329138, 13.33237450134135, 78.023277383339519, 12.611002168189851, 76.885337928230001, 11.930270529863799, 75.737238299399905, 11.26985923895046, 74.578978496880154, 10.650088642862549, 73.390238173240505, 10.06079856789372, 72.191337675889372, 9.5121491877503388, 70.972116831120729, 8.9838201550196857, 69.742735812649698, 8.4961318171144455, 68.493034446770253, 8.0490841740346468, 67.223012733480573, 7.6325170520739221, 65.932670672769746, 7.2464304512322713, 64.622008264650503, 6.8908243715097219, 63.301185682819778, 6.565698812906219, 61.960042753580638, 6.281213949128186, 60.598579476929444, 6.0373697801755659, 59.226956026570406, 5.8138459586356532, 57.835012228799314, 5.6309628319211811, 56.422748083619808, 5.4785602263258113, 54.990163591019154, 5.3566381418494871, 53.54741892471975, 5.2753567521986318, 52.084353910999198, 5.2245558836668229, 50.600968549870231, 5.2143957099604838, 49.107423015040695, 5.2143957099604838, 48.081245470699287, 5.2550364047858968, 46.536899067330523, 5.3159974470240741, 45.002712837669606, 5.4175991840876634, 43.509167302829155, 5.5496814422703258, 42.025781941709283, 5.712244221572063, 40.583037275400784, 5.9052875219928751, 39.150452782809225, 6.1288113435327878, 37.748348811330288, 6.3828156861917762, 36.366565187259766, 6.6774607236761758, 35.005101910610392, 6.9924261085733121, 33.674119155079097, 7.3480321882958597, 32.373616920660425, 7.7239586154311723, 31.083274859960511, 8.1405257373918687, 29.823413320369582, 8.5875733804716674, 28.59403230190037, 9.0651015446705401, 27.374811457140822, 9.5731102299885151, 26.186071133490259, 10.11159943642553, 25.027811330970508, 10.60944794803714, 24.0016337866291, 11.259699065244121, 22.741772247039989, 11.94043070357017, 21.502231054859294, 12.661803036721659, 20.293170383800316, 13.40349571728586, 19.104430060160666, 14.185829092675499, 17.946170257639096, 14.99864298918423, 16.818390976230148, 15.84193740681202, 15.710932042240529, 16.715712345558909, 14.633953629359894, 17.619967805424849, 13.577295563900407, 18.564863960116249, 12.551118019560818, 19.530080462220369, 11.545260822629643, 20.535937659149919, 10.569884146820186, 21.572275377198519, 9.614827818419144, 22.639093616366221, 8.6902520111398189, 23.736392376653001, 7.796156724980392, 23.980236545605621, 7.6031134245604335, 24.93529287400337, 6.9020614388191461, 25.930989897226549, 6.2010094530796778, 26.98764796268792, 5.5101176410498738, 28.084946722974689, 4.8293860027297342, 29.22288617808691, 4.1486543644004996, 30.421786675437279, 3.4780828997791104, 31.671488041319421, 2.8075114351595403, 32.961830102027037, 2.1471001442496345, 34.302973031266433, 1.4968490270402981, 35.694916829037609, 0.84659790982914274, 37.137661495340588, 0.1963467926307203, 38.631207030175382, -0.44374415087986563, 40.165393259835589, -1.0736749206698732, 40.886765592987082, -1.784887080109911, 41.851982095091202, -2.6993027136795718, 42.837518944608007, -3.603558173550482, 43.843376141537561, -4.5078136334195733, 44.869553685879829, -5.4019089195808192, 45.926211751341157, -6.2858440320305817, 46.993029990508859, -7.1697791444803443, 48.090328750795642, -8.033393909519873, 49.20794785849516, -8.9071688482708851, 50.35604748731371, -9.7606234396007494, 51.514307289838662, -10.614078030939709, 52.70304761348266, -11.457372448570823, 53.912108284539393, -12.300666866189204, 55.151649476715193, -13.133801110119748, 56.401350842597338, -13.956775180329714, 57.681532729598587, -14.769589076839111, 58.667069579115399, -15.399519846629119, 59.876130250172139, -16.141212527199968, 61.095351094935239, -16.862584860349671, 62.324732113404679, -17.563636846089139, 63.564273305580478, -18.254528658120762, 64.803814497756292, -18.914939949039763, 66.063676037344806, -19.555030892539435, 67.323537576933305, -20.184961662329442, 68.5935592902282, -20.784411911010466, 69.883901350935815, -21.363541812270341, 71.164083237937064, -21.922351366119983, 72.464585472351018, -22.460840572550296, 73.775247880471341, -22.989169605289135, 75.085910288591634, -23.487018116900799, 76.416893044124691, -23.964546281089497, 77.74787579965772, -24.421754097880694, 79.089018728897116, -24.868801740960407, 79.657988456453211, -25.051684867679796, 81.121053470168917, -25.49873251075951, 82.563798136471888, -25.925459806419894, 84.006542802774874, -26.321706580969476, 85.428967121665139, -26.687472834399159, 86.84123126684905, -27.032918740409514, 88.243335238326608, -27.347884125310884, 89.635279036097785, -27.632368989090537, 91.017062660162637, -27.886373331750292, 92.388686110521107, -28.120057326999813, 93.739989213466856, -28.313100627419772, 95.081132142706252, -28.485823580429496, 96.422275071945649, -28.638226186019892, 97.743097653772324, -28.749988096789821, 99.053760061892646, -28.841429660149515, 100.34410212260021, -28.902390702389312, 100.34410212260021, -26.596031271039465, 99.063920235599014, -26.474109186559872, 97.631335743002367, -26.291226059849578, 96.219071597818456, -26.067702238309721, 94.827127800047265, -25.793377548239732, 93.465664523395162, -25.478412163340181, 92.114361420449399, -25.112645909910498, 90.793538838622723, -24.696078787950682, 89.482876430502415, -24.2388709711704, 88.202694543501167, -23.741022459560554, 86.942833003912654, -23.192373079409663, 85.703291811736847, -22.592922830730458, 84.484070966973761, -21.952831887239881, 83.285170469623367, -21.261940075199163, 82.116750493392104, -20.530407568350711, 80.958490690867166, -19.748074192959393, 80.36920061589835, -19.321346897289914, 79.403984113794252, -18.589814390430547, 78.438767611690125, -17.817641188750713, 77.493871456998733, -17.004827292239497, 76.548975302307355, -16.151372700909633, 75.614239321322316, -15.247117241040542, 74.689663514043644, -14.302221086349164, 73.775247880471341, -13.316684236830042, 72.860832246898994, -12.290506692490453, 71.966736960739411, -11.213528279620732, 71.072641674579813, -10.095909171910534, 70.178546388420216, -8.9376493693907832, 69.304771449673353, -7.7387488720396505, 68.430996510926462, -6.4890475061602046, 67.567381745885939, -5.1987054454493773, 66.713927154551783, -3.8677226899199013, 65.870632736923994, -2.4960992395608628, 65.027338319296163, -1.0736749206698732, 65.464225788669637, -0.94159266248971107, 66.815528891615372, -0.50470519311056705, 68.146511647148401, -0.027177028909136425, 69.457174055268723, 0.48083165639945946, 70.747516115976325, 1.0091606891292031, 72.01753782927122, 1.5781304166903283, 73.257079021447026, 2.1877408390701021, 52.926571435022566, 2.6754291769793781, 52.083277017394757, 2.6855893506908615, 50.630372177385397, 2.7567105666294083, 49.218108032201521, 2.8887928248095704, 47.836324408136683, 3.081836125229529, 46.485021305190919, 3.3460006416007673, 45.164198723364258, 3.671126200200888, 43.88401683636301, 4.0572128010408051, 42.634315470480828, 4.5144206178301829, 41.415094625717757, 5.0224293031496927, 40.22635430207373, 5.6117193781192327, 39.078254673255181, 6.2518103216207237, 37.960635565555677, 6.9630224810607615, 36.873496978975268, 7.7351956827405957, 35.826999087220273, 8.5683299266693211, 34.810981716584379, 9.4725853865293175, 33.82544486706756, 10.437801888640024, 32.870388538669793, 11.463979432979613, 31.945812731391118, 12.551118019560818, 31.34636248271595, 13.333451394950316, 30.64531049697716, 14.298667897050109, 29.964578858651109, 15.28420474656923, 29.324487915150499, 16.300222117210069, 28.704717319062599, 17.346720008959892, 28.105267070387399, 18.413538248130862, 27.5362973428313, 19.510837008410817, 26.997808136394259, 20.638616289819765, 26.479639277369941, 21.796876092350431, 25.991950939464729, 22.98561641599008, 25.53474312267856, 24.194677087050877, 25.097855653305128, 25.434218279220659, 24.681288531344411, 26.704239992519433, 24.305362104209131, 28.00474222693083, 23.94975602448655, 29.325564808759736, 23.614470292176708, 30.676867911699446, 23.30966508098594, 32.058651535769968, 23.035340390914239, 33.470915680949474, 22.781336048255259, 34.903500173550128, 22.55781222671537, 36.376725360969431, 22.364768926294531, 37.870270895809881, 22.192045973286419, 39.384136778049651, 22.049803541397399, 40.938643355129898, 21.927881456921099, 42.513470279609464, 21.836439893563881, 44.118777725219843, 21.765318677619359, 45.754565691939206, 21.724677982793921, 47.420834179780286, 21.71451780908755, 49.107423015040695, 21.71451780908755, 49.981197953789888, 21.744998330206631, 51.708427483870764, 21.79579919873844, 53.405176492829924, 21.87708058838929, 55.071444980669185, 21.988842499159251, 56.697072773689797, 22.120924757341911, 58.302380219289262, 22.28348753664368, 59.856886796369508, 22.46637066335812, 61.391073026030426, 22.67973431119167, 62.894778734569627, 22.92357848014429, 64.357843748279265, 23.187742996509609, 65.790428240879919, 23.482388033994042, 67.182372038649191, 23.797353418891181, 68.553995489010049, 24.14279932490739, 69.884978244539525, 24.51872575204267, 71.185480478960017, 24.925132700297031, 72.455502192249696, 25.351859995964091, 73.684883210720727, 25.79890763904389, 74.883783708070041, 26.28659597694913, 76.052203684299457, 26.784444488560741, 77.190143139419888, 27.322933694997761, 78.287441899699843, 27.881743248847521, 79.364420312580478, 28.471033323816339, 80.400758030620636, 29.080643746197879, 81.396455053849422, 29.720734689698489, 82.371831729660698, 30.391306154318201, 83.306567710640593, 31.082197966350591, 84.210823170509684, 31.803570299502081, 85.084598109260696, 32.199817074050102, 85.53164575234041, 33.14471322874148, 86.547663122970334, 34.130250078258328, 87.512879625079222, 35.146267448894221, 88.406974911240468, 36.202925514355563, 89.240109155160098, 37.279903927229633, 90.012282356839933, 38.397523034929129, 90.713334342579401, 39.555782837454053, 91.363585459790556, 40.734362987391677, 91.952875534760096, 41.953583832154777, 92.48120456748984, 43.21344537174329, 92.938412384270123, 44.493627258744539, 93.344819332529369, 45.814449840571243, 93.680105064839154, 47.165752943516971, 93.964589928620626, 48.557696741288183, 94.177953576450818, 49.980121060178419, 94.330356182039395, 51.433025900187779, 94.421797745400909, 52.926571435022566, 94.452278266520807, 31.559726130549489, 94.696122435470897],
       [53.790186200063069, 100.00989328389915, 52.560805181593629, 99.989572936490731, 51.138380862703372, 99.938772067949685, 49.726116717519467, 99.857490678299655, 48.324012746041923, 99.725408420119493, 46.942229121977078, 99.562845640819432, 45.570605671618608, 99.369802340399474, 44.219302568672852, 99.125958171440288, 42.888319813139823, 98.8516334813703, 41.567497231313133, 98.546828270180413, 40.266994996899172, 98.191222190460394, 38.976652936191591, 97.805135589620477, 37.69647104919035, 97.378408293949178, 36.436609509601837, 96.9212004771598, 35.19706831742603, 96.423351965549955, 33.967687298956569, 95.884862759110547, 32.758626627899858, 95.315893031560336, 31.559726130549489, 94.696122435470897, 52.926571435022566, 94.452278266520807, 53.769865852650362, 94.442118092809324, 55.21261051895334, 94.370996876870777, 56.624874664137252, 94.238914618679701, 58.016818461908429, 94.035711144559173, 59.388441912266899, 93.781706801899418, 60.729584841506288, 93.446421069589633, 62.050407423332992, 93.060334468749716, 63.340749484040572, 92.603126651960338, 64.610771197335453, 92.074797619230594, 65.860472563217627, 91.495667717970719, 67.079693407980713, 90.845416600759563, 68.278593905331093, 90.124044267609861, 68.97964589106985, 89.646516103410249, 70.015983609118479, 88.884503075429166, 71.011680632341665, 88.061529005219199, 71.976897134445778, 87.177593892760342, 72.90147294172445, 86.232697738070783, 73.805728401590414, 85.226840541139609, 74.669343166630938, 84.160022301979552, 75.502477410552359, 83.032243020570604, 76.294970959648353, 81.843502696929136, 77.067144161331655, 80.603961504750259, 77.798676668189501, 79.293299096629198, 78.489568480221919, 77.931835819979824, 79.160139944841632, 76.49925132737917, 79.393823940087884, 75.970922294649426, 79.861191930580389, 74.832982839539909, 80.318399747366527, 73.664562863310493, 80.745127043033634, 72.485982713369594, 81.151533991287977, 71.266761868610047, 81.527460418423274, 70.037380850140835, 81.893226671852204, 68.777519310549906, 82.228512404162046, 67.497337423550562, 82.533317615352814, 66.1866750154295, 82.827962652837229, 64.855692259900025, 83.092127169202556, 63.504389156949401, 83.33597133815519, 62.122605532880698, 83.559495159695089, 60.720501561410856, 83.7525384601159, 59.298077242519867, 83.925261413124005, 57.845172402510798, 84.077664018719375, 56.371947215089676, 84.199586103195699, 54.868241506539562, 84.311348013965656, 53.344215450590127, 84.382469229910186, 51.799869047219545, 84.443430272148319, 50.225042122739978, 84.484070966973761, 48.629894850839264, 84.494231140680114, 47.014427231530135, 84.494231140680114, 46.465777851390158, 84.463750619561026, 44.758868668719515, 84.412949751029245, 43.08244000717059, 84.331668361378377, 41.446652040440313, 84.230066624314773, 39.831184421129365, 84.09798436613211, 38.256357496649798, 83.935421586830387, 36.712011093279216, 83.742378286409547, 35.198145211030351, 83.518854464869648, 33.724920023609229, 83.275010295917028, 32.272015183600161, 82.99052543213898, 30.859751038420654, 82.695880394654566, 29.467807240649563, 82.360594662344695, 28.116504137700758, 81.994828408915794, 26.795681555879128, 81.608741808074143, 25.515499668870689, 81.192174686113418, 24.25563812927976, 80.755287216739973, 23.026257110819643, 80.2777590525411, 21.837516787170898, 79.779910540929535, 20.679256984649328, 79.251581508198853, 19.55147770324038, 78.692771954349098, 18.454178942949511, 78.103481879380297, 17.387360703780359, 77.493871456998733, 16.36118315944077, 76.853780513498123, 15.355325962509596, 76.18320904887841, 14.390109460409803, 75.482157063139653, 13.455373479420814, 74.76078472998816, 12.551118019560818, 74.669343166630938, 12.439356108790889, 73.734607185645899, 11.392858217030152, 72.769390683541786, 10.397161193810462, 71.763533486612232, 9.462425212830567, 70.737355942269971, 8.5886502740795549, 69.670537703102269, 7.7758363775701582, 68.573238942815493, 7.0138233495908935, 67.445459661409643, 6.3229315375592705, 66.287199858884719, 5.6930007677692629, 65.098459535240693, 5.1138708665002923, 63.86907851677126, 4.6058621811898774, 62.619377150889079, 4.1486543644004996, 61.329035090181492, 3.7625677635605825, 60.008212508354802, 3.4272820312507974, 58.656909405409067, 3.1631175148795592, 57.264965607637862, 2.9497538670493668, 55.85270146245395, 2.7973512614498759, 54.399796622444619, 2.7059096980992763, 52.926571435022566, 2.6754291769793781, 73.257079021447026, 2.1877408390701021, 74.486460039916466, 2.8176716088692046, 75.685360537266831, 3.4780828997791104, 76.86394068720449, 4.1791348855203978, 78.022200489729414, 4.9106673923797644, 79.149979771135264, 5.6726804203499341, 80.267598878834775, 6.4651739694490971, 81.35473746541517, 7.2881480396608822, 82.421555704582872, 8.1517628047004109, 83.468053596337853, 9.0356979171592684, 84.494231140680114, 9.9602737244404125, 85.500088337609668, 10.915330052839636, 86.475465013420134, 11.900866902349662, 87.440681515524247, 12.916884272990501, 88.375417496509272, 13.963382164740324, 89.289833130081576, 15.050520751319709, 90.183928416241173, 16.168139859020812, 91.047543181281696, 17.316239487839994, 91.179625439464374, 17.478802267140054, 91.972118988560368, 18.616741722260485, 92.744292190243684, 19.764841351070572, 93.475824697101515, 20.923101153599418, 94.176876682840287, 22.101681303540317, 94.837287973753632, 23.290421627179967, 95.467218743547889, 24.499482298240764, 96.066668992223072, 25.728863316709976, 96.635638719779195, 26.958244335179188, 97.163967752509834, 28.218105874759203, 97.651656090415102, 29.477967414350132, 98.119024080907607, 30.768309475059141, 98.545751376574685, 32.068811709470538, 98.931837977416336, 33.37947411758978, 99.287444057138899, 34.71045687313017, 99.612569615742387, 36.05159980236931, 99.907214653226802, 37.402902905310839, 100.1612189958857, 38.784686529379542, 100.3847428174257, 40.16647015343915, 100.5676259441401, 41.568574124919905, 100.7200285497355, 42.990998443810895, 100.8419506342118, 44.42358293640973, 100.9232320238627, 45.876487776420618, 100.9841930661008, 47.339552790130256, 100.9943532398072, 48.812777977549558, 100.9943532398072, 49.087102667630461, 100.9740328923945, 50.590808376169662, 100.9232320238627, 52.084353910999198, 100.8317904605054, 53.54741892471975, 100.70986837602911, 55.000323764730638, 100.55746577043379, 56.432908257320378, 100.3644224700129, 57.855332576220462, 100.15105882217939, 59.247276373989735, 99.897054479520435, 60.629059998049343, 99.612569615742387, 61.990523274700536, 99.297604230845252, 63.34182637764934, 98.941998151122689, 64.662648959469152, 98.555911550281039, 65.973311367599308, 98.139344428320328, 67.263653428299222, 97.692296785240529, 68.543835315300385, 97.214768621041642, 69.79353668117983, 96.696599762017357, 71.033077873360526, 96.147950381873954, 72.252298718129168, 95.568820480611464, 73.46135938918087, 94.959210058229942, 74.63993953911995, 94.308958941022965, 75.808359515349366, 93.628227302696885, 76.956459144170367, 92.917015143251774, 78.094398599279884, 92.175322462687561, 79.201857533280418, 91.392989087297906, 80.299156293560372, 90.580175190789191, 81.376134706430094, 89.736880773161374, 82.442952945599245, 88.863105834414512, 83.479290663650318, 87.958850374548547, 84.505468207989907, 87.013954219857155, 85.511325404919262, 86.932672830206286, 85.592606794569292, 85.886174938451305, 86.639104686330029, 84.829516872989984, 87.655122056959954, 83.7525384601159, 88.62033855907066, 82.665399873535492, 89.544914366349985, 81.568101113248716, 90.439009652509412, 80.450482005549205, 91.292464243839277, 79.322702724143369, 92.095117966640828, 78.174603095324812, 92.867291168329757, 77.01634329279986, 93.598823675189124, 75.847923316568554, 94.289715487220747, 74.65918299292457, 94.939966604419169, 73.460282495574205, 95.559737200510426, 72.241061650811105, 96.128706928069732, 71.021840806048033, 96.66719613450914, 69.772139440165859, 97.154884472409321, 68.522438074283713, 97.612092289200518, 67.252416360988803, 98.028659411160334, 65.972234473987584, 98.404585838290586, 64.671732239573629, 98.739871570600371, 63.361069831453307, 99.034516608089689, 62.030087075920278, 99.288520950740349, 60.688944146680882, 99.5120447722893, 59.337641043735118, 99.68476772528993, 57.976177767083009, 99.827010157179757, 56.594394143018178, 99.928611894249116, 55.192290171540641, 99.989572936490731, 53.790186200063069, 100.00989328389915],
     ],

 82: [ [40.602466378163697, 45.715587326889363, 30.364066642842399, 45.715587326889363, 31.24668730968045, 45.676359741699343, 32.600038998832133, 45.646939052800008, 33.276714843407952, 45.607711467609988, 34.620259636261409, 45.578290778719747, 35.012535488189428, 45.578290778719747, 36.189363043973493, 45.588097675019526, 37.523100940528771, 45.617518363909767, 38.984328488960642, 45.656745949099786, 40.602466378163697, 45.715587326889363],
       [54.724397047572388, 47.58870451985058, 40.602466378163697, 45.715587326889363, 73.681127591993956, 0.0056436809791193809, 99.767471745207246, 0.0056436809791193809, 99.767471745207246, 2.6731194740896171, 99.630175197032415, 2.6927332666800794, 98.080685581916754, 2.8888711926501855, 96.590037344590272, 3.1340436000991758, 95.158230485052997, 3.4184435927490995, 93.785265003304914, 3.7616849631904188, 92.471140899346068, 4.13434702252016, 91.2158581731764, 4.5658504596394778, 90.019416824795954, 5.036581481959729, 88.891623750502873, 5.5465400894609047, 87.812865157700841, 6.1055331784591544, 86.792947942687974, 6.7135607489508402, 86.096658305515746, 7.1940986675599561, 85.292492809063305, 7.7923193417500443, 84.458906623716274, 8.4689951863292663, 83.615513542071028, 9.2241262012903462, 82.732892875232963, 10.05771238664056, 81.840465312096725, 10.979560638659677, 80.918617060065884, 11.970057164780883, 79.977155015438655, 13.039008861289403, 79.006272281916793, 14.176608831880003, 78.015775755798543, 15.40247086915042, 77.005665437083906, 16.706788076809971, 75.966134429474664, 18.089560454860475, 74.906989629268992, 19.550788003289199, 54.724397047572388, 47.58870451985058],
       [67.228189827778024, 92.759268869360312, 41.681224970965779, 92.288537847049156, 42.406935297032611, 92.278730950749377, 43.868162845464461, 92.210082676660022, 45.290162808703542, 92.062979232190628, 46.66312829045161, 91.84722751363006, 47.987059290708679, 91.553020624680357, 49.261955809474742, 91.190165461650395, 50.497624743048007, 90.758662024529258, 51.674452298832072, 90.248703417020806, 52.812052269423333, 89.660289639130497, 53.900617758523587, 89.003227587150832, 54.949955662431009, 88.277517261079993, 55.940452188549258, 87.473351764629115, 56.89172112947471, 86.600537994090701, 57.146700433227942, 86.335751794040334, 58.009707307469583, 85.355062164220726, 58.804065907623809, 84.33514494920928, 59.519969337392453, 83.276000149000538, 60.167224493073668, 82.167820867300179, 60.726217582071101, 81.010607104119117, 61.216562396981132, 79.814165755729846, 61.638258937803741, 78.568689925859871, 61.971693411942553, 77.274179614500099, 62.236479611993971, 75.940441717939393, 62.432617537957988, 74.567476236199582, 62.540493397238187, 73.145476272960877, 62.579720982430999, 71.674441828230556, 62.579720982430999, 71.380234939280854, 62.520879604641792, 69.987655664939666, 62.383583056466982, 68.634303975790317, 62.167831337906577, 67.31037297552939, 61.863817552662361, 66.03547645676008, 61.48134859703255, 64.799807523189884, 61.020424471017108, 63.593559278509929, 60.481045174616092, 62.426538619030907, 59.853403811531258, 61.30855244103077, 59.147307278060843, 60.219986951929968, 58.362755574204797, 59.170649048019186, 57.489941803664927, 58.150731833009559, 56.548479759037697, 57.179849099489729, 55.518755647726643, 56.248193951159919, 54.910728077238211, 55.748042239949427, 53.998686721505571, 55.0713663953793, 53.037610884281939, 54.443725032289876, 52.027500565567287, 53.855311254399567, 50.958548869063428, 53.315931958000874, 49.850369587366757, 52.815780246790382, 48.693155824179108, 52.364663017069688, 47.48690757950046, 51.942966476250149, 46.231624853330793, 51.580111313209272, 44.917500749371918, 51.256483735369329, 43.564149060220267, 50.972083742730319, 42.161762889577588, 50.726911335270415, 40.710342237443932, 50.530773409309404, 39.200080207521033, 50.383669964829096, 37.650590592405372, 50.275794105549721, 36.052066495798698, 50.207145831469461, 34.404507917701011, 50.187532038869904, 62.618948567623796, 50.011007905499355, 63.893845086389867, 50.560194098199645, 65.119707123664924, 51.138800979799271, 66.286727783150795, 51.756635446579821, 67.404713961145646, 52.403890602259708, 68.46385876135129, 53.080566446840749, 69.464162183767726, 53.786662980310211, 70.425238020991387, 54.531987098969694, 71.317665584127624, 55.316538802830109, 72.170865562071086, 56.120704299279168, 72.955417265927125, 56.964097380929161, 73.622286214204749, 57.738842188489798, 74.446065503253578, 58.817600781290821, 75.201196518214999, 59.925780062980266, 75.887679259089055, 61.063380033579961, 76.495706829577472, 62.230400693060801, 77.035086125978495, 63.426842041439158, 77.505817148292124, 64.65270407872049, 77.898093000220143, 65.898179908590464, 78.221720578060769, 67.182883323650458, 78.476699881813971, 68.497007427609788, 78.653224015181593, 69.840552220459358, 78.761099874461792, 71.213517702210083, 78.800327459654596, 72.606096976560366, 78.780713667058194, 73.665241776760013, 78.682644704076182, 75.057821051110295, 78.515927467006776, 76.420979636559423, 78.280561955849976, 77.74491063682035, 77.966741274307566, 79.039420948180123, 77.574465422379546, 80.304510570640559, 77.113541296364104, 81.530372607920071, 76.574161999963081, 82.726813956300248, 75.966134429474664, 83.893834615790183, 75.279651688600609, 85.021627690079185, 74.514713777340972, 86.110193179179987, 73.681127591993956, 87.169337979379634, 73.406534495644323, 87.483158660930712, 72.465072451017093, 88.512882772240118, 71.48438282119703, 89.473958609460169, 70.474272502482378, 90.385999965190422, 69.424934598574936, 91.239199943140193, 68.336369109474674, 92.023751646989695, 67.228189827778024, 92.759268869360312],
       [38.150742303613612, 97.770592877739546, 2.5419018448476289, 97.770592877739546, 2.5419018448476289, 95.103117084630867, 6.219487956672836, 95.103117084630867, 7.6709086088064993, 95.044275706839471, 9.1027154683437601, 94.857944677169144, 10.42664646860082, 94.534317099329201, 11.6328947132795, 94.083199869610326, 12.731267098677939, 93.494786091720016, 13.711956728498009, 92.778882661959869, 14.57496360273961, 91.935489580309877, 14.918204973176641, 91.474565454300318, 15.31048082510466, 90.739048231929701, 15.65372219554169, 89.817199979899669, 15.94792908448769, 88.709020698199311, 16.18329459564449, 87.424317283139317, 16.359818729012119, 85.953282838410814, 16.497115277186928, 84.305724260309944, 16.57557044757252, 82.481641548849439, 16.595184240168919, 80.471227807720425, 16.595184240168919, 17.314815647299838, 16.57557044757252, 15.343629491360844, 16.506922173485119, 13.539160572499895, 16.389239417906708, 11.921022683289266, 16.222522180837299, 10.489215823759878, 16.006770462276901, 9.2633537864803657, 15.75179115852367, 8.2238227788693621, 15.43797047698126, 7.370622800930505, 15.084922210246051, 6.7135607489508402, 14.54554291384502, 5.9780435265802225, 13.711956728498009, 5.1052297560399893, 12.750880891274351, 4.359905637380507, 11.68192919477049, 3.7518780668906402, 10.495294742688239, 3.2811470445794839, 9.1909775350275851, 2.9477125704397622, 7.7591706754902949, 2.7417677481807914, 6.219487956672836, 2.6731194740896171, 2.5419018448476289, 2.6731194740896171, 2.5419018448476289, 0.0056436809791193809, 44.4173490381637, 0.0056436809791193809, 44.4173490381637, 2.6731194740896171, 40.602466378163697, 2.6731194740896171, 39.288342274204858, 2.7221539555794152, 37.846728518369389, 2.9084849852406478, 36.522797518112327, 3.2223056667899073, 35.306742377135457, 3.6734228965106013, 34.218176888035202, 4.2618366743990919, 33.23748725821514, 4.987547000460836, 32.384287280271707, 5.8505538747103856, 32.041045909834708, 6.3016711044201656, 31.648770057906692, 7.0469952230905619, 31.305528687469661, 7.9688434751205932, 31.02112869482184, 9.0672158605102595, 30.78576318366504, 10.361726171879127, 30.599432153999231, 11.82295372030967, 30.47194250212263, 13.47051229841054, 30.39348733173702, 15.304401906170824, 30.364066642842399, 17.314815647299838, 30.364066642842399, 45.715587326889363, 40.602466378163697, 45.715587326889363, 54.724397047572388, 47.58870451985058, 55.430493581042853, 47.755421756919532, 56.979983196158528, 48.13789071255087, 58.470631433484989, 48.55958725337041, 59.902438293022257, 49.010704483089285, 61.295017567366742, 49.491242401700219, 62.618948567623796, 50.011007905499355, 34.404507917701011, 50.187532038869904, 34.159335510246002, 50.187532038869904, 32.737335547006921, 50.256180312959259, 30.364066642842399, 50.256180312959259, 30.364066642842399, 90.925379261600028, 30.942673524436231, 91.033255120879403, 32.580425206235731, 91.32746200982001, 34.129914821351413, 91.582441313579693, 35.600949266081471, 91.798193032129348, 36.993528540425928, 91.974717165499897, 38.288038851788393, 92.112013713680426, 39.504093992765263, 92.210082676660022, 40.631887067058322, 92.268924054449599, 41.681224970965779, 92.288537847049156, 67.228189827778024, 92.759268869360312, 66.080782960888584, 93.435944713939534, 64.89414850880631, 94.043972284420306, 63.67809336782944, 94.602965373420375, 62.42281064165978, 95.093310188329269, 61.138107226595523, 95.534620521750185, 60.275100352353867, 95.779792929210089, 59.314024515130242, 96.024965336660898, 58.294107300117368, 96.250523951519426, 57.225155603613551, 96.456468773780216, 56.097362529320478, 96.652606699750322, 54.910728077238211, 96.829130833109957, 53.675059143664967, 96.995848070180728, 52.370741936004279, 97.142951514659217, 51.017390246852628, 97.270441166530873, 49.605197179911748, 97.388123922110026, 48.143969631479898, 97.495999781389401, 46.614093808960632, 97.57445495176944, 45.035183504950332, 97.643103225860614, 43.39743182315086, 97.70194460365019, 41.700838763562153, 97.741172188849305, 39.955211222482482, 97.760785981439767, 38.150742303613612, 97.770592877739546],
     ],

 83: [ [12.84651454609096, 31.291685209620482, 10.18469654848843, 31.291685209620482, 10.18469654848843, -2.2271667670393072, 12.84651454609096, -2.2271667670393072, 13.092641552718559, -0.89625776823959313, 13.45727415512988, 0.47111449081057799, 13.903949093083719, 1.5103174076793948, 14.43266636658009, 2.2395826124993619, 14.861109674413401, 2.622446845029117, 15.927660036466451, 3.1511641185297776, 17.24945322020741, 3.3243646046703361, 41.898617143211389, 3.3972911251603364, 40.987035637183141, 3.4064069402193127, 39.674358268502459, 3.4702176456394227, 38.389028345002629, 3.5796074263598712, 37.112814236563061, 3.734576282389753, 35.863947573304358, 3.95335584383065, 34.624196725105918, 4.2177144805791613, 33.411793322088357, 4.5276521926298301, 32.217621549191328, 4.8922847950398136, 31.041681406414881, 5.3024964727501356, 29.883972893759001, 5.7765188558896625, 28.744496011223699, 6.2870044992705516, 27.62325075880895, 6.8521850329998415, 27.067186040131698, 7.153006929989715, 25.87301426723468, 7.8458088745792338, 24.742653199759651, 8.5750740793992009, 23.66698702264631, 9.3316867293997348, 22.655131550954959, 10.124762639650726, 21.707086784685568, 10.954301810130346, 20.822852723838171, 11.811188425799628, 19.993313553352461, 12.704538301699358, 19.236700903349, 13.625235622790569, 18.534783143707241, 14.591512019189395, 17.896676089487471, 15.576020045700716, 17.88756027442718, 15.585135860750597, 17.413537891292489, 16.414675031239312, 16.948631323218081, 17.308024907149957, 16.492840570203949, 18.265185488480711, 16.064397262370669, 19.286156775229756, 15.645069769597679, 20.37093876740073, 15.243973906945261, 21.510415649940114, 14.85199385935311, 22.722819052960403, 14.47824544188151, 23.989917346329094, 14.1227286545305, 25.329942160200517, 13.78544349730004, 26.724661864420341, 13.45727415512988, 28.18319227406937, 13.14733644308026, 29.705533389129414, 12.84651454609096, 31.291685209620482],
       [67.696373763810968, 99.997583318969191, 65.03455576620847, 99.997583318969191, 64.679038978857449, 98.584631984629596, 64.232364040903605, 97.262838800890677, 63.721878397527767, 96.241867514130718, 63.156697863790271, 95.530833939430522, 62.473011734269079, 95.011232480999752, 61.35176648185432, 94.537210097860225, 60.057320743294213, 94.382241241839438, 38.006164112470742, 94.236388200870351, 38.717197687172792, 94.227272385809556, 39.966064350431481, 94.163461680389446, 41.205815198629921, 94.035840269540131, 42.436450231768049, 93.844408153279801, 43.657969449845922, 93.598281146649242, 44.870372852863497, 93.297459249659369, 46.082776255881072, 92.923710832190409, 47.276948028778087, 92.495267524360315, 48.471119801675108, 92.003013511099198, 49.656175759511818, 91.456064607489679, 50.832115902288272, 90.845304998449137, 51.515802031809471, 90.462440765919382, 52.637047284224217, 89.769638821329863, 53.703597646277267, 89.040373616509896, 54.71545311796865, 88.274645151450386, 55.68172951435858, 87.463337611079623, 56.593311020386842, 86.606450995410341, 57.459313451113672, 85.703985304449816, 58.270620991478843, 84.765056353240652, 59.036349456542553, 83.780548326729331, 59.756498846304879, 82.759577039980286, 60.421953345705496, 81.693026677919988, 60.804817578237362, 80.981993103219793, 61.297071591492617, 80.015716706830062, 61.761978159567043, 79.003861235139993, 62.199537282460597, 77.946426688149586, 62.609748960173299, 76.834297250790769, 63.001729007765483, 75.667472923079913, 63.36636161017676, 74.464185335120419, 63.703646767407243, 73.206202856799791, 64.022700294517094, 71.902641303180644, 64.305290561385874, 70.544384859200363, 64.578765013194342, 69.140549339910649, 64.81577620476169, 67.691134745329691, 65.03455576620847, 66.187025260380324, 67.696373763810968, 66.187025260380324, 67.696373763810968, 99.997583318969191],
       [37.860311071506231, 99.997583318969191, 36.584096963066692, 99.97935168884942, 35.225840519084592, 99.91554098342931, 33.90404733534362, 99.79703538764079, 32.609601596783477, 99.642066531620003, 31.342503303404211, 99.432402785230806, 30.093636640145519, 99.177159963539452, 28.88123323712793, 98.876338066560493, 27.696177279291192, 98.520821279200391, 26.529352951575021, 98.12884123160984, 25.398991884099988, 97.682166293659975, 24.2959782618058, 97.189912280400677, 23.211196269632179, 96.652079191850135, 22.1628775376997, 96.068667027990159, 21.14190625094804, 95.430559973770869, 20.139166594316979, 94.755989659310217, 19.172890197927021, 94.02672445449025, 18.233961246717911, 93.251880174360849, 17.32237974068968, 92.431456818940205, 16.912168062976939, 92.03947677134056, 15.982354926828149, 91.091432005070601, 15.11635249610128, 90.116039793620075, 14.30504495573615, 89.122415952049778, 13.557548120792969, 88.110560480359709, 12.873861991271781, 87.071357563490892, 12.244870752112289, 86.013923016500485, 11.6705744033145, 84.938256839379392, 11.16008875993867, 83.835243217090465, 10.71341382198483, 82.713997964679947, 10.321433774392681, 81.574521082140564, 9.993264432222503, 80.407696754420613, 9.7289057954743043, 79.222640796589985, 9.5192420490878078, 78.019353208630491, 9.3642731930630134, 76.78871817549043, 9.2731150424601765, 75.539851512230598, 9.2457675972793538, 74.263637403790199, 9.2457675972793538, 74.126900177889183, 9.2822308575204602, 72.814222809209241, 9.3916206382438645, 71.519777070650889, 9.5648211243892263, 70.252678777269466, 9.8018323159565721, 69.012927929070429, 10.1026542129459, 67.791408710989344, 10.47640263041748, 66.597236938099741, 10.913961753311041, 65.43041261037979, 11.415331581626591, 64.281819912779611, 11.980512115364091, 63.160574660369093, 12.39072379307683, 62.440425270600826, 13.01971503223632, 61.419453983860876, 13.70340116175751, 60.425830142290579, 14.450897996700659, 59.441322115779258, 15.243973906945261, 58.475045719380432, 16.100860522611811, 57.527000953110473, 17.003326213579779, 56.606303632030176, 17.969602609969741, 55.69472212599976, 18.981458081661088, 54.801372250089116, 20.057124258774419, 53.935369819360858, 20.330598710582908, 53.716590257919961, 21.02340065516438, 53.1878729844193, 21.770897490107561, 52.640924080800687, 22.563973400352129, 52.066627731999688, 23.420860016018679, 51.474099753089831, 24.323325706986651, 50.863340144049289, 25.289602103376609, 50.234348904890794, 26.30145757506796, 49.578010220549913, 27.368007937121039, 48.903439906089261, 28.489253189535791, 48.210637961510656, 29.665193332312221, 47.49048857174057, 30.89582836545037, 46.752107551859808, 32.181158288950201, 45.995494901859274, 33.52118310281174, 45.220650621729874, 34.915902807034968, 44.41845889643082, 36.356201586559621, 43.598035540999263, 37.860311071506231, 42.759380555460666, 39.574084302839339, 41.793104159069117, 41.224046828750488, 40.854175207859953, 42.764619573938234, 39.969941147010104, 44.214034168523163, 39.131286161469689, 45.563174797444951, 38.347326066279493, 46.812041460703682, 37.608945046400549, 47.960634158299278, 36.925258916879102, 49.008952890231768, 36.287151862659812, 49.956997656501152, 35.703739698799836, 50.804768457107429, 35.165906610240199, 51.552265292050599, 34.682768412050791, 52.208603976390947, 34.245209289150807, 52.755552880007883, 33.862345056619233, 53.211343633022011, 33.534175714450612, 53.557744605312763, 33.260701262639486, 54.642526597486381, 32.376467201789637, 55.636150439057189, 31.474001510829112, 56.5568477601457, 30.55330418973972, 57.386386930631431, 29.614375238530556, 58.142999580634857, 28.657214657199802, 58.817569895095772, 27.681822445749276, 59.410097874014163, 26.679082789120002, 60.00262585293251, 25.466679386099713, 60.485764051127489, 24.245160168020448, 60.868628283659341, 23.023640949939363, 61.14210273546783, 21.811237546929988, 61.297071591492617, 20.607949958970494, 61.35176648185432, 19.395546555950204, 61.35176648185432, 19.085608843899536, 61.278839961372057, 17.836742180639703, 61.105639475226702, 16.633454592689304, 60.832165023418213, 15.457514449910377, 60.458416605946638, 14.318037567380088, 59.99351003787222, 13.205908130019452, 59.428329504134723, 12.130241952909273, 58.762875004734092, 11.081923220979661, 57.997146539670346, 10.079183564339473, 57.131144108943523, 9.0946755378299713, 56.164867712553558, 8.1557465866299026, 55.91874070592592, 7.9369670251799107, 55.025390830018239, 7.2077018203508487, 54.07734606374887, 6.551363136009968, 53.083722222178068, 5.949719342039316, 52.044519305305869, 5.411886253479679, 50.950621498071939, 4.937863870349247, 49.802028800476357, 4.5276521926298301, 48.607857027579342, 4.1812512203396182, 47.368106179380902, 3.8986609534695162, 46.073660440820788, 3.6798813920304383, 44.733635626959249, 3.5249125360005564, 43.338915922736021, 3.4246385703409032, 41.898617143211389, 3.3972911251603364, 17.24945322020741, 3.3243646046703361, 17.36795881599107, 3.3243646046703361, 18.024297500331411, 3.2605538992502261, 18.89029993105828, 3.1147008582902345, 19.947734478051039, 2.877689666720471, 21.205716956370029, 2.5586361396108259, 22.66424736601525, 2.1575402769594803, 24.323325706986651, 1.6652862637001817, 26.182951979284301, 1.0909899148991826, 27.094533485312549, 0.79016801792022306, 28.790075086525089, 0.24321911429979082, 30.312416201592299, -0.23080326883973612, 31.670672645574371, -0.64101494655005808, 32.855728603411109, -0.97830010377947474, 33.876699890162769, -1.2517745555906004, 34.724470690769039, -1.4523224869099067, 35.40815682029023, -1.5799438977592217, 35.736326162460387, -1.6346387881203555, 36.948729565477983, -1.8169550893308042, 38.188480413676388, -1.9628081302907958, 39.455578707055679, -2.0813137260702206, 40.750024445615793, -2.1633560616101022, 42.062701814296467, -2.2089351369195356, 43.411842443218291, -2.2271667670393072, 43.876749011292702, -2.2271667670393072, 45.262352900455653, -2.190703506799764, 46.611493529377469, -2.1086611712598824, 47.942402528178711, -1.9901555754695437, 49.236848266738832, -1.8260709043806855, 50.513062375178379, -1.6164071580005839, 51.761929038437103, -1.3611643363092298, 52.98344825651494, -1.0694582543801516, 54.177620029411969, -0.73217309715073498, 55.353560172188423, -0.34930886461916089, 56.493037054723743, 0.07913444320911367, 57.614282307138502, 0.54404101128966431, 58.699064299312113, 1.0545266546705534, 59.765614661365163, 1.610591373340867, 60.804817578237362, 2.212235167320614, 61.816673049928738, 2.8503422215399041, 62.810296891499547, 3.5340283510595327, 63.767457472829193, 4.2632935558794998, 64.697270608978016, 5.0290220209499239, 65.608852115006272, 5.8494453763705678, 65.909674011995591, 6.1320356432406697, 66.857718778264982, 7.0800804095106287, 67.741952839112386, 8.0372409908395639, 68.571492009598103, 9.021749017350885, 69.346336289722103, 10.024488673980159, 70.06648567948443, 11.045459960740118, 70.72282436382477, 12.09377869266973, 71.324468157803423, 13.160329054719114, 71.86230124636009, 14.245111046890088, 72.354555259615353, 15.348124669189929, 72.78299856744863, 16.478485736659422, 73.156746984920218, 17.627078434259602, 73.466684696969821, 18.793902761970458, 73.721927518657736, 19.988074534869156, 73.922475449983949, 21.200477937889445, 74.068328490948474, 22.431112971029506, 74.159486641551297, 23.679979634289339, 74.186834086732134, 24.947077927659848, 74.186834086732134, 25.10204678368973, 74.141255011430729, 26.378260892130129, 74.040981045767623, 27.636243370450757, 73.867780559622247, 28.885110033710589, 73.639885183115183, 30.124860881909626, 73.348179101186147, 31.346380099979797, 72.983546498774842, 32.558783503000086, 72.555103190941566, 33.76207109095958, 72.071964992746587, 34.947127048790207, 71.515900274069352, 36.123067191569135, 71.187730931899182, 36.752058430729448, 70.558739692739692, 37.836840422900423, 69.884169378278784, 38.88515915483913, 69.164019988516458, 39.915246256650789, 68.398291523452727, 40.908870098219268, 67.577868168027308, 41.866030679550022, 66.702749922240173, 42.804959630759186, 65.791168416211917, 43.707425321730625, 64.824892019821974, 44.582543567510584, 63.803920733070321, 45.430314368120889, 63.758341657768909, 45.457661813299637, 63.138466233669703, 45.931684196430069, 62.454780104148512, 46.423938209689368, 61.707283269205327, 46.943539668129233, 60.905091543900483, 47.481372756679775, 60.039089113173638, 48.046553290419979, 59.118391792085099, 48.629965454279954, 58.142999580634857, 49.249840878379473, 57.103796663762658, 49.878832117539787, 56.00078304146848, 50.544286616939644, 54.843074528812593, 51.227972746459272, 53.621555310734749, 51.929890506100492, 52.345341202295167, 52.659155710920459, 51.005316388433641, 53.415768360930088, 49.6105966842104, 54.199728456109369, 48.152066274565222, 55.001920181410242, 46.63884097455832, 55.822343536839981, 45.070920784189717, 56.670114337450286, 44.678940736597553, 56.879778083830388, 43.065441470927567, 57.754896329619442, 41.506637095619247, 58.620898760349519, 40.011643425732892, 59.459553745900848, 38.580460461268558, 60.289092916380469, 37.203972387165891, 61.091284641679522, 35.891295018485209, 61.884360551930513, 34.633312540166202, 62.659204832050818, 33.439140767269208, 63.406701666999652, 32.308779699794172, 64.145082686880414, 31.23311352268081, 64.865232076639586, 30.221258050989469, 65.567149836280805, 29.264097469659792, 66.250835965800434, 28.3707475937521, 66.916290465200291, 27.541208423266401, 67.563513334489471, 26.766364143142368, 68.201620388699666, 26.055330568440361, 68.812379997740209, 25.398991884099988, 69.40490797665916, 24.80646390518163, 69.988320140519136, 24.277746631685229, 70.544384859200363, 23.803724248550569, 71.091333762809882, 23.7307977280683, 71.182491913419653, 22.928606002763448, 72.239926460410061, 22.24491987324225, 73.324708452579216, 21.688855154565001, 74.445953705000647, 21.260411846731731, 75.594546402600827, 20.950474134682111, 76.779602360429635, 20.768157833476469, 77.992005763449924, 20.704347128054479, 79.240872426709757, 20.72257875817505, 79.888095295989842, 20.831968538898451, 81.091382883949336, 21.050748100345231, 82.258207211660192, 21.378917442515391, 83.397684094199576, 21.816476565408951, 84.518929346610093, 22.354309653965629, 85.603711338779249, 23.01064833830597, 86.670261700839546, 23.767260988309431, 87.700348802649387, 24.633263419036268, 88.712204274339456, 25.60865563048651, 89.696712300850777, 26.347036650369368, 90.343935170130862, 27.31331304675933, 91.082316190009806, 28.325168518450681, 91.747770689409663, 29.38260306544348, 92.331182853269638, 30.476500872677381, 92.832552681589732, 31.6159777552127, 93.260995989419825, 32.81014952810969, 93.607396961710037, 34.040784561247847, 93.880871413519344, 35.316998669687401, 94.081419344849564, 36.638791853428359, 94.199924940630808, 38.006164112470742, 94.236388200870351, 60.057320743294213, 94.382241241839438, 59.501256024616957, 94.4187045020808, 58.534979628227042, 94.619252433400106, 57.35903948545058, 94.974769220749295, 55.973435596287629, 95.49437067918916, 54.359936330617607, 96.178056808710608, 53.840334872181529, 96.405952185219576, 52.55500494868167, 96.934669458720236, 51.26967502518184, 97.42692347197044, 49.993460916742301, 97.8735984099294, 48.735478438423279, 98.274694272580746, 47.48661177516459, 98.639326874990729, 46.24686092696615, 98.958380402100374, 45.016225893828022, 99.231854853909681, 43.794706675750149, 99.468866045470349, 42.591419087792872, 99.660298161739775, 41.388131499835559, 99.806151202699766, 40.203075541998828, 99.91554098342931, 39.027135399222402, 99.97935168884942, 37.860311071506231, 99.997583318969191],
     ],

 84: [ [52.132522938841561, 91.638869269459974, 38.289179632013663, 91.638869269459974, 38.289179632013663, 16.949960557569284, 38.289179632013663, 16.396226825290796, 38.245749535364787, 14.289867137820693, 38.137174293742589, 12.422372981920489, 37.974311431309332, 10.772029309260688, 37.746303423902759, 9.3388361198485654, 37.464007795685092, 8.1445084620099806, 37.11656702249411, 7.1673312874117983, 36.703981104329841, 6.4181621202114911, 35.97652698546122, 5.5169876147483592, 35.010207335023843, 4.6483856817685592, 33.891882346315377, 3.9317890870588599, 32.621552019335873, 3.3780553547912859, 31.210073878247531, 2.9871844849512854, 29.635732874725932, 2.7483189533813857, 27.909386532933269, 2.6723162842499733, 24.456693849347939, 2.6723162842499733, 24.456693849347939, 0.0013653403402713593, 65.899863576533974, 0.0013653403402713593, 65.899863576533974, 2.6723162842499733, 62.512316037921963, 2.6723162842499733, 61.936867257324401, 2.6831738084110839, 60.253951012180622, 2.8026065741905768, 58.723040105307902, 3.0849022024085571, 57.344134536706221, 3.5083456447391654, 56.10637678221336, 4.0837944253289606, 55.020624365991573, 4.8221060683717951, 54.076019763878591, 5.7015655255090678, 53.685148894038761, 6.2552992577802797, 53.272562975874457, 7.1239011907600798, 52.925122202683497, 8.2096536069802823, 52.631969050303617, 9.5125565064408875, 52.414818567059243, 11.043467413310282, 52.251955704625978, 12.791528803430992, 52.165095511328232, 14.756740676799382, 52.132522938841561, 16.949960557569284, 52.132522938841561, 91.638869269459974],
       [85.432549544364107, 97.762512896948465, 5.6406044762241967, 97.762512896948465, 4.489706915029088, 74.842279390508338, 7.2258030039080117, 74.842279390508338, 7.3018056730435461, 75.678308751001168, 7.5080986321256802, 77.361224996140663, 7.801251784505566, 78.935565999669052, 8.1704076060209871, 80.423046809890366, 8.6047085725096935, 81.801952378489659, 9.1258697322961524, 83.083140229631681, 9.7230335612181449, 84.27746788748118, 10.396200059275669, 85.363220303701382, 11.06936655733317, 86.286109857490374, 12.08997382858167, 87.469579991171486, 13.175726244803471, 88.490187262421387, 14.315766281836369, 89.358789195401187, 15.531808988004769, 90.064528265938861, 16.812996839146511, 90.62911952237846, 17.334157998932959, 90.791982384809671, 18.409052890992541, 91.052562964701792, 19.668525693809841, 91.258855923781084, 21.112576407384811, 91.421718786219571, 22.741205031717531, 91.541151551999064, 24.554411566807911, 91.617154221141391, 26.54133848849381, 91.638869269459974, 38.289179632013663, 91.638869269459974, 52.132522938841561, 91.638869269459974, 65.899863576533974, 91.638869269459974, 85.432549544364107, 97.762512896948465],
       [85.432549544364107, 97.762512896948465, 65.899863576533974, 91.638869269459974, 67.257054096811217, 91.606296696969366, 68.907397769468346, 91.508578979508457, 70.470881248827752, 91.313143544601189, 71.925789486564966, 91.030847916379571, 73.282980006842195, 90.672549619019264, 74.542452809659494, 90.227391128370073, 75.704207895016822, 89.695372444421082, 76.74653021458974, 89.04392099468896, 77.886570251622629, 88.186176585870271, 78.939750095357766, 87.198141887110978, 79.916927269957398, 86.090674422568554, 80.807244251259263, 84.852916668078251, 81.610701039263404, 83.484868623629154, 82.04500200575211, 82.54026402152158, 82.457587923916407, 81.389366460331075, 82.826743745431827, 80.043033464211476, 83.174184518622795, 78.501265033180971, 83.489052719327105, 76.764061167221371, 83.771348347544759, 74.842279390508338, 86.507444436423697, 74.842279390508338, 85.432549544364107, 97.762512896948465],
     ],

 85: [ [43.050046354965431, 97.766453854779684, 0.81216099103183115, 97.766453854779684, 0.81216099103183115, 95.093423422880733, 4.4863264161476621, 95.093423422880733, 5.317268460519883, 95.083412072948704, 6.8790390499424197, 94.953264523828693, 8.3006507403141967, 94.682958075660281, 9.5821035316352692, 94.28250407836822, 10.723397423905549, 93.7519025319707, 11.71452106719293, 93.081142086510226, 12.56548581142958, 92.290245441869047, 13.056041958107141, 91.609473646480183, 13.51656405498816, 90.758508902239555, 13.91701805227599, 89.747362559090107, 14.247392600038451, 88.586045966949314, 14.527710398139909, 87.274559125839005, 14.737948746716039, 85.802890685801685, 14.888118995698971, 84.171040646859183, 14.978221145088741, 82.399031708861003, 15.00825519488531, 80.466841171950364, 15.00825519488531, 42.253518480749335, 15.018266544817511, 41.332474286991783, 15.028277894749699, 39.38026105020981, 15.058311944546301, 37.508138612891344, 15.098357344275071, 35.696084275161411, 15.158425443868239, 33.964120736891346, 15.238516243325799, 32.312247998081148, 15.328618392715571, 30.720443358870398, 15.428731892037529, 29.21874086904063, 15.548868091223889, 27.777106478799396, 15.68902699027463, 26.415562888021668, 15.83919723925756, 25.124098746771779, 16.009390188104891, 23.912725404970843, 16.18959448688442, 22.771431512701383, 16.37981013559612, 21.700217069948849, 16.59004848417224, 20.709093426670734, 16.82030953261274, 19.788049232898629, 17.060581930985428, 18.947095838600944, 17.32087702922253, 18.176221893820184, 17.350911079019099, 18.086119744439202, 17.871501275493291, 16.774632903321617, 18.44214822162844, 15.503191461928509, 19.052840567492371, 14.271795420270792, 19.723601012949491, 13.080444778341189, 20.434406858135372, 11.919128186200396, 21.195269452982259, 10.797856993791356, 22.016200147422278, 9.7166312011213449, 22.87717624159113, 8.6854621581005631, 23.778197735488749, 7.6743158149511146, 24.739287328979529, 6.7132262214618095, 25.75043367213128, 5.7921820277006191, 26.801625415011831, 4.9011718837282388, 27.912885257485542, 4.0602184894196398, 29.064190499688049, 3.2492991449216788, 29.384553697518321, 3.0390607963418006, 30.325620591144698, 2.4584025002695853, 31.316744234432079, 1.9177896039400366, 32.347913277448228, 1.4072107573883841, 33.429139070125373, 0.92666596065100748, 34.550410262531287, 0.48616656363083166, 35.721738204598203, 0.075701216410379857, 36.943122896326052, -0.30473008101034793, 38.204552987782719, -0.65512732863862766, 39.516039828900361, -0.96547917653879267, 40.867572069746757, -1.2457969746392337, 42.269161060254149, -1.4960807229399506, 43.710795450490352, -1.7063190715198289, 45.202486590387487, -1.8865233702999831, 46.744234479945618, -2.0366936192804133, 48.326027769232532, -2.1568298184683954, 49.957877808180427, -2.2369206179282628, 51.629773246857098, -2.2869773675884062, 53.351725435194773, -2.3070000674488256, 54.51304202732949, -2.2969887175204349, 56.124869366412987, -2.2469319678602915, 57.696651305767688, -2.1668411684004241, 59.238399195325833, -2.0467049692197179, 60.730090335222997, -1.8865233702999831, 62.191747425323548, -1.6963077215914382, 63.613359115695353, -1.4660466731511406, 64.984914056406154, -1.1957402249790903, 66.326434947320365, -0.89539972701095394, 67.627910438505793, -0.54500247938995017, 68.889340529962453, -0.16457118195830844, 70.12073657162253, 0.24589416525850538, 71.302075863621639, 0.70641626213910058, 72.443369755891922, 1.1969724088194198, 73.554629598365665, 1.7275739552314917, 74.615832691178383, 2.2882095514287357, 75.647001734194561, 2.8989018972897611, 76.638125377481913, 3.5396282929505105, 77.068613424566337, 3.8399687909186468, 54.222712879295791, 3.9000368905108189, 53.57197513370307, 3.9000368905108189, 52.030227244144932, 3.960104990099353, 50.53853610424779, 4.0702298393589444, 49.096901714011622, 4.2504341381390986, 47.7153354233686, 4.4806951865793962, 46.38382588238656, 4.7810356845511706, 45.112384440997729, 5.1314329321685364, 43.890999749269852, 5.5519096293210168, 42.719671807202971, 6.0324544260693074, 41.60841196472925, 6.5630559724813793, 40.767458570424807, 7.0135667194190319, 39.496017129035963, 7.7744293142714014, 38.32468918696906, 8.5753373088482476, 37.223440694427538, 9.4263020530815993, 36.212294351275759, 10.337334896910761, 35.281238807581573, 11.288413140471675, 34.440285413277131, 12.289548133689095, 33.679422818430268, 13.340739876570296, 33.208889371617083, 14.091591121479723, 32.63824242548192, 15.142782864368201, 32.117652229007732, 16.264054056769965, 31.647118782194539, 17.475427398570901, 31.20661938517792, 18.776902889749181, 30.826188087754488, 20.158469180398242, 30.485802190059829, 21.620126270499895, 30.18546169209397, 23.171885509989806, 29.935177943789071, 24.803735548928671, 29.84507579439931, 25.41442789480061, 29.634837445823209, 26.946164434419188, 29.45463314704368, 28.437855574320565, 29.294451548128549, 29.89951266441858, 29.154292649077821, 31.321124354788481, 29.044167799823661, 32.70269064544118, 28.964077000366089, 34.044211536351213, 28.904008900772919, 35.355698377468798, 28.863963501044161, 36.627139818858268, 28.853952151111951, 37.858535860519623, 28.853952151111951, 80.466841171950364, 28.853952151111951, 80.556943321331346, 28.88398620090852, 82.50915655810968, 28.964077000366089, 84.281165496111498, 29.10423589941685, 85.882981485261553, 29.304462898060748, 87.304593175631453, 29.554746646365651, 88.556011917160504, 29.865098494263709, 89.637237709841429, 30.235518441754959, 90.548270553659677, 30.655995138907159, 91.279099098708684, 30.90627888721205, 91.629496346340602, 31.727209581652112, 92.550540540101792, 32.668276475278489, 93.331425834818219, 33.739490918023442, 93.962140880539664, 34.940852909886907, 94.462708377148374, 36.262351100936762, 94.813105624780292, 37.713996841105129, 95.023343973349256, 39.305801480324241, 95.093423422880733, 43.050046354965431, 95.093423422880733, 43.050046354965431, 97.766453854779684],
       [105.03031378518889, 97.766453854779684, 70.441099769452791, 97.766453854779684, 70.441099769452791, 95.093423422880733, 74.115265194568622, 95.093423422880733, 75.386706635957466, 95.05337802314898, 76.868386425922438, 94.873173724368826, 78.219918666768848, 94.562821876468661, 79.461326058361109, 94.102299779591704, 80.582597250767023, 93.511630133598374, 81.583732243986574, 92.790812938481395, 82.474742387952006, 91.929836844308738, 82.745048836121285, 91.559416896820039, 83.15551418334131, 90.818577001831727, 83.515922780900354, 89.897532808070537, 83.806251928934017, 88.786272965600801, 84.056535677238926, 87.494808824350912, 84.24675132595064, 86.013129034381564, 84.386910225001387, 84.351244945639337, 84.467001024458952, 82.499145208181289, 84.487023724323336, 80.466841171950364, 84.487023724323336, 40.881963540039578, 84.487023724323336, 40.691747891331033, 84.477012374391137, 38.799602754148509, 84.446978324594554, 36.977537066479272, 84.386910225001387, 35.225550828348787, 84.316830775476006, 33.543644039738865, 84.216717276154057, 31.93181670066042, 84.096581076967695, 30.390068811098899, 83.956422177916963, 28.918400371068856, 83.796240579001832, 27.516811380559375, 83.616036280222318, 26.185301839581371, 83.415809281578404, 24.923871748120291, 83.185548233137894, 23.732521106190688, 82.945275834765198, 22.60123856384962, 82.674969386595919, 21.550046820968419, 82.39465158849444, 20.568934527618694, 82.084299740596379, 19.657901683789532, 81.753925192833904, 18.816948289480933, 81.703868443172937, 18.706823440228618, 81.153244196902165, 17.545506848091463, 80.522529151173828, 16.424235655689699, 79.811723305987954, 15.343009863008774, 79.030838011276686, 14.301829470059602, 78.169861917107852, 13.290683126910153, 77.228795023481453, 12.329593533420848, 76.207637330397503, 11.398537989731267, 75.116400187788173, 10.517539195690915, 73.945072245721292, 9.6665744514612015, 72.703664854129016, 8.8556551069486886, 71.372155313147005, 8.0747698122395377, 70.290929520469859, 7.5041228660993511, 69.079556178674181, 6.9334759199700784, 67.848160137014105, 6.4028743735616445, 66.596741395489659, 5.9223295768206299, 65.315288604168614, 5.5018528796608734, 64.013813112983172, 5.1214215822401457, 62.692314921933338, 4.8010583844115899, 61.340782681086928, 4.5207405863111489, 59.95921639044392, 4.300490887799242, 58.567638749868713, 4.1202865890190878, 57.136015709564731, 4.0001503898311057, 55.694381319328564, 3.9200595903785143, 54.222712879295791, 3.9000368905108189, 77.068613424566337, 3.8399687909186468, 78.289998116294214, 4.7209675849517225, 79.45131470842891, 5.6320004287808842, 80.552563200970425, 6.57306732240977, 81.583732243986574, 7.5441682658311038, 82.554833187409571, 8.5352919091201329, 83.465866031239386, 9.5564496022016101, 84.316830775476006, 10.607641345079173, 85.097716070187275, 11.678855787831708, 85.828544615237575, 12.780104280369414, 86.489293710762468, 13.911386822710483, 87.079963356762022, 15.062692064908333, 87.620576253100594, 16.244031356909545, 88.091109699913787, 17.455404698699567, 88.301348048489899, 18.036062994771783, 88.62171124632016, 19.057220687860536, 88.922051744286009, 20.138446480530547, 89.2123808923197, 21.259717672939587, 89.472675990556795, 22.43104561500877, 89.712948388929505, 23.642418956798792, 89.933198087437788, 24.913860398188262, 90.133425086081701, 26.225347239309485, 90.303618034929031, 27.596902180019242, 90.463799633844147, 28.998491170528723, 90.603958532894893, 30.460148260630376, 90.714083382149056, 31.971862100388535, 90.814196881471005, 33.523621339878446, 90.884276330996386, 35.135448678960529, 90.934333080657353, 36.787321417770727, 90.964367130453951, 38.489250906248344, 90.974378480386136, 40.231225794450438, 90.974378480386136, 79.886182875881786, 90.994401180250534, 81.277760516448325, 91.054469279843701, 83.169905653641763, 91.164594129097864, 84.851812442251685, 91.324775728012995, 86.333492232210119, 91.545025426521306, 87.614945023531618, 91.805320524758386, 88.706182166140934, 92.125683722588633, 89.587180960181286, 92.496103670079876, 90.267952755559236, 93.236943565062347, 91.309133148508408, 94.137965058959978, 92.310268141729466, 95.129088702247344, 93.161232885970094, 96.200303144992304, 93.862027381219377, 97.361619737126986, 94.40264027755984, 98.613038478651447, 94.793082924908958, 99.944548019633487, 95.023343973349256, 101.35614836007301, 95.093423422880733, 105.03031378518889, 95.093423422880733, 105.03031378518889, 97.766453854779684],
     ],

 86: [ [104.8185316399607, 97.767566718070157, 74.68696755991941, 97.767566718070157, 74.68696755991941, 95.100002024639252, 75.915330683352806, 94.879996689098334, 75.933664461314493, 94.879996689098334, 77.501202477039186, 94.586656241710443, 78.922070269070346, 94.22914757145918, 80.168767170465415, 93.816637567320868, 81.268793848166965, 93.339959340319183, 82.203816524213266, 92.80827977943045, 82.973835198604348, 92.212431995671068, 83.716353206052887, 91.442413321281492, 84.468038102482254, 90.379054199511302, 84.917215662543754, 89.288194410790311, 85.063885886237259, 88.179000844098482, 85.05471899725643, 87.839825951810781, 84.981383885409656, 87.042306610481319, 84.834713661716108, 86.134784601370484, 84.614708326175816, 85.108093035520142, 84.312200989807891, 83.971398801888427, 83.936358541593194, 82.724701900500804, 83.487180981531736, 81.349668553368247, 82.955501420642662, 79.87379942744883, 82.359653636887657, 78.278760744789906, 81.681303852305035, 76.564552505369647, 58.617411176496091, 19.977346826610301, 53.428952013337152, -2.2340251739806263, 56.096516706763389, -2.2340251739806263, 90.188176826530267, 80.964659216169821, 90.215677493472825, 81.047161217000394, 90.811525277227815, 82.4496952310692, 91.425706838944507, 83.788061022278271, 92.058222178622884, 85.043924812649493, 92.709071296262977, 86.226453491181019, 93.378254191864741, 87.344813946849172, 94.056603976447349, 88.380672401679476, 94.753287538991685, 89.343195744670084, 95.477471768478509, 90.223217086830118, 96.210822886946204, 91.039070206130418, 96.9625077833756, 91.781588213569194, 97.60419001203482, 92.313267774461565, 98.53921268808115, 92.927449336180871, 99.575071142916755, 93.48662956400949, 100.72093226552251, 93.981641568978375, 101.9767960558984, 94.421652240060212, 103.34266251404451, 94.788327799291437, 104.8185316399607, 95.100002024639252, 104.8185316399607, 97.767566718070157],
       [41.246156557792602, 97.767566718070157, 1.3151881572267139, 97.767566718070157, 1.3151881572267139, 95.100002024639252, 2.4243817239091068, 94.989999356868793, 3.8452495159402531, 94.797494688271399, 5.1652815291820948, 94.559155574770557, 6.3661439856729478, 94.265815127379028, 7.4661706633744984, 93.917473346111365, 8.4561946733058733, 93.514130230949377, 8.9603735672524181, 93.239123561528686, 10.051233355973119, 92.569940665929607, 11.068758032847031, 91.799921991540032, 11.9946138199125, 90.938234427339921, 12.847134495131201, 89.975711084349314, 13.17714249844164, 89.517366635311191, 13.607986280541409, 88.802349294801388, 14.11216517448795, 87.876493507741543, 14.680512291300429, 86.730632385129866, 15.32219451995965, 85.383099704940832, 16.037211860465639, 83.824728578201757, 16.816397423837572, 82.046352115921763, 53.428952013337152, -2.2340251739806263, 58.617411176496091, 19.977346826610301, 33.747641371460453, 77.288736734859413, 33.610138036747742, 77.627911627150752, 32.940955141145992, 79.22295030982059, 32.35427424637183, 80.71715321369993, 31.840928463444438, 82.11968722776146, 31.410084681344671, 83.430552352019731, 31.06174290007252, 84.640581697498419, 30.78673623064714, 85.758942153159296, 30.59423156204938, 86.776466830029676, 30.475062005298359, 87.702322617100435, 30.438394449374989, 88.536509514349746, 30.548397117145129, 89.691537525941385, 30.915072676378969, 90.846565537529386, 31.556754905038218, 91.882423992370605, 32.45511002516114, 92.789946001470526, 32.583446470893001, 92.890781780261023, 33.270963144456459, 93.321625562359259, 34.141817597636837, 93.715801788530371, 35.205176719415, 94.07331045878891, 36.442706731829219, 94.384984684129449, 37.863574523860372, 94.659991353561054, 39.458613206527623, 94.898330467058258, 41.246156557792602, 95.100002024639252, 41.246156557792602, 97.767566718070157],
     ],

 87: [ [67.195003935495436, 69.36284517643071, 50.97796894325279, 22.717219512960583, 45.791070173952022, -2.2327663070282142, 48.379961651072271, -2.2327663070282142, 70.513160617438274, 60.274377561330766, 67.195003935495436, 69.36284517643071],
       [138.18897162497581, 97.767724904271745, 109.0001318019511, 97.767724904271745, 109.0001318019511, 95.096791091611522, 110.0211030887028, 95.087675276550726, 111.4522860531671, 95.014748756060726, 112.77407923690809, 94.878011530159711, 113.99559845498599, 94.677463598840404, 115.1168437074007, 94.413104962088255, 116.1286991790921, 94.084935619910539, 116.9035434592161, 93.738534647618508, 117.9245147459677, 93.027501072920131, 118.7996329917549, 92.070340491591196, 119.2189604845279, 91.368422731949977, 119.6565196074214, 90.20159840424094, 119.8114884634462, 88.97096337109906, 119.8114884634462, 88.934500110848603, 119.7750252032051, 88.187003275910683, 119.674751237542, 87.330116660250496, 119.51066656645691, 86.363840263860766, 119.2918870050101, 85.288174086741492, 119.0092967381414, 84.103118128910864, 118.65377995079029, 82.817788205411489, 118.2435682730776, 81.413952686121775, 117.7695458899429, 79.909843201181502, 117.23171280138629, 78.296343935511686, 116.6391848224679, 76.573454889108689, 98.042922099491548, 22.717219512960583, 92.783096809708525, -2.2327663070282142, 95.663694368757788, -2.2327663070282142, 122.9108655839423, 76.573454889108689, 122.93821302912311, 76.673728854781075, 123.5398568231018, 78.496891866830993, 124.1050373568393, 80.174201837919099, 124.6337546303357, 81.705658768049034, 125.13512445865121, 83.109494287338748, 125.6000310267256, 84.376592580709257, 126.03759014961921, 85.49783783312887, 126.4386860122716, 86.482345859640191, 126.81243442974321, 87.330116660250496, 127.1406037719134, 88.041150234948873, 127.45054148396299, 88.606330768689077, 127.806058271314, 89.217090377718705, 128.61736581167909, 90.43860959579979, 129.4377891671046, 91.505159957858268, 130.27644415265061, 92.407625648818794, 131.12421495325691, 93.146006668699556, 131.99021738398369, 93.72941883256135, 132.04491227434539, 93.765882092811808, 133.04765193097651, 94.239904475940421, 134.16889718339121, 94.613652893411199, 135.39041640146911, 94.887127345220506, 136.73044121533059, 95.042096201239474, 138.18897162497581, 95.096791091611522, 138.18897162497581, 97.767724904271745],
       [38.142901338374998, 97.767724904271745, 1.9622313641135909, 97.767724904271745, 1.9622313641135909, 95.096791091611522, 2.7006123839964848, 95.087675276550726, 4.1317953484608259, 95.005632940999931, 5.4627043472620747, 94.832432454859372, 6.665991935219381, 94.577189633171656, 7.7598897424532822, 94.230788660879625, 8.7443977689638075, 93.802345353051351, 9.3095783027013113, 93.45594438075932, 10.284970514151549, 92.717563360871281, 11.169204574998959, 91.842445115089504, 11.95316467018324, 90.830589643388521, 12.63685079970443, 89.691112760858232, 12.84651454609096, 89.244437822908367, 13.129104812959691, 88.606330768689077, 13.466389970190161, 87.776791598200361, 13.86748583284259, 86.764936126510293, 14.323276585856719, 85.570764353611594, 14.84287804429283, 84.194276279511541, 15.417174393090621, 82.626356089138426, 16.046165632250109, 80.88523541262839, 16.73896757683158, 78.952682619848929, 45.791070173952022, -2.2327663070282142, 50.97796894325279, 22.717219512960583, 31.73448335099636, 77.5761945457416, 31.442777269067339, 78.414849531291111, 30.841133475088672, 80.201549283108761, 30.303300386532019, 81.833280178900168, 29.8383938184576, 83.328273848779645, 29.455529585925721, 84.668298662640154, 29.127360243755561, 85.871586250599648, 28.88123323712793, 86.919904982540174, 28.708032750982571, 87.8223706735007, 28.598642970259171, 88.578983323499415, 28.562179710018029, 89.189742932550871, 28.662453675681149, 90.247177479541278, 29.02708627809244, 91.386654362071567, 29.674309147372501, 92.425857278951298, 30.576774838340469, 93.364786230151367, 31.424545638946771, 93.966430024131114, 32.445516925698399, 94.458684037388593, 33.621457068474847, 94.81420082474142, 34.95236606727611, 95.023864571121521, 36.420012291981578, 95.096791091611522, 38.142901338374998, 95.096791091611522, 38.142901338374998, 97.767724904271745],
       [86.438489527751855, 97.767724904271745, 48.379961651072271, 97.767724904271745, 48.379961651072271, 95.096791091611522, 49.072763595653761, 95.087675276550726, 50.558641450479797, 95.023864571121521, 51.771044853497379, 94.878011530159711, 52.7099738047065, 94.668347783768695, 52.928753366153281, 94.595421263289609, 54.049998618568019, 94.130514695221791, 55.180359686043062, 93.528870901238406, 56.31072075351809, 92.790489881350368, 56.894132917376169, 92.352930758461298, 57.823946053524992, 91.486928327729402, 58.61702196376956, 90.484188671111042, 59.027233641482269, 89.86431324699879, 59.665340695702071, 88.825110330129974, 60.285216119801277, 87.740328337960818, 60.886859913779922, 86.59173564035882, 61.452040447517447, 85.397563867471035, 62.00810516619466, 84.139581389150408, 64.314406376446158, 77.5761945457416, 67.195003935495436, 69.36284517643071, 70.513160617438274, 60.274377561330766, 92.783096809708525, -2.2327663070282142, 98.042922099491548, 22.717219512960583, 79.300806335550647, 75.853305499349517, 79.054679328923015, 76.546107443929941, 78.489498795185483, 78.214301599960891, 77.979013151809681, 79.782221790330368, 77.523222398795554, 81.249868015038373, 77.140358166263681, 82.617240274081269, 76.812188824093511, 83.884338567459054, 76.538714372285042, 85.042047080118209, 76.329050625898532, 86.108597442169412, 76.174081769873737, 87.065758023498347, 76.092039434331198, 87.922644639158534, 76.055576174090064, 88.679257289171801, 76.064691989150347, 88.925384295798722, 76.210545030114844, 90.247177479541278, 76.566061817465879, 91.432233437368268, 77.140358166263681, 92.471436354251637, 77.933434076508263, 93.364786230151367, 77.95166570662883, 93.383017860269319, 78.790320692174816, 94.002893284370657, 79.793060348805895, 94.486031482570979, 80.969000491582335, 94.823316639798577, 82.318141120504166, 95.032980386178679, 83.840482235571343, 95.096791091611522, 86.438489527751855, 95.096791091611522, 86.438489527751855, 97.767724904271745],
     ],

 88: [ [48.234108610107768, 48.096512944739516, 25.171096507592949, 18.962368012071238, 24.67884249433769, 18.342492587980814, 23.712566097947729, 17.157436630139273, 22.764521331678338, 16.036191377719661, 21.843824010589799, 14.969641015668458, 20.93224250456154, 13.966901359039184, 20.057124258774419, 13.018856592771044, 19.191121828047581, 12.143738346978353, 18.352466842501599, 11.323314991561347, 17.53204348707618, 10.566702341551718, 16.7298517617713, 9.8647845819104987, 15.945891666587009, 9.2357933427483658, 15.15281575634242, 8.6250337337114615, 14.09538120934965, 7.8593052686483134, 13.01971503223632, 7.1391558788891416, 11.934933040062701, 6.4645855644193944, 10.831919417768489, 5.8264785102110181, 9.7197899804140206, 5.2430663463492237, 8.5894289129389847, 4.6961174427306105, 7.4408362153434089, 4.1856317993588164, 7.3132148044994381, 4.1309369089904067, 6.219316997265536, 3.7207252312800847, 5.061608484609649, 3.3652084439308965, 3.8127418213509539, 3.0735023619999993, 2.500064452670272, 2.8456069854910311, 1.105344748447038, 2.6724064993504726, 1.105344748447038, 0.0014726866902492475, 35.772789422701521, 0.0014726866902492475, 35.772789422701521, 2.6724064993504726, 35.563125676315032, 2.6815223144112679, 33.894931520283343, 2.7909120951298974, 32.399937850396981, 2.9823442113993224, 31.10549211183687, 3.2284712180189672, 29.993362674482398, 3.5475247451395262, 29.072665353393859, 3.9395047927282576, 28.343400148571249, 4.4044113607997133, 27.75087216965289, 4.9240128192395787, 27.00337533470972, 5.8994050306901045, 26.547584581695592, 7.0024186529808503, 26.401731540731081, 8.2239378710582969, 26.419963170851648, 8.7253076993802097, 26.620511102177861, 9.9650585475683329, 27.048954410011131, 11.177461950588622, 27.130996745553691, 11.341546621679299, 27.52297679314583, 12.025232751198928, 28.097273141943621, 12.900350996991619, 28.863001607007359, 13.976017174099979, 29.811046373276749, 15.25223128253856, 30.941407440751789, 16.728993322300084, 51.40641225108606, 42.973424880859966, 48.234108610107768, 48.096512944739516],
       [48.234108610107768, 97.768589208219055, 3.0470133562872088, 97.768589208219055, 3.0470133562872088, 95.097655395551556, 3.748931115928968, 95.07030795036917, 5.0707242996699327, 94.970033984711336, 6.3742858532903313, 94.805949313620658, 7.6413841466696217, 94.587169752179761, 8.8720191798077508, 94.30457948530966, 10.075306767765049, 93.958178513021267, 11.251246910541511, 93.557082650360826, 12.39983960813708, 93.09217608228937, 13.52108486055184, 92.572574623849505, 14.60586685272548, 91.989162459998624, 15.66330139971825, 91.351055405779334, 16.264945193696889, 90.931727913000941, 16.975978768398932, 90.393894824450399, 17.714359788281818, 89.792251030470652, 18.470972438285258, 89.126796531068976, 19.245816718409291, 88.397531326249009, 20.029776813593571, 87.613571231060632, 20.841084353958738, 86.756684615400445, 21.670623524444441, 85.84510310936821, 22.527510140110991, 84.869710897921323, 23.393512570837832, 83.830507981041592, 24.277746631685229, 82.727494358750846, 25.180212322653212, 81.560670031030895, 26.110025458802031, 80.339150812960725, 27.048954410011131, 79.04470507438964, 28.015230806401089, 77.695564445468335, 28.990623017851309, 76.28261311112874, 48.234108610107768, 48.096512944739516, 51.40641225108606, 42.973424880859966, 67.988079845740003, 17.88670183495924, 68.92700879694911, 16.482866315669526, 69.875053563218501, 15.042567536151182, 70.649897843342515, 13.821048318081012, 71.260657452381452, 12.836540291558777, 71.689100760214728, 12.070811826499266, 71.953459396962913, 11.542094552998606, 72.236049663831679, 10.712555382520804, 72.509524115640147, 9.4728045343217673, 72.600682266242984, 8.2239378710582969, 72.582450636122417, 7.8866527138306992, 72.299860369253651, 6.710712571060867, 71.661753315033877, 5.5530040583907976, 71.178615116838898, 4.9787077096007124, 70.239686165629806, 4.1491685391083593, 69.136672543335621, 3.5384089300787309, 68.29801755778962, 3.2649344782694243, 67.23146719573657, 3.0279232866996608, 65.973484717417577, 2.8547228005481884, 64.551417568013505, 2.7362172047687636, 62.93791830234349, 2.6724064993504726, 62.93791830234349, 0.0014726866902492475, 104.88889920976369, 0.0014726866902492475, 104.88889920976369, 2.6724064993504726, 104.68835127843749, 2.6815223144112679, 103.3027473892745, 2.8091437252514879, 101.97183839047329, 3.0096916565817082, 100.69562428203371, 3.2922819234518101, 99.483220879016187, 3.6386828957402031, 98.316396551300016, 4.0580103885113203, 97.213382929005832, 4.5593802168295952, 96.155948382013051, 5.124560750558885, 95.162324540442256, 5.7717836198498844, 94.223395589233164, 6.4919330096090562, 94.022847657906937, 6.6560176806888194, 93.475898754289986, 7.1300400638283463, 92.892486590431915, 7.6861047825004789, 92.272611166332695, 8.3059802066018165, 91.625388297052638, 8.9896663361214451, 90.941702167531446, 9.7553948011882312, 90.230668592829389, 10.594049786730466, 89.483171757886225, 11.496515477698267, 88.699211662701927, 12.471907689148793, 87.887904122336778, 13.520226421078405, 87.040133321730536, 14.641471673501655, 86.155899260883103, 15.835643446400354, 85.244317754854876, 17.093625924720982, 84.296272988585457, 18.424534923509782, 83.311764962074946, 19.837486257860292, 82.299909490383584, 21.314248297629092, 81.251590758451087, 22.863936857869703, 60.276100304740993, 54.149414144758339, 56.666237540869098, 59.336312914070731, 41.679837581764609, 81.761217962361115, 40.904993301640587, 82.946273920199019, 40.084569946215169, 84.313646179238276, 39.40999963175426, 85.571628657558904, 38.890398173318147, 86.720221355149988, 38.516649755846572, 87.7685400870796, 38.297870194399792, 88.707469038301497, 38.215827858857239, 89.546124023840093, 38.279638564279232, 90.184231078059383, 38.635155351630232, 91.259897255171381, 39.337073111271991, 92.271752726868726, 40.385391843204502, 93.2289133082013, 40.713561185374651, 93.465924499760149, 41.53398454080007, 93.912599437710014, 42.527608382370879, 94.286347855180793, 43.69443271008705, 94.587169752179761, 45.034457523948589, 94.824180943738611, 46.547682823955483, 94.997381429890083, 48.234108610107768, 95.097655395551556, 48.234108610107768, 97.768589208219055],
       [102.6555245199945, 97.768589208219055, 67.988079845740003, 97.768589208219055, 67.988079845740003, 95.097655395551556, 68.735576680683181, 95.08853958049076, 70.440234096956019, 95.024728875068831, 71.898764506601225, 94.933570724471792, 73.120283724679084, 94.805949313620658, 74.095675936129311, 94.65098045760169, 74.834056956012205, 94.45043252627147, 75.736522646980177, 94.012873403378762, 76.730146488550972, 93.256260753380047, 77.568801474096944, 92.289984356979403, 77.760233590362901, 92.01650990518101, 78.270719233738717, 90.886148837700603, 78.434803904823809, 89.61905054431918, 78.416572274703242, 89.126796531068976, 78.216024343377029, 87.877929867809144, 77.787581035543724, 86.665526464788854, 77.760233590362901, 86.610831574431359, 77.368253542770745, 85.92714544491173, 76.803073009033227, 85.061143014179834, 76.064691989150347, 84.003708467189426, 75.143994668061808, 82.763957618990389, 74.040981045767623, 81.332774654529203, 56.666237540869098, 59.336312914070731, 60.276100304740993, 54.149414144758339, 79.665438937961952, 78.953546923788963, 80.540557183749073, 80.074792176208575, 81.579760100621286, 81.360122099711589, 82.564268127131797, 82.57252550272824, 83.503197078340875, 83.702886570201372, 84.396546954248578, 84.751205302130984, 85.244317754854876, 85.717481698520714, 86.055625295220025, 86.601715759370563, 86.812237945223444, 87.403907484669617, 87.523271519925487, 88.133172689500498, 88.188726019326126, 88.771279743719788, 88.817717258485615, 89.327344462399196, 89.428476867524537, 89.846945920831786, 90.4403323392159, 90.640021831080958, 91.479535256088099, 91.37840285096172, 92.555201433201447, 92.062088980481349, 93.658215055495646, 92.691080219639844, 94.788576122970667, 93.274492383501638, 95.946284635626554, 93.803209656991385, 96.320033053098143, 93.949062697960471, 97.377467600090924, 94.295463670248864, 98.535176112746797, 94.587169752179761, 99.802274406126074, 94.815065128681454, 101.1787624802287, 94.988265614829288, 102.6555245199945, 95.097655395551556, 102.6555245199945, 97.768589208219055],
     ],

 89: [ [104.4513400868701, 97.769453512151813, 70.367307576473763, 97.769453512151813, 70.367307576473763, 95.09851969949159, 71.433857938526813, 95.080288069359085, 72.89238834817202, 94.989129918758408, 74.177718271671864, 94.815929432621488, 75.280731893966049, 94.569802425990929, 76.201429215054588, 94.232517268759693, 76.383745516260234, 94.150474933208898, 77.504990768674986, 93.466788803689269, 78.453035534944362, 92.65548126332942, 79.227879815068391, 91.707436497061281, 79.793060348805895, 90.604422874759621, 80.130345506036335, 89.401135286811041, 80.239735286759725, 88.10668954825087, 80.203272026518604, 87.505045754271123, 80.066534800614363, 86.639043323539227, 79.811291978926462, 85.672766927149496, 79.446659376515171, 84.624448195219884, 78.963521178320192, 83.484971312678681, 78.370993199401823, 82.254336279551353, 77.659959624699795, 80.932543095808796, 76.848652084334645, 79.519591761458287, 75.909723133125539, 78.015482276521652, 56.739164061351381, 47.878597687220463, 59.701803955943177, 41.461063884780742, 83.266185886773528, 78.589778625311737, 83.913408756053613, 79.619865727119759, 84.761179556659883, 80.959890540991182, 85.590718727145585, 82.208757204240101, 86.383794637390196, 83.384697347020847, 87.149523102453927, 84.469479339200916, 87.887904122336778, 85.481334810890985, 88.589821881978537, 86.402032131980377, 89.273508011499743, 87.249802932579769, 89.9207308807798, 88.006415582578484, 90.54972211993929, 88.680985897048231, 90.914354722350595, 89.063850129579805, 91.862399488619985, 89.966315820551245, 92.846907515130496, 90.804970806089841, 93.867878801882128, 91.570699271149351, 94.916197533814625, 92.263501215729775, 95.991863710927959, 92.892492454899184, 97.103993148282441, 93.439441358510521, 97.915300688647591, 93.804073960931419, 99.337367838051662, 94.369254494660709, 100.5862345013103, 94.779466172378307, 101.671016493484, 95.016477363940794, 102.5825979995122, 95.09851969949159, 104.4513400868701, 95.09851969949159, 104.4513400868701, 97.769453512151813],
       [43.19306288177151, 97.769453512151813, 1.3879350153158041, 97.769453512151813, 1.3879350153158041, 95.09851969949159, 1.971347179173875, 95.089403884430794, 3.3934143285779612, 94.980014103701251, 4.5967019165352383, 94.743002912131487, 5.572094127985479, 94.378370309721504, 6.3925174834108978, 93.986390262129134, 7.860163708116402, 93.238893427180301, 9.1546094466765169, 92.536975667539082, 10.275854699091269, 91.862405353091162, 11.23301528042094, 91.224298298868234, 12.01697537560522, 90.622654504888487, 12.63685079970443, 90.057473971148283, 12.89209362139235, 89.756652074160229, 13.37523181958732, 89.173239910298435, 13.93129653826457, 88.443974705478468, 14.578519407544629, 87.577972274750209, 15.307784612367239, 86.557000987999345, 16.119092152732382, 85.399292475340189, 17.012442028640059, 84.086615106658428, 17.987834240090301, 82.637200512079289, 19.045268787083071, 81.041932876531064, 45.854880879374008, 40.093691625741485, 45.854880879374008, 16.948637187681015, 45.854880879374008, 16.009708236470033, 45.809301804072589, 14.241240114781249, 45.718143653469781, 12.63685666416859, 45.590522242625809, 11.187442069578537, 45.417321756480447, 9.9112279611399572, 45.198542195033667, 8.7899827087312588, 44.934183558285469, 7.8419379424594808, 44.62424584623588, 7.0488620322212228, 44.277844873945128, 6.4198707930590899, 44.223149983583419, 6.3560600876407989, 43.521232223941688, 5.4900576569089026, 42.700808868516248, 4.7425608219709829, 41.770995732367417, 4.1135695828015741, 40.731792815495218, 3.5939681243689847, 39.583200117899622, 3.192872261719458, 38.32521763958065, 2.9011661797885608, 36.957845380538259, 2.7279656936407264, 35.481083340772472, 2.6732708032795927, 32.01707361786513, 2.6732708032795927, 32.01707361786513, 0.0023369906193693168, 73.539611217452077, 0.0023369906193693168, 73.539611217452077, 2.6732708032795927, 70.367307576473763, 2.6732708032795927, 69.483073515626344, 2.6915024334011832, 68.042774736101705, 2.8008922141198127, 66.711865737300457, 3.0287875906287809, 65.490346519222584, 3.347841117738426, 64.378217081868144, 3.7762844255812524, 63.384593240297328, 4.3141175141317945, 62.491243364389639, 4.9522245683510846, 61.716399084265618, 5.6997214032890042, 61.625240933662809, 5.8091111840185476, 61.215029255950093, 6.4107549779982946, 60.859512468599057, 7.1673676280006475, 60.549574756549482, 8.0880649490900396, 60.29433193486156, 9.1637311261983996, 60.07555237341478, 10.403481974401075, 59.911467702329666, 11.798201678629994, 59.792962106546007, 13.3570060539314, 59.720035586063737, 15.07077928525905, 59.701803955943177, 16.948637187681015, 59.701803955943177, 41.461063884780742, 56.739164061351381, 47.878597687220463, 36.347085771499337, 79.382854535560909, 36.091842949811429, 79.774834583149641, 35.125566553421471, 81.324523143401166, 34.277795752815187, 82.755706107858714, 33.566762178113152, 84.068383476540475, 32.98335001425508, 85.253439434378379, 32.527559261240953, 86.310873981368786, 32.208505734131052, 87.249802932579769, 32.01707361786513, 88.061110472939617, 31.95326291244314, 88.753912417530955, 32.026189432925413, 89.774883704278182, 32.354358775095562, 90.914360586808471, 32.928655123893378, 91.917100243448658, 33.758194294379081, 92.783102674169641, 34.833860471492422, 93.512367879000521, 34.943250252215819, 93.576178584418813, 36.073611319690848, 94.123127488041064, 37.249551462467309, 94.551570795869338, 38.46195486548487, 94.852392692861031, 39.729053158864161, 95.034708994058747, 41.032614712484559, 95.09851969949159, 43.19306288177151, 95.09851969949159, 43.19306288177151, 97.769453512151813],
     ],

 90: [ [83.694629194606833, 26.320559373580181, 83.266185886773528, 24.971418744658877, 82.737468613277144, 23.403498554289399, 82.199635524720506, 21.917620699470717, 81.652686621103555, 20.504669365131122, 81.096621902426307, 19.173760366320494, 80.531441368688775, 17.906662072939071, 79.948029204830704, 16.721606115108443, 79.364617040972604, 15.618592492810421, 78.76297324699398, 14.579389575941605, 78.161329453015327, 13.622228994609031, 77.541454028916121, 12.737994933759182, 76.912462789756617, 11.926687393399334, 76.283471550597127, 11.197422188579367, 75.63624868131707, 10.541083504238486, 74.979909996976716, 9.9576713403803296, 74.150370826491013, 9.3286801012181968, 73.229673505402474, 8.7361521222992451, 72.254281293952246, 8.2074348487985844, 71.215078377080033, 7.7242966506091761, 70.121180569846132, 7.3049691578416969, 68.963472057190245, 6.9312207403600041, 67.75106865417267, 6.6212830283111543, 66.474854545733109, 6.3660402066198003, 65.134829731871577, 6.1746080903612892, 63.740110027648342, 6.0287550493994786, 62.290695433063433, 5.9467127138486831, 60.777470133056532, 5.9193652686699352, 20.704347128054479, 5.9193652686699352, 1.898420658691605, 2.6741351072087127, 1.898420658691605, 0.0032012945484893862, 81.461254504837612, 0.0032012945484893862, 86.073856925340564, 25.892116065748269, 83.694629194606833, 26.320559373580181],
       [84.925264227744975, 97.770317816080933, 12.63685079970443, 97.770317816080933, 10.613139856321711, 73.330817639460292, 13.35700018946676, 73.330817639460292, 13.61224301115467, 74.780232234050345, 13.93129653826457, 76.421078944898909, 14.25946588043473, 77.943420059971686, 14.587635222604909, 79.347255579250486, 14.924920379835349, 80.632585502749862, 15.28043716718639, 81.808525645530608, 15.635953954537399, 82.875076007570897, 15.991470741888399, 83.823120773849951, 16.365219159360009, 84.65265994433139, 16.73896757683158, 85.36369351904068, 17.285916480448549, 86.23881176481882, 18.042529130451982, 87.214203976269346, 18.899415746118532, 88.10755385217999, 19.856576327448209, 88.909745577489957, 20.914010874440979, 89.629894967249129, 22.071719387096859, 90.268002021468419, 22.89214274252231, 90.61440299376045, 23.82195587867113, 90.9243407058093, 24.861158795543329, 91.188699342561449, 26.000635678078648, 91.416594719059503, 27.249502341337351, 91.598911020271771, 28.607758785319451, 91.744764061229944, 30.075405010024951, 91.845038026898692, 31.643325200393551, 91.908848732320621, 33.32063517148552, 91.927080362438574, 64.59699664331491, 91.927080362438574, 84.925264227744975, 97.770317816080933],
       [84.925264227744975, 97.770317816080933, 64.59699664331491, 91.927080362438574, 1.898420658691605, 2.6741351072087127, 20.704347128054479, 5.9193652686699352, 84.925264227744975, 97.770317816080933],
     ],

 91: [ [43.839918839897138, 99.998185399421345, 12.12807026175093, 99.998185399421345, 12.12807026175093, -29.268641502239916, 43.839918839897138, -29.268641502239916, 43.839918839897138, -23.642500640358776, 22.93870952877867, -23.642500640358776, 22.93870952877867, 94.304838076728629, 43.839918839897138, 94.304838076728629, 43.839918839897138, 99.998185399421345],
     ],

 92: [ [6.0005374358187558, 102.5214451296888, 41.31520497935329, -2.0096061665717571, 35.554009861254741, -2.0096061665717571, 0.23934231772020101, 102.5214451296888, 6.0005374358187558, 102.5214451296888, 6.0005374358187558, 102.5214451296888],
     ],

 93: [ [37.137647343876701, 100.00902280429, 5.4298601782493696, 100.00902280429, 5.4298601782493696, 94.308117234770179, 26.329447197345299, 94.308117234770179, 26.329447197345299, -23.641266954989987, 5.4298601782493696, -23.641266954989987, 5.4298601782493696, -29.330972317100532, 37.137647343876701, -29.330972317100532, 37.137647343876701, 100.00902280429],
     ],

 94: [ [73.895128004803098, 168.13875148216175, -2.4315914949425799, 168.13875148216175, -2.4315914949425799, 174.19165268218057, 73.895128004803098, 174.19165268218057, 73.895128004803098, 168.13875148216175, 73.895128004803098, 168.13875148216175],
       [31.728502751023289, 14.129608668681612, 31.716879355428318, 14.129608668681612, 30.124474158917561, 13.990127921540989, 28.659926313951441, 13.548438888930832, 27.323235820530019, 12.839411757631751, 26.114402678653221, 11.828176340870414, 25.974921931513592, 11.68869559372979, 24.998556701536192, 10.45661566067065, 24.289529570243079, 9.1083017716482573, 23.871087328824188, 7.6437539266808017, 23.731606581684559, 6.0629721257682831, 23.731606581684559, 5.9932317521997902, 23.894334120014118, 4.4240733468795952, 24.336023152622939, 2.9711488975117391, 25.079920470700991, 1.6460817996812693, 26.114402678653221, 0.43724865779950051, 26.16089626103312, 0.39075507541929255, 27.369729402909879, -0.63210373693073052, 28.694796500736381, -1.3643776594217343, 30.159344345702468, -1.7944432964286534, 31.728502751023289, -1.9455474391688767, 31.856360102567951, -1.9455474391688767, 33.413895112293801, -1.7711965052403684, 34.866819561664961, -1.3295074726302119, 36.203510055086383, -0.58561015455052257, 37.423966592558152, 0.43724865779950051, 37.470460174938012, 0.48374224017970846, 38.493318987295311, 1.6925753820614773, 39.225592909778364, 3.0292658754806325, 39.65565854679221, 4.4821903248484887, 39.806762689526813, 6.0629721257682831, 39.806762689526813, 6.2140762685012305, 39.644035151197251, 7.794858069421025, 39.20234611858843, 9.2594059143812046, 38.493318987295311, 10.607719803399959, 37.50533036172294, 11.828176340870414, 37.389096405773238, 11.932786901230429, 36.157016472706523, 12.897528735611559, 34.808702583690092, 13.583309075711441, 33.332531343129027, 14.001751317129674, 31.728502751023289, 14.129608668681612],
       [17.106271092552191, 96.272145338320115, 15.897437950675389, 95.505001229048503, 14.74672178677346, 94.644869955020113, 13.64249920525139, 93.726621703030105, 12.805614722413621, 92.936230802570208, 11.631651767321751, 91.727397660688439, 10.58554616377452, 90.4836943320297, 9.6672979117719535, 89.193497420979838, 8.8652836157191075, 87.880053718748968, 8.1911266712108954, 86.531739829741127, 7.633203682652379, 85.16017914953045, 7.2031380456385241, 83.742124886950478, 6.9009297601693333, 82.300823833171307, 6.714955430649808, 80.824652592611528, 6.6568384526749753, 79.313611165260227, 6.6917086394598746, 78.104778023389372, 6.8660595733844039, 76.384515475328953, 7.2031380456385241, 74.826980465608358, 7.7029440562221794, 73.40892620302111, 8.3654776051354247, 72.141976083170448, 9.1791152967832659, 71.014506710449496, 9.3999598130876905, 70.747168611771485, 10.62041635055942, 69.538335469889716, 11.898989866006019, 68.678204195868602, 13.24730375502244, 68.166774789689953, 14.653734622013699, 67.992423855761444, 16.095035675789859, 68.178398185278638, 17.47821975159118, 68.771191360629018, 18.687052893467978, 69.794050172979041, 18.745169871442808, 69.852167150958849, 19.628547936660478, 71.084247084021627, 20.163224134029068, 72.513924742208474, 20.349198463548561, 74.117953334309277, 20.349198463548561, 74.129576729908877, 20.209717716408932, 75.257046102618915, 19.802898870585011, 76.616983387229993, 19.128741926076799, 78.209388583738473, 18.187246882884288, 80.034261692151631, 17.80367482825034, 80.743288823439798, 17.024907323387389, 82.393810997931723, 16.466984334828879, 83.91647582087171, 16.129905862574791, 85.322906687859358, 16.025295302220059, 86.589856807720935, 16.153152653764721, 87.868430323160283, 16.571594895183608, 89.216744212179037, 17.292245422071691, 90.518564518810308, 18.315104234428961, 91.785514638668246, 19.628547936660478, 93.005971176138701, 20.418938837118361, 93.598764351481805, 21.639395374590119, 94.319414878369571, 22.97608586801158, 94.912208053709037, 24.429010317382708, 95.377143877511116, 25.998168722703522, 95.702598954168934, 27.69518447956904, 95.900196679278451, 29.496810796789219, 95.958313657258259, 17.106271092552191, 96.272145338320115],
       [32.600257420645988, 100.00325532431089, 32.449153277911392, 100.00325532431089, 30.659150356286151, 99.956761741930677, 28.91564101704077, 99.840527785978338, 27.24187205136522, 99.654553456461144, 25.61459666806957, 99.387215357768582, 24.057061658343692, 99.050136885518441, 22.546020230997719, 98.643318039699807, 21.10471917722154, 98.166758820301766, 19.709911705825249, 97.60883583173927, 18.38484460799879, 96.981172469619196, 17.106271092552191, 96.272145338320115, 29.496810796789219, 95.958313657258259, 30.670773751881111, 95.923443470470374, 32.216685366012001, 95.749092536549142, 33.704480002168062, 95.435260855490924, 35.145781055944212, 94.970325031688844, 36.51734173615057, 94.377531856338464, 37.842408833977032, 93.633634538258775, 39.109358953828661, 92.750256473049376, 40.318192095705449, 91.727397660688439, 41.468908259607382, 90.553434705598193, 41.503778446392289, 90.506941123221623, 42.422026698394852, 89.39109514610027, 43.235664390042693, 88.193885399821738, 43.944691521335812, 86.926935279971076, 44.572354883464122, 85.590244786548283, 45.095407685237738, 84.172190523961035, 45.525473322251592, 82.684395887801656, 45.86255179450572, 81.126860878081061, 46.106643102000049, 79.487962099188735, 46.246123849139678, 77.779322946731554, 46.292617431519567, 75.989320025099005, 46.2809940359246, 75.024578190721513, 46.188006871164838, 73.443796389801719, 46.013655937240323, 71.874637984481524, 45.757941234150991, 70.305479579161329, 45.420862761896871, 68.747944569440733, 44.990797124883017, 67.202032955308823, 44.793199399768547, 66.53949940638995, 44.3980039495396, 65.400406638091226, 43.921444730145879, 64.168326705021173, 43.363521741587363, 62.831636211598379, 42.73585837945901, 61.401958553418808, 42.015207852570938, 59.867670334879222, 41.213193556518057, 58.228771555990534, 40.329815491300423, 56.485262216738192, 39.376697052512952, 54.648765712739987, 39.051241975853827, 54.044349141800922, 38.12137032825629, 52.231099428991001, 37.249615658633623, 50.499213485338259, 36.447601362580741, 48.825444519661687, 35.692080648907762, 47.244662718738255, 34.994676913209616, 45.721997895798268, 34.367013551081271, 44.269073446430411, 33.797467166927788, 42.897512766219734, 33.274414365154172, 41.607315855180786, 32.821101936950377, 40.375235922121647, 32.425906486721431, 39.224519758208771, 32.088828014467339, 38.143543967878941, 31.879606893757881, 37.399646649810165, 31.530905025908819, 36.074579551979696, 31.217073344844671, 34.691395476180332, 30.926488454970439, 33.238471026808838, 30.670773751881111, 31.704182808269252, 30.438305839981719, 30.111777611760772, 30.22908471927229, 28.461255437268846, 30.054733785347739, 26.729369493619743, 29.90362964261314, 24.939366572001745, 29.787395686663469, 23.079623276800703, 32.739738167785617, 23.079623276800703, 32.855972123735292, 24.660405077720498, 33.030323057659842, 26.496901581718703, 33.262790969559212, 28.228787525371445, 33.530129068243497, 29.879309699859732, 33.85558414490265, 31.436844709591242, 34.227532803941642, 32.889769158959098, 34.64597504536053, 34.261329839169775, 35.110910869159312, 35.528279959009524, 35.62234027533794, 36.70224291409977, 35.715327440097703, 36.876593848028278, 36.122146285921623, 37.678608144080499, 36.633575692100273, 38.550362813708489, 37.237992263038649, 39.515104648089618, 37.935395998736801, 40.549586856039241, 38.725786899194681, 41.665432833160594, 39.609164964412336, 42.85101918385044, 40.58553019438974, 44.129592699289788, 41.654882589126878, 45.477906588308542, 42.805598753028839, 46.907584246491751, 44.060925477285501, 48.418625673828501, 45.409239366301897, 50.011030870340619, 46.850540420078083, 51.684799836020829, 48.38482863861401, 53.428309175269533, 49.628531967275713, 54.881233624641027, 50.814118317962539, 56.322534678420197, 51.929964295079571, 57.728965545411484, 52.952823107436842, 59.100526225611247, 53.882694755034379, 60.425593323441717, 54.742826029062087, 61.715790234480664, 55.509970138330061, 62.959493563139404, 56.19575047843324, 64.168326705021173, 56.80016704937163, 65.342289660111419, 57.323219851145232, 66.481382428421057, 57.323219851145232, 66.493005824009742, 57.93925981767859, 68.073787624929537, 58.450689223857239, 69.642946030249732, 58.880754860871093, 71.188857644381642, 59.206209937530218, 72.734769258509914, 59.43867784942961, 74.2690574770495, 59.578158596569239, 75.780098904389888, 59.624652178949098, 77.29114033174119, 59.589781992164212, 78.488350078019721, 59.46192464061955, 80.034261692151631, 59.206209937530218, 81.545303119499295, 58.85750806968116, 83.033097755651397, 58.39257224588237, 84.497645600618853, 57.823025861728887, 85.927323258798424, 57.137245521625708, 87.322130730201025, 56.346854621167843, 88.693691410400788, 55.440229764760232, 90.030381903830857, 54.440617743592902, 91.343825606061728, 53.766460799084683, 92.145839902110311, 52.79009556910728, 93.157075318871648, 51.767236756750009, 94.098570362060855, 50.67463757082291, 94.970325031688844, 49.51229801132601, 95.772339327741065, 48.291841473854248, 96.504613250221155, 47.013267958407653, 97.167146799140028, 45.664954069391229, 97.759939974479494, 44.246899806804997, 98.294616171850066, 42.770728566243918, 98.747928600048908, 41.236440347707997, 99.131500654679257, 39.632411755602277, 99.44533233574839, 37.970266185521702, 99.689423643241753, 36.250003637466278, 99.863774577170261, 34.448377320246067, 99.968385137530277, 32.600257420645988, 100.00325532431089],
     ],

 95: 63,

 96: [ [8.5256182075170273, 100.2186011351987, 24.59680015879513, 100.2186011351987, 32.23585317931191, 75.350657650738867, 29.710772407613629, 75.350657650738867, 8.5256182075170273, 100.2186011351987, 8.5256182075170273, 100.2186011351987],
     ],

 97: [ [35.672515457038429, 9.7268283950288605, 34.523922759442833, 9.0887213408095704, 33.411793322088357, 8.5326566221301618, 32.345242960035279, 8.0586342389906349, 31.324271673283651, 7.6757700064590608, 30.339763646773122, 7.3840639245390776, 29.39171888050376, 7.1652843630909047, 28.489253189535791, 7.0376629522397707, 27.62325075880895, 7.0011996920111415, 7.604920886428487, 6.1716605215187883, 8.2430279406482612, 5.1689208648895146, 8.954061515350304, 4.2208760986213747, 9.7471374255948717, 3.3184104076499352, 9.8109481310168576, 3.2545997022316442, 10.71341382198483, 2.3794814564389526, 11.66145858825422, 1.5955213612505759, 12.655082429825001, 0.90271941668106592, 13.70340116175751, 0.30107562270131893, 14.797298968991409, -0.20941002068138914, 15.936775851526731, -0.62873751344886841, 17.130947624423719, -0.94779104055851349, 18.370698472622159, -1.184802232128277, 19.656028396122, -1.3215394580292923, 20.996053209983529, -1.3671185333296307, 21.934982161192639, -1.3488869032116781, 23.211196269632179, -1.248612937550206, 24.46917874795119, -1.0662966363488522, 25.708929596149609, -0.81105381466113613, 26.921332999167191, -0.47376865742990049, 28.115504772064192, -0.063556979708664585, 29.282329099780348, 0.43781284859869629, 29.39171888050376, 0.48339192389903474, 29.883972893759001, 0.75686637570834137, 30.485616687737661, 1.1123831630611676, 31.18753444737942, 1.5499422859611514, 31.989726172684271, 2.0786595594508981, 32.892191863652251, 2.6985349835485977, 33.894931520283343, 3.4095685582506121, 34.997945142577521, 4.2117602835605794, 36.201232730534798, 5.0959943444104283, 37.513910099215479, 6.0713865558500402, 38.917745618498998, 7.1288211028513615, 40.430970918505892, 8.2774138004388078, 42.035354369115623, 9.5171646486414829, 35.672515457038429, 9.7268283950288605],
       [65.244219512594967, 13.555470720348239, 65.043671581268754, 13.354922789021657, 63.730994212588058, 12.060477050461486, 62.564169884871923, 10.948347613109945, 61.55231441318054, 10.018534476959758, 60.695427797513979, 9.2619218269610428, 59.975278407751659, 8.6876254781600437, 59.410097874014163, 8.2956454305713123, 58.671716854131262, 7.9765919034507533, 57.395502745691722, 7.7942756022493995, 63.202276939091689, 6.9465048016390938, 64.223248225843321, 8.1862556498417689, 65.244219512594967, 9.5171646486414829, 65.244219512594967, 13.555470720348239],
       [30.731743694365289, 39.417038046369271, 29.464645400986001, 38.888320772879524, 28.234010367847869, 38.368719314439659, 27.058070225071418, 37.858233671060589, 25.918593342536099, 37.356863842738676, 24.833811350362481, 36.864609829488472, 23.785492618429998, 36.381471631291788, 22.791868776859189, 35.907449248159537, 21.834708195529512, 35.442542680091719, 20.93224250456154, 34.986751927070145, 20.06624007383471, 34.530961174059485, 19.245816718409291, 34.093402051170415, 18.480088253345539, 33.664958743331226, 17.75082304852296, 33.236515435499314, 17.74170723346268, 33.236515435499314, 16.447261494902531, 32.443439525250142, 15.216626461764401, 31.641247799951088, 14.058917949108521, 30.829940259580326, 12.98325177199518, 30.018632719220477, 11.971396300303811, 29.189093548731762, 11.03246734909473, 28.350438563178614, 10.17558073342815, 27.502667762579222, 9.3825048231835808, 26.645781146911759, 8.6623554334212542, 25.770662901119067, 8.0151325641411972, 24.895544655340927, 7.4408362153434089, 24.011310594491079, 6.9121189418470124, 23.063265828219301, 6.410749113531466, 21.960252205928555, 6.0096532508790403, 20.811659508330195, 5.6905997237691386, 19.599256105309905, 5.4627043472620747, 18.341273626989278, 5.3259671213578477, 17.019480443250359, 5.2803880460564301, 15.652108184211102, 5.2986196761769966, 14.60378945228149, 5.3988936418401181, 13.24553300829939, 5.572094127985479, 11.932855639621266, 5.827336949673394, 10.683988976361434, 6.155506291843551, 9.4715855733411445, 6.5566021544960051, 8.3229928757500602, 7.0397403526909548, 7.2199792534484004, 7.604920886428487, 6.1716605215187883, 27.62325075880895, 7.0011996920111415, 26.930448814227478, 7.0194313221218181, 25.74539285639074, 7.1926318082696525, 24.605915973855421, 7.5299169655008882, 23.51201816662152, 8.0221709787583677, 22.46369943468903, 8.6693938480384531, 21.45184396299766, 9.4898172034590971, 20.485567566607699, 10.456093599848828, 20.120934964196412, 10.875421092619945, 19.400785574434082, 11.850813304081385, 18.780910150334869, 12.890016220939287, 18.279540322019329, 13.983914028180152, 17.88756027442718, 15.150738355900103, 17.614085822618701, 16.381373389038345, 17.45000115153362, 17.675819127598515, 17.386190446111641, 19.034075571580615, 17.404422076232208, 19.553677030009567, 17.504696041895329, 20.811659508330195, 17.732591418402389, 22.033178726411279, 18.07899239069312, 23.227350499309978, 18.553014773827812, 24.385059011958219, 19.136426937685879, 25.515420079438627, 19.838344697327638, 26.609317886668578, 20.038892628653851, 26.873676523420727, 20.704347128054479, 27.703215693898528, 21.460959778057941, 28.514523234269291, 22.317846393724491, 29.325830774629139, 23.256775344933601, 30.128022499939107, 24.305094076866091, 30.911982595131121, 25.43545514434112, 31.695942690308584, 26.66609017747928, 32.47078697042889, 27.987883361220241, 33.236515435499314, 28.553063894957749, 33.546453147551802, 29.23675002447894, 33.90196993490099, 30.029825934723529, 34.293949982489721, 30.941407440751789, 34.713277475260838, 31.94414709738286, 35.169068228278775, 33.065392349797612, 35.661322241528978, 34.296027382935762, 36.199155330090434, 35.626936381737011, 36.755220048769843, 37.067235161261642, 37.356863842738676, 38.616923721509671, 37.994970896961604, 40.276002062481091, 38.660425396359642, 42.035354369115623, 39.371458971068932, 30.731743694365289, 39.417038046369271],
       [48.443772356494257, 63.692453551899234, 29.783698928095902, 63.5921795862414, 30.075405010024951, 63.5921795862414, 31.479240529308441, 63.510137250701518, 32.791917897989123, 63.327820949489251, 34.022552931127279, 63.036114867558354, 35.180261443783174, 62.62590318985167, 36.246811805836217, 62.115417546468962, 37.222204017286458, 61.486426307310467, 38.12466970825443, 60.7571611024905, 38.935977248619572, 59.918506116940989, 39.072714474523792, 59.754421445861226, 39.592315932959913, 59.025156241041259, 40.05722250103431, 58.195617070548906, 40.467434178747027, 57.274919749459514, 40.841182596218623, 56.253948462708649, 41.160236123328502, 55.132703210299951, 41.424594760076701, 53.920299807279662, 41.643374321523481, 52.598506623540743, 41.816574807668843, 51.185555289190233, 41.944196218512808, 49.681445804249961, 42.017122738995049, 48.067946538580145, 42.035354369115623, 46.363289122298738, 42.035354369115623, 43.765281830121239, 40.904993301640587, 43.355070152410917, 39.318841481151431, 42.762542173488328, 37.769152920903402, 42.179130009630171, 36.274159251017068, 41.613949475889967, 34.824744656432131, 41.048768942160677, 33.411793322088357, 40.492704223481269, 32.053536878106257, 39.945755319869932, 30.731743694365289, 39.417038046369271, 42.035354369115623, 39.371458971068932, 42.035354369115623, 14.202693589628325, 42.026238554055332, 14.202693589628325, 40.677097925133523, 13.13614322758076, 39.364420556452842, 12.151635201058525, 38.088206448013288, 11.258285325158795, 36.857571414875139, 10.44697778479167, 35.672515457038429, 9.7268283950288605, 42.035354369115623, 9.5171646486414829, 42.099165074537609, 7.9127811980288243, 42.245018115502113, 6.4360191582709376, 42.472913492009177, 5.0959943444104283, 42.782851204058801, 3.9018225715117296, 43.174831251650943, 2.8443880245213222, 43.648853634785631, 1.9328065184890875, 44.204918353462887, 1.157962238361506, 44.286960689005411, 1.0576882727000338, 45.171194749852809, 0.20991747208972811, 46.173934406483909, -0.44642121225115261, 47.276948028778087, -0.92044359537976561, 48.498467246855938, -1.2030338622498675, 49.820260430596903, -1.2941920128505444, 50.513062375178379, -1.2668445676717965, 51.451991326387478, -1.1665706020103244, 52.400036092656883, -0.96602267068010406, 53.35719667398655, -0.68343240382091608, 54.314357255316203, -0.31879980140001862, 55.280633651706147, 0.14610676667143707, 56.246910048096112, 0.68393985522925504, 57.222302259546318, 1.3220469094485452, 58.20681028605685, 2.0421962992113549, 59.191318312567383, 2.8443880245213222, 60.184942154138163, 3.7377379004210525, 61.187681810769249, 4.7222459269287356, 62.199537282460597, 5.7887962889799383, 63.202276939091689, 6.9465048016390938, 57.395502745691722, 7.7942756022493995, 56.593311020386842, 7.903665382971667, 55.517644843273501, 8.5144249920085713, 55.171243870982771, 8.8790575944294687, 54.651642412546657, 9.9182605112910096, 54.29612562519565, 11.39502255105981, 54.28700981013538, 11.404138366120605, 54.214083289653097, 11.960203084800014, 54.150272584231118, 12.698584104680776, 54.095577693869423, 13.610165610709373, 54.040882803507742, 14.713179233000119, 54.004419543266607, 15.998509156499495, 53.967956283025472, 17.457039566150343, 53.949724652904898, 19.097886276998906, 53.931493022784338, 20.921049289048824, 53.931493022784338, 22.926528602318285, 53.931493022784338, 45.351433650608669, 53.931493022784338, 45.44259180122026, 53.91326139266377, 47.274870628330973, 53.876798132422643, 48.988643859658623, 53.812987427000671, 50.565679865088896, 53.721829276397841, 52.024210274739744, 53.603323680614182, 53.346003458478663, 53.457470639649642, 54.540175231380999, 53.293385968564557, 55.606725593428564, 53.101953852298642, 56.545654544639547, 52.883174290851862, 57.356962084999395, 52.637047284224217, 58.040648214519024, 52.290646311933472, 58.806376679589448, 51.670770887834259, 59.954969377191446, 50.97796894325279, 61.021519739239011, 50.212240478189081, 61.996911950689537, 49.364469677582797, 62.881146011539386, 48.443772356494257, 63.692453551899234],
       [31.95326291244314, 67.986002445300983, 31.889452207021179, 67.986002445300983, 30.38534272207454, 67.967770815179392, 28.935928127489628, 67.894844294689392, 27.52297679314583, 67.776338698909967, 26.16472034916373, 67.61225402781929, 24.842927165422768, 67.402590281439188, 23.566713056983222, 67.15646327480863, 22.345193838905349, 66.855641377820575, 21.160137881068611, 66.509240405528544, 20.020660998533291, 66.117260357939813, 18.926763191299379, 65.679701235039829, 17.8784444593669, 65.196563036850421, 16.884820617796091, 64.66784576334976, 15.927660036466451, 64.084433599491604, 15.01607853043819, 63.46455817540118, 14.150076099711351, 62.79910367598859, 13.174683888261111, 61.960448690449994, 12.153712601509479, 60.985056478999468, 11.24213109548122, 59.982316822370194, 10.43082355511606, 58.970461350669211, 9.738021610534588, 57.94037424886119, 9.1454936316162332, 56.901171331988735, 8.6623554334212542, 55.83462096994117, 8.2886070159496796, 54.749838977761101, 8.0151325641411972, 53.65594117053115, 7.860163708116402, 52.543811733168695, 7.8054688177546998, 51.404334850638406, 7.8237004478752681, 50.811806871719455, 7.9786693039000616, 49.471782057858945, 8.3250702761908144, 48.268494469899451, 8.835555919566616, 47.211059922909044, 9.5374736792083752, 46.290362601819652, 10.357897034633821, 45.515518321699346, 11.39709995150602, 44.904758712658804, 12.56392427922219, 44.540126110248821, 13.858370017782301, 44.412504699401325, 15.14369994128214, 44.521894480130868, 16.328755899118871, 44.859179637358466, 17.395306261171921, 45.424360171091394, 18.325119397320751, 46.217436081340566, 18.60770966418951, 46.554721238571801, 19.209353458168149, 47.511881819900736, 19.637796766001429, 48.633127072320349, 19.902155402749631, 49.909341180751653, 19.984197738292181, 51.33140833015932, 19.838344697327638, 55.515567442831525, 19.847460512387919, 55.743462819329579, 19.984197738292181, 56.928518777171121, 20.330598710582908, 58.058879844651528, 20.877547614199869, 59.143661836820684, 21.625044449143019, 60.164633123571548, 22.582205030472689, 61.140025335018436, 22.773637146738618, 61.313225821169908, 23.703450282887449, 62.006027765750332, 24.72442156963908, 62.580324114551331, 25.845666822053829, 63.017883237440401, 27.058070225071418, 63.336936764550046, 28.37986340881239, 63.528368880819471, 29.783698928095902, 63.5921795862414, 48.443772356494257, 63.692453551899234, 47.441032699863172, 64.403487126601249, 46.365366522749831, 65.032478365759744, 45.681680393228639, 65.378879338051775, 44.660709106477007, 65.834670091069711, 43.603274559484213, 66.244881768780033, 42.491145122129751, 66.609514371190016, 41.333436609473857, 66.928567898299661, 40.130149021516587, 67.211158165169763, 38.890398173318147, 67.448169356739527, 37.586836619697749, 67.648717288058833, 36.246811805836217, 67.794570329031558, 34.861207916673273, 67.903960109750187, 33.430024952208917, 67.967770815179392, 31.95326291244314, 67.986002445300983],
     ],

 98: [ [25.171096507592949, 58.242060449800192, 24.232167556383839, 57.102583567258989, 23.293238605174739, 55.908411794371204, 22.363425469025909, 54.650429316050577, 27.094533485312549, 54.149059487728664, 28.02434662146138, 54.805398172069545, 28.899464867248501, 55.361462890748953, 29.710772407613629, 55.808137828698818, 30.03894174978382, 55.9631066847287, 31.260460967861661, 56.510055588350951, 32.47286437087925, 56.956730526300817, 33.694383588957102, 57.30313149858921, 34.915902807034968, 57.558374320280564, 36.137422025112841, 57.704227361238736, 37.358941243190692, 57.749806436539075, 25.171096507592949, 58.242060449800192],
       [43.047209840807, 67.986866749241017, 42.290597190803531, 67.977750934180222, 41.233162643810772, 67.89570859864034, 40.175728096818013, 67.758971372728411, 39.127409364885501, 67.5675392564699, 38.079090632953012, 67.303180619721388, 37.049003531141068, 66.975011277550948, 36.018916429329153, 66.592147045019374, 34.997945142577521, 66.145472107058595, 33.986089670886152, 65.634986463690439, 32.974234199194797, 65.060690114889439, 31.971494542563711, 64.422583060670149, 30.97787070099292, 63.729781116089725, 29.993362674482398, 62.964052651030215, 29.01797046303216, 62.143629295598657, 28.04257825158194, 61.259395234748808, 27.076301855191989, 60.320466283541464, 26.119141273862311, 59.308610811851395, 25.171096507592949, 58.242060449800192, 37.358941243190692, 57.749806436539075, 37.513910099215479, 57.749806436539075, 38.689850241991941, 57.695111546181579, 39.847558754647821, 57.540142690158973, 40.97791982212285, 57.30313149858921, 42.090049259477318, 56.965846341361612, 43.183947066711227, 56.537403033518785, 44.25961324382456, 56.017801575089834, 45.307931975757057, 55.407041966049292, 46.338019077568987, 54.70512420641171, 47.349874549260363, 53.9120482961589, 48.33438257577086, 53.027814235319966, 49.309774787221102, 52.043306208808644, 50.257819553490492, 50.976755846750166, 50.585988895660648, 50.566544169039844, 51.224095949880422, 49.69142592325079, 51.825739743859089, 48.779844417229469, 52.381804462536309, 47.82268383588962, 52.901405920972422, 46.819944179271261, 53.37542830410711, 45.771625447330734, 53.812987427000671, 44.686843455161579, 54.20496747459282, 43.556482387681172, 54.551368446883536, 42.380542244900425, 54.861306158933161, 41.159023026830255, 55.134780610741643, 39.901040548509627, 55.362675987248707, 38.597478994888661, 55.544992288454353, 37.248338365970994, 55.690845329418863, 35.862734476799233, 55.791119295081977, 34.431551512341684, 55.85493000050397, 32.95478947258016, 55.873161630624509, 31.441564172571816, 55.873161630624509, 30.57556174183992, 55.836698370383402, 29.053220626770781, 55.754656034840849, 27.567342771948461, 55.64526625411748, 26.127043992419203, 55.499413213152927, 24.732324288201198, 55.317096911947289, 23.383183659279894, 55.098317350500508, 22.07050629060177, 54.83395871375231, 20.803407997220347, 54.54225263182326, 19.572772964078467, 54.214083289653097, 18.396832821301359, 53.849450687241813, 17.248240123710275, 53.439239009529082, 16.154342316480324, 53.001679886635507, 15.096907769479003, 52.527657503500819, 14.085052297788934, 52.017171860125011, 13.118775901399204, 51.461107141447769, 12.188962765249016, 50.877694977589691, 11.304728704410081, 50.257819553490492, 10.456957903799776, 49.410048752884187, 9.426870801991754, 48.434656541433981, 8.3603204399296374, 47.441032699863172, 7.3849282284791116, 46.447408858292377, 6.5189257977617672, 45.435553386601008, 5.753197332691343, 44.4054662847891, 5.087742833289667, 43.366263367916872, 4.5225622995494632, 42.317944635984389, 4.0667715465388028, 41.260510088991623, 3.7112547591896146, 40.184843911878261, 3.4560119374982605, 39.10006191970465, 3.3010430814683787, 38.006164112470742, 3.2463481911108829, 51.451991326387478, 3.1369584103886154, 52.518541688440543, 3.8571078001514252, 53.57597623543333, 4.6228362652182113, 54.624294967365813, 5.4432596206388553, 55.654382069177728, 6.3092620513707516, 56.666237540869098, 7.2117277423385531, 56.994406883039261, 7.5125496393193316, 57.887756758946949, 8.3785520700512279, 58.735527559553248, 9.2719019459582341, 59.555950914978659, 10.174367636929674, 60.339911010162972, 11.104180773079861, 61.078292030045837, 12.061341354408796, 61.78932560474788, 13.027617750798527, 62.463895919208802, 14.021241592370643, 63.102002973428569, 15.042212879121507, 63.694530952346952, 16.072299980929529, 64.259711486084456, 17.12973452793085, 64.788428759580839, 18.214516520100005, 65.280682772836101, 19.308414327329956, 65.727357710789946, 20.429659579749568, 66.146685203562939, 21.578252277340653, 66.529549436094811, 22.735960789999808, 66.875950408385549, 23.92101674784135, 67.185888120435152, 25.133420150850725, 67.459362572243634, 26.354939368931809, 67.696373763810968, 27.603806032191642, 67.887805880076911, 28.880020140630222, 68.051890551161989, 30.165350064129598, 68.179511962005947, 31.478027432811359, 68.270670112608769, 32.818052246668231, 68.325365002970472, 34.167192875589535, 68.343596633091039, 35.543680949700502, 68.343596633091039, 36.02681914788991, 68.316249187910174, 37.485349557529844, 68.243322667427933, 38.907416706941149, 68.143048701764812, 40.302136411159154, 68.006311475860585, 41.669508670198411, 67.823995174654925, 43.009533484069834, 67.614331428268429, 44.313095037679886, 67.368204421640797, 45.580193331068585, 67.076498339711762, 46.829059994321142, 66.757444812601875, 48.041463397341431, 66.39281221019057, 49.217403540118539, 66.000832162598428, 50.365996237709624, 65.563273039704853, 51.487241490129236, 65.098366471630456, 52.581139297359186, 64.587880828254626, 53.638573844360508, 64.040931924637675, 54.659545131111372, 63.466635575839888, 55.662284787740646, 62.846760151740646, 56.628561184130376, 62.190421467400313, 57.558374320280564, 61.506735337879121, 58.46995582630916, 60.777470133056532, 59.335958257030143, 60.421953345705496, 59.746169934751379, 59.483024394496397, 60.739793776319857, 58.516747998106467, 61.67872272753084, 57.541355786656219, 62.544725158248184, 56.538616130025162, 63.346916883561789, 55.526760658333778, 64.094413718499709, 54.487557741461579, 64.768984032958542, 53.430123194468791, 65.379743641999085, 52.354457017355458, 65.926692545621336, 51.260559210121563, 66.409830743810744, 50.139313957706797, 66.829158236578223, 49.008952890231768, 67.184675023938325, 47.851244377575881, 67.476381105858309, 46.68442004985971, 67.704276482370915, 45.49024827696271, 67.859245338400797, 44.277844873945128, 67.959519304058631, 43.047209840807, 67.986866749241017],
       [-0.69958663348890593, 94.450077869241795, 0.31226883820244211, 91.924997097539745, 0.4216586189258465, 91.970576172850997, 1.834609953269648, 92.453714371040405, 3.1290556918297621, 92.800115343328798, 4.304995834606216, 93.009779089719814, 5.3533145665386987, 93.0827056101989, -0.69958663348890593, 94.450077869241795],
       [22.363425469025909, 102.52669001265167, 19.11819530756534, 102.52669001265167, -0.69958663348890593, 94.450077869241795, 5.3533145665386987, 93.0827056101989, 5.9823058056981893, 93.046242349959357, 7.2038250237760622, 92.745420452971302, 8.2339121255879775, 92.143776658991555, 8.3615335364319492, 92.034386878269288, 9.0087564057120062, 91.223079337898525, 9.5465894942686589, 90.083602455368236, 9.9659169870416502, 88.606840415599436, 10.03884350752392, 88.169281292699452, 10.120885843066469, 87.494710978251533, 10.193812363548711, 86.66517180775918, 10.2576230689707, 85.698895411369449, 10.3123179593324, 84.577650158960751, 10.367012849694101, 83.310551865568414, 10.403476109935211, 81.897600531228818, 10.43082355511606, 80.338796155920136, 10.449055185236629, 78.634138739649643, 10.4672868153572, 76.774512467349268, 10.4672868153572, 74.769033154090721, 10.4672868153572, 6.3457253116102947, 11.32417343102375, 5.7805447778700909, 12.47276612861935, 5.0512795730501239, 13.62135882621496, 4.3493618134089047, 14.76083570875028, 3.693023129071662, 15.9003125912856, 3.0640318899095291, 17.039789473820921, 2.4806197260513727, 18.17015054129595, 1.9245550073683262, 19.291395793710699, 1.4049535489393747, 20.412641046125461, 0.9309311657998478, 21.53388629854021, 0.48425622784998268, 22.655131550954959, 0.074044550128746778, 23.083574858788239, -0.071808490829425864, 24.341557337107218, -0.48202016853974783, 25.60865563048651, -0.83753695588893606, 26.857522293745209, -1.1474746679414238, 28.115504772064192, -1.4118333046899352, 29.364371435322909, -1.6306128661417461, 30.613238098581611, -1.7946975372215093, 31.852988946780041, -1.91320313300821, 33.092739794978463, -1.9861296534909343, 34.323374828116613, -2.0134770986696822, 35.289651224506542, -1.9952454685517296, 36.520286257644699, -1.9405505781905958, 37.741805475722543, -1.8311607974610524, 38.945093063679849, -1.6761919414384465, 40.139264836576857, -1.4756440101082262, 41.32432079441358, -1.2295170034813054, 42.500260937190028, -0.92869510650052689, 43.657969449845922, -0.59140994925837731, 44.806562147441518, -0.19942990166964591, 45.946039029976838, 0.23812922121942393, 47.076400097451881, 0.72126741940883221, 48.188529534806349, 1.2591005079702882, 49.291543157100541, 1.8333968567712873, 50.376325149274152, 2.4623880959297821, 51.451991326387478, 3.1369584103886154, 38.006164112470742, 3.2463481911108829, 37.349825428130401, 3.2645798212397494, 36.100958764871713, 3.346622156779631, 34.861207916673273, 3.5289384579809848, 33.630572883535137, 3.7932970947294962, 32.409053665457272, 4.1488138820786844, 31.205766077499991, 4.5954888200285495, 30.002478489542678, 5.1242060935292102, 29.60138262689026, 5.3065223947414779, 28.534832264837181, 5.8534712983491772, 27.477397717844411, 6.4733467224505148, 26.438194800972209, 7.147917036920262, 25.398991884099988, 7.8954138718581817, 24.37802059734835, 8.7067214122216683, 23.366165125657009, 9.5818396580107219, 22.363425469025909, 10.529884424278862, 22.363425469025909, 50.037826895550097, 22.773637146738618, 50.429806943138829, 23.940461474454789, 51.523704750368779, 25.052590911809261, 52.499096961819305, 26.100909643741751, 53.374215207608358, 27.094533485312549, 54.149059487728664, 22.363425469025909, 54.650429316050577, 22.363425469025909, 102.52669001265167],
     ],

 99: [ [58.621420880225543, 26.107202202430926, 57.923468509514443, 24.55267192221072, 57.162065923284139, 22.945266462389554, 56.400663337053857, 21.454186397688318, 55.628685714903703, 20.068856692189001, 54.846133056833658, 18.789277345891605, 54.07415543468349, 17.626023394699587, 53.281027740693602, 16.568519802709488, 52.498475082623578, 15.627341605850233, 51.705347388633669, 14.791913768178347, 50.90164465872391, 14.072811325619114, 50.129667036573757, 13.427734134511411, 48.93468797762899, 12.550006153171125, 47.697408775004767, 11.778028531010932, 46.438979500540803, 11.101226232138288, 45.148825118317241, 10.530174292471202, 43.826945628334087, 10.06487271199876, 42.473341030591349, 9.7053214907209622, 41.088011325088999, 9.4409455927307135, 39.67095651182705, 9.2928950898494804, 38.222176590805518, 9.2400199102485203, 53.788629464847141, 8.8804686889707227, 54.592332194756899, 9.9696973887184868, 55.343159745067318, 11.111801268059935, 56.062262187618167, 12.29620529109161, 56.739064486489532, 13.522909457791684, 57.373566641681442, 14.80248880408908, 57.976343689113783, 16.13494332999835, 58.526245556946748, 17.509697999579657, 59.044422317020157, 18.926752812840277, 59.520298933414111, 20.396682805698219, 59.95387540612856, 21.919487978171674, 60.355726771083461, 23.484593294298975, 60.704702956439007, 25.102573790041788, 58.621420880225543, 26.107202202430926],
       [51.578446957595311, 63.638004682030441, 34.18251286941701, 63.16212806563999, 34.531489054772557, 63.16212806563999, 36.149469550511938, 63.045802670520061, 37.619399543373213, 62.781426772518898, 38.951854069276223, 62.347850299811398, 40.136258092301127, 61.755648288301018, 41.172611612447902, 61.004820737991395, 41.267786935726697, 60.920220450629131, 42.156089952995373, 59.947317146001296, 42.896342467385963, 58.826363338488591, 43.46739440705867, 57.546783992191195, 43.87982080793342, 56.108579107090918, 44.133621670010179, 54.511748683191399, 44.165346777769777, 54.152197461909964, 44.397997568006829, 52.333291283699509, 44.746973753362383, 50.821061147158616, 45.180550226076839, 49.626082088208932, 45.719877057989962, 48.74835410686137, 45.8044773453489, 48.642603747670364, 46.745655542216902, 47.690850514878548, 47.856034313802724, 46.950598000479658, 49.114463588266688, 46.432421240409894, 50.542093437448507, 46.115170162818686, 52.128348825428311, 46.009419803620403, 53.37620306397239, 46.083445055050106, 54.803832913154203, 46.390121096730581, 56.05168715169831, 46.940022964568925, 57.098615707764971, 47.733150658561499, 57.489892036799979, 48.145577059429343, 58.240719587110398, 49.287680938781705, 58.684871095744739, 50.620135464680061, 58.83292159862286, 52.132365601220954, 58.83292159862286, 52.185240780818276, 58.748321311263943, 53.41194494751835, 58.515670521026898, 54.628074078311329, 58.12439419199189, 55.833628173171746, 57.574492324158889, 57.028607232121431, 56.887114989367667, 58.213011255149468, 56.030537079858568, 59.397415278170229, 55.025908667471363, 60.560669229351333, 53.873229752206051, 61.723923180539714, 52.561925298142782, 62.876602095799171, 51.578446957595311, 63.638004682030441],
       [36.561895951386688, 67.994919481021498, 35.83221847291599, 67.98434444509985, 34.372863515974572, 67.920894229580881, 32.94523366679276, 67.793993798539304, 31.528178853530829, 67.603643151978758, 30.142849148028478, 67.349842289899243, 28.789244550285719, 67.032591212311672, 27.446214988462842, 66.651889919201494, 26.13491053439957, 66.207738410561433, 24.844756152176011, 65.700136686409678, 23.58632687771204, 65.129084746731678, 22.349047675087789, 64.494582591538347, 21.132918544303308, 63.796630220829684, 19.948514521278391, 63.035227634598414, 18.77468553417334, 62.210374832851812, 17.643156690747769, 61.311496779660956, 16.522202883242059, 60.35974354686914, 15.43297418349594, 59.344540098569269, 14.364895555589539, 58.265886434739514, 14.068794549833321, 57.948635357148305, 13.14876642480503, 56.912281837001501, 12.27103844345622, 55.854778245011403, 11.446185641706739, 54.754974509349267, 10.674208019556589, 53.623445665918553, 9.9551055770057388, 52.470766750659095, 9.2783032781343735, 51.275787691709411, 8.6543761588623198, 50.05965856092007, 8.0833242191896062, 48.801229286469606, 7.5545724231963467, 47.521649940161296, 7.0892708427222573, 46.199770450180949, 6.6662694059276504, 44.856740888350032, 6.2855681128124976, 43.481986218768725, 5.9683170352165433, 42.075506441429752, 5.6933661013000432, 40.626726520411466, 5.4607153110630264, 39.156796527549886, 5.2915147363451771, 37.655141426930641, 5.1646143053067837, 36.121761218539177, 5.0905890538677312, 34.556655902400962, 5.069438982028017, 32.959825478501443, 5.069438982028017, 32.737749724190508, 5.0905890538677312, 31.077469084768381, 5.1646143053067837, 29.459488589029206, 5.2915147363451771, 27.873233201051335, 5.4607153110630264, 26.318702920831129, 5.672216029460329, 24.806472784290236, 5.9260168915370883, 23.336542791428656, 6.232692933213186, 21.898337906328379, 6.5816691185687404, 20.491858128989406, 6.972945447603748, 19.117103459400823, 7.4065219203182124, 17.784648933498829, 7.892973572632016, 16.494494551279786, 8.4323004045451597, 15.236065276811132, 9.0033523442178733, 14.009361110111058, 9.627279463489927, 12.824957087079383, 10.29350672644143, 11.672278171809012, 11.012609168992251, 10.561899400228867, 11.77401175522256, 9.4832457364100264, 12.57771448513232, 8.4468922162595845, 13.423717358721531, 7.4316887679487991, 14.25914519639089, 6.5222356788399338, 15.348373896137, 5.4224319431705226, 16.458752667722859, 4.3966534589490038, 17.600856547068322, 3.4554752620788349, 18.75353546233363, 2.5777472807312733, 19.937939485358509, 1.7846195867386996, 21.143493580223161, 1.0655171441903803, 22.370197746927531, 0.4204399530790397, 23.628627021391502, -0.1506119865916844, 24.897631331775319, -0.6476386748290679, 26.198360749918731, -1.0600650757005496, 27.520240239901899, -1.3984662251386908, 28.863269801724801, -1.6628421231289394, 30.22744943538742, -1.8531927696894854, 31.612779140889739, -1.9695181648094149, 33.029833954151698, -2.0118183084887278, 33.452835390946298, -2.0012432725707185, 34.859315168288383, -1.9377930570517492, 36.24464487379074, -1.8003175900885253, 37.608824507453349, -1.5782418357812276, 38.96242910519608, -1.2715657941007521, 40.28430859517924, -0.89086450099057402, 41.595613049242523, -0.4255629205108562, 42.896342467385963, 0.11376391139856423, 44.165346777769777, 0.73769103068116237, 45.423776052233741, 1.4462184373114724, 46.661055254857963, 2.2287710953787609, 47.877184385642472, 3.0959240408083133, 49.07216344458724, 4.0371022376712062, 50.25656746761215, 5.0523056859783537, 51.155445520800697, 5.8983085595682496, 52.075473645828971, 6.8500617923600657, 52.953201627177791, 7.8441151688311948, 53.788629464847141, 8.8804686889707227, 38.222176590805518, 9.2400199102485203, 37.513649184174561, 9.2505949461701675, 36.096594370912598, 9.3457702694504405, 34.721839701330133, 9.5466959519217198, 33.389385175427108, 9.8427969576805481, 32.109805829123403, 10.244648322630383, 30.87252662649918, 10.741675010871404, 29.67754756755442, 11.333877022381785, 28.524868652289101, 12.031829393090447, 27.4250649166231, 12.83553212300103, 26.367561324636579, 13.734410176188248, 25.352357876329521, 14.728463552659377, 24.37945457170191, 15.828267288321513, 23.45942644667365, 17.023246347271197, 22.58169846532483, 18.32397576540825, 22.454798034286441, 18.514326411968796, 21.714545519895879, 19.719880506829213, 21.03774322102451, 20.946584673540201, 20.403241065832599, 22.205013948001579, 19.81103905432014, 23.484593294298975, 19.282287258326889, 24.785322712450579, 18.795835606013078, 26.107202202430926, 18.36225913329859, 27.460806800168939, 17.98155784018347, 28.83556146976116, 17.65373172666763, 30.242041247100133, 17.37878079275113, 31.669671096278762, 17.146130002514109, 33.118451017300686, 16.966354391876411, 34.588381010158628, 16.839453960838011, 36.090036110781512, 16.765428709398961, 37.612841283251328, 16.744278637559219, 39.156796527549886, 16.765428709398961, 40.60557644857181, 16.850028996757871, 42.212981908389338, 16.998079499635981, 43.778087224520277, 17.199005182113421, 45.290317361068446, 17.463381080110072, 46.760247353930026, 17.79120719362588, 48.177302167190646, 18.171908486741032, 49.552056836768315, 18.62663503129524, 50.873936326759576, 19.134236755448779, 52.15351567306061, 19.694713659201639, 53.380219839760684, 20.32921581439355, 54.564623862788721, 21.016593149184772, 55.696152706208522, 21.767420699495219, 56.785381405959924, 22.58169846532483, 57.832309962028376, 22.877799471081051, 58.191861183298897, 23.88242788346826, 59.228214703449339, 24.93993147545477, 60.158817864401499, 26.071460318880369, 60.951945558390435, 27.25586434190528, 61.628747857259441, 28.51429361636924, 62.178649725090509, 29.83617310635238, 62.612226197808923, 31.22150281185473, 62.918902239489398, 32.67028273287626, 63.10925288603903, 34.18251286941701, 63.16212806563999, 51.578446957595311, 63.638004682030441, 50.457493150089597, 64.388832232350978, 49.283664162984543, 65.076209567141632, 48.067535032200027, 65.689561650491669, 46.798530721816213, 66.228888482401089, 45.487226267752938, 66.694190062880807, 44.123046634090329, 67.096041427830642, 42.705991820828373, 67.423867541350774, 41.246636863886991, 67.667093367501366, 39.73440672734624, 67.846868978140265, 38.169301411206213, 67.963194373260194, 36.561895951386688, 67.994919481021498],
     ],

100: [ [73.393758176487566, 8.6537551297187747, 73.083820464437949, 8.5443653490001452, 71.64352168491331, 8.061227150799823, 70.349075946353196, 7.714826178518706, 69.200483248757592, 7.5051624321313284, 68.197743592126514, 7.4322359116486041, 51.260559210121563, 7.4322359116486041, 51.260559210121563, -2.0117484908005281, 54.578715892064388, -2.0117484908005281, 74.186834086732134, 6.1377901730884332, 73.393758176487566, 8.6537551297187747],
       [49.701754834813237, 63.886478579981485, 35.982453169088018, 63.594772498050588, 36.921382120297132, 63.558309237811045, 38.106438078133863, 63.403340381781163, 39.30972566609114, 63.120750114911061, 40.513013254048438, 62.728770067318692, 41.743648287186602, 62.209168608878826, 51.260559210121563, 62.509990505870519, 50.64068378602235, 63.093402669728675, 49.701754834813237, 63.886478579981485],
       [36.848455599814862, 68.061521877589257, 35.955105723907167, 68.052406062528462, 34.688007430527911, 67.988595357099257, 33.439140767269208, 67.879205576380627, 32.208505734131052, 67.72423672036166, 31.00521814617375, 67.514572973970644, 29.82927800339732, 67.25933015227929, 28.662453675681149, 66.94939244023044, 27.52297679314583, 66.584759837820457, 26.410847355791361, 66.174548160110135, 25.30783373349718, 65.71875740708856, 24.24128337144413, 65.208271763720404, 23.183848824451331, 64.652207045040996, 22.15376172263942, 64.041447436000453, 21.14190625094804, 63.385108751659573, 20.157398224437539, 62.674075176961196, 19.191121828047581, 61.917462526958843, 18.252192876838478, 61.106154986591719, 17.331495555749939, 60.249268370920618, 16.429029864781992, 59.337686864899297, 15.553911618994841, 58.380526283559448, 14.697025003328291, 57.368670811869379, 13.858370017782301, 56.311236264878971, 13.666937901516381, 56.055993443191255, 12.89209362139235, 54.989443081140053, 12.153712601509479, 53.904661088970897, 11.44267902680744, 52.819879096790828, 10.77722452740681, 51.716865474500082, 10.148233288247321, 50.613851852198422, 9.5465894942686589, 49.492606599789724, 8.9905247755914388, 48.36224553232023, 8.4618075020950414, 47.222768649779027, 7.9786693039000616, 46.083291767241462, 7.5228785508859337, 44.925583254589583, 7.1035510581129406, 43.758758926869632, 6.729802640641366, 42.5828187840998, 6.3834016683506141, 41.388647011201101, 6.0734639563010262, 40.194475238298764, 5.8091053195528266, 38.99118765033927, 5.572094127985479, 37.778784247329895, 5.371546196659267, 36.557265029248811, 5.2074615255741881, 35.317514181049773, 5.0798401147302172, 34.077763332850736, 4.9977977791876924, 32.819780854530109, 4.9431028888259902, 31.561798376209481, 4.924871258705422, 30.285584267781815, 4.924871258705422, 30.203541932231019, 4.9431028888259902, 28.799706412948581, 5.0069135942479468, 27.423218338848528, 5.1071875599110683, 26.074077709930862, 5.253040600875579, 24.752284526181029, 5.435356902081252, 23.448722972560063, 5.6541364635280331, 22.18162467917864, 5.9184951002762034, 20.932758015918807, 6.2284328123258197, 19.711238797848637, 6.5657179695562879, 18.517067024949938, 6.9485822020881471, 17.350242697240901, 7.377025509921423, 16.201649999638903, 7.8419320779958346, 15.089520562280086, 8.3433019063113818, 13.995622755050135, 8.8902508099283182, 12.929072392998933, 9.4736629737864178, 11.889869476119202, 10.09353839788562, 10.868898189379252, 10.75899289728625, 9.8843901628606545, 11.460910656928, 8.918113766470924, 12.20840749187116, 7.9791848152599414, 12.992367587055471, 7.0676033092386206, 13.34788437440648, 6.6756232616389752, 14.29592914067586, 5.6819994200704969, 38.580460461268558, 5.9190106116402603, 38.051743187772161, 5.9281264267010556, 36.912266305236841, 6.0101687622409372, 35.781905237761812, 6.1742534333316144, 34.669775800407344, 6.4294962550193304, 33.575877993173428, 6.7758972273113613, 32.500211816060101, 7.2043405351396359, 31.442777269067339, 7.714826178518706, 30.394458537134831, 8.3073541574412957, 29.364371435322909, 8.9910402869609243, 28.352515963631529, 9.7658845670812298, 27.349776307000472, 10.622771182748693, 26.37438409555023, 11.561700133948762, 25.408107699160269, 12.591787235771335, 24.450947117830619, 13.703916673119238, 23.940461474454789, 14.360255357460119, 23.3114702352953, 15.226257788188377, 22.70982644131664, 16.137839294220612, 22.15376172263942, 17.085884060488752, 21.634160264203299, 18.079507902049954, 21.15102206600832, 19.100479188811732, 20.704347128054479, 20.167029550859297, 20.28501963528149, 21.270043173160957, 19.911271217809912, 22.418635870748403, 19.564870245519181, 23.594576013529149, 19.264048348529851, 24.816095231610234, 18.990573896721369, 26.074077709930862, 18.753562705154021, 27.37763926354819, 18.562130588888088, 28.717664077401423, 18.398045917803021, 30.085036336451594, 18.270424506959039, 31.507103485848347, 18.179266356356241, 32.9565180804384, 18.124571465994531, 34.451511750321515, 18.106339835873971, 35.982968680451449, 18.115455650934251, 36.931013446719589, 18.16103472623567, 38.435122931670776, 18.243077061778191, 39.902769156371505, 18.361582657561879, 41.324836305779172, 18.51655151358668, 42.71044019494002, 18.707983629852599, 44.050465008800529, 18.93587900635967, 45.363142377489567, 19.209353458168149, 46.62112485579928, 19.51929117021777, 47.85175988894116, 19.856576327448209, 49.036815846779064, 20.239440559980089, 50.176292729309353, 20.667883867813369, 51.279306351600098, 21.123674620827501, 52.345856713658577, 21.615928634082731, 53.375943815470237, 22.15376172263942, 54.360451841981558, 22.7280580714372, 55.299380793188902, 23.338817680476161, 56.210962299221137, 23.986040549756211, 57.076964729938481, 24.669726679277399, 57.897388085370039, 25.161980692532669, 58.453452804049448, 26.137372903982879, 59.428845015499974, 27.130996745553691, 60.303963261289027, 28.151968032305319, 61.069691726348537, 29.200286764237831, 61.744262040811009, 30.266837126290881, 62.309442574551213, 31.360734933524778, 62.77434914261903, 32.481980185939527, 63.129865929968219, 33.621457068474847, 63.385108751659573, 34.788281396191017, 63.540077607689454, 35.982453169088018, 63.594772498050588, 49.701754834813237, 63.886478579981485, 48.717246808302718, 64.615743784801452, 47.70539133661137, 65.272082469138695, 46.647956789618597, 65.85549463300049, 45.554058982384703, 66.375096091429441, 44.423697914909667, 66.82177102939022, 43.256873587193489, 67.204635261921794, 42.053585999236191, 67.514572973970644, 40.804719335977488, 67.751584165529493, 39.52850522753792, 67.924784651680966, 38.206712043796962, 68.034174432410509, 36.848455599814862, 68.061521877589257],
       [40.239538802239963, 94.451806477110949, 41.17846775344907, 91.926725705408899, 41.205815198629921, 91.935841520469694, 42.664345608275113, 92.437211348780693, 43.977022976955823, 92.792728136129881, 45.143847304671958, 93.011507697581692, 46.146586961303051, 93.084434218060778, 40.239538802239963, 94.451806477110949],
       [63.156697863790271, 102.52841862052082, 59.911467702329666, 102.52841862052082, 40.239538802239963, 94.451806477110949, 46.146586961303051, 93.084434218060778, 46.775578200462547, 93.047970957821235, 47.99709741854042, 92.747149060829543, 49.027184520352343, 92.145505266849796, 49.154805931196279, 92.036115486131166, 49.802028800476357, 91.224807945771317, 50.339861889033017, 90.085331063230115, 50.75918938180601, 88.608569023461314, 50.841231717348563, 88.134546640329063, 50.923274052891109, 87.45997632587023, 50.996200573373358, 86.630437155381514, 51.060011278795344, 85.655044943930989, 51.114706169157039, 84.533799691518652, 51.160285244458457, 83.257585583080072, 51.196748504699571, 81.844634248740476, 51.224095949880422, 80.276714058370999, 51.251443395061273, 78.562940827028797, 51.260559210121563, 76.703314554728422, 51.260559210121563, 74.697835241469875, 51.260559210121563, 62.509990505870519, 41.743648287186602, 62.209168608878826, 42.97428332032473, 61.580177369731246, 43.685316895026773, 61.124386616709671, 44.66982492153727, 60.395121411889704, 45.590522242625809, 59.583813871518942, 46.456524673352668, 58.681348180558416, 47.258716398657519, 57.687724338979024, 47.99709741854042, 56.612058161870664, 48.671667733001328, 55.445233834161627, 48.872215664327541, 55.053253786558344, 49.410048752884187, 53.932008534149645, 49.874955320958598, 52.77430002149049, 50.285166998671322, 51.580128248591791, 50.622452155901783, 50.35860903052162, 50.905042422770549, 49.109742367261788, 51.114706169157039, 47.824412443758774, 51.260559210121563, 46.511735075080651, 51.260559210121563, 12.482397455041792, 50.44013585469613, 11.634626654438762, 49.391817122763619, 10.641002812859369, 48.343498390831137, 9.7385371218988439, 47.28606384383837, 8.9363453965997905, 46.219513481785327, 8.2344276369512954, 45.143847304671958, 7.6145522128499579, 44.068181127558631, 7.0949507544100925, 42.983399135385007, 6.6756232616389752, 41.889501328151113, 6.3474539194685349, 40.795603520917197, 6.1104427278987714, 39.692589898623027, 5.9645896869405988, 38.580460461268558, 5.9190106116402603, 14.29592914067586, 5.6819994200704969, 15.262205537065819, 4.7521862839312234, 16.237597748516041, 3.8770680381385318, 17.24033740514713, 3.0657604977714072, 18.261308691898758, 2.3182636628298496, 19.291395793710699, 1.6254617182494258, 20.348830340703469, 0.99647047909093089, 21.415380702756519, 0.42217413028993178, 22.50927850999042, -0.088311513089138316, 23.612292132284612, -0.53498645103900344, 24.742653199759651, -0.92696649863137281, 25.882130082294971, -1.2642516558589705, 27.048954410011131, -1.5286102926111198, 28.224894552787589, -1.7382740389984974, 29.428182140744902, -1.8932428950211033, 30.640585543762452, -1.9844010456217802, 31.880336391960899, -2.0117484908005281, 31.989726172684271, -2.0117484908005281, 33.302403541364953, -1.9752852305609849, 34.578617649804528, -1.8658954498387175, 35.845715943183791, -1.6835791486410017, 37.085466791382203, -1.4374521420104429, 38.297870194399792, -1.1275144299615931, 39.501157782357097, -0.74465019743001903, 40.667982110073233, -0.29797525946923997, 41.825690622729127, 0.22162619895971147, 42.181207410080162, 0.39482668511118391, 43.174831251650943, 0.91442814355104929, 44.168455093221752, 1.4978403073982918, 45.171194749852809, 2.1541789917391725, 46.173934406483909, 2.8652125664484629, 47.176674063114973, 3.6491726616295637, 48.19764534986664, 4.4969434622289555, 49.209500821557981, 5.4085249682611902, 50.239587923369918, 6.383917179711716, 51.260559210121563, 7.4322359116486041, 68.197743592126514, 7.4322359116486041, 67.705489578871251, 7.4595833568309899, 66.511317805974244, 7.7695210688798397, 65.462999074041747, 8.444091383338673, 65.289798587896385, 8.5990602393612789, 64.633459903556044, 9.4468310399715847, 64.113858445119945, 10.595423737559031, 63.730994212588058, 12.044838332149084, 63.730994212588058, 12.07218577733147, 63.630720246924959, 12.610018865889288, 63.539562096322129, 13.293704995408916, 63.457519760779597, 14.132359980951151, 63.384593240297328, 15.116868007458834, 63.329898349935632, 16.256344890000037, 63.27520345957393, 17.532558998438617, 63.22962438427254, 18.963741962899803, 63.202276939091689, 20.549893783390871, 63.174929493910838, 22.272782829790231, 63.165813678850547, 24.150640732208558, 63.156697863790271, 26.174351675588696, 63.156697863790271, 102.52841862052082],
     ],

101: [ [59.118391792085099, 25.528052169578586, 58.744643374613531, 24.543544143070903, 58.161231210755432, 23.14882443884926, 57.559587416776793, 21.836147070171137, 56.930596177617304, 20.587280406911304, 56.283373308337246, 19.420456079191354, 55.608802993876331, 18.326558271961403, 54.916001049294863, 17.305586985199625, 54.20496747459282, 16.366658033999556, 53.466586454709919, 15.491539788210503, 52.7099738047065, 14.698463877961331, 51.926013709522181, 13.987430303259316, 51.123821984217329, 13.340207433979231, 50.522178190238662, 12.911764126150956, 49.473859458306173, 12.24630962674928, 48.389077466132562, 11.653781647830328, 47.26783221371781, 11.143296004451258, 46.119239516122207, 10.714852696619346, 44.925067743225178, 10.359335909270158, 43.70354852514734, 10.085861457460851, 42.436450231768049, 9.8944293411987019, 41.142004493207928, 9.7759237454083632, 39.801979679346402, 9.73946048516882, 55.116548980621083, 9.2563222869794117, 55.864045815564261, 10.313756833969819, 56.565963575205977, 11.380307196021022, 57.231418074606609, 12.465089188201091, 57.842177683645552, 13.568102810488199, 58.407358217383063, 14.680232247850654, 58.93607549087946, 15.801477500259352, 59.419213689074432, 16.950070197861351, 59.847656996907723, 18.098662895448797, 60.239637044499858, 19.265487223168748, 60.586038016790582, 20.450543181010289, 60.886859913779922, 21.644714953901712, 61.14210273546783, 22.857118356918363, 61.35176648185432, 24.078637574988534, 59.118391792085099, 25.528052169578586],
       [51.26967502518184, 63.358684669750801, 31.95326291244314, 62.939357176979684, 32.299663884733889, 62.939357176979684, 33.530298917872017, 62.848199026379007, 34.742702320889613, 62.638535279991629, 35.936874093786599, 62.310365937821189, 37.121930051623337, 61.872806814928481, 38.288754379339508, 61.307626281188277, 39.446462891995388, 60.633055966729444, 40.11191739139602, 60.168149398650712, 41.087309602846233, 59.384189303469611, 41.980659478753921, 58.52730268779851, 42.801082834179368, 57.57925792153037, 43.539463854062262, 56.567402449840301, 44.195802538402603, 55.464388827549556, 44.779214702260667, 54.288448684768809, 44.824793777562093, 54.188174719110975, 45.125615674551391, 53.367751363690331, 45.39909012635988, 52.401474967300601, 45.636101317927228, 51.289345529941784, 45.845765064313717, 50.022247236560361, 46.02808136551937, 48.609295902209851, 46.173934406483909, 47.05960734196924, 46.292440002267568, 45.354949925691471, 15.73622792020052, 45.354949925691471, 6.8574240514853102, 44.397789344369812, 6.5748337846165441, 43.14892268110998, 6.3195909629286566, 41.881824387728557, 6.1008114014818773, 40.578262834111229, 5.9184951002762034, 39.247353835311515, 5.763526244251409, 37.879981576261343, 5.6450206484677494, 36.494377687100496, 5.5629783129251962, 35.0814263527609, 5.5173992376237768, 33.632011758170847, 5.4991676075032103, 32.155249718409323, 5.4991676075032103, 31.453331958760828, 5.5356308677443451, 30.022148994299641, 5.6085573882266138, 28.618313475009927, 5.7179471689499897, 27.25094121597067, 5.8729160249748134, 25.901800587049365, 6.0552323261804579, 24.589123218371242, 6.274011887627239, 23.294677479811071, 6.5292547093151541, 22.036695001490443, 6.8209607912441754, 20.796944153291406, 7.1582459484746428, 19.593656565339188, 7.5228785508859337, 18.417716422558442, 7.9239744135383603, 17.260007909899286, 8.3706493514922045, 16.138762657490588, 8.8446717346268997, 15.044864850249724, 9.3642731930630134, 13.978314488209435, 9.9203379117402601, 12.939111571329704, 10.50375007559833, 11.927256099639635, 11.132741314757819, 10.942748073128314, 11.78907999909816, 9.9855874917993788, 12.490997758739921, 9.0557743556491914, 13.22937877862282, 8.1533086646813899, 14.00422305874682, 7.2873062339494936, 14.47824544188151, 6.7677047755205422, 15.40805857803033, 5.8196600092487643, 16.356103344299719, 4.926310133341758, 17.331495555749939, 4.0876551477995235, 18.325119397320751, 3.3036950526111468, 19.336974869012121, 2.5653140327303845, 20.367061970824039, 1.8907437182715512, 21.424496517816809, 1.2617524791094183, 22.49104687986986, 0.69657194536921452, 23.584944687103789, 0.17697048694026307, 24.697074124458261, -0.27882026608131127, 25.82743519193329, -0.68903194379163324, 26.985143704589149, -1.0354329160800262, 28.16108384736561, -1.3362548130717187, 29.355255620262628, -1.5823818196986394, 30.567659023280189, -1.7738139359717024, 31.798294056418349, -1.9105511618690798, 33.056276534737322, -1.9925934974089614, 34.323374828116613, -2.0199409425913473, 35.070871663059762, -2.0017093124697567, 36.365317401619897, -1.947014422108623, 37.632415694999167, -1.8193930112684029, 38.872166543197579, -1.6370767100597732, 40.084569946215169, -1.4000655185009236, 41.278741719112183, -1.0992436214983172, 42.436450231768049, -0.73461101908833371, 43.566811299243078, -0.31528352632085443, 44.678940736597553, 0.15873885681139654, 45.754606913710909, 0.69657194536921452, 46.802925645643391, 1.2982157393489615, 47.833012747455307, 1.9545544236898422, 48.835752404086399, 2.674703813449014, 49.802028800476357, 3.4495480935693195, 50.750073566745719, 4.2790872640616726, 51.670770887834259, 5.1815529550294741, 52.564120763741947, 6.129597721301252, 52.600584023983089, 6.1751767966015905, 53.484818084830493, 7.1870322682916594, 54.32347307037648, 8.2171193701105949, 55.116548980621083, 9.2563222869794117, 39.801979679346402, 9.73946048516882, 38.935977248619572, 9.7485763002296153, 37.714458030541721, 9.8306186357694969, 36.52940207270499, 9.9855874917993788, 35.353461929928528, 10.20436705325119, 34.195753417272641, 10.486957320121292, 33.065392349797612, 10.84247410747048, 31.95326291244314, 11.261801600241597, 30.859365105209228, 11.754055613499077, 29.792814743156189, 12.310120332171209, 28.744496011223699, 12.929995756268909, 27.714408909411759, 13.622797700849333, 26.702553437720411, 14.379410350851686, 25.708929596149609, 15.208949521340401, 24.742653199759651, 16.102299397251045, 23.794608433490279, 17.068575793640775, 22.864795297341459, 18.098662895448797, 22.39077291420676, 18.663843429189001, 21.707086784685568, 19.557193305088731, 21.050748100345231, 20.477890626189037, 20.439988491306309, 21.435051207510696, 19.856576327448209, 22.419559234018379, 19.31874323889156, 23.440530520769244, 18.81737341057601, 24.48884925270977, 18.352466842501599, 25.58274705993972, 17.933139349728599, 26.694876497298537, 17.54115930213646, 27.852585009950417, 17.194758329845708, 29.028525152731163, 16.875704802735839, 30.25004437080861, 16.602230350927361, 31.498911034068442, 16.365219159360009, 32.784240957571456, 16.1646712280338, 34.096918326249579, 16.00058655694869, 35.446058955170884, 15.88208096116503, 36.831662844331731, 15.79092281056219, 38.244614178671327, 15.7453437352608, 39.69402877326138, 15.73622792020052, 41.170790813019266, 61.35176648185432, 41.170790813019266, 61.35176648185432, 41.343991299170739, 61.324419036673483, 42.747826818460453, 61.242376701130951, 44.133430707621301, 61.114755290286979, 45.47345552148181, 60.941554804141617, 46.786132890159934, 60.713659427634553, 48.062346998598514, 60.440184975826071, 49.302097846801189, 60.121131448716191, 50.514501249821478, 59.747383031244603, 51.69044139259131, 59.328055538471602, 52.839034090189671, 58.863148970397191, 53.942047712480417, 58.343547511961077, 55.026829704660486, 57.778366978223573, 56.066032621529303, 57.167607369184651, 57.077888093219372, 56.502152869784027, 58.053280304669897, 55.791119295081977, 58.99220925588088, 55.025390830018239, 59.903790761909477, 54.223199104713387, 60.778909007691254, 54.0682302486886, 60.933877863721136, 53.165764557720621, 61.799880294438481, 52.226835606511521, 62.602072019748448, 51.26967502518184, 63.358684669750801],
       [35.982453169088018, 68.062445240859233, 35.125566553421471, 68.053329425798438, 33.822004999801067, 67.998634535430028, 32.536675076301243, 67.889244754711399, 31.269576782921948, 67.734275898688793, 30.029825934723529, 67.533727967358573, 28.817422531705951, 67.278485145670857, 27.62325075880895, 66.977663248690078, 26.45642643109278, 66.631262276390771, 25.30783373349718, 66.230166413741244, 24.17747266602214, 65.783491475791379, 23.083574858788239, 65.291237462530262, 22.007908681674909, 64.744288558918925, 20.950474134682111, 64.151760579999973, 19.920387032870192, 63.504537710719887, 18.908531561178819, 62.811735766139464, 17.924023534668319, 62.073354746251425, 16.966862953338651, 61.280278836009529, 16.027934002129541, 60.441623850460019, 15.107236681041, 59.557389789621084, 14.223002620193601, 58.618460838399187, 13.64870627139581, 57.971237969119102, 12.928556881633479, 57.105235538401757, 12.235754937052009, 56.202769847430318, 11.57941625271166, 55.272956711280131, 10.950425013552181, 54.315796129951195, 10.367012849694101, 53.331288103439874, 9.8109481310168576, 52.31031681668901, 9.2913466725807439, 51.261998084759398, 8.7990926593255097, 50.195447722708195, 8.3433019063113818, 49.092434100410173, 7.9239744135383603, 47.96207303294068, 7.5319943659462183, 46.804364520281524, 7.1855933936554939, 45.610192747390101, 6.8574240514853102, 44.397789344369812, 15.73622792020052, 45.354949925691471, 15.800038625622481, 46.020404425100423, 16.00058655694869, 47.415124129318428, 16.255829378636601, 48.755148943178938, 16.574882905746499, 50.040478866678313, 16.948631323218081, 51.261998084759398, 17.386190446111641, 52.437938227540144, 17.88756027442718, 53.559183479948842, 18.443624993104429, 54.61661802693925, 19.063500417203642, 55.628473498629319, 19.74718654672483, 56.585634079958254, 20.485567566607699, 57.478983955868898, 21.278643476852299, 58.326754756479204, 21.825592380469232, 58.846356214911793, 22.837447852160611, 59.703242830579256, 23.87665076903281, 60.459855480581609, 24.943201131085889, 61.116194164918852, 26.03709893831979, 61.681374698659056, 27.167460005794819, 62.128049636619835, 28.316052703390401, 62.483566423969023, 29.501108661227128, 62.738809245649463, 30.713512064244728, 62.893778101679345, 31.95326291244314, 62.939357176979684, 51.26967502518184, 63.358684669750801, 50.276051183611031, 64.051486614331225, 49.245964081799123, 64.689593668561429, 48.19764534986664, 65.273005832408671, 47.112863357693008, 65.810838920970127, 45.991618105278263, 66.275745489041583, 44.852141222742937, 66.695072981819976, 43.676201079966489, 67.05970558422996, 42.472913492009177, 67.360527481221652, 41.233162643810772, 67.615770302898454, 39.966064350431481, 67.807202419171517, 38.671618611871367, 67.95305546012969, 37.340709613070118, 68.035097795680485, 35.982453169088018, 68.062445240859233],
     ],

102: [ [59.984394222811943, 97.479985685000429, 40.385391843204502, 97.188279603069532, 40.54947651428958, 97.188279603069532, 41.843922252849687, 97.088005637400784, 43.074557285987837, 96.832762815720343, 44.241381613703993, 96.404319507888431, 45.353511051058462, 95.820907344030275, 45.900459954675419, 95.456274741620291, 46.720883310100838, 94.790820242211339, 47.55953829564686, 93.970396886790695, 48.434656541433981, 92.985888860279374, 49.328006417341669, 91.85552779280988, 50.257819553490492, 90.561082054238796, 50.649799601082641, 89.977669890380639, 51.588728552291741, 88.683224151831382, 52.472962613139138, 87.589326344590518, 53.302501783624848, 86.677744838558283, 54.07734606374887, 85.966711263859906, 54.797495453511182, 85.437993990359246, 55.936972336046487, 84.781655306029279, 57.112912478822949, 84.353211998190091, 58.252389361358269, 84.216474772281799, 59.05458108666312, 84.280285477711004, 60.175826339077872, 84.626686449999397, 61.26060833125149, 85.246561874100735, 62.290695433063433, 86.158143380129331, 62.910570857162639, 86.850945324709755, 63.603372801744122, 87.917495686760958, 64.022700294517094, 89.03874093918057, 64.168553335481619, 90.196449451828812, 64.168553335481619, 90.232912712068355, 64.07739518487881, 91.363273779548763, 63.813036548130611, 92.466287401839509, 63.384593240297328, 93.532837763890711, 62.792065261378973, 94.572040680770442, 62.026336796315242, 95.574780337399716, 61.087407845106121, 96.541056733789446, 59.984394222811943, 97.479985685000429],
       [46.073660440820788, 102.38429418743181, 45.809301804072589, 102.38429418743181, 44.487508620331617, 102.33871511213147, 43.19306288177151, 102.24755696153079, 41.916848773331957, 102.09258810550091, 40.658866295012949, 101.8920401741816, 39.428231261874828, 101.62768153742945, 38.224943673917522, 101.29951219525174, 37.039887716080813, 100.92576377778823, 35.873063388364642, 100.49732046994905, 34.733586505829329, 100.00506645669884, 33.61234125341457, 99.458117553080228, 32.518443446180669, 98.856473759100481, 31.442777269067339, 98.200135074759601, 30.549427393159618, 97.598491280779854, 29.501108661227128, 96.823647000659548, 28.507484819656359, 96.021455275349581, 27.559440053386961, 95.182800289810984, 26.656974362418989, 94.298566228961135, 25.809203561812719, 93.377868907871743, 24.997896021447559, 92.429824141599966, 24.25039918650441, 91.436200300031487, 23.539365611802371, 90.406113198219828, 22.88302692746203, 89.339562836168625, 22.272267318423079, 88.236549213870603, 21.716202599745859, 87.097072331340314, 21.488307223238792, 86.604818318079197, 21.059863915405518, 85.556499586149585, 20.658768052753089, 84.471717593969515, 20.28501963528149, 83.359588156621612, 19.95685029311133, 82.210995459019614, 19.656028396122, 81.025939501188986, 19.400785574434082, 79.813536098168697, 19.172890197927021, 78.564669434908865, 18.981458081661088, 77.279339511409489, 18.826489225636291, 75.966662142731366, 18.698867814792319, 74.617521513810061, 18.616825479249801, 73.241033439710009, 18.562130588888088, 71.818966290298704, 18.543898958767532, 70.369551695719565, 18.543898958767532, 66.048655357139069, 5.7179471689499897, 66.048655357139069, 5.7179471689499897, 60.852640772780433, 18.543898958767532, 60.852640772780433, 18.543898958767532, 17.452245270778803, 18.534783143707241, 16.522432134628616, 18.50743569852639, 14.808658903300966, 18.443624993104429, 13.249854527988646, 18.352466842501599, 11.864250638820522, 18.233961246717911, 10.633615605689556, 18.07899239069312, 9.5761810586882348, 17.896676089487471, 8.6737153677204333, 17.677896528040691, 7.9353343478505849, 17.614085822618701, 7.7712496767599077, 17.048905288881201, 6.668236054458248, 16.328755899118871, 5.6746122128897696, 15.426290208150901, 4.799493967100716, 14.359739846097851, 4.0428813170983631, 13.96775979850568, 3.8149859405893949, 12.828282915970391, 3.2862686670996482, 11.634111143073371, 2.903404434571712, 10.394360294874931, 2.6755090580591059, 9.0999145563148147, 2.6025825375800196, 6.1463904767832673, 2.6025825375800196, 6.1463904767832673, 0.0045752453988825437, 45.572290612505242, 0.0045752453988825437, 45.572290612505242, 2.6025825375800196, 39.592315932959913, 2.6025825375800196, 38.89951398837843, 2.6208141677016101, 37.6141840648786, 2.775783023731492, 36.410896476921302, 3.0766049207086326, 35.298767039566833, 3.5232798586694116, 34.259564122694627, 4.1249236526491586, 33.311519356425237, 4.8724204875907162, 32.45463274075869, 5.7748861785585177, 32.23585317931191, 6.0665922604894149, 31.862104761840332, 6.732046759880177, 31.52481960460986, 7.5524701153117348, 31.23311352268081, 8.5187465117014654, 30.986986516053211, 9.6399917641101638, 30.79555439978725, 10.897974242430791, 30.631469728702172, 12.320041391838458, 30.522079947978799, 13.878845767150779, 30.45826924255681, 15.592618998478429, 30.430921797375959, 17.452245270778803, 30.430921797375959, 60.852640772780433, 47.441032699863172, 60.852640772780433, 47.441032699863172, 66.048655357139069, 30.430921797375959, 66.048655357139069, 30.430921797375959, 70.807110818608635, 30.430921797375959, 70.861805708969769, 30.44003761243625, 72.858169207178435, 30.45826924255681, 74.754258739711076, 30.476500872677381, 76.550074306589522, 30.503848317858228, 78.236500092738424, 30.549427393159618, 79.822651913229492, 30.59500646846104, 81.299413952998293, 30.65881717388303, 82.685017842159141, 30.722627879305008, 83.952116135540564, 30.79555439978725, 85.12805627832131, 30.88671255039009, 86.194606640368875, 30.97787070099292, 87.160883036758605, 31.078144666656019, 88.017769652429706, 31.1966502624397, 88.774382302428421, 31.31515585822337, 89.430720986769302, 31.442777269067339, 89.98678570544871, 31.51570378954958, 90.223796897011198, 31.96237872750342, 91.545590080750117, 32.518443446180669, 92.739761853648815, 33.165666315460733, 93.788080585578427, 33.913163150403882, 94.690546276549867, 34.760933951010173, 95.465390556670172, 35.517546601013613, 95.966760384988447, 36.593212778126968, 96.504593473538989, 37.769152920903402, 96.887457706081477, 39.027135399222402, 97.115353082590445, 40.385391843204502, 97.188279603069532, 59.984394222811943, 97.479985685000429, 58.981654566180872, 98.218366704881191, 57.896872574007233, 98.938516094651277, 56.793858951713041, 99.59485477898852, 55.672613699298303, 100.1782669428394, 54.533136816762983, 100.69786840127927, 53.37542830410711, 101.14454333922913, 52.199488161330663, 101.52740757177162, 51.014432203493918, 101.83734528380955, 49.802028800476357, 102.07435647537932, 48.580509582398491, 102.24755696153079, 47.331642919139789, 102.34783092718862, 46.073660440820788, 102.38429418743181],
     ],

103: [ [17.604970007558421, 0.57979495746985776, 17.039789473820921, -0.01273302144909394, 15.553911618994841, -1.5624215817006188, 14.25035006537445, -2.9206780256790807, 13.129104812959691, -4.1057339835206221, 12.190175861750591, -5.0993578250891005, 11.433563211747151, -5.9015495503917919, 10.85926686294934, -6.5214249744894914, 10.4672868153572, -6.9589840973894752, 10.2576230689707, -7.20511110400912, 10.22115980872956, -7.2506901793094585, 9.1910727069176517, -8.5542517329413386, 8.2612595707688286, -9.7757709510115092, 7.4408362153434089, -10.915247833549074, 6.729802640641366, -11.972682380539482, 6.1190430316024438, -12.948074591990007, 5.6085573882266138, -13.832308652839856, 5.2074615255741881, -14.63450037813891, 4.8154814779820176, -15.628124219711026, 4.5146595809927126, -16.858759252849268, 4.4143856153295919, -18.089394285991148, 4.4781963207515778, -18.891586011301115, 4.7060916972586417, -19.876094037808798, 5.116303374971352, -20.85148624924841, 5.6997155388294232, -21.817762645649054, 6.4654440038931682, -22.774923226981628, 7.404372955102275, -23.722967993249767, 8.5256182075170273, -24.66189694446075, 9.8200639460771413, -25.591710080600024, 10.321433774392681, -25.910763607709669, 11.33328924608403, -26.521523216750211, 12.363376347895979, -27.09581956555121, 13.41169507982846, -27.642768469169823, 14.48736125694179, -28.153254112541617, 15.581259064175701, -28.627276495681144, 16.702504316590449, -29.073951433631009, 17.841981199125769, -29.484163111341331, 19.00880552684194, -29.867027343880181, 20.193861484678681, -30.213428316168574, 21.406264887696238, -30.523366028210148, 22.636899920834399, -30.805956295091164, 23.894882399153371, -31.052083301721723, 25.171096507592949, -31.270862863158982, 26.474658061213351, -31.453179164371249, 27.796451244954309, -31.599032205329422, 29.145591873876128, -31.70842198605169, 30.512964132918508, -31.799580136659642, 31.907683837141722, -31.845159211959981, 33.32063517148552, -31.863390842081571, 34.040784561247847, -31.854275027009862, 35.444620080531372, -31.82692758183839, 36.811992339573749, -31.763116876420099, 38.17024878355582, -31.662842910751351, 39.501157782357097, -31.535221499911131, 40.813835151037779, -31.371136828820454, 42.108280889597893, -31.179704712558305, 43.375379182977149, -30.951809336049337, 44.633361661296163, -30.687450699300825, 45.854880879374008, -30.395744617369928, 47.06728428239159, -30.076691090260283, 48.2523402402283, -29.721174302911095, 49.419164567944478, -29.329194255318725, 50.558641450479797, -28.909866762551246, 51.689002517954833, -28.454076009529672, 52.782900325188727, -27.970937811340264, 53.867682317362352, -27.451336352900398, 54.925116864355147, -26.904387449281785, 55.964319781227339, -26.320975285430904, 56.985291067978999, -25.701099861329567, 57.978914909549779, -25.053876992049481, 58.954307121000028, -24.379306677579734, 59.911467702329666, -23.668273102888634, 39.729053158864161, -23.212482349870697, 39.683474083562743, -23.212482349870697, 38.106438078133863, -23.194250719749107, 36.574981148006401, -23.148671644448768, 35.08910329318033, -23.066629308908887, 33.648804513655712, -22.957239528179343, 32.244968994372194, -22.820502302278328, 30.88671255039009, -22.647301816130494, 29.583150996769689, -22.446753884811187, 28.316052703390401, -22.218858508298581, 27.094533485312549, -21.95449987155007, 25.909477527475811, -21.662793789619172, 24.779116460000779, -21.334624447448732, 23.685218652766881, -20.979107660099544, 22.646015735894679, -20.596243427571608, 21.64327607926359, -20.176915934800491, 20.68611549793394, -19.730240996850625, 19.774533991905681, -19.247102798650303, 18.899415746118532, -18.736617155271233, 18.553014773827812, -18.517837593830336, 17.386190446111641, -17.65183516309844, 16.429029864781992, -16.749369472130638, 15.681533029838819, -15.80132470585886, 15.15281575634242, -14.807700864290382, 14.833762229232541, -13.768497947421565, 14.72437244850914, -12.683715955248772, 14.77906733887084, -11.735671188969718, 14.970499455136769, -10.577962676321476, 15.3169004274275, -9.3746750883583445, 15.809154440682761, -8.1349242401593074, 16.456377309962821, -6.8404785015991365, 16.830125727434421, -6.1750240022010985, 17.44088533647334, -5.1996317907505727, 18.115455650934251, -4.2060079491784563, 18.872068300937709, -3.1850366624312301, 19.692491656363131, -2.1458337455587753, 20.5949573473311, -1.0792833835112106, 21.570349558781349, 0.0054986086688586511, 17.604970007558421, 0.57979495746985776],
       [46.757346570341973, 22.995584190699446, 25.81831937687301, 22.712993923829345, 27.030722779890571, 22.393940396719699, 28.316052703390401, 22.093118499731645, 29.583150996769689, 21.846991493108362, 30.850249290148948, 21.637327746720985, 32.108231768467959, 21.482358890698379, 33.357098431726648, 21.363853294911678, 34.605965094985351, 21.300042589489749, 35.836600128123507, 21.272695144311001, 36.429128107041862, 21.272695144311001, 37.851195256445948, 21.31827421961134, 39.227683330548608, 21.418548185269174, 40.576823959470417, 21.555285411181103, 41.880385513090829, 21.746717527439614, 43.156599621530368, 21.983728719009378, 44.396350469728809, 22.275434800940275, 45.599638057686093, 22.61271995817151, 46.757346570341973, 22.995584190699446],
       [21.998792866614622, 64.554585050529568, 20.977821579862962, 63.925593811371073, 19.975081923231901, 63.260139311969397, 19.00880552684194, 62.53087410714943, 18.07899239069312, 61.75602982701821, 17.176526699725141, 60.926490656540409, 16.966862953338651, 60.725942725210189, 16.037049817189821, 59.777897958938411, 15.171047386462989, 58.81162156254868, 14.368855661158131, 57.817997720980202, 13.63047464127524, 56.797026434229338, 12.955904326814331, 55.757823517360521, 12.34514471777541, 54.700388970370113, 11.79819581415844, 53.606491163129249, 11.32417343102375, 52.494361725781346, 10.904845938250761, 51.364000658300938, 10.54932915089975, 50.206292145641783, 10.26673888403098, 49.021236187811155, 10.03884350752392, 47.817948599851661, 9.8747588364388434, 46.587313566709781, 9.7836006858360065, 45.329331088389154, 9.7471374255948717, 44.053116979961487, 9.7653690557154391, 43.132419658868457, 9.8474113912579924, 41.847089735369082, 10.00238024728278, 40.570875626930501, 10.22115980872956, 39.331124778731464, 10.51286589065862, 38.10960556065038, 10.86838267800962, 36.915433787751681, 11.296825985842901, 35.739493644978211, 11.79819581415844, 34.590900947379851, 12.363376347895979, 33.469655694971152, 12.992367587055471, 32.375757887730288, 13.65782208645609, 31.345670785918628, 14.39620310633898, 30.35204694435015, 15.180163201523269, 29.394886363021214, 16.027934002129541, 28.492420672049775, 16.93039969309751, 27.644649871450383, 17.88756027442718, 26.833342331079621, 18.908531561178819, 26.076729681080906, 19.975081923231901, 25.365696106371615, 21.10544299070693, 24.700241606980853, 36.702602558850351, 24.809631387699483, 35.544894046194457, 24.855210462999821, 34.323374828116613, 25.02841094914038, 33.156550500400449, 25.311001216010482, 32.03530524798569, 25.721212893731717, 30.95963907087236, 26.249930167221464, 29.94778359918098, 26.89715303650155, 28.97239138773077, 27.671997316629131, 28.060809881702511, 28.556231377471704, 27.194807450975649, 29.568086849169049, 26.66609017747928, 30.279120423871063, 26.064446383500641, 31.181586114838865, 25.499265849763109, 32.138746696160524, 24.988780206387268, 33.141486352800712, 24.523873638312871, 34.189805084730324, 24.095430330479591, 35.283702891960274, 23.721681913008009, 36.423179774501477, 23.384396755777541, 37.608235732339381, 23.092690673848519, 38.847986580538418, 22.846563667220892, 40.124200688969722, 22.646015735894679, 41.455109687769436, 22.49104687986986, 42.822481946819607, 22.38165709914648, 44.244549096219998, 22.317846393724491, 45.712195320920728, 22.29049894854364, 47.225420620939985, 22.317846393724491, 48.775109181180596, 22.409004544327331, 50.260987036010192, 22.554857585291838, 51.673938370349788, 22.764521331678338, 53.013963184210297, 23.037995783486821, 54.28106147759172, 23.357049310596722, 55.466117435429624, 23.74902935818886, 56.578246872781165, 24.195704296142711, 57.617449789649982, 24.706189939518541, 58.574610370978917, 25.271370473256042, 59.467960246889561, 25.891245897355251, 60.279267787260324, 26.110025458802031, 60.525394793879968, 27.021606964830291, 61.464323745098227, 27.987883361220241, 62.275631285461714, 28.999738832911589, 62.968433230038499, 30.066289194964671, 63.524497948721546, 31.17841863231914, 63.962057071610616, 32.345242960035279, 64.281110598720261, 33.566762178113152, 64.463426899928891, 34.833860471492422, 64.52723760535082, 21.998792866614622, 64.554585050529568],
       [36.055379689570287, 67.991247328260215, 35.316998669687401, 67.98213151319942, 33.94962641064501, 67.927436622838286, 32.618717411843761, 67.827162657169538, 31.31515585822337, 67.663077986089775, 30.0480575648441, 67.462530054759554, 28.799190901585369, 67.198171418011043, 27.595903313628099, 66.888233705958555, 26.410847355791361, 66.523601103548572, 25.262254658195761, 66.104273610781092, 24.150125220841289, 65.639367042698723, 23.056227413607392, 65.119765584269771, 21.998792866614622, 64.554585050529568, 34.833860471492422, 64.52723760535082, 35.945989908846883, 64.481658530050481, 37.167509126924763, 64.317573858959804, 38.34344926970121, 64.034983592100616, 39.464694522115963, 63.62477191437938, 40.531244884169013, 63.096054640889633, 41.552216170920637, 62.448831771609548, 42.509376752250311, 61.673987491478329, 43.420958258278567, 60.780637615571322, 44.277844873945128, 59.768782143881253, 44.305192319125972, 59.73231888364171, 44.943299373345752, 58.838969007731066, 45.535827352264128, 57.909155871591793, 46.082776255881072, 56.942879475198424, 46.593261899256902, 55.921908188440284, 47.04905265227103, 54.855357826389081, 47.468380145044023, 53.752344204098335, 47.84212856251559, 52.603751506499975, 48.170297904685782, 51.409579733601277, 48.452888171554548, 50.169828885398601, 48.699015178182179, 48.884498961899226, 48.899563109508392, 47.562705778171221, 49.045416150472903, 46.19533351912105, 49.154805931196279, 44.782382184781454, 49.227732451678548, 43.323851775130606, 49.245964081799123, 41.819742290190334, 49.227732451678548, 40.452370031151077, 49.145690116136016, 38.939144731139095, 48.999837075171477, 37.507961766670633, 48.799289143845272, 36.158821137749328, 48.534930507097073, 34.882607029310748, 48.2158769799872, 33.688435256408411, 47.833012747455307, 32.576305819060508, 47.395453624561753, 31.537102902191691, 46.894083796246228, 30.589058135919913, 46.338019077568987, 29.71393989013086, 45.718143653469781, 28.911748164831806, 45.508479907083277, 28.6838527883192, 44.606014216115312, 27.772271282290603, 43.648853634785631, 26.988311187109502, 42.636998163094283, 26.322856687711464, 41.570447801041212, 25.775907784089213, 40.440086733566169, 25.347464476250025, 39.255030775729473, 25.046642579258332, 38.006164112470742, 24.864326278060616, 36.702602558850351, 24.809631387699483, 21.10544299070693, 24.700241606980853, 22.29049894854364, 24.080366182868602, 21.497423038299079, 23.414911683481478, 20.202977299738961, 22.302782246119023, 18.999689711781649, 21.227116069010663, 17.88756027442718, 20.215260597320594, 16.875704802735839, 19.248984200930863, 15.96412329670758, 18.328286879841471, 15.15281575634242, 17.462284449109575, 14.43266636658009, 16.641861093688931, 13.8036751274206, 15.876132628618507, 13.27495785392423, 15.16509905392013, 12.84651454609096, 14.499644554518454, 12.837398731030669, 14.481412924400502, 12.0899018960875, 13.16873555571874, 11.50648973222939, 11.919868892458908, 11.09627805451669, 10.734812934621004, 10.841035232828769, 9.6226834972694633, 10.75899289728625, 8.5834805803897325, 10.786340342467099, 7.9636051562993089, 11.0506989792153, 6.7694333834006102, 11.57030043765138, 5.6481881309809978, 12.34514471777541, 4.6181010291693383, 12.47276612861935, 4.4722479882111656, 13.174683888261111, 3.7520985984483559, 14.03157050392767, 3.0137175785603176, 15.06165760573961, 2.2297574833792169, 16.246713563576321, 1.4184499430084543, 17.604970007558421, 0.57979495746985776, 21.570349558781349, 0.0054986086688586511, 22.035256126855732, -0.058312096749432385, 22.965069263004551, -0.17681769253977109, 23.940461474454789, -0.29532328831919585, 24.952316946146141, -0.41382888409862062, 26.000635678078648, -0.52321866483180202, 27.094533485312549, -0.62349263048963621, 28.224894552787589, -0.72376659615110839, 29.39171888050376, -0.82404056181985652, 30.60412228352132, -0.91519871242053341, 31.852988946780041, -0.99724104796041502, 33.138318870279868, -1.0883991985610919, 34.469227869081131, -1.1613257190510922, 35.836600128123507, -1.2433680545909738, 37.240435647407033, -1.3162945750700601, 38.689850241991941, -1.3801052804883511, 40.175728096818013, -1.4439159859211941, 41.698069211885183, -1.4986108762786898, 43.26598940225378, -1.5533057666398236, 44.861257037803227, -1.6080006570009573, 46.511219563714349, -1.6535797323012957, 47.942402528178711, -1.6991588076089101, 49.692639019752953, -1.7720853280807205, 51.333485730603819, -1.8632434786886733, 52.874058475791571, -1.9726332594109408, 54.305241440255912, -2.1002546702511609, 55.627034623996899, -2.2461077112202474, 56.84855384207475, -2.4193081973608059, 57.960683279429219, -2.6016244985694357, 58.972538751120602, -2.802172429899656, 59.875004442088567, -3.0300678064013482, 60.668080352333142, -3.2670789979711117, 61.35176648185432, -3.531437634719623, 62.217768912581157, -3.9598809425515356, 63.22962438427254, -4.670914517260826, 64.013584479456824, -5.5186853178602178, 64.578765013194342, -6.5031933443715388, 64.916050170424796, -7.615322781719442, 65.03455576620847, -8.8641894449901883, 65.007208321027619, -9.5569913895706122, 64.852239465002825, -10.623541751621815, 64.569649198134059, -11.662744668490632, 64.150321705361065, -12.701947585359449, 63.612488616804399, -13.713803057049518, 62.9288024872832, -14.716542713689705, 62.117494946918072, -15.710166555258184, 61.178565995708958, -16.685558766708709, 60.112015633655922, -17.65183516309844, 58.908728045698609, -18.599879929359304, 58.188578655936283, -19.101249757688493, 57.331692040269729, -19.629967031178239, 56.429226349301757, -20.122221044428443, 55.462949952911799, -20.578011797450017, 54.451094481220451, -20.997339290221134, 53.37542830410711, -21.380203522749071, 52.254183051692358, -21.726604495041101, 51.078242908915911, -22.036542207089951, 49.847607875777747, -22.310016658899258, 48.562277952277917, -22.556143665529817, 47.231368953476668, -22.756691596860037, 45.836649249253441, -22.9207762679398, 44.387234654668532, -23.04839767878002, 42.89224098478217, -23.139555829391611, 41.342552424534148, -23.194250719749107, 39.729053158864161, -23.212482349870697, 59.911467702329666, -23.668273102888634, 60.85039665353878, -22.9207762679398, 61.761978159567043, -22.145931987819495, 62.655328035474717, -21.334624447448732, 62.773833631258412, -21.225234666730103, 63.803920733070321, -20.204263379968324, 64.770197129460286, -19.174176278171217, 65.645315375247407, -18.144089176348643, 66.456622915612556, -17.095770444419031, 67.185888120435152, -16.029220082371467, 67.833110989715209, -14.962669720320264, 68.416523153573294, -13.88700354320099, 68.908777166828557, -12.793105735971039, 69.337220474661834, -11.699207928741089, 69.674505631892274, -10.587078491378634, 69.947980083700756, -9.4658332389590214, 70.139412199966699, -8.344587986550323, 70.257917795750373, -7.20511110400912, 70.294381055991494, -6.0474025913608784, 70.257917795750373, -4.9990838594312663, 70.130296384906416, -3.7137539359282528, 69.893285193339054, -2.4831189027900109, 69.556000036108614, -1.2980629449484695, 69.10932509815477, -0.1585860624218185, 68.571492009598103, 0.92619592975825071, 67.924269140318032, 1.9653988466307055, 67.176772305374854, 2.9590226881991839, 66.329001504768598, 3.8979516394101665, 65.845863306573619, 4.3628582074816222, 64.934281800545364, 5.1377024876092037, 63.97712121921569, 5.8396202472504228, 62.947034117403767, 6.477727301469713, 61.87136794029044, 7.0429078352099168, 60.731891057755121, 7.5442776635281916, 59.528603469797822, 7.9818367864208994, 58.279736806539113, 8.346469388830883, 56.957943622798162, 8.6381754707617802, 55.590571363755771, 8.8751866623315436, 55.563223918574913, 8.8751866623315436, 54.93423267941543, 8.9572289978714252, 54.20496747459282, 9.0392713334113068, 53.384544119167401, 9.1213136689511884, 52.472962613139138, 9.2033560044910701, 51.470222956508053, 9.2762825249810703, 50.367209334213868, 9.3492090454601566, 49.18215337637713, 9.4130197508784477, 47.896823452877292, 9.485946271361172, 46.529451193834909, 9.549756976779463, 45.06180496912944, 9.613567682208668, 43.503000593821127, 9.6682625725698017, 41.853038067909971, 9.7229574629309354, 40.11191739139602, 9.7776523532884312, 38.270522749218941, 9.8323472436495649, 36.347085771499337, 9.8779263189499034, 34.605965094985351, 9.932621209318313, 32.828381158230258, 9.9873160996794468, 31.251345152801381, 10.051126805101376, 29.856625448578171, 10.114937510530581, 28.67156949074143, 10.178748215948872, 27.66882983411034, 10.242558921370801, 26.866638108805489, 10.315485441849887, 26.25587849976657, 10.388411962328973, 24.73353738469936, 10.66188641413828, 23.411744200958388, 11.044750646669854, 22.3725412840862, 11.500541399680515, 21.64327607926359, 12.047490303299128, 21.424496517816809, 12.266269864750939, 20.667883867813369, 13.323704411741346, 20.412641046125461, 14.426718034028454, 20.540262456969401, 15.420341875611484, 20.92312668950126, 16.614513648499269, 21.570349558781349, 17.954538462370692, 21.579465373841629, 17.981885907538526, 22.09906683227771, 18.811425078030879, 22.782752961798909, 19.704774953941524, 23.630523762405179, 20.652819720209664, 24.642379234096548, 21.655559376838937, 25.81831937687301, 22.712993923829345, 46.757346570341973, 22.995584190699446, 47.887707637817009, 23.43314331359943, 48.981605445050917, 23.916281511788839, 50.039039992043712, 24.444998785278585, 51.069127093855627, 25.02841094914038, 52.053635120366152, 25.657402188298875, 53.001679886635507, 26.331972502761346, 53.91326139266377, 27.061237707588589, 54.797495453511182, 27.836081987708894, 55.089201535440218, 28.109556439518201, 56.028130486649331, 29.048485390729184, 56.885017102315878, 30.014761787118914, 57.678093012560453, 31.00838562869103, 58.407358217383063, 32.020241100381099, 59.063696901723397, 33.068559832321625, 59.647109065581503, 34.13511019436919, 60.166710524017589, 35.229008001599141, 60.613385461971433, 36.350253254011477, 60.996249694503312, 37.498845951609837, 61.306187406552901, 38.665670279318874, 61.55231441318054, 39.868957867289282, 61.725514899325901, 41.090477085359453, 61.825788864989022, 42.34845956368008, 61.862252125230157, 43.624673672118661, 61.862252125230157, 43.934611384171149, 61.807557234868447, 45.338446903460863, 61.69816745414505, 46.70581916250012, 61.524966967999688, 48.018496531178243, 61.287955776432341, 49.285594824548753, 60.987133879443043, 50.507114042629837, 60.622501277031724, 51.692170000471378, 60.184942154138163, 52.822531067940872, 59.692688140882893, 53.907313060120941, 59.136623422205673, 54.946515976989758, 58.507632183046177, 55.940139818558237, 57.823946053524992, 56.888184584830015, 66.401928025250854, 56.888184584830015, 68.070122181282557, 56.906416214951605, 69.373683734902954, 56.979342735430691, 70.075601494544713, 57.106964146278187, 70.79575088430704, 57.681260495068273, 70.823098329487891, 57.73595538544032, 71.069225336115508, 58.738695042069594, 71.160383486718345, 60.279267787260324, 71.060109521055224, 61.601060970999242, 70.72282436382477, 62.585568997510563, 70.002674974062444, 63.232791866790649, 69.492189330686628, 63.305718387269735, 68.270670112608769, 63.360413277641783, 66.401928025250854, 63.378644907748821, 52.418267722777443, 63.378644907748821, 51.752813223376812, 63.807088215591648, 50.704494491444329, 64.426963639689347, 49.637944129391258, 64.992144173418637, 48.534930507097073, 65.511745631858503, 47.413685254682321, 65.985768014990754, 46.255976742026427, 66.405095507769147, 45.080036599250008, 66.778843925239926, 43.867633196232411, 67.097897452349571, 42.636998163094283, 67.371371904158877, 41.369899869714992, 67.590151465610688, 40.084569946215169, 67.763351951751247, 38.771892577534487, 67.890973362591467, 37.422751948612671, 67.963899883070553, 36.055379689570287, 67.991247328260215],
     ],

104: [ [60.102899818595631, 59.350318955039256, 40.522129069108729, 59.268276619499375, 41.798343177548269, 59.204465914081084, 43.083673101048127, 59.013033797811659, 44.286960689005411, 58.684864455641218, 45.39909012635988, 58.210842072508967, 46.438293043232107, 57.60919827852922, 46.48387211853349, 57.572735018289677, 47.395453624561753, 56.816122368280048, 48.20676116492691, 55.931888307441113, 48.91779473962896, 54.920032835751044, 49.528554348667882, 53.77144013814177, 50.039039992043712, 52.495226029710466, 50.075503252284818, 52.385836248980922, 50.257819553490492, 51.702150119461294, 50.42190422457557, 50.890842579101445, 50.567757265540081, 49.970145258008415, 50.695378676384053, 48.921826526078803, 50.804768457107429, 47.764118013419647, 50.905042422770549, 46.478788089920272, 50.97796894325279, 45.084068385698629, 51.041779648674783, 43.56172727062949, 51.087358723976202, 41.920880559780926, 51.114706169157039, 40.161528253149299, 51.123821984217329, 38.283670350730972, 51.123821984217329, 14.928952166279487, 51.123821984217329, 14.318192557238945, 51.105590354096762, 12.449450469881413, 51.078242908915911, 10.890646094580006, 51.032663833614492, 9.6600110614417645, 50.97796894325279, 8.7484295554095297, 50.905042422770549, 8.1559015765014919, 50.513062375178379, 6.9617298035882413, 49.947881841440882, 5.8040212909399997, 49.236848266738832, 4.8377448945502692, 48.379961651072271, 4.0446689843083732, 48.161182089625491, 3.880584313221334, 47.322527104079512, 3.4156777451498783, 46.283324187207278, 3.0601609578006901, 45.043573339008873, 2.804918136109336, 43.603274559484213, 2.6499492800794542, 41.971543663693673, 2.6043702047791157, 40.449202548626452, 2.6043702047791157, 40.449202548626452, 0.0063629126016166992, 72.883272533111736, 0.0063629126016166992, 72.883272533111736, 2.6043702047791157, 72.691840416845807, 2.6043702047791157, 71.023646260814104, 2.6499492800794542, 69.574231666229181, 2.7775706909305882, 68.343596633091039, 2.9781186222498945, 67.331741161399677, 3.2515930740592012, 66.547781066215379, 3.6071098614083894, 65.517693964403449, 4.3454908813000657, 64.697270608978016, 5.2661882023785438, 64.095626814999378, 6.350970194558613, 63.867731438492306, 6.9617298035882413, 63.630720246924959, 7.8550796794988855, 63.430172315598753, 8.9307458566217974, 63.284319274634207, 10.170496704820835, 63.174929493910838, 11.592563854221225, 63.111118788488852, 13.169599859651498, 63.083771343308001, 14.928952166279487, 63.083771343308001, 38.283670350730972, 63.083771343308001, 38.785040179038333, 63.074655528247717, 40.562624115798826, 63.047308083066859, 42.258165717008524, 63.001729007765483, 43.862549167621182, 62.947034117403767, 45.384890282690321, 62.864991781861221, 46.816073247151508, 62.782949446318703, 48.165213876069174, 62.673559665595292, 49.423196354389802, 62.555054069811632, 50.599136497170548, 62.418316843907377, 51.683918489339703, 62.263347987882582, 52.677542330908182, 62.099263316797497, 53.598239652001212, 61.916947015591852, 54.418663007418218, 61.716399084265618, 55.157044027309894, 61.625240933662809, 55.457865924301586, 61.169450180648681, 56.834353998401639, 60.658964537272851, 58.137915552018967, 60.102899818595631, 59.350318955039256],
       [46.073660440820788, 67.992111632189335, 45.225889640214511, 67.973880002071382, 44.004370422136638, 67.873606036398996, 42.791967019119078, 67.691289735201281, 41.570447801041212, 67.426931098449131, 40.358044398023637, 67.080530126160738, 39.136525179945778, 66.652086818328826, 37.924121776928217, 66.13248535988896, 36.702602558850351, 65.539957380980923, 36.447359737162429, 65.394104340008198, 35.718094532339819, 64.956545217119128, 34.943250252215819, 64.446059573740058, 34.131942711850677, 63.871763224939059, 33.293287726304669, 63.224540355658974, 32.409053665457272, 62.504390965899802, 31.488356344368729, 61.711315055661544, 30.531195763039079, 60.854428439990443, 29.546687736528551, 59.924615303840255, 28.516600634716639, 58.921875647210982, 27.44093445760328, 57.855325285148865, 26.337920835309092, 56.715848402618576, 25.198443952773768, 55.503444999598287, 24.02250380999735, 54.218115076098911, 27.65059820398978, 53.415923350799858, 28.662453675681149, 54.300157411638793, 29.628730072071111, 55.093233321891603, 30.567659023280189, 55.795151081529184, 31.470124714248161, 56.415026505630522, 32.336127144975023, 56.95285959418834, 33.17478213052101, 57.390418717081047, 33.202129575701861, 57.408650347199, 34.46011205402084, 57.973830880939204, 35.708978717279543, 58.438737449010659, 36.930497935357408, 58.803370051420643, 38.152017153435281, 59.058612873108359, 39.346188926332282, 59.213581729130965, 40.522129069108729, 59.268276619499375, 60.102899818595631, 59.350318955039256, 59.501256024616957, 60.480680022519664, 58.844917340276623, 61.528998754449276, 58.142999580634857, 62.495275150839007, 57.386386930631431, 63.379509211688855, 56.584195205326552, 64.172585121930751, 55.736424404720282, 64.892734511689923, 55.526760658333778, 65.047703367719805, 54.51490518664243, 65.731389497239434, 53.448354824589359, 66.333033291219181, 52.33622538723489, 66.843518934590975, 51.178516874579003, 67.253730612308573, 49.975229286621719, 67.572784139418218, 48.726362623363002, 67.809795330980705, 47.422801069742597, 67.946532556881721, 46.073660440820788, 67.992111632189335],
       [0.95949170748252754, 94.446206937129318, 1.9622313641135909, 91.930241980491701, 3.493688294241053, 92.413380178688385, 4.861060553283437, 92.78712859614825, 5.9823058056981893, 93.005908157600061, 6.866539866545593, 93.078834678090061, 0.95949170748252754, 94.446206937129318],
       [24.02250380999735, 102.52281908053919, 20.704347128054479, 102.52281908053919, 0.95949170748252754, 94.446206937129318, 6.866539866545593, 93.078834678090061, 7.65961577679019, 93.033255602778809, 8.8902508099283182, 92.732433705801668, 9.8929904665594108, 92.139905726879078, 9.993264432222503, 92.057863391328283, 10.613139856321711, 91.246555850968434, 11.132741314757819, 90.097963153370074, 11.55206880753081, 88.612085298551392, 11.634111143073371, 88.138062915408227, 11.70703766355564, 87.454376785888599, 11.77996418403788, 86.624837615410797, 11.84377488945986, 85.649445403960272, 11.898469779821561, 84.528200151540659, 11.95316467018324, 83.261101858159236, 11.989627930424369, 81.839034708758845, 12.01697537560522, 80.280230333450163, 12.035207005725789, 78.566457102111599, 12.05343863584636, 76.7068308298185, 12.05343863584636, 74.692235701488244, 12.05343863584636, 14.928952166279487, 12.05343863584636, 13.980907400018623, 12.00785956054494, 12.276249983740854, 11.925817225002421, 10.772140498800582, 11.807311629218731, 9.4594631301188201, 11.643226958133649, 8.347333692760003, 11.433563211747151, 7.426636371670611, 11.18743620511952, 6.7064869819114392, 10.59490822620117, 5.5761259144310316, 9.8109481310168576, 4.6189653330984584, 8.8811349948680345, 3.9717424638183729, 8.3159544611305307, 3.689152196948271, 7.2858673593185861, 3.2971721493704536, 6.1281588466626991, 2.9963502523787611, 4.861060553283437, 2.7775706909305882, 3.475456664120486, 2.6408334650186589, 1.9622313641135909, 2.6043702047791157, 1.9622313641135909, 0.0063629126016166992, 34.688007430527911, 0.0063629126016166992, 34.688007430527911, 2.6043702047791157, 33.502951472691173, 2.6226018349007063, 31.95326291244314, 2.7046441704405879, 30.59500646846104, 2.8596130264704698, 29.419066325684611, 3.087508402968524, 28.425442484113798, 3.3883302999602165, 27.62325075880895, 3.752962902381114, 27.386239567241599, 3.880584313221334, 26.25587849976657, 4.6371969632200489, 25.398991884099988, 5.5123152090091025, 24.81557972024191, 6.4968232355204236, 24.660610864217119, 6.888803283109155, 24.46917874795119, 7.6545317481795792, 24.305094076866091, 8.6481555897516955, 24.17747266602214, 9.8787906228899374, 24.095430330479591, 11.328205217469076, 24.04073544011791, 13.014631003628892, 24.02250380999735, 14.928952166279487, 24.02250380999735, 49.824292217050242, 24.423599672649772, 50.252735524878517, 25.53572911000424, 51.392212407408806, 26.611395287117571, 52.449646954410127, 27.65059820398978, 53.415923350799858, 24.02250380999735, 54.218115076098911, 24.02250380999735, 102.52281908053919],
     ],

105: [ [-16.697842064284771, 181.54856602341169, -17.582076125132168, 181.48475531798977, -18.748900452848321, 181.16570179088012, -19.82456662996168, 180.59140544206821, -20.80907465647218, 179.75275045652961, -21.52010823117422, 178.91409547099101, -22.121752025152858, 177.8475451089289, -22.486384627564181, 176.68072078121986, -22.614006038408121, 175.42273830289923, -22.504616257684741, 174.51115679687064, -22.139983655273429, 173.49018551011977, -21.501876601053649, 172.4874458534905, -20.608526725145971, 171.50293782697918, -19.44170239742979, 170.51842980047149, -19.377891692007829, 170.47285072517116, -18.539236706461821, 169.92590182154163, -17.582076125132168, 169.45187943840938, -16.533757393199661, 169.05078357575985, -15.3760488805438, 168.72261423358941, -14.118066402224789, 168.46737141190169, -12.750694143182409, 168.28505511070034, -11.283047918476941, 168.1756653299708, -9.7060119130480587, 168.13920206973125, -8.3751029142468099, 168.16654951491, -7.0624255455661276, 168.25770766551068, -5.7770956220662688, 168.39444489141897, -4.5282289588075741, 168.59499282274919, -3.3067097407297008, 168.85023564444055, -2.112537967832707, 169.16017335647848, -0.94571364011653714, 169.53392177394926, 0.18464742735849879, 169.96236508178845, 1.287661049652683, 170.44550327998149, 2.363327226766017, 170.98333636853931, 3.402530143638244, 171.58498016251906, 4.4143856153295919, 172.23220303179914, 5.3988936418401181, 172.94323660650116, 6.3469384081095077, 173.71808088662146, -2.2857384539780692, 173.8365864824118, -2.6503710563893601, 173.85481811252976, -3.598415822658751, 174.05536604384906, -4.6193871094104111, 174.4655777215703, -5.7132849166443123, 175.09456896072879, -6.8801092443604537, 175.94233976132818, -8.1198600925588948, 177.0088901233903, -9.1043681190694201, 177.85666092398969, -10.362350597388399, 178.90497965591931, -11.41066932932088, 179.70717138122927, -12.2493243148669, 180.28146773003027, -12.878315554026379, 180.60963707220071, -13.033284410051181, 180.6825635926798, -14.273035258249591, 181.16570179088012, -15.49455447632746, 181.4574078728001, -16.697842064284771, 181.54856602341169],
       [4.3414590948473233, 59.91636379270858, 5.3533145665386987, 57.318356500531081, 6.6933393804002321, 57.783263068598899, 7.9877851189603462, 58.12966404089093, 9.1819568918573662, 58.33021197222115, 10.2576230689707, 58.40313849271115, 4.3414590948473233, 59.91636379270858],
       [27.40447119736217, 67.992975936118455, 24.24128337144413, 67.992975936118455, 4.3414590948473233, 59.91636379270858, 10.2576230689707, 58.40313849271115, 10.968656643672739, 58.366675232460693, 12.21752330693144, 58.093200780651387, 13.211147148502249, 57.537136061979254, 13.83102257260145, 56.816986672209168, 14.37797147621842, 55.713973049918422, 14.797298968991409, 54.29190590052167, 14.8975729346545, 53.726725366781466, 14.99784690031762, 52.970112716768199, 15.09812086598072, 52.076762840861193, 15.180163201523269, 51.064907369171124, 15.243973906945261, 49.925430486640835, 15.307784612367239, 48.649216378198616, 15.353363687668629, 47.254496673980611, 15.39894276297005, 45.723039743850677, 15.426290208150901, 44.073077217941318, 15.435406023211179, 42.28637746612003, 15.44452183827147, 40.381172118519316, 15.44452183827147, 14.929816470219521, 15.435406023211179, 13.881497738278995, 15.38982694790977, 12.213303582251683, 15.298668797306959, 10.736541542490158, 15.171047386462989, 9.4329799888691923, 14.98873108525734, 8.3208505515103752, 14.76995152381056, 7.3910374153601879, 14.50559288706236, 6.6435405804186303, 14.323276585856719, 6.2606763478906942, 13.61224301115467, 5.1303152804102865, 12.782703840668971, 4.2187337743816897, 11.84377488945986, 3.5350476448584232, 11.70703766355564, 3.4712369394401321, 10.904845938250761, 3.152183412330487, 9.8656430213785598, 2.9151722207716375, 8.5985447279992684, 2.7419717346201651, 7.0944352430526569, 2.6325819538906217, 5.3533145665386987, 2.6052345087082358, 5.3533145665386987, 0.0072272165307367686, 37.422751948612671, 0.0072272165307367686, 37.422751948612671, 2.6052345087082358, 37.131045866683621, 2.6052345087082358, 35.462851710651933, 2.6508135840194882, 34.022552931127279, 2.7784349948597082, 32.791917897989123, 2.9789829261899285, 31.789178241358059, 3.2615731930491165, 31.01433396123403, 3.6079741653484234, 30.67704880400359, 3.8085220966713678, 29.7290040377342, 4.5833663767989492, 28.954159757610199, 5.5496427731886797, 28.343400148571249, 6.7073512858405593, 28.197547107606741, 7.0628680731897475, 27.96053591603939, 7.8832914286213054, 27.759987984713181, 8.9042627153685316, 27.605019128688379, 10.116666118388821, 27.495629347964979, 11.520501637671259, 27.431818642542989, 13.12488508828028, 27.40447119736217, 14.929816470219521, 27.40447119736217, 67.992975936118455],
       [21.424496517816809, 102.52368338446831, 20.631420607572242, 102.48722012422877, 19.391669759373801, 102.2684405627806, 18.243077061778191, 101.85822888507028, 17.194758329845708, 101.24746927602973, 16.237597748516041, 100.43616173566988, 15.6906488448991, 99.834517941690137, 14.98873108525734, 98.804430839878478, 14.47824544188151, 97.701417217580456, 14.1774235448922, 96.516361259738915, 14.077149579229079, 95.240147151300334, 14.113612839470219, 94.437955426001281, 14.34150821597728, 93.225552022980992, 14.76995152381056, 92.086075140450703, 15.39894276297005, 91.028640593449381, 16.237597748516041, 90.053248381998856, 16.839241542494701, 89.506299478391156, 17.860212829246329, 88.804381718749937, 18.972342266600801, 88.293896075370867, 20.157398224437539, 87.993074178379175, 21.424496517816809, 87.89280021272134, 22.226688243121689, 87.929263472960884, 23.44820746119953, 88.157158849469852, 24.58768434373485, 88.585602157301764, 25.636003075667329, 89.214593396460259, 26.611395287117571, 90.053248381998856, 27.121880930493401, 90.627544730799855, 27.81468287507488, 91.657631832611514, 28.306936888330139, 92.769761269970331, 28.607758785319451, 93.96393304286903, 28.708032750982571, 95.240147151300334, 28.67156949074143, 96.005875616370759, 28.452789929294649, 97.236510649509, 28.04257825158194, 98.385103347100085, 27.422702827482709, 99.451653709158563, 26.611395287117571, 100.43616173566988, 26.04621475338007, 100.93753156398088, 25.01612765156813, 101.63033350856131, 23.894882399153371, 102.13170333687958, 22.700710626256381, 102.42340941881048, 21.424496517816809, 102.52368338446831],
     ],

106: [ [-6.7524878335165113, 59.917228096659528, -5.749748176885447, 57.319220804471115, -4.40060754796363, 57.784127372549847, -3.106161809403488, 58.13052834483824, -1.921105851566778, 58.33107627616846, -0.8454396744534165, 58.404002796651184, -6.7524878335165113, 59.917228096659528],
       [16.237597748516041, 67.993840240069403, 13.13822062801998, 67.993840240069403, -6.7524878335165113, 59.917228096659528, -0.8454396744534165, 58.404002796651184, -0.134406099751402, 58.367539536411641, 1.114460563507321, 58.094065084598697, 2.108084405078102, 57.538000365919288, 2.755307274358187, 56.781387715920573, 3.2931403629148401, 55.660142463500961, 3.6942362255672658, 54.219843683978979, 3.8036260062906702, 53.627315705060028, 3.9038999719537619, 52.87981887011847, 3.9950581225565989, 51.995584809268621, 4.077100458099153, 50.974613522521395, 4.1500269785813941, 49.835136639991106, 4.2047218689430963, 48.558922531548887, 4.2594167593047976, 47.155087012259173, 4.2958800195459332, 45.623630082129239, 4.3232274647267843, 43.955435926098289, 4.3414590948473233, 42.159620359219844, 4.3414590948473233, 40.236183381508454, 4.3414590948473233, -6.7740748843716574, 4.3414590948473233, -7.9773624723311514, 4.3232274647267843, -9.7914096693202737, 4.2958800195459332, -11.486951270540885, 4.2503009442445139, -13.045755645849567, 4.1956060538828117, -14.476938610310754, 4.1226795334005431, -15.78050016393172, 4.0406371978580182, -16.947324491651671, 3.9403632321948971, -17.986527408520487, 3.8218576364112371, -18.898108914549084, 3.6942362255672658, -19.67295319466939, 3.5483831846027551, -20.320176063949475, 3.5028041093013371, -20.502492365161743, 3.0561291713474921, -21.906327884440543, 2.5091802677305561, -23.091383842278447, 1.852841583390215, -24.04854442361102, 1.105344748447038, -24.796041258548939, 0.0114469412131371, -25.543538093490497, -1.1280299413221819, -26.008444661569229, -2.2857384539780692, -26.163413517588197, 6.3469384081095077, -26.281919113378535, 7.2767515442583033, -25.461495757950615, 8.1701014201659916, -24.577261697100766, 9.0269880358325736, -23.638332745889784, 9.2275359671587864, -23.41043736939173, 9.8747588364388434, -22.608245644081762, 10.494634260538049, -21.769590658528614, 11.087162239456401, -20.894472412750474, 11.643226958133649, -19.973775091661082, 12.162828416569759, -19.016614510328509, 12.655082429825001, -18.022990668760031, 13.11998899789941, -16.983787751891214, 13.548432305732691, -15.917237389840011, 13.94952816838514, -14.805107952481194, 14.31416077079643, -13.656515254879196, 14.64233011296659, -12.471459297048568, 14.9522678250162, -11.240824263910326, 15.216626461764401, -9.9828417855896987, 15.45363765333175, -8.6792802319687326, 15.66330139971825, -7.3392554181082232, 15.83650188586361, -5.9536515289510135, 15.982354926828149, -4.5407001946005039, 16.09174470755152, -3.0821697849605698, 16.17378704309408, -1.5871761150701786, 16.21936611839547, -0.046603369879449019, 16.237597748516041, 1.5213168204900285, 16.237597748516041, 67.993840240069403],
       [10.03884350752392, 102.59747420889835, 9.2366517822190701, 102.5610109486588, 8.0151325641411972, 102.33311557214984, 6.8847714966661613, 101.90467226432156, 5.827336949673394, 101.26656521009863, 4.8519447382231533, 100.43702603960992, 4.2685325743650822, 99.789803170329833, 3.5757306297836058, 98.759716068521811, 3.083476616528344, 97.64758663117027, 2.7826547195390101, 96.453414858271572, 2.6823807538759179, 95.177200749829353, 2.7279598291773359, 94.365893209458591, 2.9558552056843999, 93.153489806449215, 3.3842985135176771, 92.01401292391165, 4.0132897526771671, 90.956578376921243, 4.8519447382231533, 89.981186165470717, 5.453588532201791, 89.434237261848466, 6.474559818953451, 88.732319502210885, 7.5775734412476359, 88.221833858831815, 8.7717452141446586, 87.921011961840122, 10.03884350752392, 87.82073799617865, 10.923077568371321, 87.866317071478989, 12.144596786449201, 88.094212447991595, 13.28407366898452, 88.531771570880665, 14.332392400917, 89.160762810039159, 15.298668797306959, 89.981186165470717, 15.84561770092389, 90.582829959450464, 16.556651275625939, 91.612917061258486, 17.058021103941481, 92.715930683549232, 17.35884300093079, 93.900986641390773, 17.459116966593911, 95.177200749829353, 17.413537891292489, 96.052318995611131, 17.185642514785432, 97.273838213688578, 16.757199206952151, 98.41331509622978, 16.128207967792662, 99.470749643220188, 15.298668797306959, 100.43702603960992, 14.65144592802687, 101.02043820347171, 13.63047464127524, 101.7132401480485, 12.51834520392077, 102.20549416130962, 11.32417343102375, 102.49720024324051, 10.03884350752392, 102.59747420889835],
     ],

107: [ [71.297120712622572, 66.04392012110111, 42.618766532973723, 66.04392012110111, 42.618766532973723, 63.73761891085087, 43.138367991409808, 63.701155650611327, 44.560435140813887, 63.491491904220311, 45.70902783840949, 63.117743486749532, 46.584146084196611, 62.589026213248871, 46.857620536005101, 62.30643594637877, 47.513959220345441, 61.249001399388362, 47.732738781792222, 60.063945441550459, 47.678043891430512, 59.516996537939121, 47.158442432994399, 58.331940580101218, 46.866736351065377, 57.949076347569644, 46.365366522749831, 57.365664183711488, 45.663448763108072, 56.627283163830725, 44.77009888720039, 55.733933287920081, 43.69443271008705, 54.685614555990469, 42.418218601647503, 53.482326968030975, 40.959688192002289, 52.13318633910967, 24.16835685096186, 36.773037962531816, 44.414582099849383, 10.893239006389194, 45.353511051058462, 9.6534881581901573, 46.20128185166476, 8.3681582346907817, 46.812041460703682, 7.2651446124000358, 47.176674063114973, 6.3262156611890532, 47.304295473958938, 5.5604871961186291, 47.085515912512157, 4.3936628684095922, 46.365366522749831, 3.4729655473202001, 46.301555817327852, 3.4182706569590664, 45.435553386601008, 2.9989431641806732, 44.204918353462887, 2.7254687123713666, 42.618766532973723, 2.6069631165883038, 42.618766532973723, 0.0089558244108047802, 74.68820391504768, 0.0089558244108047802, 74.68820391504768, 2.6069631165883038, 73.038241389136545, 2.6343105617706897, 71.561479349370771, 2.7163528973214852, 70.303496871051777, 2.8622059382796579, 69.255178139119295, 3.0627538696098782, 68.416523153573294, 3.3271125063583895, 67.596099798147861, 3.691745108768373, 66.648055031878485, 4.229578197318915, 65.65443119030769, 4.895032696720591, 64.606112458375193, 5.6972244220305583, 63.512214651141278, 6.6452691882914223, 62.363621953545703, 7.7209353654106962, 62.144842392098887, 7.9397149268588691, 61.643472563783376, 8.4502005702306633, 61.078292030045837, 9.0609601792712056, 60.449300790886348, 9.771993753969582, 59.738267216184312, 10.574185479279549, 58.963422936060311, 11.476651170250989, 58.124767950514297, 12.479390826880262, 57.204070629425779, 13.582404449171008, 56.219562602915261, 14.785692037130502, 55.171243870982771, 16.080137775690673, 54.040882803507742, 17.474857479908678, 52.84671103061072, 18.969851149799069, 35.909526648605777, 40.382900726399384, 52.84671103061072, 56.025639369850978, 53.129301297479479, 56.280882191538694, 54.250546549894231, 57.256274402978306, 55.353560172188423, 58.14962427888895, 56.429226349301757, 58.970047634320508, 57.486660896294516, 59.717544469258428, 58.516747998106467, 60.392114783720899, 59.537719284858099, 60.984642762639851, 60.531343126428908, 61.495128406018921, 61.497619522818837, 61.941803343968786, 62.381853583666242, 62.288204316260817, 63.457519760779597, 62.63460528854921, 64.606112458375193, 62.944543000601698, 65.809400046332485, 63.199785822289414, 67.085614154772045, 63.409449568680429, 68.425638968633564, 63.564418424699397, 69.829474487917082, 63.682924020478822, 71.297120712622572, 63.73761891085087, 71.297120712622572, 66.04392012110111],
       [1.242081974351265, 94.448799848938506, 2.4727170074894209, 91.932834892300889, 3.5666148147233221, 92.352162385068368, 4.9339870737657057, 92.798837323029147, 6.082579771361309, 93.063195959770383, 7.0123929075101321, 93.154354110378335, 1.242081974351265, 94.448799848938506],
       [24.16835685096186, 102.52541199234838, 20.850200169019018, 102.52541199234838, 1.242081974351265, 94.448799848938506, 7.0123929075101321, 93.154354110378335, 7.8054688177546998, 93.108775035070721, 9.0361038508928573, 92.807953138089943, 10.03884350752392, 92.215425159170991, 10.148233288247321, 92.115151193509519, 10.795456157527379, 91.276496207960008, 11.305941800903179, 90.137019325418805, 11.69792184849535, 88.687604730839666, 11.77996418403788, 88.14977164227821, 11.862006519580429, 87.456969697701425, 11.934933040062701, 86.618314712148276, 11.99874374548466, 85.633806685640593, 12.05343863584636, 84.503445618171099, 12.099017711147781, 83.218115694671724, 12.13548097138891, 81.796048545271333, 12.162828416569759, 80.228128354898217, 12.1810600466903, 78.505239308498858, 12.199291676810869, 76.636497221141326, 12.199291676810869, 74.631017907879141, 12.199291676810869, 14.5031017702604, 12.190175861750591, 13.545941188931465, 12.144596786449201, 11.932441923261649, 12.035207005725789, 10.483027328678872, 11.880238149701, 9.1885815901114256, 11.67969021837478, 8.0582205226382939, 11.424447396686871, 7.0919441262485634, 11.123625499697541, 6.2806365858887148, 10.64960311656284, 5.4602132304607949, 9.8291797611374232, 4.5304000943106075, 8.8173242894460486, 3.8284823346693884, 8.7535135840240912, 3.8011348894906405, 7.8419320779958346, 3.436502287080657, 6.7936133460633519, 3.1356803900889645, 5.6176732032868983, 2.898669198519201, 4.2958800195459332, 2.7345845274394378, 2.8373496099007118, 2.6343105617706897, 1.242081974351265, 2.6069631165883038, 1.242081974351265, 0.0089558244108047802, 34.833860471492422, 0.0089558244108047802, 34.833860471492422, 2.6069631165883038, 33.457372397389783, 2.6343105617706897, 31.81652568653891, 2.7163528973214852, 30.412690167255391, 2.8530901232188626, 29.245865839539221, 3.0354064244311303, 28.316052703390401, 3.2633018009291845, 27.62325075880895, 3.5367762527384912, 27.50474516302527, 3.6005869581604202, 26.538468766635312, 4.3025047178016393, 25.73627704133045, 5.241433669008984, 25.09816998711068, 6.4264896268505254, 24.915853685905041, 6.8913961949183431, 24.68795830939797, 7.7300511804714915, 24.496526193132041, 8.7601382822795131, 24.350673152167509, 9.9907733154213929, 24.25039918650441, 11.421956279878941, 24.186588481082421, 13.044571360609552, 24.16835685096186, 14.858618557609589, 24.16835685096186, 36.773037962531816, 24.16835685096186, 102.52541199234838],
     ],

108: [ [4.4143856153295919, 94.449723212208482, 5.6450206484677494, 91.92464244051007, 6.8756556816058767, 92.38043319352073, 8.188333050286559, 92.772413241120375, 9.3642731930630134, 93.000308617629344, 10.394360294874931, 93.082350953169225, 4.4143856153295919, 94.449723212208482],
       [27.340660491940181, 102.52633535561836, 24.095430330479591, 102.52633535561836, 4.4143856153295919, 94.449723212208482, 10.394360294874931, 93.082350953169225, 11.02335153403444, 93.045887692929682, 12.244870752112289, 92.745065795941628, 13.28407366898452, 92.143422001958243, 13.329652744285911, 92.097842926661542, 13.96775979850568, 91.295651201351575, 14.47824544188151, 90.156174318821286, 14.870225489473651, 88.679412279048847, 14.93403619489564, 88.269200601338525, 15.01607853043819, 87.603746101940487, 15.089005050920431, 86.783322746508929, 15.1619315714027, 85.817046350119199, 15.216626461764401, 84.704916912771296, 15.262205537065819, 83.437818619389873, 15.298668797306959, 82.033983100100158, 15.33513205754806, 80.475178724798752, 15.353363687668629, 78.770521308528259, 15.3715953177892, 76.910895036231523, 15.3715953177892, 74.914531538030133, 15.3715953177892, 14.932468441369565, 15.36247950272892, 13.884149709429039, 15.3169004274275, 12.215955553401727, 15.22574227682469, 10.730077698579407, 15.09812086598072, 9.4356319600192364, 14.915804564775071, 8.3143867075996241, 14.697025003328291, 7.3845735714494367, 14.43266636658009, 6.6370767365115171, 14.277697510555299, 6.2906757642194862, 13.603127196094389, 5.1420830666211259, 12.791819655729251, 4.2305015605888912, 11.84377488945986, 3.5376996160084673, 11.078046424396121, 3.2004144587808696, 10.066190952704771, 2.9360558220287203, 8.8264401045063323, 2.7537395208310045, 7.3496780647405719, 2.6352339250406658, 5.6450206484677494, 2.5987706648083986, 5.6450206484677494, 0.0007633726199856028, 38.006164112470742, 0.0007633726199856028, 38.006164112470742, 2.5987706648083986, 36.903150490176557, 2.6170022949190752, 35.316998669687401, 2.6899288154090755, 33.931394780524442, 2.8357818563708861, 32.755454637748016, 3.0454456027582637, 31.780062426297771, 3.3280358696283656, 31.01433396123403, 3.6835526569811918, 30.66793298894331, 3.8749847732397029, 29.683424962432781, 4.6407132383101271, 28.89034905218821, 5.5796421895211097, 28.270473628089011, 6.7100032569906034, 28.124620587124468, 7.0655200443397916, 27.887609395557121, 7.8859433997713495, 27.687061464230911, 8.8977988714614185, 27.53209260820611, 10.110202274470794, 27.422702827482709, 11.523153608821303, 27.358892122060752, 13.127537059430324, 27.340660491940181, 14.932468441369565, 27.340660491940181, 102.52633535561836],
     ],

109: [ [69.045514392732784, 59.582594910560147, 68.051890551161989, 58.588971068991668, 67.030919264410343, 57.522420706940466, 65.982600532477861, 56.392059639460058, 64.906934355364513, 55.197887866568635, 63.803920733070321, 53.93078957319085, 50.731841936625159, 53.721125826799835, 51.123821984217329, 52.773081060531695, 51.470222956508053, 51.724762328598445, 51.761929038437103, 50.58528544606088, 51.99894023000445, 49.336418782808323, 52.181256531210103, 47.987278153890657, 52.308877942054039, 46.537863559300604, 52.390920277596592, 44.988174999049079, 52.418267722777443, 43.33821247313972, 52.418267722777443, 14.933332745298685, 52.418267722777443, 13.730045157339191, 52.390920277596592, 11.943345405528817, 52.33622538723489, 10.457467550699221, 52.272414681812933, 9.263295777800522, 52.172140716149812, 8.3790617169506731, 52.053635120366152, 7.7956495530997927, 51.62519181253284, 6.6561726705585897, 50.996200573373358, 5.5713906783894345, 50.20312466312879, 4.6506933573000424, 49.245964081799123, 3.8940807072904136, 49.163921746256563, 3.8485016319900751, 48.361730020951711, 3.465637399458501, 47.38633780950147, 3.1556996874096512, 46.237745111905859, 2.9095726807900064, 44.897720298044327, 2.736372194638534, 43.375379182977149, 2.6360982289806998, 41.679837581764609, 2.5996349687302427, 41.679837581764609, 0.0016276765491056722, 75.052836517458985, 0.0016276765491056722, 75.052836517458985, 2.5996349687302427, 73.794854039139992, 2.6178665988591092, 72.26339710901253, 2.7090247494597861, 70.90514066503043, 2.863993605478754, 69.729200522253976, 3.0918889819913602, 68.735576680683181, 3.3835950639186194, 67.915153325257748, 3.7573434813893982, 67.678142133690415, 3.8849648922296183, 66.547781066215379, 4.6415775422392471, 65.690894450548811, 5.5075799729711434, 65.10748228669074, 6.4920879994788265, 64.952513430665931, 6.8840680470711959, 64.751965499339718, 7.6497965121307061, 64.59699664331491, 8.6434203536991845, 64.469375232470952, 9.8740553868410643, 64.378217081868144, 11.332585796488274, 64.323522191506441, 13.019011582640815, 64.314406376446158, 14.933332745298685, 64.314406376446158, 46.437589593639132, 64.168553335481619, 49.536966714131268, 64.314406376446158, 50.330042624369526, 64.606112458375193, 50.603517076178832, 65.754705155970797, 51.670067438240949, 66.875950408385549, 52.654575464748632, 67.960732400559166, 53.575272785841662, 69.009051132491663, 54.413927771380258, 70.011790789122742, 55.170540421378973, 70.987183000572969, 55.863342365970311, 71.926111951782076, 56.47410197499994, 72.819461827689764, 57.0028192485006, 73.676348443356318, 57.467725816579332, 73.977170340345637, 57.604463042480347, 75.198689558423496, 58.133180315981008, 76.429324591561624, 58.570739438870078, 77.650843809639511, 58.908024596101313, 78.87236302771737, 59.145035787671077, 80.093882245795214, 59.290888828629249, 81.315401463873087, 59.336467903940502, 69.045514392732784, 59.582594910560147],
       [61.625240933662809, 59.837837732251501, 41.17846775344907, 59.555247465381399, 41.798343177548269, 59.546131650320604, 43.074557285987837, 59.418510239480383, 44.277844873945128, 59.163267417789029, 45.417321756480447, 58.780403185261093, 46.48387211853349, 58.269917541878385, 47.477495960104307, 57.631810487659095, 48.398193281192839, 56.866082022599585, 49.255079896859392, 55.963616331631783, 50.039039992043712, 54.942645044880919, 50.276051183611031, 54.56889662741014, 50.731841936625159, 53.721125826799835, 63.803920733070321, 53.93078957319085, 63.548677911382413, 54.979108305120462, 63.165813678850547, 56.300901488859381, 62.710022925836419, 57.549768152119213, 62.199537282460597, 58.72570829489996, 61.625240933662809, 59.837837732251501],
       [1.242081974351265, 59.919880067791382, 2.3268639665248818, 57.321872775610245, 3.5848464448438899, 57.759431898499315, 4.8792921834040044, 58.114948685859417, 6.0643481412407416, 58.333728247300314, 7.1582459484746428, 58.406654767779401, 1.242081974351265, 59.919880067791382],
       [47.158442432994399, 67.987376396140462, 45.946039029976838, 67.950913135900919, 44.715403996838688, 67.823291725060699, 43.475653148640269, 67.613627978669683, 42.226786485381552, 67.321921896738786, 40.987035637183141, 66.93905766421085, 39.729053158864161, 66.47415109612848, 39.227683330548608, 66.264487349748379, 38.088206448013288, 65.744885891308513, 36.96696119559855, 65.152357912389562, 35.873063388364642, 64.514250858170271, 34.806513026311592, 63.803217283468257, 33.758194294379081, 63.046604633469542, 32.737223007627449, 62.226181278041622, 32.66429648714518, 62.153254757558898, 32.281432254613321, 61.8159696003313, 31.752714981116931, 61.332831402130978, 31.09637629677659, 60.703840162979759, 30.294184571471732, 59.92899588284854, 29.355255620262628, 59.017414376830857, 28.288705258209578, 57.959979829829535, 27.076301855191989, 56.756692241870041, 25.727161226270169, 55.416667428020446, 24.24128337144413, 53.93078957319085, 27.778219614833748, 53.784936532221764, 28.780959271464809, 54.559780812349345, 29.856625448578171, 55.316393462351698, 30.996102331113491, 56.054774482228822, 32.199389919070768, 56.765808056941751, 33.466488212450031, 57.467725816579332, 33.90404733534362, 57.695621193081024, 35.107334923300897, 58.269917541878385, 36.310622511258209, 58.72570829489996, 37.523025914275763, 59.090340897309943, 38.735429317293352, 59.345583718990383, 39.956948535371232, 59.500552575020265, 41.17846775344907, 59.555247465381399, 61.625240933662809, 59.837837732251501, 60.987133879443043, 60.886156464181113, 60.29433193486156, 61.861548675631639, 59.528603469797822, 62.773130181660235, 58.708180114372396, 63.611785167209746, 57.823946053524992, 64.386629447330051, 57.69632464268102, 64.486903412991524, 56.684469170989672, 65.225284432879562, 55.64526625411748, 65.872507302148733, 54.551368446883536, 66.437687835888937, 53.421007379408501, 66.911710219028464, 52.254183051692358, 67.303690266620833, 51.041779648674783, 67.604512163608888, 49.78379717035579, 67.814175909999904, 48.489351431795647, 67.950913135900919, 47.158442432994399, 67.987376396140462],
       [86.866932835585146, 67.987376396140462, 86.082972740400848, 67.978260581079667, 84.834106077142138, 67.896218245539785, 83.603471044003996, 67.741249389509903, 82.372836010865853, 67.522469828069006, 81.151316792787995, 67.221647931080952, 79.93891338977042, 66.857015328670968, 78.735625801813129, 66.41945620577826, 77.532338213855837, 65.90897056239919, 76.347282256019099, 65.325558398541034, 76.082923619270915, 65.179705357579223, 75.289847709026333, 64.705682974439696, 74.478540168661183, 64.176965700939036, 73.630769368054899, 63.575321906970203, 72.764766937328062, 62.909867407568527, 71.880532876480657, 62.180602202741284, 70.959835555392118, 61.378410477438592, 70.011790789122742, 60.512408046710334, 69.045514392732784, 59.582594910560147, 81.315401463873087, 59.336467903940502, 82.245214600021924, 59.309120458761754, 83.576123598823145, 59.172383232849825, 84.806758631961316, 58.908024596101313, 85.955351329556891, 58.516044548508944, 87.012785876549657, 58.005558905129874, 87.979062272939615, 57.367451850921498, 88.854180518726736, 56.610839200908231, 89.638140613911034, 55.726605140058382, 90.330942558492509, 54.723865483429108, 90.412984894035077, 54.578012442470936, 90.804964941627205, 53.775820717160968, 91.151365913917928, 52.864239211128734, 91.443071995846978, 51.843267924381507, 91.698314817534879, 50.703791041851218, 91.90797856392139, 49.454924378591386, 92.072063235006468, 48.096667934609286, 92.181453015729858, 46.619905894840485, 92.254379536212127, 45.033754074349417, 92.272611166332695, 43.33821247313972, 92.272611166332695, 14.933332745298685, 92.272611166332695, 13.967056348908955, 92.254379536212127, 12.153009151908918, 92.217916275971007, 10.64889966696137, 92.163221385609305, 9.4364962639483565, 92.081179050066766, 8.534030572980555, 91.990020899463957, 7.932386779000808, 91.743893892836297, 7.1848899440483365, 91.178713359098793, 5.9907181711605517, 90.467679784396751, 5.0153259597100259, 89.610793168730197, 4.258713309711311, 89.164118230776353, 3.9761230428412091, 88.179610204265856, 3.4838690295800916, 87.058364951851075, 3.0918889819913602, 85.827729918712933, 2.8184145301784156, 84.460357659670564, 2.6543298590986524, 82.974479804844506, 2.5996349687302427, 81.607107545802137, 2.5996349687302427, 81.607107545802137, 0.0016276765491056722, 114.1870305712519, 0.0016276765491056722, 114.1870305712519, 2.5996349687302427, 113.9500193796846, 2.5996349687302427, 112.3547517441351, 2.6543298590986524, 110.9509162248516, 2.800182900060463, 109.7293970067737, 3.0280782765694312, 108.6901940899015, 3.3471318036790763, 107.8424232892952, 3.7573434813893982, 107.7877283989336, 3.7846909265717841, 106.6482515163982, 4.5595352066993655, 105.7822490856714, 5.4346534524811432, 105.1806052916927, 6.4191614789888263, 104.9800573603665, 6.9752261976682348, 104.75216198385949, 7.8776918886396743, 104.56984568265381, 8.944242250690877, 104.4239926416893, 10.183993098889914, 104.3237186760262, 11.59694443322951, 104.2599079706042, 13.173980438659783, 104.24167634048359, 14.933332745298685, 104.24167634048359, 43.33821247313972, 104.23256052542339, 44.021898602659348, 104.2143288953028, 45.66274531351155, 104.1505181898808, 47.212433873759437, 104.0684758543383, 48.680080098460166, 103.9590860736149, 50.047452357510338, 103.8132330326504, 51.341898096070508, 103.640032546505, 52.536069868958293, 103.4394846151788, 53.648199306320748, 103.20247342361139, 54.669170593071613, 102.94723060192349, 55.608099544278957, 102.6555245199945, 56.455870344889263, 102.2088495820406, 57.540652337058418, 101.6163216031223, 58.816866445500636, 100.9690987338422, 60.011038218399335, 100.29452841938129, 61.114051840690081, 99.565263214558726, 62.135023127440945, 98.799534749494995, 63.064836263591133, 97.988227209129846, 63.903491249129729, 97.131340593463307, 64.660103899139358, 96.237990717555604, 65.325558398541034, 95.371988286828753, 65.854275672030781, 94.268974664534568, 66.41945620577826, 93.129497781999248, 66.902594403971307, 91.953557639222808, 67.294574451560038, 90.741154236205233, 67.595396348551731, 89.483171757886225, 67.814175909999904, 88.197841834386395, 67.950913135900919, 86.866932835585146, 67.987376396140462],
       [24.24128337144413, 67.987376396140462, 21.14190625094804, 67.987376396140462, 1.242081974351265, 59.919880067791382, 7.1582459484746428, 58.406654767779401, 7.8692795231766857, 58.370191507539857, 9.1181461864353821, 58.087601240669755, 10.111770028006189, 57.540652337058418, 10.749877082225961, 56.774923871991632, 11.28771017078261, 55.662794434640091, 11.69792184849535, 54.222495655121747, 11.807311629218731, 53.584388600891543, 11.90758559488185, 52.809544320771238, 11.99874374548466, 51.916194444860594, 12.08078608102721, 50.895223158109729, 12.153712601509479, 49.746630460518645, 12.20840749187116, 48.470416352080065, 12.26310238223286, 47.057465017729555, 12.29956564247399, 45.526008087610535, 12.326913087654839, 43.866929746629467, 12.33602890271513, 42.080229994819092, 12.34514471777541, 40.165908832161222, 12.34514471777541, 14.933332745298685, 12.33602890271513, 13.967056348908955, 12.29044982741371, 12.280630562760052, 12.20840749187116, 10.785636892869661, 12.071670265966929, 9.4820753392486949, 11.898469779821561, 8.3699459018898779, 11.6705744033145, 7.4492485808004858, 11.4062157665663, 6.7108675609197235, 11.19655202017981, 6.2641926229698583, 10.51286589065862, 5.1611790006791125, 9.6650950900523451, 4.2769449398292636, 8.6714712484815362, 3.6114904404312256, 8.5985447279992684, 3.5659113651199732, 7.7598897424532822, 3.2195103928315802, 6.7206868255810832, 2.9460359410295496, 5.4627043472620747, 2.7546038247601246, 4.0041739376168826, 2.6360982289806998, 2.3268639665248818, 2.5996349687302427, 2.3268639665248818, 0.0016276765491056722, 34.979713512456946, 0.0016276765491056722, 34.979713512456946, 2.5996349687302427, 33.667036143776272, 2.6178665988591092, 32.053536878106257, 2.6907931193381955, 30.65881717388303, 2.8275303452392109, 29.501108661227128, 3.0280782765694312, 28.553063894957749, 3.2924369133215805, 27.842030320255731, 3.6114904404312256, 27.632366573869241, 3.7208802211498551, 26.629626917238141, 4.4501454259698221, 25.809203561812719, 5.3708427470592142, 25.171096507592949, 6.4920879994788265, 24.988780206387268, 6.9478787524894869, 24.760884829880212, 7.7774179229782021, 24.56945271361429, 8.7983892097290664, 24.423599672649772, 10.029024242860032, 24.323325706986651, 11.460207207328494, 24.25951500156469, 13.091938103119901, 24.24128337144413, 14.933332745298685, 24.24128337144413, 50.330042624369526, 24.38713641240864, 50.512358925581793, 25.143749062412098, 51.360129726181185, 25.95505660277723, 52.1896688966699, 26.830174848564351, 53.000976437040663, 27.778219614833748, 53.784936532221764, 24.24128337144413, 53.93078957319085, 24.24128337144413, 67.987376396140462],
     ],

110: [ [28.67034129464831, 59.225769464301266, 27.478304342688421, 58.033732512340066, 26.286267390728501, 56.76850030893911, 25.083773974277719, 55.419616389619478, 23.88128055782694, 53.997537218860089, 11.47991367164756, 53.934798431910167, 11.574021852065449, 53.317867026951717, 11.657673567992459, 52.523175725651527, 11.74132528391949, 51.540268063508847, 11.804064070864751, 50.369144040530955, 11.85634639331913, 49.009803656721488, 11.908628715773499, 47.472703376548452, 11.93999810924613, 45.736930271068559, 11.96091103822787, 43.823397269239649, 11.98182396720965, 41.721647906568251, 11.98182396720965, 39.44213864755875, 11.98182396720965, 14.921729416459129, 11.950454573737019, 12.997739950129471, 11.845889928828241, 11.209684522189491, 11.668130032483351, 9.6203019195781962, 11.42763134919319, 8.2295921422992251, 11.10348094997603, 7.027098725840915, 10.716591763813611, 6.0128216702287318, 10.25650732621504, 5.1972174399415962, 9.9428133914887411, 4.7894153248016664, 9.0749268387460091, 3.9947240234905621, 7.9874545316948646, 3.3882490830183087, 6.6803964703353378, 2.9490775744015991, 5.1537526546673709, 2.6876659621302679, 3.4075230846910212, 2.5935577817108424, 1.9645309849500869, 2.5935577817108424, 1.9645309849500869, 0.00035458796992315911, 34.620069589956969, 0.00035458796992315911, 34.620069589956969, 2.5935577817108424, 34.505048480557342, 2.5935577817108424, 32.518320227290801, 2.6458401041709294, 30.834829444259711, 2.7608612135700241, 29.423206737991411, 2.9699905033885443, 28.30436503746764, 3.2523150446395448, 27.478304342688421, 3.6078348373303015, 26.401288500128128, 4.3293308872016496, 25.449750231458399, 5.3540644073000294, 24.665515394642672, 6.6402095396806544, 24.466842569316029, 7.1734892287204275, 24.257713279498478, 8.1145710329001304, 24.090409847644469, 9.358890307310503, 23.975388738244831, 10.916903516448656, 23.902193486808692, 12.767697731338558, 23.88128055782694, 14.921729416459129, 23.88128055782694, 49.752212635561591, 24.132235705607979, 50.034537176819867, 25.334729122058761, 51.27885645123024, 26.526766074018649, 52.439524009718298, 27.729259490469431, 53.506083387790568, 28.93175290692021, 54.478534585439775, 30.12378985888013, 55.367334067170304, 31.326283275330908, 56.15156890398066, 32.528776691781687, 56.852152024868701, 33.731270108232458, 57.44817050085112, 34.933763524683243, 57.96053726090031, 36.136256941134022, 58.378795840540988, 37.338750357584829, 58.702946239751327, 38.551700238526472, 58.932988458549517, 39.75419365497725, 59.079378961429029, 40.95668707142805, 59.121204819388367, 28.67034129464831, 59.225769464301266],
       [0.8875151423898302, 59.915896120699472, 1.9645309849500869, 57.322692926958553, 2.6755705703296679, 57.584104539229884, 4.181301457015862, 58.033732512340066, 5.5615547698115639, 58.305600589101232, 6.7954175797349734, 58.399708769520657, 0.8875151423898302, 59.915896120699472],
       [46.007159420521319, 67.988286707648513, 45.808486595194672, 67.988286707648513, 44.710557823652643, 67.93600438519934, 43.602172587619762, 67.81052681131041, 42.483330887095988, 67.601397521488252, 41.364489186572207, 67.329529444730724, 40.245647486048441, 66.974009652039967, 39.116349321033809, 66.53483814341962, 37.976594691528263, 66.032927847860265, 36.836840062022752, 65.447365836371318, 35.686628968026341, 64.788608573449892, 34.525961409539079, 64.046199594591599, 33.375750315542682, 63.241051828801574, 32.204626292564527, 62.352252347071044, 31.033502269586378, 61.390257613911672, 29.851921782117351, 60.344611164829985, 28.67034129464831, 59.225769464301266, 40.95668707142805, 59.121204819388367, 42.138267558897049, 59.068922496939194, 43.61262905211062, 58.84933674263084, 44.951056506942798, 58.451991091980744, 46.14309345890269, 57.876885544970719, 47.199196372481197, 57.124020101629867, 48.108908783187452, 56.193394761950913, 48.882687155512322, 55.08500952590839, 49.06044705185721, 54.760859126690775, 49.510075024964898, 53.788407929041568, 49.896964211127319, 52.700935621989629, 50.242027539326223, 51.508898670028429, 50.534808545070781, 50.191384144178301, 50.775307228360937, 48.769304973418912, 50.953067124705832, 47.242661157750263, 51.089001163087211, 45.59053976819996, 51.162196414523351, 43.833853733729484, 51.193565807995988, 41.962146589870827, 51.193565807995988, 14.921729416459129, 51.183109343505102, 13.363716207310063, 51.151739950032471, 11.429270276501484, 51.099457627578097, 9.9130829253299453, 51.015805911651093, 8.8256106182816438, 50.900784802251451, 8.1459404263696342, 50.70211197692479, 7.4662702344612626, 50.106093500944837, 6.0964733861583227, 49.33231512862001, 4.9462622921600996, 48.380776859950238, 4.0365498814608145, 47.742932526006769, 3.6287477663099708, 46.645003754464767, 3.1791197931997885, 45.306576299632589, 2.8549693939785357, 43.727650161510283, 2.6667530331505986, 41.897768875606893, 2.5935577817108424, 40.527972027302113, 2.5935577817108424, 40.527972027302113, 0.00035458796992315911, 73.173054167818094, 0.00035458796992315911, 73.173054167818094, 2.5935577817108424, 71.970560751367316, 2.6144707107014256, 70.224331181390966, 2.7190353555997717, 68.760426152668245, 2.9177081809284573, 67.578845665199225, 3.2209456511700409, 66.690046183474749, 3.6078348373303015, 65.801246701750244, 4.2038533133090823, 64.807882575116992, 5.2076739044314309, 64.096842989737411, 6.4206237853686616, 63.793605519502002, 7.2466844801492698, 63.54265037172096, 8.3341567872084852, 63.343977546394321, 9.6412148485615035, 63.197587043522063, 11.178315128719987, 63.113935327595023, 12.935001163190464, 63.082565934122421, 14.921729416459129, 63.082565934122421, 43.112357683861774, 63.082565934122421, 43.656093837391381, 63.051196540649791, 45.496431587780535, 62.98845775370453, 47.232204693260428, 62.883893108795753, 48.863413153838337, 62.747959070414367, 50.37960050502079, 62.570199174069479, 51.791223211290344, 62.361069884251918, 53.098281272639724, 62.110114736470912, 54.300774689101672, 61.82779019521724, 55.398703460628894, 61.50363979600008, 56.38161112277885, 61.054011822892399, 57.500452823300293, 60.395254559967192, 58.964357852029934, 59.684214974587583, 60.313241771349567, 58.910436602262742, 61.547104581281019, 58.084375907483498, 62.665946281798824, 57.216489354740759, 63.669766872921173, 56.285864015052773, 64.548109890150954, 55.3029563529104, 65.321888262478751, 54.299135761786268, 65.949276131930674, 53.07572941635371, 66.576664001389872, 51.789584283975927, 67.078574296938314, 50.440700364652891, 67.475919947599323, 49.029077658384587, 67.758244488850323, 47.544259700680129, 67.93600438519934, 46.007159420521319, 67.988286707648513],
       [23.88128055782694, 67.988286707648513, 20.775710604036661, 67.988286707648513, 0.8875151423898302, 59.915896120699472, 6.7954175797349734, 58.399708769520657, 7.2345890883517683, 58.389252305030823, 8.6671247236018445, 58.106927763779822, 9.8277922820891064, 57.458626965340954, 10.381984900105561, 56.810326166909363, 10.998916305067249, 55.586919821471383, 11.47991367164756, 53.934798431910167, 23.88128055782694, 53.997537218860089, 23.88128055782694, 67.988286707648513],
     ],

111: [ [20.735277918511741, 63.359905980789335, 19.68744073208299, 62.66775664663146, 18.668443101244041, 61.927541386488883, 17.67828502599485, 61.139260200368881, 16.726579691532059, 60.293299903070874, 15.80371391265902, 59.408886864988744, 14.909687689375801, 58.466794715721335, 14.04450102168232, 57.467023455268645, 13.21776709477524, 56.428799454039108, 12.419872723457949, 55.332896341631567, 11.65081790773044, 54.198540488428989, 10.91060264759269, 53.006505524048407, 10.20884012824135, 51.766404633690399, 9.5359171644797698, 50.46862463215075, 9.4590116829070041, 50.324426854200283, 8.8437678303249925, 49.045873223050876, 8.2765899037259487, 47.767319591908745, 7.7478647179132727, 46.488765960759338, 7.2768186432801647, 45.210212329609931, 6.8442253094334538, 43.931658698471438, 6.450084716373083, 42.643491882128728, 6.1136232344923078, 41.364938250979321, 5.8156144933979022, 40.086384619829914, 5.5656716782864351, 38.798217803490843, 5.3541816039613934, 37.519664172341436, 5.2003706408158896, 36.231497355998727, 5.0850124184567562, 34.943330539648741, 5.0177201220805889, 33.664776908510248, 4.9888805664908196, 32.376610092160263, 4.9984937516873913, 32.078601351069665, 5.0273333072771891, 30.713529053151433, 5.1042387888499263, 29.377296310831298, 5.229210196405659, 28.041063568500249, 5.392634344747762, 26.733670381760021, 5.6041244190728321, 25.426277195019793, 5.8540672341842699, 24.1477235638813, 6.1616891604752757, 22.878783117928833, 6.507763827552651, 21.619455857169669, 6.8922912354164216, 20.379354966811661, 7.3248845692631326, 19.158480446840258, 7.8055438290928398, 17.947219112069433, 8.3342690149055159, 16.745570962499187, 8.9014469415045596, 15.563149183319183, 9.5166907940865713, 14.399953774529422, 10.17038738745495, 13.246371550940239, 10.872149906806319, 12.112015697741299, 11.621978352140641, 10.987273029739299, 12.419872723457949, 9.8817567321311799, 12.6505891681762, 9.5645216206394252, 13.506162650673071, 8.487844878629403, 14.38096250356312, 7.4592340625895304, 15.27498872684637, 6.4883023577385757, 16.20746769091599, 5.575049764058349, 17.15917302537877, 4.7098630963591859, 18.149331100627961, 3.8927423546483624, 19.15871554627034, 3.1333007241191808, 20.187326362305889, 2.4219250195783388, 21.254389919127821, 1.7682284262082248, 22.35029303153954, 1.1625977588191745, 23.465422514344422, 0.60503301741846371, 24.609391552739108, 0.11476057238905923, 25.782200146723572, -0.33705913184894598, 26.983848296297818, -0.73119972490894725, 28.204722816265271, -1.0676612067909446, 29.454436891822471, -1.3560567626882403, 30.742603708166062, -1.5963863926008344, 32.049996894902847, -1.7790369113390625, 33.376616452032813, -1.913621504088951, 34.741688749949162, -1.9905269856608356, 36.125987418258688, -2.0193665412516566, 36.366317048173563, -2.0193665412516566, 37.741002531286483, -1.9809138004602573, 39.106074829202839, -1.8943951336914324, 40.442307571529398, -1.7501973557482415, 41.75931394346275, -1.5483204666197707, 43.066707130199539, -1.3079908366999007, 44.345260761346537, -1.0003689104087243, 45.604588022100351, -0.64468105814012233, 46.844688912460981, -0.24092727987954277, 48.075176617624997, 0.22050560955176479, 49.276824767199258, 0.73961761016835226, 50.468859731576913, 1.3067955367696413, 51.632055140364763, 1.9220393893483561, 52.776024178759457, 2.5949623531087127, 39.231046236758537, 3.1044611685283598, 39.134914384792609, 3.1044611685283598, 37.904426679628592, 3.1525270945203374, 36.72200490044753, 3.2967248724598903, 35.558809491659652, 3.5370545023797604, 34.434066823658164, 3.8639027990611794, 33.338163711246438, 4.2868829477192776, 32.271100154424524, 4.8059949483285891, 31.242489338388971, 5.4020124305206991, 30.242718077943181, 6.1037749498682388, 29.281399558283798, 6.8920561359882413, 28.348920594214182, 7.776469174081285, 27.445281185734331, 8.7474008789286017, 26.58009451804088, 9.8144644357598736, 25.743747405937199, 10.96804665934178, 24.93623984942332, 12.21776073491128, 24.167185033695802, 13.553993477231415, 23.946081774174129, 13.957747255488357, 23.378903847575089, 15.063263553100114, 22.840565476565811, 16.178393035901536, 22.331066661146341, 17.32236207429014, 21.86002058651323, 18.475944297890237, 21.40820088227332, 19.658366077070241, 20.994833918819779, 20.860014226640487, 20.610306510956011, 22.090501931808831, 20.25461865868203, 23.330602822170476, 19.937383547194429, 24.599543268108391, 19.639374806100019, 25.887710084458377, 19.379818805791981, 27.195103271198604, 19.149102361073741, 28.531336013518739, 18.956838657141841, 29.877181941050367, 18.783801323603171, 31.251867424158263, 18.649216730850839, 32.645779277670954, 18.533858508491729, 34.058917501570249, 18.456953026918971, 35.491282095859788, 18.418500286132598, 36.952486245740147, 18.3992739157394, 38.432916766010749, 18.3992739157394, 38.673246395930619, 18.428113471329201, 40.249808768170624, 18.485792582508761, 41.759078844039323, 18.5915376196713, 43.22989617912026, 18.726122212423601, 44.643034403008642, 18.90877273115888, 45.998493515729933, 19.12026280548395, 47.305886702470161, 19.379818805791981, 48.565213963218412, 19.66821436168982, 49.766862112799572, 20.004675843570599, 50.920444336388755, 20.369976881041168, 52.016347448799934, 20.77373065929811, 53.064184635240963, 21.292842659914189, 54.217766858819232, 21.965765623675761, 55.52516004555946, 22.686754513420311, 56.726808195129706, 23.455809329147829, 57.822711307540885, 24.282543256054911, 58.793643012399116, 25.157343108944961, 59.668442865291581, 26.080208887817999, 60.418271310631098, 27.051140592673988, 61.071967903990299, 27.118432889050151, 61.110420644781698, 28.377760149803951, 61.783343608538416, 29.637087410557768, 62.331295164749463, 30.90602785650816, 62.754275313400285, 32.165355117261981, 63.061897239691461, 33.424682378015802, 63.24454775842969, 34.684009638769588, 63.302226869600418, 20.735277918511741, 63.359905980789335],
       [36.923881789576001, 67.983848060350283, 36.558580752105428, 67.983848060350283, 35.222348009778869, 67.945395319558884, 33.905341637845481, 67.839650282399816, 32.597948451108721, 67.685839319248771, 31.309781634765098, 67.474349244930636, 30.021614818421511, 67.205180059419945, 28.75267437247112, 66.878331762738526, 27.483733926520699, 66.493804354879103, 26.234019850963509, 66.051597835830762, 25.003532145799451, 65.561325390801358, 23.773044440635431, 65.003760649400647, 22.56178310586461, 64.398129982018872, 21.35052177109376, 63.734820203451818, 20.735277918511741, 63.359905980789335, 34.684009638769588, 63.302226869600418, 35.808752306771083, 63.263774128819932, 37.087305937918103, 63.138802721259708, 38.337020013475318, 62.898473091350752, 39.53866816304955, 62.571624794658419, 40.701863571837428, 62.148644646018511, 41.826606239838917, 61.619919460201345, 42.912896167054043, 60.995062422418414, 43.960733353482787, 60.264460347480053, 44.960504613928542, 59.44733960576923, 45.921823133587957, 58.524473826899339, 46.854302097657573, 57.495863010859466, 47.729101950547623, 56.380733528061683, 47.777167876530591, 56.323054416880041, 48.450090840292177, 55.390575452809571, 49.08456106326738, 54.429256933148281, 49.690191730652799, 53.429485672699229, 50.266982842448442, 52.410488041859935, 50.805321213457681, 51.353037670240155, 51.324433214073757, 50.266747743018641, 51.805092473903471, 49.151618260220857, 52.256912178143381, 47.998036036631675, 52.670279141596922, 46.825227442641335, 53.064419734657292, 45.61396610787051, 53.420107586931273, 44.373865217508865, 53.746955883615442, 43.104924771560036, 54.04496462470987, 41.797531584830722, 54.304520625017922, 40.470912027689337, 54.535237069736162, 39.105839729778381, 54.737113958864619, 37.711927876269328, 54.910151292403327, 36.27956328197979, 55.054349070352231, 34.827972317289095, 55.160094107514759, 33.337928611821553, 55.236999589087532, 31.82865853596013, 55.285065515070492, 30.271322534110368, 55.30429188546367, 28.694760161870363, 55.294678700267099, 27.570017493861087, 55.256225959480702, 25.849257343681529, 55.169707292711358, 24.195789489858726, 55.054349070352231, 22.60961393242178, 54.900538107206728, 21.090730671359779, 54.708274403274856, 19.639139706679998, 54.487171143753187, 18.25484103836061, 54.21800195824855, 16.947447851631296, 53.919993217154143, 15.697733776069072, 53.573918550076762, 14.515311996889068, 53.199004327409597, 13.409795699280949, 52.785637363956049, 12.361958512861747, 52.333817659716139, 11.391026807999879, 51.84354521468984, 10.477774214319652, 51.324433214073757, 9.6414271022185858, 50.75725528747472, 8.8723722864888259, 50.497699287166682, 8.5455239898001309, 49.584446693490257, 7.5169131737711723, 48.613514988634272, 6.5844342097007029, 47.604130542991889, 5.7673134679898794, 46.546680171366567, 5.0655509486387018, 45.441163873758249, 4.4599202812605654, 44.29719483536357, 3.9696478362311609, 43.095546685789323, 3.5947336135614023, 41.855445795428693, 3.3255644280507113, 40.567278979085103, 3.1621402797100018, 39.231046236758537, 3.1044611685283598, 52.776024178759457, 2.5949623531087127, 53.583531735273368, 3.1140743537289381, 54.62175573650552, 3.8446764286709367, 55.621526996951268, 4.623344429590361, 56.59245870180726, 5.4500783565017628, 57.534550851073469, 6.3248782093905902, 58.438190259553323, 7.2381308030708169, 59.303376927246767, 8.2090625079290476, 60.139724039350462, 9.2184469535714015, 60.947231595864331, 10.285510510391759, 61.716286411591852, 11.391026807999879, 62.446888486532998, 12.544609031589061, 63.148651005884382, 13.746257181159308, 63.821573969645947, 14.995971256721532, 64.456044192621135, 16.293751258261182, 65.003995748827009, 17.505012593028368, 65.551947305032854, 18.802792594571656, 66.051832935255732, 20.100572596111306, 66.51326582469224, 21.398352597650955, 66.926632788145781, 22.696132599190605, 67.301547010812953, 23.98429941554059, 67.628395307497144, 25.28207941708024, 67.916790863394965, 26.570246233419311, 68.157120493309833, 27.848799864561443, 68.358997382438304, 29.136966680911428, 68.512808345583807, 30.415520312060835, 68.618553382746342, 31.694073943199328, 68.68584567912248, 32.972627574348735, 68.705072049515678, 34.25118120550178, 68.705072049515678, 34.597255872569804, 68.66661930872931, 35.962328170491674, 68.589713827156544, 37.317787283209327, 68.464742419600839, 38.654020025540376, 68.291705086062137, 39.971026397470268, 68.070601826540468, 41.268806399009918, 67.801432641035845, 42.556973215359903, 67.493810714744853, 43.816300476111792, 67.12850967727428, 45.066014551670378, 66.72475589901731, 46.296502256831445, 66.272936194777401, 47.507763591598632, 65.773050564554524, 48.709411741179792, 65.234712193545249, 49.882220335159218, 64.638694711356436, 51.045415743948979, 64.004224488381226, 52.189384782341222, 63.321688339423041, 53.323740635540162, 62.591086264481902, 54.429256933148281, 61.812418263557788, 55.52516004555946, 60.995297521847299, 56.601836787580396, 60.793420632718842, 56.85177960268993, 59.918620779828792, 57.880390418729803, 59.014981371348973, 58.870548493978276, 58.09211559247592, 59.803027458048746, 57.140410258013127, 60.687440496130876, 56.159865367960549, 61.523787608228304, 55.150480922318167, 62.302455609158642, 54.121870106282621, 63.03305768410064, 53.064419734657292, 63.715593833061575, 51.978129807442173, 64.350064056030533, 50.863000324637248, 64.936468353029341, 49.728644471439161, 65.46519353883923, 48.565449062651311, 65.945852798671694, 47.383027283470248, 66.368832947318879, 46.162152763502803, 66.753360355178302, 44.922051873142181, 67.080208651870635, 43.653111427191782, 67.35899102257099, 42.364944610848191, 67.580094282089703, 41.038325053718211, 67.76274480083157, 39.69247912619506, 67.88771620838088, 38.317793643082133, 67.964621689949126, 36.923881789576001, 67.983848060350283],
     ],

112: [ [30.020710119663249, 4.1519755001208978, 22.436351989508179, 3.8238061579504574, 22.60955247565354, 3.6688373019205756, 23.758145173249151, 2.6843292754092545, 24.861158795543329, 1.8183268446882721, 25.93682497265667, 1.0708300097503525, 26.966912074468581, 0.43272295552014839, 27.96053591603939, -0.095994317969598342, 28.917696497369061, -0.49709018063003896, 29.31879236002149, -0.65205903664900688, 30.421805982315671, -1.0166916390589904, 31.579514494971569, -1.3175135360506829, 32.782802082928868, -1.5727563577383989, 34.04990037630813, -1.764188474000548, 35.362577744988812, -1.9009256999088393, 36.729950004031188, -1.9920838505095162, 38.142901338374998, -2.0194312956882641, 38.817471652835913, -2.0103154806311068, 40.121033206456303, -1.955620590269973, 41.39724731489585, -1.8462308095513436, 42.646113978154567, -1.6821461384606664, 43.867633196232411, -1.4724823920805648, 45.070920784189717, -1.2081237553284154, 46.24686092696615, -0.87995441316161305, 47.40456943962203, -0.50620599567992031, 48.525814692036789, -0.077762687851645751, 49.637944129391258, 0.40537551034140051, 50.71361030650462, 0.9340927838384232, 51.771044853497379, 1.5266207627610129, 52.801131955309302, 2.164727816980303, 37.933237591988501, 2.3105808579384757, 37.340709613070118, 2.319696672999271, 35.973337354027741, 2.4017390085500665, 34.669775800407344, 2.574939494690625, 33.420909137148641, 2.8301823163783411, 32.226737364251619, 3.1856991037311673, 31.09637629677659, 3.6232582266202371, 30.020710119663249, 4.1519755001208978],
       [26.483773876273631, 58.34549603350024, 25.672466335908471, 57.260714041331084, 24.861158795543329, 56.112121343729086, 24.049851255178201, 54.89060212565164, 23.23854371481303, 53.614388017209421, 22.436351989508179, 52.274363203348912, 26.119141273862311, 51.845919895520638, 27.140112560613971, 52.812196291910368, 28.079041511823078, 53.659967092520674, 28.935928127489628, 54.389232297340641, 29.710772407613629, 54.981760276259593, 30.403574352195111, 55.455782659388206, 31.01433396123403, 55.802183631680236, 31.752714981116931, 56.157700419029425, 32.965118384134513, 56.659070247351337, 34.177521787152081, 57.041934479879274, 35.399041005229947, 57.31540893168858, 36.629676038368082, 57.479493602768343, 37.860311071506231, 57.534188493129477, 26.483773876273631, 58.34549603350024],
       [-0.62666011300663627, 59.484972916041443, 0.23934231772020101, 57.178671705780289, 1.0415340430250519, 57.461261972650391, 2.3906746719468681, 57.862357835299917, 3.5848464448438899, 58.108484841930476, 4.6331651767763731, 58.181411362420477, -0.62666011300663627, 59.484972916041443],
       [22.436351989508179, 67.698322285348695, 19.692491656363131, 67.698322285348695, -0.62666011300663627, 59.484972916041443, 4.6331651767763731, 58.181411362420477, 5.8546843948542451, 58.108484841930476, 7.0762036129320904, 57.816778759999579, 8.0880590846234668, 57.31540893168858, 8.5894289129389847, 56.905197253970982, 9.346041562942446, 55.948036672649323, 9.8929904665594108, 54.726517454568238, 9.9659169870416502, 54.489506262998475, 10.120885843066469, 53.742009428060555, 10.24850725391042, 52.76661721661003, 10.34878121957354, 51.563329628650536, 10.412591924995491, 50.123030849128554, 10.458171000296909, 48.463952508151124, 10.4672868153572, 46.576978790668363, 10.4672868153572, -15.857238557200617, 10.4672868153572, -15.966628337919246, 10.458171000296909, -17.890065315648826, 10.412591924995491, -19.585606916858524, 10.33966540451325, -21.071484771680844, 10.230275623789851, -22.329467250001471, 10.1026542129459, -23.377785981938359, 9.9385695418608009, -24.198209337359003, 9.7471374255948717, -24.79985313133875, 9.2913466725807439, -25.684087192181323, 8.5165023924567436, -26.677711033749802, 7.5866892563079196, -27.388744608459092, 7.0215087225703883, -27.689566505450784, 5.9367267303967699, -28.145357258461445, 4.7699024026806276, -28.500874045810633, 3.5210357394219041, -28.747001052441192, 2.2083583707412231, -28.874622463288688, 0.81363866651798844, -28.911085723520955, -0.99129271541795561, -28.911085723520955, -0.99129271541795561, -31.572903721131297, 33.603225438354293, -31.572903721131297, 33.603225438354293, -28.911085723520955, 31.96237872750342, -28.883738278338569, 30.430921797375959, -28.79258012774153, 29.081781168454139, -28.637611271718924, 27.924072655798248, -28.427947525331547, 26.95779625940833, -28.154473073518602, 26.182951979284301, -27.8263037313518, 25.754508671451021, -27.589292539789312, 24.706189939518541, -26.823564074718888, 23.885766584093091, -25.921098383758363, 23.302354420235019, -24.872779651821475, 23.11092230396909, -24.371409823510476, 22.90125855758259, -23.569218098200508, 22.737173886497491, -22.539130996388849, 22.60043666059326, -21.299380148189812, 22.50927850999042, -19.840849738549878, 22.45458361962875, -18.172655582511652, 22.436351989508179, -16.285681865039805, 22.436351989508179, 3.8238061579504574, 30.020710119663249, 4.1519755001208978, 29.00885464797188, 4.7718509242185974, 28.060809881702511, 5.4828844989206118, 27.86026195037627, 5.646969170000375, 26.830174848564351, 6.5585506760289718, 25.918593342536099, 7.5065954423007497, 25.125517432291531, 8.4911034688084328, 24.441831302770339, 9.5211905706200923, 23.87665076903281, 10.587740932678571, 23.420860016018679, 11.690754554980231, 23.083574858788239, 12.839347252571315, 23.047111598547101, 12.994316108601197, 22.90125855758259, 13.732697128471045, 22.773637146738618, 14.626047004381689, 22.67336318107553, 15.674365736318578, 22.59132084553298, 16.895884954388748, 22.518394325050711, 18.272373028499715, 22.472815249749321, 19.803829958618735, 22.445467804568469, 21.499371559839346, 22.436351989508179, 23.358997832139721, 22.436351989508179, 48.017277570201259, 22.573089215412409, 48.172246426220227, 23.840187508791669, 49.521387055148807, 25.02524346662841, 50.742906273218978, 26.119141273862311, 51.845919895520638, 22.436351989508179, 52.274363203348912, 22.436351989508179, 67.698322285348695],
       [43.54857966912251, 67.990028367279592, 43.402726628158007, 67.990028367279592, 42.162975779959588, 67.935333476918458, 40.932340746821431, 67.798596251010167, 39.719937343803878, 67.57981668956927, 38.525765570906849, 67.278994792581216, 37.340709613070118, 66.896130560038728, 36.173885285353947, 66.43122399197091, 35.016176772698088, 65.875159273291501, 33.867584075102492, 65.246168034140283, 32.737223007627449, 64.526018644370197, 32.181158288950201, 64.134038596781465, 31.369850748585069, 63.495931542558537, 30.549427393159618, 62.803129597981751, 29.73811985279449, 62.037401132911327, 28.917696497369061, 61.207861962429888, 28.106388957003901, 60.323627901580039, 27.295081416638769, 59.366467320251104, 26.483773876273631, 58.34549603350024, 37.860311071506231, 57.534188493129477, 38.206712043796962, 57.534188493129477, 39.40999963175426, 57.452146157589596, 40.585939774530708, 57.260714041331084, 41.725416657066027, 56.959892144339392, 42.837546094420503, 56.558796281678951, 43.91321227153383, 56.048310638310795, 44.961531003466312, 55.437551029270253, 45.973386475157689, 54.717401639511081, 46.957894501668193, 53.887862469018728, 47.896823452877292, 52.948933517811383, 48.817520773965832, 51.909730600938929, 49.227732451678548, 51.390129142499063, 49.865839505898322, 50.515010896720923, 50.467483299876989, 49.612545205749484, 51.032663833614492, 48.664500439481344, 51.570496922171181, 47.689108228030818, 52.071866750486691, 46.668136941279954, 52.536773318561103, 45.619818209339428, 52.96521662639438, 44.525920402109477, 53.35719667398655, 43.404675149700779, 53.721829276397841, 42.237850821980828, 54.049998618568019, 41.043679049078492, 54.34170470049704, 39.803928200879454, 54.596947522184962, 38.536829907508945, 54.824842898692019, 37.233268353891617, 55.016275014957962, 35.884127724959399, 55.171243870982771, 34.507639650859346, 55.289749466766438, 33.094688316519751, 55.371791802308991, 31.636157906868903, 55.426486692670657, 30.150280052039307, 55.444718322791232, 28.627938936981081, 55.444718322791232, 28.017179327940539, 55.408255062550118, 26.513069842989353, 55.335328542067863, 25.054539433349419, 55.225938761344452, 23.641588098998909, 55.070969905319657, 22.265100024898857, 54.879537789053728, 20.925075211038347, 54.651642412546657, 19.621513657421019, 54.387283775798458, 18.363531179100391, 54.086461878809132, 17.142011961019307, 53.740060906518409, 15.956956003181404, 53.35719667398655, 14.817479120651114, 52.93786918121355, 13.714465498360369, 52.482078428199429, 12.657030951369961, 51.980708599883883, 11.626943849551026, 51.442875511327202, 10.6515516381005, 50.868579162529421, 9.7035068718287221, 50.257819553490492, 8.8010411808681965, 49.6105966842104, 7.9350387501399382, 48.890447294448109, 7.0872679495296325, 48.006213233600697, 6.1756864435010357, 47.06728428239159, 5.364378903141187, 46.091892070941348, 4.6533453284282587, 45.06180496912944, 4.0334699043305591, 43.995254607076362, 3.5047526308408123, 42.874009354661609, 3.0763093230088998, 41.707185026945467, 2.7390241657813021, 40.494781623927871, 2.5020129742115387, 39.236799145608899, 2.3561599332388141, 37.933237591988501, 2.3105808579384757, 52.801131955309302, 2.164727816980303, 53.803871611940401, 2.8666455766215222, 54.788379638450891, 3.6141424115594418, 55.745540219780558, 4.4163341368584952, 56.675353355929388, 5.2732207525295962, 57.586934861957637, 6.1756864435010357, 58.471168922805049, 7.1419628398907662, 58.781106634854659, 7.4883638121791591, 59.555950914978659, 8.4272927633901418, 60.29433193486156, 9.384453344719077, 61.005365509563603, 10.350729741108808, 61.679935824024511, 11.344353582680924, 62.318042878244277, 12.365324869431788, 62.9288024872832, 13.395411971250724, 63.512214651141278, 14.452846518241131, 64.050047739697959, 15.519396880288696, 64.560533383073775, 16.61329468752956, 65.043671581268754, 17.725424124881101, 65.490346519222584, 18.864901007418666, 65.900558196935307, 20.013493705009751, 66.28342242946718, 21.189433847790497, 66.629823401757903, 22.383605620689195, 66.939761113807521, 23.596009023698571, 67.222351380676287, 24.826644056840451, 67.468478387303904, 26.075510720100283, 67.678142133690415, 27.351724828538863, 67.86045843489606, 28.646170567099034, 68.006311475860585, 29.958847935780796, 68.124817071644259, 31.28975693458051, 68.206859407186784, 32.638897563501814, 68.261554297548486, 34.006269822541071, 68.270670112608769, 35.400989526759076, 68.270670112608769, 35.747390499058383, 68.243322667427933, 37.169457648458774, 68.179511962005947, 38.564177352691331, 68.088353811403124, 39.931549611730588, 67.951616585498883, 41.271574425591098, 67.778416099353521, 42.593367609330016, 67.568752352967024, 43.887813347890187, 67.331741161399677, 45.15491164127161, 67.049150894530911, 46.394662489470647, 66.730097367421024, 47.607065892490937, 66.383696395130286, 48.801237665378721, 65.991716347538144, 49.958946178041515, 65.572388854765137, 51.098423060571804, 65.10748228669074, 52.219668312991416, 64.615228273435477, 53.304450305160572, 64.07739518487881, 54.361884852158255, 63.512214651141278, 55.40108776903071, 62.910570857162639, 56.412943240720779, 62.272463802942859, 57.397451267228462, 61.588777673421667, 58.363727663618192, 60.877744098719631, 59.29354079976838, 60.130247263776447, 60.205122305800614, 59.911467702329666, 60.451249312420259, 59.018117826421978, 61.426641523881699, 58.106536320393751, 62.329107214838587, 57.158491554124367, 63.167762200391735, 56.173983527613842, 63.933490665451245, 55.171243870982771, 64.644524240160536, 54.141156769170827, 65.273515479311754, 53.074606407117777, 65.847811828109116, 51.989824414944167, 66.349181656431028, 50.868579162529421, 66.786740779320098, 49.719986464933811, 67.151373381730082, 48.544046322157357, 67.452195278721774, 47.34075873420008, 67.689206470291538, 46.101007886001632, 67.853291141378577, 44.84302540768266, 67.953565107040049, 43.54857966912251, 67.990028367279592],
     ],

113: [ [47.450148514916549, 12.001556570969115, 46.520335378767747, 11.244943920959486, 45.581406427558669, 10.588605236618605, 44.633361661289307, 10.023424702878401, 44.396350469721988, 9.8958032920381811, 43.302452662488122, 9.3670860185411584, 42.153859964892547, 8.9295268956484506, 40.950572376935298, 8.5831259233600576, 39.701705713676631, 8.3461147317902942, 38.407259975116538, 8.2002616908284836, 37.06723516125507, 8.1546826155317831, 48.088255569136287, 7.9632504992587201, 49.100111040827613, 9.0662641215494659, 50.139313957699777, 10.233088449269417, 51.19674850469255, 11.463723482411297, 47.450148514916549, 12.001556570969115],
       [21.725318414800061, 63.168626504331769, 20.69523131298817, 62.494056189858384, 19.683375841296851, 61.764790985049331, 18.680636184665779, 60.989946704921749, 17.705243973215602, 60.178639164550987, 16.738967576825669, 59.3217525488908, 15.79092281055634, 58.410171042858565, 14.870225489467821, 57.462126276590425, 14.15919191476581, 56.687281996470119, 13.375231819581529, 55.775700490441523, 12.62773498463838, 54.83677153923054, 11.90758559487611, 53.870495142840809, 11.22389946535492, 52.885987116329488, 10.57667659607489, 51.883247459700215, 9.9659169870359676, 50.853160357888555, 9.3916206382382086, 49.804841625958943, 8.8537875496815541, 48.738291263900464, 8.3433019063057543, 47.644393456670514, 7.8692795231710591, 46.532264019311697, 7.4408362153378098, 45.392787136781408, 7.0306245376251013, 44.235078624118614, 6.6659919352138104, 43.059138481348782, 6.3378225930436543, 41.855850893389288, 6.0370006960543492, 40.634331675308204, 5.7726420593061496, 39.394580827109166, 5.5538624978593703, 38.127482533731381, 5.3533145665331574, 36.833036795171211, 5.198345710508363, 35.529475241550244, 5.0798401147247034, 34.189450427689735, 4.9886819641218656, 32.84030979876843, 4.9431028888204764, 31.463821724668378, 4.924871258699909, 30.069102020439459, 4.9431028888204764, 28.628803240921116, 4.9977977791821502, 27.206736091509811, 5.0889559297849871, 25.821132202348963, 5.2256931556892141, 24.462875758370501, 5.3897778267742922, 23.131966759570787, 5.5994415731607878, 21.828405205949821, 5.84556857978842, 20.552191097511241, 6.1281588466571568, 19.312440249308565, 6.456328188827313, 18.100036846288276, 6.8118449761783211, 16.914980888461287, 7.2129408388307459, 15.757272375798493, 7.6413841466640227, 14.636027123389795, 8.1154065297986904, 13.54212931614893, 8.6258921731744902, 12.475578954101366, 9.1728410767914283, 11.445491852289706, 9.7653690557097832, 10.433636380588723, 10.385244479808961, 9.4582441691491113, 11.05069897920955, 8.5101994028809713, 11.75261673885128, 7.5986178968487366, 12.490997758734149, 6.7052680209417304, 13.384347634641809, 5.7025283643088187, 14.350624031031741, 4.7089045227403403, 15.335132057542211, 3.779091386590153, 16.328755899112991, 2.922204770919052, 17.340611370804311, 2.1382446757415892, 18.370698472616201, 1.4180952859715035, 19.419017204548648, 0.76175660164153669, 20.47645175154139, 0.17834443777974229, 21.561233743714979, -0.3321412055993278, 22.655131550948848, -0.77881614354919293, 23.767260988303288, -1.161680376080767, 24.897622055778271, -1.4625022730688215, 26.037098938313559, -1.7086292796993803, 27.194807450969421, -1.8818297658399388, 28.379863408806099, -1.9821037315086869, 29.574035181703071, -2.0185669917482301, 30.11186827025972, -2.0094511766910728, 31.3516191184581, -1.9274088411511912, 32.582254151596203, -1.7724399851213093, 33.794657554613742, -1.5354287935588218, 35.007060957631303, -1.2163752664491767, 36.201232730528261, -0.81527940378873609, 37.386288688364949, -0.3321412055993278, 38.562228831141368, 0.22392351308008074, 39.729053158857482, 0.87114638236016617, 39.96606435042483, 0.99876779320038622, 40.777371890789937, 1.5092534365794563, 41.616026876335887, 2.0926656004412507, 42.472913492002448, 2.7307726546605409, 43.357147552849817, 3.43269041430176, 44.259613243817761, 4.2075346944184275, 45.18031056490625, 5.046189679971576, 46.128355331175612, 5.9577711860001727, 47.094631727565542, 6.9240475823899033, 48.088255569136287, 7.9632504992587201, 37.06723516125507, 8.1546826155317831, 36.93049793535085, 8.1546826155317831, 35.681631272092183, 8.2002616908284836, 34.469227869074643, 8.3278831016687036, 33.27505609617765, 8.5375468480597192, 32.11734758352182, 8.8292529299906164, 30.977870700986529, 9.2030013474613952, 29.874857078692369, 9.6496762854112603, 28.799190901579099, 10.187509373969078, 27.750872169646609, 10.798268982998707, 26.729900882895009, 11.491070927590044, 25.745392856384541, 12.265915207721264, 24.779116459994611, 13.122801823381451, 23.84930332384582, 14.052614959531638, 22.937721817817589, 15.073586246278865, 22.837447852154501, 15.192091842058289, 22.171993352753901, 16.030746827611438, 21.552117928654699, 16.905865073400491, 20.968705764796649, 17.826562394489883, 20.43087267624, 18.792838790879614, 19.92038703286417, 19.804694262569683, 19.46459627985007, 20.86212880956009, 19.03615297201679, 21.956026616790041, 18.65328873948496, 23.095503499331244, 18.316003582254488, 24.280559457169147, 18.01518168526519, 25.511194490300113, 17.75082304851702, 26.778292783681536, 17.53204348707024, 28.100085967420455, 17.349727185864591, 29.458342411409831, 17.21298995996036, 30.862177930688631, 17.11271599429724, 32.302476710210613, 17.048905288875289, 33.797470380101004, 17.030673658754719, 35.328927310230938, 17.030673658754719, 36.103771590351244, 17.06713691899586, 37.644344335538335, 17.149179254538382, 39.148453820478608, 17.258569035261761, 40.59786841506866, 17.41353789128658, 42.001703934351099, 17.595854192492219, 43.369076193390356, 17.823749568999261, 44.681753562079393, 18.08810820574746, 45.948851855449902, 18.388930102736762, 47.170371073538263, 18.726215259967201, 48.346311216311733, 19.09996367743878, 49.476672283788503, 19.519291170211769, 50.561454275961296, 19.965966108165588, 51.600657192830113, 20.458220121420819, 52.594281034398591, 20.986937394917192, 53.533209985609574, 21.552117928654699, 54.435675676581013, 22.15376172263333, 55.283446477180405, 22.791868776853079, 56.094754017551168, 23.58494468709765, 56.988103893461812, 24.514757823246441, 57.936148659729952, 25.481034219636339, 58.80215109045821, 26.465542246146839, 59.595227000700106, 27.486513532898439, 60.297144760341325, 28.5348322648309, 60.917020184439025, 29.601382626883922, 61.454853273000481, 30.704396249178082, 61.910644026011141, 31.834757316653061, 62.284392443478282, 32.992465829308912, 62.566982710348384, 34.177521787145601, 62.7766464567394, 35.389925190163133, 62.90426786757962, 36.629676038361509, 62.940731127819163, 21.725318414800061, 63.168626504331769],
       [63.083771343300583, 67.990892671219626, 60.631617092084639, 67.990892671219626, 60.403721715577603, 67.835923815200658, 59.337171353524582, 67.134006055548525, 58.252389361350993, 66.450319926028897, 57.15849155411712, 65.793981241691654, 56.04636211676268, 65.155874187468726, 54.925116864347991, 64.535998763371026, 53.785639981812693, 63.943470784448436, 52.637047284217111, 63.378290250719147, 21.725318414800061, 63.168626504331769, 36.629676038361509, 62.940731127819163, 37.614184064872013, 62.913383682640415, 38.908629803432092, 62.79487808686099, 40.166612281751043, 62.585214340469975, 41.379015684768568, 62.275276628421125, 42.554955827544973, 61.874180765771598, 43.68531689501998, 61.372810937460599, 44.779214702253853, 60.780282958530734, 45.781954358884882, 60.123944274189853, 46.84850472093791, 59.312636733830004, 47.778317857086698, 58.446634303101746, 48.589625397451812, 57.525936982008716, 49.264195711912691, 56.55054477055819, 49.820260430589911, 55.520457668750169, 50.130198142639529, 54.745613388629863, 50.458367484809692, 53.706410471761046, 50.722726121557848, 52.566933589219843, 50.923274052884068, 51.327182741020806, 51.078242908908862, 49.987157927160297, 51.160285244451408, 48.546859147638315, 51.19674850469255, 47.006286402451224, 51.19674850469255, 16.012515197489847, 51.169401059511699, 15.985167752311099, 50.248703738423181, 14.845690869769896, 49.318890602274386, 13.797372137840284, 48.389077466125599, 12.849327371568506, 47.450148514916549, 12.001556570969115, 51.19674850469255, 11.463723482411297, 51.19674850469255, -16.941156245429738, 51.187632689632267, -17.469873518930399, 51.160285244451408, -19.192762565318844, 51.078242908908862, -20.724219495448779, 50.959737313125203, -22.055128494248493, 50.786536826979841, -23.194605376778782, 50.576873080593337, -24.124418512928969, 50.330746073965713, -24.871915347881441, 49.692639019745961, -26.111666196080478, 48.917794739621968, -27.077942592470208, 48.024444863714308, -27.752512906921766, 47.140210802866932, -28.153608769578568, 46.064544625753634, -28.481778111749009, 44.83390959261552, -28.718789303311496, 43.439189888392342, -28.855526529219787, 41.89861714320466, -28.910221419580921, 40.52212906910205, -28.910221419580921, 40.52212906910205, -31.572039417180349, 73.822201484313055, -31.572039417180349, 73.822201484313055, -28.910221419580921, 72.536871560813253, -28.89198978945933, 70.932488110203579, -28.819063268980244, 69.546884221040685, -28.682326043079229, 68.380059893324557, -28.481778111749009, 67.422899311994925, -28.217419475000497, 66.68451829211206, -27.898365947890852, 66.49308617584613, -27.788976167168585, 65.444767443913676, -27.041479332219751, 64.596996643307421, -26.148129456309107, 63.949773774027392, -25.081579094261542, 63.831268178243697, -24.79898882739144, 63.603372801736661, -24.033260362328292, 63.411940685470739, -23.048752335820609, 63.275203459566512, -21.845464747861115, 63.165813678843101, -20.432513413521519, 63.102002973421151, -18.791666702669318, 63.083771343300583, -16.941156245429738, 63.083771343300583, 67.990892671219626],
       [38.872166543190957, 67.990892671219626, 38.033511557644999, 67.981776856158831, 36.748181634145197, 67.927081965801335, 35.490199155826247, 67.835923815200658, 34.250448307627863, 67.690070774231572, 33.019813274489763, 67.507754473019304, 31.816525686532518, 67.270743281460454, 30.622353913635521, 66.997268829651148, 29.446413770859131, 66.678215302541503, 28.297821073263549, 66.313582700131519, 27.15834419072829, 65.903371022410283, 26.037098938313559, 65.447580269399623, 24.934085316019409, 64.946210441088624, 23.84930332384582, 64.399261537470011, 22.782752961792799, 63.806733558551059, 21.725318414800061, 63.168626504331769, 52.637047284217111, 63.378290250719147, 52.035403490238501, 63.861428448908555, 51.005316388426621, 64.599809468789317, 49.929650211313323, 65.274379783251788, 48.817520773958869, 65.86690776217074, 47.650696446242733, 66.386509220610606, 46.438293043225201, 66.833184158560471, 46.41094559804435, 66.842299973621266, 45.244121270328243, 67.197816760970454, 44.04083368237098, 67.480407027840556, 42.801082834172597, 67.699186589288729, 41.524868725733079, 67.863271260368492, 40.212191357052433, 67.954429410980083, 38.872166543190957, 67.990892671219626],
     ],

114: [ [27.413587012422429, 58.675393983550748, 26.547584581695592, 57.408295690169325, 25.672466335908471, 56.068270876308816, 24.81557972024191, 54.646203726901149, 23.94957728951508, 53.142094241949962, 27.10364930037284, 52.540450447981129, 27.82379869013516, 53.570537549789151, 28.534832264837181, 54.509466501000134, 29.245865839539221, 55.366353116660321, 29.94778359918098, 56.132081581730745, 30.649701358822739, 56.815767711250373, 31.324271673283651, 57.390064060051373, 32.427285295577832, 58.037286929331458, 33.466488212450031, 58.256066490768717, 27.413587012422429, 58.675393983550748],
       [0.95949170748252754, 59.915144831749785, 1.679641097244825, 57.317137539561372, 1.770799247847662, 57.353600799808191, 3.1108240617091951, 57.818507367879647, 4.3870381701487409, 58.137560894989292, 5.5903257581060473, 58.338108826319512, 6.7206868255810832, 58.401919531741441, 0.95949170748252754, 59.915144831749785],
       [23.94957728951508, 67.99175697515966, 20.92312668950126, 67.99175697515966, 0.95949170748252754, 59.915144831749785, 6.7206868255810832, 58.401919531741441, 7.6504999617299063, 58.338108826319512, 8.8537875496871834, 58.000823669081001, 9.8929904665594108, 57.390064060051373, 10.59490822620117, 56.642567225098901, 11.19655202017981, 55.566901047990541, 11.62499532801308, 54.217760419069236, 11.67969021837478, 53.862243631720048, 11.75261673885703, 53.242368207618711, 11.816427444279009, 52.458408112430334, 11.87112233464072, 51.519479161230265, 11.925817225002421, 50.425581353989401, 11.96228048524352, 49.167598875668773, 11.99874374548466, 47.745531726268382, 12.026091190665509, 46.159379905780952, 12.04432282078608, 44.418259229270916, 12.05343863584636, 42.513053881670203, 12.05343863584636, 40.452879678050522, 12.05343863584636, 14.855670988770726, 12.05343863584636, 13.8802787773202, 12.026091190665509, 12.066231580320164, 11.980512115364091, 10.562122095379891, 11.90758559488185, 9.3588345074203971, 11.816427444279009, 8.4654846315097529, 11.69792184849535, 7.8638408375409199, 11.415331581626591, 7.0251858519914094, 10.831919417768489, 5.8674773393286159, 10.08442258282534, 4.9285483881212713, 9.1728410767970843, 4.1901673682405089, 9.0634512960736782, 4.1172408477614226, 8.1792172352262753, 3.652334279679053, 7.1582459484746428, 3.2785858622082742, 5.9914216207584721, 2.9777639652202197, 4.696975882198358, 2.7681002188292041, 3.2566771026737049, 2.640478807988984, 1.679641097244825, 2.6040155477494409, 1.679641097244825, 0.0060082555683038663, 35.481083340772472, 0.0060082555683038663, 35.481083340772472, 2.6040155477494409, 34.624196725105918, 2.6131313628102362, 33.156550500400449, 2.7042895134109131, 31.81652568653891, 2.8774899995587475, 30.622353913641891, 3.1327328212501016, 29.555803551588841, 3.4700179784704233, 28.635106230500298, 3.8984612863096118, 27.75087216965289, 4.4362943748710677, 26.729900882901259, 5.2476019152309163, 25.918593342536099, 6.1500676061987178, 25.31694954855746, 7.1436914477708342, 25.061706726869549, 7.7271036116289906, 24.72442156963908, 8.7116116381403117, 24.441831302770339, 9.8146252604310575, 24.223051741323559, 11.036144478508504, 24.06808288529874, 12.385285107429809, 23.976924734695931, 13.843815517080657, 23.94957728951508, 15.429967337571725, 23.94957728951508, 47.080077226870344, 24.17747266602214, 47.526752164820209, 24.915853685905041, 48.912356053988333, 25.6542347057879, 50.206801792541228, 26.38349991061051, 51.419205195561517, 27.10364930037284, 52.540450447981129, 23.94957728951508, 53.142094241949962, 23.94957728951508, 67.99175697515966],
       [40.959688192002289, 67.99175697515966, 40.740908630555509, 67.99175697515966, 39.829327124527261, 67.927946269741369, 38.926861433559282, 67.79120904382944, 38.0335115576516, 67.572429482381267, 37.131045866683621, 67.271607585389575, 36.237695990775933, 66.888743352861638, 35.344346114868252, 66.423836784790183, 34.450996238960563, 65.886003696228727, 33.566762178113152, 65.266128272131027, 32.682528117265747, 64.564210512489808, 31.798294056418349, 63.780250417301431, 30.914059995570941, 62.923363801641244, 30.03894174978382, 61.975319035369466, 29.154707688936409, 60.954347748618602, 28.288705258209578, 59.851334126331494, 27.413587012422429, 58.675393983550748, 33.466488212450031, 58.256066490768717, 33.639688698595421, 58.246950675718836, 34.496575314261968, 58.046402744388615, 35.52666241607389, 57.572380361249088, 36.74818163415177, 56.824883526311169, 38.142901338374998, 55.803912239560304, 39.355304741392558, 54.901446548588865, 40.531244884169013, 54.190412973890489, 41.652490136583758, 53.689043145568576, 42.737272128757382, 53.388221248591435, 43.767359230569333, 53.278831467858254, 43.794706675750149, 53.278831467858254, 45.043573339008873, 53.406452878698474, 46.192166036604469, 53.771085481119371, 47.258716398657519, 54.381845090149, 48.234108610107768, 55.229615890759305, 48.40730909625313, 55.411932191960659, 49.154805931196279, 56.405556033540051, 49.683523204692683, 57.499453840770002, 50.00257673180257, 58.693625613668701, 50.111966512525953, 59.988071352228872, 50.111966512525953, 60.124808578129887, 49.98434510168201, 61.337211981150176, 49.665291574572109, 62.485804678748536, 49.145690116136016, 63.579702485978487, 48.434656541433981, 64.628021217911737, 47.513959220345441, 65.61252924441942, 46.857620536005101, 66.159478148041671, 45.845765064313717, 66.824932647439709, 44.751867257079823, 67.335418290811504, 43.566811299243078, 67.700050893221487, 42.308828820924099, 67.91883045466966, 40.959688192002289, 67.99175697515966],
     ],

115: [ [42.299713005863822, 1.3013182980612328, 12.490997758739921, 0.87287499022932025, 12.59127172440304, 0.87287499022932025, 13.676053716576661, 0.78171683962864336, 14.94315200995592, 0.53558983300172258, 16.38345078948058, 0.15272560045923456, 17.769054678643521, -0.22102281701154425, 19.14554275274617, -0.55830797423914191, 20.485567566607699, -0.86824568629162968, 21.807360750348689, -1.132604323040141, 23.092690673848519, -1.3696155145989906, 24.350673152167509, -1.5610476308684156, 25.581308185305659, -1.7251323019518168, 26.784595773262939, -1.8527537127883988, 27.96053591603939, -1.9439118633999897, 29.10001279857471, -1.9986067537611234, 30.221258050989469, -2.016838383879076, 30.46738505761709, -2.0077225688182807, 31.73448335099636, -1.9712593085787375, 32.974234199194797, -1.8618695278601081, 34.204869232332932, -1.6886690417086356, 35.417272635350507, -1.4516578501497861, 36.611444408247507, -1.1508359531508177, 37.787384551023962, -0.78620335074083414, 38.945093063679849, -0.36687585796971689, 40.084569946215169, 0.12537815529140062, 41.19669938356963, 0.68144287395989522, 42.299713005863822, 1.3013182980612328],
       [9.8929904665594108, 22.568514833699737, 7.51376273582565, 22.568514833699737, 7.51376273582565, -1.004982912189007, 9.8929904665594108, -1.004982912189007, 10.47640263041748, -0.093401406160410261, 11.387984136445739, 0.62674798359876149, 12.490997758739921, 0.87287499022932025, 42.299713005863822, 1.3013182980612328, 43.384494998037432, 1.9850044275808614, 30.367111091953969, 2.2402472492685774, 30.075405010024951, 2.2402472492685774, 28.835654161826511, 2.3040579546905064, 27.61413494374867, 2.4407951805987977, 26.419963170851648, 2.6595747420396947, 25.24402302807519, 2.9695124540885445, 24.086314515419311, 3.3523766866201186, 22.94683763288398, 3.8172832546988502, 21.834708195529512, 4.3642321583211015, 20.749926203355901, 4.9932233974795963, 19.67426002624256, 5.6951411571208155, 18.635057109370361, 6.4882170673590736, 17.604970007558421, 7.3633353131517651, 16.985094583459212, 7.9376316619491263, 16.21025030333519, 8.7489392023089749, 15.471869283452319, 9.6149416330408712, 14.76995152381056, 10.526523139069468, 14.104497024409939, 11.501915350519994, 13.48462160031073, 12.522886637270858, 12.90120943645263, 13.589436999318423, 12.35426053283569, 14.71979806679883, 11.84377488945986, 15.895738209568663, 11.37886832138545, 17.126373242710542, 10.950425013552181, 18.411703166209918, 10.55844496596003, 19.742612165009632, 10.202928178609, 21.128216054181394, 9.8929904665594108, 22.568514833699737],
       [14.68790918826801, 64.109284063408268, 13.7489802370589, 63.343555598341482, 12.84651454609096, 62.514016427860042, 12.718893135246979, 62.377279201951751, 11.83465907439958, 61.456581880858721, 11.041583164155011, 60.49030548446899, 10.3123179593324, 59.496681642900512, 9.6650950900523451, 58.457478726031695, 9.090798741254531, 57.390928363980493, 8.5985447279992684, 56.287914741689747, 8.1792172352262753, 55.139322044091386, 7.8328162629355509, 53.96338190131064, 7.5684576261873531, 52.750978498290351, 7.377025509921423, 51.492996019980637, 7.2676357291980187, 50.207666096481262, 7.2311724689569132, 48.885872912731429, 7.258519914137735, 47.755511845258297, 7.3679096948611402, 46.406371216340631, 7.5593418111270694, 45.102809662719665, 7.8328162629355509, 43.863058814520627, 8.1974488653468427, 42.687118671739881, 8.6350079882404032, 41.556757604270388, 9.1637252617368006, 40.48109142715839, 9.7744848707757228, 39.469235955461045, 10.4672868153572, 38.502959559071314, 10.54021333583947, 38.420917223531433, 11.087162239456401, 37.773694354251347, 11.71615347861592, 37.117355669910467, 12.42718705331794, 36.451901170508791, 13.220262963562529, 35.777330856049957, 14.104497024409939, 35.084528911469533, 15.07077342079989, 34.382611151828314, 16.119092152732382, 33.662461762058228, 17.24945322020741, 32.942312372299057, 18.470972438285258, 32.203931352418294, 19.765418176845401, 31.447318702419579, 21.15102206600832, 30.690706052409951, 22.618668290713831, 29.915861772278731, 24.16835685096186, 29.131901677101268, 25.553960740124811, 28.439099732520845, 27.058070225071418, 27.655139637339744, 28.489253189535791, 26.907642802398186, 29.82927800339732, 26.169261782510148, 31.087260481716299, 25.458228207811771, 32.263200624492747, 24.774542078288505, 33.357098431726648, 24.099971763829672, 34.359838088357719, 23.452748894549586, 35.280535409446259, 22.832873470448249, 36.128306210052557, 22.231229676468502, 36.88491886005599, 21.647817512610345, 37.559489174516898, 21.091752793930937, 38.142901338374998, 20.553919705380395, 38.553113016087707, 20.134592212609277, 39.364420556452842, 19.168315816208633, 40.048106685974027, 18.147344529461407, 40.613287219711573, 17.071678352349409, 41.050846342605134, 15.932201469808206, 41.360784054654708, 14.747145511981216, 41.543100355860361, 13.498278848721384, 41.606911061282347, 12.185601480028708, 41.597795246222063, 11.7753898023293, 41.47017383537812, 10.526523139069468, 41.187583568509353, 9.3323513661707693, 40.750024445615793, 8.2111061137584329, 40.157496466697431, 7.1445557516999543, 39.40999963175426, 6.1418160950706806, 38.507533940786288, 5.1937713287989027, 38.425491605243742, 5.1208448083198164, 37.486562654034657, 4.3551163432603062, 36.483822997403571, 3.7078934739802207, 35.399041005229947, 3.1791762004795601, 34.25044830763435, 2.7689645227692381, 33.02892908955647, 2.4772584408383409, 31.73448335099636, 2.3040579546905064, 30.367111091953969, 2.2402472492685774, 43.384494998037432, 1.9850044275808614, 44.45104536009049, 2.7325012625296949, 45.499364092023001, 3.5346929878287483, 45.873112509494568, 3.8446306998812361, 46.821157275763959, 4.7015173155486991, 47.687159706490803, 5.5948671914484294, 48.480235616735371, 6.5246803275986167, 49.200385006497697, 7.5000725390491425, 49.847607875777747, 8.5119280107392115, 50.412788409515287, 9.5602467426797375, 50.914158237830833, 10.654144549909688, 51.324369915543542, 11.784505617390096, 51.670770887834259, 12.951329945110047, 51.935129524582457, 14.163733348119422, 52.126561640848387, 15.412600011379254, 52.235951421571791, 16.69792993487863, 52.272414681812933, 18.028838933678344, 52.254183051692358, 18.849262289098988, 52.172140716149812, 19.943160096339852, 52.017171860125011, 21.027942088509008, 51.79839229867823, 22.085376635499415, 51.515802031809471, 23.124579552379146, 51.160285244458457, 24.136435024069215, 50.731841936625159, 25.130058865641331, 50.239587923369918, 26.105451077088219, 49.683523204692683, 27.062611658420792, 49.054531965533187, 27.992424794570979, 48.352614205891427, 28.904006300599576, 47.586885740827682, 29.788240361438511, 46.757346570341973, 30.663358607231203, 45.854880879374008, 31.511129407841509, 44.888604482984078, 32.331552763258514, 43.849401566111851, 33.142860303629277, 42.746387943817659, 33.926820398810378, 41.570447801041212, 34.683433048820007, 40.3306969528428, 35.430929883761564, 39.018019584162118, 36.151079273520736, 37.641531510059451, 36.84388121810116, 27.121880930493401, 41.96696928198071, 25.982404047958081, 42.532149815720913, 24.56945271361429, 43.279646650658833, 23.275006975054168, 44.018027670539595, 22.09906683227771, 44.738177060309681, 21.041632285284951, 45.458326450068853, 20.111819149136121, 46.169360024770867, 19.300511608770989, 46.871277784408448, 18.60770966418951, 47.554963913938991, 18.042529130451982, 48.23865004345862, 17.377074631051361, 49.15934736455165, 16.784546652132999, 50.225897726599214, 16.328755899118871, 51.356258794068708, 16.00058655694869, 52.559546382028202, 15.800038625622481, 53.826644675409625, 15.73622792020052, 55.157553674209339, 15.763575365381341, 55.795660728428629, 15.97323911176786, 56.926021795909037, 16.38345078948058, 58.019919603138987, 17.003326213579779, 59.0682383350686, 17.814633753944921, 60.089209621819464, 18.835605040696581, 61.073717648330785, 19.73807073166455, 61.766519592918485, 20.740810388295611, 62.368163386898232, 21.834708195529512, 62.860417400148435, 22.992416708185399, 63.243281632680009, 24.24128337144413, 63.516756084489316, 25.572192370245379, 63.680840755579993, 26.976027889528869, 63.735535645930213, 14.68790918826801, 64.109284063408268],
       [47.304295473958938, 67.99262127908878, 44.925067743225178, 67.99262127908878, 44.815677962501809, 67.782957532701403, 44.068181127558631, 66.497627609198389, 43.411842443218291, 65.759246589321265, 42.910472614902737, 65.476656322451163, 41.606911061282347, 65.248760945938557, 15.66330139971825, 64.802086007988692, 14.68790918826801, 64.109284063408268, 26.976027889528869, 63.735535645930213, 27.62325075880895, 63.726419830880332, 28.97239138773077, 63.644377495329536, 30.275952941351161, 63.480292824249773, 31.52481960460986, 63.225050002558419, 32.718991377506882, 62.887764845330821, 33.867584075102492, 62.468437352559704, 34.961481882336393, 61.957951709180634, 36.000684799208592, 61.365423730261682, 36.994308640779387, 60.681737600738415, 37.933237591988501, 59.916009135671629, 38.471070680545161, 59.396407677249954, 39.109177734764927, 58.694489917601459, 39.729053158864161, 57.901414007348649, 40.3306969528428, 57.035411576631304, 40.914109116700871, 56.078250995298731, 41.479289650438403, 55.04816389349071, 42.026238554055332, 53.926918641071097, 42.55495582755173, 52.732746868179674, 43.065441470927567, 51.447416944669385, 43.557695484182801, 50.089160500690923, 44.031717867317489, 48.639745906111784, 44.487508620331617, 47.108288975978212, 44.925067743225178, 45.494789710308396, 47.304295473958938, 45.494789710308396, 47.304295473958938, 67.99262127908878],
       [27.267733971457911, 67.99262127908878, 26.337920835309092, 67.974389648970828, 24.979664391326988, 67.892347313420032, 23.676102837706591, 67.746494272458222, 22.409004544327331, 67.527714711010049, 21.178369511189171, 67.245124444139947, 19.993313553352461, 66.889607656801672, 18.844720855756862, 66.470280164019641, 17.74170723346268, 65.987141965830233, 16.684272686469878, 65.421961432090029, 15.66330139971825, 64.802086007988692, 41.606911061282347, 65.248760945938557, 40.886761671520013, 65.312571651360486, 39.811095494406693, 65.513119582690706, 38.416375790183451, 65.850404739918304, 36.702602558850351, 66.333542938118626, 35.936874093786599, 66.561438314620318, 34.523922759442833, 66.935186732098373, 33.165666315460733, 67.263356074261537, 31.871220576900608, 67.518598895949253, 30.631469728702172, 67.728262642340269, 29.446413770865441, 67.874115683298442, 28.325168518450681, 67.965273833899118, 27.267733971457911, 67.99262127908878],
     ],

116: [ [41.242278458871048, 13.125394735179725, 38.434607420304019, 13.125394735179725, 38.179364598616111, 12.560214201439521, 37.532141729336047, 11.40250568879128, 36.784644894392898, 10.390650217101211, 35.927758278726323, 9.5246477863693144, 34.979713512456946, 8.8044983965992287, 33.931394780524442, 8.1846229725088051, 32.7645704528083, 7.6832531441905303, 31.570398679911278, 7.3915470622596331, 30.367111091953969, 7.2912730966017989, 38.288754379339508, 7.072493535149988, 38.954208878740133, 8.148159712258348, 39.592315932959913, 9.2876365947995509, 40.184843911878261, 10.50003999781984, 40.731792815495218, 11.785369921319216, 41.242278458871048, 13.125394735179725],
       [23.803724248550569, 87.747456818651699, 21.570349558781349, 87.747456818651699, 21.15102206600832, 86.726485531900835, 20.50379919672827, 85.17679697164931, 19.893039587689341, 83.745614007191762, 19.31874323889156, 82.43293663851, 18.771794335274588, 81.247880680668459, 18.270424506959039, 80.181330318620894, 17.79640212382435, 79.242401367409911, 17.35884300093079, 78.421978011978354, 16.957747138278361, 77.729176067401568, 16.903052247916659, 77.628902101740096, 16.17378704309408, 76.507656849320483, 15.426290208150901, 75.422874857151328, 14.660561743087159, 74.36544031016092, 13.86748583284259, 73.353584838459938, 13.056178292477449, 72.36907681195953, 12.22663912199172, 71.421032045691391, 11.36975250632517, 70.509450539659156, 10.50375007559833, 69.625216478809307, 9.6104001996906447, 68.78656149327071, 8.8446717346268997, 68.102875363740168, 7.769005557513565, 67.200409672779642, 6.6933393804002321, 66.379986317351722, 5.6359048334074648, 65.623373667338456, 4.57847028641467, 64.948803352879622, 3.5301515544821882, 64.356275373971584, 2.4909486376099892, 63.827558100470924, 1.460861535798045, 63.380883162521059, 1.460861535798045, 61.001655431780819, 11.91670140994213, 61.001655431780819, 11.91670140994213, 16.589404458078207, 11.91670140994213, 15.914834143630287, 11.95316467018324, 14.310450693021266, 12.035207005725789, 12.815457023130875, 12.162828416569759, 11.420737318909232, 12.326913087654839, 10.135407395409857, 12.536576834041339, 8.9594672526291106, 12.791819655729251, 7.8838010755207506, 13.083525737658279, 6.9266404941918154, 13.429926709949029, 6.0606380634599191, 13.82190675754117, 5.2493305230891565, 14.46912962682123, 4.1554327158592059, 15.22574227682469, 3.1618088742907275, 16.08262889249124, 2.2684589983800834, 17.048905288881201, 1.4844989031989826, 18.106339835873971, 0.800812773679354, 18.571246403948379, 0.53645413693084265, 19.756302361785121, -0.046958026930951746, 20.950474134682111, -0.49363296488081687, 22.1628775376997, -0.81268649199046195, 23.375280940717289, -1.0132344233206823, 24.59680015879513, -1.0770451287389733, 24.8793904256639, -1.067929313681816, 26.064446383500641, -0.99500279319909168, 27.240386526277071, -0.81268649199046195, 28.407210853993231, -0.52098041005956475, 29.564919366649121, -0.11988454741003807, 30.713512064244728, 0.38148528090096079, 31.852988946780041, 0.99224488994150306, 32.98335001425508, 1.7032784646507935, 34.113711081730123, 2.5328176351285947, 34.323374828116613, 2.6969023062192718, 35.198493073903727, 3.4352833261000342, 36.028032244389443, 4.2465908664707968, 36.821108154634032, 5.1217091122489364, 37.568604989577182, 6.0606380634599191, 38.288754379339508, 7.072493535149988, 30.367111091953969, 7.2912730966017989, 29.920436154000129, 7.3003889116589562, 28.689801120862001, 7.5009368429891765, 27.568555868447248, 7.9384959658782464, 26.565816211816159, 8.6130662803407176, 25.681582150968751, 9.5246477863693144, 25.59953981542623, 9.6158059369699913, 25.125517432291531, 10.354186956850754, 24.72442156963908, 11.247536832761398, 24.38713641240864, 12.304971379751805, 24.131893590720718, 13.526490597829252, 23.94957728951508, 14.912094487001013, 23.840187508791669, 16.461783047241624, 23.803724248550569, 18.175556278580189, 23.803724248550569, 61.001655431780819, 39.227683330548608, 61.001655431780819, 39.227683330548608, 66.042701160120487, 23.803724248550569, 66.042701160120487, 23.803724248550569, 87.747456818651699],
     ],

117: [ [72.600682266242984, 8.6595096595810901, 72.454829225278459, 8.5956989541591611, 71.12392022647721, 8.0852133107910049, 69.865937748158217, 7.7205807083810214, 68.671765975261209, 7.5018011469292105, 67.550520722846457, 7.4288746264501242, 73.603421922874062, 6.1344288878790394, 72.600682266242984, 8.6595096595810901],
       [63.083771343308001, 12.050592862011399, 50.613336340841492, 11.977666341528675, 50.613336340841492, -2.0151097760099219, 53.858566502302061, -2.0151097760099219, 73.603421922874062, 6.1344288878790394, 67.550520722846457, 7.4288746264501242, 67.058266709591194, 7.4562220716288721, 65.864094936694187, 7.7752755987385171, 64.81577620476169, 8.4407300981401931, 64.642575718616328, 8.5956989541591611, 63.986237034275973, 9.4434697547694668, 63.466635575839888, 10.592062452371465, 63.083771343308001, 12.050592862011399],
       [62.509474994510207, 66.043565464071435, 40.020759240793183, 66.043565464071435, 40.020759240793183, 63.381747466461093, 40.294233692601658, 63.372631651400297, 41.998891108874489, 63.281473500799621, 43.530348039001979, 63.126504644769739, 44.888604482984078, 62.898609268271684, 46.073660440820788, 62.606903186340787, 47.085515912512157, 62.233154768859094, 47.924170898058151, 61.795595645970025, 48.598741212519052, 61.28511000259823, 48.872215664327541, 60.984288105610176, 49.410048752884187, 60.19121219536828, 49.838492060717471, 59.224935798978549, 50.184893033008223, 58.09457473150178, 50.42190422457557, 56.781897362820018, 50.567757265540081, 55.305135323051218, 50.613336340841492, 53.646056982081063, 50.613336340841492, 16.225636159619171, 50.20312466312879, 15.815424481908849, 49.081879410714031, 14.712410859621741, 47.987981603480129, 13.691439572859963, 46.930547056487342, 12.75251062164898, 45.90957576973571, 11.895624005981517, 44.925067743225178, 11.11166391081133, 43.967907161895539, 10.418861966219993, 43.047209840807, 9.7989865421186551, 42.172091595019879, 9.2611534535608371, 41.31520497935329, 8.8053627005501767, 40.230422987179672, 8.2948770571711066, 38.926861433559282, 7.7752755987385171, 37.68711058536087, 7.3741797360889905, 36.492938812463848, 7.0915894692188886, 35.344346114868252, 6.9183889830710541, 34.259564122694627, 6.8545782776491251, 44.934183558285469, 6.1435447029507486, 45.991618105278263, 7.1645159897016129, 47.076400097451881, 8.2584137969388394, 48.2158769799872, 9.4252381246515142, 49.391817122763619, 10.664988972850551, 50.613336340841492, 11.977666341528675, 63.083771343308001, 12.050592862011399, 62.992613192705193, 12.551962690329674, 62.901455042102363, 13.226533004788507, 62.819412706559802, 14.046956360209151, 62.746486186077561, 15.022348571659677, 62.682675480655583, 16.152709639140085, 62.627980590293873, 17.419807932521508, 62.582401514992483, 18.850990896979056, 62.555054069811632, 20.418911087348533, 62.527706624630781, 22.141800133751531, 62.509474994510207, 24.010542221101787, 62.509474994510207, 26.034253164489201, 62.509474994510207, 66.043565464071435],
       [23.302354420235019, 66.043565464071435, 0.1664157972379314, 66.043565464071435, 0.1664157972379314, 63.381747466461093, 1.4517457207377611, 63.381747466461093, 23.302354420235019, 66.043565464071435],
       [23.302354420235019, 66.043565464071435, 1.4517457207377611, 63.381747466461093, 3.0196659111063582, 63.327052576099959, 4.3961539852090246, 63.217662795381329, 5.5812099430457627, 63.044462309240771, 6.5748337846165441, 62.807451117671008, 7.3679096948611402, 62.51574503574011, 7.6869632219710411, 62.342544549588638, 8.7443977689638075, 61.604163529711514, 9.6195160147509284, 60.729045283918822, 10.33054958945297, 59.6989581821108, 10.412591924995491, 59.543989326088195, 10.740761267165681, 58.705334340538684, 11.005119903913879, 57.647899793548277, 11.18743620511952, 56.380801500170492, 11.296825985842901, 54.904039460401691, 11.33328924608403, 53.217613674249151, 11.33328924608403, 23.727951954231685, 11.33328924608403, 23.272161201221024, 11.36063669126488, 21.686009380729956, 11.39709995150602, 20.172784080721613, 11.470026471988289, 18.714253671081678, 11.561184622591099, 17.328649781920831, 11.67969021837478, 16.006856598170998, 11.8255432593393, 14.74887411985037, 11.99874374548466, 13.554702346958948, 12.190175861750591, 12.433457094539335, 12.408955423197369, 11.376022547548928, 12.655082429825001, 10.382398705980449, 12.919441066573199, 9.4525855698302621, 12.93767269669376, 9.3978906794691284, 13.37523181958732, 8.1672556463308865, 13.894833278023439, 7.009547133671731, 14.48736125694179, 5.8974176963201899, 15.15281575634242, 4.8490989643905777, 15.9003125912856, 3.8554751228184614, 16.7298517617713, 2.925661986668274, 17.632317452739269, 2.0505437408792204, 18.616825479249801, 1.2301203854513005, 18.81737341057601, 1.0751515294286946, 19.838344697327638, 0.34588632460872759, 20.89577924432044, -0.27398909948897199, 21.998792866614622, -0.811822188039514, 23.147385564210229, -1.2402654958787025, 24.350673152167509, -1.5775506531099381, 25.590424000365939, -1.8145618446797016, 26.875753923865769, -1.9604148856415122, 28.197547107606741, -2.0151097760099219, 29.154707688936409, -1.9877623308202601, 30.421805982315671, -1.8874883651587879, 31.661556830514119, -1.7142878790109535, 32.892191863652251, -1.4499292422697181, 34.104595266669833, -1.1217599000992777, 35.298767039566833, -0.70243240732088452, 36.483822997403571, -0.21017839405976702, 37.641531510059451, 0.36411795473031816, 38.097322263073579, 0.6193607764216722, 38.799240022715338, 1.056919899310742, 39.546736857658487, 1.5674055426898121, 40.339812767903076, 2.1417018914798973, 41.169351938388779, 2.798040575820778, 42.053585999236191, 3.527305780651659, 42.965167505264439, 4.3203816908899171, 43.931443901654397, 5.1954999366789707, 44.934183558285469, 6.1435447029507486, 34.259564122694627, 6.8545782776491251, 33.284171911244393, 6.8910415378886682, 32.007957802804839, 7.0460103939185501, 30.79555439978725, 7.328600660788652, 29.646961702191678, 7.738812338498974, 28.553063894957749, 8.276645427049516, 27.51386097808555, 8.9512157415192632, 26.547584581695592, 9.7442916517611593, 26.347036650369368, 9.9174921379089938, 25.772740301571591, 10.573830822249874, 25.253138843135471, 11.34867510237018, 24.79734809012135, 12.251140793341619, 24.396252227468921, 13.262996265031688, 24.058967070238449, 14.393357332508458, 23.785492618429998, 15.65133981082181, 23.575828872043498, 17.018712069861067, 23.420860016018679, 18.513705739751458, 23.329701865415871, 20.118089190360479, 23.302354420235019, 21.85009405180972, 23.302354420235019, 66.043565464071435],
     ],

118: [ [32.308779699794172, 66.044429768000555, 1.242081974351265, 66.044429768000555, 1.242081974351265, 63.382611770390213, 2.8008863496595771, 63.109137318580906, 4.2047218689430963, 62.799199606539332, 5.2895038611167129, 62.480146079418773, 6.0734639563010262, 62.151976737259247, 6.8483082364250256, 61.723533429430972, 7.9330902285986431, 61.003384039660887, 8.8993666249886019, 60.210308129411715, 9.7471374255948717, 59.344305698690732, 9.7562532406551554, 59.335189883629937, 10.33966540451325, 58.551229788448836, 10.93219338343161, 57.603185022169782, 11.53383717741025, 56.481939769761084, 12.153712601509479, 55.187494031200913, 12.77358802560869, 53.71984780648927, 36.347085771499337, -2.0142454720808018, 41.388131499835559, 15.870983676199103, 26.03709893831979, 52.352475547450013, 25.54484492506452, 53.564878950470302, 25.09816998711068, 54.877556319148425, 24.779116460000779, 56.108191352290305, 24.58768434373485, 57.256784049881389, 24.523873638312871, 58.332450227000663, 24.532989453373151, 58.73354608965019, 24.760884829880212, 60.000644383031613, 25.262254658195761, 61.094542190261564, 26.03709893831979, 62.00612369629016, 26.60227947205729, 62.461914449300821, 27.62325075880895, 62.972400092679891, 28.853885791947079, 63.273221989671583, 30.294184571471732, 63.382611770390213, 32.308779699794172, 63.382611770390213, 32.308779699794172, 66.044429768000555],
       [72.454829225278459, 66.044429768000555, 50.905042422770549, 66.044429768000555, 50.905042422770549, 63.382611770390213, 52.509425873380252, 63.364380140268622, 53.958840467965189, 63.291453619789536, 55.089201535440218, 63.182063839070906, 55.873161630624509, 63.017979167980229, 55.909624890865643, 63.008863352919434, 57.012638513159828, 62.416335374000482, 57.896872574007233, 61.504753867979161, 58.188578655936283, 61.085426375211682, 58.471168922805049, 59.845675527001731, 58.471168922805049, 59.845675527001731, 58.407358217383063, 58.924978205919615, 58.20681028605685, 57.858427843861136, 57.878640943886701, 56.636908625780052, 57.413734375812282, 55.251304736619204, 56.812090581833623, 53.71984780648927, 41.388131499835559, 15.870983676199103, 36.347085771499337, -2.0142454720808018, 39.300609851030863, -2.0142454720808018, 62.728254555956987, 54.658776757711166, 63.184045308971122, 55.761790379998274, 63.813036548130611, 57.092699378801626, 64.460259417410668, 58.305102781818277, 65.125713916811293, 59.380768958930275, 65.818515861392768, 60.337929540259211, 66.529549436094811, 61.167468710751564, 67.267930455977691, 61.869386470389145, 67.504941647545039, 62.051702771590499, 68.38005989333216, 62.534840969790821, 69.492189330686628, 62.917705202318757, 70.850445774668728, 63.200295469188859, 72.454829225278459, 63.382611770390213, 72.454829225278459, 66.044429768000555],
     ],

119: [ [51.989824414944167, 46.437234936598543, 37.787384551023962, 15.507274437059095, 32.600485781723201, -2.0133221087999118, 35.262303779325691, -2.0133221087999118, 54.505789371582161, 40.165554175131547, 51.989824414944167, 46.437234936598543],
       [28.635106230500298, 66.045353131270531, 0.95949170748252754, 66.045353131270531, 0.95949170748252754, 63.374419318610308, 1.7252201725462439, 63.201218832469749, 3.147287321950329, 62.800122969809308, 4.4143856153295919, 62.344332216798648, 5.5265150526840614, 61.833846573419578, 6.4927914490740193, 61.259550224618579, 7.3040989894391544, 60.639674800520879, 7.6231525165490552, 60.320621273411234, 8.2430279406482612, 59.582240253530472, 8.8720191798077508, 58.679774562559032, 9.5010104189672404, 57.63145583062942, 10.13000165812676, 56.409936612548336, 10.76810871234653, 55.033448538448283, 11.4062157665663, 53.501991608318349, 32.600485781723201, -2.0133221087999118, 37.787384551023962, 15.507274437059095, 23.65787120758603, 53.501991608318349, 23.45732327625981, 54.03070888181901, 23.01064833830597, 55.398081140858267, 22.691594811196101, 56.66517943423969, 22.50016269493014, 57.832003761959641, 22.436351989508179, 58.907669939071639, 22.527510140110991, 59.955988671001251, 22.9377218178237, 61.104581368599611, 23.65787120758603, 62.007047059560136, 23.74902935818886, 62.089089395110932, 24.5056420081923, 62.544880148121592, 25.572192370245379, 62.918628565588733, 26.948680444348039, 63.192103017401678, 28.635106230500298, 63.374419318610308, 28.635106230500298, 66.045353131270531],
       [69.209599063817876, 66.045353131270531, 37.787384551023962, 66.045353131270531, 37.787384551023962, 63.374419318610308, 39.145640995006062, 63.283261167998717, 40.640634664892389, 63.100944866801001, 41.898617143211389, 62.854817860170442, 42.919588429963028, 62.535764333060797, 43.69443271008705, 62.152900100529223, 43.758243415509043, 62.107321025228885, 44.651593291416717, 61.47832978607039, 45.49024827696271, 60.712601320999966, 46.26509255708671, 59.791903999921487, 46.97612613178876, 58.725353637870285, 47.641580631189377, 57.522066049899877, 48.234108610107768, 56.163809605921415, 51.989824414944167, 46.437234936598543, 54.505789371582161, 40.165554175131547, 71.01453044575382, -2.0133221087999118, 75.982649653607794, 16.947573216588353, 60.996249694503312, 54.869363867361244, 60.823049208357929, 55.343386250500771, 60.522227311368617, 56.601368728821399, 60.421953345705496, 57.822887946898845, 60.43106916076578, 58.26956288484871, 60.640732907152277, 59.600471883648424, 61.114755290286979, 60.676138060760422, 61.862252125230157, 61.505677231249138, 61.926062830652107, 61.551256306549476, 62.728254555956987, 62.052626134860475, 63.703646767407243, 62.471953627638868, 64.834007834882243, 62.809238784870104, 66.128453573442371, 63.08271323667941, 67.586983983087578, 63.265029537891678, 69.209599063817876, 63.374419318610308, 69.209599063817876, 66.045353131270531],
       [105.2444159971147, 66.045353131270531, 84.414778584369145, 66.045353131270531, 84.414778584369145, 63.374419318610308, 85.371939165698805, 63.328840243309969, 86.912511910886565, 63.164755572219292, 88.188726019326126, 62.918628565588733, 89.209697306077757, 62.581343408361136, 89.966309956081204, 62.152900100529223, 90.349174188613077, 61.824730758358783, 91.087555208495957, 60.812875286668714, 91.333682215123588, 59.700745849309897, 91.333682215123588, 59.691630034249101, 91.278987324761886, 58.707122007741418, 91.105786838616524, 57.594992570378963, 90.814080756687488, 56.35524172219084, 90.412984894035077, 54.987869463151583, 89.893383435598949, 53.501991608318349, 75.982649653607794, 16.947573216588353, 71.01453044575382, -2.0133221087999118, 73.968054525285353, -2.0133221087999118, 96.019211156108824, 54.869363867361244, 96.465886094062668, 55.935914229419723, 97.085761518161874, 57.193896707729436, 97.769447647683066, 58.333373590270639, 98.507828667565946, 59.363460692078661, 99.291788762750244, 60.275042198110896, 100.1486753784168, 61.077233923409949, 101.0511410693847, 61.770035868001287, 102.0174174657747, 62.344332216798648, 103.0383887525263, 62.800122969809308, 104.11405492963971, 63.146523942101339, 105.2444159971147, 63.374419318610308, 105.2444159971147, 66.045353131270531],
     ],

120: [ [11.69166538042033, 182.91971914866008, 10.59748029414159, 182.87108870039083, 8.9318874405839637, 182.56714839864071, 7.4972892163518301, 181.98358301928965, 6.2936856214452197, 181.12039256234129, 5.8681691990035034, 180.68271852783073, 4.9806635179107408, 179.39401164843002, 4.4457285868411267, 177.91078297591957, 4.2755220178644464, 176.22087489823025, 4.4457285868411267, 174.67685816535959, 4.9563482937711987, 173.23010232906017, 5.8195387507244467, 171.86844977724832, 7.0109847335612718, 170.59190050992038, 7.825544742235464, 169.94754707022003, 9.1628820699094842, 169.15730228569009, 10.633953130350889, 168.59805213048094, 12.25091553562949, 168.2576389925307, 14.00161167367547, 168.14822048390124, 14.269079139210261, 168.14822048390124, 15.70367736344239, 168.24548138046157, 17.162590811814042, 168.50079123392061, 18.621504260185691, 168.88983482015101, 20.10473293269688, 169.42476975122918, 21.600119217277818, 170.11775363919878, 23.119820725998281, 170.94447125993975, 24.639522234718768, 171.9170802255212, 26.18353896757877, 173.04773814800865, 27.19262076936916, 173.87445576876053, 28.286805855647899, 174.88353757054938, 29.344518105717341, 175.97772265682943, 30.365757519577521, 177.14485341552063, 31.338366485158598, 178.3970874587103, 32.274502614530419, 179.7222671743184, 21.782483398324288, 180.2572021053893, 21.575803993138312, 180.26935971745843, 20.2992547258131, 180.59761524333953, 18.18383022567421, 181.3392295795893, 18.06225410497656, 181.38786002788038, 16.153509010023651, 182.05652869171172, 14.46360093232648, 182.54283317449881, 12.980372259815301, 182.82245825209975, 11.69166538042033, 182.91971914866008],
       [30.075405010024951, 33.457178594690049, 16.237597748516041, 15.070579618099146, 16.18290285815436, 14.997653097620059, 15.043425975619041, 13.502659427729668, 13.95864398344542, 12.11705553856882, 12.94678851175405, 10.831725615069445, 11.989627930424369, 9.6557854722886987, 11.087162239456401, 8.589235110241134, 10.2576230689707, 7.6229587138514034, 9.4827787888467014, 6.7660720981912164, 8.7717452141446586, 6.0185752632387448, 8.1245223448646016, 5.3713523939586594, 7.5411101810065011, 4.8335193054117553, 7.0123929075101321, 4.4050759975689289, 6.082579771361309, 3.8034322035891819, 4.9704503340068413, 3.2564832999814826, 3.7580469309892521, 2.8553874373210419, 2.4727170074894209, 2.6001446156296879, 2.4727170074894209, 0.0021373234485508874, 24.02250380999735, 0.0021373234485508874, 24.02250380999735, 2.6001446156296879, 23.831071693731388, 2.6092604307013971, 22.3725412840862, 2.7733451017811603, 21.123674620827501, 3.0923986288908054, 20.057124258774419, 3.5664210120194184, 19.191121828047581, 4.186296436120756, 18.30688776720018, 5.0978779421602667, 17.723475603342109, 6.1461966740789649, 17.53204348707618, 7.2856735566201678, 17.54115930213646, 7.3950633373387973, 17.687012343100971, 7.8873173505999148, 18.015181685271131, 8.5801192951803387, 18.534783143707241, 9.4734691710909829, 19.22758508828872, 10.576482793381729, 20.111819149136121, 11.870928531938262, 21.178369511189171, 13.375038016889448, 22.436351989508179, 15.070579618099146, 33.02892908955647, 29.200092961538758, 30.075405010024951, 33.457178594690049],
       [33.02892908955647, 66.046217435199651, 1.9622313641135909, 66.046217435199651, 1.9622313641135909, 63.375283622539428, 2.1172002201383862, 63.375283622539428, 3.5119199243616199, 63.311472917121137, 4.8245972930423022, 63.147388246030459, 6.0643481412407416, 62.873913794221153, 7.2220566538966287, 62.500165376750374, 8.306838646070247, 62.017027178560966, 9.3186941177615932, 61.433615014699171, 9.3551573780027297, 61.406267569520423, 9.9568011719813683, 60.941361001441692, 10.60402404126145, 60.357948837579897, 11.296825985842901, 59.665146892999473, 12.04432282078608, 58.86295516770042, 12.837398731030669, 57.942257846611028, 13.676053716576661, 56.903054929738573, 14.569403592484351, 55.754462232140213, 15.50833254369345, 54.496479753830499, 16.501956385264229, 53.119991679719533, 17.53204348707618, 51.624998009829142, 30.075405010024951, 33.457178594690049, 33.02892908955647, 29.200092961538758, 42.691693053455957, 15.070579618099146, 43.357147552856588, 14.086071591591462, 44.4054662847891, 12.499919771100394, 45.289700345636497, 11.096084251821594, 46.009849735398817, 9.8654492186797142, 46.575030269136327, 8.8171304867501021, 46.97612613178876, 7.9420122409610485, 47.222253138416391, 7.2400944813198294, 47.304295473958938, 6.7113772078191687, 47.240484768536952, 6.0459227084211307, 46.802925645643391, 4.9429090861303848, 45.92780739985627, 4.0404433951589453, 45.718143653469781, 3.8763587240791821, 44.742751442019532, 3.3202940053997736, 43.621506189604787, 2.919198142739333, 42.33617626610495, 2.6821869511804834, 40.886761671520013, 2.6001446156296879, 40.886761671520013, 0.0021373234485508874, 72.026385917445182, 0.0021373234485508874, 72.026385917445182, 2.6001446156296879, 71.160383486718345, 2.6639553210516169, 69.793011227675962, 2.8553874373210419, 68.535028749356954, 3.1470935192483012, 67.368204421640797, 3.5390735668406705, 66.292538244527464, 4.0222117650409928, 65.317146033077236, 4.6238555590207397, 64.979860875846782, 4.8608667505795893, 64.423796157169534, 5.3348891337191162, 63.803920733070321, 5.9183012975809106, 63.12935041860942, 6.6384506873400824, 62.390969398726519, 7.4679898578287975, 61.588777673421667, 8.434266254218528, 60.722775242694837, 9.509932431330526, 59.802077921606298, 10.722335834350815, 58.817569895095772, 12.044129018089734, 57.778366978223573, 13.502659427729668, 56.666237540869098, 15.070579618099146, 40.239538802239963, 38.717003884481528, 37.286014722708423, 43.265795599560079, 32.600485781723201, 50.758995579111797, 32.263200624492747, 51.278597037551663, 31.442777269067339, 52.536579515861376, 30.75909113954614, 53.566666617669398, 30.221258050989469, 54.368858342979365, 29.510224476287419, 55.417177074908977, 28.717148566042852, 56.738970258651534, 28.151968032305319, 57.89667877131069, 27.805567060014599, 58.881186797818373, 27.696177279291192, 59.701610153239017, 27.74175635459261, 60.285022317100811, 28.124620587124468, 61.433615014699171, 28.917696497369061, 62.363428150838445, 29.23675002447894, 62.609555157469003, 30.193910605808611, 63.037998465308192, 31.461008899187881, 63.293241286999546, 33.02892908955647, 63.375283622539428, 33.02892908955647, 66.046217435199651],
       [65.03455576620847, 66.046217435199651, 42.691693053455957, 66.046217435199651, 42.691693053455957, 63.375283622539428, 43.19306288177151, 63.366167807478632, 44.62424584623588, 63.220314766509546, 45.772838543831483, 62.88302960927831, 46.647956789618597, 62.363428150838445, 47.012589392029888, 62.00791136350017, 47.659812261309952, 60.96870844662044, 47.878591822756732, 59.774536673721741, 47.869476007696449, 59.646915262881521, 47.760086226973073, 59.072618914080522, 47.48661177516459, 58.35246952432135, 47.06728428239159, 57.468235463478777, 46.492987933593781, 56.438148361659842, 45.772838543831483, 55.2530924038183, 44.897720298044327, 53.903951774900634, 43.867633196232411, 52.408958105021156, 42.691693053455957, 50.758995579111797, 37.286014722708423, 43.265795599560079, 40.239538802239963, 38.717003884481528, 49.245964081799123, 50.758995579111797, 49.5741334239693, 51.196554702000867, 50.622452155901783, 52.582158591161715, 51.634307627593131, 53.867488514668366, 52.609699839043373, 55.070776102620584, 53.539512975192203, 56.182905539979402, 54.4237470360396, 57.203876826730266, 55.27151783664587, 58.133689962880453, 56.082825377011041, 58.972344948429964, 56.84855384207475, 59.719841783371521, 57.577819046897361, 60.385296282769559, 58.261505176418552, 60.950476816498849, 58.908728045698609, 61.433615014699171, 59.036349456542553, 61.515657350239053, 60.093784003535347, 62.1173011442188, 61.224145071010383, 62.609555157469003, 62.418316843907377, 62.974187759889901, 63.694530952346952, 63.238546396631136, 65.03455576620847, 63.375283622539428, 65.03455576620847, 66.046217435199651],
     ],

121: [ [31.666622011042239, 66.053470481710974, 0.88354825040035223, 66.053470481710974, 0.88354825040035223, 63.378795826360147, 1.843999603911683, 63.147801197028457, 3.6311685781669629, 62.600708653899346, 5.0900820265386102, 62.004985662468243, 6.2207399490266511, 61.360632222778804, 6.8772510007938896, 60.789224455500516, 7.9349632508633334, 59.609936084740184, 9.1750396819792428, 57.980816067378328, 10.23275193204868, 56.448956946591352, 11.2053608976298, 54.965728274080902, 12.007763294234209, 53.628390946410946, 12.63995912186191, 52.424787351501436, 36.347302657901302, 2.6028930896100064, 42.110010778969311, 17.386549366441614, 26.037647622741598, 50.698406437601079, 25.1987723899279, 52.558521084269159, 24.5301037260909, 54.297059610238648, 24.043799243300342, 55.865391567251208, 23.764174165695771, 57.263516955270461, 23.666913269137648, 58.479278162249102, 23.727701329486489, 59.293838170920935, 24.262636260556079, 60.752751619289484, 25.32034851062555, 62.017143274548289, 25.466239855462721, 62.138719395239605, 26.694158674508842, 62.831703283220122, 28.2503330194386, 63.245062093588786, 30.146920502321748, 63.378795826360147, 31.666622011042239, 63.378795826360147, 31.666622011042239, 66.053470481710974],
       [72.966030212029779, 66.053470481710974, 51.48352968475718, 66.053470481710974, 51.48352968475718, 63.378795826360147, 52.869497460710257, 63.354480602218246, 54.608035986686481, 63.220746869450522, 55.811639581593091, 62.953279403918714, 56.419520185081282, 62.661496714241366, 57.610966167918129, 61.652414912448876, 57.793330348964602, 61.360632222778804, 58.109428262778451, 59.707196981289599, 58.072955426569138, 58.698115179500746, 57.866276021383172, 57.093310386291705, 57.465074823080961, 55.488505593079026, 56.893667055802077, 53.871543187811767, 42.110010778969311, 17.386549366441614, 36.347302657901302, 2.6028930896100064, 31.666622011042239, -8.861735092181334, 31.545045890344579, -9.1535177818514057, 30.706170657530901, -11.098735713010683, 29.867295424717199, -12.825116626918316, 29.028420191903489, -14.332660523570667, 28.18954495908979, -15.609209790898603, 27.36282733834587, -16.666922040971258, 26.548267329671681, -17.505797273781354, 26.086278071020661, -17.894840860011755, 24.578734174369959, -18.916080273869738, 23.144135950137819, -19.536118489428191, 21.782483398324288, -19.742797894610703, 32.274502614530419, -20.277732825681596, 33.162008295623181, -18.879607437658706, 34.025198752576401, -17.384221153079125, 34.8397587612506, -15.828046808150248, 35.617845933715458, -14.186769178730174, 36.347302657901302, -12.460388264829817, 63.227782944148998, 53.433869153290289, 63.835663547637182, 54.953570662011771, 64.625908332171832, 56.825842920759897, 65.245946547729773, 58.163180248429853, 65.683620582241275, 58.989897869170818, 66.619756711613093, 60.181343852011196, 67.774729858240647, 61.409262671058968, 68.856757332449632, 62.223822679730802, 69.586214056635441, 62.600708653899346, 71.093757953286172, 63.07485552461003, 72.966030212029779, 63.378795826360147, 72.966030212029779, 66.053470481710974],
     ],

122: [ [62.003282520490671, 20.262161232560175, 59.551263369364129, 20.262161232560175, 59.420239445258119, 19.09230476733137, 59.204985855655423, 17.342199495331442, 58.961655710887129, 15.760553554340731, 58.718325566118857, 14.366084647790558, 58.45627771790685, 13.140075072231411, 58.184871017972988, 12.091883679378952, 57.904105466317297, 11.221510469240457, 57.604622211217873, 10.528955441819562, 56.986937997575289, 9.4526874938092078, 56.182076749495593, 8.3764195457988535, 55.302344687641039, 7.4686109287795261, 54.338382960289771, 6.7199027910282894, 53.280832715719917, 6.1302951325487811, 53.271473863998068, 6.1302951325487811, 52.513406874527639, 5.8214530257282604, 51.59623940578566, 5.5594051775187836, 50.538689161215807, 5.3347927362010523, 49.331397289096259, 5.156974553479813, 47.965004937705153, 5.0165917776503193, 46.448870958764303, 4.913644408708933, 44.792354203995608, 4.8574912983785907, 42.976736969955333, 4.8294147432097816, 18.905770341339089, 4.8294147432097816, 2.977004710738441, 2.6020080334092199, 2.977004710738441, 0.00024725473849684931, 61.207780124132817, 0.00024725473849684931, 62.003282520490671, 20.262161232560175],
       [63.154421282279088, 63.378391115151317, 46.795148472473009, 60.991883926079026, 2.977004710738441, 2.6020080334092199, 18.905770341339089, 4.8294147432097816, 63.154421282279088, 63.378391115151317],
       [63.154421282279088, 66.045663855878956, 7.8061721992166611, 66.045663855878956, 7.3756650200112404, 47.730391036209767, 10.258191350343189, 47.730391036209767, 10.267550202065051, 47.91756807063939, 10.38921527444918, 49.377548939250119, 10.576392308886341, 50.76265899408827, 10.829081305376461, 52.082257086869504, 11.1472822639196, 53.326984365881799, 11.53099518451574, 54.506199682829902, 11.980220067164881, 55.619903037728363, 12.485598060145181, 56.668094430580823, 13.16879423584072, 57.753721230321389, 14.01109089080785, 58.755118364548252, 14.96569376643728, 59.550620760910533, 16.02324401100714, 60.130869567670743, 16.060679417894558, 60.14958727110934, 16.78131100047753, 60.374199712430709, 17.698478469219541, 60.561376746871247, 18.802822972398641, 60.720477226139337, 20.103703361736791, 60.842142298530234, 21.601119637233921, 60.926371964029386, 23.295071798890039, 60.982525074359728, 25.176200994983279, 60.991883926079026, 46.795148472473009, 60.991883926079026, 63.154421282279088, 63.378391115151317, 63.154421282279088, 66.045663855878956],
     ],

123: [ [60.633346127309181, 102.52721928010942, 60.03864624976412, 102.44358960982936, 58.691279339701111, 102.2205771557492, 57.362496800811357, 101.96039595932962, 56.070883004268183, 101.64446164937908, 54.80714576448495, 101.30065078267944, 53.57128508146161, 100.90108680244884, 52.372593140784851, 100.46435407987883, 51.201777756868012, 99.981160429371812, 50.049546744124491, 99.460798036521737, 48.943776659314118, 98.893974715738295, 47.856590945677048, 98.280690467010572, 46.797281788799921, 97.620945290360396, 45.775141374269367, 96.924031371370802, 44.78087751649872, 96.189948710019962, 43.814490215488, 95.400112935159996, 42.885271656823839, 94.573108417949697, 41.974637469332968, 93.708935158389068, 41.101172024188649, 92.798300970898708, 40.478595589883703, 92.1013870518982, 39.577253587979442, 91.042077895021066, 38.750249070768348, 89.973476552560896, 37.978997667077103, 88.895583024510415, 37.263499376905713, 87.799105125279311, 36.622338571427427, 86.684042854889412, 36.036930879469033, 85.559688398898288, 35.507276301030458, 84.426041757331404, 35.042667021698378, 83.273810744591174, 34.643103041472791, 82.112287546260632, 34.308584360353713, 80.932179976760381, 34.02981879275444, 79.742780221669818, 33.81609852426169, 78.534796095398633, 33.658131369288782, 77.317519783551688, 33.56520951342236, 76.090951286121708, 33.537332956662453, 74.845798417511105, 33.537332956662453, 74.381189138170157, 33.574501699008998, 73.228958125429926, 33.63954699811552, 72.039558370339364, 33.751053225155196, 70.822282058488781, 33.899728194541467, 69.558544818708469, 34.085571906274311, 68.266931022171775, 34.299292174767061, 66.938148483281111, 34.559473371193008, 65.572197202040115, 34.856823309965527, 64.169077178459702, 35.191341991084641, 62.728788412528957, 35.31214040371097, 62.227010390848591, 35.674535641590012, 60.647338841121382, 35.981177765949177, 59.160589147249993, 36.250651147961783, 57.75746912366958, 36.464371416454533, 56.437978770369227, 36.631630757014079, 55.211410272928333, 36.752429169640443, 54.077763631361449, 36.826766654333568, 53.027746660070989, 36.854643211093482, 52.061359359060589, 36.826766654333568, 51.345861068890372, 36.705968241707211, 50.147169128209498, 36.455079230867881, 48.967061558709247, 36.092683992988867, 47.805538360378705, 35.618782528070142, 46.66259953322151, 35.024082650525088, 45.547537262820697, 34.308584360353713, 44.451059363600507, 33.472287657555967, 43.382458021140337, 32.524484727718523, 42.323148864259565, 32.041291077213181, 41.858539584929531, 31.149241260895572, 41.077995995648962, 30.192146145471501, 40.362497705478745, 29.17929791652756, 39.702752528828569, 28.101404388477139, 39.108052651281469, 26.967757746906869, 38.578398072841082, 25.778357991816758, 38.104496607931651, 24.523912937620139, 37.695640442110744, 23.213714769903699, 37.351829575411102, 21.8477634886674, 37.073064007810899, 20.416766908324579, 36.850051553730736, 20.416766908324579, 33.895136537179496, 21.243771425535702, 33.774338124549104, 22.637599263531911, 33.514156928129523, 23.97567398800831, 33.198222618178988, 25.248703413378198, 32.817243009129015, 26.465979725228241, 32.37121810096869, 27.627502923558438, 31.869440079288324, 28.723980822782131, 31.30261675850852, 29.764705608485968, 30.670748138611089, 30.740385095083361, 29.983126405200892, 31.66031146816087, 29.230459372691257, 32.524484727718523, 28.412747041060356, 33.082015862917018, 27.799462792339909, 33.964773493647961, 26.721569264289428, 34.736024897339213, 25.625091365069238, 35.377185702817492, 24.510029094668425, 35.906840281256052, 23.385674638688215, 36.324988632654907, 22.233443625940708, 36.613046385840789, 21.062628242019855, 36.789597911986988, 19.882520672519604, 36.854643211093482, 18.683828731849644, 36.84535102550683, 18.395770978659129, 36.808182283160278, 17.401507120888709, 36.724552612880501, 16.323613592838228, 36.585169829080883, 15.162090394511324, 36.408618302934691, 13.90764534031041, 36.176313663268651, 12.560278430250037, 35.897548095669407, 11.129281849909603, 35.5630294145503, 9.6146555992781941, 35.191341991084641, 8.0071074927982409, 35.051959207285023, 7.4124076152511407, 34.736024897339213, 5.9814110349107068, 34.447967144153317, 4.5782910113193793, 34.206370318900639, 3.221631915668695, 34.001942235994541, 1.9021415623683424, 33.83468289543498, 0.62911213700135704, 33.704592297222007, -0.616040731609246, 33.611670441355592, -1.8147326722901198, 33.555917327835751, -2.9762558706206619, 33.537332956662453, -4.1006103266008722, 33.546625142249098, -4.9461992149808793, 33.62096262694223, -6.1913520835987583, 33.751053225155196, -7.4179205810287385, 33.946189122474657, -8.6351968928793212, 34.206370318900639, -9.8338888335601951, 34.522304628846463, -11.013996403060446, 34.90328423789876, -12.1848117869813, 35.34930914605755, -13.33704279972153, 35.851087167736182, -14.479981626878725, 36.417910488521329, -15.604336082858936, 37.040486922826318, -16.719398353259749, 37.728108656237787, -17.815876252479939, 38.480775688755763, -18.89376978053042, 39.298488020380212, -19.962371123001503, 40.171953465524517, -21.012388094288326, 41.101172024188649, -22.053112879988475, 41.491443818827598, -22.461969045798469, 42.374201449558569, -23.354018862119119, 43.29412782263605, -24.208899936089438, 44.241930752473507, -25.017320082130027, 45.217610239070858, -25.779279300229973, 46.221166282428158, -26.504069775990502, 47.261891068132002, -27.182399323821301, 48.330492410595781, -27.823560129301768, 49.426970309819502, -28.418260006841592, 50.551324765803109, -28.975791142038361, 51.703555778546672, -29.486861349301762, 52.89295553363678, -29.951470628639072, 54.110231845486823, -30.378911165618774, 55.3553847140968, -30.759890774679661, 56.628414139466692, -31.094409455788991, 57.938612307183149, -31.391759394558903, 59.267394846072882, -31.64264840541, 60.633346127309181, -31.856368673899851, 60.633346127309181, -29.338186379918625, 60.47537897233628, -29.291725451988896, 58.997921464060283, -28.8921614717583, 57.604093626064042, -28.455428749188286, 56.275311087174309, -27.972235098681267, 55.020866032977693, -27.442580520240881, 53.840758463474231, -26.875757199461077, 52.734988378663871, -26.271765136330941, 51.703555778546672, -25.630604330850474, 50.746460663122583, -24.942982597440277, 49.854410846804988, -24.208899936089438, 49.045990700767192, -23.43764853239918, 48.311908039422491, -22.629228386358591, 47.754376904224017, -21.960191024121741, 46.95524894377283, -20.882297496078536, 46.258335024774709, -19.776527411260759, 45.6729273328163, -18.642880769690237, 45.199025867897568, -17.490649756950006, 44.827338444431909, -16.301250001859444, 44.557865062419317, -15.10255806117857, 44.399897907446409, -13.866697378158278, 44.344144793926567, -12.612252323961002, 44.353436979513219, -11.859585291451367, 44.409190093033061, -10.800276134570595, 44.511404134486099, -9.6666294930000731, 44.650786918285739, -8.4586453667288879, 44.836630630018561, -7.1856159413691785, 45.059643084097956, -5.8382490313015296, 45.32911646611057, -4.4165446365514072, 45.645050776056387, -2.9297949426800187, 46.0074460139354, -1.3594155785394832, 46.063199127455249, -1.0992343821089889, 46.388425622987711, 0.37822312616117415, 46.667191190586941, 1.809219706501608, 46.908788015839633, 3.1844631733292772, 47.122508284332383, 4.5225378977993387, 47.28976762489193, 5.8048595087602735, 47.41985822310491, 7.0407201917805651, 47.512780078971332, 8.2301199468711275, 47.568533192491167, 9.3730587740283227, 47.587117563664457, 10.460244487669115, 47.587117563664457, 10.618211642638926, 47.54065663573126, 11.8169035833198, 47.41985822310491, 13.015595524000673, 47.22472232578545, 14.204995279091236, 46.964541129359468, 15.385102848591487, 46.620730262653751, 16.574502603678411, 46.211874096841512, 17.745317987588351, 45.719388260749518, 18.925425557099516, 45.161857125551023, 20.096240941009455, 44.529988505659389, 21.257764139339997, 43.814490215488, 22.419287337670539, 43.03394662621011, 23.580810536008357, 42.179065552239067, 24.733041548748588, 42.114020253132587, 24.816671219028649, 41.37064540620127, 25.727305406519008, 40.571517445750082, 26.610063037249347, 39.73522074295235, 27.464944111219666, 38.852463112221422, 28.291948628429964, 37.932536739143899, 29.091076588891156, 36.966149438133193, 29.862327992570499, 35.953301209189249, 30.60570283951165, 34.90328423789876, 31.321201129678229, 33.806806338675052, 32.008822863088426, 32.663867511518127, 32.668568039738602, 31.483759942014672, 33.300436659628758, 30.257191444577991, 33.904428722769808, 28.993454204794752, 34.480544229139923, 27.68325603707828, 35.028783178750018, 26.326596941428619, 35.549145571600093, 26.410226611708399, 35.586314313950425, 27.794762264117971, 36.097384521210188, 29.132836988594359, 36.636331285240885, 30.415158599550889, 37.203154606020689, 31.66031146816087, 37.797854483571427, 32.859003408837623, 38.420430917871272, 34.001942235994541, 39.070883908931137, 35.107712320804858, 39.749213456758298, 36.157729292095361, 40.455419561349117, 37.170577521039291, 41.180210037098732, 38.136964822050011, 41.942169255209592, 39.047599009540882, 42.732005030069558, 39.921064454685201, 43.540425176110148, 40.748068971896281, 44.386014064490155, 41.528612561174178, 45.250187324050785, 42.253403036932212, 46.151529325961747, 42.26269522251885, 46.16082151154842, 43.117576296489887, 47.303760338698339, 43.888827700181132, 48.45599135143857, 44.595033804765869, 49.6082223641788, 45.22690242465751, 50.769745562520256, 45.775141374269367, 51.940560946430196, 46.258335024774709, 53.11137633035105, 46.667191190586941, 54.291483899851301, 47.001709871706048, 55.480883654938225, 47.252598882545357, 56.670283410039701, 47.438442594278193, 57.868975350720575, 47.549948821317876, 59.067667291390535, 47.587117563664457, 60.275651417650806, 47.587117563664457, 60.526540428490989, 47.559241006904521, 61.623018327718455, 47.494195707798042, 62.775249340458686, 47.391981666345004, 63.964649095549248, 47.252598882545357, 65.209801964159851, 47.076047356399179, 66.510707946290495, 46.862327087906429, 67.848782670760556, 46.620730262653751, 69.242610508761572, 46.332672509467841, 70.68289927468868, 46.0074460139354, 72.178941154139466, 45.747264817509432, 73.256834682189947, 45.42203832197697, 74.771460932821356, 45.133980568791081, 76.202457513150875, 44.892383743538403, 77.577700979978545, 44.697247846218943, 78.869314776518877, 44.539280691246027, 80.095883273959771, 44.437066649792968, 81.248114286700002, 44.372021350686467, 82.335300000340794, 44.344144793926567, 83.348148229288199, 44.372021350686467, 84.193737117668206, 44.492819763312838, 85.429597800688498, 44.725124402978871, 86.646874112539081, 45.059643084097956, 87.836273867629643, 45.496375806670102, 89.007089251550497, 46.044614756281959, 90.150028078700416, 46.695067747346883, 91.265090349101229, 47.447734779864838, 92.37086043391173, 48.311908039422491, 93.439461776379176, 48.349076781769071, 93.485922704308905, 49.092451628700388, 94.285050664759183, 49.910163960324837, 95.037717697279732, 50.802213776642439, 95.76250817304026, 51.777893263239797, 96.431545535269834, 52.818618048943648, 97.072706340761215, 53.933680319340631, 97.658114032710728, 55.12308007443076, 98.215645167911134, 56.386817314213992, 98.7174231895915, 57.734184224277023, 99.191324654508207, 59.146596433446547, 99.618765191491548, 60.633346127309181, 99.999744800541521, 60.633346127309181, 102.52721928010942],
     ],

124: [ [17.603327430348909, 102.5258967710397, 17.603327430348909, -31.861136700448697, 11.624243314032309, -31.861136700448697, 11.624243314032309, 102.5258967710397, 17.603327430348909, 102.5258967710397, 17.603327430348909, 102.5258967710397],
     ],

125: [ [12.778354385381499, 102.5248720951713, 12.778354385381499, 100.01017529153978, 13.71175712908911, 99.768588699051179, 15.380900859013281, 99.285415514070337, 16.951213710191919, 98.75831749408826, 18.41171447387558, 98.165332221618883, 19.78436556756321, 97.5174409054016, 21.058185782505319, 96.814643545429135, 22.233175118701951, 96.056940141708765, 23.32031478490256, 95.244330694251403, 24.297642363608158, 94.36583399428855, 25.176139063568229, 93.443412459339015, 25.615387413548291, 92.905333230610267, 26.526827739756872, 91.631513015669043, 27.306493560971461, 90.335730383230839, 27.9434036684425, 88.996022915780486, 28.437558062170069, 87.634353030851344, 28.788956742154092, 86.239739519660361, 28.997599708394599, 84.812182382229366, 29.06348696089163, 83.351681618540169, 29.06348696089163, 82.802621181068389, 28.997599708394599, 81.572725801121123, 28.887787620899619, 80.243999542428355, 28.712088280907579, 78.827423613751307, 28.470501688418551, 77.301035597571172, 28.174009052182051, 75.686797911388567, 27.822610372198, 73.984710555221682, 27.405324439716971, 72.172811111551709, 27.042944550983439, 70.547592216618796, 26.691545870999391, 68.878448486699199, 26.406034443512372, 67.275192009281454, 26.175429059772831, 65.748803993090405, 25.988748511031329, 64.277322020661813, 25.856974006037319, 62.882708509470831, 25.780105544790789, 61.543001042031392, 25.747161918542311, 60.280162035840476, 25.758143127291788, 59.643251928369864, 25.856974006037319, 58.25961962592919, 26.054635763528321, 56.87598732349943, 26.35112839976486, 55.503336229809065, 26.746451914746899, 54.1306851361187, 27.24060630847444, 52.758034042428335, 27.844572789697001, 51.396364157499193, 28.536388940915572, 50.045675481309445, 29.338017179629158, 48.694986805119697, 30.227495088338738, 47.34429812892995, 31.226785084543341, 46.004590661490511, 32.072338158254922, 44.972357039041526, 33.005740901962533, 43.951104625328298, 33.994049689417608, 42.962795837880549, 35.048245729369711, 42.018411885419482, 36.146366604319837, 41.106971559209342, 37.310374731766927, 40.239456068000436, 38.529288902961547, 39.404884203038819, 39.814090326653201, 38.61423717307116, 41.153797794092327, 37.845552560611395, 42.548411305278947, 37.131773991888622, 43.997930860213103, 36.450939049431327, 45.513337667644258, 35.803047733199492, 47.083650518822907, 35.188100043229497, 45.55726250264226, 34.628058397011046, 44.0198932777121, 33.991148289529519, 42.537430096529448, 33.321294555818895, 41.109872959094297, 32.618497195850068, 39.759184282905693, 31.871775000880007, 38.463401650464561, 31.092109179669933, 37.233506270520422, 30.279499732201657, 36.058516934323819, 29.422965449739422, 34.949414850624208, 28.533487541029899, 33.90620001942159, 27.600084797330055, 32.928872440715992, 26.633738427368371, 32.017432114507422, 25.634448431159399, 31.16089783204632, 24.591233599960105, 30.754593108314801, 24.075116788739251, 29.799227947108189, 22.746390530050121, 28.953674873396611, 21.406683062610682, 28.206952678430529, 20.066975595171243, 27.548080153460461, 18.716286918981496, 26.999019715985408, 17.34363582529113, 26.548790157255869, 15.970984731600765, 26.19739147727185, 14.598333637921314, 25.955804884782822, 13.203720126730332, 25.802067962289811, 11.79812540678904, 25.747161918542311, 10.392530686858663, 25.769124336041301, 9.3163722294084437, 25.84599279728781, 7.9986271794696222, 25.96678609353231, 6.6040136682786397, 26.15346664227383, 5.1544941133397515, 26.384072026013371, 3.6281060971705301, 26.66958345350039, 2.0358308284885425, 27.010000924734921, 0.3666870985616697, 27.405324439716971, -1.3573626751094707, 27.624948614706991, -2.3127278363208461, 28.00929092093952, -4.0697212362283608, 28.338727183424538, -5.7388649661588715, 28.602276193412571, -7.3091778173402417, 28.799937950903601, -8.7806597897688334, 28.953674873396611, -10.153310883459199, 29.041524543392629, -11.427131098400423, 29.06348696089163, -12.602120434599783, 29.05250575214211, -13.260992959571013, 28.920731247148101, -14.721493723249296, 28.646201028410591, -16.138069651940896, 28.239896304679039, -17.52170195438157, 27.67985465845447, -18.872390630571317, 26.988038507235931, -20.190135680499225, 26.15346664227383, -21.463955895451363, 25.176139063568229, -22.704832484141662, 24.703947087339689, -23.220949295369792, 23.77054434363211, -24.110427204079315, 22.738310721179001, -24.955980277791241, 21.6072462199804, -25.735646099001315, 20.38833204878577, -26.471387085221068, 19.059605790096128, -27.152222027689277, 17.632048652660981, -27.77815092640958, 16.11664184522985, -28.34917378137834, 14.49142295030367, -28.865290592610108, 12.778354385381499, -29.337482568840642, 12.778354385381499, -31.852179372468527, 12.833260429129011, -31.852179372468527, 14.41455448905716, -31.599611571229616, 15.95192371398733, -31.292137726250076, 17.456349312668969, -30.918776628768683, 18.916850076352631, -30.501490696289693, 20.333426005038259, -30.018317511308851, 21.71705830747538, -29.480238282580103, 23.056765774914538, -28.887253010099812, 24.363529616105151, -28.228380485139496, 25.626368622297779, -27.52558312517067, 26.856264002241922, -26.756898512699991, 28.042234547188031, -25.922326647738373, 29.18428025713613, -25.043829947779159, 30.293382340835731, -24.099445995329006, 31.35855958953735, -23.111137207870343, 32.37981200324095, -22.045959959170432, 32.862985188219, -21.518861939188355, 33.895218810672098, -20.288966559248365, 34.850583971878713, -19.037108761800482, 35.729080671838773, -17.774269755609566, 36.51972770180285, -16.489468331921671, 37.222525061770938, -15.18270449072952, 37.848453960492492, -13.864959440790699, 38.386533189218063, -12.52525197335126, 38.836762747947603, -11.163582088411204, 39.210123845430608, -9.7909309947208385, 39.506616481667152, -8.3963174835407699, 39.71525944790767, -6.9797415548491699, 39.836052744152198, -5.5521844174218131, 39.8799775791502, -4.102664862479287, 39.8799775791502, -3.9818715662404429, 39.847033952901683, -2.6751077250482922, 39.770165491655177, -1.3024566313615651, 39.638390986661172, 0.11411929731912096, 39.451710437919637, 1.5856012697586266, 39.221105054180128, 3.1119892859387619, 38.935593626693112, 4.6932833458704408, 38.606157364208059, 6.3294834495391115, 38.22181505797554, 8.0096083882199309, 38.155927805478512, 8.2841386069485452, 37.727660664247992, 10.128981676869444, 37.376261984263948, 11.853031450540584, 37.079769348027412, 13.456287927969242, 36.860145173037381, 14.938751109151781, 36.695427041794893, 16.300420994088199, 36.596596163049348, 17.552278791528806, 36.56365253680088, 18.683343292730569, 36.574633745550358, 19.243384938959935, 36.717389459293877, 20.627017241400608, 37.024863304279911, 21.977705917579442, 37.486074071758956, 23.317413385018881, 38.112002970480518, 24.624177226211032, 38.902650000444602, 25.908978649898927, 39.847033952901683, 27.171817656089843, 40.956136036601293, 28.412694244791055, 41.011042080348801, 28.467600288531685, 42.010332076553389, 29.411984240989113, 43.097471742754003, 30.268518523458624, 44.261479870201129, 31.037203135918389, 45.513337667644258, 31.718038078390236, 46.842063926333871, 32.322004559609923, 48.25863985501951, 32.849102579588362, 49.752084244951682, 33.277369720821298, 51.33337830487983, 33.628768400798435, 52.991540826054489, 33.892317410791293, 52.991540826054489, 36.846262564409699, 52.859766321060476, 36.868224981899402, 51.212585008635301, 37.142755200638931, 49.642272157456652, 37.49415388063062, 48.148827767524523, 37.944383439360536, 46.743233047588369, 38.471481459331699, 45.425487997648247, 39.086429149301694, 44.184611408954623, 39.78922650927052, 43.031584490257011, 40.568892330480594, 41.955426032805882, 41.447389030450722, 40.956136036601293, 42.402754191651184, 40.538850104120257, 42.842002541641705, 39.484654064168147, 44.082879130328365, 38.595176155458581, 45.345718136519281, 37.859435169242012, 46.630519560210814, 37.28841231426793, 47.948264610149636, 36.882107590536407, 49.298953286339383, 36.640520998047378, 50.66062317127944, 36.56365253680088, 52.066217891209817, 36.56365253680088, 52.219954813710501, 36.607577371798868, 53.362000523651659, 36.706408250544371, 54.624839529849851, 36.882107590536407, 56.008471832279611, 37.123694183025407, 57.512897430970042, 37.420186819261943, 59.138116325888404, 37.793547916744977, 60.873147308309854, 38.22181505797554, 62.728971586981061, 38.232796266725018, 62.80584004821867, 38.617138572957572, 64.474983778149181, 38.957556044192103, 66.100202673078456, 39.232086262929641, 67.670515524259827, 39.462691646669157, 69.196903540439962, 39.649372195410677, 70.668385512868554, 39.770165491655177, 72.08496144154924, 39.847033952901683, 73.457612535250519, 39.8799775791502, 74.775357585178426, 39.86899637040068, 75.544042197649105, 39.78114670040469, 77.004542961331026, 39.616428569162167, 78.432100098769297, 39.363860767923647, 79.837694818699674, 39.034424505438608, 81.232308329890657, 38.628119781707063, 82.604959423581022, 38.133965387979522, 83.955648099770769, 37.551961324255963, 85.284374358448986, 36.904070008035411, 86.602119408398721, 36.157347813069322, 87.897902040840563, 35.333757156856741, 89.171722255781788, 34.433298039397641, 90.423580053218757, 33.444989251942559, 91.65347543316966, 32.37981200324095, 92.872389604359341, 31.35855958953735, 93.904623226808326, 30.293382340835731, 94.892932014270627, 29.18428025713613, 95.826334757970471, 28.031253338438521, 96.7048314579406, 26.845282793492402, 97.52842211414827, 25.615387413548291, 98.286125517868641, 24.35254840735567, 98.988922877830191, 23.045784566165029, 99.636814194051112, 21.69509588997639, 100.21881825778109, 20.311463587539269, 100.74591627774862, 18.883906450104121, 101.21810825397915, 17.412424477670982, 101.63539418646178, 15.90799887898933, 101.98679286644983, 14.359648445309659, 102.28328550267906, 12.778354385381499, 102.5248720951713],
     ],

126: [ [5.453588532201791, 42.140679415020713, 4.8245972930423022, 41.21086627888144, 4.2411851291842311, 40.217242437309324, 3.7215836707481169, 39.168923705368798, 3.2475612876134221, 38.075025898138847, 2.828233794840429, 36.917317385479691, 2.4727170074894209, 35.714029797531111, 2.1627792954398042, 34.446931504149688, 1.907536473751889, 33.12513832041077, 1.7069885424256761, 31.757766061360599, 1.5520196864008819, 30.326583096899412, 1.460861535798045, 28.84070524208073, 4.6331651767763731, 28.84070524208073, 4.6422809918366559, 28.913631762559817, 4.9886819641274078, 30.408625432439294, 5.3897778267798344, 31.803345136660937, 5.827336949673394, 33.106906690278265, 6.3287067779889412, 34.319310093298554, 6.866539866545593, 35.431439530661009, 7.4590678454639772, 36.452410817408236, 8.1062907147440342, 37.373108138501266, 8.7899768442652242, 38.202647308979067, 9.5374736792083752, 38.941028328870743, 9.9021062816196945, 39.260081855980388, 10.89573012319047, 39.998462875861151, 11.934933040062701, 40.61833829995885, 13.03794666235688, 41.128823943341558, 14.20477099007303, 41.529919805991085, 15.426290208150901, 41.812510072861187, 16.702504316590449, 41.97659474394095, 18.042529130451982, 42.040405449359241, 5.453588532201791, 42.140679415020713],
       [78.36187738434154, 48.667602998189977, 75.12576303794124, 48.667602998189977, 74.970794181916446, 47.473431225291279, 74.724667175288815, 46.106058966248384, 74.396497833118644, 44.820729042749008, 73.986286155405921, 43.608325639728719, 73.503147957210956, 42.477964572259225, 72.947083238533722, 41.420530025261542, 72.308976184313934, 40.445137813818292, 71.588826794551622, 39.542672122839576, 70.79575088430704, 38.722248767418932, 69.884169378278784, 37.93828867224147, 68.881429721647706, 37.227255097528541, 67.823995174654925, 36.625611303559708, 66.711865737300457, 36.133357290298591, 65.5450414095843, 35.750493057770655, 64.323522191506441, 35.477018605961348, 63.047308083066859, 35.312933934870671, 61.716399084265618, 35.258239044509537, 40.03899087091375, 34.911838072221144, 41.61602687634263, 34.282846833059011, 43.101904731168673, 33.699434669211769, 44.496624435391908, 33.152485765589518, 45.800185989012299, 32.642000122210447, 47.021705207090172, 32.167977739070921, 48.152066274565222, 31.739534431239008, 49.191269191437407, 31.356670198711072, 50.148429772767088, 31.001153411358246, 51.005316388433641, 30.691215699309396, 51.78016066855767, 30.426857062560885, 52.463846798078862, 30.198961686059192, 53.0654905920575, 30.007529569789767, 53.566860420373047, 29.852560713759885, 54.478441926401302, 29.597317892079445, 55.7820034800217, 29.269148549909005, 57.05821758846124, 29.023021543278446, 58.307084251719971, 28.84070524208073, 59.519487654737532, 28.731315461351187, 60.70454361257427, 28.703968016168801, 60.832165023418213, 28.703968016168801, 62.117494946918072, 28.74954709146914, 63.375477425237051, 28.886284317370155, 64.587880828254626, 29.114179693879123, 65.772936786091364, 29.424117405931611, 66.921529483686953, 29.825213268588413, 68.024543105981152, 30.30835146678146, 69.100209283094486, 30.882647815571545, 70.139412199966699, 31.538986499919702, 71.142151856597764, 32.286483334861259, 72.099312437927438, 33.116022505349974, 73.029125574076261, 34.036719826439366, 73.585190292753495, 34.638363620408199, 74.305339682515793, 35.522597681261686, 74.970794181916446, 36.470642447529826, 75.572437975895085, 37.455150474041147, 76.119386879512035, 38.50346920597076, 76.602525077707014, 39.597367013211624, 77.030968385540291, 40.736843895738275, 77.40471680301188, 41.931015668640612, 77.714654515061483, 43.179882331900444, 77.960781521689114, 44.474328070460615, 78.152213637955043, 45.823468699378282, 78.288950863859284, 47.218188403599925, 78.36187738434154, 48.667602998189977],
       [18.325119397320751, 48.886382559630874, 17.805517938884631, 48.877266744580993, 16.565767090686219, 48.795224409030197, 15.344247872608349, 48.612908107821568, 14.16830772983192, 48.339433656019537, 13.01971503223632, 47.965685238541482, 11.898469779821561, 47.500778670470027, 10.81368778764795, 46.944713951790618, 9.7653690557154391, 46.288375267460651, 8.7443977689638075, 45.549994247568975, 7.7507739273929976, 44.702223446969583, 6.7936133460633519, 43.763294495758601, 6.1372746617229827, 43.024913475870562, 5.453588532201791, 42.140679415020713, 18.042529130451982, 42.040405449359241, 18.771794335274588, 42.013058004180493, 19.601333505760291, 41.931015668640612, 20.51291501178855, 41.794278442739596, 21.497423038299079, 41.602846326470171, 22.563973400352129, 41.365835134900408, 23.703450282887449, 41.065013237908715, 24.915853685905041, 40.709496450559527, 26.210299424465148, 40.299284772849205, 27.586787498567819, 39.834378204770474, 29.02708627809244, 39.314776746341522, 30.549427393159618, 38.740480397540523, 32.144695028709073, 38.11148915837839, 33.822004999801067, 37.427803028858762, 34.779165581130741, 37.03582298127003, 36.620560223307791, 36.288326146328473, 38.379912529942352, 35.577292571619182, 40.03899087091375, 34.911838072221144, 61.716399084265618, 35.258239044509537, 61.607009303542242, 35.258239044509537, 60.859512468599057, 35.29470230474908, 60.039089113173638, 35.385860455360671, 59.145739237265957, 35.522597681261686, 58.179462840875999, 35.714029797531111, 57.1402599240038, 35.960156804150756, 56.028130486649331, 36.251862886081653, 54.852190343872877, 36.607379673441756, 53.594207865553891, 37.008475536091282, 52.272414681812933, 37.464266289098305, 50.877694977589691, 37.965636117420217, 49.40093293782391, 38.530816651149507, 47.860360192636158, 39.14157626019005, 46.24686092696615, 39.807030759591726, 44.560435140813887, 40.527180149361811, 43.894980641413269, 40.809770416228275, 42.436450231768049, 41.420530025261542, 41.014383082363977, 42.003942189119698, 39.628779193201041, 42.569122722859902, 38.279638564279232, 43.106955811410444, 36.96696119559855, 43.635673084911105, 35.681631272098713, 44.127927098168584, 34.441880423900272, 44.601949481300835, 33.229477020882712, 45.057740234311495, 32.053536878106257, 45.486183542150684, 30.914059995570941, 45.896395219861006, 29.811046373276749, 46.279259452388942, 28.735380196163419, 46.643892054809839, 27.705293094351472, 46.990293027098232, 26.702553437720411, 47.309346554200602, 25.74539285639074, 47.601052636131499, 24.81557972024191, 47.874527087951719, 24.615031788915701, 47.93833779337001, 23.329701865415871, 48.275622950590332, 22.062603572036579, 48.549097402399639, 20.8046210937176, 48.731413703608268, 19.564870245519181, 48.849919299398607, 18.325119397320751, 48.886382559630874],
     ],

127: 63,

128: [ [67.34085697645996, 20.556157960148994, 66.584244326456499, 19.526070858340972, 65.608852115006272, 18.204277674598416, 64.651691533676612, 16.973642641460174, 63.730994212588058, 15.806818313751137, 62.846760151740646, 14.722036321571068, 61.980757721013823, 13.719296664941794, 61.151218550528107, 12.789483528791607, 60.358142640283518, 11.941712728188577, 59.583298360159517, 11.166868448060995, 58.844917340276623, 10.464950688419776, 58.142999580634857, 9.8541910793901479, 57.459313451113672, 9.3072421757606207, 56.830322211954183, 8.8332197926283698, 55.836698370383402, 8.1677652932303317, 54.815727083631742, 7.5570056841897895, 53.758292536638983, 7.0009409655212949, 52.664394729405082, 6.4904553221385868, 51.543149476990322, 6.0346645691315643, 50.385440964334443, 5.642684521528281, 49.191269191437407, 5.2962835492398881, 47.960634158299278, 4.9954616522481956, 46.702651679980271, 4.7584504606784321, 45.408205941420157, 4.5761341594807163, 44.077296942618908, 4.439396933579701, 42.719040498636808, 4.3573545980289055, 41.31520497935329, 4.3300071528501576, 20.139166594316979, 4.0291852558584651, 21.10544299070693, 3.3272674962208839, 22.08995101721743, 2.6800446269407985, 23.092690673848519, 2.0692850179002562, 24.131893590720718, 1.5132202992208477, 25.189328137713488, 0.99361884078825824, 26.264994314826851, 0.51959645765964524, 27.377123752181319, 0.10026896488125203, 28.507484819656359, -0.28259526765032206, 29.665193332312221, -0.6198804248815577, 30.841133475088672, -0.91158650680881692, 32.044421063045966, -1.1577135134393757, 33.275056096184102, -1.3673772598194773, 34.533038574503109, -1.5223461158493592, 35.809252682942663, -1.6317358965716267, 37.112814236563061, -1.7046624170616269, 38.434607420304019, -1.7228940471795795, 38.562228831147991, -1.7228940471795795, 39.90225364500953, -1.6955466019899177, 41.224046828750488, -1.6226200815108314, 42.527608382370879, -1.4949986706706113, 43.803822490810433, -1.3309139995799342, 45.052689154069149, -1.1121344381390372, 46.283324187207278, -0.85689161645132117, 47.495727590224867, -0.5469539043988334, 48.680783548061612, -0.19143711704964517, 49.838492060717471, 0.21877456067159073, 50.987084758313067, 0.66544949862145586, 52.099214195667543, 1.1577035118716594, 53.193112002901437, 1.7046524154902727, 54.268778180014799, 2.2971803944092244, 55.317096911947289, 2.9352874486285145, 56.347184013759197, 3.6189735781517811, 57.349923670390297, 4.3482387829717482, 58.325315881840531, 5.1230830630993296, 58.398242402322779, 5.1868937685212586, 59.118391792085099, 5.8158850076797535, 59.856772811967993, 6.4995711371993821, 60.604269646911149, 7.2379521570801444, 61.36088229691461, 8.0310280673293164, 62.126610761978363, 8.8879146830004174, 62.910570857162639, 9.7994961890217382, 63.703646767407243, 10.765772585411469, 64.505838492712087, 11.786743872158695, 65.317146033077236, 12.862410049270693, 66.146685203562939, 14.001886931808258, 66.985340189108939, 15.196058704710595, 67.833110989715209, 16.444925367970427, 68.699113420442046, 17.748486921591393, 69.574231666229181, 19.11585918063065, 67.34085697645996, 20.556157960148994],
       [25.499265849763109, 95.159988413510291, 24.478294563011481, 94.521881359291001, 23.466439091320101, 93.84731104482853, 22.481931064809601, 93.127161655058444, 21.515654668419639, 92.370549005059729, 20.558494087089969, 91.568357279760676, 19.628680950941138, 90.729702294211165, 18.71709944491289, 89.845468233361316, 17.823749569005201, 88.924770912268286, 16.948631323218081, 87.958494515878556, 16.09174470755152, 86.955754859249282, 15.79092281056219, 86.582006441778503, 15.052541790679321, 85.652193305628316, 14.34150821597728, 84.704148539360176, 13.64870627139581, 83.737872142970446, 12.98325177199518, 82.753364116459124, 12.33602890271513, 81.741508644769056, 11.71615347861592, 80.711421542961034, 11.11450968463725, 79.663102811031422, 10.54021333583947, 78.596552448969305, 9.9841486171622194, 77.51177045680015, 9.4554313436658504, 76.399641019448609, 8.954061515350304, 75.269279951968201, 8.4618075020950414, 74.120687254369841, 8.0060167490809135, 72.953862926660804, 7.5593418111270694, 71.759691153758467, 7.1491301334143591, 70.556403565798973, 6.7480342707619343, 69.325768532660732, 6.3834016683506141, 68.076901869411813, 6.0278848809996068, 66.800687760969595, 5.708831353889706, 65.515357837470219, 5.3988936418401181, 64.202680468788458, 5.1254191900316348, 62.871771469988744, 4.861060553283437, 61.522630841071077, 4.6331651767763731, 60.155258582020906, 4.4143856153295919, 58.769654692860058, -1.638515584698012, 58.769654692860058, -3.2975939256694171, 53.14519680066951, 3.8400892665318049, 53.14519680066951, 3.7853943761701032, 52.078646438611031, 3.7398153008686839, 50.747737439811317, 3.7033520406275491, 49.498870776551485, 3.6942362255672658, 48.313814818720857, 3.6942362255672658, 47.156106306061702, -1.638515584698012, 47.156106306061702, -3.2975939256694171, 41.531648413860239, 3.9859423074963161, 41.531648413860239, 4.0406371978580182, 40.784151578918681, 4.1773744237622452, 39.31650535422159, 4.3323432797870387, 37.876206574688695, 4.4964279508721461, 36.454139425288304, 4.696975882198358, 35.059419721059385, 4.9066396285848546, 33.692047462020128, 5.1345350050919194, 32.342906833098823, 5.3897778267798344, 31.011997834299109, 5.6632522785883159, 29.708436280681781, 5.9549583605173382, 28.432222172239562, 6.274011887627239, 27.174239693918935, 6.6021812297973952, 25.943604660780693, 6.9576980171484299, 24.740317072821199, 7.3314464346200046, 23.555261114990572, 7.7234264822121466, 22.388436787270621, 8.1427539749851405, 21.248959904740332, 8.5803130978787294, 20.136830467381515, 9.0269880358325736, 19.042932660151564, 9.5010104189672404, 17.976382298089447, 10.00238024728278, 16.928063566159835, 10.51286589065862, 15.907092279408971, 11.0506989792153, 14.904352622779697, 11.60676369789252, 13.928960411329172, 12.1810600466903, 12.980915645061032, 12.77358802560869, 12.051102508910844, 13.34788437440648, 11.21244752336861, 14.104497024409939, 10.155012976370926, 14.8975729346545, 9.1431575046808575, 15.70888047501967, 8.176881108291127, 16.547535460565651, 7.256183787201735, 17.413537891292489, 6.3810655414199573, 18.2977719521399, 5.5515263709312421, 19.209353458168149, 4.7675662757501414, 20.139166594316979, 4.0291852558584651, 41.31520497935329, 4.3300071528501576, 41.205815198629921, 4.3300071528501576, 40.011643425732892, 4.375586228150496, 38.853934913077012, 4.4940918239408347, 37.723573845601983, 4.6764081251385505, 36.620560223307791, 4.9407667618906999, 35.544894046194457, 5.2689361040611402, 34.496575314261968, 5.6791477817714622, 33.466488212450031, 6.1531701649109891, 32.47286437087925, 6.7001190685296024, 31.506587974489289, 7.319994492620026, 30.567659023280189, 8.0127964372113638, 29.65607751725193, 8.778524902270874, 28.762727641344242, 9.6171798878203845, 27.905841025677692, 10.528761393848981, 27.076301855191989, 11.504153605288593, 26.274110129887141, 12.561588152289914, 25.490150034702818, 13.691949219759408, 24.742653199759651, 14.886120992661745, 24.02250380999735, 16.15321928603953, 23.65787120758603, 16.846021230619954, 23.15650137927048, 17.857876702310023, 22.67336318107553, 18.887963804121682, 22.217572428061398, 19.945398351119366, 21.789129120228129, 21.030180343288521, 21.378917442515391, 22.133193965579267, 20.986937394923249, 23.263555033059674, 20.622304792511962, 24.412147730661673, 20.28501963528149, 25.588087873431505, 19.96596610817161, 26.791375461390999, 19.66514421118228, 28.012894679468445, 19.391669759373801, 29.261761342721002, 19.14554275274617, 30.528859636098787, 18.917647376239099, 31.823305374658958, 18.71709944491289, 33.135982743340719, 18.534783143707241, 34.476007557208504, 18.370698472622159, 35.843379816251399, 18.233961246717911, 37.228983705408609, 18.124571465994531, 38.641935039759119, 18.033413315391702, 40.073118004220305, 17.969602609969741, 41.531648413860239, 55.946088151106778, 41.531648413860239, 57.605166492078212, 47.156106306061702, 17.823749569005201, 47.156106306061702, 17.823749569005201, 48.003877106668369, 17.851097014186049, 49.280091215099674, 17.896676089487471, 50.565421138599049, 17.96048679490946, 51.850751062109339, 18.042529130451982, 53.14519680066951, 59.410097874014163, 53.14519680066951, 61.069176214985561, 58.769654692860058, 18.470972438285258, 58.769654692860058, 18.616825479249801, 60.018521356119891, 18.799141780455439, 61.477051765770739, 18.999689711781649, 62.908234730228287, 19.218469273228429, 64.312070249510725, 19.45548046479578, 65.688558323621692, 19.710723286483699, 67.037698952539358, 19.984197738292181, 68.359492136271001, 20.275903820221199, 69.653937874838448, 20.58584153227082, 70.911920353159076, 20.914010874440979, 72.151671201350837, 21.260411846731731, 73.364074604371126, 21.625044449143019, 74.540014747148234, 22.007908681674909, 75.697723259811028, 22.399888729267051, 76.818968512219726, 22.819216222040041, 77.921982134521386, 23.256775344933601, 78.988532496568951, 23.703450282887449, 80.027735413441405, 24.17747266602214, 81.048706700188632, 24.669726679277399, 82.033214726699953, 25.171096507592949, 82.990375308028888, 25.672466335908471, 83.874609368878737, 26.419963170851648, 85.077896956838231, 27.18569163591539, 86.21737383936852, 27.978767546159961, 87.283924201419723, 28.80830671664566, 88.277548042988201, 29.65607751725193, 89.207361179138388, 30.531195763039079, 90.073363609870285, 31.442777269067339, 90.866439520108543, 32.37259040521613, 91.586588909878628, 33.329750986545811, 92.242927594219509, 34.323374828116613, 92.826339758081303, 35.335230299807961, 93.345941216510255, 36.374433216680188, 93.792616154471034, 37.440983578733238, 94.166364571930899, 38.53488138596714, 94.476302283990663, 39.665242453442168, 94.722429290610307, 40.813835151037779, 94.89562977676178, 41.989775293814198, 94.995903742419614, 43.19306288177151, 95.032367002659157, 25.499265849763109, 95.159988413510291],
       [43.19306288177151, 99.790822464128723, 43.156599621530368, 99.790822464128723, 41.853038067909971, 99.763475018949975, 40.558592329349857, 99.699664313531684, 39.291494035970572, 99.599390347859298, 38.0335115576516, 99.453537306901126, 36.802876524513472, 99.271221005688858, 35.590473121495883, 99.043325629190804, 34.38718553353857, 98.778966992438654, 33.211245390762137, 98.469029280389805, 32.053536878106257, 98.113512493040616, 30.914059995570941, 97.730648260509042, 29.792814743156189, 97.293089137609059, 28.698916935922281, 96.828182569541241, 27.61413494374867, 96.308581111101375, 26.547584581695592, 95.752516392429243, 25.499265849763109, 95.159988413510291, 43.19306288177151, 95.032367002659157, 43.986138792016114, 95.023251187598362, 45.235005455274802, 94.968556297240866, 46.447408858292377, 94.859166516518599, 47.62334900106881, 94.704197660488717, 48.762825883604137, 94.503649729158496, 49.865839505898322, 94.248406907481694, 50.923274052891109, 93.947585010490002, 51.944245339642748, 93.592068223140814, 52.928753366153281, 93.200088175541168, 53.876798132422643, 92.744297422530508, 54.7792638233906, 92.242927594219509, 55.654382069177728, 91.695978690600896, 56.483921239663452, 91.094334896621149, 57.27699714990802, 90.447112027341063, 58.024493984851198, 89.754310082760639, 58.744643374613531, 89.006813247819082, 59.419213689074432, 88.21373733756991, 60.057320743294213, 87.365966536959604, 60.658964537272851, 86.47261666104896, 61.224145071010383, 85.524571894791734, 61.752862344506752, 84.530948053219618, 62.236000542701731, 83.491745136350801, 62.682675480655583, 82.397847329109936, 63.092887158368278, 81.258370446579647, 63.466635575839888, 80.064198673680949, 63.794804918010037, 78.824447825478273, 64.086510999939094, 77.539117901978898, 64.350869636687293, 76.199093088118389, 64.569649198134059, 74.813489198961179, 64.742849684279435, 73.373190419428283, 64.888702725243959, 71.887312564609601, 67.696373763810968, 71.887312564609601, 67.696373763810968, 93.446215182171727, 67.541404907786173, 93.519141702650813, 66.329001504768598, 94.129901311698632, 65.116598101751009, 94.713313475560426, 63.904194698733448, 95.260262379171763, 62.691791295715859, 95.779863837611629, 61.47938789269827, 96.263002035801037, 60.266984489680709, 96.718792788818973, 59.05458108666312, 97.138120281590091, 57.833061868585283, 97.530100329178822, 56.620658465567679, 97.894732931588806, 55.399139247489842, 98.22290227377016, 54.186735844472253, 98.514608355690143, 52.96521662639438, 98.78808280749945, 51.743697408316542, 99.015978184008418, 50.531294005298939, 99.22564193038852, 49.309774787221102, 99.398842416539992, 48.088255569143229, 99.535579642441007, 46.866736351065377, 99.644969423170551, 45.636101317927228, 99.727011758710432, 44.414582099849383, 99.772590834010771, 43.19306288177151, 99.790822464128723],
     ],

129: 63,

130: [ [5.7165071826405551, 182.92768670300939, 4.4792875118618829, 182.76730637532091, 3.1275104641592288, 182.17160801532009, 1.8902907933805291, 181.11768014761037, 1.603897351070656, 180.79691949222979, 0.80199571260297375, 179.55969982144961, 0.32085472952238092, 178.1277326099007, 0.16047440182885001, 176.51247359527042, 0.29794325413757861, 175.05759490833952, 0.7447170241410106, 173.63708343448161, 1.4893399741467019, 172.33112933754819, 2.5432678418470678, 171.17409983061953, 3.1160547264668419, 170.68150310984129, 4.3303629218607389, 169.92542442214108, 5.7165071826405551, 169.37554901291151, 7.251576033421542, 169.04333261982902, 8.9584809495884485, 168.94023098059915, 9.2906973426678974, 168.94023098059915, 10.66538586575532, 169.04333261982902, 12.040074388842781, 169.283903111369, 13.40330717423782, 169.6733981929101, 14.76653995963286, 170.20036212676132, 16.11831700733552, 170.86479491291902, 17.458638317345759, 171.66669655139049, 18.787503889663611, 172.60606704216116, 10.4706383249846, 173.25904409063151, 9.1761399657439426, 173.76309654910074, 8.6720875072785475, 174.78265720371928, 8.6720875072785475, 174.79411294142119, 9.3937989818994652, 176.14588998911131, 10.12696619421277, 177.3601981845095, 10.40190389883025, 178.88381129760091, 10.40190389883025, 178.96400146144879, 10.035320292673591, 180.32723424684082, 9.0272153757427986, 181.6217326060796, 8.5804416057393951, 181.99977194992971, 7.2172088203443527, 182.6871162114694, 5.7165071826405551, 182.92768670300939],
       [16.018818187069261, 0.074709186908876291, 16.866588987675549, -0.63632438778950018, 17.8784444593669, -1.2379681817801611, 19.01792134190222, -1.6664114896084357, 20.266788005160919, -1.930770126360585, 21.64327607926359, -2.0128124619004666, 21.94409797625292, -2.0036966468396713, 23.192964639511612, -1.8122645305702463, 24.37802059734835, -1.3655895926203812, 25.918593342536099, -0.58162949743928039, 27.094533485312549, -0.089375484181800857, 27.842030320255731, 0.074709186908876291, 16.018818187069261, 0.074709186908876291],
       [23.22942789975275, 14.423002091789385, 22.226688243121689, 14.377423016489047, 20.968705764802682, 14.185990900219622, 19.783649806965968, 13.848705742988386, 18.6715203696115, 13.347335914681025, 17.632317452739269, 12.700113045390026, 16.666041056349311, 11.897921320090973, 16.192018673214641, 11.433014752019517, 15.380711132849481, 10.44850672550092, 14.742604078629711, 9.4001879935713077, 14.29592914067586, 8.2789427411589713, 14.022454688867381, 7.0938867833210679, 13.93129653826457, 5.8450201200612355, 13.93129653826457, 5.7812094146393065, 14.022454688867381, 4.3956055254784587, 14.277697510555299, 3.1285072321006737, 14.68790918826801, 1.9890303495594708, 15.271321352126099, 0.96805906280860654, 16.018818187069261, 0.074709186908876291, 27.842030320255731, 0.074709186908876291, 27.842030320255731, 0.074709186908876291, 28.853885791947079, -0.57251368237120914, 29.32790817508177, -1.5752533390113967, 29.501108661227128, -2.8788148926287249, 29.491992846166848, -3.3710689058789285, 29.409950510624331, -4.5834723088992178, 29.23675002447894, -5.7867598968587117, 28.97239138773077, -6.9718158546893392, 28.616874600379731, -8.13864018240929, 28.17019966242589, -9.2963486950684455, 27.62325075880895, -10.435825577598735, 26.994259519649429, -11.557070830018347, 26.274110129887141, -12.669200267369888, 25.462802589521971, -13.763098074599839, 25.38987606903973, -13.863372040268587, 24.615031788915701, -14.765837731229112, 23.785492618429998, -15.631840161961009, 22.910374372642881, -16.452263517388928, 21.971445421433771, -17.227107797509234, 20.986937394923249, -17.956373002329201, 19.947734478051039, -18.64005913184883, 18.853836670817142, -19.287282001128915, 17.696128158161262, -19.879809980051505, 16.501956385264229, -20.435874698730913, 15.243973906945261, -20.946360342109983, 13.93129653826457, -21.411266910181439, 13.93129653826457, -24.583570551159937, 14.50559288706236, -24.383022619829717, 15.90942840634588, -23.890768606579513, 17.267684850327981, -23.362051333078853, 18.571246403948379, -22.824218244521035, 19.829228882267358, -22.249921895730949, 21.03251647022466, -21.666509731869155, 22.181109167820271, -21.046634307771455, 23.284122790114449, -20.408527253548527, 24.341557337107218, -19.752188569211285, 25.344296993738311, -19.068502439691656, 26.29234176000768, -18.366584680050437, 27.194807450975649, -17.63731947523047, 28.04257825158194, -16.880706825220841, 28.844769976886791, -16.105862545100535, 29.592266811829969, -15.303670819790568, 30.294184571471732, -14.483247464369924, 31.050797221475172, -13.507855252908485, 31.80740987147863, -12.423073260739329, 32.491096000999818, -11.320059638448583, 33.10185561003874, -10.198814386039885, 33.639688698595421, -9.0684533185594773, 34.113711081730123, -7.9198606209611171, 34.505691129322258, -6.7621521083092375, 34.833860471492422, -5.5770961504713341, 35.079987478120053, -4.3829243775689974, 35.262303779325691, -3.1796367896095035, 35.371693560049103, -1.9581175715393329, 35.40815682029023, -0.71836672334029572, 35.399041005229947, -0.034680593820667127, 35.316998669687401, 1.3509232953401806, 35.162029813662599, 2.6818322941398947, 34.915902807034968, 3.9489305875285936, 34.587733464864783, 5.1613339905416069, 34.177521787152081, 6.3099266881290532, 33.694383588957102, 7.3947086803091224, 33.120087240159307, 8.4339115971815772, 32.463748555818967, 9.4001879935713077, 31.73448335099636, 10.311769499599905, 30.932291625691509, 11.132192855031462, 29.929551969060409, 12.007311100809602, 28.899464867248501, 12.745692120701278, 27.832914505195451, 13.347335914681025, 26.729900882901259, 13.821358297809638, 25.59953981542623, 14.158643455040874, 24.423599672649772, 14.359191386371094, 23.22942789975275, 14.423002091789385],
     ],

131: [ [61.35176648185432, 199.86677404840157, 52.199488161330663, 199.50214144599158, 52.792016140249018, 199.38363585020124, 53.785639981819827, 198.5632124947806, 54.159388399291402, 197.79748402971018, 54.4237470360396, 196.59419644175068, 54.505789371582161, 195.03539206644928, 54.478441926401302, 194.12381056042068, 54.32347307037648, 192.8931755272788, 54.059114433628309, 191.68988793931931, 53.667134386036139, 190.51394779653856, 53.15664874266033, 189.37447091400827, 52.518541688440543, 188.26234147666037, 51.771044853497379, 187.1775594844803, 51.743697408316542, 187.14109622424075, 51.078242908915911, 186.32978868388091, 50.32163025891245, 185.53671277363173, 49.482975273366463, 184.74363686338984, 48.562277952277917, 183.96879258325862, 47.55953829564686, 183.20306411819911, 46.46564048841293, 182.45556728326119, 45.289700345636497, 181.70807044830872, 44.031717867317489, 180.97880524348875, 42.691693053455957, 180.24954003866878, 42.691693053455957, 177.22308943864846, 43.247757772133212, 177.41452155492152, 44.560435140813887, 177.88854393805013, 45.82753343419315, 178.3990295814292, 47.039936837210739, 178.94597848505146, 48.20676116492691, 179.5293906488987, 49.328006417341669, 180.14926607301095, 50.403672594455003, 180.81472057240171, 51.433759696266918, 181.50752251698941, 52.409151907717153, 182.23678772180938, 53.338965043865983, 183.01163200192968, 54.223199104713387, 183.81382372722874, 55.061854090259367, 184.65247871277825, 55.85493000050397, 185.53671277363173, 56.602426835447119, 186.44829427966033, 57.012638513159828, 187.00435899833974, 57.760135348102999, 188.09825680556969, 58.443821477624198, 189.20127042787135, 59.05458108666312, 190.32251568028005, 59.592414175219801, 191.46199256281034, 60.066436558354503, 192.61970107546949, 60.458416605946638, 193.78652540318944, 60.777470133056532, 194.97158136102007, 61.032712954744419, 196.17486894897957, 61.215029255950093, 197.38727235199985, 61.315303221613192, 198.61790738514173, 61.35176648185432, 199.86677404840157],
       [52.822500573770071, 96.797719365418743, 51.550913689914211, 95.755247235410934, 51.39053336222068, 95.606322645409819, 50.714644838369331, 94.918978383870126, 50.027300576825638, 94.128532483100571, 49.339956315281903, 93.223529205399245, 48.641156316045802, 92.203968550769787, 47.942356316809679, 91.092761994608736, 47.243556317573557, 89.855542323828558, 46.533300580645061, 88.526676751509513, 45.823044843716559, 87.08325380226961, 45.101333369095627, 85.525273476101574, 44.391077632167132, 83.864191510710953, 43.657910419853827, 82.100007906079554, 42.936198945232952, 80.221266924530937, 42.203031732919641, 78.239424303741544, 41.458408782913942, 76.143024306031293, 40.919989111371358, 74.585043979870534, 40.221189112135242, 72.706302998318279, 39.556756325976323, 71.045221032920381, 38.915235015202171, 69.59034234597857, 38.296625179812821, 68.353122675198392, 37.700926819808267, 67.310650545201497, 37.139595672880922, 66.485837431340769, 36.658454689800287, 65.890139071339945, 35.478513707483593, 64.893489892099751, 34.115280922088537, 64.251968581331312, 33.508126824391582, 64.068676778249937, 32.454198956691222, 63.862473499790212, 31.090966171296181, 63.656270221319573, 29.40697273051407, 63.461522680550843, 27.413674372037288, 63.266775139778474, 25.09961535817343, 63.094939074399008, 24.022776015088279, 58.340807932050666, 36.784467804416643, 58.340807932050666, 36.669910427492709, 57.871122686661693, 35.994021903641368, 55.08737842741175, 35.341044855174829, 52.406735807391669, 34.722435019785479, 49.840650564288808, 34.126736659780931, 47.389122698121355, 33.56540551285358, 45.040696471180127, 33.026985841310989, 42.806827621159755, 32.511477645153207, 40.67606041038016, 32.030336662072592, 38.659850576521421, 31.572107154376798, 36.746742381888907, 31.13678912206575, 34.948191564180888, 30.73583830283193, 33.264198123401002, 30.357798958982869, 31.683306321850978, 30.002671090518621, 30.205516159530816, 29.681910435131559, 28.853739111829782, 29.384061255129271, 27.60506370335861, 29.109123550511779, 26.459489934120938, 28.868553058971489, 25.428473541800486, 28.650894042815992, 24.500558788720809, 28.456146502045272, 23.698657150249346, 28.295766174351709, 22.988401413320389, 28.15829732204298, 22.392703053319565, 28.055195682811409, 21.911562070239597, 27.96354978127226, 21.544978464080486, 27.917726830502691, 21.281496497151238, 27.688612076654781, 20.193201416368538, 27.127280929727391, 17.386545681740245, 26.57740552049242, 14.728814537098515, 26.061897324334641, 12.220007982468815, 25.580756341254052, 9.8486702801383217, 25.122526833558229, 7.614801430128864, 24.6986645389396, 5.529857170109608, 24.297713719705769, 3.5823817624004732, 23.931130113549099, 1.78383094469973, 23.587457982777241, 0.12274897929819417, 23.26669732739018, -1.4008641337895824, 22.9803038850803, -2.7755526568798814, 22.728277655847592, -4.0013165899690648, 22.499162901999679, -5.089611670740851, 22.292959623536579, -6.0404378992097918, 22.121123558150661, -6.842339537681255, 21.97219896814951, -7.506772323838959, 21.857641591225558, -8.0337362576792657, 21.7774514273788, -8.4117756015402847, 21.720172738916801, -8.6408903553783603, 21.399412083529739, -9.923932976929791, 20.883903887371961, -11.928687073101173, 20.379851428906559, -13.761605103889451, 19.86434323274878, -15.445598544658424, 19.360290774283381, -16.957755920058844, 18.86769405351038, -18.309532967770792, 18.375097332737401, -19.500929687768803, 17.882500611964389, -20.531946080089256, 17.389903891191381, -21.402582144710323, 17.332625202729421, -21.505683783940185, 16.290153072721441, -23.0292968970316, 15.24768094271346, -24.289428043201042, 14.19375307501309, -25.286077222430322, 13.13982520731272, -26.019244434748543, 12.00570717576559, -26.511841155519505, 10.4706383249846, -26.740955909368495, 18.787503889663611, -27.393932957838842, 20.11636946198146, -26.30563787705978, 21.422323558914542, -25.079873943970597, 21.445235034299309, -25.068418206279603, 22.132579295843051, -24.358162469350646, 22.819923557386769, -23.579172306268447, 23.507267818930469, -22.742903454720363, 24.183156342781821, -21.849355914720945, 24.859044866633131, -20.887073948550096, 25.523477652792049, -19.856057556240557, 26.187910438950979, -18.767762475461495, 26.852343225109909, -17.610732968529192, 27.505320273576451, -16.396424773138278, 28.15829732204298, -15.113382151590486, 28.811274370509519, -13.773060841580445, 29.45279568128365, -12.364005105409888, 30.08286125436538, -10.89767068078072, 30.71292682744712, -9.3626018299983116, 31.342992400528889, -7.7702542907609313, 31.973057973610629, -6.1091723253593955, 32.591667808999979, -4.3793559338082559, 33.198821906696907, -2.592260853798507, 33.80597600439387, -0.74788708531923476, 34.413130102090832, 1.1652211093096412, 35.020284199787767, 3.1470637300917588, 35.615982559792322, 5.1861850393397617, 36.200225182104468, 7.2940407747410063, 36.372061247490421, 7.9011948724401009, 36.876113705955817, 9.779935853988718, 37.380166164421212, 11.647221097849979, 37.884218622886607, 13.480139128630981, 38.3653596059672, 15.301601421720989, 38.835044851355413, 17.088696501730738, 39.304730096743612, 18.864335844060406, 39.76295960443943, 20.605607973309816, 40.221189112135242, 22.335424364850041, 40.656507144446259, 24.042329281019192, 41.091825176757283, 25.726322721799079, 41.515687471375912, 27.387404687200615, 41.928094028302148, 29.025575177220162, 42.340500585228369, 30.640834191839531, 42.72999566676981, 32.233181731091463, 43.11949074831125, 33.802617794939579, 43.497530092160297, 35.360598121111252, 43.875569436009357, 36.884211234199029, 44.230697304473608, 38.396368609588535, 44.585825172937859, 39.874158771908697, 44.929497303709717, 41.340493196541502, 45.261713696789172, 42.77246040809041, 45.59393008986865, 44.192971881941048, 45.903235007563318, 45.590571880420612, 46.212539925258, 46.965260403499997, 46.521844842952667, 48.317037451208307, 46.80823828526254, 49.645903023530991, 47.094631727572413, 50.951857120460772, 47.369569432189913, 52.234899742008565, 47.633051399114997, 53.506486625861726, 47.885077628347709, 54.743706296638265, 48.137103857580399, 55.958014492029179, 48.366218611428302, 57.160866949729098, 48.595333365276218, 58.340807932050666, 61.139366138449077, 58.340807932050666, 62.36513007153539, 63.094939074399008, 49.53470385605263, 63.094939074399008, 49.74090713451573, 64.377981695939525, 50.050212052210412, 66.359824316728918, 50.35951696990508, 68.284388249048789, 50.668821887599762, 70.151673492910049, 50.96667106760205, 71.961680048309063, 51.26452024760431, 73.702952177551197, 51.550913689914211, 75.386945618338359, 51.837307132224083, 77.013660370659636, 52.112244836841569, 78.571640696820396, 52.387182541459048, 80.083798072220816, 52.650664508384153, 81.515765283769724, 52.914146475309252, 82.901909544551017, 53.166172704541943, 84.219319379171793, 53.418198933774647, 85.479450525341235, 53.670225163007331, 86.682302983041154, 53.910795654547627, 87.827876752278826, 54.151366146087952, 88.904716095359618, 54.357569424551059, 89.729529209209431, 54.873077620708841, 91.230230846918857, 55.571877619944949, 92.5934636323218, 56.431057946874603, 93.842139040789334, 57.462074339190188, 94.964801334641379, 57.473530076882582, 94.976257072328735, 58.768028436123238, 95.927083300801314, 60.165628434595469, 96.49987018542015, 61.643418596914472, 96.694617726188881, 52.822500573770071, 96.797719365418743],
       [62.147471055379867, 100.00532591929004, 61.265379253065419, 99.982414443911694, 59.764677615361649, 99.822034116219584, 58.298343190735039, 99.512729198519082, 56.877831716878042, 99.054499690828379, 55.491687456098191, 98.447345593129285, 54.139910408395536, 97.702722643120069, 52.822500573770071, 96.797719365418743, 61.643418596914472, 96.694617726188881, 62.147471055379867, 96.67170625081053, 63.522159578467303, 96.190565267730562, 63.545071053852091, 96.156198054650304, 64.163680889241434, 94.815876744640263, 64.117857938471872, 94.495116089259682, 63.37323498846618, 92.937135763091646, 62.846271054615983, 91.837384944610676, 62.582789087690891, 90.416873470760038, 62.582789087690891, 90.32522756922117, 62.94937269384755, 88.927627570748882, 63.946021873085918, 87.678952162281348, 64.28969400385779, 87.369647244580847, 65.595648100790868, 86.625024294578907, 67.11926121387944, 86.384453803038923, 67.944074327731897, 86.453188229188527, 69.353130063896515, 86.934329212268494, 70.578893996982814, 87.896611178428429, 71.312061209296104, 88.893260357668623, 71.850480880838688, 90.290860356140911, 72.022316946224635, 91.929030846149544, 72.010861208532219, 92.307070189999649, 71.793202192376725, 93.796316090021719, 71.277693996218943, 95.171004613101104, 70.464336620058873, 96.454047234648897, 69.353130063896515, 97.622532479279471, 69.330218588511741, 97.656899692348816, 68.16173334388742, 98.504624281591532, 66.867234984646714, 99.157601330050966, 65.435267773097337, 99.627286575439939, 63.854375971546773, 99.913680017758452, 62.147471055379867, 100.00532591929004],
     ],

132: [ [26.830174848564351, -0.069415246180142276, 17.677896528040691, -0.49785855400841683, 18.407161732863301, -0.66194322509909398, 19.409901389494362, -1.5097140256984858, 19.66514421118228, -1.9563889636592648, 20.011545183473029, -3.0867500311287586, 20.130050779256688, -4.5361646257188113, 20.120934964196412, -5.1469242347593536, 20.011545183473029, -6.459601603441115, 19.801881437086511, -7.7175840817617427, 19.491943725036919, -8.929987484778394, 19.063500417203642, -10.087695997430274, 18.534783143707241, -11.199825434789091, 17.896676089487471, -12.248144166718703, 17.56850674731729, -12.703934919729363, 16.966862953338651, -13.424084309499449, 16.255829378636601, -14.162465329380211, 15.44452183827147, -14.909962164321769, 14.523824517182931, -15.675690629388555, 13.49373741537101, -16.459650724569656, 12.35426053283569, -17.261842449868709, 11.11450968463725, -18.073149990239472, 9.7653690557154391, -18.902689160728187, 8.306838646070247, -19.750459961331217, 8.306838646070247, -22.776910561351542, 8.4982707623361762, -22.722215670979494, 9.8109481310168576, -22.29377236315122, 11.078046424396121, -21.82886579506885, 12.29044982741371, -21.327495966761489, 13.466389970190161, -20.771431248078443, 14.5967510376652, -20.178903269170405, 15.681533029838819, -19.549912030008272, 16.72073594671102, -18.866225900488644, 17.714359788281818, -18.146076510718558, 18.662404554551209, -17.380348045659048, 19.564870245519181, -16.57815632034908, 20.421756861185742, -15.730385519749689, 21.23306440155088, -14.837035643839044, 21.998792866614622, -13.907222507688857, 22.67336318107553, -12.99564100166026, 23.402628385898112, -11.910859009491105, 24.049851255178201, -10.807845387200359, 24.633263419036268, -9.6866001347807469, 25.152864877472378, -8.5471232522395439, 25.59953981542623, -7.3894147395913024, 25.973288232897801, -6.2225904118713515, 26.283225944947421, -5.0284186389799288, 26.520237136514741, -3.8160152359596395, 26.693437622660131, -2.5853802028213977, 26.79371158832322, -1.3365135395615653, 26.830174848564351, -0.069415246180142276],
       [14.359739846097851, 14.424730699669453, 13.19291551838168, 14.370035809301044, 11.944048855122981, 14.160372062920942, 10.76810871234653, 13.804855275571754, 9.6650950900523451, 13.29436963219996, 8.6258921731801195, 12.638030947851803, 7.65961577679019, 11.82672340748104, 7.1491301334143591, 11.334469394230837, 6.3195909629286566, 10.331729737601563, 5.6814839087088549, 9.2742951906111557, 5.2165773406344718, 8.1712815683094959, 4.9431028888259902, 6.9953414255396638, 4.8519447382231533, 5.7738222074585792, 4.8975238135245709, 4.8895881466087303, 5.1254191900316348, 3.6680689285312837, 5.5538624978649116, 2.5285920460009947, 6.1828537370244021, 1.4802733140604687, 7.0123929075101321, 0.51399691767073818, 7.6140367014887707, -0.032951985940599116, 8.6350079882404032, -0.74398556063897558, 9.7471374255948717, -1.2453553889608884, 10.93219338343161, -1.5461772859489429, 12.199291676810869, -1.6555670666712103, 12.873861991271781, -1.6282196214888245, 14.1227286545305, -1.4367875052193995, 15.3715953177892, -1.0721549028094159, 16.656925241289031, -0.66194322509909398, 17.677896528040691, -0.49785855400841683, 26.830174848564351, -0.069415246180142276, 26.830174848564351, 0.0035112742989440449, 26.784595773262939, 1.3617677182810439, 26.638742732298429, 2.6653292718983721, 26.401731540731081, 3.9141959351582045, 26.064446383500641, 5.1174835231213365, 25.64511889072762, 6.2660762207087828, 25.125517432291531, 7.350858212888852, 24.51475782325258, 8.3900611297613068, 23.812840063610849, 9.3836849713297852, 23.01064833830597, 10.313498107479973, 22.108182647338001, 11.206847983390617, 21.08721136058637, 12.054618783990009, 20.038892628653851, 12.783883988820889, 18.954110636480241, 13.376411967728927, 17.851097014186049, 13.832202720750502, 16.711620131650729, 14.160372062920942, 15.553911618994841, 14.360919994251162, 14.359739846097851, 14.424730699669453],
       [48.671667733001328, 14.424730699669453, 47.668928076370229, 14.379151624369115, 46.410945598051249, 14.18771950809969, 45.225889640214511, 13.850434350868454, 44.11376020286005, 13.349064522550179, 43.074557285987837, 12.701841653270094, 42.108280889597893, 11.899649927971041, 41.725416657066027, 11.516785695439467, 40.904993301640587, 10.523161853860074, 40.266886247420807, 9.4657273068696668, 39.811095494406693, 8.3444820544609684, 39.537621042598211, 7.1685419116802223, 39.446462891995388, 5.9196752484313038, 39.501157782357097, 4.9533988520306593, 39.7472847889847, 3.7501112640711654, 40.193959726938537, 2.6197501966016716, 40.841182596218623, 1.5623156496112642, 41.679837581764609, 0.58692343816073844, 42.263249745622687, 0.030858719481329899, 43.284221032374347, -0.69840648533863714, 44.378118839608248, -1.2271237588392978, 45.554058982384703, -1.5461772859489429, 46.793809830583108, -1.6555670666712103, 47.140210802873831, -1.6373354365496198, 48.325266760710583, -1.4641349504017853, 49.683523204692683, -1.0721549028094159, 49.738218095054371, -1.0539232726914634, 51.123821984217329, -0.6345957799203461, 52.199488161330663, -0.49785855400841683, 61.35176648185432, -0.13322595159843331, 61.35176648185432, -0.051183616058551706, 61.297071591492617, 1.270609567680367, 61.151218550528107, 2.5559394911797426, 60.914207358960759, 3.7865745243216224, 60.576922201730298, 4.9807462972094072, 60.139363078836737, 6.1202231797506101, 59.610645805340368, 7.2232368020486319, 58.990770381241163, 8.2715555339709681, 58.270620991478843, 9.283411005668313, 57.459313451113672, 10.240571587000886, 57.413734375812282, 10.295266477358382, 56.429226349301757, 11.26154287375175, 55.417370877610409, 12.100197859290347, 54.369052145677898, 12.811231433999637, 53.293385968564557, 13.394643597861432, 52.181256531210103, 13.841318535811297, 51.041779648674783, 14.169487877981737, 49.874955320958598, 14.360919994251162, 48.671667733001328, 14.424730699669453],
     ],

133: [ [24.59680015879513, 13.997151695770299, 23.3114702352953, 13.905993545169622, 22.108182647338001, 13.623403278288606, 20.986937394923249, 13.167612525281584, 19.938618662990759, 12.520389656001498, 18.972342266600801, 11.690850485509145, 18.89029993105828, 11.608808149969263, 18.069876575632829, 10.651647568640328, 17.422653706352769, 9.6124446517715114, 16.966862953338651, 8.4911993993482611, 16.693388501530158, 7.2787959963388857, 16.59311453586707, 5.9934660728395102, 16.59311453586707, 5.9478869975391717, 16.693388501530158, 4.6716728891005914, 16.985094583459212, 3.4775011161982547, 17.459116966593911, 2.3562558637786424, 18.124571465994531, 1.3261687619706208, 18.972342266600801, 0.36900818064168561, 19.00880552684194, 0.33254492039850447, 19.96596610817161, -0.50611006514009205, 21.005169025043809, -1.1624487494809728, 22.117298462398281, -1.6364711326204997, 23.32058605035559, -1.9190613994796877, 24.59680015879513, -2.0102195500912785, 24.697074124458261, -2.0102195500912785, 25.964172417837521, -1.900829769369011, 27.149228375674259, -1.6091236874417518, 28.270473628089011, -1.1351013043095008, 29.31879236002149, -0.47876261996862013, 30.294184571471732, 0.36900818064168561, 31.123723741957431, 1.3261687619706208, 31.770946611237491, 2.3744874939002329, 32.226737364251619, 3.4957327463198453, 32.509327631120392, 4.7081361493401346, 32.600485781723201, 5.9934660728395102, 32.600485781723201, 6.0481609632006439, 32.500211816060101, 7.3243750716392242, 32.217621549191328, 8.5276626595987182, 31.761830796177211, 9.6489079120110546, 31.11460792689715, 10.706342459001462, 30.294184571471732, 11.690850485509145, 30.23948968111003, 11.736429560809484, 29.282329099780348, 12.547737101180246, 28.234010367847869, 13.176728340338741, 27.11276511543312, 13.632519093349401, 25.891245897355251, 13.905993545169622, 24.59680015879513, 13.997151695770299],
       [73.822201484320843, 13.997151695770299, 72.536871560820998, 13.905993545169622, 71.333583972863707, 13.623403278288606, 70.212338720448955, 13.167612525281584, 69.164019988516458, 12.520389656001498, 68.197743592126514, 11.690850485509145, 68.124817071644259, 11.608808149969263, 67.295277901158542, 10.651647568640328, 66.648055031878485, 9.6124446517715114, 66.192264278864343, 8.4911993993482611, 65.918789827055875, 7.2787959963388857, 65.827631676453052, 5.9934660728395102, 65.827631676453052, 5.9478869975391717, 65.927905642116158, 4.6716728891005914, 66.210495908984925, 3.4775011161982547, 66.684518292119606, 2.3562558637786424, 67.349972791520244, 1.3261687619706208, 68.197743592126514, 0.36900818064168561, 68.234206852367649, 0.33254492039850447, 69.191367433697309, -0.50611006514009205, 70.230570350569522, -1.1624487494809728, 71.351815602984274, -1.6364711326204997, 72.545987375881282, -1.9190613994796877, 73.822201484320843, -2.0102195500912785, 73.922475449983949, -2.0102195500912785, 75.189573743363226, -1.900829769369011, 76.383745516260234, -1.6091236874417518, 77.495874953614702, -1.1351013043095008, 78.544193685547199, -0.47876261996862013, 79.519585896997427, 0.36900818064168561, 80.349125067483143, 1.3261687619706208, 80.996347936763215, 2.3744874939002329, 81.452138689777314, 3.4957327463198453, 81.734728956646066, 4.7081361493401346, 81.825887107248903, 5.9934660728395102, 81.825887107248903, 6.0481609632006439, 81.725613141585796, 7.3243750716392242, 81.443022874717045, 8.5276626595987182, 80.987232121702917, 9.6489079120110546, 80.340009252422874, 10.706342459001462, 79.519585896997427, 11.690850485509145, 79.474006821695994, 11.727313745759602, 78.489498795185483, 12.538621286119451, 77.441180063253, 13.176728340338741, 76.310818995777979, 13.632519093349401, 75.098415592760389, 13.905993545169622, 73.822201484320843, 13.997151695770299],
       [123.0476028098465, 13.997151695770299, 122.9746762893643, 13.997151695770299, 121.6893463658644, 13.896877730101551, 120.47694296284681, 13.614287463231449, 119.3556977104321, 13.149380895159993, 118.3073789784996, 12.511273840940703, 117.35933421223019, 11.690850485509145, 117.30463932186851, 11.636155595151649, 116.4933317815034, 10.678995013819076, 115.8643405423439, 9.630676281889464, 115.4085497893298, 8.5003152144090564, 115.1441911525816, 7.287911811399681, 115.0530330019787, 5.9934660728395102, 115.0530330019787, 5.9478869975391717, 115.1533069676418, 4.6716728891005914, 115.43589723451061, 3.4775011161982547, 115.9099196176453, 2.3562558637786424, 116.5753741170459, 1.3261687619706208, 117.43226073271251, 0.36900818064168561, 117.4596081778933, 0.33254492039850447, 118.416768759223, -0.50611006514009205, 119.4559716760952, -1.1624487494809728, 120.57721692851, -1.6364711326204997, 121.77138870140701, -1.9190613994796877, 123.0476028098465, -2.0102195500912785, 123.1478767755096, -2.0102195500912785, 124.41497506888889, -1.900829769369011, 125.6091468417859, -1.6091236874417518, 126.7212762791404, -1.1351013043095008, 127.76959501107289, -0.47876261996862013, 128.74498722252309, 0.36900818064168561, 129.5745263930088, 1.3261687619706208, 130.22174926228891, 2.3744874939002329, 130.67754001530301, 3.4957327463198453, 130.9601302821718, 4.7081361493401346, 131.05128843277461, 5.9934660728395102, 131.05128843277461, 6.0481609632006439, 130.95101446711149, 7.3243750716392242, 130.6684242002427, 8.5276626595987182, 130.2126334472286, 9.6489079120110546, 129.56541057794851, 10.706342459001462, 128.74498722252309, 11.690850485509145, 128.6994081472217, 11.727313745759602, 127.7240159357715, 12.538621286119451, 126.6665813887787, 13.176728340338741, 125.5362203213036, 13.632519093349401, 124.3329327333464, 13.905993545169622, 123.0476028098465, 13.997151695770299],
     ],

134: [ [35.335230299807961, 197.33522943278149, 35.234956334144869, 196.42364792674925, 35.052640032939202, 195.16566544842863, 34.833860471492422, 193.90768297011164, 34.569501834744237, 192.66793212190896, 34.259564122694627, 191.42818127370992, 33.913163150403882, 190.18843042551089, 33.530298917872017, 188.96691120744072, 33.10185561003874, 187.74539198935963, 32.582254151602633, 186.35067228513071, 31.989726172684271, 184.7280572044001, 31.479240529308441, 183.29687423993892, 31.050797221475172, 182.06623920680067, 30.713512064244728, 181.02703628992822, 30.45826924255681, 180.17926548932155, 30.294184571471732, 179.53204262004147, 30.03894174978382, 178.39256573750026, 29.847509633517891, 177.12546744412975, 29.783698928095902, 175.92217985617026, 29.847509633517891, 174.79181878870077, 30.093636640145519, 173.55206794049082, 30.512964132918508, 172.39435942783894, 31.10549211183687, 171.33692488084853, 31.880336391960899, 170.3706484844588, 32.45463274075869, 169.81458376577939, 33.457372397389783, 169.08531856095942, 34.551270204623677, 168.55660128745876, 35.727210347400103, 168.24666357540991, 36.994308640779387, 168.13727379469128, 37.823847811265097, 168.18285286999162, 39.054482844403253, 168.41074824650059, 40.193959726938537, 168.83919155432886, 41.233162643810772, 169.468182793491, 42.181207410080162, 170.29772196397971, 42.791967019119078, 171.01787135373888, 43.439189888399142, 172.04795845555054, 43.904096456473553, 173.16920370795924, 44.177570908282028, 174.39072292604033, 44.277844873945128, 175.71251610979016, 44.25049742876427, 176.34150734894138, 44.159339278161468, 177.24397303990918, 43.986138792016114, 178.23759688148129, 43.740011785388468, 179.31326305858965, 43.411842443218291, 180.47097157124881, 43.019862395626149, 181.71072241945149, 42.545840012491453, 183.0416314182512, 41.998891108874489, 184.4545827525908, 41.369899869714992, 185.94957642248119, 40.667982110073233, 187.53572824296862, 40.430970918505892, 188.08267714659087, 39.865790384768388, 189.45004940563012, 39.437347076935112, 190.60775791828928, 39.154756810066353, 191.56491849961094, 39.063598659463537, 191.94778273214979, 38.88128235825787, 192.85936423817839, 38.68073442693165, 194.0626518261306, 38.46195486548487, 195.557645496021, 38.215827858857239, 197.33522943278149, 35.335230299807961, 197.33522943278149],
       [63.703646767407243, 197.60870388457988, 35.335230299807961, 197.33522943278149, 38.215827858857239, 197.33522943278149, 39.054482844403253, 197.28965035747024, 40.503897438988162, 197.17114476169081, 41.707185026945467, 197.01617590566821, 42.691693053455957, 196.83385960445958, 43.083673101048127, 196.73358563880174, 44.11376020286005, 196.42364792674925, 45.28058453057622, 196.02255206408881, 46.584146084196611, 195.53029805083861, 48.024444863721271, 194.95600170204125, 48.86309984926725, 194.60048491468842, 50.394556779394712, 193.98972530565152, 51.816623928798798, 193.47012384721165, 53.111069667358912, 193.04168053937974, 54.305241440255912, 192.7135111972093, 55.371791802308991, 192.47650000565045, 56.328952383638637, 192.33976277973852, 57.176723184244942, 192.29418370443818, 57.450197636053389, 192.29418370443818, 58.744643374613531, 192.44003674539999, 59.920583517389957, 192.80466934780998, 60.987133879443043, 193.37896569661098, 61.935178645712398, 194.16292579179935, 62.108379131857788, 194.3543579080615, 62.855875966800937, 195.32063430445123, 63.384593240297328, 196.40541629662039, 63.703646767407243, 197.60870388457988],
       [37.786315766528901, 64.609212769199075, 35.116051389825493, 64.609212769199075, 35.106649050470907, 64.439970660820109, 34.984418638861229, 62.813365952479217, 34.815176530478631, 61.280784637681791, 34.617727404032252, 59.851629055781814, 34.392071259522112, 58.5258992067902, 34.119403418239017, 57.294192751331138, 33.818528558892162, 56.175314368141699, 33.480044342126916, 55.150459378488449, 33.10395076794336, 54.219627782378666, 32.812478247951077, 53.617878063691023, 32.22953320796654, 52.564816055968549, 31.543162435081509, 51.521156387618248, 30.762768268650579, 50.496301397961361, 29.888350708673759, 49.48084874766937, 28.910507415796449, 48.493603115428414, 27.83864072937325, 47.51575982255963, 27.857445408082441, 47.468748125789716, 28.177124946138459, 46.237041670341569, 28.49680448419452, 45.005335214878869, 28.797679343541379, 43.764226420080377, 29.098554202888241, 42.513715285920625, 29.390026722880521, 41.253801812399615, 29.662694564163619, 39.993888338889519, 29.93536240544671, 38.724572526021802, 30.198627907375201, 37.445854373789189, 30.452491069949129, 36.167136221571127, 30.69695189316846, 34.879015729991806, 30.93201037703318, 33.581492899058503, 31.167068860897931, 32.274567728771217, 31.383322666053491, 30.967642558480293, 31.59017413185444, 29.651315048839024, 31.79702559765542, 28.334987539201393, 31.985072384747209, 27.009257690198865, 32.163716832484397, 25.67412550184963, 32.34236128022161, 24.329590974139137, 32.511603388604208, 22.985056446439557, 32.66204081827766, 21.631119579378719, 32.812478247951077, 20.26778037296026, 32.859489944724032, 19.844675101998291, 32.962915677624522, 18.829222451709938, 33.066341410524977, 17.794965122699068, 33.160364804070902, 16.751305454341491, 33.254388197616777, 15.688841107268672, 33.348411591162687, 14.607572081491526, 33.442434984708569, 13.507498377010052, 33.527056038899872, 12.398022333170957, 33.611677093091181, 11.269741610620258, 33.696298147282477, 10.122656209361594, 33.780919201473779, 8.9567661293913261, 33.86554025566511, 7.7814737100707134, 33.940758970501811, 6.5779742726808763, 34.015977685338527, 5.3650724959297804, 34.081794060820641, 4.1427683798392536, 34.157012775657357, 2.8922572456795024, 34.222829151139507, 1.6323437721694063, 34.288645526621622, 0.35362561994043062, 34.354461902103743, -0.94389721100014867, 34.410875938231271, -2.2508223812801589, 34.467289974358827, -3.5859545696403075, 34.523704010486369, -4.9304890973398869, 34.580118046613912, -6.293828303758346, 34.627129743386831, -7.6665698495307879, 34.683543779514373, -9.0675184133615403, 34.730555476287321, -10.477869316549913, 34.768164833705697, -11.90702489844989, 34.815176530478631, -13.354985159050557, 34.852785887896999, -14.812347759008844, 34.890395245315347, -16.288515037689649, 34.928004602733687, -17.78348699506023, 34.956211620797461, -19.29726363114969, 34.984418638861229, -20.829844945950754, 35.012625656925003, -22.371828600109438, 35.040832674988792, -23.932616932961537, 35.069039693052559, -25.512209944539791, 35.087844371761719, -27.101205295461114, 35.106649050470907, -28.718407664451661, 35.116051389825493, -30.345012372799829, 37.786315766528901, -30.345012372799829, 37.795718105883481, -29.884297744418291, 37.852132142011023, -27.938013498020155, 37.899143838783971, -26.019936269680329, 37.955557874911513, -24.148870738121332, 38.011971911039041, -22.2966098852703, 38.058983607811989, -20.491360729189182, 38.115397643939531, -18.704916251819668, 38.171811680067073, -16.965483471220068, 38.228225716194601, -15.254257708678779, 38.284639752322143, -13.571238964210352, 38.34105378844967, -11.92582957715058, 38.397467824577213, -10.308627208170947, 38.45388186070474, -8.7290341965999687, 38.510295896832282, -7.1870505424412841, 38.56670993295981, -5.6732739063590998, 38.623123969087381, -4.1971066276782949, 38.679538005214908, -2.7491463670812664, 38.74535438069703, -1.3293931245316344, 38.801768416824558, 0.043348421240807511, 38.867584792306673, 1.3972852883016458, 38.923998828434243, 2.7042104585889319, 38.980412864561771, 3.9923309501682525, 39.046229240043893, 5.2334397449703829, 39.112045615526, 6.4463415217105648, 39.168459651653563, 7.6310362803887983, 39.234276027135678, 8.7781216816511005, 39.300092402617793, 9.8875977254901954, 39.365908778099943, 10.96886675127098, 39.422322814227471, 12.021928758978902, 39.488139189709592, 13.037381409281807, 39.553955565191728, 14.015224702161504, 39.619771940673843, 14.964860976968339, 39.685588316155958, 15.876887894370157, 39.751404691638101, 16.760707793699112, 39.82662340647483, 17.606918335608498, 39.892439781956938, 18.424921859459573, 39.958256157439052, 19.205316025891079, 40.024072532921188, 19.948100834899378, 40.099291247757911, 20.662678625849367, 40.165107623240033, 21.349049398741045, 40.1933146413038, 21.61231490065984, 40.334349731622638, 22.90043539223916, 40.494189500650663, 24.188555883818481, 40.654029269678688, 25.476676375401439, 40.823271378061293, 26.76479686698076, 41.011318165153078, 28.05291735856008, 41.20876729159945, 29.341037850139401, 41.40621641804583, 30.638560681069066, 41.62247022320139, 31.926681172648387, 41.848126367711551, 33.22420400358169, 42.083184851576277, 34.51232449516101, 42.327645674795598, 35.80984732610159, 42.581508837369512, 37.107370157031255, 42.844774339298027, 38.40489298796092, 43.126844519935702, 39.702415818890586, 43.408914700573398, 40.999938649831165, 43.70978955992026, 42.306863820111175, 44.01066441926713, 43.604386651051755, 44.330343957323151, 44.911311821339041, 44.659425834733781, 46.218236991619051, 44.997910051499012, 47.51575982255963, 44.443172029578207, 47.985876790291513, 43.437121718637172, 48.926110725751641, 42.51569246188739, 49.903954018620425, 41.697688938038112, 50.910004329569347, 40.973708807734738, 51.963066337280907, 40.34375207097721, 53.034933023711346, 39.807818727765643, 54.153811406900786, 39.742002352283492, 54.294846497221442, 39.356506438745328, 55.253885111378622, 39.018022221980118, 56.316349458451441, 38.717147362633263, 57.463434859721019, 38.45388186070474, 58.704543654519512, 38.228225716194601, 60.039675842868746, 38.040178929102808, 61.468831424768723, 37.899143838783971, 62.992010400208528, 37.786315766528901, 64.609212769199075],
       [7.3039315789498849, 65.417813953699806, 7.4731736873324897, 64.110888783408882, 7.8680719402252626, 62.907389346019045, 8.4792239982735662, 61.82612032023826, 9.3160322008320406, 60.857679366719822, 9.7579421504977404, 60.462781113830715, 10.78279714014797, 59.785812680300296, 11.92048020205331, 59.296891033860447, 13.189796014922869, 59.00541851386879, 14.581342239402121, 58.911395120321686, 15.23950599422338, 58.939602138379996, 16.16093525097315, 59.043027871281083, 17.195192579977999, 59.23107465837893, 18.332875641883302, 59.503742499658983, 19.57398443668913, 59.851629055781814, 20.918518964395421, 60.28413666609049, 22.375881564356771, 60.801265330599563, 23.936669897218621, 61.403015049290843, 25.61028630233557, 62.079983482821262, 26.26845005715683, 62.352651324101316, 27.54716820938097, 62.832170631179906, 28.825886361605139, 63.264678241499496, 30.095202174474728, 63.640771815680637, 31.35511564798972, 63.960451353730605, 32.615029121504712, 64.233119195021573, 33.874942595019689, 64.439970660820109, 35.116051389825493, 64.609212769199075, 37.786315766528901, 64.609212769199075, 7.3039315789498849, 65.417813953699806],
       [58.828751242100111, 72.826857365118485, 58.179989826633431, 72.808052686399606, 56.873064656345491, 72.667017596089863, 55.584944164766739, 72.394349754798895, 55.274666966065297, 72.300326361259067, 54.607100871889422, 72.084072556099272, 53.676269275785067, 71.745588339330425, 52.482172177752197, 71.303678389671404, 51.024809577790847, 70.739538028399693, 49.294779136546403, 70.071971934219619, 47.301483193373429, 69.29157776779175, 46.765549850161811, 69.084726301989576, 45.562050412774362, 68.671023370388866, 44.330343957323151, 68.294929796200449, 43.07043048380816, 67.965847918789223, 41.791712331583987, 67.683777738151548, 40.484787161296083, 67.458121593641408, 39.149654972944383, 67.270074806550838, 37.786315766528901, 67.129039716230182, 7.407357311850375, 67.072625680109923, 7.3039315789498849, 65.756298170461378, 7.3039315789498849, 65.417813953699806, 37.786315766528901, 64.609212769199075, 38.491491218123123, 64.552798733078816, 39.995865514857428, 64.402361303400539, 41.246376649017833, 64.223716855671228, 42.252426959958882, 64.026267729219398, 42.271231638668063, 64.026267729219398, 43.14564919864489, 63.772404566650948, 44.264527581841037, 63.396310992458893, 45.627866788256512, 62.879182327960734, 47.226264478536699, 62.230420912488626, 48.034865663031411, 61.891936695730692, 49.614458674602453, 61.243175280258583, 51.10943063198215, 60.67903491899051, 52.519781535170573, 60.190113272550661, 53.836109044813099, 59.776410340939037, 55.077217839618903, 59.437926124181104, 56.214900901524231, 59.174660622251395, 57.277365248592851, 58.986613835160824, 58.245806202115553, 58.873785762898478, 59.120223762092358, 58.836176405478909, 59.86300857110492, 58.864383423551772, 61.151129062683708, 59.071234889350308, 62.354628500071158, 59.466133142250328, 63.454702204558117, 60.067882860941609, 64.451350176144587, 60.857679366719822, 64.714615678073102, 61.120944868649531, 65.513814523213199, 62.136397518941521, 66.087357223843156, 63.24587356279153, 66.425841440608366, 64.458775339531712, 66.548071852218044, 65.756298170461378, 66.529267173508856, 66.273426834959537, 66.341220386417064, 67.561547326549771, 65.927517454815131, 68.746242085220729, 65.297560718057625, 69.827511111001513, 64.451350176144587, 70.805354403881211, 63.736772385195792, 71.397701783218508, 62.683710377481781, 72.018256180621393, 61.517820297512678, 72.469568469641672, 60.229699805933933, 72.732833971571381, 58.828751242100111, 72.826857365118485],
       [14.722377329720951, 72.892673740600003, 14.036006556835931, 72.873869061888399, 12.729081386547991, 72.676419935440208, 11.534984288515149, 72.272119343189843, 10.444312923382769, 71.679771963848907, 9.4664696305054576, 70.880573118709435, 9.0433643595489457, 70.438663169050415, 8.2817748718271957, 69.413808179400803, 7.7364391892610049, 68.285527456850104, 7.407357311850375, 67.072625680109923, 37.786315766528901, 67.129039716230182, 35.116051389825493, 67.129039716230182, 34.467289974358827, 67.176051413000096, 33.10395076794336, 67.307684163970407, 31.778220918946229, 67.495730951060978, 30.4806980880129, 67.740191774279083, 29.220784614497919, 68.041066633628361, 27.97967581969209, 68.398355529101536, 26.776176382304641, 68.821460800059867, 25.61028630233557, 69.29157776779175, 25.121364655896912, 69.498429233590286, 23.1750804094969, 70.344639775499672, 21.529671022443718, 71.049815227099316, 20.19453883409204, 71.623357927721372, 19.169683844441781, 72.046463198690617, 18.4457037141384, 72.319131039970671, 18.041403121891051, 72.460166130291327, 17.373837027715179, 72.629408238670294, 16.095118875491039, 72.826857365118485, 14.722377329720951, 72.892673740600003],
       [36.629828025914406, 101.15610584049136, 36.582816329141451, 101.15610584049136, 35.313500516271887, 101.04327776823993, 34.110001078884409, 100.73300056952939, 32.972318016979102, 100.21587190503124, 31.919256009265069, 99.491891774730902, 30.941412716387791, 98.561060178628395, 30.38667469446699, 97.893494084448321, 29.72851093964573, 96.868639094798709, 29.220784614497919, 95.740358372251649, 28.85409337966891, 94.518054256150208, 28.63783957451335, 93.201726746508939, 28.56262085967666, 91.781973503970221, 28.56262085967666, 91.669145431711513, 28.600230217095, 90.766520853670954, 28.7036559499955, 89.798079900148878, 28.872898058378102, 88.7544202317913, 29.098554202888241, 87.635541848590947, 29.390026722880521, 86.450847089909075, 29.747315618354921, 85.190933616398979, 30.16101854995685, 83.855801428049745, 30.640537857040929, 82.445450524861371, 31.176471200252511, 80.96928324619148, 31.78762325830084, 79.417897252678813, 32.45518935247668, 77.800694883688266, 33.066341410524977, 76.296320586960064, 33.592872414382022, 74.914176701830002, 34.025380024693114, 73.673067907031509, 34.363864241458352, 72.5635918631815, 34.617727404032252, 71.595150909670338, 34.721153136932742, 71.200252656770317, 34.909199924024527, 70.090776612931222, 35.050235014343372, 68.727437406509125, 35.116051389825493, 67.129039716230182, 37.786315766528901, 67.129039716230182, 37.87093682072021, 68.200906402660621, 38.021374250393649, 69.376198821981234, 38.228225716194601, 70.579698259371071, 38.491491218123123, 71.811404714819218, 38.811170756179138, 73.080720527690573, 39.187264330362723, 74.378243358620239, 39.619771940673843, 75.703973207619129, 40.118095926467078, 77.057910074679967, 40.672833948387883, 78.449456299160374, 40.851478396125053, 78.900768588180654, 41.50023981159174, 80.508568617809942, 42.07378251222169, 81.984735896490747, 42.572106498014932, 83.338672763540671, 43.014016447680632, 84.560976879638474, 43.380707682509637, 85.651648244769603, 43.6815825418565, 86.620089198298956, 43.916641025721212, 87.456897400850721, 44.020066758621702, 87.880002671809052, 44.283332260550218, 89.186927842099976, 44.433769690223642, 90.484450673029642, 44.490183726351177, 91.781973503970221, 44.461976708287402, 92.665793403299176, 44.292734599904797, 93.982120912940445, 43.973055061848747, 95.223229707749852, 43.502938094119287, 96.389119787709205, 42.882383696716367, 97.479791152851249, 42.111391869640038, 98.485841463789257, 41.189962612890263, 99.379063702468557, 40.127498265821679, 100.15945786890006, 39.008619882625538, 100.71419589082871, 37.842729802656443, 101.04327776823993, 36.629828025914406, 101.15610584049136],
     ],

135: [ [57.103796663762658, 5.2659885352186393, 56.283373308337246, 5.2386410900398914, 55.27151783664587, 5.1201354942495527, 54.177620029411969, 4.9287033779910416, 53.001679886635507, 4.655228926181735, 51.734581593256252, 4.2997121388289088, 50.385440964334443, 3.862153015939839, 48.954257999870059, 3.3425515574999736, 47.441032699863172, 2.7409077635202266, 46.957894501668193, 2.5494756472508016, 45.362626866118738, 1.9113685930387874, 44.059065312498348, 1.4008829496597173, 43.047209840807, 1.0362503472497337, 42.327060451044673, 0.79923915567997028, 42.108280889597893, 0.73542845026167925, 41.096425417906509, 0.50753307375998702, 39.801979679346402, 0.26140606711851433, 38.215827858857239, 0.0061632454307982698, 10.284970514151549, -0.048531644919421524, 10.18469654848843, -1.3612090136084589, 10.18469654848843, -1.4067880889087974, 10.30320214427212, -2.7285812726513541, 10.64048730150256, -3.9227530455391388, 11.20566783524009, -4.9801875925404602, 11.980512115364091, -5.9100007286906475, 12.144596786449201, -6.0649695847096154, 13.092641552718559, -6.7851189744797011, 14.1774235448922, -7.2956046178514953, 15.39894276297005, -7.6055423299003451, 16.73896757683158, -7.7058162955618172, 17.340611370810219, -7.6784688503794314, 18.288656137079609, -7.5508474395392113, 19.35520649913266, -7.3047204329086526, 20.549378272029688, -6.9583194606202596, 21.87117145577065, -6.5025287076095992, 23.32058605035559, -5.9373481738693954, 24.88850624072418, -5.2627778594105621, 25.663350520848191, -4.9163768871185312, 27.067186040131698, -4.3238489081995795, 28.306936888330139, -3.8498265250600525, 29.38260306544348, -3.485193922650069, 30.294184571471732, -3.2390669160195102, 31.260460967861661, -3.0476347997609992, 32.436401110638123, -2.883550128670322, 33.794657554620208, -2.755928717830102, 35.335230299807961, -2.6647705672185111, 63.703646767407243, -2.3912961154201184, 63.803920733070321, -1.078618746738357, 63.803920733070321, -1.0056922262592707, 63.676299322226377, 0.2796376972401049, 63.320782534875349, 1.455577840020851, 62.746486186077561, 2.5221282020684157, 61.935178645712398, 3.4610571532903123, 61.725514899325901, 3.6524892695488234, 60.750122687875688, 4.3635228442508378, 59.656224880641787, 4.8648926725691126, 58.443821477624198, 5.1657145695608051, 57.103796663762658, 5.2659885352186393],
       [17.1036001792429, 5.2659885352186393, 16.629577796108201, 5.256872720161482, 15.307784612367239, 5.0927880490708048, 14.113612839470219, 4.7463870767787739, 13.056178292477449, 4.1994381731601607, 12.12636515632863, 3.4610571532903123, 11.87112233464072, 3.2058143315989582, 11.132741314757819, 2.2395379352092277, 10.60402404126145, 1.1547559430291585, 10.284970514151549, -0.048531644919421524, 38.215827858857239, 0.0061632454307982698, 35.335230299807961, 0.50753307375998702, 34.314259013056329, 0.56222796411020681, 32.873960233531683, 0.68073355990054552, 31.679788460634661, 0.83570241591951344, 30.722627879305008, 1.0180187171317812, 30.230373866049749, 1.1365243129112059, 29.21851839435837, 1.4373462098992604, 28.04257825158194, 1.8384420725487871, 26.720785067840978, 2.3489277159314952, 25.24402302807519, 2.9596873249683995, 24.195704296142711, 3.4063622629182646, 22.746289701557771, 3.9806586117192637, 21.406264887696238, 4.4455651798016333, 20.16651403949783, 4.8010819671399076, 19.036152972022791, 5.065440603888419, 18.015181685271131, 5.2112936448611435, 17.1036001792429, 5.2659885352186393],
       [35.335230299807961, 70.371139695758757, 35.070871663059762, 68.830566950571665, 34.760933951010173, 67.381152355981612, 34.423648793779712, 66.086706617428717, 34.059016191368407, 64.938113919830357, 33.667036143776272, 63.935374263201084, 33.247708651003251, 63.087603462590778, 32.992465829315357, 62.668275969819661, 32.354358775095562, 61.784041908969812, 31.579514494971569, 60.890692033070081, 30.66793298894331, 59.979110527030571, 29.61049844195054, 59.049297390891297, 28.416326669053522, 58.110368439680315, 28.443674114234369, 58.083020994501567, 29.346139805202341, 57.025586447500245, 30.175678975688051, 55.968151900509838, 30.914059995570941, 54.901601538458635, 31.579514494971569, 53.825935361350275, 32.16292665882964, 52.741153369170206, 32.67341230220547, 51.647255561940256, 33.10185561003874, 50.544241939638596, 33.402677507028073, 49.69647113902829, 33.749078479318797, 48.593457516741182, 34.059016191368407, 47.453980634210893, 34.34160645823718, 46.287156306490942, 34.596849279925067, 45.083868718531448, 34.806513026311592, 43.844117870328773, 34.988829327517237, 42.577019576958264, 35.143798183542032, 41.282573838390817, 35.262303779325691, 39.951664839591103, 35.344346114868252, 38.584292580548208, 35.38992519016967, 37.189572876330203, 35.40815682029023, 35.767505726918898, 35.399041005229947, 34.628028844388609, 35.353461929928528, 33.260656585349352, 35.280535409446259, 31.911515956431685, 35.17114562872289, 30.589722772678215, 35.034408402818627, 29.295277034121682, 34.870323731733549, 28.019062925679464, 34.660659985347053, 26.77931207749134, 34.432764608839989, 25.548677044349461, 34.16840597209179, 24.354505271450762, 33.867584075102492, 23.17856512868093, 33.5394147329323, 22.039088246139727, 33.17478213052101, 20.908727178659319, 32.873960233531683, 20.070072193120723, 32.418169480517548, 18.976174385879858, 31.907683837141722, 17.864044948528317, 31.333387488343931, 16.7519155111695, 30.704396249184441, 15.639786073821597, 30.002478489542678, 14.51854082140926, 29.23675002447894, 13.388179753928853, 28.416326669053522, 12.257818686459359, 29.145591873876128, 11.68352233765836, 30.275952941351161, 10.717245941268629, 31.269576782921948, 9.787432805118442, 32.117347583528243, 8.8940829292114358, 32.828381158230258, 8.0371963135403348, 33.39356169196779, 7.2167729581196909, 33.621457068474847, 6.779213835230621, 34.04990037630813, 5.8038216237800953, 34.432764608839989, 4.6825763713604829, 34.779165581130741, 3.4337097081006505, 35.079987478120053, 2.0389900038790074, 35.335230299807961, 0.50753307375998702, 38.215827858857239, 0.0061632454307982698, 38.398144160062891, 1.1547559430291585, 38.68073442693165, 2.59505472255114, 38.999787954041551, 3.8986162761793821, 39.373536371513133, 5.065440603888419, 39.783748049225842, 6.1046435207608738, 40.239538802239963, 6.997993396671518, 40.531244884169013, 7.4902474099289975, 41.151120308268212, 8.3562498406499799, 41.898617143211389, 9.2678313466785767, 42.791967019119078, 10.22499192801115, 43.822054120930993, 11.218615769579628, 44.997994263707447, 12.257818686459359, 44.797446332381242, 12.549524768379342, 44.022602052257213, 13.743696541281679, 43.311568477555198, 14.919636684058787, 42.636998163094283, 16.086461011778738, 42.026238554055332, 17.235053709369822, 41.461058020317829, 18.374530591900111, 40.950572376941999, 19.495775844319724, 40.494781623927871, 20.607905281678541, 40.084569946215169, 21.701803088908491, 39.729053158864161, 22.786585081081284, 39.555852672718771, 23.397344690118189, 39.273262405850033, 24.473010867230187, 39.027135399222402, 25.603371934710594, 38.808355837775622, 26.77931207749134, 38.635155351630232, 28.009947110618668, 38.480186495605437, 29.286161219071801, 38.370796714882061, 30.607954402799805, 38.288754379339508, 31.993558291971567, 38.234059488977813, 33.41562544136832, 38.215827858857239, 34.901503296201554, 38.215827858857239, 35.129398672710522, 38.24317530403809, 36.624392342589999, 38.288754379339508, 38.055575307058461, 38.370796714882061, 39.441179196219309, 38.489302310665721, 40.781204010079819, 38.626039536569948, 42.057418118518399, 38.799240022715338, 43.297168966721074, 39.008903769101828, 44.482224924558977, 39.245914960669182, 45.612585992028471, 39.510273597417381, 46.697367984201264, 39.801979679346402, 47.727455086009286, 39.847558754647821, 47.864192311921215, 40.221307172119388, 48.985437564340828, 40.649750479952672, 50.115798631810321, 41.123772863087368, 51.246159699279815, 41.652490136583758, 52.385636581821018, 42.217670670321269, 53.525113464358583, 42.837546094420503, 54.664590346888872, 43.512116408881397, 55.813183044479956, 44.232265798643709, 56.961775742078316, 44.997994263707447, 58.110368439680315, 44.214034168523163, 58.748475493899605, 43.101904731168673, 59.732983520410926, 42.12651251971846, 60.68102828667179, 41.306089164293013, 61.592609792711301, 40.622403034771843, 62.46772803848944, 40.093685761275452, 63.306383024038951, 39.765516419105268, 63.962721708379831, 39.364420556452842, 64.947229734891152, 39.018019584162118, 66.077590802360646, 38.708081872112501, 67.362920725860022, 38.443723235364303, 68.794103690328484, 38.215827858857239, 70.371139695758757, 35.335230299807961, 70.371139695758757],
       [63.694530952346952, 70.498761106598977, 35.335230299807961, 70.371139695758757, 38.215827858857239, 70.371139695758757, 39.273262405850033, 70.289097360218875, 40.722677000434942, 70.143244319249789, 41.90773295827168, 69.979159648159111, 42.828430279360219, 69.796843346961396, 43.047209840807, 69.733032641539467, 43.904096456473553, 69.45955818973016, 45.016225893828022, 69.040230696959043, 46.356250707689547, 68.475050163218839, 47.951518343239002, 67.773132403581258, 48.571393767338208, 67.517889581889904, 50.029924176983428, 66.9527090481497, 51.40641225108606, 66.478686665021087, 52.700857989646209, 66.086706617428717, 53.91326139266377, 65.785884720429749, 55.034506645078523, 65.567105158988852, 56.07370956195075, 65.439483748148632, 57.030870143280403, 65.393904672841018, 57.422850190872559, 65.403020487901813, 58.744643374613531, 65.557989343931695, 59.929699332450241, 65.904390316220088, 60.996249694503312, 66.451339219838701, 61.935178645712398, 67.198836054780259, 62.026336796315242, 67.289994205380935, 62.810296891499547, 68.238038971649075, 63.357245795116476, 69.313705148761073, 63.694530952346952, 70.498761106598977],
       [16.3105242689983, 78.083119236758648, 15.06165760573961, 77.9828452710899, 13.858370017782301, 77.663791743980255, 12.782703840668971, 77.116842840368918, 11.84377488945986, 76.351114375298494, 11.06893060933583, 75.421301239148306, 10.494634260538049, 74.354750877100741, 10.15734910330761, 73.1696949192592, 10.03884350752392, 71.884364995759825, 38.215827858857239, 73.105884213840909, 35.335230299807961, 73.105884213840909, 34.925018622095251, 73.142347474080452, 33.402677507028073, 73.297316330110334, 32.172042473889917, 73.479632631311688, 31.22399770762053, 73.689296377699065, 30.768206954606431, 73.80780197347849, 29.792814743156189, 74.099508055409387, 28.625990415440011, 74.509719733130623, 27.276849786518198, 75.02020537649878, 25.754508671451021, 75.630964985539322, 24.669726679277399, 76.050292478321353, 23.192964639511612, 76.588125566868257, 21.807360750348689, 77.043916319878917, 20.52203082684883, 77.417664737349696, 19.32785905395184, 77.709370819280593, 18.224845431657631, 77.919034565671609, 17.222105775026559, 78.03754016145831, 16.3105242689983, 78.083119236758648],
       [57.322576225209438, 78.083119236758648, 56.903248732436452, 78.074003421690577, 55.873161630624509, 77.991961086161609, 54.770148008330317, 77.827876415070932, 53.603323680614182, 77.581749408440373, 52.363572832415741, 77.235348436148342, 51.050895463735053, 76.816020943380863, 49.683523204692683, 76.305535300001793, 48.234108610107768, 75.703891506018408, 47.26783221371781, 75.302795643368881, 45.745491098650632, 74.692036034328339, 44.487508620331617, 74.218013651199726, 43.493884778760837, 73.880728493968491, 42.75550375887795, 73.689296377699065, 42.272365560682971, 73.570790781908727, 41.19669938356963, 73.397590295771806, 39.847558754647821, 73.2426214397492, 38.215827858857239, 73.105884213840909, 10.03884350752392, 71.884364995759825, 10.03884350752392, 71.857017550581077, 10.15734910330761, 70.55345599696011, 10.494634260538049, 69.368400039129483, 11.0506989792153, 68.292733862010209, 11.84377488945986, 67.344689095738431, 11.852890704520149, 67.326457465620479, 12.81005128584982, 66.542497370439378, 13.885717462963161, 65.986432651759969, 15.079889235860181, 65.649147494528734, 16.38345078948058, 65.539757713810104, 17.32237974068968, 65.576220974049647, 18.434509178044149, 65.694726569829072, 19.601333505760291, 65.895274501159292, 20.831968538898451, 66.18698058309019, 22.126414277458569, 66.560729000560968, 23.475554906380381, 67.016519753571629, 24.88850624072418, 67.554352842129447, 25.289602103376609, 67.71843751320921, 27.00337533470972, 68.374776197550091, 28.443674114234369, 68.921725101179618, 29.61961425701082, 69.35016840901153, 30.522079947978799, 69.669221936121176, 31.160187002198569, 69.860654052379687, 31.388082378705629, 69.91534894274082, 32.381706220276421, 70.079433613831497, 33.703499404017379, 70.234402469850465, 35.335230299807961, 70.371139695758757, 63.694530952346952, 70.498761106598977, 63.803920733070321, 71.811438475280738, 63.803920733070321, 71.838785920459486, 63.685415137286668, 73.142347474080452, 63.3481299800562, 74.327403431918356, 62.792065261378973, 75.393953793969558, 62.00810516619466, 76.351114375298494, 61.916947015591852, 76.433156710849289, 60.959786434262178, 77.153306100601185, 59.875004442088567, 77.67290755904105, 58.662601039070978, 77.9828452710899, 57.322576225209438, 78.083119236758648],
       [36.848455599814862, 102.52261941336837, 36.018916429329153, 102.48615615312883, 34.788281396191017, 102.25826077663078, 33.648804513655712, 101.82070165373079, 32.609601596783477, 101.19171041457957, 31.661556830514119, 100.36217124409086, 31.597746125092129, 100.28924472361177, 30.868480920269519, 99.350315772400791, 30.303300386532019, 98.301997040460265, 29.893088708819281, 97.15340434286918, 29.65607751725193, 95.886306049491395, 29.574035181709409, 94.518933790441224, 29.583150996769689, 93.716742065138533, 29.674309147372501, 92.394948881399614, 29.856625448578171, 91.273703628990916, 29.94778359918098, 91.009344992238766, 30.2577213112306, 90.161574191628461, 30.786438584726969, 88.812433562710794, 31.51570378954958, 86.952807290410419, 31.94414709738286, 85.840677853051602, 32.509327631120392, 84.309220922928944, 33.02892908955647, 82.896269588589348, 33.484719842570598, 81.610939665089973, 33.885815705223052, 80.444115337370022, 34.232216677513783, 79.39579660544041, 34.523922759442833, 78.456867654218513, 34.760933951010173, 77.654675928930374, 34.8976711769144, 77.135074470490508, 35.08910329318033, 76.050292478321353, 35.234956334144869, 74.71026766444993, 35.335230299807961, 73.105884213840909, 38.215827858857239, 73.105884213840909, 38.32521763958065, 74.254476911439269, 38.480186495605437, 75.54892264999944, 38.689850241991941, 76.816020943380863, 38.945093063679849, 78.074003421690577, 39.236799145608899, 79.304638454828819, 39.583200117899622, 80.526157672909903, 39.975180165491771, 81.720329445808602, 40.403623473325062, 82.905385403650143, 40.886761671520013, 84.063093916298385, 41.233162643810772, 84.883517271729943, 41.916848773331957, 86.497016537399759, 42.482029307069467, 87.873504611499811, 42.928704245023312, 89.0129814940301, 43.26598940225378, 89.906331369940744, 43.48476896370056, 90.55355423922083, 43.667085264906198, 91.51983063561056, 43.794706675750149, 92.786928928988345, 43.840285751051567, 94.236343523571122, 43.831169935991277, 94.701250091649854, 43.721780155267908, 96.141548871168197, 43.475653148640269, 97.426878794671211, 43.083673101048127, 98.575471492269571, 42.55495582755173, 99.578211148898845, 41.898617143211389, 100.43509776456995, 41.433710575136978, 100.88177270251981, 40.458318363686743, 101.60192209227898, 39.373536371513133, 102.11240773566169, 38.17024878355582, 102.42234544771054, 36.848455599814862, 102.52261941336837],
     ],

136: 63,

137: [ [133.10234682133819, 44.739196354119485, 121.89901011225091, 44.702733093879942, 122.9746762893643, 44.611574943279265, 124.0594582815379, 44.310753046291211, 125.0895453833498, 43.800267402908503, 126.0740534098603, 43.089233828210126, 127.00386654600911, 42.159420692059939, 127.8789847917963, 41.029059624590445, 127.933679682158, 40.94701728903965, 128.38947043517209, 40.190404639040935, 128.81791374300539, 39.360865468548582, 129.2098937905975, 38.449283962519985, 129.56541057794851, 37.473891751080373, 129.8935799201187, 36.425573019139847, 130.17617018698749, 35.304327766731149, 130.43141300867541, 34.110155993828812, 130.65930838518241, 32.843057700451027, 130.84162468638809, 31.503032886590518, 130.99659354241291, 30.090081552250922, 131.1150991381966, 28.613319512478483, 131.19714147373909, 27.054515137169801, 131.2518363641008, 25.422784241378395, 131.27006799422139, 23.727242640168697, 131.27006799422139, 23.371725852819509, 131.2518363641008, 21.657952621480945, 131.22448891892, 20.017105910628743, 131.1697940285583, 18.467417350380856, 131.10598332313629, 16.999771125680127, 131.01482517253351, 15.614167236519279, 130.91455120687041, 14.310605682898313, 130.78692979602641, 13.098202279881662, 130.65019257012219, 11.958725397340459, 130.48610789903711, 10.901290850350051, 130.31290741289169, 9.9258986388995254, 130.11235948156551, 9.0325487629888812, 129.8935799201187, 8.2212412226290326, 129.7568426942145, 7.7654504696183722, 129.25547286589889, 6.3707307653894532, 128.70852396228199, 5.1036324720116681, 128.10688016830329, 3.9732714045312605, 127.45965729902331, 2.9705317479092628, 126.7577395393815, 2.1045293171810044, 126.0102427044383, 1.3752641123610374, 125.70030499238879, 1.1382529207912739, 124.6246388152754, 0.50926168162914109, 123.44869867249901, 0.13551326415836229, 122.1816003791197, 0.0078918533108662814, 110.8688738893091, -0.019455591871519573, 111.88072936100041, -0.71225753644830547, 112.5279522302805, -1.1315850292194227, 113.68566074293641, -1.7879237135603034, 114.84336925559219, -2.3622200623613026, 116.0193093983687, -2.8544740756115061, 117.2043653562054, -3.2555699382683088, 118.39853712910239, -3.5655076503207965, 119.6018247170597, -3.7842872117689694, 120.8142281200773, -3.9119086226091895, 122.0448631532154, -3.9574876979095279, 122.9837921044245, -3.93014025273078, 124.1779638773216, -3.8207504720012366, 125.3721356502186, -3.6293183557390876, 126.5663074231156, -3.3467280888689857, 127.7513633809523, -2.9729796713982068, 128.93641933878899, -2.5171889183802705, 130.1305911116861, -1.9793558298297285, 131.3065312544625, -1.3503645906712336, 132.49158721229921, -0.63933101596921915, 133.13881008157929, -0.21088770813003066, 134.14154973821039, 0.52749331175073166, 135.08959450447969, 1.3205692219889897, 135.98294438038741, 2.1774558376600908, 136.82159936593339, 3.0890373436886875, 137.60555946111771, 4.055313740078418, 138.3439404810006, 5.0854008418900776, 139.01851079546151, 6.1701828340701468, 139.63838621956069, 7.3096597166004358, 140.2035667532983, 8.5129473045599298, 140.50438865028761, 9.2239808792583062, 140.90548451294001, 10.272299611191556, 141.26100130029101, 11.366197418428783, 141.5891706424612, 12.496558485898277, 141.87176090932999, 13.672498628679023, 142.1178879159576, 14.884902031688398, 142.32755166234409, 16.142884510009026, 142.4916363334292, 17.446446063629992, 142.6283735593334, 18.795586692558572, 142.71953170993621, 20.18119058171942, 142.78334241535819, 21.603257731130725, 142.80157404547879, 23.080019770888612, 142.78334241535819, 24.055411982339137, 142.72864752499649, 25.386320981138851, 142.61925774427311, 26.689882534759818, 142.46428888824829, 27.975212458259193, 142.26374095692211, 29.242310751640616, 142.0176139502945, 30.482061599839653, 141.7259078683654, 31.694465002859943, 141.3795068960747, 32.888636775751365, 140.98752684848259, 34.064576918528473, 140.549967725589, 35.213169616119558, 140.05771371233371, 36.343530683599965, 139.63838621956069, 37.191301484210271, 139.000279165341, 38.339894181801355, 138.30747722075949, 39.424676173981425, 137.5690962008766, 40.463879090850241, 136.776020290632, 41.430155487239972, 135.92824949002571, 42.350852808329364, 135.03489961411799, 43.207739424000465, 134.095970662909, 44.000815334238723, 133.10234682133819, 44.739196354119485],
       [63.184045308971122, 44.839470319788234, 62.20865309752088, 44.119320930021786, 61.287955776432341, 43.335360834840685, 60.403721715584943, 42.487590034230379, 59.574182545099227, 41.576008528201783, 58.790222449914921, 40.600616316751257, 58.042725614971772, 39.561413399878802, 57.349923670390297, 38.458399777591694, 56.702700801110232, 37.291575449871743, 56.09194119207131, 36.051824601669068, 55.991667226408197, 35.833045040220895, 55.508529028213218, 34.693568157690606, 55.070969905319657, 33.544975460088608, 54.678989857727522, 32.369035317318776, 54.34170470049704, 31.165747729359282, 54.040882803507742, 29.953344326338993, 53.785639981819827, 28.713593478150869, 53.57597623543333, 27.455610999819328, 53.421007379408501, 26.170281076319952, 53.302501783624848, 24.875835337759781, 53.229575263142578, 23.554042154031777, 53.211343633022011, 22.214017340160353, 53.211343633022011, 21.575910285941063, 53.25692270832343, 20.135611506419082, 53.348080858926267, 18.731775987129367, 53.484818084830493, 17.373519543150906, 53.676250201096423, 16.051726359408349, 53.904145577603479, 14.757280620851816, 54.186735844472253, 13.508413957588346, 54.505789371582161, 12.296010554571694, 54.879537789053728, 11.129186226859019, 55.298865281826721, 9.9897093443214544, 55.763771849901133, 8.8958115370915039, 56.283373308337246, 7.8383769901010965, 56.839438027014459, 6.8174057033393183, 57.450197636053389, 5.8328976768389111, 58.106536320393751, 4.8848529105707712, 58.808454080035489, 3.9732714045312605, 59.555950914978659, 3.1072689738102781, 59.856772811967993, 2.7699838165790425, 60.813933393297638, 1.7763599750105641, 61.78932560474788, 0.86477846897832933, 62.792065261378973, 0.026123483428818872, 63.813036548130611, -0.73048916656989604, 64.861355280063108, -1.4141752960895246, 65.927905642116158, -2.0067032750084763, 67.01268763428979, -2.5263047334410658, 68.115701256583975, -2.9638638563410495, 69.246062324059011, -3.3193806436902378, 70.3946550216546, -3.6019709105494258, 71.561479349370771, -3.8025188418796461, 72.755651122267778, -3.9210244376699848, 73.968054525285353, -3.9574876979095279, 74.68820391504768, -3.9392560677915753, 75.873259872884404, -3.8480979171908984, 77.067431645781426, -3.6657816159786307, 78.25248760361815, -3.3923071641693241, 79.446659376515171, -3.0276745617593406, 80.631715334351895, -2.5809996238094755, 81.825887107248903, -2.0522823503088148, 83.010943065085655, -1.4232911111503199, 84.205114837982634, -0.71225753644830547, 84.970843303046365, -0.19265607800844009, 73.822201484320843, 0.0078918533108662814, 72.937967423473424, 0.062586743679275969, 71.82583798611897, 0.3360611954885826, 70.777519254186473, 0.81008357862083358, 69.802127042736245, 1.5120013382584148, 68.899661351768273, 2.4144670292298542, 68.061006366222273, 3.5357122816385527, 67.75106865417267, 4.0370821099604655, 67.34085697645996, 4.8210422051415662, 66.948876928867804, 5.6779288208090293, 66.602475956577067, 6.6077419569592166, 66.274306614406896, 7.6104816135884903, 65.982600532477861, 8.6861477907114022, 65.727357710789946, 9.8347404882988485, 65.490346519222584, 11.056259706379933, 65.298914402956669, 12.350705444940104, 65.125713916811293, 13.718077703979361, 64.988976690907066, 15.149260668440547, 64.879586910183676, 16.662485968448891, 64.806660389701406, 18.248637788939959, 64.761081314400002, 19.907716129910114, 64.742849684279435, 21.630605176298559, 64.751965499339718, 23.244104441968375, 64.779312944520555, 24.894066967888648, 64.824892019821974, 26.471102973311645, 64.888702725243959, 27.956980828141241, 64.979860875846782, 29.351700532359246, 65.080134841509889, 30.673493716109078, 65.207756252353846, 31.904128749250958, 65.344493478258073, 33.043605631781247, 65.508578149343165, 34.110155993828812, 65.690894450548811, 35.076432390218542, 65.891442381875038, 35.969782266129187, 66.110221943321818, 36.77197399142824, 66.164916833683506, 36.945174477579712, 66.648055031878485, 38.33077836674056, 67.195003935495436, 39.579645030000393, 67.805763544534358, 40.7100060974808, 68.480333858995266, 41.712745754110074, 69.209599063817876, 42.587863999888214, 70.002674974062444, 43.335360834840685, 70.35819176141348, 43.608835286649992, 71.433857938526813, 44.219594895690534, 72.609798081303254, 44.584227498100518, 73.895128004803098, 44.702733093879942, 63.184045308971122, 44.839470319788234],
       [121.89901011225091, 48.522259604138526, 121.7166938110453, 48.522259604138526, 120.59544855863049, 48.467564713770116, 119.4468558610349, 48.321711672808306, 118.27091571825849, 48.084700481238542, 117.0767439453615, 47.75653113907174, 115.8643405423439, 47.346319461361418, 114.6337055092057, 46.844949633050419, 113.3757230308868, 46.252421654131467, 112.0995089224472, 45.568735524608201, 111.2061590465395, 45.021786620989587, 110.2034193899084, 44.319868861348368, 109.2553746236391, 43.554140396281582, 108.3620247477314, 42.715485410739348, 107.5233697621854, 41.822135534828703, 106.7302938519408, 40.855859138438973, 106.0010286471182, 39.825772036630951, 105.3082267025367, 38.731874229401001, 104.6792354633772, 37.56504990168105, 104.0958232995191, 36.343530683599965, 103.7494223272284, 35.513991513118526, 103.33009483445539, 34.4200937058813, 102.95634641698381, 33.289732638411806, 102.61906125975329, 32.132024125749012, 102.3273551778243, 30.946968167911109, 102.0629965410761, 29.725448949830025, 101.85333279468961, 28.467466471520311, 101.671016493484, 27.182136548020935, 101.53427926757971, 25.860343364278378, 101.4340053019166, 24.511202735349798, 101.3793104115549, 23.12559884618895, 101.3519629663741, 21.703531696788559, 101.3701945964947, 20.691676225091214, 101.4340053019166, 19.351651411241619, 101.54339508264, 18.038974042548944, 101.6983639386648, 16.753644119049568, 101.90802768505129, 15.486545825671783, 102.1632705067392, 14.255910792529903, 102.4640924037286, 13.043507389520528, 102.81960919107961, 11.849335616618191, 103.220705053732, 10.69162710396995, 103.66737999168581, 9.5521502214287466, 104.16874982000139, 8.4400207840808434, 104.5151507922921, 7.7016397641891672, 105.14414203145159, 6.525699621419335, 105.8095965308522, 5.4044543689997226, 106.5388617356749, 4.3470198220093152, 107.3045902007386, 3.3533959804408369, 108.12501355616401, 2.4144670292298542, 108.9910159868908, 1.5393487834408006, 109.9025974929191, 0.72804124308095197, 110.8688738893091, -0.019455591871519573, 122.1816003791197, 0.0078918533108662814, 121.0785867568255, 0.099050003918819129, 119.966457319471, 0.39075608584971633, 118.91813858753849, 0.8830100990999199, 117.94274637608829, 1.5940436737982964, 117.04028068512029, 2.4965093647697358, 116.20162569957429, 3.6086388021285529, 115.8278772821027, 4.2376300412906858, 115.42678141945029, 5.0215901364717865, 115.0530330019787, 5.8875925672000449, 114.706632029688, 6.8174057033393183, 114.38757850257809, 7.8292611750403012, 114.1049882357094, 8.9049273521486612, 113.8497454140214, 10.062635864811455, 113.62185003751441, 11.284155082881625, 113.43041792124841, 12.587716636498953, 113.2663332501634, 13.964204710599006, 113.1295960242591, 15.404503490128263, 113.0202062435357, 16.92684460520104, 112.9472797230535, 18.522112240749266, 112.90170064775209, 20.18119058171942, 112.8925848326918, 21.922311258229456, 112.8925848326918, 23.116483031131793, 112.9290480929329, 24.830256262459443, 112.9837429832946, 26.480218788368802, 113.0657853188371, 28.057254793799075, 113.17517509956051, 29.552248463689466, 113.3119123254648, 30.983431428161566, 113.4759969965499, 32.341687872140028, 113.6674291128158, 33.627017795639404, 113.87709285920231, 34.839421198648779, 114.1232198658299, 35.988013896250777, 114.38757850257809, 37.054564258298342, 114.6884003995674, 38.048188099881372, 115.0074539266773, 38.978001236020646, 115.35385489896809, 39.825772036630951, 115.7276033164396, 40.609732131808414, 116.1286991790921, 41.320765706521343, 116.6847638977693, 42.095609986641648, 117.5507663284961, 43.034538937848993, 118.5079269098258, 43.76380414266896, 119.547129826698, 44.29252141616962, 120.6774908941731, 44.60245912821847, 121.89901011225091, 44.702733093879942, 133.10234682133819, 44.739196354119485, 132.0631439044659, 45.422882483639114, 131.46150011048729, 45.769283455931145, 130.23086507734919, 46.41650632521123, 129.00934585927129, 46.972571043890639, 127.7969424562537, 47.446593427019252, 126.6027706833567, 47.838573474618897, 125.4085989104597, 48.13939537161059, 124.22354295262301, 48.358174933051487, 123.05671862490679, 48.485796343891707, 121.89901011225091, 48.522259604138526],
       [74.186834086732134, 48.522259604138526, 73.649000998175467, 48.513143789081369, 72.454829225278459, 48.431101453541487, 71.260657452381452, 48.26701678245081, 70.06648567948443, 48.011773960759456, 68.872313906587422, 47.665372988471063, 67.678142133690415, 47.23692968063915, 66.483970360793393, 46.717328222199285, 65.289798587896385, 46.115684428219538, 64.095626814999378, 45.422882483639114, 63.184045308971122, 44.839470319788234, 73.895128004803098, 44.702733093879942, 74.861404401193042, 44.629806573400856, 75.955302208426957, 44.338100491469959, 76.985389310238887, 43.836730663151684, 77.942549891568547, 43.116581273388874, 78.835899767476235, 42.17765232218153, 79.665438937961952, 41.029059624590445, 79.929797574710136, 40.591500501690462, 80.358240882543413, 39.798424591448565, 80.759336745195853, 38.941537975781102, 81.133085162667442, 38.02084065469171, 81.470370319897896, 37.027216813119594, 81.780308031947484, 35.978898081189982, 82.062898298816236, 34.857652828781283, 82.318141120504166, 33.672596870939742, 82.536920681950946, 32.42373020767991, 82.728352798216875, 31.111052839001786, 82.892437469301953, 29.734564764901734, 83.029174695206194, 28.285150170311681, 83.129448660869315, 26.771924870299699, 83.202375181351556, 25.194888864869426, 83.247954256652974, 23.554042154031777, 83.266185886773528, 21.84938473775037, 83.257070071713272, 20.399970143160317, 83.211490996411854, 18.759123432319029, 83.138564475929584, 17.191203241949552, 83.029174695206194, 15.687093756998365, 82.892437469301953, 14.255910792529903, 82.719236983156577, 12.88853853350156, 82.509573236770095, 11.584976979880594, 82.281677860263017, 10.354341946738714, 82.008203408454563, 9.1875176190187631, 81.707381511465215, 8.0936198117888125, 81.379212169295045, 7.063532709980791, 81.014579566883754, 6.0972563135910605, 80.622599519291626, 5.2039064376804163, 80.194156211458335, 4.3743672671917011, 79.738365458444207, 3.6086388021285529, 78.999984438561327, 2.6150149605600745, 78.097518747593355, 1.676086009341816, 77.131242351203383, 0.94682080451821093, 76.092039434331198, 0.42721934608925949, 74.989025812036999, 0.10816581897961441, 73.822201484320843, 0.0078918533108662814, 84.970843303046365, -0.19265607800844009, 85.946235514496635, 0.54572494186868425, 86.876048650645416, 1.3388008521105803, 87.751166896432551, 2.1956874677816813, 88.589821881978537, 3.1163847888710734, 89.373781977162835, 4.0917770003215992, 90.121278812105999, 5.1218641021296207, 90.814080756687488, 6.2157619093704852, 91.461303625967545, 7.3734704220187268, 92.062947419946198, 8.5858738250390161, 92.181453015729858, 8.8502324617911654, 92.646359583804283, 9.944130269021116, 93.065687076577277, 11.074491336501524, 93.448551309109135, 12.232199849149765, 93.776720651279305, 13.417255806991307, 94.068426733208355, 14.629659210011596, 94.314553739835986, 15.869410058210633, 94.515101671162199, 17.136508351581142, 94.670070527187008, 18.430954090148589, 94.779460307910398, 19.761863088948303, 94.84327101333237, 21.120119532930403, 94.870618458513221, 22.496607607030455, 94.852386828392639, 23.617852859450068, 94.788576122970667, 24.921414413071034, 94.679186342247277, 26.215860151620291, 94.515101671162199, 27.48295844500899, 94.305437924775688, 28.740940923318703, 94.050195103087788, 29.980691771521379, 93.749373206098468, 31.202210989598825, 93.402972233807731, 32.405498577558319, 93.001876371155305, 33.590554535388947, 92.555201433201447, 34.757378863108897, 92.062947419946198, 35.905971560710896, 91.579809221751219, 36.890479587218579, 90.932586352471148, 38.075535545049206, 90.24890022294997, 39.205896612529614, 89.519635018127374, 40.263331159520021, 88.753906553063629, 41.266070816149295, 87.942599012698494, 42.214115582421073, 87.085712397031926, 43.089233828210126, 86.192362521124238, 43.909657183641684, 85.253433569915146, 44.657154018579604, 84.278041358464904, 45.349955963160028, 83.712860824727386, 45.705472750509216, 82.555152312071513, 46.361811434850097, 81.379212169295045, 46.936107783651096, 80.203272026518604, 47.428361796908575, 79.01821606868188, 47.820341844490031, 77.814928480724589, 48.130279556549795, 76.611640892767298, 48.349059117990691, 75.408353304810007, 48.485796343891707, 74.186834086732134, 48.522259604138526],
       [14.496477072002079, 96.407636115800415, 13.5393164906724, 95.687486726041243, 12.63685079970443, 94.903526630860142, 11.770848368977591, 94.055755830249836, 10.950425013552181, 93.135058509160444, 10.17558073342815, 92.141434667588328, 9.4463155286055667, 91.093115935658716, 8.7535135840240912, 89.971870683239104, 8.1154065298043179, 88.7868147254012, 7.51376273582565, 87.528832247091486, 7.4317204002831261, 87.328284315761266, 6.9576980171484299, 86.179691618159268, 6.5292547093151541, 85.012867290450231, 6.1463904767832673, 83.82781133260869, 5.8091053195528266, 82.624523744649196, 5.5173992376237768, 81.403004526579025, 5.2712722309961464, 80.163253678379988, 5.061608484609649, 78.90527120005936, 4.9066396285848546, 77.62905709162078, 4.7972498478614511, 76.334611353060609, 4.72432332737921, 75.021933984378848, 4.7060916972586417, 73.691024985579133, 4.7060916972586417, 73.481361239191756, 4.7334391424394928, 72.113988980148861, 4.8154814779820176, 70.773964166288351, 4.9339870737657057, 69.461286797610228, 5.1071875599110683, 68.175956874110852, 5.316851306297564, 66.917974395790225, 5.5812099430457627, 65.678223547591188, 5.8911476550953799, 64.474935959631694, 6.2466644424463871, 63.298995816858223, 6.6477603050988128, 62.141287304199068, 7.0944352430526569, 61.020042051779456, 7.5866892563079196, 59.91702842948871, 8.0151325641411972, 59.041910183699656, 8.6532396183609706, 57.865970040929824, 9.3369257478821623, 56.753840603571007, 10.066190952704771, 55.705521871641395, 10.841035232828769, 54.711898030069278, 11.6705744033145, 53.791200708979886, 12.545692649101619, 52.925198278258904, 13.466389970190161, 52.113890737891779, 14.43266636658009, 51.375509718000103, 15.44452183827147, 50.691823588480474, 16.18290285815436, 50.236032835469814, 17.349727185870499, 49.597925781250524, 18.51655151358668, 49.041861062571115, 19.701607471423412, 48.57695449449966, 20.88666342926015, 48.194090261971724, 22.08995101721743, 47.902384180040826, 23.302354420235019, 47.683604618589015, 24.523873638312871, 47.555983207748795, 25.754508671451021, 47.519519947498338, 26.201183609404868, 47.519519947498338, 27.431818642542989, 47.592446467988339, 28.635106230500298, 47.738299508950149, 29.82016218833704, 47.957079070398322, 30.96875488593264, 48.257900967390015, 32.099115953407683, 48.640765199921589, 33.202129575701861, 49.10567176800032, 34.286911567875478, 49.643504856550862, 35.335230299807961, 50.254264465591405, 36.365317401619897, 50.94706641016819, 25.60865563048651, 51.120266896319663, 24.57856852867457, 51.202309231859545, 23.466439091320101, 51.494015313790442, 22.427236174447899, 51.986269327051559, 21.45184396299766, 52.68818708668914, 20.540262456969401, 53.608884407778532, 19.692491656363131, 54.730129660190869, 19.656028396122, 54.793940365620074, 19.218469273228429, 55.532321385489922, 18.81737341057601, 56.343628925860685, 18.452740808164691, 57.227862986710534, 18.106339835873971, 58.175907752978674, 17.79640212382435, 59.205994854790333, 17.513811856955609, 60.299892662020284, 17.258569035267701, 61.457601174679439, 17.039789473820921, 62.697352022878476, 16.839241542494701, 64.000913576499443, 16.684272686469878, 65.377401650599495, 16.547535460565651, 66.826816245189548, 16.438145679842251, 68.349157360251411, 16.365219159360009, 69.935309180749755, 16.319640084058591, 71.594387521708995, 16.3105242689983, 73.32639238316915, 16.3105242689983, 73.590751019921299, 16.319640084058591, 75.176902840401453, 16.356103344299719, 76.708359770531388, 16.419914049721712, 78.176005995239393, 16.492840570203949, 79.579841514518193, 16.59311453586707, 80.938097958500293, 16.711620131650729, 82.223427882010583, 16.857473172615268, 83.463178730198706, 17.02155784370035, 84.639118872979452, 17.212989959966279, 85.751248310330993, 17.413537891292489, 86.808682857328677, 17.641433267799549, 87.811422513961588, 17.896676089487471, 88.759467280229728, 18.279540322019329, 89.880712532638427, 18.80825759551573, 91.156926641080645, 19.400785574434082, 92.3146351537398, 20.057124258774419, 93.34472225555146, 20.786389463597029, 94.247187946519261, 21.570349558781349, 95.031148041700362, 21.634160264203299, 95.076727117000701, 22.66424736601525, 95.687486726041243, 23.840187508791669, 96.061235143508384, 25.171096507592949, 96.179740739298722, 14.496477072002079, 96.407636115800415],
       [87.951714827758764, 99.999267249560944, 81.534181025319853, 99.999267249560944, 11.479142287048569, -3.9574876979095279, 17.896676089487471, -3.9574876979095279, 87.951714827758764, 99.999267249560944],
       [25.462802589521971, 99.999267249560944, 24.742653199759651, 99.990151434489235, 23.493786536500949, 99.898993283888558, 22.272267318423079, 99.725792797740723, 21.059863915405518, 99.461434160999488, 19.856576327448209, 99.124149003760976, 18.680636184671751, 98.695705695929064, 17.513811856955609, 98.176104237500113, 16.365219159360009, 97.583576258581161, 15.22574227682469, 96.899890129061532, 14.496477072002079, 96.407636115800415, 25.171096507592949, 96.179740739298722, 25.344296993738311, 96.179740739298722, 26.502005506394202, 96.052119328451226, 27.595903313628099, 95.723949986280786, 28.635106230500298, 95.195232712780125, 29.61049844195054, 94.475083323020954, 30.522079947978799, 93.554386001931562, 31.369850748585069, 92.433140749519225, 31.73448335099636, 91.849728585661069, 32.15381084376935, 91.047536860358377, 32.554906706421797, 90.172418614569324, 32.919539308833087, 89.233489663358341, 33.247708651003251, 88.221634191668272, 33.548530547992591, 87.145968014548998, 33.822004999801067, 85.988259501900757, 34.059016191368407, 84.766740283819672, 34.259564122694627, 83.481410360320297, 34.432764608839989, 82.114038101281039, 34.578617649804528, 80.682855136808939, 34.688007430527911, 79.187861466929462, 34.770049766070457, 77.610825461499189, 34.815628841371847, 75.969978750650625, 34.833860471492422, 74.265321334380133, 34.824744656432131, 72.99822304099871, 34.788281396191017, 71.330028884960484, 34.724470690769039, 69.725645434351463, 34.633312540166202, 68.185072689171648, 34.514806944382549, 66.717426464460004, 34.359838088357719, 65.313590945181204, 34.186637602212357, 63.973566131320695, 33.976973855825861, 62.697352022878476, 33.73996266425852, 61.484948619858187, 33.484719842570598, 60.345471737320622, 33.183897945581293, 59.269805560208624, 32.864844418471392, 58.257950088518555, 32.518443446180669, 57.309905322250415, 32.144695028709073, 56.434787076461362, 31.73448335099636, 55.614363721040718, 31.2969242281028, 54.86686688609916, 30.622353913641891, 53.90059048970943, 29.7290040377342, 52.906966648140951, 28.780959271464809, 52.123006552948937, 27.778219614833748, 51.566941834269528, 26.720785067840978, 51.229656677038292, 25.60865563048651, 51.120266896319663, 36.365317401619897, 50.94706641016819, 37.377172873311252, 51.72191069029941, 38.352565084761487, 52.569681490909716, 39.30972566609114, 53.499494627048989, 40.239538802239963, 54.511350098739058, 40.494781623927871, 54.81217199573075, 41.205815198629921, 55.687290241519804, 41.871269698030538, 56.607987562609196, 42.491145122129751, 57.565148143941769, 43.065441470927567, 58.567887800571043, 43.594158744423929, 59.60709071743986, 44.068181127558631, 60.682756894559134, 44.505740250452192, 61.794886331910675, 44.897720298044327, 62.952594844558917, 45.244121270335079, 64.146766617461253, 45.535827352264128, 65.38651746566029, 45.791070173952022, 66.653615759041713, 46.000733920338547, 67.966293127719837, 46.155702776363341, 69.324549571698299, 46.274208372147001, 70.71015346087006, 46.338019077568987, 72.141336425331247, 46.365366522749831, 73.618098465100047, 46.365366522749831, 73.681909170518338, 46.338019077568987, 75.031049799439643, 46.26509255708671, 76.352842983178562, 46.155702776363341, 77.656404536799528, 45.991618105278263, 78.941734460298903, 45.791070173952022, 80.199716938619531, 45.544943167324419, 81.439467786818568, 45.253237085395369, 82.651871189838857, 44.90683611310461, 83.855158777791075, 44.523971880572752, 85.021983105511026, 44.095528572739482, 86.179691618159268, 43.621506189604787, 87.310052685639675, 43.174831251650943, 88.267213266968611, 42.545840012491453, 89.452269224810152, 41.862153882970262, 90.582630292279646, 41.151120308268212, 91.65829646939892, 40.385391843204502, 92.661036126020917, 39.574084302839339, 93.599965077228262, 38.726313502233069, 94.484199138081749, 37.83296362632538, 95.304622493509669, 36.894034675116281, 96.061235143508384, 35.909526648605777, 96.754037088088808, 35.034408402818627, 97.310101806768216, 33.894931520283343, 97.939093045930349, 32.737223007627449, 98.486041949541686, 31.570398679911278, 98.950948517620418, 30.38534272207454, 99.333812750148354, 29.172939319056979, 99.625518832079251, 27.95142010097911, 99.835182578470267, 26.720785067840978, 99.962803989310487, 25.462802589521971, 99.999267249560944],
     ],

138: 63,

139: [ [40.595055589590999, 67.339089555760438, 36.492938812463848, 67.339089555760438, 8.5985447279992684, 33.455604976701579, 36.492938812463848, -0.573732643340918, 40.595055589590999, -0.573732643340918, 23.01064833830597, 33.455604976701579, 40.595055589590999, 67.339089555760438],
     ],

140: 63,

141: 63,

142: 63,

143: 63,

144: 63,

145: [ [27.98788336121396, 78.666117684249912, 27.42270282747646, 78.638770239071164, 26.228531054579491, 78.429106492680148, 24.81557972023575, 78.018894814969826, 23.885766584086952, 77.699841287860181, 22.791868776853079, 77.508409171590756, 32.545790891355068, 76.997923528218962, 31.49747215942261, 77.727188733038929, 30.385342722068199, 78.246790191478794, 29.21851839435206, 78.556727903531282, 27.98788336121396, 78.666117684249912],
       [32.017073617858699, 100.00624074037114, 31.34250330339782, 99.750997918679786, 29.99336267447606, 99.213164830129244, 28.698916935915971, 98.647984296389041, 27.468281902777878, 98.055456317470089, 26.292341760001481, 97.444696708429547, 25.180212322647041, 96.797473839149461, 24.122777775654299, 96.132019339751423, 23.120038119023231, 95.448333210231795, 22.181109167814189, 94.728183820468985, 21.296875106966809, 93.989802800588222, 20.46733593648111, 93.224074335521436, 19.692491656357131, 92.43099842527954, 19.081732047318209, 91.729080665631045, 18.233961246711971, 90.689877748769504, 17.45000115152769, 89.632443201768183, 16.738967576825669, 88.556777024659823, 16.100860522605931, 87.471995032479754, 15.52656417380814, 86.368981410189008, 15.01607853043234, 85.238620342719514, 14.569403592478521, 84.108259275239107, 14.20477099006723, 82.950550762579951, 13.894833278017609, 81.774610619810119, 13.65782208645029, 80.589554661968577, 13.493737415365221, 79.386267074019997, 13.384347634641809, 78.164747855938913, 13.35700018946096, 76.934112822800671, 13.393463449702089, 75.74905686495913, 13.53020067560632, 74.454611126409873, 13.758096052113389, 73.205744463139126, 14.08626539428354, 72.011572690251342, 14.50559288705654, 70.862979992649343, 15.0343101605529, 69.769082185419393, 15.64506976959183, 68.720763453478867, 16.365219159354101, 67.718023796849593, 17.176526699719229, 66.769979030581453, 18.124571465988591, 65.83105007937047, 19.127311122619631, 64.983279278771079, 20.175629854552081, 64.272245704061788, 21.25129603166539, 63.697949355271703, 22.35430965395955, 63.242158602250129, 23.50290235155509, 62.913989260090602, 24.678842494331519, 62.722557143821177, 25.891245897349052, 62.658746438399248, 26.27411012988091, 62.667862253460044, 27.541208423260152, 62.777252034178673, 28.75361182627768, 63.023379040809232, 29.920436153993791, 63.406243273340806, 31.032565591348231, 63.934960546830553, 32.090000138340969, 64.600415046239505, 33.101855610032288, 65.402606771538558, 33.15655050039399, 65.448185846838896, 33.940510595578282, 66.323304092631588, 34.551270204617168, 67.316927934200066, 34.988829327510729, 68.447289001680474, 35.253187964258899, 69.705271480001102, 35.335230299801452, 71.090875369158312, 35.271419594379473, 72.166541546270309, 35.01617677269158, 73.388060764351394, 34.569501834737743, 74.518421831831802, 33.931394780517991, 75.557624748700619, 33.101855610032288, 76.505669514968758, 32.545790891355068, 76.997923528218962, 22.791868776853079, 77.508409171590756, 21.880287270824851, 77.727188733038929, 20.923126689495231, 78.593191163770825, 20.48556756660167, 79.331572183651588, 20.166514039491801, 80.498396511371539, 20.057124258768429, 81.98427436619022, 20.075355888888989, 82.740887016199849, 20.21209311479322, 84.044448569820815, 20.46733593648111, 85.284199418019853, 20.850200169012961, 86.460139560789685, 21.36980162744905, 87.572268998148502, 21.998792866608539, 88.611471915020957, 22.14464590757305, 88.821135661408334, 22.737173886491401, 89.568632496349892, 23.411744200952281, 90.334360961409402, 24.177472666016001, 91.118321056601417, 25.03435928168253, 91.90228115177888, 25.97328823289158, 92.704472877088847, 27.003375334703492, 93.524896232509491, 28.124620587118191, 94.345319587941049, 29.337023990135719, 95.19309038854044, 30.631469728695809, 96.040861189150746, 32.017073617858699, 96.906863619871729, 32.017073617858699, 100.00624074037114],
     ],

146: [ [16.706036885615081, 85.75639877012145, 17.750759386213129, 85.014095940739935, 18.868795746502279, 84.491734690440353, 20.041817501559731, 84.18015078676035, 21.278988883846889, 84.070179997230298, 21.78302166922316, 84.097672694610083, 22.974371889203379, 84.299285808760033, 24.385663688256901, 84.720840501981002, 25.357072329163859, 85.050752870589349, 26.475108689453009, 85.224873287348601, 16.706036885615081, 85.75639877012145],
       [23.368433885043, 100.00678024757144, 23.011028819048931, 99.997616015120002, 21.728036274454841, 99.896809458041389, 20.500029124629069, 99.649375181579671, 19.327007369571589, 99.26447741820084, 18.208971009282429, 98.732951935438905, 17.164248508684409, 98.073127198218572, 16.165347170393289, 97.266674741618772, 15.36805894625266, 96.405236890248489, 14.735726906417, 95.406335551961092, 14.28667951580905, 94.27913495921166, 14.02091677442885, 93.023635112000193, 13.929274449814979, 91.639836010330328, 13.99342407704469, 90.595113509731164, 14.240858353502119, 89.357942127440765, 14.68990574411006, 88.22157730222898, 15.331402016407109, 87.186019034088531, 16.165347170393289, 86.232938858109264, 16.706036885615081, 85.75639877012145, 26.475108689453009, 85.224873287348601, 27.336546540823321, 85.014095940739935, 28.344612111575831, 84.143493856910936, 28.711181410031291, 83.483669119690603, 29.031929546179811, 82.310647364640317, 29.141900335716461, 80.826041705888201, 29.123571870793679, 80.193709666058567, 29.004436848795649, 78.864895959159185, 28.757002572338219, 77.609396111951355, 28.39043327388277, 76.418045891969086, 27.886400488506499, 75.309173764140724, 27.26323268113223, 74.264451263541559, 27.134933426672831, 74.090330846771394, 26.548422549144082, 73.329699552479724, 25.870269347001511, 72.569068258180778, 25.10047382024505, 71.790108498971676, 24.239035968874699, 71.001984507278394, 23.285955792890519, 70.204696283140947, 22.250397524753851, 69.398243826541147, 21.114032699541951, 68.573462905020278, 19.895189782177539, 67.73951775102978, 18.575540307737889, 66.905572597050195, 17.173412741145789, 66.044134745679912, 17.173412741145789, 62.662532967431616, 17.81490901344284, 62.900803011420066, 19.162051185266652, 63.459821191569063, 20.463372194783521, 64.028003604169498, 21.700543577070668, 64.632842946630262, 22.873565332128148, 65.256010753990267, 24.000765924878671, 65.906671258759161, 25.063816890399501, 66.57566022843821, 26.06271822869061, 67.272141895500681, 27.00663417221341, 67.996116259950213, 27.895564720967879, 68.738419089320814, 28.729509874954061, 69.508214616078476, 29.499305401710529, 70.30550284021956, 30.094980511700641, 70.965327577439894, 30.956418363070949, 72.010050078039058, 31.744542354750202, 73.073101043559291, 32.468516719199727, 74.145316241538239, 33.119177223958161, 75.245024136911525, 33.705688101486892, 76.344732032270258, 34.228049351785899, 77.47193262501969, 34.677096742393843, 78.617461682701105, 35.05283027331069, 79.772154972830322, 35.364414176997833, 80.945176727891521, 35.602684220993872, 82.136526947870152, 35.776804637760222, 83.337041400311136, 35.877611194835481, 84.565048550139181, 35.914268124681001, 85.802219932418666, 35.877611194835481, 86.938584757641365, 35.74931194037606, 88.239905767160963, 35.520206128841409, 89.495405614361516, 35.190293760231498, 90.695920066798863, 34.768739067007722, 91.850613356938993, 34.246377816708673, 92.959485484770994, 33.6232100093344, 94.013372217828874, 32.908399877346262, 95.012273556119908, 32.09278318828288, 95.965353732099175, 31.20385263952841, 96.826791583469458, 30.177458603853129, 97.669900969918672, 29.123571870793679, 98.384711101898574, 28.033028207888691, 98.96205774696864, 26.914991847599541, 99.420269370039023, 25.760298557464871, 99.741017506188655, 24.578112569946001, 99.942630620338605, 23.368433885043, 100.00678024757144],
     ],

147: [ [54.004419543259473, 78.877569097840023, 53.329849228798587, 78.850221652661276, 52.080982565539919, 78.667905351449008, 50.832115902281259, 78.303272749039024, 49.492091088419762, 77.883945256271545, 48.452888171547592, 77.719860585191782, 58.617021963762276, 77.282301462291798, 57.568703231829829, 77.984219221929379, 56.447457979415098, 78.476473235190497, 55.262402021578417, 78.777295132178551, 54.004419543259473, 78.877569097840023],
       [19.409901389488368, 78.877569097840023, 19.063500417197641, 78.868453282779228, 17.851097014180109, 78.71348442676026, 16.529303830439201, 78.376199269529025, 16.465493125017218, 78.348851824339363, 15.079889235854321, 77.938640146629041, 14.004223058741021, 77.792787105670868, 4.8519447382176386, 77.36434379783168, 4.8519447382176386, 77.336996352649294, 4.8975238135190571, 76.00608735384958, 5.0433768544835678, 74.720757430350204, 5.2895038611111991, 73.481006582151167, 5.6176732032813561, 72.286834809259744, 6.0552323261748882, 71.147357926718541, 6.5839495996712571, 70.053460119488591, 7.2038250237704631, 69.005141387558979, 7.9239744135327612, 68.002401730918791, 8.7443977689581516, 67.054356964661565, 9.7197899804083647, 66.078964753200125, 10.74076126715997, 65.231193952600734, 11.78907999909242, 64.511044562841562, 12.864746176205729, 63.918516583911696, 13.96775979849988, 63.462725830901036, 15.10723668103517, 63.134556488741509, 16.264945193690998, 62.934008557411289, 17.45911696658797, 62.87019785198936, 18.543898958761559, 62.924892742350494, 19.81099725214079, 63.116324858609005, 20.996053209977472, 63.462725830901036, 22.108182647331908, 63.954979844158515, 23.138269749143799, 64.602202713438601, 24.095430330473452, 65.395278623680497, 24.441831302764172, 65.732563780911732, 25.280486288310129, 66.70795599235862, 25.92770915759019, 67.756274724299146, 26.392615725664569, 68.868404161650687, 26.666090177473048, 70.053460119488591, 26.75724832807586, 71.311442597809219, 26.702553437714158, 72.314182254438492, 26.456426431086559, 73.535701472519577, 26.027983123253279, 74.675178355049866, 25.408107699154101, 75.741728717108344, 24.59680015878897, 76.717120928551594, 23.986040549750069, 77.254954017109412, 22.94683763287787, 77.965987591811427, 21.834708195523461, 78.467357420129701, 20.658768052747039, 78.777295132178551, 19.409901389488368, 78.877569097840023],
       [57.896872573999978, 99.78924884612934, 57.732787902914907, 99.734553955768206, 56.410994719173971, 99.315226462989813, 55.134780610734452, 98.850319894918357, 53.913261392656644, 98.348950066600082, 52.728205434819948, 97.802001162988745, 51.588728552284657, 97.209473184069793, 50.503946560111068, 96.580481944911298, 49.464743643238897, 95.905911630448827, 48.471119801668152, 95.194878055750451, 47.52307503539879, 94.438265405740822, 46.620609344430846, 93.636073680441768, 45.763722728764321, 92.797418694899534, 44.961531003459491, 91.913184634038771, 44.204918353456073, 90.992487312960293, 43.530348038995179, 90.071789991870901, 42.810198649232888, 88.987007999690832, 42.153859964892547, 87.893110192460881, 41.570447801034497, 86.771864940048545, 41.050846342598412, 85.63238805751098, 40.604171404644582, 84.474679544848186, 40.230422987173, 83.298739402078354, 39.920485275123411, 82.104567629179655, 39.683474083556071, 80.89216422617028, 39.510273597410702, 79.6615291930284, 39.40999963174761, 78.412662529761292, 39.373536371506482, 77.145564236390783, 39.419115446807901, 75.87846594300936, 39.55585267271212, 74.584020204449189, 39.783748049219177, 73.335153541189356, 40.111917391389341, 72.140981768290658, 40.540360699222589, 70.992389070699573, 41.059962157658703, 69.898491263458709, 41.670721766697589, 68.850172531529097, 42.381755341399611, 67.856548689960619, 43.193062881764739, 66.908503923688841, 44.04083368237098, 66.060733123078535, 45.0526891540623, 65.19473069236119, 46.101007885994761, 64.465465487541223, 47.167558248047783, 63.863821693561476, 48.279687685402223, 63.398915125479107, 49.410048752877231, 63.070745783308666, 50.576873080593337, 62.87019785198936, 51.771044853490309, 62.797271331510274, 53.074606407110679, 62.87019785198936, 54.314357255309062, 63.088977413430257, 55.490297398085453, 63.444494200779445, 56.6024268354399, 63.954979844158515, 57.64162975231207, 64.602202713438601, 58.617021963762276, 65.395278623680497, 59.127507607138092, 65.914880082120362, 59.929699332442908, 66.908503923688841, 60.549574756542107, 67.975054285740043, 60.996249694495923, 69.096299538148742, 61.269724146304412, 70.281355496001197, 61.35176648184693, 71.52110634418932, 61.30618740654554, 72.405340405039169, 61.07829203003849, 73.626859623120254, 60.649848722205199, 74.766336505661457, 60.020857483045738, 75.82377105264095, 59.191318312560071, 76.790047449030681, 58.617021963762276, 77.282301462291798, 48.452888171547592, 77.719860585191782, 47.805665302267563, 77.87482944121075, 46.793809830576208, 78.731716056878213, 46.502103748647187, 79.196622624949669, 46.128355331175612, 80.326983692430076, 46.000733920331662, 81.758166656891262, 46.018965550452229, 82.487431861711229, 46.128355331175612, 83.800109230389353, 46.347134892622392, 85.058091708709981, 46.675304234792549, 86.261379296669475, 47.112863357686066, 87.409971994260559, 47.659812261303017, 88.503869801501423, 48.307035130583067, 89.54307271837024, 48.63520447275323, 89.98063184125931, 49.227732451671578, 90.6916654159686, 49.9387660263736, 91.420930620788567, 50.750073566738713, 92.168427455730125, 51.679886702887501, 92.934155920800549, 52.700857989639097, 93.71811601598165, 53.840334872174402, 94.520307741280703, 55.089201535433062, 95.349846911769419, 56.438342164354822, 96.188501897311653, 57.896872573999978, 97.045388512979116, 57.896872573999978, 99.78924884612934],
       [23.51201816661538, 99.998912592509441, 23.056227413601281, 99.843943736490473, 21.734434229860341, 99.379037168419018, 20.46733593648111, 98.868551525039948, 19.23670090334301, 98.321602621421334, 18.060760760566609, 97.73819045755954, 16.939515508151882, 97.118315033469116, 15.86384933103858, 96.46197634912096, 14.833762229226689, 95.76917440455145, 13.849254202716221, 95.039909199720569, 12.91944106656743, 94.274180734661059, 12.03520700572005, 93.471989009351091, 11.205667835234349, 92.633334023801581, 10.41259192498981, 91.758215778019803, 9.6742109051069463, 90.846634271991206, 9.2001885219722794, 90.208527217768278, 8.4435758719688465, 89.114629410538328, 7.7598897424476831, 88.002499973179511, 7.14913013340876, 86.872138905710017, 6.6112970448521082, 85.732662023168814, 6.1463904767777251, 84.584069325581368, 5.7452946141252994, 83.408129182800621, 5.4262410870154261, 82.232189040019875, 5.1709982653275111, 81.038017267128453, 4.9886819641218656, 79.825613864111801, 4.8884079984587743, 78.604094646030717, 4.8519447382176386, 77.36434379783168, 14.004223058741021, 77.792787105670868, 13.338768559340391, 77.938640146629041, 12.41807123825191, 78.804642577360937, 12.053438635840619, 79.497444521941361, 11.78907999909242, 80.69161629484006, 11.69792184848961, 82.268652300270332, 11.725269293670459, 83.180233806291653, 11.880238149695259, 84.410868839429895, 12.144596786443429, 85.605040612328594, 12.53657683403557, 86.78098075510934, 13.047062477411369, 87.920457637639629, 13.685169531631139, 89.041702890059241, 14.43266636657426, 90.126484882228397, 14.46001381175512, 90.153832327410782, 15.116352496095431, 90.946908237649041, 15.854733515978291, 91.739984147898213, 16.684272686463999, 92.514828428018518, 17.604970007552481, 93.289672708149737, 18.607709664183542, 94.055401173209248, 19.701607471417422, 94.812013823211601, 20.886663429254099, 95.568626473221229, 22.15376172263333, 96.307007493098354, 23.51201816661538, 97.045388512979116, 23.51201816661538, 99.998912592509441],
     ],

148: [ [61.35176648185432, 85.441820245181589, 52.199488161330663, 85.077187642771605, 52.792016140249018, 84.958682046988542, 53.785639981819827, 84.138258691560623, 54.159388399291402, 83.372530226501112, 54.4237470360396, 82.169242638541618, 54.505789371582161, 80.610438263229298, 54.478441926401302, 79.698856757200701, 54.32347307037648, 78.468221724069736, 54.059114433628309, 77.264934136110242, 53.667134386036139, 76.098109808390291, 53.15664874266033, 74.949517110788292, 52.518541688440543, 73.837387673440389, 51.771044853497379, 72.752605681271234, 51.743697408316542, 72.716142421031691, 51.078242908915911, 71.904834880660928, 50.32163025891245, 71.111758970419032, 49.482975273366463, 70.327798875230656, 48.562277952277917, 69.552954595099436, 47.55953829564686, 68.787226130039926, 46.46564048841293, 68.030613480041211, 45.289700345636497, 67.283116645099653, 44.031717867317489, 66.553851440279686, 42.691693053455957, 65.824586235459719, 42.691693053455957, 62.798135635439394, 43.247757772133212, 62.989567751708819, 44.560435140813887, 63.46359013484107, 45.82753343419315, 63.97407577822014, 47.039936837210739, 64.521024681831477, 48.20676116492691, 65.104436845689634, 49.328006417341669, 65.733428084851766, 50.403672594455003, 66.389766769189009, 51.433759696266918, 67.082568713780347, 52.409151907717153, 67.8118339185894, 53.338965043865983, 68.58667819872062, 54.223199104713387, 69.388869924019673, 55.061854090259367, 70.236640724629979, 55.85493000050397, 71.111758970419032, 56.602426835447119, 72.032456291508424, 57.012638513159828, 72.579405195119762, 57.760135348102999, 73.673303002360626, 58.443821477624198, 74.776316624651372, 59.05458108666312, 75.90667769213178, 59.592414175219801, 77.037038759601273, 60.066436558354503, 78.194747272260429, 60.458416605946638, 79.361571599969466, 60.777470133056532, 80.546627557811007, 61.032712954744419, 81.749915145770501, 61.215029255950093, 82.962318548779876, 61.315303221613192, 84.192953581921756, 61.35176648185432, 85.441820245181589],
       [26.830174848564351, 85.514746765671589, 17.677896528040691, 85.077187642771605, 18.407161732863301, 84.913102971680928, 19.409901389494362, 84.065332171081536, 19.66514421118228, 83.618657233120757, 20.011545183473029, 82.497411980708421, 20.130050779256688, 81.038881571068487, 20.120934964196412, 80.428121962031582, 20.011545183473029, 79.115444593349821, 19.801881437086511, 77.857462115029193, 19.491943725036919, 76.645058712008904, 19.063500417203642, 75.487350199349748, 18.534783143707241, 74.384336577059003, 17.896676089487471, 73.326902030068595, 17.56850674731729, 72.871111277050659, 16.966862953338651, 72.150961887291487, 16.255829378636601, 71.42169668247152, 15.44452183827147, 70.665084032458253, 14.523824517182931, 69.899355567398743, 13.49373741537101, 69.115395472210366, 12.35426053283569, 68.313203746911313, 11.11450968463725, 67.501896206551464, 9.7653690557154391, 66.672357036059111, 8.306838646070247, 65.824586235459719, 8.306838646070247, 62.798135635439394, 8.4982707623361762, 62.861946340861323, 9.8109481310168576, 63.281273833628802, 11.078046424396121, 63.746180401711172, 12.29044982741371, 64.256666045079328, 13.466389970190161, 64.803614948701579, 14.5967510376652, 65.396142927620531, 15.681533029838819, 66.034249981839821, 16.72073594671102, 66.708820296298654, 17.714359788281818, 67.428969686061464, 18.662404554551209, 68.19469815112825, 19.564870245519181, 68.996889876430942, 20.421756861185742, 69.844660677041247, 21.23306440155088, 70.738010552948253, 21.998792866614622, 71.667823689098441, 22.67336318107553, 72.588521010180557, 23.402628385898112, 73.664187187299831, 24.049851255178201, 74.767200809590577, 24.633263419036268, 75.888446062010189, 25.152864877472378, 77.027922944540478, 25.59953981542623, 78.185631457199634, 25.973288232897801, 79.361571599969466, 26.283225944947421, 80.555743372871802, 26.520237136514741, 81.768146775888454, 26.693437622660131, 82.998781809030334, 26.79371158832322, 84.247648472279252, 26.830174848564351, 85.514746765671589],
       [14.359739846097851, 99.999776896449475, 13.19291551838168, 99.945082006088342, 11.944048855122981, 99.73541825970824, 10.76810871234653, 99.379901472351776, 9.6650950900523451, 98.869415828979982, 8.6258921731801195, 98.213077144639101, 7.65961577679019, 97.410885419329134, 7.1491301334143591, 96.909515591021773, 6.3195909629286566, 95.906775934388861, 5.6814839087088549, 94.858457202448335, 5.2165773406344718, 93.746327765100432, 4.9431028888259902, 92.579503437380481, 4.8519447382231533, 91.348868404238601, 4.8975238135245709, 90.473750158460462, 5.1254191900316348, 89.243115125318582, 5.5538624978649116, 88.103638242788293, 6.1828537370244021, 87.055319510851405, 7.0123929075101321, 86.089043114461674, 7.6140367014887707, 85.542094210850337, 8.6350079882404032, 84.831060636141046, 9.7471374255948717, 84.329690807830048, 10.93219338343161, 84.028868910838355, 12.199291676810869, 83.928594945169607, 12.873861991271781, 83.946826575291198, 14.1227286545305, 84.138258691560623, 15.3715953177892, 84.502891293970606, 16.656925241289031, 84.913102971680928, 17.677896528040691, 85.077187642771605, 26.830174848564351, 85.514746765671589, 26.830174848564351, 85.57855747108988, 26.784595773262939, 86.936813915068342, 26.638742732298429, 88.240375468689308, 26.401731540731081, 89.498357947009936, 26.064446383500641, 90.692529719908634, 25.64511889072762, 91.841122417499719, 25.125517432291531, 92.935020224729669, 24.51475782325258, 93.9742231416094, 23.812840063610849, 94.958731168120721, 23.01064833830597, 95.888544304270908, 22.108182647338001, 96.781894180170639, 21.08721136058637, 97.63878079584174, 20.038892628653851, 98.358930185600911, 18.954110636480241, 98.951458164519863, 17.851097014186049, 99.407248917530524, 16.711620131650729, 99.73541825970824, 15.553911618994841, 99.935966191031184, 14.359739846097851, 99.999776896449475],
       [48.671667733001328, 99.999776896449475, 47.668928076370229, 99.954197821149137, 46.410945598051249, 99.762765704890626, 45.225889640214511, 99.42548054765939, 44.11376020286005, 98.924110719341115, 43.074557285987837, 98.27688785006103, 42.108280889597893, 97.474696124751063, 41.725416657066027, 97.091831892219489, 40.904993301640587, 96.09820805065101, 40.266886247420807, 95.040773503660603, 39.811095494406693, 93.928644066309062, 39.537621042598211, 92.743588108471158, 39.446462891995388, 91.494721445211326, 39.501157782357097, 90.528445048821595, 39.7472847889847, 89.325157460858463, 40.193959726938537, 88.19479639338897, 40.841182596218623, 87.137361846398562, 41.679837581764609, 86.161969634951674, 42.263249745622687, 85.615020731329423, 43.284221032374347, 84.876639711448661, 44.378118839608248, 84.347922437951638, 45.554058982384703, 84.028868910838355, 46.793809830583108, 83.928594945169607, 47.140210802873831, 83.937710760241316, 48.325266760710583, 84.110911246378237, 49.683523204692683, 84.502891293970606, 49.738218095054371, 84.521122924088559, 51.123821984217329, 84.94045041687059, 52.199488161330663, 85.077187642771605, 61.35176648185432, 85.441820245181589, 61.35176648185432, 85.52386258072147, 61.297071591492617, 86.854771579521184, 61.151218550528107, 88.130985687970679, 60.914207358960759, 89.370736536158802, 60.576922201730298, 90.555792494000343, 60.139363078836737, 91.704385191598703, 59.610645805340368, 92.798282998828654, 58.990770381241163, 93.855717545819061, 58.270620991478843, 94.858457202448335, 57.459313451113672, 95.824733598841703, 57.413734375812282, 95.870312674149318, 56.429226349301757, 96.836589070539048, 55.417370877610409, 97.675244056081283, 54.369052145677898, 98.386277630790573, 53.293385968564557, 98.969689794641454, 52.181256531210103, 99.42548054765939, 51.041779648674783, 99.744534074761759, 49.874955320958598, 99.935966191031184, 48.671667733001328, 99.999776896449475],
     ],

149: [ [26.182951979284301, 66.910232531561633, 27.477397717844411, 66.873769271318452, 28.744496011223699, 66.746147860470955, 29.975131044361831, 66.545599929151649, 31.17841863231914, 66.263009662281547, 32.345242960035279, 65.898377059871564, 33.475604027510322, 65.451702121910785, 34.578617649804528, 64.922984848421038, 35.645168011857578, 64.321341054441291, 36.6752551136695, 63.628539109860867, 37.668878955240309, 62.862810644790443, 38.635155351630232, 62.005924029130256, 39.008903769101828, 61.650407241781068, 39.893137829949239, 60.693246660448494, 40.695329555254091, 59.708738633940811, 41.41547894501641, 58.687767347179033, 42.053585999236191, 57.639448615249421, 42.618766532973723, 56.554666623080266, 43.092788916108411, 55.433421370660653, 43.493884778760837, 54.275712858001498, 43.803822490810433, 53.09065690017087, 44.04083368237778, 51.8691376821007, 44.195802538402603, 50.620271018829953, 44.268729058884837, 49.334941095341492, 44.277844873945128, 48.815339636901626, 44.232265798643709, 47.51177808328066, 44.11376020286005, 46.244679789899237, 43.904096456473553, 45.0049289417002, 43.621506189604787, 43.810757168801501, 43.256873587193489, 42.643932841088827, 42.801082834179368, 41.513571773608419, 42.272365560682971, 40.419673966378468, 41.661605951644049, 39.362239419391699, 40.968804007062573, 38.332152317569125, 40.193959726938537, 37.338528476000647, 39.337073111271991, 36.381367894671712, 39.008903769101828, 36.053198552501271, 38.060859002832451, 35.159848676590627, 37.076350976321919, 34.348541136230779, 36.064495504630571, 33.619275931410812, 35.016176772698088, 32.972053062130726, 33.931394780524442, 32.406872528390522, 32.819265343169981, 31.9237343301902, 31.670672645574371, 31.522638467540673, 30.485616687737661, 31.203584940431028, 29.273213284720072, 30.95745793380047, 28.02434662146138, 30.802489077781502, 26.748132513021801, 30.729562557291501, 26.182951979284301, 30.72044674224162, 24.8793904256639, 30.756910002481163, 23.621407947344888, 30.884531413321383, 22.39077291420676, 31.094195159708761, 21.196601141309738, 31.376785426578863, 20.029776813593571, 31.750533844049642, 18.899415746118532, 32.197208781999507, 17.814633753944921, 32.735041870560963, 16.757199206952151, 33.354917294658662, 15.727112105140231, 34.056835054299881, 14.742604078629711, 34.831679334420187, 13.78544349730004, 35.697681765148445, 13.429926709949029, 36.053198552501271, 12.527461018981059, 36.992127503708616, 11.71615347861592, 37.976635530219937, 10.98688827379331, 38.979375186860125, 10.33966540451325, 40.027693918789737, 9.7744848707757228, 41.103360095901735, 9.2822308575204602, 42.224605348310433, 8.8811349948680345, 43.373198045908794, 8.562081467758162, 44.54913818868954, 8.3250702761908144, 45.770657406770624, 8.1701014201659916, 47.019524070019543, 8.0971748996837505, 48.304853993518918, 8.0880590846234668, 48.815339636901626, 8.1336381599248853, 50.118901190518955, 8.2521437557085449, 51.376883668839582, 8.4526916870347577, 52.616634517038619, 8.7443977689638075, 53.810806289940956, 9.1090303713750984, 54.977630617649993, 9.5465894942686589, 56.107991685119487, 10.075306767765049, 57.211005307421146, 10.68606637680398, 58.277555669468711, 11.36975250632517, 59.307642771280371, 12.144596786449201, 60.310382427920558, 12.992367587055471, 61.276658824299375, 13.35700018946676, 61.650407241781068, 14.29592914067586, 62.534641302630916, 15.271321352126099, 63.327717212869175, 16.283176823817449, 64.056982417689142, 17.331495555749939, 64.695089471908432, 18.407161732863301, 65.251154190591478, 19.52840698527805, 65.725176573720091, 20.67699968287366, 66.126272436380532, 21.87117145577065, 66.445325963479263, 23.092690673848519, 66.673221339988231, 24.350673152167509, 66.828190196010837, 25.64511889072762, 66.901116716500837, 26.182951979284301, 66.910232531561633, 26.182951979284301, 66.910232531561633, 26.182951979284301, 66.910232531561633],
     ],

150: [ [73.749274963838573, 32.663038713348215, -2.577444535907119, 32.663038713348215, -2.577444535907119, 37.92286400312878, 73.749274963838573, 37.92286400312878, 73.749274963838573, 32.663038713348215, 73.749274963838573, 32.663038713348215],
     ],

151: [ [147.56002950694631, 32.663903017299162, -2.714181761811346, 32.663903017299162, -2.714181761811346, 37.996654827558814, 147.56002950694631, 37.996654827558814, 147.56002950694631, 32.663903017299162, 147.56002950694631, 32.663903017299162],
     ],

152: 63,

153: [ [70.840661257369021, 87.335013842719491, 70.872182535505914, 85.223088207549154, 70.872182535505914, 51.631912806329638, 70.861675442793626, 50.539175164249173, 70.798632886519812, 48.679419754171249, 70.672547773972212, 47.166398403598578, 70.472913012438539, 45.979096927108912, 70.22074278734334, 45.138529510131775, 70.126178952932662, 44.938894748600433, 69.317132814085596, 43.751593272110767, 68.203380986581863, 42.911025855119078, 67.446870311296323, 42.627334351880563, 66.228047556669594, 42.385671219508367, 64.651983649824672, 42.23857192153082, 62.729185683473901, 42.186036457969749, 62.729185683473901, 39.590784558029554, 84.783573286590297, 39.590784558029554, 84.783573286590297, 42.186036457969749, 82.188321386652333, 42.186036457969749, 80.549214923533626, 42.270093199669645, 79.141264500085526, 42.532770517478639, 78.08004813614329, 42.974068411389453, 77.890920467321905, 43.100153523941117, 76.840211196091957, 44.035284775338368, 76.136235984367886, 45.285628808098409, 76.010150871820315, 45.590334496759169, 75.778994832149721, 46.567494119000912, 75.61088134875294, 47.901894893460849, 75.516317514342234, 49.593536820138979, 75.484796236205341, 51.631912806329638, 75.484796236205341, 86.378868405899993, 70.840661257369021, 87.335013842719491],
       [134.30350123965721, 88.469779855651723, 122.1152736933899, 87.03030815405873, 122.1152736933899, 51.558363157339045, 122.1152736933899, 50.885909223761701, 122.0522311371161, 48.994632535541314, 121.9261460245685, 47.439582814120513, 121.72651126303489, 46.231267152208602, 121.46383394522741, 45.359178457081725, 121.3062275545429, 45.043965675711661, 120.44464595213429, 43.898692570070125, 119.2993728464937, 43.047618060380046, 119.2573444756445, 43.026603874950524, 118.3327203169622, 42.690376908158214, 117.0613620987739, 42.427699590349221, 115.4642840065044, 42.270093199669645, 113.5414860401537, 42.186036457969749, 113.5414860401537, 39.590784558029554, 142.22584914473089, 39.590784558029554, 142.22584914473089, 42.186036457969749, 140.40812210550311, 42.33313575594002, 138.71648017882291, 42.595813073749014, 137.350558126224, 42.963561318680149, 136.3103559477064, 43.425873398020485, 135.59587364327001, 43.993256404479325, 135.35421051088721, 44.308469185860304, 134.94443389510749, 45.159543695550383, 134.62922111373851, 46.325830986610526, 134.4085721667802, 47.786316873629403, 134.27197996152029, 49.562015542000154, 134.21944449795879, 51.631912806329638, 134.21944449795879, 85.370187505519425, 134.22995159067111, 86.652052816418291, 134.30350123965721, 88.469779855651723],
       [35.915085081685902, 93.450141801280552, 23.800407184404719, 93.450141801280552, 23.800407184404719, 51.631912806329638, 23.800407184404719, 50.959458872741379, 23.72685753541862, 48.984125442828372, 23.569251144734121, 47.324004794281791, 23.327588012351239, 45.968589834399609, 23.00186813826997, 44.928387655880215, 22.58158442977799, 44.203398258730886, 22.23485037027211, 43.846157106509054, 21.320733304302049, 43.26826700734091, 20.070389271538431, 42.795447835280356, 18.504832457405819, 42.438206683069438, 16.603048676479631, 42.186036457969749, 16.603048676479631, 39.590784558029554, 43.553741483527538, 39.590784558029554, 43.553741483527538, 42.186036457969749, 42.271876172627003, 42.280600292378949, 40.590741338659107, 42.522263424758421, 39.203805100635613, 42.900518762409774, 38.121574551268772, 43.415366305311181, 37.354556783270908, 44.056298960760614, 37.091879465463421, 44.403033020269504, 36.671595756971442, 45.275121715378191, 36.335368790177881, 46.441409006449248, 36.104212750507287, 47.901894893460849, 35.957113452535083, 49.656579376420268, 35.915085081685902, 51.70546245532023, 35.915085081685902, 93.450141801280552],
       [56.162252738286782, 97.76855690604134, 3.700338825776015, 97.76855690604134, 2.1873174752049058, 83.279276055771334, 4.635470077170651, 83.279276055771334, 4.7510480970059632, 83.857166154950392, 5.171331805497914, 85.496272618071089, 5.6756722556882826, 86.967265597788355, 6.2640694475770706, 88.280652186829684, 6.9575375665888251, 89.42592529247122, 7.7350624272989696, 90.403084914709325, 8.5966440297075337, 91.212131053558551, 8.6596865859813192, 91.254159424410318, 9.5632965592390633, 91.842556616291404, 10.635020015893589, 92.325882881061261, 11.853842770520311, 92.735659496840526, 13.23027191583153, 93.040365185501287, 14.774814544539559, 93.271521225171455, 16.47696356393206, 93.397606337719481, 18.326211881296729, 93.450141801280552, 23.800407184404719, 93.450141801280552, 35.915085081685902, 93.450141801280552, 41.315730735807762, 93.450141801280552, 56.162252738286782, 97.76855690604134],
       [56.162252738286782, 97.76855690604134, 41.315730735807762, 93.450141801280552, 42.198326523640922, 93.439634708560334, 43.974025192019532, 93.355577966871351, 45.602624562425909, 93.176957390758616, 47.073617542147844, 92.914280072949623, 48.418525409322143, 92.567546013451647, 49.605826885811972, 92.126248119529919, 50.65653615704192, 91.611400576628512, 51.549639037587347, 90.991482106601325, 51.70724542827184, 90.865396994049661, 52.610855401529591, 89.951279928078293, 53.388380262239757, 88.900570656860509, 54.050327103114633, 87.702762087650626, 54.586188831441888, 86.36836131319069, 55.006472539933867, 84.897368333469785, 55.300671135878247, 83.279276055771334, 57.748823737843992, 83.279276055771334, 56.162252738286782, 97.76855690604134],
       [83.333594492292974, 97.76855690604134, 62.729185683473901, 97.76855690604134, 62.729185683473901, 95.099755357110553, 64.368292146592609, 95.068234078971727, 65.996891516999, 94.942148966420064, 67.278756827899514, 94.710992926749896, 68.203380986581863, 94.385273052681441, 68.424029933540169, 94.24868084740956, 69.527274668331586, 93.334563781438192, 70.294292436329442, 92.147262304948526, 70.472913012438539, 91.558865113060165, 70.641026495835305, 90.497648749118525, 70.767111608382919, 89.089698325671634, 70.840661257369021, 87.335013842719491, 75.484796236205341, 86.378868405899993, 97.686283137293927, 39.590784558029554, 103.0133791424297, 56.52821801025857, 83.333594492292974, 97.76855690604134],
       [142.22584914473089, 97.76855690604134, 122.1152736933899, 97.76855690604134, 103.0133791424297, 56.52821801025857, 97.686283137293927, 39.590784558029554, 99.987336441287482, 39.590784558029554, 122.1152736933899, 87.03030815405873, 134.30350123965721, 88.469779855651723, 134.42958635220481, 89.972294113511452, 134.61871402102619, 91.149088497291814, 134.87088424612139, 92.000163006978255, 134.98646226595659, 92.27334741750019, 135.7850013120914, 93.471155986699159, 136.8882460468829, 94.311723403690848, 137.51867160962081, 94.574400721488928, 138.69546599339839, 94.847585132021777, 140.27152990024331, 95.015698615410656, 142.22584914473089, 95.099755357110553, 142.22584914473089, 97.76855690604134],
     ],

154: 63,

155: [ [12.490997758739921, 67.343979781671806, 8.306838646070247, 67.343979781671806, 25.81831937687301, 33.314642161629308, 8.306838646070247, -0.57795823250125977, 12.490997758739921, -0.57795823250125977, 40.886761671520013, 33.314642161629308, 12.490997758739921, 67.343979781671806],
     ],

156: 63,

157: 63,

158: 63,

159: 63,

160: 63,

161: [ [4.6331651767763731, 90.99558987166165, 3.5119199243616199, 90.913547536121769, 2.3086323364043428, 90.649188899369619, 1.187387083989591, 90.184282331290888, 0.13906835205708029, 89.527943646950007, -0.8454396744534165, 88.68928866141141, -1.638515584698012, 87.76859134031838, -2.303970084098637, 86.72938842343865, -2.7779924672333318, 85.608143171029951, -3.0605827341020979, 84.404855583070457, -3.151740884704906, 83.137757289689034, -3.0696985491623532, 81.970932961979997, -2.8053399124141829, 80.767645374020503, -2.3404333443397709, 79.646400121611805, -1.6932104750597139, 78.60719720473935, -0.8454396744534165, 77.650036623399501, 0.020562756273420801, 76.893423973400786, 1.068881488205903, 76.218853658938315, 2.181010925560372, 75.735715460741631, 3.3751826984573929, 75.444009378810733, 4.6331651767763731, 75.343735413149261, 5.8364527647336777, 75.434893563760852, 7.0397403526909548, 75.708368015559245, 8.1609856051057061, 76.164158768580819, 9.209304337038219, 76.811381637860904, 10.18469654848843, 77.650036623399501, 10.950425013552181, 78.506923239070602, 11.62499532801308, 79.537010340878624, 12.108133526208061, 80.658255593298236, 12.39072379307683, 81.852427366189659, 12.490997758739921, 83.137757289689034, 12.39983960813708, 84.42308721318841, 12.11724934126835, 85.626374801151542, 11.66145858825422, 86.74762005356024, 11.01423571897416, 87.795938785500766, 10.18469654848843, 88.753099366829701, 9.2913466725807439, 89.509712016828416, 8.2430279406482612, 90.156934886108502, 7.121782688233508, 90.621841454179958, 5.9184951002762034, 90.895315906000178, 4.6331651767763731, 90.99558987166165],
       [41.388131499835559, 90.99558987166165, 40.184843911878261, 90.904431721050059, 38.981556323920991, 90.630957269251667, 37.860311071506231, 90.175166516230092, 36.811992339573749, 89.527943646950007, 35.836600128123507, 88.68928866141141, 35.043524217878911, 87.76859134031838, 34.38718553353857, 86.72938842343865, 33.913163150403882, 85.608143171029951, 33.630572883535137, 84.404855583070457, 33.530298917872017, 83.137757289689034, 33.61234125341457, 81.970932961979997, 33.885815705223052, 80.767645374020503, 34.34160645823718, 79.646400121611805, 34.997945142577521, 78.60719720473935, 35.836600128123507, 77.650036623399501, 36.757297449212047, 76.856960713161243, 37.796500366084253, 76.200622028820362, 38.917745618498998, 75.726599645680835, 40.121033206456303, 75.444009378810733, 41.388131499835559, 75.343735413149261, 42.518492567310602, 75.425777748689143, 43.712664340207617, 75.690136385441292, 44.833909592622369, 76.155042953520024, 45.891344139615143, 76.811381637860904, 46.866736351065377, 77.650036623399501, 47.632464816129101, 78.525154869188555, 48.307035130590009, 79.564357786061009, 48.790173328784988, 80.685603038480622, 49.081879410714031, 81.870658996311249, 49.173037561316839, 83.137757289689034, 49.100111040834598, 84.304581617408985, 48.835752404086399, 85.516985020429274, 48.389077466132562, 86.647346087898768, 47.760086226973073, 87.704780634900089, 46.939662871547618, 88.68928866141141, 46.02808136551937, 89.482364571649669, 44.979762633586887, 90.138703255990549, 43.858517381172128, 90.612725639119162, 42.664345608275113, 90.895315906000178, 41.388131499835559, 90.99558987166165],
       [38.580460461268558, 100.22079471265897, 22.50927850999042, 100.22079471265897, 14.94315200995592, 75.343735413149261, 17.386190446111641, 75.343735413149261, 38.580460461268558, 100.22079471265897],
     ],

162: [ [54.150272584231118, 100.00293851449169, 51.62519181253284, 100.00293851449169, 17.24945322020741, 19.546754792430875, 16.675156871409602, 18.206729978570365, 15.991470741888399, 16.666157233379636, 15.3169004274275, 15.216742638800497, 14.65144592802687, 13.858486194818397, 13.99510724368653, 12.582272086379817, 13.34788437440648, 11.388100313481118, 12.709777320186699, 10.285086691190372, 12.0899018960875, 9.264115404439508, 11.470026471988289, 8.3343022682893206, 10.86838267800962, 7.4956472827398102, 10.26673888403098, 6.7390346327410953, 9.6833267201729143, 6.064464318278624, 9.0999145563148147, 5.4810521544204676, 8.6623554334212542, 5.116419552010484, 7.8966269683575367, 4.6423971688709571, 6.9303505719675789, 4.1866064158602967, 5.7817578743719764, 3.7672789230782655, 4.4326172454501602, 3.375298875500448, 2.9011603153226981, 3.0106662730795506, 1.1691554538690241, 2.6733811158483149, 1.1691554538690241, 0.0024473031917295884, 31.95326291244314, 0.0024473031917295884, 31.95326291244314, 2.6733811158483149, 30.95963907087236, 2.7463076363383152, 29.273213284720072, 2.928623937539669, 27.75087216965289, 3.1474034989805659, 26.410847355791361, 3.4117621357290773, 25.24402302807519, 3.721699847781565, 24.25039918650441, 4.0772166351416672, 23.43909164613925, 4.4691966827303986, 22.791868776859189, 4.9067558056194684, 22.026140311795469, 5.5813261200783018, 21.251296031671441, 6.5749499616504181, 20.786389463597029, 7.6415003237016208, 20.631420607572242, 8.7992088363607763, 20.68611549793394, 9.6469796369710821, 20.831968538898451, 10.631487663478765, 21.078095545526079, 11.725385470708716, 21.43361233287709, 12.9469046887898, 21.88028727083093, 14.277813687589514, 22.436351989508179, 15.736344097240362, 23.083574858788239, 17.304264287598926, 29.710772407613629, 32.737339184659504, 67.550520722846457, 32.737339184659504, 31.95326291244314, 38.070090994930069, 48.954257999870059, 77.578033466190391, 54.150272584231118, 100.00293851449169],
       [54.150272584231118, 100.00293851449169, 48.954257999870059, 77.578033466190391, 65.535925594524016, 38.070090994930069, 31.95326291244314, 38.070090994930069, 67.550520722846457, 32.737339184659504, 73.466684696969821, 18.680752361709892, 73.612537737934346, 18.3070039442282, 74.259760607214403, 16.720852123751683, 74.806709510831354, 15.244090083979245, 75.280731893966049, 13.876717824939988, 75.663596126497893, 12.609619531558565, 75.964418023487241, 11.461026833960204, 76.174081769873737, 10.412708102030592, 76.301703180717695, 9.4828949658804049, 76.347282256019099, 8.6533557953989657, 76.26523992047656, 7.7144268441916211, 75.900607318065255, 6.5840657767112134, 75.253384448785198, 5.5539786748995539, 74.332687127696659, 4.6150497236885712, 73.9498228951648, 4.3506910869400599, 73.129399539739367, 3.9131319640509901, 72.135775698168572, 3.5393835465802113, 70.959835555392118, 3.2203300194705662, 69.619810741530586, 2.9742030128400074, 68.097469626463393, 2.7918867116386537, 66.401928025250854, 2.6733811158483149, 66.401928025250854, 0.0024473031917295884, 104.96182573024601, 0.0024473031917295884, 104.96182573024601, 2.6733811158483149, 103.5215269507213, 2.801002526688535, 102.1450388766186, 3.0106662730795506, 100.8597089531188, 3.3023723550104478, 99.647305550101265, 3.6761207724812266, 98.526060297686513, 4.131911525488249, 97.486857380814314, 4.669744614049705, 96.52969679948464, 5.2896200381510425, 95.663694368757788, 5.9915377977886237, 95.271714321165646, 6.3379387700806546, 94.679186342247277, 6.9578141941892682, 94.077542548268639, 7.6688477688803687, 93.457667124169447, 8.4892711243082886, 92.837791700070198, 9.4008526303405233, 92.199684645850425, 10.421823917091388, 91.552461776570397, 11.543069169500086, 90.896123092230027, 12.764588387581171, 90.230668592829389, 14.095497386391798, 89.556098278368495, 15.517564535788551, 88.863296333787034, 17.04902146591121, 88.170494389205544, 18.680752361709892, 54.150272584231118, 100.00293851449169],
       [35.69986290221928, 100.21260226087907, 19.555754430458901, 100.21260226087907, 11.980512115364091, 75.344658776430151, 14.43266636658009, 75.344658776430151, 35.69986290221928, 100.21260226087907],
     ],

163: [ [67.167656490314585, 10.21302447465132, 26.25587849976657, 9.8119286120017932, 27.39535538230189, 8.9550419963306922, 28.863001607007359, 7.8793758192186942, 30.24860549617031, 6.858404532471468, 31.570398679911278, 5.9103597661996901, 32.828381158230258, 5.0261257053498412, 34.004321301006712, 4.2148181649899925, 35.116450738361181, 3.4673213300411589, 36.146537840173117, 2.7836352005215304, 37.112814236563061, 2.1637597764201928, 38.015279927531033, 1.6168108728088555, 38.835703282956473, 1.1336726746085333, 39.592315932959913, 0.714345181841054, 40.276002062481091, 0.35882839448095183, 40.886761671520013, 0.076238127621763851, 41.069077972725687, -0.0058042079290316906, 42.199439040200723, -0.4615949609396921, 43.366263367916872, -0.84445919347126619, 44.56955095587417, -1.1635127205809113, 45.809301804072589, -1.40963972721147, 47.085515912512157, -1.5828402133593045, 48.398193281192839, -1.6922299940815719, 49.747333910114662, -1.7286932543211151, 50.914158237830833, -1.6831141790098627, 52.108330010727819, -1.5646085832304379, 53.275154338443997, -1.3549448368503363, 54.432862851099877, -1.0723545699802344, 55.572339733635197, -0.69860615250945557, 56.684469170989672, -0.23369958443072392, 57.787482793283857, 0.3041335041198181, 58.872264785457467, 0.92400892822115566, 59.929699332450241, 1.6350425029195321, 60.978018064382752, 2.4281184131687041, 62.00810516619466, 3.3032366589613957, 63.01084482282576, 4.260397240290331, 63.329898349935632, 4.5885665824607713, 64.059163554758243, 5.4089899378814152, 64.761081314400002, 6.2749923686096736, 65.417419998740343, 7.1865738746382704, 66.037295422839549, 8.1528502710316388, 66.620707586697634, 9.1555899276609125, 67.167656490314585, 10.21302447465132],
       [36.593212778126968, 14.424531032498635, 15.3715953177892, 14.424531032498635, 15.891196776225311, 14.406299402380682, 17.14917925454429, 14.251330546361714, 18.398045917803021, 13.92316120418036, 19.191121828047581, 13.622339307199582, 20.330598710582908, 13.084506218641764, 21.497423038299079, 12.409935904179292, 21.169253696128891, 11.170185055980255, 20.713462943114759, 9.739002091511793, 20.230324744919809, 8.4536721680196933, 19.701607471423412, 7.2959636553605378, 19.136426937685879, 6.2932239987312641, 18.534783143707241, 5.4181057529385726, 17.896676089487471, 4.6888405481186055, 17.614085822618701, 4.4335977264308895, 16.529303830445091, 3.5675952957099071, 15.426290208150901, 2.9477198716085695, 14.323276585856719, 2.58308726919131, 13.211147148502249, 2.45546585835109, 21.15102206600832, 2.200223036659736, 21.916750531072068, 3.0388780222092464, 22.67336318107553, 3.9686911583594338, 23.411744200958388, 4.9714308149887074, 24.141009405781009, 6.0562128071615007, 24.861158795543329, 7.2321529499386088, 25.563076555185091, 8.4810196131984412, 26.25587849976657, 9.8119286120017932, 67.167656490314585, 10.21302447465132, 52.637047284224217, 10.96052130958924, 51.643423442653408, 10.97875293971083, 50.385440964334443, 11.042563645140035, 49.118342670955172, 11.16106924091946, 47.851244377575881, 11.334269727060018, 46.575030269136327, 11.553049288508191, 45.28058453057622, 11.826523740321136, 45.225889640214511, 11.844755370439088, 44.824793777562093, 11.935913521050679, 44.286960689005411, 12.081766562008852, 43.603274559484213, 12.273198678278277, 42.782851204058801, 12.51932568490156, 41.825690622729127, 12.801915951771662, 40.731792815495218, 13.139201108999259, 39.492041967296807, 13.522065341541747, 38.115553893194154, 13.950508649370022, 36.593212778126968, 14.424531032498635],
       [16.237597748516041, 18.818353891558218, 15.62683813947711, 18.80923807650106, 14.29592914067586, 18.699848295778793, 13.0288308472966, 18.48106873433062, 11.83465907439958, 18.143783577099384, 22.363425469025909, 18.244057542760856, 21.45184396299766, 18.380794768669148, 20.16651403949783, 18.544879439748911, 18.972342266600801, 18.68161666566084, 18.780910150334869, 18.699848295778793, 17.44088533647334, 18.79100644637947, 16.237597748516041, 18.818353891558218],
       [67.842226804775493, 22.50114317590851, 67.705489578871251, 22.036236607840692, 67.240583010796854, 20.668864348801435, 66.72098155236074, 19.410881870480807, 66.137569388502655, 18.234941727700061, 65.499462334282882, 17.159275550591701, 64.806660389701406, 16.165651709019585, 64.050047739697959, 15.281417648169736, 63.238740199332817, 14.479225922859769, 62.363621953545703, 13.777308163218549, 62.199537282460597, 13.649686752378329, 61.233260886070667, 13.020695513219835, 60.212289599319, 12.473746609601221, 59.109275977024822, 12.017955856590561, 57.951567464368942, 11.635091624058987, 56.720932431230807, 11.343385542120814, 55.426486692670657, 11.133721795740712, 54.0682302486886, 11.006100384900492, 52.637047284224217, 10.96052130958924, 67.167656490314585, 10.21302447465132, 67.678142133690415, 11.316038096949342, 68.152164516825096, 12.473746609601221, 68.589723639718656, 13.66791838249992, 68.990819502371096, 14.916785045759752, 69.355452104782401, 16.202114969259128, 69.683621446952571, 17.542139783119637, 69.966211713821323, 18.93685948734128, 70.221454535509238, 20.368042451809742, 70.440234096956019, 21.853920306639338, 67.842226804775493, 22.50114317590851],
       [33.466488212450031, 95.965496746728604, 32.518443446180669, 95.3547371376917, 31.52481960460986, 94.625471932871733, 30.567659023280189, 93.859743467801309, 29.637845887131391, 93.04843592744146, 28.762727641344242, 92.182433496709564, 27.914956840737968, 91.270851990688243, 27.11276511543312, 90.304575594291236, 26.337920835309092, 89.301835937658325, 25.61777144554679, 88.244401390671555, 24.924969500965322, 87.14138776838081, 24.268630816624981, 85.992795070778811, 23.65787120758603, 84.789507482819317, 23.630523762405179, 84.725696777401026, 23.11092230396909, 83.60445152498869, 22.636899920834399, 82.45585882739033, 22.199340797940842, 81.298150314731174, 21.807360750348689, 80.122210171961342, 21.45184396299766, 78.91892258399821, 21.14190625094804, 77.706519180981559, 20.877547614199869, 76.475884147850593, 20.649652237692809, 75.22701748459076, 20.458220121426869, 73.959919191209337, 20.312367080462341, 72.674589267709962, 20.212093114799249, 71.371027714088996, 20.148282409377259, 70.049234530350077, 20.130050779256688, 68.709209716478654, 20.130050779256688, 68.572472490581276, 20.139166594316979, 67.843207285761309, 20.16651403949783, 67.013668115268956, 20.202977299738961, 66.056507533940021, 20.257672190100632, 64.989957171888818, 20.330598710582908, 63.81401702911171, 20.412641046125461, 62.528687105608697, 20.51291501178855, 61.115735771269101, 20.631420607572242, 59.602510471260757, 20.759042018416181, 57.970779575469351, 20.904895059380721, 56.220543083898519, 21.068979730465799, 54.360916811601783, 7.0853194279923741, 54.360916811601783, 7.0853194279923741, 47.51493970133015, 21.068979730465799, 47.51493970133015, 21.15102206600832, 46.512200044700876, 21.30599092203315, 44.707268662761635, 21.45184396299766, 42.966147986251599, 21.58858118890188, 41.279722200091783, 21.716202599745859, 39.666222934418329, 21.834708195529512, 38.116534374170442, 21.94409797625292, 36.63065651935176, 22.044371941916008, 35.208589369951369, 22.135530092518849, 33.850332925958355, 22.226688243121689, 32.555887187398184, 22.29961476360393, 31.325252154259942, 22.363425469025909, 30.158427826550906, 22.418120359387618, 29.055414204249246, 22.472815249749321, 28.025327102441224, 22.50927850999042, 27.049934890990698, 22.536625955171271, 26.138353384958464, 22.563973400352129, 25.290582584359072, 22.573089215412409, 24.515738304238766, 22.582205030472689, 23.795588914468681, 22.582205030472689, 22.874891593379289, 22.582205030472689, 21.489287704218441, 22.545741770231562, 20.887643910238694, 22.46369943468903, 19.647893062050571, 22.363425469025909, 18.244057542760856, 11.83465907439958, 18.143783577099384, 10.71341382198483, 17.687992824081448, 9.6468634599317795, 17.12281229034852, 8.6532396183609706, 16.448241975878773, 7.7325422972724311, 15.646050250579719, 7.5593418111270694, 15.472849764428247, 6.7206868255810832, 14.533920813220902, 6.018769065939324, 13.522065341541747, 5.4444727171415357, 12.455514979479631, 4.9977977791876924, 11.334269727060018, 4.669628437017507, 10.140097954168596, 4.4781963207515778, 8.8912312909087632, 4.4143856153295919, 7.5785539222306397, 4.4781963207515778, 6.2749923686096736, 4.6787442520777907, 4.9623149999315501, 5.0160294093082314, 3.7590274119793321, 5.4900517924429257, 2.6651296047384676, 6.1099272165421601, 1.6806215782307845, 6.866539866545593, 0.79638751738093561, 7.1947092087157776, 0.46821817521049525, 8.1518697900454242, -0.32485773503867676, 9.2001885219779354, -0.9356173440683051, 10.33054958945297, -1.3731764669682889, 11.55206880753081, -1.6375351037095243, 12.84651454609096, -1.7286932543211151, 13.22937877862282, -1.7195774392603198, 14.42355055151981, -1.601071843480895, 15.590374879235981, -1.3367132067287457, 16.73896757683158, -0.92650152901842375, 17.86932864430662, -0.37955262538889656, 18.972342266600801, 0.32236513424868463, 20.057124258774419, 1.1610201197909191, 20.37617778588432, 1.443610386661021, 21.15102206600832, 2.200223036659736, 13.211147148502249, 2.45546585835109, 12.04432282078608, 2.6195505294417671, 10.950425013552181, 3.120920357749128, 9.9659169870416502, 3.9686911583594338, 9.5465894942686589, 4.4791768017312279, 8.9814089605311551, 5.5092639035501634, 8.6350079882404032, 6.7125514914987434, 8.5256182075170273, 8.0799237505489145, 8.5256182075170273, 8.1801977162103867, 8.6532396183609706, 9.4928750848885102, 8.9905247755914388, 10.677931042730052, 9.5465894942686589, 11.744481404781254, 10.33054958945297, 12.692526171049394, 10.64048730150256, 12.975116437919496, 11.597647882832231, 13.61322349213151, 12.709777320186699, 14.059898430088651, 13.96775979850568, 14.333372881901596, 15.3715953177892, 14.424531032498635, 36.593212778126968, 14.424531032498635, 34.943250252215819, 14.9441324909385, 33.147434685340158, 15.518428839739499, 31.214881892560271, 16.138304263840837, 29.136476058815848, 16.803758763231599, 29.473761216046292, 17.806498419871787, 29.911320338939849, 19.164754863850249, 30.321532016652579, 20.495663862649963, 30.704396249184441, 21.799225416270929, 31.069028851595728, 23.075439524709509, 31.39719819376592, 24.315190372908546, 31.707135905815509, 25.527593775928835, 31.989726172684271, 26.703533918698668, 32.244968994372194, 27.861242431361461, 32.47286437087925, 28.982487683781073, 32.67341230220547, 30.067269675950229, 32.819265343169981, 31.05177770246155, 32.98335001425508, 32.245949475349335, 33.129203055219591, 33.476584508491214, 33.256824466063541, 34.716335356690252, 33.366214246786939, 35.983433650071674, 33.448256582329492, 37.26876357357105, 33.52118310281174, 38.572325127188378, 33.566762178113152, 39.894118310930935, 33.59410962329401, 41.243258939848602, 33.603225438354293, 42.610631198898773, 33.603225438354293, 43.376359663958283, 33.59410962329401, 44.515836546488572, 33.566762178113152, 45.901440435660334, 33.530298917872017, 47.51493970133015, 52.126561640848387, 47.51493970133015, 52.126561640848387, 54.360916811601783, 33.530298917872017, 54.360916811601783, 33.530298917872017, 54.442959147141664, 33.448256582329492, 55.318077392930718, 33.347982616666371, 56.357280309799535, 33.238592835942967, 57.560567897759029, 33.110971425099031, 58.927940156798286, 32.974234199194797, 60.45939708692822, 32.81014952810969, 62.154938688141556, 32.728107192567172, 62.984477858630271, 32.582254151602633, 64.488587343570543, 32.445516925698399, 65.947117753221391, 32.32701132991474, 67.341837457439397, 32.226737364251619, 68.68186227131082, 32.144695028709073, 69.976308009860077, 32.071768508226832, 71.216058858059114, 32.01707361786513, 72.401114815900655, 31.980610357623991, 73.531475883370149, 31.95326291244314, 74.607142060489423, 31.95326291244314, 75.637229162301082, 31.95326291244314, 75.764850573141302, 31.971494542563711, 77.442160544240323, 32.044421063045966, 79.037428179788549, 32.15381084376935, 80.550653479789617, 32.308779699794172, 81.990952259318874, 32.509327631120392, 83.340092888240179, 32.755454637748016, 84.625422811739554, 33.047160719677038, 85.819594584630977, 33.37533006184723, 86.940839837050589, 33.758194294379081, 87.980042753919406, 34.177521787152081, 88.946319150309137, 34.642428355226492, 89.82143739609819, 35.143798183542032, 90.623629121411795, 35.69986290221928, 91.352894326231763, 36.274159251017068, 92.009233010569005, 37.18574075704533, 92.902582886479649, 38.152017153435281, 93.677427166599955, 39.172988440186913, 94.333765850940836, 40.239538802239963, 94.871598939498654, 41.369899869714992, 95.281810617208976, 42.545840012491453, 95.582632514200668, 43.776475045629581, 95.755833000341227, 45.070920784189717, 95.819643705759518, 33.466488212450031, 95.965496746728604],
       [46.793809830583108, 99.785023256990826, 46.666188419739157, 99.785023256990826, 45.389974311299589, 99.748559996751283, 44.13199183298061, 99.64828603108981, 42.883125169721893, 99.484201359999133, 41.652490136583758, 99.26542179855096, 40.440086733566169, 98.973715716620063, 39.236799145608899, 98.62731474433167, 38.051743187772161, 98.217103066621348, 36.88491886005599, 97.752196498538979, 35.727210347400103, 97.214363409988437, 34.587733464864783, 96.621835431069485, 33.466488212450031, 95.965496746728604, 45.070920784189717, 95.819643705759518, 45.61786968780666, 95.810527890698722, 47.012589392029888, 95.682906479858502, 48.279687685409158, 95.427663658170786, 49.428280383004761, 95.02656779552126, 50.44013585469613, 94.479618891899008, 51.333485730603819, 93.805048577440175, 51.716349963135677, 93.413068529851444, 52.381804462536309, 92.528834469001595, 52.91963755109299, 91.498747367189935, 53.329849228805692, 90.322807224409189, 53.621555310734749, 89.001014040681184, 53.785639981819827, 87.524252000908746, 53.858566502302061, 86.557975604519015, 54.040882803507742, 84.953592153909995, 54.268778180014799, 83.640914785220957, 54.54225263182326, 82.629059313530888, 54.870421973993437, 81.908909923771716, 55.289749466766438, 81.325497759909922, 56.173983527613842, 80.377452993641782, 57.158491554124367, 79.702882679179311, 58.243273546297978, 79.301786816540698, 59.410097874014163, 79.165049590628769, 60.029973298113362, 79.201512850868312, 61.160334365588398, 79.502334747860004, 62.254232172822299, 80.094862726778956, 63.302550904754781, 80.969980972571648, 63.867731438492306, 81.635435471969686, 64.514954307772371, 82.701985834020888, 64.897818540304229, 83.850578531608335, 65.03455576620847, 85.081213564750215, 64.988976690907066, 86.001910885839607, 64.834007834882243, 87.114040323198424, 64.560533383073775, 88.21705394548917, 64.177669150541902, 89.329183382840711, 63.676299322226377, 90.441312820199528, 63.047308083066859, 91.553442257551069, 62.318042878244277, 92.665571694909886, 61.461156262577731, 93.768585317200632, 60.485764051127489, 94.880714754559449, 60.485764051127489, 94.880714754559449, 59.692688140882893, 95.66467484974055, 58.826685710156063, 96.384824239499721, 57.905988389067517, 97.032047108779807, 56.921480362557013, 97.606343457580806, 55.873161630624509, 98.116829100959876, 54.76103219327004, 98.563504038909741, 53.585092050493621, 98.93725245638052, 52.354457017355458, 99.238074353368575, 51.060011278795344, 99.475085544938338, 49.701754834813237, 99.64828603108981, 48.279687685409158, 99.748559996751283, 46.793809830583108, 99.785023256990826],
     ],

164: [ [46.575030269136327, 24.75361379971946, 45.444669201661291, 24.325170491880272, 44.277844873945128, 23.960537889470288, 43.101904731168673, 23.641484362360643, 41.889501328151113, 23.386241540680203, 40.667982110073233, 23.185693609349983, 39.419115446814551, 23.048956383448967, 38.142901338374998, 22.957798232841014, 36.848455599814862, 22.930450787669542, 54.952464309535991, 22.930450787669542, 56.101057007131573, 23.732642512968596, 57.249649704727183, 24.589529128628783, 46.575030269136327, 24.75361379971946],
       [26.67520599253956, 24.926814285860019, 16.529303830445091, 24.589529128628783, 16.666041056349311, 24.44367608767061, 17.44088533647334, 23.723526697911439, 18.2977719521399, 23.030724753331015, 19.264048348529851, 22.356154438861267, 20.312367080462341, 21.718047384649253, 21.460959778057941, 21.09817196054064, 22.700710626256381, 20.505643981628964, 24.03161962505763, 19.94046344788876, 25.462802589521971, 19.402630359330942, 26.520237136514741, 19.019766126799368, 27.74175635459261, 18.627786079210637, 28.97239138773077, 18.290500921979401, 30.212142235929178, 17.989679024991347, 31.45189308412759, 17.734436203299992, 32.709875562446598, 17.533888271980686, 33.967858040765577, 17.369803600890009, 35.234956334144869, 17.260413820171379, 36.502054627524132, 17.187487299688655, 37.787384551023962, 17.169255669570703, 38.771892577534487, 17.187487299688655, 39.929601090190367, 17.251298005110584, 41.096425417906509, 17.378919415950804, 42.254133930562404, 17.552119902098639, 43.411842443218291, 17.780015278600331, 44.56955095587417, 18.062605545470433, 45.727259468530058, 18.390774887640873, 46.884967981185937, 18.773639120168809, 48.04267649384181, 19.211198243061517, 49.191269191437407, 19.703452256318997, 50.348977704093301, 20.241285344880453, 51.497570401688897, 20.833813323799404, 52.655278914344791, 21.48103619307949, 53.803871611940401, 22.182953952720709, 54.952464309535991, 22.930450787669542, 36.848455599814862, 22.930450787669542, 36.356201586559621, 22.939566602719424, 35.070871663059762, 22.985145678019762, 33.803773369680499, 23.094535458749306, 32.554906706421797, 23.258620129829069, 31.333387488343931, 23.47739969128088, 30.130099900386629, 23.759989958150982, 28.954159757610199, 24.088159300321422, 27.805567060014599, 24.480139347910153, 26.67520599253956, 24.926814285860019],
       [54.478441926401302, 75.574282760790084, 36.921382120297132, 74.981754781878408, 37.632415694999167, 74.972638966810337, 38.88128235825787, 74.908828261388408, 40.121033206456303, 74.781206850548188, 41.351668239594431, 74.598890549350472, 42.573187457672297, 74.352763542719913, 43.785590860689858, 74.042825830671063, 44.997994263707447, 73.67819322826108, 46.20128185166476, 73.249749920418253, 57.249649704727183, 73.468529481870064, 56.502152869784027, 74.088404905971402, 55.508529028213218, 74.854133371030912, 54.478441926401302, 75.574282760790084],
       [37.067235161261642, 80.824992235520767, 36.073611319690848, 80.806760605399177, 34.870323731733549, 80.733834084909176, 33.648804513655712, 80.615328489129752, 32.409053665457272, 80.442128002989193, 31.160187002198569, 80.22334844154102, 29.902204523879561, 79.940758174670918, 28.625990415440011, 79.621704647561273, 27.340660491940181, 79.238840415029699, 26.03709893831979, 78.810397107201425, 25.24402302807519, 78.509575210209732, 23.95869310457536, 77.989973751769867, 22.737173886497491, 77.433909033090458, 21.561233743721061, 76.850496869228664, 20.449104306366589, 76.239737260199036, 19.382553944313511, 75.59251439091895, 18.37981428768245, 74.917944076460117, 17.422653706352769, 74.206910501750826, 16.529303830445091, 73.468529481870064, 27.11276511543312, 73.176823399939167, 28.25224199796844, 73.596150892710284, 29.419066325684611, 73.969899310188339, 30.613238098581611, 74.279837022229913, 31.82564150159919, 74.535079843921267, 33.056276534737322, 74.726511960190692, 34.323374828116613, 74.872365001148864, 35.60870475161645, 74.95440733669966, 36.921382120297132, 74.981754781878408, 54.478441926401302, 75.574282760790084, 53.411891564348217, 76.248853075259831, 52.317993757114323, 76.877844314418326, 51.18763268963928, 77.461256478269206, 50.020808361923137, 78.008205381891457, 48.817520773965832, 78.500459395141661, 47.586885740827682, 78.947134333098802, 47.04905265227103, 79.129450634300156, 45.745491098650632, 79.521430681899801, 44.460161175150773, 79.867831654188194, 43.183947066711227, 80.159537736119091, 41.925964588392247, 80.396548927681579, 40.686213740193807, 80.587981043951004, 39.464694522115963, 80.715602454791224, 38.261406934158657, 80.797644790338381, 37.067235161261642, 80.824992235520767],
       [6.0005374358187558, 83.705589794561092, 1.9622313641135909, 79.603473017439683, 12.34514471777541, 69.43022341015967, 11.852890704520149, 68.819463801130041, 11.06893060933583, 67.771145069189515, 10.33966540451325, 66.704594707138313, 9.6468634599317795, 65.628928530029953, 9.0087564057120062, 64.535030722800002, 8.4162284267936212, 63.432017100498342, 7.8692795231766857, 62.31077184807873, 7.3679096948611402, 61.171294965548441, 6.9212347569072961, 60.022702267950081, 6.5110230791945858, 58.864993755290925, 6.155506291843551, 57.679937797460298, 5.8455685797939623, 56.494881839618756, 5.5903257581060473, 55.282478436609381, 5.371546196659267, 54.060959218528296, 5.2074615255741881, 52.830324185390054, 5.0889559297905, 51.572341707069427, 5.0160294093082314, 50.314359228748799, 4.9886819641274078, 49.029029305249423, 4.9977977791876924, 48.199490134771622, 5.0524926695493662, 46.877696951029066, 5.1527666352124859, 45.574135397411737, 5.3077354912372812, 44.288805473908724, 5.4991676075032103, 43.030822995591734, 5.7361787990705571, 41.800187962449854, 6.0278848809996068, 40.57866874436877, 6.3651700382300467, 39.393612786530866, 6.7480342707619343, 38.217672643761034, 7.1855933936554939, 37.078195761219831, 7.65961577679019, 35.947834693750337, 8.188333050286559, 34.844821071448678, 8.7626293990843749, 33.769154894340318, 9.3825048231835808, 32.71172034734991, 10.057075137644491, 31.67251743047018, 10.76810871234653, 30.660661958780111, 11.53383717741025, 29.667038117211632, 12.34514471777541, 28.700761720818264, 1.9622313641135909, 18.244921846671787, 6.0005374358187558, 14.279542295451392, 16.529303830445091, 24.589529128628783, 26.67520599253956, 24.926814285860019, 25.572192370245379, 25.437299929239089, 24.487410378071761, 26.002480462979292, 23.429975831078959, 26.62235588708063, 22.39077291420676, 27.296926201539463, 21.378917442515391, 28.035307221420226, 20.38529360094461, 28.819267316608602, 19.419017204554649, 29.667038117211632, 18.470972438285258, 30.578619623240229, 18.224845431657631, 30.824746629870788, 17.331495555749939, 31.781907211199723, 16.492840570203949, 32.757299422650249, 15.70888047501967, 33.760039079279522, 14.98873108525734, 34.790126181091182, 14.323276585856719, 35.829329097959999, 13.721632791878079, 36.895879460011201, 13.174683888261111, 37.989777267248428, 12.68242987500585, 39.101906704599969, 12.244870752112289, 40.241383587141172, 11.87112233464072, 41.399092099789414, 11.55206880753081, 42.57503224257016, 11.296825985842901, 43.778319830529654, 11.087162239456401, 45.008954863671534, 10.950425013552181, 46.248705711870571, 10.85926686294934, 47.524919820309151, 10.831919417768489, 48.810249743808527, 10.841035232828769, 49.43012516789895, 10.89573012319047, 50.724570906470035, 11.005119903913879, 51.991669199840544, 11.169204574998959, 53.240535863100376, 11.39709995150602, 54.462055081181461, 11.6705744033145, 55.65622685408016, 12.00785956054494, 56.832166996849992, 12.39983960813708, 57.989875509509147, 12.85563036115121, 59.120236576989555, 13.35700018946676, 60.223250199280301, 13.92218072320429, 61.308032191449456, 14.532940332243211, 62.374582553500659, 15.207510646704121, 63.41378547038039, 15.945891666587009, 64.434756757131254, 16.7298517617713, 65.428380598699732, 17.56850674731729, 66.394656995089463, 18.470972438285258, 67.342701761361241, 18.881184115997989, 67.743797624010767, 19.820113067207071, 68.628031684860616, 20.79550527865732, 69.439339225231379, 21.780013305167842, 70.205067690290889, 22.80098459191947, 70.916101264989265, 23.840187508791669, 71.563324134269351, 24.906737870844751, 72.155852113188303, 26.000635678078648, 72.693685201749759, 27.11276511543312, 73.176823399939167, 16.529303830445091, 73.468529481870064, 6.0005374358187558, 83.705589794561092],
       [67.550520722846457, 83.705589794561092, 57.249649704727183, 73.468529481870064, 46.20128185166476, 73.249749920418253, 47.38633780950147, 72.757495907171688, 48.571393767338208, 72.210547003549436, 49.747333910114662, 71.599787394508894, 49.77468135529552, 71.581555764390941, 50.877694977589691, 70.943448710171651, 51.935129524582457, 70.250646765591227, 52.946984996273841, 69.512265745710465, 53.922377207724047, 68.72830565051845, 54.843074528812593, 67.898766480040649, 55.727308589659998, 67.0145324191908, 56.565963575205977, 66.075603467979818, 57.35903948545058, 65.100211256529292, 58.115652135454013, 64.07012415472127, 58.817569895095772, 62.994457977598358, 59.483024394496397, 61.864096910128865, 59.902351887269411, 61.080136814951402, 60.494879866187773, 59.87684922698827, 61.023597139684171, 58.682677454089571, 61.488503707758547, 57.479389866130077, 61.898715385471291, 56.276102278170583, 62.236000542701731, 55.063698875161208, 62.518590809570497, 53.851295472140919, 62.737370371017278, 52.629776254070748, 62.892339227042072, 51.408257035989664, 62.983497377644909, 50.186737817908579, 63.01084482282576, 48.956102784770337, 63.01084482282576, 48.518543661881267, 62.965265747524342, 47.233213738378254, 62.855875966800937, 45.975231260061264, 62.691791295715859, 44.744596226919384, 62.463895919208802, 43.532192823899095, 62.190421467400313, 42.338021051000396, 61.853136310169873, 41.171196723291359, 61.452040447517447, 40.013488210628566, 61.005365509563603, 38.892242958219867, 60.494879866187773, 37.78011352086105, 59.920583517389957, 36.695331528688257, 59.300708093290751, 35.637896981690574, 58.61702196376956, 34.598694064821757, 57.86952512882641, 33.577722778070893, 57.076449218581807, 32.574983121441619, 56.219562602915261, 31.599590909991093, 55.298865281826721, 30.64243032865852, 54.870421973993437, 30.232218650948198, 53.91326139266377, 29.347984590098349, 52.93786918121355, 28.518445419620548, 51.935129524582457, 27.752716954550124, 50.905042422770549, 27.032567564790952, 49.856723690838038, 26.385344695510867, 48.790173328784988, 25.78370090153112, 47.696275521551087, 25.236751997908868, 46.575030269136327, 24.75361379971946, 57.249649704727183, 24.589529128628783, 67.550520722846457, 14.279542295451392, 71.734679835516133, 18.244921846671787, 61.35176648185432, 28.700761720818264, 61.889599570411008, 29.38444785034153, 62.673559665595292, 30.46011402744989, 63.411940685478179, 31.554011834690755, 64.104742630059661, 32.647909641931619, 64.751965499339718, 33.750923264218727, 65.344493478258073, 34.872168516631064, 65.891442381875038, 36.002529584111471, 66.39281221019057, 37.151122281698918, 66.848602963204684, 38.299714979300916, 67.249698825857124, 39.466539307009953, 67.614331428268429, 40.642479449790699, 67.924269140318032, 41.827535407628602, 68.179511962005947, 43.021707180520025, 68.398291523452727, 44.234110583551228, 68.562376194537819, 45.446513986560603, 68.680881790321493, 46.677149019698845, 68.753808310803748, 47.926015682951402, 68.781155755984599, 49.17488234621851, 68.772039940924316, 49.749178695008595, 68.726460865622897, 50.97069791308968, 68.635302715020075, 52.183101316109969, 68.48944967405555, 53.386388904069463, 68.29801755778962, 54.589676492021681, 68.051890551161989, 55.774732449859584, 67.760184469232954, 56.959788407701126, 67.4228993120025, 58.135728550470958, 67.030919264410343, 59.302552878190909, 66.602475956577067, 60.460261390850064, 66.110221943321818, 61.608854088441149, 65.581504669825421, 62.748330970978714, 64.99809250596735, 63.887807853509003, 64.369101266807846, 65.009053105921339, 63.685415137286668, 66.130298358340951, 62.956149932464058, 67.242427795699768, 62.181305652340029, 68.336325602929719, 61.35176648185432, 69.43022341015967, 71.734679835516133, 79.603473017439683, 67.550520722846457, 83.705589794561092],
     ],

165: [ [73.749274963838573, 97.772156736529723, 48.817520773965832, 97.772156736529723, 48.817520773965832, 95.0282964033795, 49.637944129391258, 94.90067499253928, 50.75918938180601, 94.809516841938603, 52.208603976390947, 94.654547985908721, 53.612439495674458, 94.39018934916021, 54.669874042667232, 94.034672561811021, 55.371791802308991, 93.587997623861156, 56.07370956195075, 92.804037528669141, 56.684469170989672, 91.728371351560781, 56.885017102315878, 90.634473544330831, 56.875901287255601, 90.260725126860052, 56.730048246291091, 89.276217100348731, 56.429226349301757, 88.10939277262878, 55.982551411347913, 86.760252143711114, 55.371791802308991, 85.219679398520384, 40.020759240793183, 48.884040568231285, 27.340660491940181, 48.884040568231285, 0.1664157972379314, 48.884040568231285, 0.1664157972379314, 43.62421527845072, 29.646961702191678, 43.62421527845072, 30.722627879305008, 41.026207986269583, 30.722627879305008, 30.643294632609468, 0.1664157972379314, 30.643294632609468, 0.1664157972379314, 25.383469342828903, 30.722627879305008, 25.383469342828903, 30.722627879305008, 17.598563281339011, 30.722627879305008, 16.030643090980448, 30.704396249184441, 14.207480078919616, 30.67704880400359, 12.639559888550139, 30.631469728702172, 11.326882519868377, 30.576774838340469, 10.278563787931489, 30.512964132918508, 9.485487877689593, 30.430921797375959, 8.947654789131775, 30.102752455205781, 7.808177906601486, 29.564919366649121, 6.6322377638207399, 28.88123323712793, 5.6386139222486236, 28.060809881702511, 4.8364221969386563, 27.86937776543656, 4.6996849710412789, 26.985143704589149, 4.1709676975515322, 25.964172417837521, 3.7334085746515484, 24.81557972024191, 3.3961234174312267, 23.53024979674208, 3.1591122258614632, 22.108182647338001, 3.0132591848887387, 20.558494087089969, 2.9585642945312429, 18.252192876838478, 2.9585642945312429, 18.252192876838478, 0.0050402150009176694, 55.371791802308991, 0.0050402150009176694, 55.371791802308991, 2.9585642945312429, 52.418267722777443, 2.9585642945312429, 52.33622538723489, 2.9585642945312429, 51.005316388433641, 3.0314908150103292, 49.738218095054371, 3.2229229312797543, 48.525814692036789, 3.5419764583893993, 47.377221994441179, 3.9795355812784692, 46.292440002267568, 4.544716115018673, 45.244121270335079, 5.337792025271483, 44.414582099849383, 6.2676051614107564, 43.840285751051567, 7.2885764481616206, 43.822054120930993, 7.3523871535799117, 43.639737819725347, 8.0178416529888636, 43.48476896370056, 8.8473808234703029, 43.348031737796298, 9.8683521102211671, 43.238641957072929, 11.053408068059071, 43.156599621530368, 12.429896142159123, 43.092788916108411, 13.970468887349853, 43.056325655867283, 15.693357933738298, 43.047209840807, 17.598563281339011, 43.047209840807, 25.383469342828903, 73.749274963838573, 25.383469342828903, 73.749274963838573, 30.643294632609468, 43.047209840807, 30.643294632609468, 43.047209840807, 42.46650676579884, 43.54857966912251, 43.62421527845072, 73.749274963838573, 43.62421527845072, 73.749274963838573, 48.884040568231285, 45.854880879374008, 48.884040568231285, 61.278839961372057, 83.852307139481127, 61.287955776432341, 83.861422954538284, 61.971641905953533, 85.356416624421399, 62.664443850535001, 86.742020513589523, 63.3481299800562, 88.027350437081623, 64.040931924637675, 89.194174764801573, 64.724618054158853, 90.242493496738462, 65.417419998740343, 91.190538263010239, 66.101106128261534, 92.029193248548836, 66.793908072842996, 92.758458453368803, 67.477594202364187, 93.369218062420259, 67.678142133690415, 93.533302733500022, 68.553260379477535, 94.071135822061478, 69.592463296349749, 94.490463314821682, 70.804866699367324, 94.79128521182065, 72.19047058853026, 94.964485697961209, 73.749274963838573, 95.0282964033795, 73.749274963838573, 97.772156736529723],
       [32.01707361786513, 97.772156736529723, 0.1664157972379314, 97.772156736529723, 0.1664157972379314, 95.0282964033795, 1.032418227964768, 94.991833143139957, 2.363327226766017, 94.827748472060193, 3.612193890024741, 94.536042390118382, 4.7607865876203439, 94.125830712411698, 5.827336949673394, 93.597113438918313, 6.7936133460633519, 92.940774754581071, 7.2949831743788698, 92.503215631681087, 7.9513218587192114, 91.801297872039868, 8.6076605430595521, 90.962642886501271, 9.2731150424601765, 89.97813485998995, 9.9476853569210846, 88.856889607570338, 10.622255671381989, 87.59890712924971, 11.296825985842901, 86.19507160997091, 11.980512115364091, 84.645383049719385, 27.340660491940181, 48.884040568231285, 40.020759240793183, 48.884040568231285, 24.59680015879513, 86.304461390700453, 24.25039918650441, 87.152232191299845, 23.721681913008009, 88.601646785878984, 23.402628385898112, 89.741123668420187, 23.302354420235019, 90.561547023851745, 23.44820746119953, 91.409317824451136, 24.049851255178201, 92.421173296141205, 25.09816998711068, 93.369218062420259, 25.563076555185091, 93.670039959401038, 26.429078985911929, 94.052904191928974, 27.50474516302527, 94.39018934916021, 28.790075086525089, 94.654547985908721, 30.303300386532019, 94.873327547360532, 32.01707361786513, 95.0282964033795, 32.01707361786513, 97.772156736529723],
     ],

166: [ [22.578791359788649, 193.74135569375358, 22.17446736337709, 193.72163257197826, 20.902326008813901, 193.45537042799697, 19.748523384907742, 192.86367677470844, 18.683474808994362, 191.93669005123957, 18.09178115570915, 191.1970729846289, 17.460641258871622, 190.04327036072209, 17.085901945124299, 188.77112900616339, 16.957701653579189, 187.39051048183319, 16.97742477535536, 186.70020121966081, 17.085901945124299, 185.39847518243187, 17.32257940643839, 184.13619538875355, 17.66773403752142, 182.89363871685782, 18.131227399261519, 181.69052828852, 18.70319793077056, 180.5170025428306, 19.393507192936621, 179.3829230406991, 20.192293624871638, 178.26856666034291, 21.119280348351818, 177.19365652353736, 22.14488268071284, 176.14833106940932, 22.706991651333791, 175.62566834232712, 23.722732422806729, 174.7775741059595, 24.787780998720109, 174.0182339175808, 25.90213737907391, 173.35750933807867, 27.065801563868149, 172.7756772456778, 28.278773553102841, 172.28259920128039, 29.54105334677795, 171.88813676575228, 30.842779384005411, 171.5725668173327, 32.193813225673303, 171.34575091690931, 33.594154871781633, 171.21755062536249, 35.043804322330381, 171.16824282093148, 35.093112126770819, 171.16824282093148, 36.513176894655317, 171.21755062536249, 37.893795418987452, 171.33588935602165, 39.23496769976726, 171.54298213466973, 40.536693736994721, 171.83882896132127, 41.808835091557903, 172.20370671417186, 43.031668641680682, 172.65733851503319, 44.224917509139168, 173.18986280298122, 45.378720133045327, 173.80127957803779, 35.477713001406187, 173.97878767403017, 34.876157787232898, 173.99851079581276, 33.465954580236478, 174.12671108735231, 32.134643860344767, 174.41269635310164, 30.882225627557741, 174.83674347129272, 29.718561442763502, 175.41857556369359, 28.633789745073958, 176.14833106940932, 28.574620379745419, 176.18777731295995, 27.60818741271294, 177.17393340176932, 27.026355320315819, 178.30801290389354, 26.829124102554061, 179.60973894112249, 26.868570346106431, 180.29018664239993, 27.055940002980069, 181.58205111874122, 27.410956194951179, 183.2092086652774, 27.460263999391628, 183.40643988303782, 27.74624926514614, 184.8265046509332, 27.923757361131688, 186.18740005348081, 27.982926726460221, 187.45954140803951, 27.923757361131688, 188.52458998395741, 27.64763365626527, 189.87562382563192, 27.134832490084762, 191.05901113218715, 26.395215423478248, 192.07475190366677, 26.197984205716519, 192.28184468232212, 25.123074068915059, 193.0904926751391, 23.910102079680371, 193.57370915866341, 22.578791359788649, 193.74135569375358],
       [17.60564896360124, 21.636513864832523, 11.62555757518613, 21.636513864832523, 11.62555757518613, -31.855129288429453, 17.60564896360124, -31.855129288429453, 17.60564896360124, 21.636513864832523],
       [17.60564896360124, 102.52319340904796, 11.62555757518613, 102.52319340904796, 11.62555757518613, 49.031550255793263, 17.60564896360124, 49.031550255793263, 17.60564896360124, 102.52319340904796],
     ],

167: [ [48.021618451052603, 58.85724223779107, 29.501607103225581, 58.551533850259148, 29.53119178588986, 58.521949167603452, 30.369424461377239, 57.752747418322542, 31.26682650219314, 56.96382254728087, 32.223397908337553, 56.14531299356895, 33.229277118922397, 55.297218757201335, 34.294325694835777, 54.409678277261264, 35.408682075189581, 53.512276236448088, 36.582207820871929, 52.575427952077007, 37.805041370994672, 51.608994985042955, 39.087044286445973, 50.622838896240864, 39.619568574402649, 50.198791778049781, 41.029771781399063, 49.074573836813215, 42.370944062178857, 47.970079017351964, 43.63322385585397, 46.905030441426788, 44.816611162424408, 45.869566548179137, 45.930967542778198, 44.853825776706799, 46.9664314360273, 43.877531248792366, 47.932864403059817, 42.930821403533628, 48.820404882987638, 42.003834680050204, 49.629052875810743, 41.116294200131961, 50.368669942417263, 40.258338402847585, 51.02939452191908, 39.42996728826256, 51.621088175204278, 38.631180856333231, 52.133889341384823, 37.861979107052321, 52.666413629341491, 36.964577066239144, 53.366584452395642, 35.64312790724216, 53.958278105680868, 34.341401870013215, 54.441494589197099, 33.059398954552307, 54.816233902944418, 31.787257600000885, 55.082496046922749, 30.524977806308016, 55.250142582020231, 29.282421134419565, 55.299450386460677, 28.049726023396943, 55.299450386460677, 27.635540466108068, 55.220557899355981, 26.462014720433217, 55.043049803370423, 25.308212096519128, 54.776787659392063, 24.174132594387629, 54.411909906532863, 23.059776214031444, 53.958278105680868, 21.96514295545785, 53.415892256836088, 20.900094379547227, 52.774890799110437, 19.844907364516985, 52.035273732503917, 18.81930503215699, 51.206902617904632, 17.813425821572309, 50.28977745531256, 16.817408171882562, 49.274036683839633, 15.850975204841234, 48.159680303485828, 14.904265359589772, 46.956569875139223, 13.977278636113624, 45.66470539879986, 13.079876595293172, 44.27422531357962, 12.192336115360376, 49.688222241139272, 12.083858945603424, 50.861747986821598, 12.951676303753629, 51.96624280628734, 13.829355222791492, 53.021429821312609, 14.736618824492325, 54.017447471009383, 15.653743987080816, 54.954295755377622, 16.600453832339554, 55.831974674417353, 17.566886799380882, 56.650484228128562, 18.553042888182972, 57.409824416511242, 19.558922098767653, 58.119856800453498, 20.584524431127647, 58.760858258179127, 21.639711446150613, 58.879196988836178, 21.836942663911032, 59.579367811890329, 23.12880714025232, 60.210507708727903, 24.420671616593609, 60.762755118460738, 25.712536092927621, 61.245971601976997, 27.00440056926891, 61.65029559838856, 28.296265045610198, 61.985588668583517, 29.588129521951487, 62.251850812561848, 30.879993998292775, 62.429358908547421, 32.171858474626788, 62.547697639204472, 33.463722950968076, 62.577282321868722, 34.755587427309365, 62.567420760980632, 35.64312790724216, 62.468805152099769, 36.974438627126801, 62.301158617002301, 38.286026225243404, 62.044758033912039, 39.587752262457798, 61.709464963717089, 40.889478299701295, 61.29527940641745, 42.161619654259994, 60.802201362013108, 43.433761008818692, 60.220369269615979, 44.686179241609352, 59.569506251002252, 45.928735913512355, 58.829889184395739, 47.161431024520425, 58.820027623507649, 47.171292585408082, 58.267780213774778, 48.009525260902592, 57.666224999601489, 48.847757936389826, 57.015361980987763, 49.705713733652374, 56.325052718821702, 50.573531091802579, 55.585435652215182, 51.451210010840441, 54.796510781168251, 52.338750490773236, 53.968139666568959, 53.236152531579137, 53.090460747529221, 54.143416133287246, 52.173335584937149, 55.070402856763394, 51.206902617904632, 55.997389580246818, 50.191161846431697, 56.94409942549828, 49.12611327051831, 57.890809270757018, 48.021618451052603, 58.85724223779107],
       [49.086667026965983, 97.060929118240892, 38.722166533586751, 96.765082291596627, 39.698461061507352, 96.725636048038723, 41.118525829391842, 96.518543269390648, 42.390667183955031, 96.133942394757469, 43.51488512519694, 95.561971863251529, 44.491179653117541, 94.812493235753209, 44.589795261998397, 94.713877626876638, 45.45761262015003, 93.698136855397024, 46.078890956099507, 92.55419579239242, 46.453630269846791, 91.291915998706827, 46.581830561391932, 89.911297474376624, 46.571969000503863, 89.556281282406417, 46.463491830734881, 88.224970562507224, 46.21695280853271, 86.814767355506774, 45.930967542778198, 85.365117904970248, 45.714013203240278, 83.964776258857455, 45.644982277023701, 82.988481730943022, 45.654843837911777, 82.702496465186414, 45.871798177449669, 81.390908867069811, 46.39446090451829, 80.187798438731988, 47.232693580005673, 79.093165180136566, 47.567986650200623, 78.767733670836606, 48.65275834789017, 78.028116604233219, 49.875591898012921, 77.584346364266821, 51.266071983233161, 77.436422950951965, 51.522472566323422, 77.446284511832346, 52.922814212431739, 77.643515729592764, 54.116063079890239, 78.146455334877828, 55.082496046922749, 78.955103327709367, 55.112080729587007, 78.984688010372338, 55.920728722410132, 80.099044390728523, 56.502560814807246, 81.29229325819324, 56.847715445890287, 82.574296173639596, 56.956192615659262, 83.925330015306827, 56.956192615659262, 84.388823377048539, 56.857577006778371, 85.690549414277484, 56.640622667240478, 86.952829207948525, 56.305329597045521, 88.195385879851528, 55.85169779619352, 89.398496308196627, 55.279727264684482, 90.572022053878754, 54.59927956340649, 91.71596311689791, 53.800493131471477, 92.830319497246819, 52.8735064079913, 93.905229634052375, 51.838042514742199, 94.960416649082617, 51.197041057016548, 95.532387180581281, 50.17143872465553, 96.34103517341282, 49.086667026965983, 97.060929118240892],
       [38.722166533586751, 99.792581484238326, 38.672858729146327, 99.792581484238326, 37.26265552214992, 99.743273679800041, 35.88203699781775, 99.615073388253222, 34.540864717037948, 99.407980609597871, 33.23913867981048, 99.121995343848539, 31.966997325247291, 98.757117590990674, 30.74416377512452, 98.303485790136619, 29.55091490766603, 97.770961502181308, 28.397112283759871, 97.149683166229806, 27.28275590340607, 96.459373904071981, 26.20784576660461, 95.68031059391069, 25.1625203124674, 94.822354796640866, 24.166502662770629, 93.875644951389404, 23.288823743730919, 92.938796667018323, 22.411144824691181, 91.883609652002633, 21.622219953644251, 90.798837954302144, 20.912187569701981, 89.674620013058302, 20.290909233752529, 88.520817389158765, 19.748523384907742, 87.327568521686771, 19.294891584055762, 86.104734971573635, 18.920152270308449, 84.842455177902593, 18.634167004553941, 83.550590701561305, 18.41721266501602, 82.219279981669388, 18.298873934358991, 80.858384579121775, 18.259427690806628, 79.458042933001707, 18.279150812582799, 78.422579039746779, 18.39748954323986, 77.091268319862138, 18.604582321889659, 75.759957599970221, 18.900429148532279, 74.438508440973237, 19.294891584055762, 73.126920842849358, 19.778108067571988, 71.815333244732756, 20.35007859908103, 70.513607207511086, 20.68537166927598, 69.803574823563395, 21.237619079008851, 68.758249369428086, 21.868758975846418, 67.693200793517462, 22.568929798900569, 66.608429095816973, 23.34799310905942, 65.494072715482616, 24.196087345434911, 64.35013165246346, 25.123074068915059, 63.186467467661714, 26.119091718611831, 62.00308016109193, 27.194001855413291, 60.780246610971517, 26.88829346788259, 60.602738514979137, 25.59642899154321, 59.784228961267218, 24.363733880532379, 58.945996285779984, 23.190208134850021, 58.088040488517436, 22.06599019360814, 57.210361569479574, 21.00094161769476, 56.312959528666397, 19.995062407109909, 55.39583436607063, 19.048352561853591, 54.458986081706826, 18.160812081925769, 53.502414675560431, 17.32257940643839, 52.526120147638721, 16.543516096279539, 51.520240937046765, 15.8236221514492, 50.504500165581703, 15.153036011059299, 49.469036272341327, 15.014974158626069, 49.232358811023005, 14.30494177468384, 47.96021745645703, 13.66394031695819, 46.678214541003399, 13.10183134633723, 45.396211625549768, 12.61861486282098, 44.114208710103412, 12.20442930552133, 42.822344233762124, 11.86913623532638, 41.530479757420835, 11.60287409134804, 40.238615281079547, 11.4155044344744, 38.94675080475281, 11.29716570381734, 37.645024767516588, 11.26758102115309, 36.343298730287643, 11.27744258204117, 35.475481372137438, 11.366196630033951, 34.134309091357864, 11.543704726019509, 32.802998371473223, 11.79024374822168, 31.491410773349344, 12.115675257528549, 30.199546297008055, 12.51999925394011, 28.9175433815617, 13.01307729834445, 27.645402027003001, 13.57518626896541, 26.402845355099998, 14.216187726691061, 25.160288683196995, 14.93608167152138, 23.947316693971516, 15.36999035059719, 23.276730553581729, 15.96168400388242, 22.438497878087219, 16.59282390071996, 21.590403641712328, 17.273271601997951, 20.722586283547571, 18.003027107716381, 19.844907364516985, 18.791951978763329, 18.957366884591465, 19.620323093362629, 18.050103282883356, 20.498002012402338, 17.132978120302141, 21.42498873588249, 16.196129835916508, 22.401283263803091, 15.249419990672322, 23.426885596164109, 14.292848584518651, 24.501795732965579, 13.326415617491875, 25.626013674207488, 12.340259528682509, 26.799539419889811, 11.334380318097828, 28.012511409124471, 10.318639546618215, 29.284652763687689, 9.293037214272772, 30.60610192269133, 8.2575733210178441, 31.976858886135378, 7.202386306002154, 33.387062093131789, 6.1373377300769789, 34.570449399702198, 5.2300741283834213, 35.891898558705833, 4.1946102351284935, 37.144316791492848, 3.1690079027612228, 38.327704098063293, 2.1631286921765422, 39.451922039305167, 1.1671110424795188, 40.49724749344238, 0.20067807545274263, 41.47354202136296, -0.75589333068637643, 42.390667183955031, -1.6927416150574572, 43.238761420330519, -2.6098667776532238, 44.007963169601283, -3.5171303793613333, 44.71799555354351, -4.4046708592868526, 45.358997011269167, -5.2724882174297818, 45.930967542778198, -6.1205824538119487, 46.06902939521143, -6.347398354242614, 46.710030852937052, -7.5209240999174654, 47.232693580005673, -8.7437576500378782, 47.646879137305319, -10.015899004611128, 47.932864403059817, -11.337348163622664, 48.110372499045383, -12.708105127057934, 48.169541864373912, -14.118308334051108, 48.100510938157292, -15.291834079733235, 47.863833476843212, -16.514667629860924, 47.469371041319732, -17.717778058213298, 46.917123631586882, -18.901165364783083, 46.197229686756543, -20.045106427787687, 45.319550767716827, -21.169324369031528, 44.27422531357962, -22.263957627612399, 43.95865536516083, -22.559804454249388, 42.84429898480704, -23.476929616852431, 41.700357921788957, -24.255992927006446, 40.516970615218547, -24.88713282385288, 39.303998625983873, -25.380210868250288, 38.061441954084927, -25.735227060220495, 36.789300599521738, -25.942319838868571, 35.477713001406187, -26.021212325969827, 45.378720133045327, -26.198720421962207, 46.49307651339916, -25.498549598902173, 47.567986650200623, -24.719486288748158, 48.603450543449718, -23.861530491478334, 49.609329754034583, -22.914820646226872, 49.737530045579717, -22.786620354680053, 50.664516769059873, -21.79060270498303, 51.502749444547248, -20.745277250847721, 52.262089632929928, -19.670367114042165, 52.952398895095989, -18.556010733693256, 53.553954109269313, -17.402208109779167, 54.076616836337898, -16.199097681441344, 54.510525515413718, -14.966402570433274, 54.875403268272947, -13.6942612158673, 55.151526973139362, -12.382673617750697, 55.35861975178917, -11.031639776083466, 55.476958482446229, -9.6411596908583306, 55.516404725998562, -8.2112333620898426, 55.506543165110493, -7.392723808370647, 55.40792755622963, -6.0022437231600634, 55.230419460244057, -4.631486759710242, 54.964157316265727, -3.3001760398183251, 54.609141124294581, -1.9984500025966554, 54.165370884330677, -0.72630864803068107, 53.642708157262092, 0.51624802387232194, 53.327138208843309, 1.1473879206969286, 52.774890799110437, 2.1236824486331898, 52.153612463160982, 3.1394232200982515, 51.443580079218719, 4.2044717960234266, 50.644793647283699, 5.2991050545897451, 49.776976289132051, 6.4430461176089011, 48.810543322099562, 7.6165718632910284, 47.775079428850432, 8.8394054134114413, 46.650861487608552, 10.101685207089758, 47.18338577556522, 10.427116716396995, 48.465388691016493, 11.245626270108914, 49.688222241139272, 12.083858945603424, 44.27422531357962, 12.192336115360376, 44.007963169601283, 12.438875137573632, 43.071114885233037, 13.27710781305359, 42.104681918200519, 14.135063610323414, 41.088941146727592, 15.002880968473619, 40.043615692590379, 15.870698326616548, 38.958843994900832, 16.758238806549343, 37.834626053658951, 17.65564084736252, 36.680823429752792, 18.562904449070629, 35.477713001406187, 19.470168050771463, 34.777542178352043, 20.012553899621707, 33.396923654019872, 21.087464036419988, 32.085336055904321, 22.142651051442954, 30.832917823117299, 23.178114944690606, 29.649530516546889, 24.193855716162943, 28.525312575305009, 25.18001180497231, 27.460263999391628, 26.156306332886743, 26.464246349694861, 27.112877739040414, 25.537259626214709, 28.049726023396943, 24.669442268063051, 28.966851185999985, 23.86079427523995, 29.864253226813162, 23.121177208633441, 30.741932145851024, 22.440729507355432, 31.590026382233191, 21.82931273229406, 32.428259057720425, 21.286926883449301, 33.246768611432344, 21.129141909239909, 33.493307633631048, 20.458555768850012, 34.696418061983422, 19.89644679822905, 35.929113172991492, 19.432953436488958, 37.191392966662534, 19.077937244517841, 38.483257443011098, 18.82153666142759, 39.804706602008082, 18.663751687218191, 41.155740443668037, 18.614443882777749, 42.546220528893173, 18.624305443665861, 43.039298573297856, 18.70319793077056, 44.242409001642955, 18.880706026756108, 45.415934747332358, 19.14696817073445, 46.579598932119552, 19.501984362705571, 47.703816873363394, 19.955616163557579, 48.818173253719578, 20.498002012402338, 49.893083390517859, 21.129141909239909, 50.958131966443034, 21.85889741495831, 51.99359585968341, 22.667545407781429, 52.99947507026809, 23.574809009485421, 53.985631159077457, 24.580688220070272, 54.952064126111509, 25.675321478647909, 55.88891241048259, 26.85870878521834, 56.796176012190699, 28.130850139781529, 57.683716492108942, 29.501607103225581, 58.551533850259148, 48.021618451052603, 58.85724223779107, 46.877677388034527, 59.833536765712779, 45.674566959687951, 60.819692854522145, 44.441871848677089, 61.815710504219169, 43.150007372337733, 62.821589714796573, 41.818696652446022, 63.837330486283463, 40.438078128113858, 64.862932818643458, 39.008151799341277, 65.908258272771491, 38.810920581579524, 66.046320125213242, 37.489471422575889, 67.042337774910266, 36.227191628900783, 68.028493863712356, 35.043804322330381, 68.994926830746408, 33.93930950286466, 69.961359797773184, 32.893984048727447, 70.927792764807236, 31.927551081694961, 71.87450261007325, 31.020287479990969, 72.811350894429779, 30.19191636539168, 73.74819917880086, 29.432576177009, 74.675185902277008, 28.742266914842901, 75.59231106488005, 28.130850139781529, 76.499574666580884, 27.588464290936741, 77.446284511832346, 27.085524685644319, 78.600087135739159, 26.691062250120861, 79.852505368529819, 26.405076984366332, 81.193677649309393, 26.23743044926886, 82.623603978077881, 26.188122644828439, 84.142284354842559, 26.197984205716519, 84.704393325468118, 26.316322936373549, 86.075150288910663, 26.572723519463811, 87.386737887027266, 26.957324394099199, 88.649017680698307, 27.479987121167799, 89.842266548163025, 28.140711700669609, 90.976346050287248, 28.929636571716571, 92.061117747980461, 29.85662329519673, 93.086720080340456, 30.211639487167851, 93.431874711423006, 31.247103380416942, 94.319415191348526, 32.341736638994597, 95.059032257959188, 33.495539262900742, 95.670449033023033, 34.708511252135423, 96.153665516532783, 35.990514167586703, 96.488958586727676, 37.321824887478421, 96.696051365383028, 38.722166533586751, 96.765082291596627, 49.086667026965983, 97.060929118240892, 47.962449085724067, 97.701930575960432, 46.788923340041741, 98.254177985698334, 45.566089789918998, 98.727532908327703, 44.29394843535578, 99.102272222080501, 42.972499276352153, 99.407980609597871, 41.601742312908101, 99.615073388253222, 40.19153910591168, 99.743273679800041, 38.722166533586751, 99.792581484238326],
     ],

168: [ [37.356685666087003, 96.398064678593073, 36.340139101619741, 96.341062067491293, 35.086081657604041, 96.084550317580579, 33.908027695043842, 95.628529428846377, 32.815477649121107, 94.963498966113548, 31.808431519835779, 94.08945892938209, 31.124400186736299, 93.329424114817812, 30.411867548091038, 92.255874939262867, 29.90834448344836, 91.106322282248584, 29.60433055762639, 89.861765273410128, 29.49982577062508, 88.541204783126886, 29.556828381716681, 87.572160394556704, 29.803839696447049, 86.308602515367966, 30.259860585180039, 85.140048987988848, 30.93439148309756, 84.056999377251486, 31.808431519835779, 83.059453683148604, 32.568466334390727, 82.384922785233357, 33.642015509949601, 81.672390146581165, 34.791568166963998, 81.159366646759736, 36.036125175797743, 80.855352720936935, 37.356685666087003, 80.760348369120038, 38.363731795372331, 80.817350980207266, 39.627289674569937, 81.07386273011798, 40.805343637130129, 81.529883618852182, 41.897893683052899, 82.194914081592287, 42.90493981233822, 83.059453683148604, 43.512967663982181, 83.743485016253544, 44.225500302627466, 84.798033321436378, 44.729023367270109, 85.957086413640354, 45.033037293092107, 87.201643422471534, 45.137542080093418, 88.541204783126886, 45.090039904183719, 89.51974960687221, 44.843028589453382, 90.792807921243366, 44.39650813590233, 91.970861883812177, 43.750478543530619, 93.072912364907097, 42.90493981233822, 94.08945892938209, 42.144904997783243, 94.773490262472478, 41.071355822224369, 95.486022901117394, 39.912302730028053, 95.989545965770958, 38.677246156376242, 96.3030603267689, 37.356685666087003, 96.398064678593073],
       [11.91452024885964, 96.398064678593073, 10.94547586030205, 96.350562502680987, 9.6819179811044194, 96.094050752762996, 8.513364453726183, 95.638029864028795, 7.4303148429853527, 94.963498966113548, 6.4327691488819587, 94.08945892938209, 5.7582382509644381, 93.329424114817812, 5.0457056123191526, 92.255874939262867, 4.5326821124945686, 91.106322282248584, 4.2286681866725644, 89.861765273410128, 4.1241633996712599, 88.541204783126886, 4.181166010762893, 87.572160394556704, 4.4376777606752, 86.308602515367966, 4.8936986494081793, 85.140048987988848, 5.558729112143765, 84.056999377251486, 6.4327691488819587, 83.059453683148604, 7.1928039634369147, 82.384922785233357, 8.2663531389958091, 81.672390146581165, 9.4254062311921416, 81.159366646759736, 10.66046280484394, 80.855352720936935, 11.981023295133181, 80.760348369120038, 12.92156637814494, 80.807850545032125, 14.17562382216064, 81.064362294942839, 15.34417734953891, 81.520383183669765, 16.446227830643611, 82.18541364640987, 17.46277439511087, 83.059453683148604, 18.108803987482592, 83.77198632179352, 18.84033749649171, 84.82653462698363, 19.353360996316319, 85.976087283997913, 19.66687535732024, 87.211143857661227, 19.77138014432154, 88.541204783126886, 19.714377533229928, 89.51974960687221, 19.46736621849956, 90.792807921243366, 19.020845764948518, 91.970861883812177, 18.3748161725768, 93.072912364907097, 17.538777876566339, 94.08945892938209, 16.721740450919778, 94.811492003202147, 15.64819127536089, 95.505023771489505, 14.489138183164551, 95.999046400953375, 13.24458117433082, 96.3030603267689, 11.91452024885964, 96.398064678593073],
     ],

169: [ [81.397026173665466, 32.45179630027269, 80.582292079026217, 31.375929482986976, 79.642214277519429, 30.22694550336746, 78.681245858201351, 29.151078686089022, 77.678496203260735, 28.137883722236438, 76.644410621603242, 27.187360611831537, 75.578989113228857, 26.299509354852489, 74.492676987043211, 25.484775260207243, 73.364583625235042, 24.732713019002404, 72.205154336709967, 24.043322631230694, 71.014389121468014, 23.427049405800062, 69.802733288414771, 22.863002724901889, 68.549296219739034, 22.372073206330242, 67.264523224346391, 21.954260850106948, 65.948414302236841, 21.588675038408837, 64.600969453410414, 21.296206389051804, 63.222188677867081, 21.066409593127901, 61.822517284512521, 20.909729959552351, 60.38106465553539, 20.805276870487432, 58.908276099841373, 20.773940943770867, 72.967661886821048, 20.554589456747635, 74.116645866440479, 21.243979844519345, 75.234293919343031, 21.99604208573146, 76.320606045528677, 22.789885562553536, 77.386027553903062, 23.635955583922623, 78.420113135560555, 24.544697458710289, 79.433308099406787, 25.495220569107914, 80.415167136536127, 26.508415532960498, 81.365690246948546, 27.573837041338265, 82.295322739549761, 28.691485094241216, 83.193619305434027, 29.86135969166935, 84.060579944601443, 31.083460833629942, 81.397026173665466, 32.45179630027269],
       [73.949520923950388, 78.651397589870612, 58.18754978535285, 78.599171045352705, 58.438237199087972, 78.588725736437482, 59.963252299310142, 78.536499191912299, 61.456931472815398, 78.400710176138091, 74.97316119670225, 78.526053882997076, 73.949520923950388, 78.651397589870612],
       [81.397026173665466, 81.764099643747613, 78.514120915711231, 81.764099643747613, 78.399222517749308, 81.502966921107145, 77.668050894355105, 80.01973305651336, 76.926433962055285, 79.173663035151549, 76.383277898962461, 78.818522532361385, 74.97316119670225, 78.526053882997076, 61.456931472815398, 78.400710176138091, 62.898384101792509, 78.191803998022806, 64.298055495147111, 77.888890039757825, 65.666390961784799, 77.512858919159044, 66.982499883894334, 77.053265327311237, 68.246382261475731, 76.52055457312963, 69.478928712340206, 75.893836038791051, 70.659248618676543, 75.194000342111394, 71.808232598295973, 74.410602174182713, 72.675193237463361, 73.710766477510333, 73.636161656781439, 72.833360529431957, 74.555348840476995, 71.872392110119108, 75.422309479644383, 70.848751837373129, 76.226598265377973, 69.74154909337085, 76.989105815489069, 68.561229187027493, 77.699386821072011, 67.318237427272834, 78.357441282126757, 65.991683196247322, 78.963269198653393, 64.592011802902562, 79.516870570651832, 63.119223247202171, 80.018245398122133, 61.583762838068651, 82.838478802642584, 61.583762838068651, 81.397026173665466, 81.764099643747613],
       [58.981393262180802, 81.837216806088691, 57.425042235241762, 81.816326188280073, 55.900027135019592, 81.743209025938995, 54.395902652608697, 81.617865319072735, 52.923114096914681, 81.450740376581962, 51.481661467937549, 81.231388889573282, 50.061099456771728, 80.95981085801759, 48.67187337232275, 80.646451590851939, 47.313983214590699, 80.280865779161104, 45.976983674669889, 79.873498731831205, 44.671320061465991, 79.403459831082728, 43.396992374978993, 78.891639694702462, 42.154000615208872, 78.338038322712237, 40.931899473250013, 77.732210406167724, 39.741134258008032, 77.074155945119855, 38.57125966057734, 76.363874939539528, 37.432720989863533, 75.611812698341964, 36.325518245866618, 74.807523912597389, 35.249651428586617, 73.951008582327631, 34.194675229117848, 73.052712016462465, 33.171034956365993, 72.102188906043011, 32.408527406254912, 71.339681355930225, 31.4057777513143, 70.263814538651786, 30.45525464090187, 69.167057103557454, 29.55695807501758, 68.049409050647228, 28.721333362567069, 66.900425071042264, 27.948380503550371, 65.730550473606854, 27.227654189061809, 64.539785258362826, 26.569599728007042, 63.328129425310181, 25.963771811480431, 62.095582974448917, 25.410170439481959, 60.831700596856535, 24.929686229822948, 59.546927601470088, 24.490983255786428, 58.241263988267747, 24.12539744408932, 56.914709757256787, 23.801592868014751, 55.567264908429934, 23.54046014537397, 54.188484132886515, 23.34199927616698, 52.788812739527202, 23.19576495148814, 51.368250728366547, 23.112202480243099, 49.926798099382722, 23.080866553526189, 48.454009543689608, 23.112202480243099, 47.15879123940249, 23.185319642582531, 45.706893301510718, 23.33155396726136, 44.265440672526893, 23.53001483646835, 42.865769279182132, 23.791147559109131, 41.476543194730766, 24.1149521351837, 40.129098345896637, 24.490983255786428, 38.79209880597773, 24.929686229822948, 37.486435192782665, 25.431061057293249, 36.212107506289613, 25.984662429291689, 34.948225128711783, 26.611380963629561, 33.72612398675119, 27.27988073358998, 32.514468153698544, 28.0214976658898, 31.334148247362464, 28.815341142717759, 30.185164267742948, 29.671856472979531, 29.057070905932051, 30.59104365667508, 27.949868161937047, 31.562457384898781, 26.874001344658609, 32.596542966556292, 25.819025145188789, 33.23370680979977, 25.202751919758157, 34.278237700362887, 24.26267411824665, 35.354104517642917, 23.364377552366932, 36.461307261639831, 22.528752839913068, 37.589400623448, 21.745354671991663, 38.748829911973083, 21.014183048602717, 39.939595127215028, 20.335237969731679, 41.161696269173888, 19.718964744301047, 42.404688028944001, 19.154918063402874, 43.679015715431028, 18.632652618121938, 44.984679328634932, 18.173059026266856, 46.321678868555722, 17.776137287859456, 47.679569026287787, 17.420996785062016, 49.068795110736737, 17.128528135712259, 50.4893571219026, 16.877840721972461, 51.941255059785327, 16.68982516167307, 53.414043615479358, 16.554036145891587, 54.918168097890259, 16.470473674649838, 56.453628507018038, 16.44958305684122, 57.059456423544638, 16.44958305684122, 58.532244979238669, 16.501809601366404, 59.98414291712141, 16.60626269041677, 61.404704928287252, 16.752497015098925, 62.804376321641847, 16.961403193221486, 64.172711788279543, 17.232981224762625, 65.509711328200325, 17.546340491928277, 66.825820250309874, 17.911926303626387, 68.110593245702503, 18.340183968757628, 69.364030314378255, 18.810222869520658, 70.596576765242759, 19.342933623702265, 71.797787289390357, 19.927870922423608, 72.967661886821048, 20.554589456747635, 58.908276099841373, 20.773940943770867, 57.748846811316326, 20.794831561579485, 56.244722328905432, 20.888839341729181, 54.782379082117039, 21.066409593127901, 53.36181707095119, 21.317097006860422, 51.98303629540785, 21.640901582941297, 50.656482064392691, 22.048268630256644, 49.37170906900004, 22.528752839913068, 48.12871730922992, 23.08235421191057, 46.92750678508235, 23.719518055157096, 45.778522805462899, 24.429799060737423, 44.671320061465991, 25.223642537566775, 43.605898553091599, 26.090603176737204, 42.582258280339737, 27.030680978241435, 41.610844552116049, 28.054321250987414, 40.942344782155629, 28.827274110008148, 40.232063776572708, 29.756906602611707, 39.563564006612332, 30.749210948648397, 38.936845472274427, 31.79374183921027, 38.362353482464727, 32.900944583212549, 37.82964272827752, 34.060373871732736, 37.349158518618481, 35.272029704792658, 36.910455544581971, 36.546357391271158, 36.523979115073622, 37.872911622289394, 36.179283921187789, 39.262137706733483, 35.876369962924493, 40.703590335717308, 35.625682549189321, 42.197269509219041, 35.416776371076708, 43.753620536161179, 35.26009673749224, 45.372643416529172, 35.14519833953031, 47.043892841429624, 35.072081177190881, 48.767368810862536, 35.05119055937962, 50.553516633721301, 35.061635868285236, 51.399586655083112, 35.113862412813411, 52.882820519676898, 35.218315501869711, 54.345163766469341, 35.36454982654854, 55.786616395453166, 35.573456004661182, 57.207178406621097, 35.824143418396318, 58.617295108866529, 36.137502685565273, 59.996075884417223, 36.492643188356737, 61.364411351052695, 36.597096277413051, 61.750887780559424, 37.0880257959777, 63.317684116402233, 37.620736550164906, 64.780027363187401, 38.184783231068991, 66.137917520922201, 38.780165838689982, 67.391354589599359, 39.417329681933467, 68.540338569218875, 40.096274760799503, 69.584869459780748, 40.117165378610757, 69.616205386497313, 40.99457132668379, 70.744298748308211, 41.934649128190607, 71.809720256693254, 42.947844092036831, 72.812469911623339, 44.023710909316861, 73.742102404226898, 45.172694888936292, 74.609063043390051, 46.384350721989513, 75.41335182912735, 47.658678408476533, 76.144523452523572, 48.389850031870708, 76.510109264207131, 49.65373240945209, 77.063710636219184, 50.969841331561639, 77.533749536967662, 52.317286180388074, 77.909780657566444, 53.716957573742661, 78.2126946158387, 55.158410202719772, 78.421600793946709, 56.652089376225028, 78.54694450081297, 58.18754978535285, 78.599171045352705, 73.949520923950388, 78.651397589870612, 72.309607425766274, 79.100545872817747, 71.150178137241198, 79.487022302331752, 69.384920932189516, 80.051068983229925, 67.839015214156092, 80.531553192893625, 66.512460983140926, 80.918029622393078, 65.405258239144018, 81.210498271750112, 64.527852291070985, 81.40895914095745, 63.493766709413499, 81.576084083448222, 62.135876551681442, 81.722318408130377, 60.631752069270533, 81.805880879372125, 58.981393262180802, 81.837216806088691],
       [36.419526026017309, 96.011500991029607, 35.061635868285236, 95.426563692322816, 33.703745710553193, 94.810290466877632, 32.356300861726773, 94.141790696921817, 31.00885601290031, 93.441955000249436, 30.987965395089049, 93.431509691341489, 29.71363770860205, 92.72122868574661, 28.47064594883193, 91.969166444549046, 27.258990115778719, 91.196213585542864, 26.078670209442379, 90.391924799798289, 24.919240920917311, 89.556300087351701, 23.801592868014751, 88.678894139280601, 22.704835432923488, 87.780597573393607, 21.6394139245491, 86.850965080790047, 20.6053283428916, 85.889996661477198, 19.602578687950992, 84.897692315440509, 18.6311649597273, 83.874052042687254, 17.680641849314839, 82.819075843217433, 16.771899974524931, 81.732763717031048, 15.88404871754628, 80.615115664128098, 15.02753338728451, 79.466131684508582, 14.20235398373964, 78.285811778172501, 13.40851050691168, 77.074155945119855, 12.646002956800601, 75.831164185350644, 11.91483133340639, 74.556836498857592, 11.39256588812483, 73.606313388452691, 10.69273019144754, 72.279759157427179, 10.04512103929841, 70.942759617522825, 9.4392931227718009, 69.616205386497313, 8.8648011329620715, 68.268760537677736, 8.3320903787748932, 66.921315688850882, 7.8307155513045918, 65.573870840016752, 7.3815672683624314, 64.215980682289228, 6.9637549121371762, 62.84764521564648, 6.5877237915344722, 61.479309749011009, 6.2534739065542624, 60.10052897346759, 5.9610052571965753, 58.721748197916895, 5.6998725345557943, 57.332522113480081, 5.4909663564431801, 55.943296029028716, 5.3133961050474454, 54.543624635676679, 5.1671617803686161, 53.143953242317366, 5.073154000217925, 51.723391231156711, 5.0104821467841409, 50.313274528896727, 4.9895915289728796, 48.892712517728796, 5.0000368378785254, 48.109314349807391, 5.041818073501048, 46.688752338639461, 5.1253805447460934, 45.26819032747153, 5.2402789427080441, 43.858073625211546, 5.3969585762924899, 42.458402231859509, 5.5954194454994868, 41.058730838507472, 5.8356615503290072, 39.659059445148159, 6.1176848907810486, 38.280278669597465, 6.4310441579499971, 36.891052585160651, 6.7861846607414691, 35.522717118517903, 7.1831063991554336, 34.154381651882431, 7.6218093731919501, 32.796491494147631, 8.0918482739453736, 31.438601336420106, 8.6036684103212906, 30.091156487593253, 9.1572697823197586, 28.743711638766399, 9.7526523899407191, 27.406712098847493, 10.389816233184231, 26.080157867829257, 11.05831600314462, 24.753603636818298, 11.76859700872757, 23.437494714708009, 12.45798739649922, 22.246729499471257, 13.21004963770468, 21.003737739702046, 14.003893114532641, 19.792081906642125, 14.81862720917189, 18.61176200031332, 15.66469723052802, 17.462778020686528, 16.55254848750667, 16.334684658882907, 17.46129036229658, 15.248372532689245, 18.401368163803401, 14.193396333219425, 19.37278189202712, 13.159310751572775, 20.36508623806208, 12.167006405528809, 21.39917181971958, 11.195592677308014, 22.45414801918832, 10.255514875796507, 23.550905454279619, 9.3467730010088417, 24.668553507182171, 8.4798123618384125, 25.817537486801601, 7.6337423404911533, 26.997857393137942, 6.8190082458531833, 28.209513226191149, 6.0251647690165555, 29.452504985961269, 5.2731025278117158, 30.726832672448271, 4.5523762133234413, 31.374441824597429, 4.1867904016326065, 32.690550746706947, 3.4974000138608972, 34.017104977722113, 2.849790861706424, 35.343659208737279, 2.233517636283068, 36.68065874865809, 1.6590256464623963, 38.028103597484517, 1.1263148922735127, 39.375548446310937, 0.6249400648084702, 40.733438604043009, 0.17579178186133504, 42.091328761775081, -0.24202057436195901, 43.459664228412777, -0.61805169496074086, 44.838445003956082, -0.95230157994228648, 46.22767108840506, -1.255215538199991, 47.61689717285401, -1.5163482608477352, 49.00612325730296, -1.7252544389630202, 50.416239959563171, -1.9028246903471882, 51.826356661823411, -2.0490590150293428, 53.236473364083622, -2.1430667951935902, 54.667480684155088, -2.2057386486194446, 56.098488004226567, -2.2266292664280627, 56.871440863243294, -2.2161839575273916, 58.29200287440915, -2.1744027219028794, 59.712564885574999, -2.1012855595618021, 61.12268158783521, -1.9759418527028174, 62.532798290095421, -1.8192622191127157, 63.932469683450023, -1.6208013498981018, 65.321695767898973, -1.3805592450735276, 66.710921852347923, -1.0985359046171652, 68.089702627891256, -0.78517663745151367, 69.458038094528945, -0.43003613466134993, 70.826373561166633, -0.033114396239398047, 72.184263718898706, 0.40558857779251412, 73.542153876630778, 0.87562747854099143, 74.889598725457205, 1.3874476149212569, 76.226598265377973, 1.9410489869187586, 56.098488004226567, 2.1708457828426617, 54.782379082117039, 2.1917364006512798, 53.36181707095119, 2.2544082540771342, 51.941255059785327, 2.3588613431420526, 50.531138357525123, 2.5050956678169314, 49.131466964170528, 2.6931112281308742, 47.742240879721571, 2.9333533329481725, 46.353014795272628, 3.2153766734118108, 44.974234019729302, 3.5287359405701864, 43.605898553091599, 3.8943217522682971, 42.23756308645391, 4.3016887995909201, 40.879672928721853, 4.7612823914387263, 39.532228079895418, 5.2522119100103737, 38.195228539974607, 5.7849226641919813, 36.858229000053832, 6.3698599629133241, 35.521229460133021, 6.9965784972519032, 34.2051205380235, 7.6650782672004425, 32.889011615913951, 8.3753592727880459, 32.533871113122473, 8.5738201420026598, 31.280434044446739, 9.3154370742922765, 30.04788759358226, 10.08838993331301, 28.857122378340279, 10.90312402795098, 27.6976930898152, 11.738748740397568, 26.569599728007042, 12.616154688468669, 25.483287601821392, 13.524896563270886, 24.417866093447, 14.464974364767841, 23.394225820695141, 15.436388092988636, 22.401921474660181, 16.439137747933273, 21.44095305534211, 17.48366863848787, 20.521765871646551, 18.559535455773585, 19.62346930576226, 19.656292890867917, 18.766953975500481, 20.794831561579485, 17.941774571955619, 21.964706159007619, 17.14793109512766, 23.165916683159594, 16.385423545016579, 24.408908442928805, 15.66469723052802, 25.672790820506634, 15.00664276947324, 26.884446653566556, 14.327697690607209, 28.211000884577516, 13.700979156269341, 29.537555115603027, 13.11604185755399, 30.874554655521933, 12.58333110336679, 32.221999504341511, 12.08195627589649, 33.569444353168365, 11.62236268404874, 34.927334510903165, 11.2149956367291, 36.295669977538637, 10.84940982503201, 37.664005444181385, 10.525605248957451, 39.042786219717527, 10.2435819085054, 40.432012304168893, 10.00333980367588, 41.821238388612983, 9.8048789344688885, 43.220909781972296, 9.6586446097900591, 44.631026484232279, 9.554191520733724, 46.041143186499539, 9.4810743583943236, 47.461705197660194, 9.4601837405830622, 48.892712517728796, 9.4601837405830622, 49.00761091568711, 9.49151966729994, 50.428172926862317, 9.554191520733724, 51.848734938022972, 9.6690899186956756, 53.258851640290231, 9.8153242433745032, 54.658523033642268, 10.0137851125815, 56.058194426987029, 10.25402721741102, 57.447420511438395, 10.53605055786306, 58.836646595889761, 10.87030044284327, 60.204982062517956, 11.235886254540359, 61.583762838068651, 11.64325330186, 62.941652995810728, 12.102846893707749, 64.309988462438923, 12.60422172117805, 65.657433311273053, 13.136932475365249, 67.004878160099906, 13.7218697740806, 68.341877700011537, 14.348588308418471, 69.678877239937719, 15.01708807837889, 71.005431470948679, 15.737814392867451, 72.321540393058967, 15.98850180660258, 72.781133984906774, 16.74056404780805, 74.034571053576656, 17.523962215730389, 75.256672195551801, 18.33869631036961, 76.447437410781276, 19.18476633172574, 77.606866699308739, 20.072617588704421, 78.734960061119637, 20.981359463494329, 79.821272187313298, 21.931882573906758, 80.876248386768566, 22.903296302130489, 81.899888659521821, 23.916491265976699, 82.881747696650564, 24.96102215653983, 83.832270807062741, 26.03688897381986, 84.751457990758354, 27.144091717816771, 85.639309247737401, 28.282630388530581, 86.485379269091936, 29.462950294866889, 87.310558672637853, 30.66416081901448, 88.093956840559258, 31.907152578784611, 88.835573772863427, 33.171034956365993, 89.556300087351701, 34.090222140061542, 90.036784297008126, 35.427221679982352, 90.715729375879164, 36.785111837714403, 91.342447910210467, 38.132556686540831, 91.92738520893181, 39.490446844272903, 92.470541272021364, 40.848337002004968, 92.971916099500959, 42.216672468642649, 93.431509691341489, 43.585007935280338, 93.849322047572059, 44.953343401918033, 94.214907859262894, 46.33212417746136, 94.538712435336492, 47.721350261910317, 94.820735775792855, 49.10013103745365, 95.060977880617429, 50.4893571219026, 95.259438749817491, 51.889028515257188, 95.416118383407593, 53.288699908611761, 95.520571472472511, 54.688371301966363, 95.583243325898366, 56.098488004226567, 95.604133943706984, 36.419526026017309, 96.011500991029607],
       [56.098488004226567, 100.00160899299226, 55.764238119246379, 100.00160899299226, 54.364566725891791, 99.98071837516909, 52.95445002363158, 99.907601212828013, 51.56522393918263, 99.803148123777646, 50.165552545828042, 99.656913799102767, 48.776326461379078, 99.468898238803376, 47.3871003769301, 99.239101442872197, 46.008319601386802, 98.977968720231729, 44.629538825843461, 98.664609453058802, 43.250758050300128, 98.319914259176585, 41.87197727475683, 97.943883138570527, 40.503641808119113, 97.515625473439286, 39.135306341481432, 97.05603188159148, 37.777416183749381, 96.554657054126437, 36.419526026017309, 96.011500991029607, 56.098488004226567, 95.604133943706984, 57.12212827697843, 95.593688634813589, 58.532244979238669, 95.541462090281129, 59.931916372593228, 95.447454310131434, 61.33158776594783, 95.311665294357226, 62.731259159302432, 95.123649734050559, 64.110039934845759, 94.893852938126656, 65.499266019294694, 94.632720215493464, 66.878046794838042, 94.319360948320536, 68.256827570381347, 93.964220445530373, 69.625163037019036, 93.55685339820775, 70.993498503656753, 93.118150424168562, 72.351388661388796, 92.627220905611466, 73.709278819120868, 92.104955460323254, 75.056723667947296, 91.530463470517134, 76.404168516773723, 90.914190245086502, 77.75161336560015, 90.256135784031358, 79.088612905520961, 89.556300087351701, 79.537761188463094, 89.30561267361918, 80.801643566044476, 88.574441050222958, 82.023744708003335, 87.811933500110172, 83.224955232150947, 87.01809002328082, 84.384384520675994, 86.192910619742179, 85.512477882484177, 85.32594998057175, 86.609235317575454, 84.427653414692031, 87.674656825949839, 83.498020922088472, 88.708742407607318, 82.537052502768347, 89.701046753642316, 81.534302847816434, 90.672460481866025, 80.500217266169784, 91.602092974467183, 79.434795757792017, 92.510834849257108, 78.338038322712237, 93.37779548842451, 77.199499651993392, 94.213420200875007, 76.029625054557982, 95.017708986608611, 74.828414530413284, 95.790661845625337, 73.595868079552019, 96.532278777925157, 72.321540393058967, 96.584505322453296, 72.217087304001325, 97.294786328036224, 70.890533072990365, 97.963286097996644, 69.56397884197213, 98.590004632334484, 68.23742461096117, 99.164496622144213, 66.889979762127041, 99.707652685237036, 65.542534913307463, 100.19858220380171, 64.19509006448061, 100.6477304867438, 62.837199906753085, 101.05509753406341, 61.468864440110337, 101.42068334576049, 60.10052897346759, 101.7444879218351, 58.721748197916895, 102.0265112622872, 57.332522113480081, 102.256308058211, 55.943296029028716, 102.454768927418, 54.543624635676679, 102.6010032520969, 53.143953242317366, 102.7159016500588, 51.733836540057382, 102.77857350349259, 50.313274528896727, 102.7994641213039, 48.892712517728796, 102.77857350349259, 47.597494213427126, 102.7159016500588, 46.176932202266471, 102.62189386990811, 44.766815500006487, 102.47565954522931, 43.356698797746503, 102.287643984928, 41.946582095486519, 102.04740188009841, 40.55735601104243, 101.77582384855199, 39.168129926591064, 101.4624645813831, 37.789349151040369, 101.096878769686, 36.41056837549695, 100.69995703127201, 35.042232908861479, 100.2508087483299, 33.684342751126678, 99.759879229765204, 32.336897902299825, 99.227168475578011, 30.989453053480247, 98.652676485768282, 29.652453513561341, 98.036403260336044, 28.315453973642434, 97.378348799281284, 26.988899742616923, 96.668067793698356, 25.672790820506634, 96.459161615585742, 25.286314390999905, 95.707099374380277, 24.032877322322747, 94.934146515363565, 22.81077618036943, 94.129857729629947, 21.620010965132678, 93.283787708273834, 20.46058167659794, 92.416827069106418, 19.332488314787042, 91.508085194316507, 18.235730879699986, 90.568007392809704, 17.180754680230166, 89.596593664585995, 16.146669098583516, 88.593844009645395, 15.15436475253955, 87.549313119082285, 14.193396333219425, 86.483891610707886, 13.263763840630418, 85.376688866710964, 12.365467274743423, 84.248595504902795, 11.498506635572994, 83.078720907472103, 10.673327232027077, 81.877510383324505, 9.8690384462897782, 80.644963932460016, 9.1065308961769915, 79.370636245973003, 8.3753592727880459, 78.096308559485976, 7.6859688850236125, 76.76975432847081, 7.0174691150605213, 75.443200097455644, 6.3907505807219422, 74.095755248629217, 5.8162585909085465, 72.74831039980279, 5.2731025278117158, 71.400865550976363, 4.7821730092473445, 70.042975393244291, 4.3225794173995382, 68.674639926606602, 3.9152123700769152, 67.306304459968914, 3.5496265583933564, 65.92752368442558, 3.2258219822979299, 64.53829759997663, 2.9437986418633955, 63.14907151552768, 2.7140018459322164, 61.749400122173093, 2.5155409767176025, 60.349728728818491, 2.3693066520499997, 58.939612026558279, 2.2544082540771342, 57.519050015392423, 2.1917364006512798, 56.098488004226567, 2.1708457828426617, 76.226598265377973, 1.9410489869187586, 77.563597805298798, 2.5364315945334965, 78.900597345219609, 3.1735954377800226, 80.216706267329116, 3.8420952077431139, 81.532815189438679, 4.5523762133234413, 82.734025713586277, 5.2313212921872037, 83.977017473356355, 5.9833835333920433, 85.188673306409612, 6.7667817013207241, 86.368993212745934, 7.5815157959586941, 87.517977192365379, 8.4171405084125581, 88.646070554173548, 9.2945464564909344, 89.732382680359194, 10.203288331271324, 90.797804188733593, 11.132920823882159, 91.831889770391086, 12.104334552102955, 92.834639425331687, 13.096638898132369, 93.806053153555382, 14.1202791708929, 94.746130955062185, 15.185700679263391, 95.654872829852124, 16.272012805449776, 96.542724086830773, 17.389660858352727, 97.3887941081869, 18.53864483795769, 98.21397351173178, 19.718964744301047, 98.997371679654123, 20.930620577360969, 99.759879229765204, 22.173612337122904, 100.49105085315939, 23.437494714708009, 100.8879725915734, 24.15822102920356, 101.577362979345, 25.474329951306572, 102.2249721314941, 26.800884182317532, 102.83080004802081, 28.137883722236438, 103.40529203783051, 29.474883262162621, 103.9380027920177, 30.822328110989474, 104.4289323105823, 32.180218268716999, 104.8885259024301, 33.538108426451799, 105.2958929497497, 34.895998584179324, 105.6719240703525, 36.274779359722743, 106.0061739553327, 37.643114826372766, 106.2986426046903, 39.03234091080958, 106.5597753273311, 40.421566995260946, 106.7791268143494, 41.821238388612983, 106.9566970657451, 43.220909781972296, 107.0924860815183, 44.631026484232279, 107.18649386166901, 46.041143186499539, 107.24916571510281, 47.461705197660194, 107.270056332914, 48.892712517728796, 107.25961102400839, 49.895462172673433, 107.2073844794803, 51.316024183826812, 107.12382200823519, 52.726140886101348, 106.9984783013676, 54.136257588361332, 106.83135335887749, 55.535928981720645, 106.6328924896705, 56.935600375072681, 106.39265038484101, 58.324826459516771, 106.11062704438901, 59.70360723506019, 105.7868224683144, 61.082388010603609, 105.4212366566173, 62.461168786147027, 105.0243149182033, 63.829504252782499, 104.5856119441668, 65.187394410510024, 104.1051277345078, 66.545284568237548, 103.5933075981319, 67.892729417071678, 103.0397062261334, 69.240174265898531, 102.4443236185124, 70.577173805817438, 101.8071597752689, 71.903728036842949, 101.12821469640291, 73.240727576747304, 100.41793369081989, 74.556836498857592, 100.3865977641031, 74.619508352297998, 99.644980831803252, 75.883390729883104, 98.87202797278654, 77.126382489652315, 98.067739187052936, 78.338038322712237, 97.242559783508071, 79.50791292014037, 96.375599144340669, 80.65689689975261, 95.487747887362005, 81.774544952662836, 94.568560703666449, 82.860857078841946, 93.618037593254016, 83.905387969411095, 92.646623865030307, 84.929028242157074, 91.633428901184089, 85.921332588186488, 90.599343319526596, 86.882301007506612, 89.533921811152211, 87.811933500110172, 88.43716437606092, 88.710230065997166, 87.309071014252751, 89.577190705160319, 86.160087034633321, 90.412815417621459, 84.97976712829697, 91.217104203351482, 83.757665986338154, 91.990057062372216, 82.525119535473635, 92.731673994661833, 81.250791848986637, 93.441955000249436, 80.86431541947826, 93.650861178357445, 79.527315879557477, 94.329806257221207, 78.17987103073105, 94.977415409382957, 76.821980872998978, 95.593688634813589, 75.474536024172551, 96.157735315711761, 74.116645866440479, 96.690446069900645, 72.74831039980279, 97.181375588472292, 71.379974933165101, 97.630523871412151, 70.011639466527413, 98.04833622762817, 68.643303999889724, 98.413922039333556, 67.264523224346391, 98.748171924307826, 65.875297139897441, 99.040640573657583, 64.496516364354108, 99.301773296312604, 63.096844970999513, 99.510679474420613, 61.707618886550563, 99.688249725812057, 60.307947493195961, 99.834484050486935, 58.908276099841373, 99.928491830651183, 57.508604706486807, 99.991163684077037, 56.098488004226567, 100.00160899299226],
     ],

170: 63,

171: [ [69.209599063817876, 67.348810948249593, 65.03455576620847, 67.348810948249593, 36.629676038368082, 33.456210554119025, 65.03455576620847, -0.57312706590892049, 69.209599063817876, -0.57312706590892049, 51.698118333015117, 33.456210554119025, 69.209599063817876, 67.348810948249593],
       [36.629676038368082, 67.348810948249593, 32.527559261240953, 67.348810948249593, 4.6331651767763731, 33.456210554119025, 32.527559261240953, -0.57312706590892049, 36.629676038368082, -0.57312706590892049, 19.045268787083071, 33.456210554119025, 36.629676038368082, 67.348810948249593],
     ],

172: [ [80.458514848206534, 63.311369180490146, 2.618570048453932, 63.311369180490146, 2.618570048453932, 57.468131726847787, 74.761130435529935, 57.468131726847787, 74.761130435529935, 34.040487021920853, 80.458514848206534, 34.040487021920853, 80.458514848206534, 63.311369180490146],
     ],

173: [ [6.0005374358187558, 38.571970470147789, 43.26598940225378, 38.571970470147789, 43.26598940225378, 27.687687288176676, 6.0005374358187558, 27.687687288176676, 6.0005374358187558, 38.571970470147789, 6.0005374358187558, 38.571970470147789],
     ],

174: [ [61.069176214985561, 48.16267221749149, 50.403672594455003, 47.159932560862217, 71.588826794551622, 17.952861107718491, 84.852337707262706, 17.952861107718491, 84.852337707262706, 20.332088838447817, 84.615326515695358, 20.359436283630203, 83.202375181351556, 20.578215845082013, 82.008203408454563, 20.933732632431202, 81.032811197004307, 21.416870830631524, 80.513209738568236, 21.790619248102303, 79.711018013263356, 22.474305377618293, 78.87236302771737, 23.303844548099732, 77.988128966869965, 24.279236759561172, 77.076547460841709, 25.409597827027028, 76.128502694572319, 26.676696120412089, 61.069176214985561, 48.16267221749149],
       [69.391915365023522, 77.205658999548177, 50.97796894325279, 77.150964109190681, 51.214980134820138, 77.141848294129886, 52.564120763741947, 77.078037588697043, 53.858566502302061, 76.923068732678075, 55.098317350500508, 76.676941726058431, 56.283373308337246, 76.330540753762762, 57.422850190872559, 75.883865815812896, 58.498516367985893, 75.35514854232315, 59.528603469797822, 74.726157303157379, 60.503995681248057, 73.996892098330136, 61.424693002336603, 73.185584557970287, 62.071915871616653, 72.501898428447021, 62.874107596921498, 71.535622032046376, 63.557793726442704, 70.514650745302788, 64.141205890300796, 69.448100383247947, 64.615228273435477, 68.335970945896406, 64.988976690907066, 67.169146618180093, 65.25333532765525, 65.956743215159804, 65.408304183680059, 64.689644921782019, 65.462999074041747, 63.376967553100258, 65.426535813800626, 62.438038601896551, 65.271566957775804, 61.161824493457971, 64.988976690907066, 59.940305275376886, 64.578765013194342, 58.773480947660573, 64.040931924637675, 57.661351510309032, 63.375477425237051, 56.603916963307711, 63.311666719815058, 56.512758812707034, 62.573285699932192, 55.564714046442532, 61.725514899325901, 54.680479985603597, 60.786585948116823, 53.878288260289992, 59.756498846304879, 53.149023055462749, 58.61702196376956, 52.492684371129144, 57.395502745691722, 51.918388022328145, 56.611542650507403, 51.617566125336452, 55.68172951435858, 51.334975858473626, 54.660758227606948, 51.079733036778634, 53.548628790252472, 50.860953475341375, 52.33622538723489, 50.678637174132746, 51.041779648674783, 50.523668318106502, 49.647059944451541, 50.405162722330715, 48.161182089625491, 50.323120386783557, 46.593261899256902, 50.268425496418786, 44.925067743225178, 50.25930968135799, 66.775676442722443, 50.095225010270951, 67.951616585498883, 50.642173913889565, 69.054630207793068, 51.216470262683288, 70.075601494544713, 51.827229871727468, 71.023646260814104, 52.474452741007553, 71.889648691540941, 53.139907240409229, 72.682724601785523, 53.841825000046811, 73.393758176487566, 54.580206019927573, 73.721927518657736, 54.963070252459147, 74.505887613842035, 55.974925724156492, 75.180457928302943, 57.032360271150537, 75.763870092161014, 58.117142263319693, 76.228776660235425, 59.256619145860896, 76.59340926264673, 60.423443473569932, 76.857767899394929, 61.635846876590222, 77.012736755419724, 62.884713539846416, 77.067431645781426, 64.170043463353068, 77.049200015660858, 64.871961222990649, 76.948926049997752, 66.111712071193324, 76.748378118671539, 67.305883844092023, 76.447556221682206, 68.47270817180106, 76.04646035902978, 69.593953424220672, 75.545090530714234, 70.687851231450622, 74.952562551795879, 71.745285778451944, 74.259760607214403, 72.775372880263603, 73.466684696969821, 73.759880906756734, 72.582450636122417, 74.717041488096584, 71.588826794551622, 75.637738809193252, 71.178615116838898, 75.975023966420849, 70.312612686112061, 76.613131020632864, 69.391915365023522, 77.205658999548177],
       [55.663497884238012, 80.323267750172818, 27.842030320255731, 80.323267750172818, 27.842030320255731, 77.725260457977129, 29.063549538333572, 77.688797197748499, 30.45826924255681, 77.533828341722256, 31.588630310031849, 77.260353889920225, 32.45463274075869, 76.859258027259784, 32.98335001425508, 76.421698904370714, 33.73996266425852, 75.455422507977346, 34.259564122694627, 74.261250735078647, 34.323374828116613, 73.768996721832082, 34.38718553353857, 72.8756468459178, 34.432764608839989, 71.608548552540014, 34.46011205402084, 69.985933471813041, 34.469227869081131, 67.989569973608013, 34.469227869081131, 30.286558884268743, 34.469227869081131, 29.694030905360705, 34.441880423900272, 27.843520448121126, 34.378069718478287, 26.302947702926758, 34.277795752815187, 25.081428484860226, 34.141058526910939, 24.169846978817077, 33.967858040765577, 23.577318999909039, 33.639688698595421, 22.920980315568158, 32.88307604859196, 21.936472289060475, 31.880336391960899, 21.198091269172437, 31.050797221475172, 20.833458666762454, 29.94778359918098, 20.559984214960423, 28.58952715519888, 20.386783728819864, 26.976027889528869, 20.332088838447817, 26.976027889528869, 17.952861107718491, 53.430123194468791, 17.952861107718491, 53.430123194468791, 20.332088838447817, 53.0654905920575, 20.341204653508612, 51.369948990844961, 20.395899543873384, 49.920534396260017, 20.532636769778037, 48.708130993242428, 20.742300516161777, 47.741854596852498, 21.043122413153469, 47.012589392029888, 21.416870830631524, 46.693535864919987, 21.644766207129578, 45.882228324554852, 22.492537007739884, 45.289700345636497, 23.568203184848244, 44.925067743225178, 24.880880553530005, 44.925067743225178, 47.159932560862217, 50.403672594455003, 47.159932560862217, 61.069176214985561, 48.16267221749149, 61.278839961372057, 48.217367107863538, 62.773833631258412, 48.645810415691813, 64.186784965602186, 49.092485353641678, 65.517693964403449, 49.575623551842, 66.775676442722443, 50.095225010270951, 44.925067743225178, 50.25930968135799, 44.925067743225178, 75.99325559654244, 46.064544625760497, 76.367004014013219, 47.368106179380902, 76.704289171240816, 48.616972842639619, 76.950416177860461, 49.820260430596903, 77.096269218818634, 50.97796894325279, 77.150964109190681, 69.391915365023522, 77.205658999548177, 68.416523153573294, 77.743492088113271, 67.386436051761365, 78.235746101367113, 66.301654059587733, 78.673305224263459, 65.162177177052413, 79.056169456787757, 63.968005404155399, 79.39345461402263, 62.71913874089671, 79.676044880892732, 61.415577187276313, 79.903940257398062, 60.057320743294213, 80.086256558599416, 58.653485224010687, 80.21387796945055, 57.185838999305211, 80.295920304990432, 55.663497884238012, 80.323267750172818],
       [35.781905237761812, 95.738111017111805, 34.587733464864783, 95.209393743607507, 33.39356169196779, 94.65332902494265, 32.199389919070768, 94.060801046012784, 31.01433396123403, 93.440925621922361, 30.421805982315671, 93.112756279748282, 29.30967654496121, 92.474649225521716, 28.215778737727309, 91.809194726127316, 27.149228375674259, 91.11639278155053, 26.100909643741751, 90.405359206837602, 25.079938356990109, 89.66697818695684, 24.086314515419311, 88.901249721886416, 23.11092230396909, 88.117289626708953, 22.15376172263942, 87.305982086341828, 21.223948586490589, 86.467327100799594, 20.321482895522621, 85.610440485143044, 19.4463646497355, 84.726206424282282, 18.580362219008659, 83.814624918260961, 17.75082304852296, 82.884811782110773, 16.9395155081578, 81.9276512007782, 16.146439597913229, 80.952258989331312, 15.38982694790977, 79.940403517641244, 14.64233011296659, 78.910316415822308, 13.92218072320429, 77.861997683889058, 13.22937877862282, 76.777215691719903, 12.56392427922219, 75.674202069421881, 11.91670140994213, 74.552956817009544, 11.78907999909816, 74.334177255572286, 11.16008875993867, 73.167352927848697, 10.55844496596003, 71.991412785071589, 9.9841486171622194, 70.815472642301756, 9.4463155286055667, 69.639532499517372, 8.9358298852297366, 68.454476541679469, 8.4618075020950414, 67.26030476878077, 8.0151325641411972, 66.066132995889348, 7.5958050713682042, 64.871961222990649, 7.212940838836345, 63.668673635031155, 6.8574240514853102, 62.465386047071661, 6.5383705243754369, 61.252982644058648, 6.2375486273861043, 60.031463425977563, 5.9823058056981893, 58.809944207896478, 5.7452946141308407, 57.58842498982267, 5.5447466828046279, 56.357789956688066, 5.3806620117195498, 55.127154923553462, 5.2439247858152953, 53.887404075350787, 5.1345350050919194, 52.638537412087317, 5.0524926695493662, 51.398786563891917, 5.0069135942479468, 50.140804085582204, 4.9886819641274078, 48.882821607250662, 5.0069135942479468, 47.643070759062539, 5.0524926695493662, 46.385088280738273, 5.1345350050919194, 45.136221617482079, 5.2348089707550107, 43.887354954218608, 5.371546196659267, 42.647604106023209, 5.5447466828046279, 41.407853257820534, 5.7452946141308407, 40.177218224693206, 5.9731899906379047, 38.946583191536774, 6.2375486273861043, 37.725063973470242, 6.5292547093151541, 36.503544755389157, 6.8483082364250256, 35.29114135238342, 7.2038250237760622, 34.08785376441665, 7.5866892563079196, 32.884566176457156, 8.0060167490809135, 31.681278588497662, 8.443575871974474, 30.496222630667035, 8.9267140701694512, 29.302050857768336, 9.4280838984849993, 28.116994899930432, 9.9659169870416502, 26.9410547571606, 10.54021333583947, 25.765114614383492, 11.141857129818099, 24.598290286659903, 11.770848368977591, 23.44058177399711, 12.04432282078608, 22.948327760750544, 12.700661505126419, 21.836198323399003, 13.37523181958732, 20.742300516161777, 14.077149579229079, 19.675750154106936, 14.797298968991409, 18.636547237241757, 15.54479580393456, 17.615575950483617, 16.319640084058591, 16.621952108922414, 17.112715994303159, 15.646559897460975, 17.933139349728599, 14.698515131196473, 18.780910150334869, 13.777817810107081, 19.646912581061709, 12.875352119139279, 20.531146641909121, 12.000233873346588, 21.44272814793737, 11.143347257682763, 22.38165709914648, 10.313808087201323, 23.338817680476161, 9.51161636190227, 24.323325706986651, 8.7276562667102553, 25.335181178678031, 7.9710436167079024, 26.36526828048995, 7.2417784118806594, 27.422702827482709, 6.5307448371822829, 28.498369004596071, 5.8470587076590164, 29.60138262689026, 5.1816042082573404, 30.722627879305008, 4.5434971540380502, 31.80740987147863, 3.9600849901908077, 32.974234199194797, 3.3493253811393515, 34.141058526910939, 2.7841448474064237, 35.316998669687401, 2.2371959437878104, 36.492938812463848, 1.7267103004123783, 56.09194119207131, 2.1642694233087241, 55.90050907580536, 2.1642694233087241, 54.642526597486381, 2.1916168684911099, 53.384544119167401, 2.2463117588486057, 52.135677455908677, 2.3374699094492826, 50.895926607710258, 2.4559755052323453, 49.656175759511818, 2.6200601763193845, 48.42554072637369, 2.8114922925888095, 47.19490569323554, 3.0302718540333444, 45.973386475157689, 3.2946304907818558, 44.751867257079823, 3.586336572712753, 43.539463854062262, 3.9145059148795553, 42.33617626610495, 4.2700227022287436, 41.132888678147651, 4.662002749821113, 39.938716905250658, 5.0904460576566635, 38.75366094741392, 5.5553526257281192, 37.568604989577182, 6.0476066389892367, 36.392664846800727, 6.5763239124789834, 35.216724704024301, 7.1415044462191872, 34.04990037630813, 7.7340324251417769, 32.88307604859196, 8.3721394793610671, 32.272316439553038, 8.71854045164946, 31.160187002198569, 9.383994951051136, 30.075405010024951, 10.067681080567127, 29.01797046303216, 10.778714655272779, 27.987883361220241, 11.517095675153541, 26.985143704589149, 12.28282414021669, 26.009751493138939, 13.075900050462224, 25.052590911809261, 13.887207590829348, 24.131893590720718, 14.725862576371583, 23.22942789975275, 15.591865007110755, 22.354309653965629, 16.485214883010485, 21.506538853359359, 17.405912204099877, 20.68611549793394, 18.34484115531086, 19.893039587689341, 19.320233366757748, 19.11819530756534, 20.313857208333502, 18.37981428768245, 21.33482849507709, 17.65966489792012, 22.38314722701034, 16.966862953338651, 23.449697589072457, 16.30140845393802, 24.552711211363203, 15.66330139971825, 25.673956463782815, 15.56302743405513, 25.84715694993065, 14.93403619489564, 27.004865462578891, 14.350624031037571, 28.180805605348723, 13.78544349730004, 29.34762993305776, 13.26584203886395, 30.53268589090294, 12.77358802560869, 31.717741848740843, 12.317797272594561, 32.902797806578747, 11.898469779821561, 34.106085394538241, 11.50648973222939, 35.300257167429663, 11.15097294487839, 36.512660570449953, 10.831919417768489, 37.725063973470242, 10.54021333583947, 38.946583191536774, 10.29408632921184, 40.168102409632411, 10.066190952704771, 41.398737442759739, 9.8838746514991271, 42.629372475901619, 9.7289057954743043, 43.869123324097018, 9.6104001996906447, 45.117989987360488, 9.5283578641480915, 46.366856650616683, 9.4827787888467014, 47.624839128940948, 9.4645471587261341, 48.882821607250662, 9.4645471587261341, 49.302149100018141, 9.4918946039069567, 50.560131578342407, 9.5557053093289426, 51.808998241613153, 9.6468634599317795, 53.057864904862072, 9.7744848707757228, 54.297615753072023, 9.9385695418608009, 55.537366601260146, 10.13000165812676, 56.768001634402026, 10.367012849694101, 57.989520852483111, 10.622255671381989, 59.211040070556919, 10.923077568371321, 60.432559288630728, 11.251246910541511, 61.644962691651017, 11.6158795129528, 62.848250279603235, 12.01697537560522, 64.051537867570005, 12.445418683438501, 65.245709640461428, 12.91032525151291, 66.439881413360126, 13.40257926476818, 67.62493737119803, 13.940412353324859, 68.800877513967862, 14.50559288706236, 69.976817656752246, 15.09812086598072, 71.152757799522078, 15.73622792020052, 72.319582127238391, 16.146439597913229, 73.039731517012115, 16.81189409731385, 74.14274513930286, 17.504696041895329, 75.227527131479292, 18.224845431657631, 76.284961678473337, 18.972342266600801, 77.315048780277721, 19.73807073166455, 78.308672621853475, 20.531146641909121, 79.284064833293087, 21.351569997334568, 80.232109599572141, 22.199340797940842, 81.161922735707776, 23.065343228667668, 82.055272611622058, 23.96780891963564, 82.921275042346679, 24.88850624072418, 83.769045842956984, 25.83655100699357, 84.580353383316833, 26.80282740338351, 85.373429293562367, 27.805567060014599, 86.130041943571996, 28.826538346766231, 86.868422963452758, 29.874857078698739, 87.579456538151135, 30.950523255812069, 88.263142667681677, 32.053536878106257, 88.919481352022558, 33.17478213052101, 89.548472591181053, 34.213985047393209, 90.09542149479239, 35.399041005229947, 90.687949473707704, 36.593212778126968, 91.253130007447908, 37.787384551023962, 91.781847280937654, 38.981556323920991, 92.274101294198772, 40.184843911878261, 92.729892047209432, 41.388131499835559, 93.158335355037707, 42.600534902853148, 93.550315402637352, 43.812938305870709, 93.90583218998654, 45.025341708888298, 94.224885717099824, 46.237745111905859, 94.516591799030721, 47.459264329983732, 94.771834620718437, 48.680783548061612, 94.990614182170248, 49.91141858119974, 95.182046298439673, 51.14205361433789, 95.327899339390569, 52.372688647476018, 95.446404935180908, 53.612439495674458, 95.537563085781585, 54.852190343872877, 95.583142161078285, 56.09194119207131, 95.601373791199876, 35.781905237761812, 95.738111017111805],
       [56.09194119207131, 100.00431246531662, 55.307981096886998, 99.995196650263097, 54.0682302486886, 99.958733390019916, 52.828479400490153, 99.894922684601624, 51.588728552291741, 99.794648718932876, 50.358093519153577, 99.667027308089018, 49.127458486015449, 99.51205845207005, 47.905939267937583, 99.320626335800625, 46.675304234799448, 99.101846774348815, 45.453785016721582, 98.855719767721894, 44.241381613703993, 98.573129500851792, 43.019862395626149, 98.26319178880658, 41.807458992608552, 97.916790816510911, 40.595055589590999, 97.543042399040132, 39.3917680016337, 97.132830721333448, 38.188480413676388, 96.704387413497898, 36.98519282571911, 96.230365030358371, 35.781905237761812, 95.738111017111805, 56.09194119207131, 95.601373791199876, 57.25876551978746, 95.592257976139081, 58.498516367985893, 95.537563085781585, 59.738267216184312, 95.455520750241703, 60.978018064382752, 95.34613096951216, 62.20865309752088, 95.19116211347864, 63.439288130659037, 95.008845812291838, 64.660807348736896, 94.790066250840027, 65.882326566814754, 94.543939244213107, 67.103845784892613, 94.252233162282209, 68.316249187910174, 93.933179635168926, 69.528652590927763, 93.586778662880533, 70.731940178885054, 93.194798615288164, 71.93522776684236, 92.775471122513409, 73.138515354799651, 92.319680369502748, 74.332687127696659, 91.836542171302426, 75.52685890059368, 91.316940712873475, 76.721030673490688, 90.76087599418679, 77.906086631327412, 90.168348015271476, 79.082026774103866, 89.548472591181053, 79.811291978926462, 89.147376728520612, 80.914305601220647, 88.500153859240527, 81.999087593394265, 87.825583544778056, 83.056522140387045, 87.123665785140474, 84.086609242198975, 86.403516395381303, 85.098464713890337, 85.646903745371674, 86.082972740400848, 84.87205946524773, 87.031017506670224, 84.060751924880606, 87.969946457879331, 83.231212754399166, 88.872412148847289, 82.36521032366727, 89.747530394634424, 81.480976262821059, 90.604417010300978, 80.569394756792462, 91.433956180786694, 79.630465805588756, 92.23614790609156, 78.664189409202663, 93.020108001275858, 77.670565567626909, 93.767604836219036, 76.65871009593684, 94.496870041041632, 75.610391364010866, 95.198787800683391, 74.543841001948749, 95.873358115144299, 73.440827379658003, 96.52969679948464, 72.319582127238391, 96.739360545871136, 71.936717894706817, 97.359235969970356, 70.760777751929709, 97.951763948888711, 69.593953424220672, 98.498712852505676, 68.418013281443564, 99.018314310941776, 67.232957323612936, 99.510568324197024, 66.047901365767757, 99.957243262150897, 64.853729592869058, 100.3856865699841, 63.650442004909564, 100.768550802516, 62.447154416957346, 101.124067589867, 61.243866828997852, 101.4340053019166, 60.031463425977563, 101.72571138384571, 58.809944207896478, 101.97183839047329, 57.58842498982267, 102.1906179519201, 56.357789956688066, 102.382050068186, 55.127154923553462, 102.5279031091505, 53.887404075350787, 102.6464087049342, 52.647653227148112, 102.7284510404767, 51.398786563891917, 102.7831459308384, 50.140804085582204, 102.801377560959, 48.882821607250662, 102.801377560959, 48.727852751231694, 102.7740301157781, 47.460754457846633, 102.7193352254165, 46.202771979529643, 102.6372928898739, 44.953905316273449, 102.50967147903, 43.705038653009979, 102.3547026230052, 42.465287804821855, 102.17238632179949, 41.234652771679976, 101.9444909452924, 40.004017738538096, 101.6892481236045, 38.773382705403492, 101.40665785673581, 37.560979302390479, 101.07848851456561, 36.339460084302118, 100.7229717272146, 35.1361724963499, 100.3309916796224, 33.932884908390406, 99.911664186849464, 32.738713135491707, 99.455873433835336, 31.544541362593009, 98.963619420580073, 30.359485404762381, 98.444017962143974, 29.183545261992549, 97.88795324346674, 28.007605119208165, 97.295425264548371, 26.831664976431057, 96.675549840449165, 25.673956463782815, 96.301801422977576, 25.017617779427383, 95.636346923576951, 23.914604157136637, 94.95266079405576, 22.829822164967482, 94.241627219353717, 21.772387617973436, 93.503246199470837, 20.742300516161777, 92.737517734407106, 19.739560859532503, 91.953557639222808, 18.764168648078339, 91.142250098857659, 17.807008066753042, 90.294479298251375, 16.886310745656374, 89.437592682584821, 15.983845054703124, 88.544242806677119, 15.108726808910433, 87.623545485588593, 14.251840193239332, 86.684616534379487, 13.431416837818688, 85.718340137989557, 12.629225112512358, 84.724716296418748, 11.854380832388415, 83.703745009667117, 11.106883997439581, 82.664542092794903, 10.38673460768041, 81.588875915681555, 9.6848168480428285, 80.494978108447654, 9.0102465335803572, 79.373732856032902, 8.3721394793610671, 79.136721664465554, 8.2354022534564137, 77.969897336749398, 7.6155268293514382, 76.803073009033227, 7.0321146654969198, 75.627132866256787, 6.4760499468175112, 74.442076908420049, 5.9564484883812838, 73.257020950583325, 5.4641944751274423, 72.062849177686303, 5.0084037221167819, 70.859561589729012, 4.5890762293420266, 69.65627400177172, 4.2062119968104525, 68.452986413814429, 3.8506952094612643, 67.240583010796854, 3.5316416823479813, 66.019063792718981, 3.2490514154778793, 64.797544574641122, 2.9938085937901633, 63.56690954150298, 2.7750290323529043, 62.336274508364852, 2.5927127311369986, 61.096523660166412, 2.4377438751107547, 59.856772811967993, 2.319238279327692, 58.607906148709283, 2.2371959437878104, 57.349923670390297, 2.1825010534230387, 56.09194119207131, 2.1642694233087241, 36.492938812463848, 1.7267103004123783, 37.677994770300593, 1.2526879172801273, 38.872166543197579, 0.79689716426219093, 40.066338316094601, 0.38668548654823098, 41.269625904051907, -0.005294561036862433, 42.472913492009177, -0.36081134839332663, 43.685316895026773, -0.67986487549933372, 44.90683611310461, -0.9806867724910262, 46.12835533118249, -1.2359295941787423, 47.349874549260363, -1.4729407857375918, 48.589625397458782, -1.6734887170678121, 49.82937624565718, -1.8466892032083706, 51.069127093855627, -1.9834264291202999, 52.317993757114323, -2.0928162098425673, 53.566860420373047, -2.1657427303289296, 54.83395871375231, -2.211321805632906, 56.09194119207131, -2.2295534357472206, 57.340807855330013, -2.211321805632906, 58.589674518588708, -2.1657427303289296, 59.847656996907723, -2.0928162098425673, 61.096523660166412, -1.9834264291202999, 62.336274508364852, -1.8466892032083706, 63.56690954150298, -1.6826045321286074, 64.806660389701406, -1.4820566007983871, 66.028179607779265, -1.2450454092395375, 67.249698825857124, -0.98980258755182149, 68.471218043934996, -0.69809650562092429, 69.683621446952571, -0.36992716344684595, 70.886909034909863, -0.014410376097657718, 72.090196622867154, 0.36845385642664041, 73.293484210824445, 0.77866553414060036, 74.478540168661183, 1.2253404720977414, 75.672711941558191, 1.6993628552299924, 76.857767899394929, 2.2098484986127005, 78.033708042171369, 2.7476815871705185, 79.20053236988754, 3.3128621209034463, 80.376472512663966, 3.9145059148795553, 81.534181025319853, 4.5434971540380502, 82.026435038575144, 4.8169716058473568, 83.138564475929584, 5.4641944751274423, 84.232462283163485, 6.1387647895899136, 85.299012645216536, 6.8315667341812514, 86.338215562088763, 7.5517161239331472, 87.359186848840395, 8.2992129588674288, 88.361926505471487, 9.064941423937853, 89.328202901861431, 9.858017334190663, 90.285363483191105, 10.669324874550512, 91.206060804279645, 11.507979860100022, 92.108526495247617, 12.373982290831918, 92.992760556095007, 13.258216351670853, 93.849647171761575, 14.16979785769945, 94.679186342247277, 15.099610993849637, 95.490493882612427, 16.065887390243006, 96.274453977796725, 17.041279601689894, 97.040182442860456, 18.053135073379963, 97.77856346274335, 19.083222175191622, 98.489597037445407, 20.131540907132148, 99.182398982026854, 21.207207084240508, 99.847853481427478, 22.310220706531254, 100.49507635070751, 23.44058177399711, 101.1149517748067, 24.580058656538313, 101.71659556878539, 25.755998799322697, 102.2817761025229, 26.922823127031734, 102.81960919107961, 28.107879084869637, 103.33009483445539, 29.283819227646745, 103.8041172175901, 30.477991000538168, 104.25079215554391, 31.672162773436867, 104.6701196483169, 32.866334546342841, 105.0529838808488, 34.069622134302335, 105.40850066819981, 35.272909722247277, 105.72755419530969, 36.485313125267567, 106.0192602772387, 37.706832343348651, 106.2836189139869, 38.92835156142246, 106.51151429049401, 40.158986594557064, 106.7120622218202, 41.389621627698943, 106.88526270796559, 42.629372475901619, 107.02199993386979, 43.869123324097018, 107.1313897145932, 45.117989987360488, 107.2043162350755, 46.366856650616683, 107.2498953103769, 47.624839128940948, 107.2681269404974, 48.882821607250662, 107.2681269404974, 49.092485353641678, 107.2498953103769, 50.350467831958667, 107.1952004200152, 51.608450310282933, 107.1131580844727, 52.857316973539128, 107.0037683037493, 54.097067821727251, 106.8579152627847, 55.336818669937202, 106.6847147766394, 56.567453703071806, 106.4841668453131, 57.79808873620641, 106.24715565374581, 59.028723769348289, 105.98279701699759, 60.250242987429374, 105.6910909350686, 61.462646390449663, 105.3629215928984, 62.675049793462676, 105.0074048055474, 63.887453196482966, 104.6154247579552, 65.09074078444246, 104.1960972651822, 66.284912557326606, 103.7494223272284, 67.479084330232581, 103.27539994409371, 68.67325610313128, 102.7649143007179, 69.858312060961907, 102.2270812121612, 71.034252203739015, 101.65278486336339, 72.210192346523399, 101.0511410693847, 73.386132489300508, 100.42214983022529, 74.552956817009544, 100.057517227814, 75.181948056168039, 99.392062728413364, 76.294077493526856, 98.708376598892187, 77.378859485703288, 97.988227209129846, 78.445409847750852, 97.25896200430725, 79.484612764630583, 96.502349354303789, 80.