##############################################################################
# ThanCad 0.9.1 "Students2024": n-dimensional CAD with raster support for engineers
#
# Copyright (C) 2001-2025 Thanasis Stamos, May 20, 2025
# Athens, Greece, Europe
# URL: http://thancad.sourceforge.net
# e-mail: cyberthanasis@gmx.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (www.gnu.org/licenses/gpl.html).
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##############################################################################
"""\
ThanCad 0.9.1 "Students2024": n-dimensional CAD with raster support for engineers

This module defines ThanCad fonts made by straight lines.
"""
from .thanfont import ThanFont, ThanFontLine, thanFonts

def makePrime1Lines():
    """Makes the lines that define each character of fixed width line font Prime1.

    Prime1 is a font which defines a letter as a set of straight line segments.
    Each letter fits into a 6x9 units rectangle with left lower xy coordinates
    0,-2 and right upper 6,7 (xy). All the letters are less than 6 units wide (x)
    and most letters less than 5 units wide, thus leaving some space between the
    letters of the same word.
    All capital letters and most of the small letters are within the 0 to 7 y-range.
    Small letters like p,q,y use the full y-range: -2 to 7
    """
    dilines = \
{ 1 : [ [ 2,2,2,4,0,4,0,0,4,0,4,4,2,4,2,2 ]                       # undefined
      ],
  2 : [ [ 2,2,2,4,1,4,0,3,0,1,1,0,3,0,4,1,4,3,3,4,2,4,2,2 ]       # undefined
      ],
  3 : [ [ 2,2,2,4,0,1,4,1,2,4,2,2 ]                               # undefined
      ],
  4 : [ [ 2,2,4,2,0,2,2,2,2,0,2,4,2,2 ]                           # undefined
      ],
  5 : [ [ 2,2,4,4,0,0,2,2,0,4,4,0,2,2 ]                           # undefined
      ],
  6 : [ [ 2,2,2,4,0,2,2,0,4,2,2,4,2,2 ]                           # undefined
      ],
  7 : [ [ 2,2,2,0,2,4,0,2,4,2,2,4,2,2 ]                           # undefined
      ],
  8 : [ [ 2,2,0,0,4,4,0,4,4,0,2,2 ]                               # undefined
      ],
  9 : [ [ 2,2,4,4,0,4,4,4,0,0,4,0,0,0,2,2 ]                       # undefined
      ],
 10 : [ [ 2,2,0,4,2,2,4,4,2,2,2,0,2,2 ]                           # undefined
      ],
 11 : [ [ 2,2,4,4,3,3,1,3,0,4,1,3,1,1,0,0,1,1,3,1,4,0,3,1,3,3,2,2 ]       # undefined
      ],
 12 : [ [ 2,2,4,2,0,2,2,2,2,0,2,4,2,2,4,4,0,0,2,2,0,4,4,0,2,2 ]   # undefined
      ],
 13 : [ [ 2,2,4,4,0,4,4,0,0,0,2,2 ]                               # undefined
      ],
 14 : [ [ 2,2,2,0,2,4,2,2 ]                                       # undefined
      ],
 15 : [ [ 1,0,3,6,5,0,0,4,6,4,1,0 ]                               # undefined
      ],
 16 : [ [ 2,2,6,2,2,2 ]                                           # undefined
      ],
 17 : [                                                           # undefined
      ],
 20 : [                                                           # undefined
      ],
 23 : [ [ 0,0,6,0 ]                                               # undefined
      ],
 25 : [ [ 0,7,6,7 ]                                               # undefined
      ],
 31 : [ [ 0,3,4,3,4,2 ]                                           # undefined
      ],
 32 : [                                                           # " "
      ],
 33 : [ [ 1,0,2,1,3,0,1,0 ],
        [ 2,2,2,7 ]                                               # "!"
      ],
 34 : [ [ 2,5,2,7,1,7,2,5 ],
        [ 4,5,4,7,3,7,4,5 ]                                       # """
      ],
 35 : [ [ 0,1,4,1 ],
        [ 4,3,0,3 ],
        [ 1,4,1,0 ],
        [ 3,0,3,4 ]                                               # "#"
      ],
 36 : [ [ 2,7,2,0 ],
        [ 0,2,3,2,4,3,3,4,1,4,0,5,1,6,4,6 ]                       # "$"
      ],
 37 : [ [ 4,1,4,0,3,0,3,1,4,1 ],
        [ 0,0,4,7 ],
        [ 1,7,1,6,0,6,0,7,1,7 ]                                   # "%"
      ],
 38 : [ [ 4,1,3,0,1,0,0,1,0,2,3,6,2,7,1,6,1,5,4,0 ]               # "&"
      ],
 39 : [ [ 4,5,4,7,3,7,4,5 ]                                       # "'"
      ],
 40 : [ [ 4,7,3,6,3,1,4,0 ]                                       # "("
      ],
 41 : [ [ 0,7,1,6,1,1,0,0 ]                                       # ")"
      ],
 42 : [ [ 4,1,0,5,2,3,4,5,0,1,2,3,2,1,2,5,2,3,0,3,4,3 ]           # "*"
      ],
 43 : [ [ 2,1,2,5,2,3,0,3,4,3 ]                                   # "+"
      ],
 44 : [ [ 2,1,1,1,1,2,2,2,2,1,1,0 ]                               # ","
      ],
 45 : [ [ 0,3,4,3 ]                                               # "-"
      ],
 46 : [ [ 1,1,1,0,0,0,0,1,1,1 ]                                   # "."
      ],
 47 : [ [ 0,0,4,7 ]                                               # "/"
      ],
 48 : [ [ 4,6,3,7,1,7,0,6,0,1,1,0,3,0,4,1,4,6 ]                   # "0"
      ],
 49 : [ [ 1,6,2,7,2,0,1,0,3,0 ]                                   # "1"
      ],
 50 : [ [ 0,6,1,7,3,7,4,6,4,4,0,1,0,0,4,0 ]                       # "2"
      ],
 51 : [ [ 0,6, 1,7, 3,7, 4,6, 4,5, 3,4, 1,4 ],
        [ 3,4, 4,3, 4,1, 3,0, 1,0, 0,1 ]                          # "3"
      ],
 52 : [ [ 4,2,0,2,3,7,3,0,2,0,4,0 ]                               # "4"
      ],
 53 : [ [ 4,7,0,7,0,4,3,4,4,3,4,1,3,0,1,0,0,1 ]                   # "5"
      ],
 54 : [ [ 0,3, 1,4, 3,4, 4,3, 4,1, 3,0, 1,0, 0,1, 0,6, 1,7, 3,7, 4,6 ]            # "6"
      ],
 55 : [ [ 0,6,0,7,4,7,4,6,1,1,1,0 ]                               # "7"
      ],
 56 : [ [ 0,6,1,7,3,7,4,6,4,5,3,4,1,4,3,4,4,3,4,1,3,0,1,0,0,1,0,3,1,4,0,5,0,6 ]   # "8"
      ],
 57 : [ [ 4,4,3,3,1,3,0,4,0,6,1,7,3,7,4,6,4,1,3,0,1,0,0,1 ]       # "9"
      ],
 58 : [ [ 2,4,1,4,1,5,2,5,2,4 ],
        [ 2,1,1,1,1,2,2,2,2,1 ]                                   # ":"
      ],
 59 : [ [ 2,4,1,4,1,5,2,5,2,4 ],
        [ 2,1,1,1,1,2,2,2,2,1,1,0 ]                               # ";"
      ],
 60 : [ [ 4,2,0,4,4,6 ]                                           # "<"
      ],
 61 : [ [ 4,4,0,4 ],
        [ 0,2,4,2 ]                                               # "="
      ],
 62 : [ [ 0,2,4,4,0,6 ]                                           # ">"
      ],
 63 : [ [ 1,0,2,1,3,0,1,0 ],
        [ 2,2,2,4,3,4,4,5,4,6,3,7,1,7,0,6 ]                       # "?"
      ],
 64 : [ [ 3,1,1,1,0,2,0,5,1,6,3,6,4,5,4,2,3,3,3,4,2,5,1,4,1,3,2,2,3,3 ]       # "@"
      ],
 65 : [ [ 0,0,0,3,4,3,4,6,3,7,1,7,0,6,0,3,4,3,4,0 ]               # "A"
      ],
 66 : [ [ 4,1,3,0,0,0,0,7,3,7,4,6,4,5,3,4,0,4,3,4,4,3,4,1 ]       # "B"
      ],
 67 : [ [ 4,6,3,7,1,7,0,6,0,1,1,0,3,0,4,1 ]                       # "C"
      ],
 68 : [ [ 3,7,4,6,4,1,3,0,0,0,0,7,3,7 ]                           # "D"
      ],
 69 : [ [ 4,0,0,0,0,7,4,7,0,7,0,4,3,4 ]                           # "E"
      ],
 70 : [ [ 0,0,0,7,4,7,0,7,0,4,3,4 ]                               # "F"
      ],
 71 : [ [ 4,3,4,1,3,0,1,0,0,1,0,6,1,7,3,7,4,6 ],
        [ 3,3,5,3 ]                                               # "G"
      ],
 72 : [ [ 0,0,0,7,0,4,4,4,4,7,4,0 ]                               # "H"
      ],
 73 : [ [ 1,0,3,0,2,0,2,7,1,7,3,7 ]                               # "I"
      ],
 74 : [ [ 0,1,1,0,3,0,4,1,4,7 ]                                   # "J"
      ],
 75 : [ [ 0,7,0,0 ],
        [ 4,0,2,5,0,3,4,7 ]                                       # "K"
      ],
 76 : [ [ 4,0,0,0,0,7 ]                                           # "L"
      ],
 77 : [ [ 4,0,4,7,2,3,0,7,0,0 ]                                   # "M"
      ],
 78 : [ [ 4,7,4,0,0,7,0,0 ]                                       # "N"
      ],
 79 : [ [ 4,6,3,7,1,7,0,6,0,1,1,0,3,0,4,1,4,6 ]                   # "O"
      ],
 80 : [ [ 0,0,0,7,3,7,4,6,4,5,3,4,0,4 ]                           # "P"
      ],
 81 : [ [ 4,6,3,7,1,7,0,6,0,1,1,0,3,0,4,1,4,6],
        [ 4,0,2,2 ]                                               # "Q"
      ],
 82 : [ [ 0,0,0,7,3,7,4,6,4,5,3,4,0,4,3,4,4,3,4,0 ]               # "R"
      ],
 83 : [ [ 4,6,3,7,1,7,0,6,0,5,1,4,3,4,4,3,4,1,3,0,1,0,0,1 ]       # "S"
      ],
 84 : [ [ 4,7,0,7,2,7,2,0 ]                                       # "T"
      ],
 85 : [ [ 0,7,0,1,1,0,3,0,4,1,4,7 ]                               # "U"
      ],
 86 : [ [ 0,7,2,0,4,7 ]                                           # "V"
      ],
 87 : [ [ 4,7,4,0,2,4,0,0,0,7 ]                                   # "W"
      ],
 88 : [ [ 4,7,0,0 ],
        [ 4,0,0,7 ]                                               # "X"
      ],
 89 : [ [ 2,0, 2,4, 0,7, 2,4, 4,7 ]                               # "Υ"
      ],
 90 : [ [ 0,7, 4,7, 0,0, 4,0 ]                                    # "Z"
      ],
 91 : [ [ 4,7,0,7,0,0,4,0 ]                                       # "["
      ],
 92 : [ [ 4,0,0,7 ]                                               # "\"
      ],
 93 : [ [ 0,0,4,0,4,7,0,7 ]                                       # "]"
      ],
 94 : [ [ 0,1,2,5,4,1 ]                                           # "^"
      ],
# 95 : [ [ 0,3,5,3 ]                                               # "_"
 95 : [ [ 0,0,5,0 ]                                               # "_"
      ],
 96 : [ [ 0,0,1,4,1,2,2,1,3,1,4,2,4,4,4,2,5,1 ]                   # "`"
      ],

#---------Small English

 97 : [ [ 1,0, 3,0, 4,1, 4,3, 1,3, 0,2, 0,1, 1,0 ],
        [ 5,0, 4,0, 4,1],
        [ 1,4, 4,4, 4,3 ]                                         # "a"
      ],
 98 : [ [ 0,7, 0,0, 3,0, 4,1, 4,3, 3,4, 0,4 ]                     # "b"
      ],
 99 : [ [ 4,1, 3,0, 1,0, 0,1, 0,3, 1,4, 3,4, 4,3 ]                # "c"
      ],
100 : [ [ 4,7, 4,0, 1,0, 0,1, 0,3, 1,4, 4,4 ]                     # "d"
      ],
101 : [ [ 4,1, 3,0, 1,0, 0,1, 0,3, 1,4, 3,4, 4,3, 4,2, 0,2 ]      # "e"
      ],
102 : [ [ 1,0, 1,6, 2,7, 3,7, 4,6 ],
        [ 0,4, 3,4 ]                                              # "f"
      ],
103 : [ [ 4,1, 3,0, 1,0, 0,1, 0,3, 1,4, 3,4, 4,3, 4,-1, 3,-2, 1,-2, 0,-1 ]  # "g"
      ],
104 : [ [ 0,7, 0,0 ],
        [ 0,3, 1,4, 3,4, 4,3, 4,0 ]                               # "h"
      ],
105 : [ [ 2,0, 2,4 ],
        [ 2,5, 2,6 ]                                              # "i"
      ],
106 : [ [ 3,6, 3,5 ],
        [ 3,4, 3,-1, 2,-2, 0,-1 ]                                 # "j"
      ],
107 : [ [ 0,7, 0,0 ],
        [ 3,4, 0,2, 3,0 ]                                         # "k"
      ],
108 : [ [ 1,7, 2,7, 2,0 ],
        [ 1,0, 3,0 ]                                              # "l"
      ],

#109 : [ [ 0,4, 0,0 ],
#        [ 0,3, 1,4, 2,4, 3,3, 4,4, 5,4, 6,3, 6,0 ],
#      [ 3,3, 3,0 ]                                              # "m"
#      ],
109 : [ [ 0,4, 0,0 ],
        [ 0,3, 1,4, 1.5,4, 2.5,3, 3.5,4, 4,4, 5,3, 5,0 ],
        [ 2.5,3, 2.5,0 ]                                          # "m"
      ],

110 : [ [ 0,4, 0,0 ],
        [ 0,3, 1,4, 3,4, 4,3, 4,0 ]                               # "n"
      ],
111 : [ [ 4,1, 3,0, 1,0, 0,1, 0,3, 1,4, 3,4, 4,3, 4,1 ]           # "o"
      ],
112 : [ [ 0,-2, 0,4 ],
        [ 0,3, 1,4, 3,4, 4,3, 4,1, 3,0, 1,0, 0,1 ]                # "p"
      ],
113 : [ [ 4,-2, 4,4 ],
        [ 4,3, 3,4, 1,4, 0,3, 0,1, 1,0, 3,0, 4,1 ]                # "q"
      ],
114 : [ [ 1,0, 1,4 ],
        [ 1,3, 2,4, 3,4, 4,3 ]                                    # "r"
      ],
115 : [ [ 4,3, 3,4, 1,4, 0,3, 4,1, 3,0, 1,0, 0,1 ]                # "s"
      ],
116 : [ [ 1,6, 1,1, 2,0, 3,0, 4,1 ],
        [ 0,4, 3,4 ]                                              # "t"
      ],
117 : [ [  4,4, 4,0 ],
        [ 4,1, 3,0, 1,0, 0,1, 0,4 ]                               # "u"
      ],
118 : [ [ 0,4, 2,0, 4,4 ]                                         # "v"
      ],
119 : [ [0,4, 1,0, 2,2, 3,0, 4,4 ]                                # "w"
      ],
120 : [ [ 0,4, 4,0 ],
        [ 0,0, 4,4 ]                                              # "x"
      ],
121 : [ [ 0,4, 2,0 ],
        [ 4,4, 1,-2 ]                                             # "y"
      ],
122 : [ [ 0,4, 4,4, 0,0, 4,0 ]                                    # "z"
      ],
123 : [ [ 5,0,4,0,3,1,3,3,2,4,3,5,3,7,4,8,5,8 ]                   # "{"
      ],
124 : [ [ 0,0,0,8 ]                                               # "|"
      ],
125 : [ [ 1,0,2,0,3,1,3,3,4,4,3,5,3,7,2,8,1,8 ]                   # "}"
      ],
126 : [ [ 0,1,1,2,2,2,4,0,5,0,6,1 ]                               # "~"
      ],
127 : [ [ 6,3,5,2,4,2,3,3,3,4,2,5,1,5,0,4,0,3,1,2,2,2,3,3,3,4,4,5,5,5,6,4,6,3 ] # undefined (infinity)
      ],

128 : [ [ 5,7, 4,7, 2,6, 1,4, 1,3, 2,1, 4,0, 5,0 ],
        [ 0,4, 4,4 ],
        [ 0,3, 4,3 ]                                              # Euro
      ],


162 : [ [ 3,0,3,6 ],
        [ 5,4,4,5,2,5,1,4,1,2,2,1,4,1,5,2 ]                       # CENT SIGN
      ],
177 : [ [ 0,1,4,1 ],
        [ 2,2,2,6,2,4,0,4,4,4 ]                                   # PLUS-MINUS SIGN
      ],
183 : [ [ 2,3, 3,3, 3,4, 2,4, 2,3 ]                               # "·" (MIDDLE DOT)
      ],
187 : [ [ 0,4, 2,2, 0,0 ],
        [ 2,4, 4,2, 2,0 ]                                         # "»" (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK)
      ],
189 : [ [ 0,5, 1,6, 1,3 ],
        [ 0,2, 4,4 ],
        [ 2,2, 3,3, 4,2, 2,0, 4,0 ]                               # "½" (VULGAR FRACTION ONE HALF)
      ],

215 : [ [ 0,5, 4,1 ],
        [ 0,1, 4,5 ]                                              # "times" multiplication symbol
      ],


255 : [ [ 0,0, 4,0,  4,4, 0,4, 0,0 ]                              # undefined (quadrilateral)
      ],


#---------Not defined

902 : [ [ 0,0, 0,3, 4,3, 4,5, 3,7, 1,7, 0,5, 0,3, 4,3, 4,0 ],
        [ 0,7, 0,6 ]                                              # "Ά" (iso88597-7: 162)
      ],
904 : [ [ 5,0, 1,0, 1,7, 5,7, 1,7, 1,4, 4,4 ],
        [ 0,7, 0,6 ]                                              # "Έ" (iso88597-7: 184)
      ],
905 : [ [ 1,0, 1,7, 1,4, 5,4, 5,7, 5,0 ],
        [ 0,7, 0,6 ]                                              # "Ή" (iso88597-7: 185)
      ],
906 : [ [ 1,0, 3,0, 2,0, 2,7, 1,7, 3,7 ],
        [ 0,7, 0,6 ],                                             # "Ί" (iso88597-7: 186)
      ],
908 : [ [ 4,5, 3,7, 1,7, 0,5, 0,2, 1,0, 3,0, 4,2, 4,5 ],
        [ 0,7, 0,6 ]                                              # "Ό" (iso88597-7: 188)
      ],
910 : [ [ 2,0, 2,4, 0,7, 2,4, 4,7 ],
        [0,6, 0,5 ]                                               # "Ύ" (iso88597-7: 190)
      ],
911 : [ [ 0,0, 1,0, 1,1, 0,2, 0,5, 1,7, 3,7, 4,5, 4,2, 3,1, 3,0, 4,0 ],
        [ 0,7, 0,6 ]                                              # "Ώ" (iso88597-7: 191)
      ],
912 : [ [ 1,4, 1,1, 2,0, 3,1 ],
        [ 0,5, 0,4 ],
        [ 2,5, 2,4 ],
        [ 1,6, 1,5 ]                                              # "ΐ" (iso88597-7: 192)
      ],
#-----Greek capital

913 : [ [ 0,0,0,3,4,3,4,6,3,7,1,7,0,6,0,3,4,3,4,0 ]               # "Α" (iso88597-7: 193)
      ],
914 : [ [ 4,1,3,0,0,0,0,7,3,7,4,6,4,5,3,4,0,4,3,4,4,3,4,1 ]       # "Β" (iso88597-7: 194)
      ],
915 : [ [ 0,0,0,7,4,7 ]                                           # "Γ" (iso88597-7: 195)
      ],
916 : [ [ 0,0,2,7,4,0,0,0 ]                                       # "Δ" (iso88597-7: 196)
      ],
917 : [ [ 4,0,0,0,0,7,4,7,0,7,0,4,3,4 ]                           # "Ε" (iso88597-7: 197)
      ],
918 : 90,                                                         # "Ζ" (iso88597-7: 198)
919 : [ [ 0,0,0,7,0,4,4,4,4,7,4,0 ]                               # "Η" (iso88597-7: 199)
      ],
920 : [ [ 0,4,0,6,1,7,3,7,4,6,4,1,3,0,1,0,0,1,0,4,4,4 ]           # "Θ" (iso88597-7: 200)
      ],
921 : [ [ 1,0,3,0,2,0,2,7,1,7,3,7 ]                               # "Ι" (iso88597-7: 201)
      ],
922 : [ [ 0,7,0,0 ],
        [ 4,0,2,5,0,3,4,7 ]                                       # "Κ" (iso88597-7: 202)
      ],
923 : [ [ 0,0,2,7,4,0 ]                                           # "Λ" (iso88597-7: 203)
      ],
924 : [ [ 4,0,4,7,2,3,0,7,0,0 ]                                   # "Μ" (iso88597-7: 204)
      ],
925 : [ [ 4,7,4,0,0,7,0,0 ]                                       # "Ν" (iso88597-7: 205)
      ],
926 : [ [ 0,7,4,7 ],
        [ 1,4,3,4 ],
        [ 0,0,4,0 ]                                               # "Ξ" (iso88597-7: 206)
      ],
927 : [ [ 4,6,3,7,1,7,0,6,0,1,1,0,3,0,4,1,4,6 ]                   # "Ο" (iso88597-7: 207)
      ],
928 : [ [ 0,0,0,7,4,7,4,0 ]                                       # "Π" (iso88597-7: 208)
      ],
929 : [ [ 0,0,0,7,3,7,4,6,4,5,3,4,0,4 ]                           # "Ρ" (iso88597-7: 209)
      ],
931 : [ [ 5,0,1,0,3,4,1,7,5,7 ]                                   # "Σ" (iso88597-7: 211)
      ],
932 : [ [ 4,7,0,7,2,7,2,0 ]                                       # "Τ" (iso88597-7: 212)
      ],
933 : 89,                                                         # "Υ" (iso88597-7: 213)
934 : [ [ 1,1,0,2,0,5,1,6,3,6,4,5,4,2,3,1,1,1 ],
        [ 2,7,2,0 ]                                               # "Φ" (iso88597-7: 214)
      ],
935 : [ [ 4,7,0,0 ],
        [ 4,0,0,7 ]                                               # "Χ" (iso88597-7: 215)
      ],
936 : [ [ 0,7,0,3,1,2,3,2,4,3,4,7 ],
        [ 2,7,2,0 ]                                               # "Ψ" (iso88597-7: 216)
      ],
937 : [ [ 0,0,1,0,1,1,0,2,0,6,1,7,3,7,4,6,4,2,3,1,3,0,4,0 ]       # "Ω" (iso88597-7: 217)
      ],

#----------Not defined

#938 : 921,                                                        # "Ϊ" (iso88597-7: 218)
938 : [ [ 1,0, 3,0, 2,0, 2,7, 1,7, 3,7 ],
        [ 0,7, 0,6 ],
        [ 4,7, 4,6 ],                                             # "Ϊ" (iso88597-7: 218)
      ],
#939 : 89,                                                         # "Ϋ" (iso88597-7: 219)
939 : [ [ 2,0, 2,4, 0,7, 2,4, 4,7 ],
        [1,7, 1,6 ],
        [3,7, 3,6 ],                                               # "Ϋ" (iso88597-7: 219)
      ],
940 : [ [ 5,0, 4,0, 4,1, 3,0, 1,0, 0,1, 0,3, 1,4, 3,4, 4,3, 4,4 ],
        [ 4,3, 4,1 ],
        [ 2,6, 2,5 ]                                              # "ά" (iso88597-7: 220)
      ],
941 : [ [ 4,3, 3,4, 1,4, 0,3, 1,2, 3,2 ],
        [ 1,2, 0,1, 1,0, 3,0, 4,1 ],
        [ 2,6, 2,5 ]                                              # "έ" (iso88597-7: 221)
      ],
942 : [ [ 0,4, 1,3, 1,0 ],
        [ 1,3, 2,4, 3,4, 4,3, 4,-1 ],
        [ 2,6, 2,5 ]                                              # "ή" (iso88597-7: 222)
      ],
943 : [ [ 1,4, 1,1, 2,0, 3,1 ],
        [ 1,6, 1,5 ]                                              # "ί" (iso88597-7: 223)
      ],
944 : [ [ 0,4, 0,1, 1,0, 3,0, 4,1, 4,4 ],
        [ 1,5, 1,4 ],
        [ 3,5, 3,4 ],
        [ 2,6, 2,5 ]                                              # "ΰ" (iso88597-7: 224)
      ],

#----------Small Greek letters

945 : [ [ 5,0, 4,0, 4,1, 3,0, 1,0, 0,1, 0,3, 1,4, 3,4, 4,3, 4,4 ],
        [ 4,3, 4,1 ]                                              # "α" (iso88597-7: 225_
      ],
946 : [ [ 0,-2, 0,6, 1,7, 2,7, 3,6, 3,5, 2,4, 1,4, 3,4, 4,3, 4,1, 3,0, 1,0, 0,1]       # "β" (iso88597-7: 226)
      ],
947 : [ [  0,4, 3,0, 3,-1, 2,-2, 1,-2, 0,-1, 0,0, 3,4 ]           # "γ" (iso88597-7: 227)
      ],
948 : [ [ 3,4, 1,4, 0,3, 0,1, 1,0, 3,0, 4,1, 4,3, 0,7, 4,7 ]      # "δ" (iso88597-7: 228)
      ],
949 : [ [ 4,3, 3,4, 1,4, 0,3, 1,2, 3,2 ],
        [ 1,2, 0,1, 1,0, 3,0, 4,1 ]                               # "ε" (iso88597-7: 229)
      ],
950 : [ [ 0,7, 4,7, 1,5, 0,4, 0,2, 1,1, 3,0, 4,-1, 3,-2, 2,-2 ]   # "ζ" (iso88597-7: 230)
      ],
951 : [ [ 0,4, 1,3, 1,0 ],
        [ 1,3, 2,4, 3,4, 4,3, 4,-1 ]                              # "η" (iso88597-7: 231)
      ],
952 : [ [ 4,4, 1,4, 1,6, 2,7, 3,7, 4,6, 4,1, 3,0, 2,0, 1,1, 1,4 ] # "θ" (iso88597-7: 232)
      ],
953 : [ [ 1,4, 1,1, 2,0, 3,1 ]                                    # "ι" (iso88597-7: 233)
      ],
954 : [ [ 0,4, 0,0 ],
        [ 3,4, 0,2, 3,0 ]                                         # "κ" (iso88597-7: 234)
      ],
955 : [ [ 0,0, 2,4, 4,0 ],
        [ 2,4, 1,6, 0,7 ]                                         # "λ" (iso88597-7: 235)
      ],
956 : [ [ 0,4, 0,-2 ],
        [ 0,1, 1,0, 3,0, 4,1 ],
        [ 4,4, 4,0 ]                                              # "μ" (iso88597-7: 236)
      ],
957 : [ [ 0,4, 2,0, 4,4 ]                                         # "ν" (iso88597-7: 237)
      ],
958 : [ [ 0,7, 4,7 ],
        [ 2,7, 0,6, 0,5, 1,4, 3,4 ],
        [ 1,4, 0,3, 0,1, 1,0, 3,0, 4,-1, 3,-2, 2,-2 ]             # "ξ" (iso88597-7: 238)
      ],
959 : [ [ 1,0, 3,0, 4,1, 4,3, 3,4, 1,4, 0,3, 0,1, 1,0 ]           # "ο" (iso88597-7: 239)
      ],
960 : [ [ 0,4, 4,4 ],
        [ 1,4, 1,0 ],
        [ 3,4, 3,0 ]                                              # "π" (iso88597-7: 240)
      ],
961 : [ [ 0,1, 1,0, 3,0, 4,1, 4,3, 3,4, 1,4, 0,3, 0,-2 ]          # "ρ" (iso88597-7: 241)
      ],
962 : [ [ 3,4, 1,4, 0,3, 0,2, 1,1, 3,1, 4,0, 3,-1, 2,-1, 1,-1 ]   # "ς" (iso88597-7: 242)
      ],
963 : [ [ 5,4, 1,4, 0,3, 0,1, 1,0, 2,0, 3,1, 3,3, 2,4 ]           # "σ" (iso88597-7: 243)
      ],
964 : [ [ 0,4, 4,4 ],
        [ 2,4, 2,1, 3,0, 4,1 ],                                   # "τ" (iso88597-7: 244)
      ],
965 : [ [ 0,4, 0,1, 1,0, 3,0, 4,1, 4,4 ]                          # "υ" (iso88597-7: 245)
      ],
966 : [ [ 1,4, 0,3, 0,1, 1,0, 3,0, 4,1, 4,3, 3,4, 2,3, 2,-2 ]     # "φ" (iso88597-7: 246)
      ],
967 : [ [ 0,4, 4,-2 ],
        [ 4,4, 0,-2 ]                                             # "χ" (iso88597-7: 247)
      ],
968 : [ [ 0,4, 0,1, 1,0, 3,0, 4,1, 4,4 ],
        [ 2,4, 2,-2 ]                                             # "ψ" (iso88597-7: 248)
      ],
969 : [ [ 1,4, 0,3, 0,1, 1,0, 2,1, 2,3 ],
        [ 2,1, 3,0, 4,1, 4,3, 3,4 ]                               # "ω" (iso88597-7: 249)
      ],

970 : [ [ 1,4, 1,1, 2,0, 3,1 ],
        [ 0,5, 0,4 ],
        [ 2,5, 2,4 ]                                              # "ϊ" (iso88597-7: 250)
      ],
971 : [ [ 0,4, 0,1, 1,0, 3,0, 4,1, 4,4 ],
        [ 1,5, 1,4 ],
        [ 3,5, 3,4 ]                                              # "ϋ" (iso88597-7: 251)
      ],
972 : [ [ 1,0, 3,0, 4,1, 4,3, 3,4, 1,4, 0,3, 0,1, 1,0 ],
        [ 2,6, 2,5 ]                                              # "ό" (iso88597-7: 252)
      ],
973 : [ [ 0,4, 0,1, 1,0, 3,0, 4,1, 4,4 ],
        [ 2,6, 2,5 ]                                              # "ύ" (iso88597-7: 253)
      ],

974 : [ [ 1,4, 0,3, 0,1, 1,0, 2,1, 2,3 ],
        [ 2,1, 3,0, 4,1, 4,3, 3,4 ],
        [ 2,6, 2,5 ]                                              # "ώ" (iso88597-7: 254)
      ],
8254: [ [ 0,7,5,7 ],                                              # overscore (opposite of underscore)
      ],
8594: [ [ 0,3,6,3,4,4,4,2,6,3 ]                                   # RIGHTWARDS ARROW
      ],
8744: [ [ 1,4,3,0,5,4 ]                                           # LOGICAL OR
      ],
8747: [ [ 0,1,1,0,2,0,3,1,3,6,4,7,5,7,6,6 ]                       # INTEGRAL
      ],
8776: [ [ 0,1,1,2,2,2,4,0,5,0,6,1 ],
        [ 0,3,1,4,2,4,4,2,5,2,6,3 ]                               # ALMOST EQUAL TO
      ],
8797: [ [ 0,3,4,3 ],
        [ 4,5,0,5 ],
        [ 0,1,4,1 ]                                               # EQUAL TO BY DEFINITION
      ],
8800: [ [ 4,4,0,4 ],
        [ 0,2,4,2 ],
        [ 3,5,1,1 ]                                               # NOT EQUAL TO
      ],
8835: [ [ 1,2,4,2,5,3,5,4,4,5,1,5 ]                               # SUPERSET OF
      ],
}
    for lines in dilines.values():   #works for python2,3
        if type(lines) == int: continue  # An integer for indirection
        lines.append([(7, 0)])               # The next character start position
    return dilines

#=============================================================================

def makePrime2Lines():
    """Makes the lines that define each character of fixed width line font Prime2.

    Prime2 is a font which defines a letter as a set of straight line segments.
    Each letter fits into a 6x9 units rectangle with left lower xy coordinates
    0,-2 and right upper 6,7 (xy). All the letters are less than 6 units wide (x)
    and most letters less than 5 units wide, thus leaving some space between the
    letters of the same word.
    All capital letters and most of the small letters are within the 0 to 7 y-range.
    Small letters like p,q,y use the full y-range: -2 to 7
    This font is in construction. When it is finished, it will consist of polygons
    which may be filled.
    """
    "Makes the lines that define each character in thanFontPrime1."

    dilines = \
{ 1 : [ [ 2,2,2,4,0,4,0,0,4,0,4,4,2,4,2,2 ]                       # "Not printable"
      ],
  2 : [ [ 2,2,2,4,1,4,0,3,0,1,1,0,3,0,4,1,4,3,3,4,2,4,2,2 ]       # "Not printable"
      ],
  3 : [ [ 2,2,2,4,0,1,4,1,2,4,2,2 ]                               # "Not printable"
      ],
  4 : [ [ 2,2,4,2,0,2,2,2,2,0,2,4,2,2 ]                           # "Not printable"
      ],
  5 : [ [ 2,2,4,4,0,0,2,2,0,4,4,0,2,2 ]                           # "Not printable"
      ],
  6 : [ [ 2,2,2,4,0,2,2,0,4,2,2,4,2,2 ]                           # "Not printable"
      ],
  7 : [ [ 2,2,2,0,2,4,0,2,4,2,2,4,2,2 ]                           # "Not printable"
      ],
  8 : [ [ 2,2,0,0,4,4,0,4,4,0,2,2 ]                               # "Not printable"
      ],
  9 : [ [ 2,2,4,4,0,4,4,4,0,0,4,0,0,0,2,2 ]                       # "Not printable"
      ],
 10 : [ [ 2,2,0,4,2,2,4,4,2,2,2,0,2,2 ]                           # "Not printable"
      ],
 11 : [ [ 2,2,4,4,3,3,1,3,0,4,1,3,1,1,0,0,1,1,3,1,4,0,3,1,3,3,2,2 ]       # "Not printable"
      ],
 12 : [ [ 2,2,4,2,0,2,2,2,2,0,2,4,2,2,4,4,0,0,2,2,0,4,4,0,2,2 ]   # "Not printable"
      ],
 13 : [ [ 2,2,4,4,0,4,4,0,0,0,2,2 ]                               # "Not printable"
      ],
 14 : [ [ 2,2,2,0,2,4,2,2 ]                                       # "Not printable"
      ],
 15 : [ [ 1,0,3,6,5,0,0,4,6,4,1,0 ]                               # "Not printable"
      ],
 16 : [ [ 2,2,6,2,2,2 ]                                           # "Not printable"
      ],
 17 : [                                                           # "Not printable"
      ],
 18 : [ [ 0,3,4,3 ],
        [ 4,5,0,5 ],
        [ 0,1,4,1 ]                                               # "Not printable"
      ],
 19 : [ [ 0,3,6,3,4,4,4,2,6,3 ]                                   # "Not printable"
      ],
 20 : [                                                           # "Not printable"
      ],
 21 : [ [ 4,4,0,4 ],
        [ 0,2,4,2 ],
        [ 3,5,1,1 ]                                               # "Not printable"
      ],
 22 : [ [ 0,1,4,1 ],
        [ 2,2,2,6,2,4,0,4,4,4 ]                                   # "Not printable"
      ],
 23 : [ [ 0,0,6,0 ]                                               # "Not printable"
      ],
 24 : [                                                           # "Not printable"
      ],
 25 : [ [ 0,7,6,7 ]                                               # "Not printable"
      ],
 26 : [ [ 0,1,1,0,2,0,3,1,3,6,4,7,5,7,6,6 ]                       # "Not printable"
      ],
 27 : [ [ 1,2,4,2,5,3,5,4,4,5,1,5 ]                               # "Not printable"
      ],
 28 : [ [ 1,4,3,0,5,4 ]                                           # "Not printable"
      ],
 29 : [ [ 0,1,1,2,2,2,4,0,5,0,6,1 ],
        [ 0,3,1,4,2,4,4,2,5,2,6,3 ]                               # "Not printable"
      ],
 30 : [ [ 3,0,3,6 ],
        [ 5,4,4,5,2,5,1,4,1,2,2,1,4,1,5,2 ]                       # "Not printable"
      ],
 31 : [ [ 0,3,4,3,4,2 ]                                           # "Not printable"
      ],
 32 : [                                                           # " "
      ],
 33 : [ [ 1,0,2,1,3,0,1,0 ],
        [ 2,2,2,7 ]                                               # "!"
      ],
 34 : [ [ 2,5,2,7,1,7,2,5 ],
        [ 4,5,4,7,3,7,4,5 ]                                       # """
      ],
 35 : [ [ 0,1,4,1 ],
        [ 4,3,0,3 ],
        [ 1,4,1,0 ],
        [ 3,0,3,4 ]                                               # "#"
      ],
 36 : [ [ 2,7,2,0 ],
        [ 0,2,3,2,4,3,3,4,1,4,0,5,1,6,4,6 ]                       # "$"
      ],
 37 : [ [ 4,1,4,0,3,0,3,1,4,1 ],
        [ 0,0,4,7 ],
        [ 1,7,1,6,0,6,0,7,1,7 ]                                   # "%"
      ],
 38 : [ [ 4,1,3,0,1,0,0,1,0,2,3,6,2,7,1,6,1,5,4,0 ]               # "&"
      ],
 39 : [ [ 4,5,4,7,3,7,4,5 ]                                       # "'"
      ],
 40 : [ [ 4,7,3,6,3,1,4,0 ]                                       # "("
      ],
 41 : [ [ 0,7,1,6,1,1,0,0 ]                                       # ")"
      ],
 42 : [ [ 4,1,0,5,2,3,4,5,0,1,2,3,2,1,2,5,2,3,0,3,4,3 ]           # "*"
      ],
 43 : [ [ 2,1,2,5,2,3,0,3,4,3 ]                                   # "+"
      ],
 44 : [ [ 2,1,1,1,1,2,2,2,2,1,1,0 ]                               # ","
      ],
 45 : [ [ 0,3,4,3 ]                                               # "-"
      ],
 46 : [ [ 1,1,1,0,0,0,0,1,1,1 ]                                   # "."
      ],
 47 : [ [ 0,0,4,7 ]                                               # "/"
      ],
 48 : [ [ 4,6,3,7,1,7,0,6,0,1,1,0,3,0,4,1,4,6 ]                   # "0"
      ],
 49 : [ [ 1,6,2,7,2,0,1,0,3,0 ]                                   # "1"
      ],
 50 : [ [ 0,6,1,7,3,7,4,6,4,4,0,1,0,0,4,0 ]                       # "2"
      ],
 51 : [ [ 0,6, 1,7, 3,7, 4,6, 4,5, 3,4, 1,4 ],
        [ 3,4, 4,3, 4,1, 3,0, 1,0, 0,1 ]                          # "3"
      ],
 52 : [ [ 4,2,0,2,3,7,3,0,2,0,4,0 ]                               # "4"
      ],
 53 : [ [ 4,7,0,7,0,4,3,4,4,3,4,1,3,0,1,0,0,1 ]                   # "5"
      ],
 54 : [ [ 0,3, 1,4, 3,4, 4,3, 4,1, 3,0, 1,0, 0,1, 0,6, 1,7, 3,7, 4,6 ]            # "6"
      ],
 55 : [ [ 0,6,0,7,4,7,4,6,1,1,1,0 ]                               # "7"
      ],
 56 : [ [ 0,6,1,7,3,7,4,6,4,5,3,4,1,4,3,4,4,3,4,1,3,0,1,0,0,1,0,3,1,4,0,5,0,6 ]   # "8"
      ],
 57 : [ [ 4,4,3,3,1,3,0,4,0,6,1,7,3,7,4,6,4,1,3,0,1,0,0,1 ]       # "9"
      ],
 58 : [ [ 2,4,1,4,1,5,2,5,2,4 ],
        [ 2,1,1,1,1,2,2,2,2,1 ]                                   # ":"
      ],
 59 : [ [ 2,4,1,4,1,5,2,5,2,4 ],
        [ 2,1,1,1,1,2,2,2,2,1,1,0 ]                               # ";"
      ],
 60 : [ [ 4,2,0,4,4,6 ]                                           # "<"
      ],
 61 : [ [ 4,4,0,4 ],
        [ 0,2,4,2 ]                                               # "="
      ],
 62 : [ [ 0,2,4,4,0,6 ]                                           # ">"
      ],
 63 : [ [ 1,0,2,1,3,0,1,0 ],
        [ 2,2,2,4,3,4,4,5,4,6,3,7,1,7,0,6 ]                       # "?"
      ],
 64 : [ [ 3,1,1,1,0,2,0,5,1,6,3,6,4,5,4,2,3,3,3,4,2,5,1,4,1,3,2,2,3,3 ]       # "@"
      ],
 65 : [ [ 3.500,          2.750,
          0.500,          2.750,
          0.500,          0.000,
          0.000,          0.000,
          0.000,          6.000,
          1.000,          7.000,
          3.000,          7.000,
          4.000,          6.000,
          4.000,          0.000,
          3.500,          0.000,
          3.500,          2.750
        ],
        [ 3.500,          3.250,
          3.500,          5.793,
          2.793,          6.500,
          1.207,          6.500,
          0.500,          5.793,
          0.500,          3.250,
          3.500,          3.250
        ]
      ],
 66 : [ [4,1, 3,0, 0,0, 0,7, 3,7, 4,6, 4,5, 3,4, 4,3, 4,1],
        [ 2.543,          3.750,
          3.500,          2.793,
          3.500,          1.207,
          2.793,          0.500,
          0.500,          0.500,
          0.500,          3.750,
          2.543,          3.750                                   # "A"
        ],
        [ 0.500,          4.250,
          0.500,          6.500,
          2.793,          6.500,
          3.500,          5.793,
          3.500,          5.207,
          2.543,          4.250,
          0.500,          4.250                                   # "B"
        ]
      ],
 67 : [ [ 4,6,3,7,1,7,0,6,0,1,1,0,3,0,4,1,                        # "C"
          3.646,          1.354,
          2.793,          0.500,
          1.207,          0.500,
          0.500,          1.207,
          0.500,          5.793,
          1.207,          6.500,
          2.793,          6.500,
          3.646,          5.646,
          4,              6
        ]
      ],
 68 : [  [3,7, 4,6, 4,1, 3,0, 0,0, 0,7, 3,7],                     # "D"
         [2.793,          6.500,
          3.500,          5.793,
          3.500,          1.207,
          2.793,          0.500,
          0.500,          0.500,
          0.500,          6.500,
          2.793,          6.500
         ],
      ],
 69 : [ [ 4,0,0,0,0,7,4,7,0,7,0,4,3,4 ]                           # "E"
      ],
 70 : [ [ 0,0,0,7,4,7,0,7,0,4,3,4 ]                               # "F"
      ],
 71 : [ [ 4,3,4,1,3,0,1,0,0,1,0,6,1,7,3,7,4,6 ],
        [ 3,3,5,3 ]                                               # "G"
      ],
 72 : [ [ 0,0,0,7,0,4,4,4,4,7,4,0 ]                               # "H"
      ],
 73 : [ [ 1,0,3,0,2,0,2,7,1,7,3,7 ]                               # "I"
      ],
 74 : [ [ 0,1,1,0,3,0,4,1,4,7 ]                                   # "J"
      ],
 75 : [ [ 0,7,0,0 ],
        [ 4,0,2,5,0,3,4,7 ]                                       # "K"
      ],
 76 : [ [ 4,0,0,0,0,7 ]                                           # "L"
      ],
 77 : [ [ 4,0,4,7,2,3,0,7,0,0 ]                                   # "M"
      ],
 78 : [ [ 4,7,4,0,0,7,0,0 ]                                       # "N"
      ],
 79 : [ [ 4,6,3,7,1,7,0,6,0,1,1,0,3,0,4,1,4,6 ]                   # "O"
      ],
 80 : [ [ 0,0,0,7,3,7,4,6,4,5,3,4,0,4 ]                           # "P"
      ],
 81 : [ [ 4,6,3,7,1,7,0,6,0,1,1,0,3,0,4,1,4,6],
        [ 4,0,2,2 ]                                               # "Q"
      ],
 82 : [ [ 0,0,0,7,3,7,4,6,4,5,3,4,0,4,3,4,4,3,4,0 ]               # "R"
      ],
 83 : [ [ 4,6,3,7,1,7,0,6,0,5,1,4,3,4,4,3,4,1,3,0,1,0,0,1 ]       # "S"
      ],
 84 : [ [ 4,7,0,7,2,7,2,0 ]                                       # "T"
      ],
 85 : [ [ 0,7,0,1,1,0,3,0,4,1,4,7 ]                               # "U"
      ],
 86 : [ [ 0,7,2,0,4,7 ]                                           # "V"
      ],
 87 : [ [ 4,7,4,0,2,4,0,0,0,7 ]                                   # "W"
      ],
 88 : [ [ 4,7,0,0 ],
        [ 4,0,0,7 ]                                               # "X"
      ],
 89 : [ [ 2,0, 2,4, 0,7, 2,4, 4,7 ]                               # "Υ"
      ],
 90 : [ [ 0,7, 4,7, 0,0, 4,0 ]                                    # "Z"
      ],
 91 : [ [ 4,7,0,7,0,0,4,0 ]                                       # "["
      ],
 92 : [ [ 4,0,0,7 ]                                               # "\"
      ],
 93 : [ [ 0,0,4,0,4,7,0,7 ]                                       # "]"
      ],
 94 : [ [ 0,1,2,5,4,1 ]                                           # "^"
      ],
 95 : [ [ 0,3,5,3 ]                                               # "_"
      ],
 96 : [ [ 0,0,1,4,1,2,2,1,3,1,4,2,4,4,4,2,5,1 ]                   # "`"
      ],

#---------Small English

 97 : [ [ 1,0, 3,0, 4,1, 4,3, 1,3, 0,2, 0,1, 1,0 ],
        [ 5,0, 4,0, 4,1],
        [ 1,4, 4,4, 4,3 ]                                         # "a"
      ],
 98 : [ [ 0,7, 0,0, 3,0, 4,1, 4,3, 3,4, 0,4 ]                     # "b"
      ],
 99 : [ [ 4,1, 3,0, 1,0, 0,1, 0,3, 1,4, 3,4, 4,3 ]                # "c"
      ],
100 : [ [ 4,7, 4,0, 1,0, 0,1, 0,3, 1,4, 4,4 ]                     # "d"
      ],
101 : [ [ 4,1, 3,0, 1,0, 0,1, 0,3, 1,4, 3,4, 4,3, 4,2, 0,2 ]      # "e"
      ],
102 : [ [ 1,0, 1,6, 2,7, 3,7, 4,6 ],
        [ 0,4, 3,4 ]                                              # "f"
      ],
103 : [ [ 4,1, 3,0, 1,0, 0,1, 0,3, 1,4, 3,4, 4,3, 4,-1, 3,-2, 1,-2, 0,-1 ]  # "g"
      ],
104 : [ [ 0,7, 0,0 ],
        [ 0,3, 1,4, 3,4, 4,3, 4,0 ]                               # "h"
      ],
105 : [ [ 2,0, 2,4 ],
        [ 2,5, 2,6 ]                                              # "i"
      ],
106 : [ [ 3,6, 3,5 ],
        [ 3,4, 3,-1, 2,-2, 0,-1 ]                                 # "j"
      ],
107 : [ [ 0,7, 0,0 ],
        [ 3,4, 0,2, 3,0 ]                                         # "k"
      ],
108 : [ [ 1,7, 2,7, 2,0 ],
        [ 1,0, 3,0 ]                                              # "l"
      ],
109 : [ [ 0,4, 0,0 ],
        [ 0,3, 1,4, 2,4, 3,3, 4,4, 5,4, 6,3, 6,0 ],
        [ 3,3, 3,0 ]                                              # "m"
      ],
110 : [ [ 0,4, 0,0 ],
        [ 0,3, 1,4, 3,4, 4,3, 4,0 ]                               # "n"
      ],
111 : [ [ 4,1, 3,0, 1,0, 0,1, 0,3, 1,4, 3,4, 4,3, 4,1 ]           # "o"
      ],
112 : [ [ 0,-2, 0,4 ],
        [ 0,3, 1,4, 3,4, 4,3, 4,1, 3,0, 1,0, 0,1 ]                # "p"
      ],
113 : [ [ 4,-2, 4,4 ],
        [ 4,3, 3,4, 1,4, 0,3, 0,1, 1,0, 3,0, 4,1 ]                # "q"
      ],
114 : [ [ 1,0, 1,4 ],
        [ 1,3, 2,4, 3,4, 4,3 ]                                    # "r"
      ],
115 : [ [ 4,3, 3,4, 1,4, 0,3, 4,1, 3,0, 1,0, 0,1 ]                # "s"
      ],
116 : [ [ 1,6, 1,1, 2,0, 3,0, 4,1 ],
        [ 0,4, 3,4 ]                                              # "t"
      ],
117 : [ [  4,4, 4,0 ],
        [ 4,1, 3,0, 1,0, 0,1, 0,4 ]                               # "u"
      ],
118 : [ [ 0,4, 2,0, 4,4 ]                                         # "v"
      ],
119 : [ [0,4, 1,0, 2,2, 3,0, 4,4 ]                                # "w"
      ],
120 : [ [ 0,4, 4,0 ],
        [ 0,0, 4,4 ]                                              # "x"
      ],
121 : [ [ 0,4, 2,0 ],
        [ 4,4, 1,-2 ]                                             # "y"
      ],
122 : [ [ 0,4, 4,4, 0,0, 4,0 ]                                    # "z"
      ],
123 : [ [ 5,0,4,0,3,1,3,3,2,4,3,5,3,7,4,8,5,8 ]                   # "{"
      ],
124 : [ [ 0,0,0,8 ]                                               # "|"
      ],
125 : [ [ 1,0,2,0,3,1,3,3,4,4,3,5,3,7,2,8,1,8 ]                   # "}"
      ],
126 : [ [ 0,1,1,2,2,2,4,0,5,0,6,1 ]                               # "~"
      ],
127 : [ [ 6,3,5,2,4,2,3,3,3,4,2,5,1,5,0,4,0,3,1,2,2,2,3,3,3,4,4,5,5,5,6,4,6,3 ] # "Not printable"
      ],

128 : [ [ 5,7, 4,7, 2,6, 1,4, 1,3, 2,1, 4,0, 5,0 ],
        [ 0,4, 4,4 ],
        [ 0,3, 4,3 ]                                              # "
      ],
162 : [ [ 0,0, 0,3, 4,3, 4,5, 3,7, 1,7, 0,5, 0,3, 4,3, 4,0 ],
        [ 0,7, 0,6 ]                                              # "’"
      ],
183 : [ [ 2,3, 3,3, 3,4, 2,4, 2,3 ]                               # "·"
      ],
184 : [ [ 5,0, 1,0, 1,7, 5,7, 1,7, 1,4, 4,4 ],
        [ 0,7, 0,6 ]                                              # "Έ"
      ],
185 : [ [ 1,0, 1,7, 1,4, 5,4, 5,7, 5,0 ],
        [ 0,7, 0,6 ]                                              # "Ή"
      ],
186 : [ [ 1,0, 3,0, 2,0, 2,7, 1,7, 3,7 ],
        [ 0,7, 0,6 ],                                             # "Ί"
      ],
187 : [ [ 0,4, 2,2, 0,0 ],
        [ 2,4, 4,2, 2,0 ]                                         # "»"
      ],
188 : [ [ 4,5, 3,7, 1,7, 0,5, 0,2, 1,0, 3,0, 4,2, 4,5 ],
        [ 0,7, 0,6 ]                                              # "Ό"
      ],
189 : [ [ 0,5, 1,6, 1,3 ],
        [ 0,2, 4,4 ],
        [ 2,2, 3,3, 4,2, 2,0, 4,0 ]                               # "½"
      ],
190 : [ [ 2,0, 2,4, 0,7, 2,4, 4,7 ],
        [0,6, 0,5 ]                                               # "Ύ"
      ],
191 : [ [ 0,0, 1,0, 1,1, 0,2, 0,5, 1,7, 3,7, 4,5, 4,2, 3,1, 3,0, 4,0 ],
        [ 0,7, 0,6 ]                                              # "Ώ"
      ],
192 : [ [ 1,4, 1,1, 2,0, 3,1 ],
        [ 0,5, 0,4 ],
        [ 2,5, 2,4 ],
        [ 1,6, 1,5 ]                                              #  "ΐ"
      ],
#-----Greek capital

193 : [ [ 0,0,0,3,4,3,4,6,3,7,1,7,0,6,0,3,4,3,4,0 ]               # "Α"
      ],
194 : [ [ 4,1,3,0,0,0,0,7,3,7,4,6,4,5,3,4,0,4,3,4,4,3,4,1 ]       # "Β"
      ],
195 : [ [ 0,0,0,7,4,7 ]                                           # "Γ"
      ],
196 : [ [ 0,0,2,7,4,0,0,0 ]                                       # "Δ"
      ],
197 : [ [ 4,0,0,0,0,7,4,7,0,7,0,4,3,4 ]                           # "Ε"
      ],
198 : 90,                                                         # "Ζ"
199 : [ [ 0,0,0,7,0,4,4,4,4,7,4,0 ]                               # "Η"
      ],
200 : [ [ 0,4,0,6,1,7,3,7,4,6,4,1,3,0,1,0,0,1,0,4,4,4 ]           # "Θ"
      ],
201 : [ [ 1,0,3,0,2,0,2,7,1,7,3,7 ]                               # "Ι"
      ],
202 : [ [ 0,7,0,0 ],
        [ 4,0,2,5,0,3,4,7 ]                                       # "Κ"
      ],
203 : [ [ 0,0,2,7,4,0 ]                                           # "Λ"
      ],
204 : [ [ 4,0,4,7,2,3,0,7,0,0 ]                                   # "Μ"
      ],
205 : [ [ 4,7,4,0,0,7,0,0 ]                                       # "Ν"
      ],
206 : [ [ 0,7,4,7 ],
        [ 1,4,3,4 ],
        [ 0,0,4,0 ]                                               # "Ξ"
      ],
207 : [ [ 4,6,3,7,1,7,0,6,0,1,1,0,3,0,4,1,4,6 ]                   # "Ο"
      ],
208 : [ [ 0,0,0,7,4,7,4,0 ]                                       # "Π"
      ],
209 : [ [ 0,0,0,7,3,7,4,6,4,5,3,4,0,4 ]                           # "Ρ"
      ],
210 : 63,                                                         # Not defined
211 : [ [ 5,0,1,0,3,4,1,7,5,7 ]                                   # "Σ"
      ],
212 : [ [ 4,7,0,7,2,7,2,0 ]                                       # "Τ"
      ],
213 : 89,                                                         # "Υ"
214 : [ [ 1,1,0,2,0,5,1,6,3,6,4,5,4,2,3,1,1,1 ],
        [ 2,7,2,0 ]                                               # "Φ"
      ],
215 : [ [ 4,7,0,0 ],
        [ 4,0,0,7 ]                                               # "Χ"
      ],
216 : [ [ 0,7,0,3,1,2,3,2,4,3,4,7 ],
        [ 2,7,2,0 ]                                               # "Ψ"
      ],
217 : [ [ 0,0,1,0,1,1,0,2,0,6,1,7,3,7,4,6,4,2,3,1,3,0,4,0 ]       # "Ω"
      ],

218 : 201,                                                        # "Ϊ"
219 : 89,                                                         # "Ϋ"
220 : [ [ 5,0, 4,0, 4,1, 3,0, 1,0, 0,1, 0,3, 1,4, 3,4, 4,3, 4,4 ],
        [ 4,3, 4,1 ],
        [ 2,6, 2,5 ]                                              #  "ά"
      ],
221 : [ [ 4,3, 3,4, 1,4, 0,3, 1,2, 3,2 ],
        [ 1,2, 0,1, 1,0, 3,0, 4,1 ],
        [ 2,6, 2,5 ]                                              #  "έ"
      ],
222 : [ [ 0,4, 1,3, 1,0 ],
        [ 1,3, 2,4, 3,4, 4,3, 4,-1 ],
        [ 2,6, 2,5 ]                                              #  "ή"
      ],
223 : [ [ 1,4, 1,1, 2,0, 3,1 ],
        [ 1,6, 1,5 ]                                              #  "ί"
      ],
224 : [ [ 0,4, 0,1, 1,0, 3,0, 4,1, 4,4 ],
        [ 1,5, 1,4 ],
        [ 3,5, 3,4 ],
        [ 2,6, 2,5 ]                                              #  "ΰ"
      ],

#----------Small Greek letters

225 : [ [ 5,0, 4,0, 4,1, 3,0, 1,0, 0,1, 0,3, 1,4, 3,4, 4,3, 4,4 ],
        [ 4,3, 4,1 ]                                              # "α"
      ],
226 : [ [ 0,-2, 0,6, 1,7, 2,7, 3,6, 3,5, 2,4, 1,4, 3,4, 4,3, 4,1, 3,0, 1,0, 0,1]       # "β"
      ],
227 : [ [  0,4, 3,0, 3,-1, 2,-2, 1,-2, 0,-1, 0,0, 3,4 ]           # "γ"
      ],
228 : [ [ 3,4, 1,4, 0,3, 0,1, 1,0, 3,0, 4,1, 4,3, 0,7, 4,7 ]      # "δ"
      ],
229 : [ [ 4,3, 3,4, 1,4, 0,3, 1,2, 3,2 ],
        [ 1,2, 0,1, 1,0, 3,0, 4,1 ]                               # "ε"
      ],
230 : [ [ 0,7, 4,7, 1,5, 0,4, 0,2, 1,1, 3,0, 4,-1, 3,-2, 2,-2 ]   #  "ζ"
      ],
231 : [ [ 0,4, 1,3, 1,0 ],
        [ 1,3, 2,4, 3,4, 4,3, 4,-1 ]                              #  "η"
      ],
232 : [ [ 4,4, 1,4, 1,6, 2,7, 3,7, 4,6, 4,1, 3,0, 2,0, 1,1, 1,4 ] #  "θ"
      ],
233 : [ [ 1,4, 1,1, 2,0, 3,1 ]                                    #  "ι"
      ],
234 : [ [ 0,4, 0,0 ],
        [ 3,4, 0,2, 3,0 ]                                         #  "κ"
      ],
235 : [ [ 0,0, 2,4, 4,0 ],
        [ 2,4, 1,6, 0,7 ]                                         #  "λ"
      ],
236 : [ [ 0,4, 0,-2 ],
        [ 0,1, 1,0, 3,0, 4,1 ],
        [ 4,4, 4,0 ]                                              #  "μ"
      ],
237 : [ [ 0,4, 2,0, 4,4 ]                                         #  "ν"
      ],
238 : [ [ 0,7, 4,7 ],
        [ 2,7, 0,6, 0,5, 1,4, 3,4 ],
        [ 1,4, 0,3, 0,1, 1,0, 3,0, 4,-1, 3,-2, 2,-2 ]             # "ξ"
      ],
239 : [ [ 1,0, 3,0, 4,1, 4,3, 3,4, 1,4, 0,3, 0,1, 1,0 ]           # "ο"
      ],
240 : [ [ 0,4, 4,4 ],
        [ 1,4, 1,0 ],
        [ 3,4, 3,0 ]                                              # "π"
      ],
241 : [ [ 0,1, 1,0, 3,0, 4,1, 4,3, 3,4, 1,4, 0,3, 0,-2 ]          # "ρ"
      ],
242 : [ [ 3,4, 1,4, 0,3, 0,2, 1,1, 3,1, 4,0, 3,-1, 2,-1, 1,-1 ]   # "ς"
      ],
243 : [ [ 5,4, 1,4, 0,3, 0,1, 1,0, 2,0, 3,1, 3,3, 2,4 ]           # "σ"
      ],
244 : [ [ 0,4, 4,4 ],
        [ 2,4, 2,1, 3,0, 4,1 ],                                   # "τ"
      ],
245 : [ [ 0,4, 0,1, 1,0, 3,0, 4,1, 4,4 ]                          # "υ"
      ],
246 : [ [ 1,4, 0,3, 0,1, 1,0, 3,0, 4,1, 4,3, 3,4, 2,3, 2,-2 ]     # "φ"
      ],
247 : [ [ 0,4, 4,-2 ],
        [ 4,4, 0,-2 ]                                             # "χ"
      ],
248 : [ [ 0,4, 0,1, 1,0, 3,0, 4,1, 4,4 ],
        [ 2,4, 2,-2 ]                                             # "ψ"
      ],
249 : [ [ 1,4, 0,3, 0,1, 1,0, 2,1, 2,3 ],
        [ 2,1, 3,0, 4,1, 4,3, 3,4 ]                               # "ω"
      ],

250 : [ [ 1,4, 1,1, 2,0, 3,1 ],
        [ 0,5, 0,4 ],
        [ 2,5, 2,4 ]                                              #  "ϊ"
      ],
251 : [ [ 0,4, 0,1, 1,0, 3,0, 4,1, 4,4 ],
        [ 1,5, 1,4 ],
        [ 3,5, 3,4 ]                                              #  "ϋ"
      ],
252 : [ [ 1,0, 3,0, 4,1, 4,3, 3,4, 1,4, 0,3, 0,1, 1,0 ],
        [ 2,6, 2,5 ]                                              #  "ό"
      ],
253 : [ [ 0,4, 0,1, 1,0, 3,0, 4,1, 4,4 ],
        [ 2,6, 2,5 ]                                              #  "ύ"
      ],

254 : [ [ 1,4, 0,3, 0,1, 1,0, 2,1, 2,3 ],
        [ 2,1, 3,0, 4,1, 4,3, 3,4 ],
        [ 2,6, 2,5 ]                                              #  "ώ"
      ],
255 : [ [ 0,0, 4,0,  4,4, 0,4, 0,0 ]                              # quadrilateral
      ]
}
    for lines in dilines.values():   #works for python2,3
        if type(lines) == int: continue
        lines.append([(7, 0)])
    return dilines

def makeLcd1Lines():
    """Makes the lines that define each character of fixed width line font Lcd1.

    Lcd1 is a font which defines a letter as a set of straight line segments.
    Each letter fits into a 6x9 units rectangle with left lower xy coordinates
    0,-2 and right upper 6,7 (xy). All the letters are less than 6 units wide (x)
    and most letters less than 5 units wide, thus leaving some space between the
    letters of the same word.
    All capital letters and most of the small letters are within the 0 to 7 y-range.
    Small letters like p,q,y use the full y-range: -2 to 7
    """
    dilines = \
{32 : [                                                           # " "
      ],
 33 : [ [1,2, 1,-1, 0,-1, 1,0],                                   # "!"
      ],
 34 : [ [0,2, 0,1],
        [1,2, 1,1],                                               # """
      ],
 35 : [ [0,1, 2,1],
        [0,0, 2,0],
        [1,2, 1,-1],
        [2,2, 2,-1],                                              # "#"
      ],
 36 : [ [2,2, 0,2, 0,1, 2,1, 2,0, 0,0],
        [1,2, 1,-1],                                              # "$"
      ],
 37 : [ [2,2, 0,0],
        [0,2, 0,1],
        [2,0, 2,1],                                               # "%"
      ],
 38 : [ [2,0, 0,0, 0,1, 1,2, 0,2, 2,-1]                           # "&"
      ],
 39 : [ [1,2, 0,1],                                               # "'"
      ],
 40 : [ [1,2, 0,1, 0,0, 1,-1],                                    # "("
      ],
 41 : [ [1,2, 2,1, 2,0, 1,-1],                                    # ")"
      ],
 42 : [ [0,0, 2,2],
        [2,0, 0,2],
        [0,1, 2,1],                                               # "*"
      ],
 43 : [ [1,0, 1,2],                                               # "+"
        [0,1, 2,1],
      ],
 44 : [ [1,0, 0,-1],                                              # ","
      ],
 45 : [ [0,1, 2,1],                                               # "-"
      ],
 46 : [ [0,0, 0,-1],                                              # "."
      ],
 47 : [ [0,0, 2,2],                                               # "/"
      ],
 48 : [ [0,0, 2,0, 2,2, 0,2, 0,0],                                # "0"
      ],
 49 : [ [1,0, 1,2],                                               # "1"
      ],
 50 : [ [0,2, 2,2, 2,1, 0,1, 0,0, 2,0],                           # "2"
      ],
 51 : [ [0,2, 2,2, 2,0, 0,0],
        [0,1, 2,1],                                               # "3"
      ],
 52 : [ [0,2, 0,1, 2,1],
        [2,2, 2,0],                                               # "4"
      ],
 53 : [ [2,2, 0,2, 0,1, 2,1, 2,0, 0,0],                           # "5"
      ],
 54 : [ [0,2, 0,0, 2,0, 2,1, 0,1],                                # "6"
      ],
 55 : [ [ 0,2, 2,2, 2,0],                                         # "7"
      ],
 56 : [ [0,0, 2,0, 2,2, 0,2, 0,0],
        [0,1, 2,1],                                               # "8"
      ],
 57 : [ [2,1, 0,1, 0,2, 2,2, 2,0],                                # "9"
      ],
 58 : [ [1,2, 1,1],
        [1,0, 1,-1]                                               # ":"
      ],
 59 : [ [1,2, 1,1],
        [1,0, 0,-1],                                              # ";"
      ],
 60 : [ [2,2, 0,1, 2,0]                                           # "<"
      ],
 61 : [ [0,1, 2,1],
        [0,0, 2,0],                                               # "="
      ],
 62 : [ [0,2, 2,1, 0,0],                                          # ">"
      ],
 63 : [ [1,0, 1,1, 2,1, 2,2, 0,2, 0,1],                           # "?"
      ],
 64 : [ [2,-1, 0,-1, 0,2, 2,2, 2,0, 1,0, 1,1, 2,1],               # "@"
      ],
 65 : [ [0,0, 0,2, 2,2, 2,0],
        [0,1, 2,1],                                               # "A"
      ],
 66 : [ [0,0, 0,2, 1,2, 1,1, 2,1, 2,0, 0,0],
        [0,1, 1,1],                                               # "B"
      ],
 67 : [ [2,0, 0,0, 0,2, 2,2]                                      # "C"
      ],
 68 : [ [0,0, 0,2, 1,2, 2,1, 1,0, 0,0],                           # "D"
      ],
 69 : [ [2,0, 0,0, 0,2, 2,2],
        [0,1, 1,1],                                               # "E"
      ],
 70 : [ [0,0, 0,2, 2,2],
        [0,1, 1,1],                                               # "F"
      ],
 71 : [ [2,2, 0,2, 0,0, 2,0, 2,1, 1,1],                           # "G"
      ],
 72 : [ [0,0, 0,2],
        [2,0, 2,2],
        [0,1, 2,1],                                               # "H"
      ],
 73 : [ [1,0, 1,2],                                               # "I"
      ],
 74 : [ [2,2, 2,0, 0,0, 0,1],                                     # "J"
      ],
 75 : [ [0,0, 0,2],
        [2,2, 1,1, 2,0],
        [0,1, 1,1],                                               # "K"
      ],
 76 : [ [0,2, 0,0, 2,0],                                          # "L"
      ],
 77 : [ [0,0, 0,2, 1,1, 2,2, 2,0],                                # "M"
      ],
 78 : [ [0,0, 0,2, 2,0, 2,2],                                     # "N"
      ],
 79 : [ [0,0, 2,0, 2,2, 0,2, 0,0],                                # "O"
      ],
 80 : [ [0,0, 0,2, 2,2, 2,1, 0,1],                                # "P"
      ],
 81 : [ [0,0, 2,0, 2,2, 0,2, 0,0],
        [ 1,1, 2,0],                                              # "Q"
      ],
 82 : [ [0,0, 0,2, 2,2, 2,1, 0,1],
        [1,1, 2,0],                                               # "R"
      ],
 83 : [ [2,2, 0,2, 0,1, 2,1, 2,0, 0,0],                           # "S"
      ],
 84 : [ [0,2, 2,2],
        [1,0, 1,2],                                               # "T"
      ],
 85 : [ [0,2, 0,0, 2,0, 2,2],                                     # "U"
      ],
 86 : [ [0,2, 1,0, 2,2],                                          # "V"
      ],
 87 : [ [0,2, 0,0, 1,1, 2,0, 2,2],                                # "W"
      ],
 88 : [ [0,2, 2,0],
        [0,0, 2,2],                                               # "X"
      ],
 89 : [ [0,2, 1,1, 2,2],
        [1,0, 1,1],                                               # "Υ"
      ],
 90 : [ [0,2, 2,2, 0,0, 2,0],                                     # "Z"
      ],
 91 : [ [1,0, 0,0, 0,2, 1,2],                                     # "["
      ],
 92 : [ [0,2, 2,0],                                               # "\"
      ],
 93 : [ [1,2, 2,2, 2,0, 1,0],                                     # "]"
      ],
 94 : [ [0,1, 1,2, 2,1],                                          # "^"
      ],
 95 : [ [0,0, 2,0],                                               # "_"
      ],
 96 : [ [0,2, 1,1],                                               # "`"
      ],

#---------Small English

 97 : [ [2,0, 0,0, 0,1, 1,1, 1,0],
        [1,1, 1,2, 0,2],                                          # "a"
      ],
 98 : [ [0,2, 0,0, 1,0, 1,1, 0,1]                                 # "b"
      ],
 99 : [ [1,1, 0,1, 0,0, 1,0],                                     # "c"
      ],
100 : [ [1,2, 1,0, 0,0, 0,1, 1,1],                                # "d"
      ],
101 : [ [1,0, 0,0, 0,1, 1,2, 1,1, 0,1],                           # "e"
      ],
102 : [ [1,0, 1,1, 2,2, 2,1, 0,1],                                # "f"
      ],
103 : [ [1,0, 0,0, 0,1, 1,1, 1,-1, 0,-1],                         # "g"
      ],
104 : [ [0,2, 0,0],
        [0,1, 1,1, 1,0],                                          # "h"
      ],
105 : [ [1,0, 1,1],                                               # "i"
      ],
106 : [ [1,1, 1,-1, 0,-1, 0,0],                                   # "j"
      ],
107 : [ [0,0, 0,2],
        [1,0, 0,1, 1,1],                                          # "k"
      ],
108 : [ [0,1, 1,2, 1,0],                                          # "l"
      ],
109 : [ [0,0, 0,1, 2,1, 2,0],
        [1,0, 1,1],                                               # "m"
      ],
110 : [ [0,0, 0,1, 1,1, 1,0],                                     # "n"
      ],
111 : [ [0,0, 0,1, 1,1, 1,0, 0,0]                                 # "o"
      ],
112 : [ [0,0, 1,0, 1,1, 0,1, 0,-1],                               # "p"
      ],
113 : [ [1,0, 0,0, 0,1, 1,1, 1,-1],                               # "q"
      ],
114 : [ [0,0, 0,1, 1,1],                                          # "r"
      ],
115 : [ [1,1, 0,1, 1,0, 0,0],                                     # "s"
      ],
116 : [ [2,0, 1,0, 1,2],
        [0,1, 2,1],                                               # "t"
      ],
117 : [ [0,1, 0,0, 1,0, 1,1],                                     # "u"
      ],
118 : [ [0,1, 0,0, 1,1],                                          # "v"
      ],
119 : [ [0,1, 0,0, 2,0, 2,1],
        [1,1, 1,0],                                               # "w"
      ],
120 : [ [0,1, 1,0],
        [0,0, 1,1]                                                # "x"
      ],
121 : [ [0,1, 0,0, 1,0, 1,1],
        [1,0, 1,-1, 0,-1]                                         # "y"
      ],
122 : [ [0,1, 1,1, 0,0, 1,0],                                     # "z"
      ],
123 : [ [2,2, 1,2, 1,0, 2,0],
        [0,1, 1,1],                                               # "{"
      ],
124 : [ [1,0,1,2],                                                # "|"
      ],
125 : [ [0,2, 1,2, 1,0, 0,0],
        [1,1, 2,1],                                               # "}"
      ],
126 : [ [0,1, 0,2, 1,2, 1,1, 2,1, 2,2],                           # "~"
      ],
127 : [ [0,0, 2,0, 2,1, 0,1, 0,0],
        [1,0, 1,1],                                               # "infinity symbol"
      ],

128 : [ [2,-1, 1,0, 1,1, 2,2],
        [0,1, 2,1],
        [0,0, 2,0],                                               # "Euro symbol"
      ],

162 : 65,                                                         # "Ά"

183 : [ [0,2, 0,1],                                               # "·"
      ],
184 : 69,                                                         # "Έ"
185 : 72,                                                         # "Ή"
186 : [ [1,0, 1,2],
        [0,2, 0,1],                                               # "Ί"
      ],
187 : [ [0,2, 1,1, 0,0],
        [1,2, 2,1, 1,0],                                          # "»"
      ],
188 : 79,                                                         # "Ό"
189 : [ [0,2, 0,1],
        [1,2, 0,-1],
        [1,1, 2,1, 2,0, 1,0, 1,-1, 2,-1],                         # "½"
      ],
190 : 89,                                                         # "Ύ"
191 : 217,                                                        # "Ώ"
192 : 233,                                                        # "ΐ"

#-----Greek capital

193 : 65,                                                         # "Α"
194 : 66,                                                         # "Β"
195 : [ [0,0, 0,2, 2,2],                                          # "Γ"
      ],
196 : [ [0,0, 1,2, 2,0, 0,0],                                     # "Δ"
      ],
197 : 69,                                                         # "Ε"
198 : 90,                                                         # "Ζ"
199 : 72,                                                         # "Η"
200 : [ [0,1, 1,2, 2,1, 1,0, 0,1],
        [0,1, 2,1],                                               # "Θ"
      ],
201 : 73,                                                         # "Ι"
202 : 75,                                                         # "Κ"
203 : [ [0,0, 1,2, 2,0],                                          # "Λ"
      ],
204 : 77,                                                         # "Μ"
205 : 78,                                                         # "Ν"
206 : [ [0,0, 2,0],
        [0,2, 2,2],
        [0,1, 2,1],                                               # "Ξ"
      ],
207 : 79,                                                         # "Ο"
208 : [ [0,0, 0,2, 2,2, 2,0],                                     # "Π"
      ],
209 : 80,                                                         # "Ρ"
210 : 63,                                                         # Not defined
211 : [ [2,2, 0,2, 1,1, 0,0, 2,0],                                # "Σ"
      ],
212 : 84,                                                         # "Τ"
213 : 89,                                                         # "Υ"
214 : [ [0,1, 2,1, 2,2, 0,2, 0,1],
        [1,2, 1,0],                                               # "Φ"
      ],
215 : 88,                                                         # "Χ"
216 : [ [0,2, 0,1, 2,1, 2,2],
        [1,2, 1,0],                                               # "Ψ"
      ],
217 : [ [0,1, 2,1, 2,2, 0,2, 0,1],
        [1,1, 1,0],
        [0,0, 2,0],                                               # "Ω"
      ],

#----------Not defined

218 : 201,                                                        # "Ϊ"
219 : 89,                                                         # "Ϋ"
220 : 225,                                                        # "ά"
221 : 229,                                                        # "έ"
222 : 231,                                                        # "ή"
223 : 233,                                                        # "ί"
224 : 245,                                                        # "ΰ"

#----------Small Greek letters

225 : [ [2,0, 0,0, 0,1, 1,1, 1,0],                                # "α"
      ],
226 : [ [0,0, 1,0, 1,1, 0,1, 0,-1],
        [0,1, 0,2, 1,2, 0,1],                                     # "β"
      ],
227 : [ [0,1, 1,0, 1,-1, 0,-1, 0,0, 1,1],                         # "γ"
      ],
228 : [ [1,1, 0,1, 0,0, 1,0, 1,1, 0,2, 1,2],                      # "δ"
      ],
229 : [ [1,2, 0,1, 1,0],
        [0,1, 1,1],                                               # "ε"
      ],
230 : [ [0,2, 1,2, 0,1, 1,0, 0,-1],                               # "ζ"
      ],
231 : [ [0,0, 0,1, 1,1, 1,-1],                                    # "η"
      ],
232 : [ [0,0, 1,0, 1,2, 0,2, 0,0],
        [0,1, 1,1]                                                # "θ"
      ],
233 : [ [ 1,0, 1,1],                                              # "ι"
      ],
234 : 107,                                                        # "κ"
235 : [ [0,0, 1,1],
        [1,0, 1,2, 0,2],                                          # "λ"
      ],
236 : [ [0,1, 0,-1],
        [0,0, 1,0, 1,1],                                          # "μ"
      ],
237 : 118,                                                        # "ν"
238 : [ [0,2, 1,2, 0,1, 1,1, 0,0, 1,0, 1,-1],                     # "ξ"
      ],
239 : 111,                                                        # "ο"
240 : [ [0,0, 0,1, 1,1, 1,0],                                     # "π"
      ],
241 : 112,                                                        # "ρ"
242 : [ [1,1, 0,1, 0,0, 1,0, 1,-1, 0,-1],                         # "ς"
      ],
243 : [ [1,1, 1,0, 0,0, 0,1, 2,1],                                # "σ"
      ],
244 : [ [0,1, 2,1],
        [1,1, 1,0, 2,0],                                          # "τ"
      ],
245 : 117,                                                        # "υ"
246 : [ [0,1, 0,0, 2,0, 2,1, 1,1, 1,-1],                          # "φ"
      ],
247 : [ [0,1, 1,-1],
        [1,1, 0,-1],                                              # "χ"
      ],
248 : [ [0,1, 0,0, 2,0, 2,1],
        [1,1, 1,-1],                                              # "ψ"
      ],
249 : 119,                                                        # "ω"
250 : 233,                                                        # "ϊ"
251 : 245,                                                        # "ϋ"
252 : 239,                                                        # "ό"
253 : 245,                                                        # "ύ"
254 : 249,                                                        # "ώ"
255 : 239,                                                        # quadrilateral
}
    for lines in dilines.values():   #works for python2,3
        if type(lines) == int: continue
        for li in lines:
            for i in range(0, len(li), 2): li[i] *= 0.75
        lines.append([(2, 0)])
    return dilines



thanFonts["thanprime1"] = ThanFontLine("thanprime1", (0,0), (6,7), (0,-2), False, makePrime1Lines())
thanFonts["thanprime2"] = ThanFontLine("thanprime2", (0,0), (6,7), (0,-2), False, makePrime2Lines())
thanFonts["thanlcd1"]   = ThanFontLine("thanlcd1",   (0,0), (2,2), (0,-1), False, makeLcd1Lines())


if __name__ == "__main__":
    print(__doc__)
    thanFonts["thanprime1"].thanExportTxt(open("pr1.txf", "w"))
#    for k,dilines in thanFonts["thanlcd1"].thanDilines.items():  #works for python2,3
#        print k, ':', dilines
