//
// NTUA ECE ProgTech 2022-2023
//
// (very) basic AVL trees
//
// Δείτε τα Run configurations στο αρχείο CMakeLists.txt
// Προσοχή: σε κάθε αλλαγή που κάνετε στο CMakeLists.txt *πρέπει* να κάνετε "Reload changes" ή "Reload CMake project"
//
// Επιλέξτε: (menu)Run -> (option)Run... -> avl
//
#include <iostream>
using namespace std;

struct Node {   // AVL tree
    int key;
    Node *left, *right;
    int height;
};

int height(Node *N) {
    if (N == NULL) return 0;
    return N->height;
}

// Δημιουργεί έναν νέο κόμβο, χωρίς να τον τοποθετήσει στο δέντρο
Node* newNode(int newkey) {
    Node* newNode = new Node;
    newNode->key = newkey;
    newNode->left = newNode->right = NULL;
    newNode->height = 1;
    return(newNode);
}

// Δεξιά περιστροφή
Node *rightRotate(Node *y) {
    Node *x = y->left;
    Node *tmpNode = x->right;
    x->right = y; // περιστροφή: x είναι η νέα ρίζα
    y->left = tmpNode;
    // ενημέρωση υψών
    y->height = max(height(y->left), height(y->right)) + 1;
    x->height = max(height(x->left), height(x->right)) + 1;
    return x;
}

// αριστερή περιστροφή
Node *leftRotate(Node *x) {
    Node *y = x->right;
    Node *tmpNode = y->left;
    y->left = x;
    x->right = tmpNode;
    x->height = max(height(x->left), height(x->right)) + 1;
    y->height = max(height(y->left), height(y->right)) + 1;
    return y;
}

int getBalance(Node *N) {
    if (N == NULL) return 0;
    return height(N->left) - height(N->right);
}

// Εισαγωγή του key στο υποδέντρο currNode
Node* insert(Node* currNode, int key) {
    // 1. εισαγωγή στο BST χωρίς ζύγισμα
    if (currNode == NULL)
        return(newNode(key));
    if (key < currNode->key)
        currNode->left = insert(currNode->left, key);
    else if (key > currNode->key)
        currNode->right = insert(currNode->right, key);
    else
        return currNode;

    // 2. ενημέρωση υψών
    currNode->height = 1 + max(height(currNode->left), height(currNode->right));

    // 3. έλεγχος ισορροπίας
    int balance = getBalance(currNode);

    if (balance > 1 && key < currNode->left->key)  // Left Left
        return rightRotate(currNode);

    if (balance < -1 && key > currNode->right->key)  // Right Right
        return leftRotate(currNode);

    if (balance > 1 && key > currNode->left->key) {   // Left Right
        currNode->left = leftRotate(currNode->left);
        return rightRotate(currNode);
    }

    if (balance < -1 && key < currNode->right->key) { // Right Left
        currNode->right = rightRotate(currNode->right);
        return leftRotate(currNode);
    }
    return currNode;
}

Node * minValueNode(Node* subtree) {
    Node* current = subtree;
    while (current->left != NULL)
        current = current->left;
    return current;
}

// Διαγραφή του keyToDelete από το υ/δ root. Επιστρέφει τη νέα ρίζα.
Node* deleteNode(Node* root, int keyToDelete) {

    // 1: STANDARD BST DELETE
    if (root == NULL)
        return root;

    if (keyToDelete < root->key )
        root->left = deleteNode(root->left, keyToDelete);
    else if(keyToDelete > root->key )
        root->right = deleteNode(root->right, keyToDelete);
    else {
        // 1 ή 0 παιδιά
        if( (root->left == NULL) || (root->right == NULL) ) {
            Node *temp = root->left ?
                         root->left :
                         root->right;

            // κανένα παιδί
            if (temp == NULL) {
                temp = root;
                root = NULL;
            }
            else // 1 παιδί
                *root = *temp;
            free(temp);
        }
        else {
            // 2 παιδιά: Βρες τον διάδοχο (μικρότερη τιμή στο δεξί υ/δ)
            Node* temp = minValueNode(root->right);
            root->key = temp->key;
            // διαγραφή διαδόχου
            root->right = deleteNode(root->right,
                                     temp->key);
        }
    }

    // Μόνο 1 κόμβος: επιστροφή
    if (root == NULL)
        return root;

    // 2: ενημέρωση του ύψους
    root->height = 1 + max(height(root->left),
                           height(root->right));


    // 3: έλεγχος ισορροπίας
    int balance = getBalance(root);

    // Left Left
    if (balance > 1 && getBalance(root->left) >= 0)
        return rightRotate(root);

    // Left Right
    if (balance > 1 && getBalance(root->left) < 0) {
        root->left = leftRotate(root->left);
        return rightRotate(root);
    }

    // Right Right
    if (balance < -1 && getBalance(root->right) <= 0)
        return leftRotate(root);

    // Right Left
    if (balance < -1 && getBalance(root->right) > 0) {
        root->right = rightRotate(root->right);
        return leftRotate(root);
    }
    return root;
}


void preOrder(Node *root) {
    if (root != NULL) {
        cout << root->key << " ";
        preOrder(root->left);
        preOrder(root->right);
    }
}

int main() {
    Node *root = NULL;
    root = insert(root, 10);
    root = insert(root, 20);
    root = insert(root, 30);
    root = insert(root, 40);
    root = insert(root, 50);
    root = insert(root, 25);
    cout << "Preorder traversal of the new AVL tree:\n";
    preOrder(root);
    return 0;
}
