//
// NTUA ECE ProgTech 2022-2023
//
// Binary trees
//
// Δείτε τα Run configurations στο αρχείο CMakeLists.txt
// Προσοχή: σε κάθε αλλαγή που κάνετε στο CMakeLists.txt *πρέπει* να κάνετε "Reload changes" ή "Reload CMake project"
//
// Επιλέξτε: (menu)Run -> (option)Run... -> binary_Trees
//
#include <iostream>
#include <queue>
using namespace std;

struct Node {
    char data;
    struct Node *left, *right;
    Node(char newdata) {        // constructor σε struct!
        this->data = newdata;
        left = right = NULL;
    }
};

void printBForder(Node* root) {
    if (root == NULL) return;
    queue<Node *> q; // Create an empty queue
    q.push(root); // Enqueue Root
    while (q.empty() == false) {
        Node *node = q.front();
        cout << node->data << " "; // Print front of queue and remove it from queue
        q.pop();
        if (node->left != NULL)
            q.push(node->left);   /* Enqueue left child */
        if (node->right != NULL)
            q.push(node->right); /*Enqueue right child */
    }
}

void printPreorder(struct Node* node)
{
    if (node == NULL) return;
    cout << node->data << " "; // visit bst_node
    printPreorder(node->left);  // visit left subtree
    printPreorder(node->right); // visit right subtree
}

void printPostorder(struct Node* node) {
    if (node == NULL) return;
    printPostorder(node->left);  // visit left subtree
    printPostorder(node->right); // visit right subtree
    cout << node->data << " ";        // visit bst_node
}

void printInorder(struct Node* node) {
    if (node == NULL) return;
    printInorder(node->left);  // visit left subtree
    cout << node->data << " ";      // visit bst_node
    printInorder(node->right); // visit right subtree
}


int main() {
    struct Node* root = new Node('A');
    root->left = new Node('B');
    root->right = new Node('D');
    root->left->right = new Node('C');
    root->right->left = new Node('E');
    root->right->right = new Node('H');
    root->right->left->left = new Node('F');
    root->right->left->right = new Node('G');
    root->right->right->left = new Node('I');

    cout << "\nDepth-first preorder traversal of binary tree \n";
    printPreorder(root);
    cout << "\nDepth-first postorder traversal of binary tree \n";
    printPostorder(root);
    cout << "\nDepth-first inorder traversal of binary tree \n";
    printInorder(root);
    cout << "\nBreadth-first inorder traversal of binary tree \n";
    printBForder(root);
}

