//
// NTUA ECE ProgTech 2022-2023
//
// Binary trees
//
// Δείτε τα Run configurations στο αρχείο CMakeLists.txt
// Προσοχή: σε κάθε αλλαγή που κάνετε στο CMakeLists.txt *πρέπει* να κάνετε "Reload changes" ή "Reload CMake project"
//
// Επιλέξτε: (menu)Run -> (option)Run... -> BST
//

#include <iostream>
using namespace std;

template <typename K, typename V>
class BSTree {
public:
    BSTree(): root(nullptr) {}
    int height() const { return calcHeight(root); }
    void print() { printPreorder(root); cout << "\nh= " << height() << endl;}
    void insertNode(const K &k, const V &v) { root = doInsertNode(root, k, v); }
    void deleteNode(const K &k){ root = doDeleteNode(root, k); }
    V & search(const K &k) {
        bst_node *s = doSearch(root, k);
        if (s == nullptr) throw "Not found";
        return s->value;
    }
private:
    struct bst_node {
        K key;
        V value;
        bst_node *left, *right;
        bst_node(const K &k, const V &v):
                key(k), value(v), left(nullptr), right(nullptr) {}
    };

    bst_node *root;

    static int calcHeight(bst_node *r) {
        if (r == nullptr)
            return -1;
        return 1 + max(calcHeight(r->left), calcHeight(r->right));
    }

    static bst_node * doSearch(bst_node *r, const K &k) {
        if (r == nullptr)
            return nullptr;
        if (r->key == k)
            return r;
        if (k < r->key)
            return doSearch(r->left, k);
        else
            return doSearch(r->right, k);
    }

    static bst_node * doInsertNode(bst_node *r, const K &k, const V &v) {
        if (r == nullptr)
            return new bst_node(k, v);
        if (r->key == k)
            r->value = v;  // update if it exists
        else if (k < r->key)
            r->left = doInsertNode(r->left, k, v);
        else
            r->right = doInsertNode(r->right, k, v);
        return r;
    }

    static bst_node* minValueNode(bst_node* n) // ??????????
    {
        struct bst_node* current = n;
        while (current && current->left != NULL)
            current = current->left;
        return current;
    }

    static bst_node* doDeleteNode(bst_node* n, const K &key)   // ????????
    {
        if (n == NULL)
            return n;

        if (key < n->key)
            n->left = doDeleteNode(n->left, key);
        else if (key > n->key)
            n->right = doDeleteNode(n->right, key);
        else {              // this is the bst_node to delete
            if ((n->left == NULL) && (n->right == NULL))
                return NULL;
            else if (n->left == NULL) {
                bst_node* temp = n->right;
                free(n);
                return temp;
            }
            else if (n->right == NULL) {
                bst_node* temp = n->left;
                free(n);
                return temp;
            }
            bst_node* temp = minValueNode(n->right);

            // Copy the inorder successor's content to this bst_node
            n->key = temp->key;
            n->value = temp->value;
            // Delete the inorder successor
            n->right = doDeleteNode(n->right, temp->key);
        }
        return n;
    }

    static void printPreorder(const bst_node* n) {
        if (n == NULL) return;
        cout << n->value << " ";   // visit bst_node SOS: needs overloaded <<
        printPreorder(n->left);  // visit left subtree
        printPreorder(n->right); // visit right subtree
    }
};

int main() {
    BSTree<int, string> t;
    t.insertNode(5, "5five");
    t.insertNode(2, "2two");
    t.insertNode(3, "3three");
    t.insertNode(7, "7seven");
    t.insertNode(4, "4four");
    t.insertNode(10, "10ten");
    t.insertNode(9, "9nine");
    t.insertNode(11, "11eleven");

    t.print();cout<<endl;
    try {
        cout << "Searching 1... " << t.search(1) << " found!"<< endl;
    } catch (const char *exc) {
        cout << "\n  Exception searching 1: " << exc << endl;
    }
    try {
        cout << "Searching 9... " << t.search(9) << " found!"<<endl;
    } catch (const char *exc) {
        cout << "\n  Exception searching 9: " << exc << endl;
    }
    cout << "Deleting 3... ";
    t.deleteNode(3);
    t.print();cout<<endl;

    cout << "Deleting 5... ";
    t.deleteNode(5);
    t.print();cout<<endl;

    cout << "Deleting 7... ";
    t.deleteNode(7);
    t.print();cout<<endl;

    return 0;
}

